/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.converter;

import com.google.common.net.MediaType;
import com.google.common.primitives.Bytes;
import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.converter.RbelConverterPlugin;
import de.gematik.rbellogger.converter.RbelHttpRequestConverter;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelMultiMap;
import de.gematik.rbellogger.data.facet.RbelHttpHeaderFacet;
import de.gematik.rbellogger.data.facet.RbelHttpMessageFacet;
import de.gematik.rbellogger.data.facet.RbelHttpResponseFacet;
import de.gematik.rbellogger.data.facet.RbelNoteFacet;
import de.gematik.rbellogger.data.facet.RbelResponseFacet;
import de.gematik.rbellogger.util.RbelArrayUtils;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbelHttpResponseConverter
implements RbelConverterPlugin {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelHttpResponseConverter.class);

    @Override
    public boolean ignoreOversize() {
        return true;
    }

    @Override
    public void consumeElement(RbelElement targetElement, RbelConverter converter) {
        String content = targetElement.getRawStringContent();
        if (!content.startsWith("HTTP")) {
            return;
        }
        String eol = RbelHttpRequestConverter.findEolInHttpMessage(content);
        int endOfHeadIndex = Bytes.indexOf((byte[])targetElement.getRawContent(), (byte[])(eol + eol).getBytes());
        if (endOfHeadIndex == -1) {
            return;
        }
        RbelElement headerElement = this.extractHeaderFromMessage(targetElement, converter, eol);
        byte[] bodyData = this.extractBodyData(targetElement, endOfHeadIndex += 2 * eol.length(), headerElement.getFacetOrFail(RbelHttpHeaderFacet.class), eol);
        RbelElement bodyElement = new RbelElement(bodyData, targetElement, this.findCharsetInHeader(headerElement.getFacetOrFail(RbelHttpHeaderFacet.class)));
        RbelElement responseCode = this.extractResponseCodeFromMessage(targetElement, content);
        RbelHttpResponseFacet rbelHttpResponse = RbelHttpResponseFacet.builder().responseCode(responseCode).reasonPhrase(this.extractReasonPhraseFromMessage(targetElement, content)).build();
        targetElement.addFacet(rbelHttpResponse);
        targetElement.addFacet(new RbelResponseFacet(responseCode.getRawStringContent()));
        targetElement.addFacet(RbelHttpMessageFacet.builder().header(headerElement).body(bodyElement).build());
        converter.convertElement(bodyElement);
    }

    private RbelElement extractResponseCodeFromMessage(RbelElement targetElement, String content) {
        return RbelElement.builder().parentNode(targetElement).rawContent(content.split("\\s")[1].getBytes(StandardCharsets.UTF_8)).build();
    }

    private RbelElement extractReasonPhraseFromMessage(RbelElement targetElement, String content) {
        String[] responseStatusLineSplit = content.split("\\r\\n")[0].trim().split("\\s", 3);
        if (responseStatusLineSplit.length == 2) {
            return RbelElement.builder().parentNode(targetElement).build();
        }
        return RbelElement.builder().parentNode(targetElement).rawContent(responseStatusLineSplit[2].trim().getBytes(targetElement.getElementCharset())).build();
    }

    public RbelElement extractHeaderFromMessage(RbelElement rbel, RbelConverter converter, String eol) {
        String content = rbel.getRawStringContent();
        int endOfBodyPosition = content.indexOf(eol + eol);
        int endOfFirstLine = content.indexOf(eol) + eol.length();
        endOfBodyPosition = endOfBodyPosition < 0 ? content.length() : (endOfBodyPosition += 2 * eol.length());
        List<String> headerList = Arrays.stream(content.substring(endOfFirstLine, endOfBodyPosition).split(eol)).filter(line -> !line.isEmpty() && !line.startsWith("HTTP")).toList();
        RbelElement headerElement = new RbelElement(headerList.stream().collect(Collectors.joining(eol)).getBytes(rbel.getElementCharset()), rbel);
        RbelMultiMap headerMap = headerList.stream().map(line -> this.parseStringToKeyValuePair((String)line, converter, headerElement)).collect(RbelMultiMap.COLLECTOR);
        headerElement.addFacet(new RbelHttpHeaderFacet(headerMap));
        return headerElement;
    }

    Optional<Charset> findCharsetInHeader(RbelHttpHeaderFacet headerMap) {
        return headerMap.getCaseInsensitiveMatches("Content-Type").map(RbelElement::getRawStringContent).map(str -> this.strictParsingOfCharset((String)str).orElse(this.guessCharset((String)str))).findFirst();
    }

    private Charset guessCharset(String str) {
        String lowerCaseString = str.toLowerCase();
        return Stream.of(StandardCharsets.UTF_8, StandardCharsets.ISO_8859_1, StandardCharsets.US_ASCII, StandardCharsets.UTF_16).filter(charset -> charset.aliases().stream().map(String::toLowerCase).anyMatch(lowerCaseString::contains)).findFirst().orElse(StandardCharsets.UTF_8);
    }

    private Optional<Charset> strictParsingOfCharset(String s) {
        try {
            return Optional.ofNullable(s).map(MediaType::parse).map(MediaType::charset).filter(com.google.common.base.Optional::isPresent).map(com.google.common.base.Optional::get);
        }
        catch (RuntimeException e) {
            return Optional.empty();
        }
    }

    private byte[] extractBodyData(RbelElement rbel, int separator, RbelHttpHeaderFacet headerMap, String eol) {
        byte[] inputData = rbel.getRawContent();
        if (headerMap.hasValueMatching("Transfer-Encoding", "chunked")) {
            int chunkSeperator = rbel.getRawStringContent().indexOf(eol, separator) + eol.length();
            int indexOfChunkTerminator = RbelArrayUtils.indexOf(inputData, (eol + "0" + eol).getBytes(rbel.getElementCharset()), chunkSeperator);
            if (indexOfChunkTerminator >= 0) {
                return Arrays.copyOfRange(inputData, Math.min(inputData.length, chunkSeperator), indexOfChunkTerminator);
            }
            rbel.addFacet(RbelNoteFacet.builder().style(RbelNoteFacet.NoteStyling.WARN).value("Detected incorrect use of chunked encoding: Chunked was given as transfer-encoding, but the chunk-seperator could not be found in the content. Displaying the message as-is.").build());
        }
        return Arrays.copyOfRange(inputData, Math.min(inputData.length, separator), inputData.length);
    }

    protected AbstractMap.SimpleImmutableEntry<String, RbelElement> parseStringToKeyValuePair(String line, RbelConverter context, RbelElement headerElement) {
        int colon = line.indexOf(58);
        if (colon == -1) {
            throw new IllegalArgumentException("Header malformed: '" + line + "'");
        }
        String key = line.substring(0, colon).trim();
        RbelElement el = new RbelElement(line.substring(colon + 1).trim().getBytes(headerElement.getElementCharset()), headerElement);
        return new AbstractMap.SimpleImmutableEntry<String, RbelElement>(key, context.convertElement(el));
    }
}

