/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.converter;

import de.gematik.rbellogger.converter.RbelBase64JsonConverter;
import de.gematik.rbellogger.converter.RbelBearerTokenConverter;
import de.gematik.rbellogger.converter.RbelCborConverter;
import de.gematik.rbellogger.converter.RbelCetpConverter;
import de.gematik.rbellogger.converter.RbelConverterPlugin;
import de.gematik.rbellogger.converter.RbelHttpFormDataConverter;
import de.gematik.rbellogger.converter.RbelHttpRequestConverter;
import de.gematik.rbellogger.converter.RbelHttpResponseConverter;
import de.gematik.rbellogger.converter.RbelJsonConverter;
import de.gematik.rbellogger.converter.RbelJweConverter;
import de.gematik.rbellogger.converter.RbelJwtConverter;
import de.gematik.rbellogger.converter.RbelMtomConverter;
import de.gematik.rbellogger.converter.RbelSicctCommandConverter;
import de.gematik.rbellogger.converter.RbelSicctEnvelopeConverter;
import de.gematik.rbellogger.converter.RbelUriConverter;
import de.gematik.rbellogger.converter.RbelValueShader;
import de.gematik.rbellogger.converter.RbelVauEpaKeyDeriver;
import de.gematik.rbellogger.converter.RbelX500Converter;
import de.gematik.rbellogger.converter.RbelX509Converter;
import de.gematik.rbellogger.converter.RbelXmlConverter;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelHostname;
import de.gematik.rbellogger.data.RbelMultiMap;
import de.gematik.rbellogger.data.facet.RbelHostnameFacet;
import de.gematik.rbellogger.data.facet.RbelHttpRequestFacet;
import de.gematik.rbellogger.data.facet.RbelHttpResponseFacet;
import de.gematik.rbellogger.data.facet.RbelMessageTimingFacet;
import de.gematik.rbellogger.data.facet.RbelNoteFacet;
import de.gematik.rbellogger.data.facet.RbelParsingNotCompleteFacet;
import de.gematik.rbellogger.data.facet.RbelTcpIpMessageFacet;
import de.gematik.rbellogger.exceptions.RbelConversionException;
import de.gematik.rbellogger.key.RbelKeyManager;
import de.gematik.rbellogger.util.RbelMessagesDequeFacade;
import java.beans.ConstructorProperties;
import java.nio.charset.StandardCharsets;
import java.security.Provider;
import java.security.Security;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutionException;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.pqc.jcajce.provider.BouncyCastlePQCProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbelConverter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelConverter.class);
    private final Deque<RbelElement> messageHistory = new ConcurrentLinkedDeque<RbelElement>();
    private final Set<String> knownMessageUuids = ConcurrentHashMap.newKeySet();
    private final RbelMultiMap<CompletableFuture<RbelElement>> messagesWaitingForCompletion = new RbelMultiMap();
    private final RbelKeyManager rbelKeyManager;
    private final RbelValueShader rbelValueShader = new RbelValueShader();
    private final List<RbelConverterPlugin> postConversionListeners = new ArrayList<RbelConverterPlugin>();
    private final List<RbelConverterPlugin> converterPlugins = new ArrayList<RbelConverterPlugin>(List.of(new RbelBase64JsonConverter(), new RbelUriConverter(), new RbelHttpResponseConverter(), new RbelHttpRequestConverter(), new RbelJwtConverter(), new RbelHttpFormDataConverter(), new RbelJweConverter(), new RbelBearerTokenConverter(), new RbelXmlConverter(), new RbelJsonConverter(), new RbelVauEpaKeyDeriver(), new RbelMtomConverter(), new RbelX509Converter(), new RbelX500Converter(), new RbelSicctEnvelopeConverter(), new RbelSicctCommandConverter(), new RbelCetpConverter(), new RbelCborConverter()));
    private int rbelBufferSizeInMb;
    private boolean manageBuffer;
    private long currentBufferSize;
    private long messageSequenceNumber;
    private int skipParsingWhenMessageLargerThanKb;

    public RbelElement convertElement(byte[] input, RbelElement parentNode) {
        return this.convertElement(RbelElement.builder().parentNode(parentNode).rawContent(input).build());
    }

    public RbelElement convertElement(String input, RbelElement parentNode) {
        return this.convertElement(RbelElement.builder().parentNode(parentNode).rawContent(input.getBytes(Optional.ofNullable(parentNode).map(RbelElement::getElementCharset).orElse(StandardCharsets.UTF_8))).build());
    }

    public RbelElement convertElement(RbelElement convertedInput) {
        log.trace("Converting {}...", (Object)convertedInput);
        boolean elementIsOversized = this.skipParsingWhenMessageLargerThanKb > -1 && convertedInput.getRawContent().length > this.skipParsingWhenMessageLargerThanKb * 1024;
        for (RbelConverterPlugin plugin : this.converterPlugins) {
            if (!plugin.ignoreOversize() && elementIsOversized) continue;
            try {
                plugin.consumeElement(convertedInput, this);
            }
            catch (RuntimeException e) {
                String msg = "Exception during conversion with plugin '" + plugin.getClass().getName() + "' (" + e.getMessage() + ")\n" + ExceptionUtils.getStackTrace((Throwable)e);
                log.info(msg, (Throwable)e);
                if (log.isDebugEnabled()) {
                    log.debug("Content in failed conversion-attempt was (B64-encoded) {}", (Object)Base64.getEncoder().encodeToString(convertedInput.getRawContent()));
                    if (convertedInput.getParentNode() != null) {
                        log.debug("Parent-Content in failed conversion-attempt was (B64-encoded) {}", (Object)Base64.getEncoder().encodeToString(convertedInput.getParentNode().getRawContent()));
                    }
                }
                convertedInput.addFacet(new RbelNoteFacet(msg, RbelNoteFacet.NoteStyling.ERROR));
            }
        }
        return convertedInput;
    }

    private Optional<RbelElement> findLastRequest() {
        Iterator<RbelElement> iterator = this.messageHistory.descendingIterator();
        while (iterator.hasNext()) {
            RbelElement element = iterator.next();
            if (!element.hasFacet(RbelHttpRequestFacet.class)) continue;
            return Optional.of(element);
        }
        return Optional.empty();
    }

    public void registerListener(RbelConverterPlugin listener) {
        this.postConversionListeners.add(listener);
    }

    public void triggerPostConversionListenerFor(RbelElement element) {
        for (RbelConverterPlugin postConversionListener : this.postConversionListeners) {
            postConversionListener.consumeElement(element, this);
        }
    }

    public void addConverter(RbelConverterPlugin converter) {
        this.converterPlugins.add(converter);
    }

    public RbelElement parseMessage(byte[] content, RbelHostname sender, RbelHostname receiver, Optional<ZonedDateTime> transmissionTime) {
        RbelElement messageElement = RbelElement.builder().rawContent(content).build();
        return this.parseMessage(messageElement, sender, receiver, transmissionTime);
    }

    public RbelElement parseMessage(@NonNull RbelElement messageElement, RbelHostname sender, RbelHostname receiver, Optional<ZonedDateTime> transmissionTime) {
        if (messageElement == null) {
            throw new NullPointerException("messageElement is marked non-null but is null");
        }
        try {
            return this.parseMessageAsync(messageElement, sender, receiver, transmissionTime).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RbelConversionException(e);
        }
        catch (ExecutionException e) {
            throw new RbelConversionException(e);
        }
    }

    public CompletableFuture<RbelElement> parseMessageAsync(@NonNull RbelElement messageElement, RbelHostname sender, RbelHostname receiver, Optional<ZonedDateTime> transmissionTime) {
        if (messageElement == null) {
            throw new NullPointerException("messageElement is marked non-null but is null");
        }
        this.addMessageToHistory(messageElement);
        messageElement.addFacet(RbelTcpIpMessageFacet.builder().receiver(RbelHostnameFacet.buildRbelHostnameFacet(messageElement, receiver)).sender(RbelHostnameFacet.buildRbelHostnameFacet(messageElement, sender)).sequenceNumber(this.messageSequenceNumber++).build());
        messageElement.addFacet(new RbelParsingNotCompleteFacet(this));
        return CompletableFuture.supplyAsync(() -> {
            try {
                this.convertElement(messageElement);
                this.doMessagePostConversion(messageElement, transmissionTime);
                RbelElement rbelElement = messageElement;
                return rbelElement;
            }
            finally {
                messageElement.removeFacetsOfType(RbelParsingNotCompleteFacet.class);
            }
        });
    }

    public RbelElement doMessagePostConversion(@NonNull RbelElement rbelElement, Optional<ZonedDateTime> transmissionTime) {
        if (rbelElement == null) {
            throw new NullPointerException("rbelElement is marked non-null but is null");
        }
        if (rbelElement.getFacet(RbelHttpResponseFacet.class).map(resp -> resp.getRequest() == null).orElse(false).booleanValue()) {
            Optional<RbelElement> request = this.findLastRequest();
            rbelElement.addOrReplaceFacet(rbelElement.getFacet(RbelHttpResponseFacet.class).map(RbelHttpResponseFacet::toBuilder).orElse(RbelHttpResponseFacet.builder()).request(request.orElse(null)).build());
            request.flatMap(req -> req.getFacet(RbelHttpRequestFacet.class)).ifPresent(reqFacet -> ((RbelElement)request.get()).addOrReplaceFacet(reqFacet.toBuilder().response(rbelElement).build()));
        }
        transmissionTime.ifPresent(tt -> rbelElement.addFacet(RbelMessageTimingFacet.builder().transmissionTime((ZonedDateTime)tt).build()));
        rbelElement.triggerPostConversionListener(this);
        return rbelElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMessageToHistory(RbelElement rbelElement) {
        Deque<RbelElement> deque = this.messageHistory;
        synchronized (deque) {
            this.currentBufferSize += rbelElement.getSize();
            this.knownMessageUuids.add(rbelElement.getUuid());
            this.messageHistory.add(rbelElement);
        }
        this.manageRbelBufferSize();
    }

    public RbelConverter addPostConversionListener(RbelConverterPlugin postConversionListener) {
        this.postConversionListeners.add(postConversionListener);
        return this;
    }

    public void removeAllConverterPlugins() {
        this.converterPlugins.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void manageRbelBufferSize() {
        if (this.manageBuffer) {
            Deque<RbelElement> deque = this.messageHistory;
            synchronized (deque) {
                if (this.rbelBufferSizeInMb <= 0 && !this.messageHistory.isEmpty()) {
                    this.currentBufferSize = 0L;
                    this.messageHistory.clear();
                    this.knownMessageUuids.clear();
                }
                if (this.rbelBufferSizeInMb > 0) {
                    long exceedingLimit = this.getExceedingLimit(this.currentBufferSize);
                    if (exceedingLimit > 0L) {
                        log.trace("Buffer is currently at {} Mb which exceeds the limit of {} Mb", (Object)(this.currentBufferSize / 1026L), (Object)this.rbelBufferSizeInMb);
                    }
                    while (exceedingLimit > 0L && !this.messageHistory.isEmpty()) {
                        log.trace("Exceeded buffer size, dropping oldest message in history");
                        RbelElement messageToDrop = this.messageHistory.getFirst();
                        exceedingLimit -= messageToDrop.getSize();
                        this.currentBufferSize -= messageToDrop.getSize();
                        this.knownMessageUuids.remove(messageToDrop.getUuid());
                        this.messageHistory.removeLast();
                    }
                }
            }
        }
    }

    private long getExceedingLimit(long messageHistorySize) {
        return messageHistorySize - (long)this.rbelBufferSizeInMb * 1024L * 1024L;
    }

    public boolean isMessageUuidAlreadyKnown(String msgUuid) {
        return this.knownMessageUuids.contains(msgUuid);
    }

    public Stream<RbelElement> messagesStreamLatestFirst() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.messageHistory.descendingIterator(), 16), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RbelElement> getMessageList() {
        Deque<RbelElement> deque = this.messageHistory;
        synchronized (deque) {
            return this.messageHistory.stream().takeWhile(msg -> !msg.hasFacet(RbelParsingNotCompleteFacet.class)).toList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RbelMessagesDequeFacade getMessageHistoryAsync() {
        Deque<RbelElement> deque = this.messageHistory;
        synchronized (deque) {
            return new RbelMessagesDequeFacade(this.messageHistory, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllMessages() {
        Deque<RbelElement> deque = this.messageHistory;
        synchronized (deque) {
            this.currentBufferSize = 0L;
            this.messageHistory.clear();
            this.knownMessageUuids.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessage(RbelElement rbelMessage) {
        Deque<RbelElement> deque = this.messageHistory;
        synchronized (deque) {
            Iterator<RbelElement> iterator = this.messageHistory.descendingIterator();
            while (iterator.hasNext()) {
                if (!iterator.next().equals(rbelMessage)) continue;
                iterator.remove();
                this.currentBufferSize -= rbelMessage.getSize();
                this.knownMessageUuids.remove(rbelMessage.getUuid());
            }
        }
    }

    public void waitForGivenElementToBeParsed(RbelElement result) {
        this.waitForGivenMessagesToBeParsed(List.of(result));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForAllElementsBeforeGivenToBeParsed(RbelElement element) {
        ArrayList<RbelElement> unfinishedMessages = new ArrayList<RbelElement>();
        Deque<RbelElement> deque = this.messageHistory;
        synchronized (deque) {
            for (RbelElement msg : this.messageHistory) {
                if (msg == element || msg.getUuid().equals(element.getUuid())) break;
                if (!msg.hasFacet(RbelParsingNotCompleteFacet.class)) continue;
                unfinishedMessages.add(msg);
            }
        }
        this.waitForGivenMessagesToBeParsed(unfinishedMessages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForGivenMessagesToBeParsed(List<RbelElement> unfinishedMessages) {
        List<Pair> callbacks;
        RbelMultiMap<CompletableFuture<RbelElement>> rbelMultiMap = this.messagesWaitingForCompletion;
        synchronized (rbelMultiMap) {
            callbacks = unfinishedMessages.stream().filter(msg -> msg.hasFacet(RbelParsingNotCompleteFacet.class)).map(msg -> {
                CompletableFuture future = new CompletableFuture();
                this.messagesWaitingForCompletion.put(msg.getUuid(), future);
                return Pair.of(future, (Object)msg);
            }).toList();
        }
        for (Pair future : callbacks) {
            try {
                ((CompletableFuture)future.getKey()).get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RbelConversionException(e);
            }
            catch (ExecutionException e) {
                throw new RbelConversionException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalMessageParsingIsComplete(RbelElement element) {
        List<CompletableFuture<RbelElement>> completableFutures;
        RbelMultiMap<CompletableFuture<RbelElement>> rbelMultiMap = this.messagesWaitingForCompletion;
        synchronized (rbelMultiMap) {
            completableFutures = this.messagesWaitingForCompletion.removeAll(element.getUuid());
        }
        completableFutures.forEach(future -> future.complete(element));
    }

    @Generated
    private static int $default$rbelBufferSizeInMb() {
        return 1024;
    }

    @Generated
    private static boolean $default$manageBuffer() {
        return false;
    }

    @Generated
    private static long $default$currentBufferSize() {
        return 0L;
    }

    @Generated
    private static long $default$messageSequenceNumber() {
        return 0L;
    }

    @Generated
    private static int $default$skipParsingWhenMessageLargerThanKb() {
        return -1;
    }

    @Generated
    public static RbelConverterBuilder builder() {
        return new RbelConverterBuilder();
    }

    @ConstructorProperties(value={"rbelKeyManager", "rbelBufferSizeInMb", "manageBuffer", "currentBufferSize", "messageSequenceNumber", "skipParsingWhenMessageLargerThanKb"})
    @Generated
    private RbelConverter(RbelKeyManager rbelKeyManager, int rbelBufferSizeInMb, boolean manageBuffer, long currentBufferSize, long messageSequenceNumber, int skipParsingWhenMessageLargerThanKb) {
        this.rbelKeyManager = rbelKeyManager;
        this.rbelBufferSizeInMb = rbelBufferSizeInMb;
        this.manageBuffer = manageBuffer;
        this.currentBufferSize = currentBufferSize;
        this.messageSequenceNumber = messageSequenceNumber;
        this.skipParsingWhenMessageLargerThanKb = skipParsingWhenMessageLargerThanKb;
    }

    @Generated
    public RbelKeyManager getRbelKeyManager() {
        return this.rbelKeyManager;
    }

    @Generated
    public RbelValueShader getRbelValueShader() {
        return this.rbelValueShader;
    }

    @Generated
    public List<RbelConverterPlugin> getPostConversionListeners() {
        return this.postConversionListeners;
    }

    @Generated
    public long getCurrentBufferSize() {
        return this.currentBufferSize;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        Security.addProvider((Provider)new BouncyCastlePQCProvider());
    }

    @Generated
    public static class RbelConverterBuilder {
        @Generated
        private RbelKeyManager rbelKeyManager;
        @Generated
        private boolean rbelBufferSizeInMb$set;
        @Generated
        private int rbelBufferSizeInMb$value;
        @Generated
        private boolean manageBuffer$set;
        @Generated
        private boolean manageBuffer$value;
        @Generated
        private boolean currentBufferSize$set;
        @Generated
        private long currentBufferSize$value;
        @Generated
        private boolean messageSequenceNumber$set;
        @Generated
        private long messageSequenceNumber$value;
        @Generated
        private boolean skipParsingWhenMessageLargerThanKb$set;
        @Generated
        private int skipParsingWhenMessageLargerThanKb$value;

        @Generated
        RbelConverterBuilder() {
        }

        @Generated
        public RbelConverterBuilder rbelKeyManager(RbelKeyManager rbelKeyManager) {
            this.rbelKeyManager = rbelKeyManager;
            return this;
        }

        @Generated
        public RbelConverterBuilder rbelBufferSizeInMb(int rbelBufferSizeInMb) {
            this.rbelBufferSizeInMb$value = rbelBufferSizeInMb;
            this.rbelBufferSizeInMb$set = true;
            return this;
        }

        @Generated
        public RbelConverterBuilder manageBuffer(boolean manageBuffer) {
            this.manageBuffer$value = manageBuffer;
            this.manageBuffer$set = true;
            return this;
        }

        @Generated
        public RbelConverterBuilder currentBufferSize(long currentBufferSize) {
            this.currentBufferSize$value = currentBufferSize;
            this.currentBufferSize$set = true;
            return this;
        }

        @Generated
        public RbelConverterBuilder messageSequenceNumber(long messageSequenceNumber) {
            this.messageSequenceNumber$value = messageSequenceNumber;
            this.messageSequenceNumber$set = true;
            return this;
        }

        @Generated
        public RbelConverterBuilder skipParsingWhenMessageLargerThanKb(int skipParsingWhenMessageLargerThanKb) {
            this.skipParsingWhenMessageLargerThanKb$value = skipParsingWhenMessageLargerThanKb;
            this.skipParsingWhenMessageLargerThanKb$set = true;
            return this;
        }

        @Generated
        public RbelConverter build() {
            int rbelBufferSizeInMb$value = this.rbelBufferSizeInMb$value;
            if (!this.rbelBufferSizeInMb$set) {
                rbelBufferSizeInMb$value = RbelConverter.$default$rbelBufferSizeInMb();
            }
            boolean manageBuffer$value = this.manageBuffer$value;
            if (!this.manageBuffer$set) {
                manageBuffer$value = RbelConverter.$default$manageBuffer();
            }
            long currentBufferSize$value = this.currentBufferSize$value;
            if (!this.currentBufferSize$set) {
                currentBufferSize$value = RbelConverter.$default$currentBufferSize();
            }
            long messageSequenceNumber$value = this.messageSequenceNumber$value;
            if (!this.messageSequenceNumber$set) {
                messageSequenceNumber$value = RbelConverter.$default$messageSequenceNumber();
            }
            int skipParsingWhenMessageLargerThanKb$value = this.skipParsingWhenMessageLargerThanKb$value;
            if (!this.skipParsingWhenMessageLargerThanKb$set) {
                skipParsingWhenMessageLargerThanKb$value = RbelConverter.$default$skipParsingWhenMessageLargerThanKb();
            }
            return new RbelConverter(this.rbelKeyManager, rbelBufferSizeInMb$value, manageBuffer$value, currentBufferSize$value, messageSequenceNumber$value, skipParsingWhenMessageLargerThanKb$value);
        }

        @Generated
        public String toString() {
            return "RbelConverter.RbelConverterBuilder(rbelKeyManager=" + this.rbelKeyManager + ", rbelBufferSizeInMb$value=" + this.rbelBufferSizeInMb$value + ", manageBuffer$value=" + this.manageBuffer$value + ", currentBufferSize$value=" + this.currentBufferSize$value + ", messageSequenceNumber$value=" + this.messageSequenceNumber$value + ", skipParsingWhenMessageLargerThanKb$value=" + this.skipParsingWhenMessageLargerThanKb$value + ")";
        }
    }
}

