/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.converter.RbelConverterPlugin;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelMultiMap;
import de.gematik.rbellogger.data.facet.RbelFacet;
import de.gematik.rbellogger.data.facet.RbelListFacet;
import de.gematik.rbellogger.data.facet.RbelMapFacet;
import de.gematik.rbellogger.data.facet.RbelNestedFacet;
import de.gematik.rbellogger.data.facet.RbelRootFacet;
import de.gematik.rbellogger.data.facet.RbelValueFacet;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;

public abstract class AbstractJacksonConverter<F extends RbelFacet>
implements RbelConverterPlugin {
    private final ObjectMapper mapper;
    private final Class<F> facetClass;

    private Optional<JsonNode> convertToJacksonNode(RbelElement target) {
        if (!this.shouldElementBeConsidered(target)) {
            return Optional.empty();
        }
        try {
            return Optional.of(this.convertContentUsingJackson(target));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    JsonNode convertContentUsingJackson(RbelElement target) throws IOException {
        return this.mapper.readTree(target.getRawContent());
    }

    boolean shouldElementBeConsidered(RbelElement target) {
        return true;
    }

    @Override
    public void consumeElement(RbelElement rbelElement, RbelConverter converter) {
        Optional<JsonNode> jsonOptional = this.convertToJacksonNode(rbelElement);
        if (jsonOptional.isEmpty()) {
            return;
        }
        if (jsonOptional.get().isContainerNode()) {
            this.augmentRbelElementWithFacet(jsonOptional.get(), converter, rbelElement);
            rbelElement.addFacet(new RbelRootFacet<F>(rbelElement.getFacetOrFail(this.facetClass)));
        }
    }

    private void augmentRbelElementWithFacet(JsonNode node, RbelConverter context, RbelElement parentElement) {
        parentElement.addFacet((RbelFacet)this.buildFacetForNode(node));
        if (node.isObject()) {
            this.convertObject(node, context, parentElement);
        } else if (node.isArray()) {
            this.convertArray(node, context, parentElement);
        } else if (node.isValueNode()) {
            this.convertPrimitive(node, context, parentElement);
        } else {
            parentElement.addFacet(RbelValueFacet.builder().value(null).build());
        }
    }

    abstract F buildFacetForNode(JsonNode var1);

    private void convertPrimitive(JsonNode node, RbelConverter context, RbelElement parentElement) throws IOException {
        if (node.isTextual()) {
            this.addFacetAndConvertNestedElement(parentElement, node.asText(), context);
        } else if (node.isFloatingPointNumber()) {
            this.addFacetAndConvertNestedElement(parentElement, node.doubleValue(), context);
        } else if (node.isNumber()) {
            this.addFacetAndConvertNestedElement(parentElement, node.longValue(), context);
        } else if (node.isBoolean()) {
            this.addFacetAndConvertNestedElement(parentElement, node.booleanValue(), context);
        } else if (node.isBinary()) {
            RbelElement nestedElement = new RbelElement(node.binaryValue(), parentElement);
            context.convertElement(nestedElement);
            parentElement.addFacet(new RbelNestedFacet(nestedElement));
        }
    }

    private void convertArray(JsonNode node, RbelConverter context, RbelElement parentElement) {
        ArrayList<RbelElement> elementList = new ArrayList<RbelElement>();
        parentElement.addFacet(RbelListFacet.builder().childNodes(elementList).build());
        Iterator it = node.elements();
        while (it.hasNext()) {
            JsonNode el = (JsonNode)it.next();
            RbelElement newChild = new RbelElement(el.toString().getBytes(parentElement.getElementCharset()), parentElement);
            this.augmentRbelElementWithFacet(el, context, newChild);
            elementList.add(newChild);
        }
    }

    private void convertObject(JsonNode node, RbelConverter context, RbelElement parentElement) {
        RbelMultiMap<RbelElement> elementMap = new RbelMultiMap<RbelElement>();
        parentElement.addFacet(RbelMapFacet.builder().childNodes(elementMap).build());
        Iterator it = node.fields();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            RbelElement newChild = new RbelElement(((JsonNode)entry.getValue()).toString().getBytes(parentElement.getElementCharset()), parentElement);
            this.augmentRbelElementWithFacet((JsonNode)entry.getValue(), context, newChild);
            elementMap.put((String)entry.getKey(), newChild);
        }
    }

    private void addFacetAndConvertNestedElement(RbelElement parentElement, Object value, RbelConverter context) {
        RbelElement nestedElement = RbelElement.wrap(parentElement, value);
        context.convertElement(nestedElement);
        parentElement.addFacet(new RbelNestedFacet(nestedElement));
    }

    @ConstructorProperties(value={"mapper", "facetClass"})
    @Generated
    public AbstractJacksonConverter(ObjectMapper mapper, Class<F> facetClass) {
        this.mapper = mapper;
        this.facetClass = facetClass;
    }

    @Generated
    ObjectMapper getMapper() {
        return this.mapper;
    }
}

