/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.configuration;

import de.gematik.rbellogger.RbelLogger;
import de.gematik.rbellogger.captures.RbelCapturer;
import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.converter.RbelConverterPlugin;
import de.gematik.rbellogger.key.RbelKey;
import java.beans.ConstructorProperties;
import java.security.Key;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import lombok.Generated;

public class RbelConfiguration {
    private List<RbelConverterPlugin> postConversionListener;
    private List<RbelConverterPlugin> additionalConverters;
    private List<Consumer<RbelConverter>> initializers;
    private Map<String, RbelKey> keys;
    private RbelCapturer capturer;
    private boolean activateAsn1Parsing;
    private boolean activateVauEpa3Parsing;
    private int rbelBufferSizeInMb;
    private int skipParsingWhenMessageLargerThanKb;
    private boolean manageBuffer;

    public RbelConfiguration addPostConversionListener(RbelConverterPlugin listener) {
        this.postConversionListener.add(listener);
        return this;
    }

    public RbelConfiguration addInitializer(Consumer<RbelConverter> initializer) {
        this.initializers.add(initializer);
        return this;
    }

    public RbelConfiguration addKey(String keyId, Key key, int precedence) {
        this.keys.put(keyId, RbelKey.builder().key(key).keyName(keyId).precedence(precedence).build());
        return this;
    }

    public RbelConfiguration addCapturer(RbelCapturer capturer) {
        this.capturer = capturer;
        return this;
    }

    public RbelConfiguration setActivateAsn1Parsing(boolean activateAsn1Parsing) {
        this.activateAsn1Parsing = activateAsn1Parsing;
        return this;
    }

    public RbelConfiguration addAdditionalConverter(RbelConverterPlugin converter) {
        this.additionalConverters.add(converter);
        return this;
    }

    public RbelLogger constructRbelLogger() {
        return RbelLogger.build(this);
    }

    @Generated
    private static List<RbelConverterPlugin> $default$postConversionListener() {
        return new ArrayList<RbelConverterPlugin>();
    }

    @Generated
    private static List<RbelConverterPlugin> $default$additionalConverters() {
        return new ArrayList<RbelConverterPlugin>();
    }

    @Generated
    private static List<Consumer<RbelConverter>> $default$initializers() {
        return new ArrayList<Consumer<RbelConverter>>();
    }

    @Generated
    private static Map<String, RbelKey> $default$keys() {
        return new HashMap<String, RbelKey>();
    }

    @Generated
    private static boolean $default$activateAsn1Parsing() {
        return true;
    }

    @Generated
    private static boolean $default$activateVauEpa3Parsing() {
        return false;
    }

    @Generated
    private static int $default$rbelBufferSizeInMb() {
        return 1024;
    }

    @Generated
    private static int $default$skipParsingWhenMessageLargerThanKb() {
        return 16000;
    }

    @Generated
    private static boolean $default$manageBuffer() {
        return false;
    }

    @Generated
    public static RbelConfigurationBuilder builder() {
        return new RbelConfigurationBuilder();
    }

    @Generated
    public List<RbelConverterPlugin> getPostConversionListener() {
        return this.postConversionListener;
    }

    @Generated
    public List<RbelConverterPlugin> getAdditionalConverters() {
        return this.additionalConverters;
    }

    @Generated
    public List<Consumer<RbelConverter>> getInitializers() {
        return this.initializers;
    }

    @Generated
    public Map<String, RbelKey> getKeys() {
        return this.keys;
    }

    @Generated
    public RbelCapturer getCapturer() {
        return this.capturer;
    }

    @Generated
    public boolean isActivateAsn1Parsing() {
        return this.activateAsn1Parsing;
    }

    @Generated
    public boolean isActivateVauEpa3Parsing() {
        return this.activateVauEpa3Parsing;
    }

    @Generated
    public int getRbelBufferSizeInMb() {
        return this.rbelBufferSizeInMb;
    }

    @Generated
    public int getSkipParsingWhenMessageLargerThanKb() {
        return this.skipParsingWhenMessageLargerThanKb;
    }

    @Generated
    public boolean isManageBuffer() {
        return this.manageBuffer;
    }

    @Generated
    public RbelConfiguration setPostConversionListener(List<RbelConverterPlugin> postConversionListener) {
        this.postConversionListener = postConversionListener;
        return this;
    }

    @Generated
    public RbelConfiguration setAdditionalConverters(List<RbelConverterPlugin> additionalConverters) {
        this.additionalConverters = additionalConverters;
        return this;
    }

    @Generated
    public RbelConfiguration setInitializers(List<Consumer<RbelConverter>> initializers) {
        this.initializers = initializers;
        return this;
    }

    @Generated
    public RbelConfiguration setKeys(Map<String, RbelKey> keys) {
        this.keys = keys;
        return this;
    }

    @Generated
    public RbelConfiguration setCapturer(RbelCapturer capturer) {
        this.capturer = capturer;
        return this;
    }

    @Generated
    public RbelConfiguration setActivateVauEpa3Parsing(boolean activateVauEpa3Parsing) {
        this.activateVauEpa3Parsing = activateVauEpa3Parsing;
        return this;
    }

    @Generated
    public RbelConfiguration setRbelBufferSizeInMb(int rbelBufferSizeInMb) {
        this.rbelBufferSizeInMb = rbelBufferSizeInMb;
        return this;
    }

    @Generated
    public RbelConfiguration setSkipParsingWhenMessageLargerThanKb(int skipParsingWhenMessageLargerThanKb) {
        this.skipParsingWhenMessageLargerThanKb = skipParsingWhenMessageLargerThanKb;
        return this;
    }

    @Generated
    public RbelConfiguration setManageBuffer(boolean manageBuffer) {
        this.manageBuffer = manageBuffer;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RbelConfiguration)) {
            return false;
        }
        RbelConfiguration other = (RbelConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isActivateAsn1Parsing() != other.isActivateAsn1Parsing()) {
            return false;
        }
        if (this.isActivateVauEpa3Parsing() != other.isActivateVauEpa3Parsing()) {
            return false;
        }
        if (this.getRbelBufferSizeInMb() != other.getRbelBufferSizeInMb()) {
            return false;
        }
        if (this.getSkipParsingWhenMessageLargerThanKb() != other.getSkipParsingWhenMessageLargerThanKb()) {
            return false;
        }
        if (this.isManageBuffer() != other.isManageBuffer()) {
            return false;
        }
        List<RbelConverterPlugin> this$postConversionListener = this.getPostConversionListener();
        List<RbelConverterPlugin> other$postConversionListener = other.getPostConversionListener();
        if (this$postConversionListener == null ? other$postConversionListener != null : !((Object)this$postConversionListener).equals(other$postConversionListener)) {
            return false;
        }
        List<RbelConverterPlugin> this$additionalConverters = this.getAdditionalConverters();
        List<RbelConverterPlugin> other$additionalConverters = other.getAdditionalConverters();
        if (this$additionalConverters == null ? other$additionalConverters != null : !((Object)this$additionalConverters).equals(other$additionalConverters)) {
            return false;
        }
        List<Consumer<RbelConverter>> this$initializers = this.getInitializers();
        List<Consumer<RbelConverter>> other$initializers = other.getInitializers();
        if (this$initializers == null ? other$initializers != null : !((Object)this$initializers).equals(other$initializers)) {
            return false;
        }
        Map<String, RbelKey> this$keys = this.getKeys();
        Map<String, RbelKey> other$keys = other.getKeys();
        if (this$keys == null ? other$keys != null : !((Object)this$keys).equals(other$keys)) {
            return false;
        }
        RbelCapturer this$capturer = this.getCapturer();
        RbelCapturer other$capturer = other.getCapturer();
        return !(this$capturer == null ? other$capturer != null : !((Object)this$capturer).equals(other$capturer));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RbelConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isActivateAsn1Parsing() ? 79 : 97);
        result = result * 59 + (this.isActivateVauEpa3Parsing() ? 79 : 97);
        result = result * 59 + this.getRbelBufferSizeInMb();
        result = result * 59 + this.getSkipParsingWhenMessageLargerThanKb();
        result = result * 59 + (this.isManageBuffer() ? 79 : 97);
        List<RbelConverterPlugin> $postConversionListener = this.getPostConversionListener();
        result = result * 59 + ($postConversionListener == null ? 43 : ((Object)$postConversionListener).hashCode());
        List<RbelConverterPlugin> $additionalConverters = this.getAdditionalConverters();
        result = result * 59 + ($additionalConverters == null ? 43 : ((Object)$additionalConverters).hashCode());
        List<Consumer<RbelConverter>> $initializers = this.getInitializers();
        result = result * 59 + ($initializers == null ? 43 : ((Object)$initializers).hashCode());
        Map<String, RbelKey> $keys = this.getKeys();
        result = result * 59 + ($keys == null ? 43 : ((Object)$keys).hashCode());
        RbelCapturer $capturer = this.getCapturer();
        result = result * 59 + ($capturer == null ? 43 : ((Object)$capturer).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RbelConfiguration(postConversionListener=" + this.getPostConversionListener() + ", additionalConverters=" + this.getAdditionalConverters() + ", initializers=" + this.getInitializers() + ", keys=" + this.getKeys() + ", capturer=" + this.getCapturer() + ", activateAsn1Parsing=" + this.isActivateAsn1Parsing() + ", activateVauEpa3Parsing=" + this.isActivateVauEpa3Parsing() + ", rbelBufferSizeInMb=" + this.getRbelBufferSizeInMb() + ", skipParsingWhenMessageLargerThanKb=" + this.getSkipParsingWhenMessageLargerThanKb() + ", manageBuffer=" + this.isManageBuffer() + ")";
    }

    @ConstructorProperties(value={"postConversionListener", "additionalConverters", "initializers", "keys", "capturer", "activateAsn1Parsing", "activateVauEpa3Parsing", "rbelBufferSizeInMb", "skipParsingWhenMessageLargerThanKb", "manageBuffer"})
    @Generated
    public RbelConfiguration(List<RbelConverterPlugin> postConversionListener, List<RbelConverterPlugin> additionalConverters, List<Consumer<RbelConverter>> initializers, Map<String, RbelKey> keys, RbelCapturer capturer, boolean activateAsn1Parsing, boolean activateVauEpa3Parsing, int rbelBufferSizeInMb, int skipParsingWhenMessageLargerThanKb, boolean manageBuffer) {
        this.postConversionListener = postConversionListener;
        this.additionalConverters = additionalConverters;
        this.initializers = initializers;
        this.keys = keys;
        this.capturer = capturer;
        this.activateAsn1Parsing = activateAsn1Parsing;
        this.activateVauEpa3Parsing = activateVauEpa3Parsing;
        this.rbelBufferSizeInMb = rbelBufferSizeInMb;
        this.skipParsingWhenMessageLargerThanKb = skipParsingWhenMessageLargerThanKb;
        this.manageBuffer = manageBuffer;
    }

    @Generated
    public RbelConfiguration() {
        this.postConversionListener = RbelConfiguration.$default$postConversionListener();
        this.additionalConverters = RbelConfiguration.$default$additionalConverters();
        this.initializers = RbelConfiguration.$default$initializers();
        this.keys = RbelConfiguration.$default$keys();
        this.activateAsn1Parsing = RbelConfiguration.$default$activateAsn1Parsing();
        this.activateVauEpa3Parsing = RbelConfiguration.$default$activateVauEpa3Parsing();
        this.rbelBufferSizeInMb = RbelConfiguration.$default$rbelBufferSizeInMb();
        this.skipParsingWhenMessageLargerThanKb = RbelConfiguration.$default$skipParsingWhenMessageLargerThanKb();
        this.manageBuffer = RbelConfiguration.$default$manageBuffer();
    }

    @Generated
    public static class RbelConfigurationBuilder {
        @Generated
        private boolean postConversionListener$set;
        @Generated
        private List<RbelConverterPlugin> postConversionListener$value;
        @Generated
        private boolean additionalConverters$set;
        @Generated
        private List<RbelConverterPlugin> additionalConverters$value;
        @Generated
        private boolean initializers$set;
        @Generated
        private List<Consumer<RbelConverter>> initializers$value;
        @Generated
        private boolean keys$set;
        @Generated
        private Map<String, RbelKey> keys$value;
        @Generated
        private RbelCapturer capturer;
        @Generated
        private boolean activateAsn1Parsing$set;
        @Generated
        private boolean activateAsn1Parsing$value;
        @Generated
        private boolean activateVauEpa3Parsing$set;
        @Generated
        private boolean activateVauEpa3Parsing$value;
        @Generated
        private boolean rbelBufferSizeInMb$set;
        @Generated
        private int rbelBufferSizeInMb$value;
        @Generated
        private boolean skipParsingWhenMessageLargerThanKb$set;
        @Generated
        private int skipParsingWhenMessageLargerThanKb$value;
        @Generated
        private boolean manageBuffer$set;
        @Generated
        private boolean manageBuffer$value;

        @Generated
        RbelConfigurationBuilder() {
        }

        @Generated
        public RbelConfigurationBuilder postConversionListener(List<RbelConverterPlugin> postConversionListener) {
            this.postConversionListener$value = postConversionListener;
            this.postConversionListener$set = true;
            return this;
        }

        @Generated
        public RbelConfigurationBuilder additionalConverters(List<RbelConverterPlugin> additionalConverters) {
            this.additionalConverters$value = additionalConverters;
            this.additionalConverters$set = true;
            return this;
        }

        @Generated
        public RbelConfigurationBuilder initializers(List<Consumer<RbelConverter>> initializers) {
            this.initializers$value = initializers;
            this.initializers$set = true;
            return this;
        }

        @Generated
        public RbelConfigurationBuilder keys(Map<String, RbelKey> keys) {
            this.keys$value = keys;
            this.keys$set = true;
            return this;
        }

        @Generated
        public RbelConfigurationBuilder capturer(RbelCapturer capturer) {
            this.capturer = capturer;
            return this;
        }

        @Generated
        public RbelConfigurationBuilder activateAsn1Parsing(boolean activateAsn1Parsing) {
            this.activateAsn1Parsing$value = activateAsn1Parsing;
            this.activateAsn1Parsing$set = true;
            return this;
        }

        @Generated
        public RbelConfigurationBuilder activateVauEpa3Parsing(boolean activateVauEpa3Parsing) {
            this.activateVauEpa3Parsing$value = activateVauEpa3Parsing;
            this.activateVauEpa3Parsing$set = true;
            return this;
        }

        @Generated
        public RbelConfigurationBuilder rbelBufferSizeInMb(int rbelBufferSizeInMb) {
            this.rbelBufferSizeInMb$value = rbelBufferSizeInMb;
            this.rbelBufferSizeInMb$set = true;
            return this;
        }

        @Generated
        public RbelConfigurationBuilder skipParsingWhenMessageLargerThanKb(int skipParsingWhenMessageLargerThanKb) {
            this.skipParsingWhenMessageLargerThanKb$value = skipParsingWhenMessageLargerThanKb;
            this.skipParsingWhenMessageLargerThanKb$set = true;
            return this;
        }

        @Generated
        public RbelConfigurationBuilder manageBuffer(boolean manageBuffer) {
            this.manageBuffer$value = manageBuffer;
            this.manageBuffer$set = true;
            return this;
        }

        @Generated
        public RbelConfiguration build() {
            List<RbelConverterPlugin> postConversionListener$value = this.postConversionListener$value;
            if (!this.postConversionListener$set) {
                postConversionListener$value = RbelConfiguration.$default$postConversionListener();
            }
            List<RbelConverterPlugin> additionalConverters$value = this.additionalConverters$value;
            if (!this.additionalConverters$set) {
                additionalConverters$value = RbelConfiguration.$default$additionalConverters();
            }
            List<Consumer<RbelConverter>> initializers$value = this.initializers$value;
            if (!this.initializers$set) {
                initializers$value = RbelConfiguration.$default$initializers();
            }
            Map<String, RbelKey> keys$value = this.keys$value;
            if (!this.keys$set) {
                keys$value = RbelConfiguration.$default$keys();
            }
            boolean activateAsn1Parsing$value = this.activateAsn1Parsing$value;
            if (!this.activateAsn1Parsing$set) {
                activateAsn1Parsing$value = RbelConfiguration.$default$activateAsn1Parsing();
            }
            boolean activateVauEpa3Parsing$value = this.activateVauEpa3Parsing$value;
            if (!this.activateVauEpa3Parsing$set) {
                activateVauEpa3Parsing$value = RbelConfiguration.$default$activateVauEpa3Parsing();
            }
            int rbelBufferSizeInMb$value = this.rbelBufferSizeInMb$value;
            if (!this.rbelBufferSizeInMb$set) {
                rbelBufferSizeInMb$value = RbelConfiguration.$default$rbelBufferSizeInMb();
            }
            int skipParsingWhenMessageLargerThanKb$value = this.skipParsingWhenMessageLargerThanKb$value;
            if (!this.skipParsingWhenMessageLargerThanKb$set) {
                skipParsingWhenMessageLargerThanKb$value = RbelConfiguration.$default$skipParsingWhenMessageLargerThanKb();
            }
            boolean manageBuffer$value = this.manageBuffer$value;
            if (!this.manageBuffer$set) {
                manageBuffer$value = RbelConfiguration.$default$manageBuffer();
            }
            return new RbelConfiguration(postConversionListener$value, additionalConverters$value, initializers$value, keys$value, this.capturer, activateAsn1Parsing$value, activateVauEpa3Parsing$value, rbelBufferSizeInMb$value, skipParsingWhenMessageLargerThanKb$value, manageBuffer$value);
        }

        @Generated
        public String toString() {
            return "RbelConfiguration.RbelConfigurationBuilder(postConversionListener$value=" + this.postConversionListener$value + ", additionalConverters$value=" + this.additionalConverters$value + ", initializers$value=" + this.initializers$value + ", keys$value=" + this.keys$value + ", capturer=" + this.capturer + ", activateAsn1Parsing$value=" + this.activateAsn1Parsing$value + ", activateVauEpa3Parsing$value=" + this.activateVauEpa3Parsing$value + ", rbelBufferSizeInMb$value=" + this.rbelBufferSizeInMb$value + ", skipParsingWhenMessageLargerThanKb$value=" + this.skipParsingWhenMessageLargerThanKb$value + ", manageBuffer$value=" + this.manageBuffer$value + ")";
        }
    }
}

