/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.builder;

import de.gematik.rbellogger.RbelLogger;
import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelMultiMap;
import de.gematik.rbellogger.exceptions.RbelPathException;
import de.gematik.rbellogger.writer.RbelContentTreeConverter;
import de.gematik.rbellogger.writer.RbelContentType;
import de.gematik.rbellogger.writer.RbelWriter;
import de.gematik.rbellogger.writer.tree.RbelContentTreeNode;
import de.gematik.test.tiger.common.config.TigerGlobalConfiguration;
import de.gematik.test.tiger.common.jexl.TigerJexlContext;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RbelBuilder {
    private static RbelLogger rbelLogger;
    private static RbelWriter rbelWriter;
    private RbelContentTreeNode treeRootNode;

    public RbelBuilder(RbelContentTreeNode treeRootNode) {
        this.treeRootNode = treeRootNode;
    }

    public static RbelBuilder fromFile(String pathName) {
        String fileContent = Files.readString(Paths.get(String.valueOf(Path.of(pathName, new String[0])), new String[0]));
        String resolvedInput = TigerGlobalConfiguration.resolvePlaceholders((String)fileContent);
        return RbelBuilder.fromString(resolvedInput);
    }

    public static RbelBuilder fromFile(String objectName, String pathName) {
        RbelBuilder contentBuilder = RbelBuilder.fromFile(pathName);
        return RbelBuilder.fromRbel(objectName, contentBuilder.getTreeRootNode());
    }

    public static RbelBuilder fromScratch(RbelContentType type) {
        RbelContentTreeNode root = new RbelContentTreeNode(null, new byte[0]);
        root.setType(type);
        return new RbelBuilder(root);
    }

    public static RbelBuilder fromString(String content) {
        RbelContentTreeNode treeRootNode = RbelBuilder.getContentTreeNodeFromString(content);
        return new RbelBuilder(treeRootNode);
    }

    public RbelContentTreeNode getTreeRootNode() {
        return this.treeRootNode;
    }

    public RbelBuilder setValueAt(String rbelPath, String newValue) {
        RbelContentTreeNode parentNode;
        Optional<RbelContentTreeNode> entryOptional = this.treeRootNode.findElement(rbelPath);
        if (entryOptional.isPresent()) {
            return this.setValueAt(entryOptional.get(), newValue);
        }
        ArrayList<String> steps = new ArrayList<String>(Arrays.asList(rbelPath.split("\\.")));
        if (steps.isEmpty() || !steps.contains("$")) {
            throw new RbelPathException("RbelPath must at least contain '$' and one node");
        }
        String newKey = steps.remove(steps.size() - 1);
        if (steps.size() == 1) {
            parentNode = this.treeRootNode;
        } else {
            String parentPath = String.join((CharSequence)".", steps);
            Optional<RbelContentTreeNode> parentOptional = this.treeRootNode.findElement(parentPath);
            if (parentOptional.isEmpty()) {
                throw new RbelPathException("Neither the path '%s' nor its parent does exist.".formatted(rbelPath));
            }
            parentNode = parentOptional.get();
        }
        if (parentNode.getType() == RbelContentType.XML) {
            String newXmlValue = String.format("<%s>%s</%s>", newKey, newValue, newKey);
            RbelContentTreeNode newXmlNode = RbelBuilder.getContentTreeNodeFromString(newXmlValue);
            parentNode.addOrReplaceChild(newKey, newXmlNode.findElement("$." + newKey).orElseThrow());
        } else {
            RbelContentTreeNode newValueNode = RbelBuilder.getContentTreeNodeFromString(newValue);
            parentNode.addOrReplaceChild(newKey, newValueNode);
        }
        return this;
    }

    public RbelBuilder addEntryAt(String rbelPath, String newValue) {
        RbelContentTreeNode entry = this.treeRootNode.findElement(rbelPath).orElseThrow();
        RbelContentTreeNode newChild = RbelBuilder.getContentTreeNodeFromString(newValue);
        entry.addChild(newChild);
        return this;
    }

    private RbelBuilder setValueAt(RbelContentTreeNode entry, String newValue) {
        if (!RbelBuilder.isJsonObject(newValue) && entry.getParentNode() != null && entry.getParentNode().getType() == RbelContentType.JSON) {
            RbelContentTreeNode parentNode = entry.getParentNode();
            String wrappedContent = RbelBuilder.wrapJsonContentInKey(entry.getKey().orElseThrow(), newValue);
            RbelContentTreeNode modifiedRbelContentTreeNode = RbelBuilder.getContentTreeNodeFromString(wrappedContent);
            if (parentNode.getKey().isPresent()) {
                parentNode.addOrReplaceChild(entry.getKey().orElseThrow(), modifiedRbelContentTreeNode.getChildNodes().get(0));
            } else {
                this.treeRootNode = modifiedRbelContentTreeNode;
            }
        } else {
            RbelContentTreeNode newContentTreeNode = RbelBuilder.getContentTreeNodeFromString(newValue);
            Optional<String> key = entry.getKey();
            if (key.isPresent()) {
                entry.getParentNode().addOrReplaceChild(key.get(), newContentTreeNode);
            } else {
                throw new NullPointerException("The key of the node which is to be changed is not set in its parent node.");
            }
        }
        return this;
    }

    public String serialize() {
        return RbelBuilder.getRbelWriter().serialize(this.treeRootNode, new TigerJexlContext()).getContentAsString();
    }

    private static RbelBuilder fromRbel(String name, RbelContentTreeNode content) {
        RbelMultiMap<RbelContentTreeNode> childNodes = new RbelMultiMap<RbelContentTreeNode>();
        childNodes.put(name, content);
        RbelContentTreeNode contentTreeNode = new RbelContentTreeNode(childNodes, null);
        content.setKey(name);
        contentTreeNode.setCharset(content.getElementCharset());
        contentTreeNode.setType(content.getType());
        return new RbelBuilder(contentTreeNode);
    }

    private static RbelConverter getRbelConverter() {
        RbelBuilder.assureRbelIsInitialized();
        return rbelLogger.getRbelConverter();
    }

    private static RbelWriter getRbelWriter() {
        RbelBuilder.assureRbelIsInitialized();
        return rbelWriter;
    }

    private static RbelContentTreeNode getContentTreeNodeFromString(String content) {
        RbelElement input = RbelBuilder.getRbelConverter().convertElement(content, null);
        return new RbelContentTreeConverter(input, new TigerJexlContext()).convertToContentTree();
    }

    private static String wrapJsonContentInKey(String key, String content) {
        if (RbelBuilder.isJsonObject(content) || RbelBuilder.isJsonArray(content)) {
            return String.format("{ \"%s\": %s }", key, content);
        }
        return String.format("{ \"%s\": \"%s\" }", key, content);
    }

    private static synchronized void assureRbelIsInitialized() {
        if (rbelLogger == null) {
            rbelLogger = RbelLogger.build();
            rbelWriter = new RbelWriter(rbelLogger.getRbelConverter());
        }
    }

    private static boolean isJsonObject(String json) {
        try {
            new JSONObject(json);
            return true;
        }
        catch (JSONException e) {
            return false;
        }
    }

    private static boolean isJsonArray(String json) {
        try {
            new JSONObject(json);
        }
        catch (JSONException e) {
            try {
                new JSONArray(json);
            }
            catch (JSONException ne) {
                return false;
            }
        }
        return true;
    }
}

