/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.util;

import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelHostname;
import de.gematik.rbellogger.data.facet.RbelHostnameFacet;
import de.gematik.rbellogger.data.facet.RbelMessageTimingFacet;
import de.gematik.rbellogger.data.facet.RbelTcpIpMessageFacet;
import de.gematik.rbellogger.util.RbelMessagePostProcessor;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;

public class RbelFileWriter {
    private static final String FILE_DIVIDER = "\n";
    private static final String RAW_MESSAGE_CONTENT = "rawMessageContent";
    private static final String SENDER_HOSTNAME = "senderHostname";
    private static final String RECEIVER_HOSTNAME = "receiverHostname";
    private static final String SEQUENCE_NUMBER = "sequenceNumber";
    private static final String MESSAGE_TIME = "timestamp";
    private static final String MESSAGE_UUID = "uuid";
    public final List<RbelMessagePostProcessor> postConversionListener = new ArrayList<RbelMessagePostProcessor>();
    public final List<BiConsumer<RbelElement, JSONObject>> preSaveListener = new ArrayList<BiConsumer<RbelElement, JSONObject>>();
    private final RbelConverter rbelConverter;

    public String convertToRbelFileString(RbelElement rbelElement) {
        JSONObject jsonObject = new JSONObject(Map.of(RAW_MESSAGE_CONTENT, Base64.getEncoder().encodeToString(rbelElement.getRawContent()), SENDER_HOSTNAME, rbelElement.getFacet(RbelTcpIpMessageFacet.class).map(RbelTcpIpMessageFacet::getSender).filter(Objects::nonNull).flatMap(element -> element.getFacet(RbelHostnameFacet.class)).map(RbelHostnameFacet::toString).orElse(""), RECEIVER_HOSTNAME, rbelElement.getFacet(RbelTcpIpMessageFacet.class).map(RbelTcpIpMessageFacet::getReceiver).filter(Objects::nonNull).flatMap(element -> element.getFacet(RbelHostnameFacet.class)).map(RbelHostnameFacet::toString).orElse(""), SEQUENCE_NUMBER, rbelElement.getFacet(RbelTcpIpMessageFacet.class).map(RbelTcpIpMessageFacet::getSequenceNumber).map(Object::toString).orElse(""), MESSAGE_TIME, rbelElement.getFacet(RbelMessageTimingFacet.class).map(RbelMessageTimingFacet::getTransmissionTime).map(Object::toString).orElse(""), MESSAGE_UUID, rbelElement.getUuid()));
        this.preSaveListener.forEach(listener -> listener.accept(rbelElement, jsonObject));
        return jsonObject + FILE_DIVIDER;
    }

    public List<RbelElement> convertFromRbelFile(Path rbelFile) {
        try {
            return this.readRbelFileStream(Files.lines(rbelFile, StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new RbelFileReadingException("Error while reading from file " + rbelFile.toAbsolutePath(), e);
        }
    }

    public List<RbelElement> convertFromRbelFile(String rbelFileContent) {
        return this.readRbelFileStream(Arrays.stream(rbelFileContent.split(FILE_DIVIDER)));
    }

    private List<RbelElement> readRbelFileStream(Stream<String> rbelFileStream) {
        List collect = rbelFileStream.filter(StringUtils::isNotEmpty).collect(Collectors.toList());
        return collect.stream().map(JSONObject::new).map(this::parseFileObject).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private Optional<RbelElement> parseFileObject(JSONObject messageObject) {
        try {
            String msgUuid = messageObject.optString(MESSAGE_UUID);
            if (this.rbelConverter.getMessageHistory().stream().anyMatch(msg -> msg.getUuid().equals(msgUuid))) {
                return Optional.empty();
            }
            RbelElement parsedMessage = this.rbelConverter.parseMessage(RbelElement.builder().rawContent(Base64.getDecoder().decode(messageObject.getString(RAW_MESSAGE_CONTENT))).uuid(msgUuid).parentNode(null).build(), (RbelHostname)RbelHostname.fromString(messageObject.getString(SENDER_HOSTNAME)).orElse(null), (RbelHostname)RbelHostname.fromString(messageObject.getString(RECEIVER_HOSTNAME)).orElse(null), messageObject.has(MESSAGE_TIME) ? RbelFileWriter.parseTransmissionTimeFromString(messageObject.getString(MESSAGE_TIME)) : Optional.empty());
            this.postConversionListener.forEach(listener -> listener.performMessagePostConversionProcessing(parsedMessage, this.rbelConverter, messageObject));
            return Optional.of(parsedMessage);
        }
        catch (Exception e) {
            throw new RbelFileReadingException("Error while converting from object '" + messageObject.toString() + "'", e);
        }
    }

    private static Optional<ZonedDateTime> parseTransmissionTimeFromString(String time) {
        if (StringUtils.isBlank((CharSequence)time)) {
            return Optional.empty();
        }
        return Optional.of(ZonedDateTime.parse(time));
    }

    @ConstructorProperties(value={"rbelConverter"})
    @Generated
    public RbelFileWriter(RbelConverter rbelConverter) {
        this.rbelConverter = rbelConverter;
    }

    private static class RbelFileReadingException
    extends RuntimeException {
        public RbelFileReadingException(String s, Exception e) {
            super(s, e);
        }
    }
}

