/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.renderer;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.facet.RbelHostnameFacet;
import de.gematik.rbellogger.data.facet.RbelHttpMessageFacet;
import de.gematik.rbellogger.data.facet.RbelHttpRequestFacet;
import de.gematik.rbellogger.data.facet.RbelHttpResponseFacet;
import de.gematik.rbellogger.data.facet.RbelMessageTimingFacet;
import de.gematik.rbellogger.data.facet.RbelRequestFacet;
import de.gematik.rbellogger.data.facet.RbelResponseFacet;
import de.gematik.rbellogger.data.facet.RbelTcpIpMessageFacet;
import de.gematik.rbellogger.renderer.RbelHtmlFacetRenderer;
import de.gematik.rbellogger.renderer.RbelHtmlRenderer;
import de.gematik.rbellogger.renderer.RbelHtmlRenderingToolkit;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import j2html.tags.Tag;
import j2html.tags.specialized.DivTag;
import j2html.tags.specialized.H1Tag;
import j2html.tags.specialized.ITag;
import j2html.tags.specialized.SpanTag;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class RbelMessageRenderer
implements RbelHtmlFacetRenderer {
    public static ContainerTag buildAddressInfo(RbelElement element) {
        String icon;
        String right;
        String left;
        if (!element.hasFacet(RbelTcpIpMessageFacet.class)) {
            return TagCreator.span();
        }
        RbelTcpIpMessageFacet messageFacet = element.getFacetOrFail(RbelTcpIpMessageFacet.class);
        if (messageFacet.getSender().getFacet(RbelHostnameFacet.class).isEmpty() && messageFacet.getReceiver().getFacet(RbelHostnameFacet.class).isEmpty()) {
            return TagCreator.span();
        }
        Optional<Boolean> isRequest = RbelMessageRenderer.determineIsRequest(element);
        if (isRequest.isEmpty() || isRequest.get().booleanValue()) {
            left = messageFacet.getSender().getFacet(RbelHostnameFacet.class).map(RbelHostnameFacet::toString).orElse(null);
            right = messageFacet.getReceiver().getFacet(RbelHostnameFacet.class).map(RbelHostnameFacet::toString).orElse(null);
            icon = "fa-arrow-right";
        } else {
            left = messageFacet.getReceiver().getFacet(RbelHostnameFacet.class).map(RbelHostnameFacet::toString).orElse(null);
            right = messageFacet.getSender().getFacet(RbelHostnameFacet.class).map(RbelHostnameFacet::toString).orElse(null);
            icon = "fa-arrow-left";
        }
        return (ContainerTag)((SpanTag)((SpanTag)((SpanTag)TagCreator.span().withText(left == null ? "" : left)).with((DomContent)RbelHtmlRenderingToolkit.icon(icon))).with((DomContent)TagCreator.text((String)(right == null ? "" : right)))).withClass("is-size-6 ml-4");
    }

    private static Optional<Boolean> determineIsRequest(RbelElement element) {
        if (element.hasFacet(RbelRequestFacet.class)) {
            return Optional.of(true);
        }
        if (element.hasFacet(RbelResponseFacet.class)) {
            return Optional.of(false);
        }
        return Optional.empty();
    }

    public static ContainerTag buildTimingInfo(RbelElement element) {
        if (!element.hasFacet(RbelMessageTimingFacet.class)) {
            return TagCreator.span();
        }
        RbelMessageTimingFacet timingFacet = element.getFacetOrFail(RbelMessageTimingFacet.class);
        return (ContainerTag)((SpanTag)((SpanTag)TagCreator.span().with((DomContent)RbelHtmlRenderingToolkit.icon("fa-clock"))).withText(timingFacet.getTransmissionTime().format(DateTimeFormatter.ISO_TIME))).withClass("is-size-6 ml-4 ");
    }

    @Override
    public boolean checkForRendering(RbelElement element) {
        return element.hasFacet(RbelHttpMessageFacet.class) && element.getParentNode() != null;
    }

    @Override
    public ContainerTag performRendering(RbelElement element, Optional<String> key, RbelHtmlRenderingToolkit renderingToolkit) {
        Optional<RbelHttpMessageFacet> httpMessageFacet = element.getFacet(RbelHttpMessageFacet.class);
        Optional<RbelHttpRequestFacet> httpRequestFacet = element.getFacet(RbelHttpRequestFacet.class);
        Optional<RbelHttpResponseFacet> httpResponseFacet = element.getFacet(RbelHttpResponseFacet.class);
        Optional<Boolean> isRequest = RbelMessageRenderer.determineIsRequest(element);
        ArrayList<Object> messageTitleElements = new ArrayList<Object>();
        messageTitleElements.add(TagCreator.a().attr("name", (Object)element.getUuid()));
        messageTitleElements.add(TagCreator.i().withClasses(new String[]{"fas fa-toggle-on toggle-icon is-pulled-right mr-3 is-size-3 msg-toggle", httpRequestFacet.map(f -> "has-text-link").orElse("has-text-success")}));
        messageTitleElements.add(RbelHtmlRenderer.showContentButtonAndDialog(element, renderingToolkit));
        messageTitleElements.add(((H1Tag)TagCreator.h1((DomContent[])new DomContent[]{renderingToolkit.constructMessageId(element), this.getRequestOrReplySymbol(isRequest), (DomContent)httpRequestFacet.map(f -> (SpanTag)((SpanTag)TagCreator.span().with((DomContent)((SpanTag)((SpanTag)TagCreator.span((String)(" " + f.getMethod().getRawStringContent() + " " + f.getPathAsString())).withClass("is-family-monospace title is-size-4 ml-3")).withTitle(f.getPathAsString())).with(RbelHtmlRenderingToolkit.addNotes(f.getPath(), new String[0])))).withClass("has-text-link text-ellipsis")).orElse(TagCreator.span()), (DomContent)httpResponseFacet.map(response -> (SpanTag)TagCreator.span((String)response.getResponseCode().getRawStringContent()).withClass("is-family-monospace title ml-3")).orElse(TagCreator.span((String)"")), ((SpanTag)TagCreator.span().with(new DomContent[]{RbelMessageRenderer.buildTimingInfo(element), RbelMessageRenderer.buildAddressInfo(element)})).withStyle(isRequest.map(r -> (Boolean)isRequest.get() != false ? "display: block;" : "").orElse(""))}).withClasses(new String[]{"title", "ml-3", "text-ellipsis", isRequest.map(req -> req != false ? "has-text-link" : "has-text-success").orElse("")})).withStyle("overflow: hidden;"));
        messageTitleElements.addAll(RbelHtmlRenderingToolkit.addNotes(element, new String[0]));
        List<Object> messageBodyElements = new ArrayList<ContainerTag>();
        if (httpMessageFacet.isPresent()) {
            messageBodyElements = this.performRenderingForBody(renderingToolkit, httpMessageFacet, httpRequestFacet);
        } else {
            messageBodyElements.add(renderingToolkit.convert(element));
        }
        return RbelHtmlRenderer.collapsibleCard((ContainerTag)((DivTag)TagCreator.div().with(messageTitleElements)).withClass("full-width"), RbelHtmlRenderingToolkit.ancestorTitle().with(messageBodyElements), "msg-card", "mx-3 " + isRequest.map(r -> Boolean.TRUE.equals(r) ? "mt-5" : "mt-2").orElse("mt-3"), "msg-content");
    }

    private List<DomContent> performRenderingForBody(RbelHtmlRenderingToolkit renderingToolkit, Optional<RbelHttpMessageFacet> httpMessageFacet, Optional<RbelHttpRequestFacet> httpRequestFacet) {
        ArrayList<Tag> headerTitleElements = new ArrayList<Tag>();
        headerTitleElements.add(TagCreator.i().withClasses(new String[]{"fas fa-toggle-on toggle-icon is-pulled-right mr-3 is-size-3 has-text-primary header-toggle"}));
        httpMessageFacet.map(a -> headerTitleElements.add((Tag)RbelHtmlRenderer.showContentButtonAndDialog(a.getHeader(), renderingToolkit)));
        headerTitleElements.add(TagCreator.div((DomContent[])new DomContent[]{(DomContent)httpRequestFacet.map(f -> RbelHtmlRenderingToolkit.t2("REQ Headers")).orElseGet(() -> RbelHtmlRenderingToolkit.t2("RES Headers"))}).withClass("has-text-primary"));
        ArrayList<Tag> bodyTitleElements = new ArrayList<Tag>();
        bodyTitleElements.add(TagCreator.i().withClasses(new String[]{"fas fa-toggle-on toggle-icon is-pulled-right mr-3 is-size-3 has-text-info body-toggle"}));
        httpMessageFacet.map(a -> bodyTitleElements.add((Tag)RbelHtmlRenderer.showContentButtonAndDialog(a.getBody(), renderingToolkit)));
        bodyTitleElements.add(TagCreator.div((DomContent[])new DomContent[]{(DomContent)httpRequestFacet.map(f -> RbelHtmlRenderingToolkit.t2("REQ Body")).orElseGet(() -> RbelHtmlRenderingToolkit.t2("RES Body"))}).withClass("has-text-info"));
        ArrayList<DomContent> messageBodyElements = new ArrayList<DomContent>();
        messageBodyElements.add((DomContent)RbelHtmlRenderingToolkit.ancestorTitle().with((DomContent)((DivTag)TagCreator.div().withClass("tile is-parent is-vertical pr-3")).with(new DomContent[]{TagCreator.div().with((DomContent)RbelHtmlRenderer.collapsibleCard(((DivTag)TagCreator.div().withClass("tile is-child pr-3")).with(headerTitleElements), httpMessageFacet.map(facet -> renderingToolkit.convert(facet.getHeader(), Optional.empty())).orElse((ContainerTag)TagCreator.div()), "is-primary notification", "my-3", "msg-header-content")), (DomContent)httpMessageFacet.map(RbelHttpMessageFacet::getBody).map(RbelElement::getRawStringContent).map(s -> StringUtils.isBlank((CharSequence)s) ? (DivTag)TagCreator.div((String)"Empty body").withClass("is-info notification tile is-child") : (DivTag)TagCreator.div().with((DomContent)RbelHtmlRenderer.collapsibleCard(((DivTag)TagCreator.div().withClass("tile is-child pr-3")).with((Iterable)bodyTitleElements), renderingToolkit.convert(((RbelHttpMessageFacet)httpMessageFacet.get()).getBody(), Optional.empty()), "is-info notification", "my-3", "msg-body-content"))).orElse(TagCreator.div())})));
        return messageBodyElements;
    }

    private DomContent getRequestOrReplySymbol(Optional<Boolean> isRequestOptional) {
        return isRequestOptional.map(isRequest -> {
            if (isRequest.booleanValue()) {
                return (ITag)((ITag)TagCreator.i().withClass("fas fa-share mr-3")).withTitle("Request");
            }
            return (ITag)((ITag)TagCreator.i().withClass("fas fa-reply mr-3")).withTitle("Response");
        }).map(DomContent.class::cast).orElse((DomContent)TagCreator.span());
    }
}

