/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.renderer;

import de.gematik.rbellogger.converter.RbelValueShader;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.facet.RbelAsn1Facet;
import de.gematik.rbellogger.renderer.RbelHtmlFacetRenderer;
import de.gematik.rbellogger.renderer.RbelHtmlRenderingToolkit;
import de.gematik.rbellogger.util.BinaryClassifier;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import j2html.tags.specialized.ATag;
import j2html.tags.specialized.ArticleTag;
import j2html.tags.specialized.ButtonTag;
import j2html.tags.specialized.DivTag;
import j2html.tags.specialized.HeaderTag;
import j2html.tags.specialized.PreTag;
import j2html.tags.specialized.SpanTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbelHtmlRenderer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelHtmlRenderer.class);
    private static final List<RbelHtmlFacetRenderer> htmlRenderer = new ArrayList<RbelHtmlFacetRenderer>();
    public static final String OVERSIZE_REPLACEMENT_TEXT_PRE = "<...redacted due to size of ";
    public static final String OVERSIZE_REPLACEMENT_TEXT_POST = " Mb...>";
    private final RbelValueShader rbelValueShader;
    private boolean renderAsn1Objects = false;
    private boolean renderNestedObjectsWithoutFacetRenderer = false;
    private int maximumEntitySizeInBytes = 0x400000;
    private String title = "RBelLogger";
    private String subTitle = "<p>The [R]everse [B]ridle [E]vent [L]ogger pays tribute to the fact that many agile projects' specifications, alas somewhat complete, lack specificality. Using PoCs most of the time does not resolve this as the code is not well enough documented and communication between nodes is not observable or logged in a well enough readable manner.</p> <p>This is where the RBeL Logger comes into play.</p> <p>Attaching it to a network, RestAssured or Wiremock interface or instructing it to read from a recorded PCAP file, produces this shiny communication log supporting Plain HTTP, JSON, JWT and even JWE!</p>";

    public RbelHtmlRenderer(RbelValueShader rbelValueShader) {
        this.rbelValueShader = rbelValueShader;
    }

    public RbelHtmlRenderer() {
        this.rbelValueShader = new RbelValueShader();
    }

    public static String render(Collection<RbelElement> elements) {
        return RbelHtmlRenderer.render(elements, new RbelValueShader());
    }

    public static String render(Collection<RbelElement> elements, RbelValueShader valueShader) {
        return new RbelHtmlRenderer(valueShader).performRendering(elements);
    }

    public static ContainerTag collapsibleCard(ContainerTag title, ContainerTag body, String classes, String spaces, String contentClasses) {
        return ((DivTag)TagCreator.div().withClass("container page-break " + spaces)).with((DomContent)((DivTag)TagCreator.div().withClass("card full-width " + classes)).with(new DomContent[]{((HeaderTag)TagCreator.header().withClass("card-header")).with((DomContent)((DivTag)TagCreator.div().withClass("card-header-title card-toggle")).with((DomContent)title)), ((DivTag)TagCreator.div().withClass("card-content " + contentClasses)).with((DomContent)TagCreator.div().with((DomContent)body))}));
    }

    public static DomContent showContentButtonAndDialog(RbelElement el, RbelHtmlRenderingToolkit renderingToolkit) {
        String id = "dialog" + RandomStringUtils.randomAlphanumeric((int)20);
        return TagCreator.span().with(new DomContent[]{((ATag)((ATag)TagCreator.a().withClass("button modal-button modal-button-details is-pulled-right mx-3")).attr("data-target", (Object)id)).with((DomContent)((SpanTag)TagCreator.span().withClass("icon is-small")).with((DomContent)TagCreator.i().withClass("fas fa-align-left"))), ((DivTag)((DivTag)TagCreator.div().withClass("modal")).withId(id)).with(new DomContent[]{TagCreator.div().withClass("modal-background"), ((DivTag)TagCreator.div().withClass("modal-content")).with((DomContent)((ArticleTag)TagCreator.article().withClass("message")).with(new DomContent[]{((DivTag)TagCreator.div().withClass("message-header")).with(new DomContent[]{((DivTag)TagCreator.div().withStyle("display: inline-flex;")).with(new DomContent[]{TagCreator.p((String)("Raw content of " + el.findNodePath())).withStyle("align-self: center;"), ((ButtonTag)((ButtonTag)TagCreator.button().withClass("copyToClipboard-button")).attr("data-target", (Object)("text-" + id))).with((DomContent)TagCreator.i().withClass("fa fa-clipboard"))}), ((ButtonTag)TagCreator.button().withClass("delete")).attr("aria-label", (Object)"delete")}), ((DivTag)TagCreator.div().withClass("message-body")).with((DomContent)((PreTag)TagCreator.pre((String)RbelHtmlRenderer.printRawContentOfElement(el, renderingToolkit)).withId("text-" + id)).withStyle("white-space: pre-wrap;word-wrap: break-word;"))})), ((ButtonTag)TagCreator.button().withClass("modal-close is-large")).attr("aria-label", (Object)"close")})});
    }

    @Nullable
    private static String printRawContentOfElement(RbelElement el, RbelHtmlRenderingToolkit renderingToolkit) {
        if (renderingToolkit.shouldRenderEntitiesWithSize(el.getRawContent().length)) {
            if (BinaryClassifier.isBinary(el.getRawContent())) {
                return Hex.toHexString((byte[])el.getRawContent());
            }
            return el.getRawStringContent();
        }
        return RbelHtmlRenderer.buildOversizeReplacementString(el);
    }

    public static String buildOversizeReplacementString(RbelElement el) {
        return OVERSIZE_REPLACEMENT_TEXT_PRE + (double)(el.getRawContent().length / 10000) / 100.0 + OVERSIZE_REPLACEMENT_TEXT_POST;
    }

    public static void registerFacetRenderer(RbelHtmlFacetRenderer rbelFacetRenderer) {
        htmlRenderer.add(rbelFacetRenderer);
    }

    public String doRender(Collection<RbelElement> elements) {
        return this.performRendering(elements);
    }

    private String performRendering(Collection<RbelElement> elements) {
        RbelHtmlRenderingToolkit renderingToolkit = new RbelHtmlRenderingToolkit(this);
        return renderingToolkit.renderDocument(new ArrayList<RbelElement>(elements));
    }

    public Optional<ContainerTag> convert(RbelElement element, Optional<String> key, RbelHtmlRenderingToolkit renderingToolkit) {
        if (element.getFacets().isEmpty() && ArrayUtils.isEmpty((byte[])element.getRawContent())) {
            return Optional.empty();
        }
        List renderedFacets = htmlRenderer.stream().filter(renderer -> this.renderAsn1Objects || !renderer.getClass().getName().startsWith(RbelAsn1Facet.class.getName())).filter(renderer -> renderer.checkForRendering(element)).sorted(Comparator.comparing(RbelHtmlFacetRenderer::order)).map(renderer -> renderer.performRendering(element, key, renderingToolkit)).collect(Collectors.toList());
        if (renderedFacets.isEmpty()) {
            return Optional.empty();
        }
        if (renderedFacets.size() == 1) {
            return Optional.of((ContainerTag)renderedFacets.get(0));
        }
        return Optional.of(TagCreator.div().with(renderedFacets));
    }

    public String getEmptyPage() {
        return this.performRendering(List.of());
    }

    @Generated
    public RbelValueShader getRbelValueShader() {
        return this.rbelValueShader;
    }

    @Generated
    public boolean isRenderAsn1Objects() {
        return this.renderAsn1Objects;
    }

    @Generated
    public boolean isRenderNestedObjectsWithoutFacetRenderer() {
        return this.renderNestedObjectsWithoutFacetRenderer;
    }

    @Generated
    public int getMaximumEntitySizeInBytes() {
        return this.maximumEntitySizeInBytes;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public String getSubTitle() {
        return this.subTitle;
    }

    @Generated
    public void setRenderAsn1Objects(boolean renderAsn1Objects) {
        this.renderAsn1Objects = renderAsn1Objects;
    }

    @Generated
    public void setRenderNestedObjectsWithoutFacetRenderer(boolean renderNestedObjectsWithoutFacetRenderer) {
        this.renderNestedObjectsWithoutFacetRenderer = renderNestedObjectsWithoutFacetRenderer;
    }

    @Generated
    public void setMaximumEntitySizeInBytes(int maximumEntitySizeInBytes) {
        this.maximumEntitySizeInBytes = maximumEntitySizeInBytes;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setSubTitle(String subTitle) {
        this.subTitle = subTitle;
    }
}

