/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.modifier;

import de.gematik.rbellogger.converter.brainpool.BrainpoolCurves;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.elements.RbelJwtSignature;
import de.gematik.rbellogger.modifier.RbelElementWriter;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.bouncycastle.util.Arrays;

public class RbelJwtSignatureWriter
implements RbelElementWriter {
    public static final byte[] VERIFIED_USING_MARKER = "NewVerifiedUsing: ".getBytes(StandardCharsets.UTF_8);

    @Override
    public boolean canWrite(RbelElement oldTargetElement) {
        return oldTargetElement.hasFacet(RbelJwtSignature.class);
    }

    @Override
    public byte[] write(RbelElement oldTargetElement, RbelElement oldTargetModifiedChild, byte[] newContent) {
        if (oldTargetElement.getFacetOrFail(RbelJwtSignature.class).getVerifiedUsing() == oldTargetModifiedChild) {
            return Arrays.concatenate((byte[])VERIFIED_USING_MARKER, (byte[])newContent);
        }
        return newContent;
    }

    @Generated
    public RbelJwtSignatureWriter() {
    }

    static {
        BrainpoolCurves.init();
    }
}

