/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.data.facet;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelMultiMap;
import de.gematik.rbellogger.data.facet.RbelFacet;
import de.gematik.rbellogger.data.facet.RbelRootFacet;
import de.gematik.rbellogger.renderer.RbelHtmlFacetRenderer;
import de.gematik.rbellogger.renderer.RbelHtmlRenderer;
import de.gematik.rbellogger.renderer.RbelHtmlRenderingToolkit;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import j2html.tags.Text;
import j2html.tags.specialized.DivTag;
import java.beans.ConstructorProperties;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;

public class RbelXmlFacet
implements RbelFacet {
    private final RbelMultiMap childElements;

    @Override
    public RbelMultiMap getChildElements() {
        return this.childElements;
    }

    @Generated
    private static RbelMultiMap $default$childElements() {
        return new RbelMultiMap();
    }

    @ConstructorProperties(value={"childElements"})
    @Generated
    RbelXmlFacet(RbelMultiMap childElements) {
        this.childElements = childElements;
    }

    @Generated
    public static RbelXmlFacetBuilder builder() {
        return new RbelXmlFacetBuilder();
    }

    @Generated
    public RbelXmlFacetBuilder toBuilder() {
        return new RbelXmlFacetBuilder().childElements(this.childElements);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RbelXmlFacet)) {
            return false;
        }
        RbelXmlFacet other = (RbelXmlFacet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RbelMultiMap this$childElements = this.getChildElements();
        RbelMultiMap other$childElements = other.getChildElements();
        return !(this$childElements == null ? other$childElements != null : !((Object)this$childElements).equals(other$childElements));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RbelXmlFacet;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RbelMultiMap $childElements = this.getChildElements();
        result = result * 59 + ($childElements == null ? 43 : ((Object)$childElements).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RbelXmlFacet(childElements=" + this.getChildElements() + ")";
    }

    static {
        RbelHtmlRenderer.registerFacetRenderer(new RbelHtmlFacetRenderer(){

            @Override
            public boolean checkForRendering(RbelElement element) {
                return element.hasFacet(RbelXmlFacet.class) && element.getFacet(RbelRootFacet.class).filter(root -> root.getRootFacet() instanceof RbelXmlFacet).isPresent();
            }

            @Override
            public ContainerTag performRendering(RbelElement element, Optional<String> key, RbelHtmlRenderingToolkit renderingToolkit) {
                String formattedXml = RbelHtmlRenderingToolkit.prettyPrintXml(element.getRawStringContent());
                for (Map.Entry<UUID, RbelHtmlRenderingToolkit.JsonNoteEntry> entry : renderingToolkit.getNoteTags().entrySet()) {
                    if (formattedXml.contains(entry.getValue().getStringToMatch() + ",")) {
                        formattedXml = formattedXml.replace(entry.getValue().getStringToMatch() + ",", entry.getValue().getTagForKeyReplacement().render() + "," + entry.getValue().getTagForValueReplacement().render());
                        continue;
                    }
                    if (!formattedXml.contains(entry.getValue().getStringToMatch())) continue;
                    formattedXml = formattedXml.replace(entry.getValue().getStringToMatch(), entry.getValue().getTagForKeyReplacement().render() + entry.getValue().getTagForValueReplacement().render());
                }
                return RbelHtmlRenderingToolkit.ancestorTitle().with((DomContent)RbelHtmlRenderingToolkit.vertParentTitle().with((DomContent)((DivTag)((DivTag)TagCreator.div().withClass("tile is-child pr-3")).with((DomContent)TagCreator.pre((DomContent[])new DomContent[]{new Text(formattedXml)}).withClass("json"))).with(renderingToolkit.convertNested(element))));
            }
        });
    }

    @Generated
    public static class RbelXmlFacetBuilder {
        @Generated
        private boolean childElements$set;
        @Generated
        private RbelMultiMap childElements$value;

        @Generated
        RbelXmlFacetBuilder() {
        }

        @Generated
        public RbelXmlFacetBuilder childElements(RbelMultiMap childElements) {
            this.childElements$value = childElements;
            this.childElements$set = true;
            return this;
        }

        @Generated
        public RbelXmlFacet build() {
            RbelMultiMap childElements$value = this.childElements$value;
            if (!this.childElements$set) {
                childElements$value = RbelXmlFacet.$default$childElements();
            }
            return new RbelXmlFacet(childElements$value);
        }

        @Generated
        public String toString() {
            return "RbelXmlFacet.RbelXmlFacetBuilder(childElements$value=" + this.childElements$value + ")";
        }
    }
}

