/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.data;

import de.gematik.rbellogger.data.RbelElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;

public class RbelMultiMap
implements Map<String, RbelElement> {
    public static final Collector<Map.Entry<String, RbelElement>, RbelMultiMap, RbelMultiMap> COLLECTOR = Collector.of(RbelMultiMap::new, RbelMultiMap::put, (m1, m2) -> {
        m1.putAll((Map)m2);
        return m1;
    }, new Collector.Characteristics[0]);
    private final List<Map.Entry<String, RbelElement>> values = new ArrayList<Map.Entry<String, RbelElement>>();

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.values.stream().anyMatch(entry -> ((String)entry.getKey()).equals(key));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values.stream().anyMatch(entry -> ((RbelElement)entry.getValue()).equals(value));
    }

    @Override
    public RbelElement get(Object key) {
        return this.values.stream().filter(entry -> ((String)entry.getKey()).equals(key)).map(Map.Entry::getValue).findFirst().orElse(null);
    }

    @Override
    public RbelElement put(String key, RbelElement value) {
        this.values.add((Map.Entry<String, RbelElement>)Pair.of((Object)key, (Object)value));
        return null;
    }

    public RbelElement put(Map.Entry<String, RbelElement> value) {
        this.values.add(value);
        return null;
    }

    @Override
    public RbelElement remove(Object key) {
        return this.removeAll(key.toString()).stream().findFirst().orElse(null);
    }

    public List<RbelElement> removeAll(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        Iterator<Map.Entry<String, RbelElement>> iterator = this.values.iterator();
        ArrayList<RbelElement> removed = new ArrayList<RbelElement>();
        while (iterator.hasNext()) {
            Map.Entry<String, RbelElement> entry = iterator.next();
            if (!key.equals(entry.getKey())) continue;
            iterator.remove();
            removed.add(entry.getValue());
        }
        return removed;
    }

    @Override
    public void putAll(Map m) {
        Iterator iterator = m.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entryRaw;
            Map.Entry entry = entryRaw = iterator.next();
            this.values.add((Map.Entry<String, RbelElement>)Pair.of((Object)((String)entry.getKey()), (Object)((RbelElement)entry.getValue())));
        }
    }

    @Override
    public void clear() {
        this.values.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.values.stream().map(Map.Entry::getKey).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    @Deprecated
    public Collection<RbelElement> values() {
        return this.stream().map(Map.Entry::getValue).collect(Collectors.toUnmodifiableList());
    }

    @Override
    @Deprecated
    public Set<Map.Entry<String, RbelElement>> entrySet() {
        return this.stream().collect(Collectors.toUnmodifiableSet());
    }

    public Stream<Map.Entry<String, RbelElement>> stream() {
        return this.values.stream();
    }

    public RbelMultiMap with(String key, RbelElement value) {
        this.put(key, value);
        return this;
    }

    public RbelMultiMap withSkipIfNull(String key, RbelElement value) {
        if (value != null) {
            this.put(key, value);
        }
        return this;
    }

    public List<RbelElement> getAll(String key) {
        return this.values.stream().filter(entry -> ((String)entry.getKey()).equals(key)).map(Map.Entry::getValue).collect(Collectors.toUnmodifiableList());
    }

    public Iterator<Map.Entry<String, RbelElement>> iterator() {
        return this.values.listIterator();
    }

    @Generated
    public RbelMultiMap() {
    }

    @Generated
    public List<Map.Entry<String, RbelElement>> getValues() {
        return this.values;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RbelMultiMap)) {
            return false;
        }
        RbelMultiMap other = (RbelMultiMap)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Map.Entry<String, RbelElement>> this$values = this.getValues();
        List<Map.Entry<String, RbelElement>> other$values = other.getValues();
        return !(this$values == null ? other$values != null : !((Object)this$values).equals(other$values));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RbelMultiMap;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Map.Entry<String, RbelElement>> $values = this.getValues();
        result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RbelMultiMap(values=" + this.getValues() + ")";
    }
}

