/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.converter.listener;

import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.converter.RbelConverterPlugin;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.facet.RbelJsonFacet;
import de.gematik.rbellogger.data.facet.RbelListFacet;
import de.gematik.rbellogger.data.facet.RbelNoteFacet;
import de.gematik.rbellogger.key.RbelKey;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.lang.JoseException;

public class RbelJwkReader
implements RbelConverterPlugin {
    @Override
    public void consumeElement(RbelElement rbelElement, RbelConverter converter) {
        List keysList = Optional.of(rbelElement).filter(element -> element.hasFacet(RbelJsonFacet.class)).map(element -> element.getAll("keys")).stream().flatMap(Collection::stream).filter(el -> el.hasFacet(RbelJsonFacet.class)).filter(el -> el.hasFacet(RbelListFacet.class)).map(el -> el.getFacet(RbelListFacet.class)).filter(Optional::isPresent).map(Optional::get).map(RbelListFacet::getChildNodes).flatMap(Collection::stream).collect(Collectors.toList());
        for (RbelElement keyElement : keysList) {
            this.tryToConvertKeyAndAddToKeyManager(keyElement, converter);
        }
    }

    private void tryToConvertKeyAndAddToKeyManager(RbelElement keyElement, RbelConverter converter) {
        try {
            JsonWebKey jwk = JsonWebKey.Factory.newJwk((String)keyElement.getRawStringContent());
            converter.getRbelKeyManager().addKey(RbelKey.builder().key(jwk.getKey()).keyName(jwk.getKeyId()).precedence(200).build());
        }
        catch (RuntimeException | JoseException e) {
            keyElement.addFacet(RbelNoteFacet.builder().value("Unable to parse key: " + e.getMessage()).style(RbelNoteFacet.NoteStyling.WARN).build());
        }
    }
}

