/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.converter.listener;

import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.converter.RbelConverterPlugin;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.facet.RbelTcpIpMessageFacet;
import de.gematik.rbellogger.util.RbelFileWriter;
import de.gematik.test.tiger.common.data.config.tigerProxy.TigerFileSaveInfo;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class RbelFileAppenderPlugin
implements RbelConverterPlugin {
    private final TigerFileSaveInfo fileSaveInfo;
    private final RbelFileWriter rbelFileWriter;

    public RbelFileAppenderPlugin(TigerFileSaveInfo fileSaveInfo, RbelConverter rbelConverter) {
        this.fileSaveInfo = fileSaveInfo;
        this.rbelFileWriter = new RbelFileWriter(rbelConverter);
        if (fileSaveInfo.isWriteToFile() && StringUtils.isNotEmpty((CharSequence)fileSaveInfo.getFilename()) && fileSaveInfo.isClearFileOnBoot()) {
            FileUtils.deleteQuietly((File)new File(fileSaveInfo.getFilename()));
        }
    }

    @Override
    public void consumeElement(RbelElement rbelElement, RbelConverter converter) {
        if (this.fileSaveInfo.isWriteToFile() && StringUtils.isNotEmpty((CharSequence)this.fileSaveInfo.getFilename()) && rbelElement.hasFacet(RbelTcpIpMessageFacet.class)) {
            try {
                FileUtils.writeStringToFile((File)new File(this.fileSaveInfo.getFilename()), (String)this.rbelFileWriter.convertToRbelFileString(rbelElement), (Charset)StandardCharsets.UTF_8, (boolean)true);
            }
            catch (IOException e) {
                throw new RuntimeException("Exception while trying to save RbelElement to file '" + this.fileSaveInfo.getFilename() + "'!", e);
            }
        }
    }

    @Generated
    public TigerFileSaveInfo getFileSaveInfo() {
        return this.fileSaveInfo;
    }

    @Generated
    public RbelFileWriter getRbelFileWriter() {
        return this.rbelFileWriter;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RbelFileAppenderPlugin)) {
            return false;
        }
        RbelFileAppenderPlugin other = (RbelFileAppenderPlugin)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TigerFileSaveInfo this$fileSaveInfo = this.getFileSaveInfo();
        TigerFileSaveInfo other$fileSaveInfo = other.getFileSaveInfo();
        if (this$fileSaveInfo == null ? other$fileSaveInfo != null : !this$fileSaveInfo.equals(other$fileSaveInfo)) {
            return false;
        }
        RbelFileWriter this$rbelFileWriter = this.getRbelFileWriter();
        RbelFileWriter other$rbelFileWriter = other.getRbelFileWriter();
        return !(this$rbelFileWriter == null ? other$rbelFileWriter != null : !this$rbelFileWriter.equals(other$rbelFileWriter));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RbelFileAppenderPlugin;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TigerFileSaveInfo $fileSaveInfo = this.getFileSaveInfo();
        result = result * 59 + ($fileSaveInfo == null ? 43 : $fileSaveInfo.hashCode());
        RbelFileWriter $rbelFileWriter = this.getRbelFileWriter();
        result = result * 59 + ($rbelFileWriter == null ? 43 : $rbelFileWriter.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RbelFileAppenderPlugin(fileSaveInfo=" + this.getFileSaveInfo() + ", rbelFileWriter=" + this.getRbelFileWriter() + ")";
    }
}

