/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.converter;

import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.converter.RbelConverterPlugin;
import de.gematik.rbellogger.converter.RbelHtmlConverter;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelMultiMap;
import de.gematik.rbellogger.data.facet.RbelRootFacet;
import de.gematik.rbellogger.data.facet.RbelXmlFacet;
import de.gematik.rbellogger.util.RbelException;
import java.io.IOException;
import java.io.StringReader;
import java.util.Map;
import lombok.Generated;
import org.dom4j.Attribute;
import org.dom4j.Branch;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Text;
import org.dom4j.io.SAXReader;
import org.dom4j.tree.AbstractBranch;
import org.dom4j.tree.DefaultComment;
import org.jsoup.nodes.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RbelXmlConverter
implements RbelConverterPlugin {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelXmlConverter.class);
    private static final String XML_TEXT_KEY = "text";
    private RbelHtmlConverter htmlConverter = new RbelHtmlConverter();

    @Override
    public void consumeElement(RbelElement rbel, RbelConverter context) {
        String content = rbel.getRawStringContent();
        if (content.contains("<") && content.contains(">")) {
            try {
                InputSource source = this.buildInputSource(content.trim(), rbel);
                this.buildXmlElementForNode(this.parseXml(source), rbel, context);
                rbel.addFacet(new RbelRootFacet<RbelXmlFacet>(rbel.getFacetOrFail(RbelXmlFacet.class)));
            }
            catch (DocumentException e) {
                log.trace("Exception while trying to parse XML. Trying as HTML (more lenient SAX parsing)", (Throwable)e);
                try {
                    this.htmlConverter.parseHtml(content.trim()).ifPresent(document -> {
                        this.htmlConverter.buildXmlElementForNode((Node)document, rbel, context);
                        rbel.addFacet(new RbelRootFacet<RbelXmlFacet>(rbel.getFacetOrFail(RbelXmlFacet.class)));
                    });
                }
                catch (IOException | SAXException e2) {
                    log.trace("Exception while trying to parse XML. Skipping", (Throwable)e);
                }
            }
        }
    }

    private Branch parseXml(InputSource source) throws DocumentException {
        SAXReader reader = new SAXReader();
        reader.setMergeAdjacentText(true);
        return reader.read(source);
    }

    private InputSource buildInputSource(String text, RbelElement parentElement) {
        InputSource source = new InputSource(new StringReader(text));
        source.setEncoding(parentElement.getElementCharset().name());
        return source;
    }

    private void buildXmlElementForNode(Branch branch, RbelElement parentElement, RbelConverter converter) {
        RbelMultiMap childElements = new RbelMultiMap();
        parentElement.addFacet(RbelXmlFacet.builder().childElements(childElements).build());
        for (Object child : branch.content()) {
            if (child instanceof Text) {
                childElements.put(XML_TEXT_KEY, converter.convertElement(((Text)child).getText(), parentElement));
                continue;
            }
            if (child instanceof AbstractBranch) {
                RbelElement element = new RbelElement(((AbstractBranch)child).asXML().getBytes(parentElement.getElementCharset()), parentElement);
                this.buildXmlElementForNode((Branch)((AbstractBranch)child), element, converter);
                childElements.put(((AbstractBranch)child).getName(), element);
                continue;
            }
            if (child instanceof Namespace) {
                String childXmlName = ((Namespace)child).getPrefix();
                childElements.put(childXmlName, converter.convertElement(((Namespace)child).getText(), parentElement));
                continue;
            }
            if (child instanceof DefaultComment) continue;
            throw new RbelException("Could not convert XML element of type " + child.getClass().getSimpleName());
        }
        if (childElements.stream().map(Map.Entry::getKey).noneMatch(key -> key.equals(XML_TEXT_KEY))) {
            childElements.put(XML_TEXT_KEY, new RbelElement(new byte[0], parentElement));
        }
        if (branch instanceof Element) {
            for (Attribute attribute : ((Element)branch).attributes()) {
                childElements.put(attribute.getName(), converter.convertElement(attribute.getText(), parentElement));
            }
        }
    }
}

