/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.converter;

import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.converter.RbelConverterPlugin;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.facet.RbelX509Facet;
import de.gematik.rbellogger.util.CryptoLoader;
import java.security.cert.X509Certificate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Base64;
import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbelX509Converter
implements RbelConverterPlugin {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelX509Converter.class);
    private static final ZoneId utcZone = ZoneId.of("UTC");

    @Override
    public void consumeElement(RbelElement element, RbelConverter context) {
        this.tryConversion(element, () -> element.getRawContent());
        this.tryConversion(element, () -> Base64.getDecoder().decode(element.getRawContent()));
    }

    private void tryConversion(RbelElement element, Supplier<byte[]> binaryContentExtractor) {
        try {
            X509Certificate certificate = CryptoLoader.getCertificateFromPem((byte[])binaryContentExtractor.get());
            element.addFacet(RbelX509Facet.builder().serialnumber(certificate.getSerialNumber().toString()).issuer(certificate.getIssuerDN().getName()).validFrom(ZonedDateTime.ofInstant(certificate.getNotBefore().toInstant(), utcZone)).validUntil(ZonedDateTime.ofInstant(certificate.getNotAfter().toInstant(), utcZone)).subject(certificate.getSubjectDN().getName()).parent(element).build());
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

