/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.converter;

import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.converter.RbelConverterPlugin;
import de.gematik.rbellogger.converter.brainpool.BrainpoolCurves;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.elements.RbelJwtSignature;
import de.gematik.rbellogger.data.facet.RbelJwtFacet;
import de.gematik.rbellogger.data.facet.RbelRootFacet;
import de.gematik.rbellogger.data.facet.RbelValueFacet;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Optional;
import lombok.Generated;
import org.jose4j.jca.ProviderContext;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.lang.JoseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbelJwtConverter
implements RbelConverterPlugin {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelJwtConverter.class);

    @Override
    public void consumeElement(RbelElement rbelElement, RbelConverter converter) {
        try {
            JsonWebSignature jsonWebSignature = this.initializeJws(rbelElement);
            RbelElement headerElement = converter.convertElement(jsonWebSignature.getHeaders().getFullHeaderAsJsonString().getBytes(StandardCharsets.UTF_8), rbelElement);
            RbelElement bodyElement = converter.convertElement(jsonWebSignature.getUnverifiedPayloadBytes(), rbelElement);
            RbelElement signatureElement = new RbelElement(Base64.getUrlDecoder().decode(jsonWebSignature.getEncodedSignature()), rbelElement);
            signatureElement.addFacet(converter.getRbelKeyManager().getAllKeys().map(rbelKey -> this.verifySig(jsonWebSignature, rbelKey.getKey(), rbelKey.getKeyName(), signatureElement)).filter(Optional::isPresent).map(Optional::get).findAny().or(() -> this.tryToGetKeyFromX5cHeaderClaim(jsonWebSignature).map(key -> this.verifySig(jsonWebSignature, (Key)key, "x5c-header certificate", signatureElement)).filter(Optional::isPresent).map(Optional::get)).orElseGet(() -> RbelJwtSignature.builder().isValid(new RbelElement(null, signatureElement).addFacet(new RbelValueFacet<Boolean>(false))).verifiedUsing(null).build()));
            RbelJwtFacet rbelJwtFacet = new RbelJwtFacet(headerElement, bodyElement, signatureElement);
            rbelElement.addFacet(rbelJwtFacet);
            rbelElement.addFacet(new RbelRootFacet<RbelJwtFacet>(rbelJwtFacet));
        }
        catch (JoseException e) {
            return;
        }
    }

    private Optional<PublicKey> tryToGetKeyFromX5cHeaderClaim(JsonWebSignature jsonWebSignature) {
        return Optional.ofNullable(jsonWebSignature.getCertificateChainHeaderValue()).map(list -> (X509Certificate)list.get(0)).map(Certificate::getPublicKey);
    }

    private JsonWebSignature initializeJws(RbelElement rbel) throws JoseException {
        JsonWebSignature jsonWebSignature = new JsonWebSignature();
        ProviderContext context = new ProviderContext();
        context.getSuppliedKeyProviderContext().setGeneralProvider("BC");
        jsonWebSignature.setProviderContext(context);
        jsonWebSignature.setCompactSerialization(rbel.getRawStringContent());
        return jsonWebSignature;
    }

    private Optional<RbelJwtSignature> verifySig(JsonWebSignature jsonWebSignature, Key key, String keyId, RbelElement signatureElement) {
        try {
            jsonWebSignature.setKey(key);
            this.tryToGetKeyFromX5cHeaderClaim(jsonWebSignature);
            if (jsonWebSignature.verifySignature()) {
                return Optional.of(RbelJwtSignature.builder().isValid(new RbelElement(null, signatureElement).addFacet(new RbelValueFacet<Boolean>(true))).verifiedUsing(new RbelElement(null, signatureElement).addFacet(new RbelValueFacet<String>(keyId))).build());
            }
            return Optional.empty();
        }
        catch (JoseException e) {
            return Optional.empty();
        }
    }

    static {
        BrainpoolCurves.init();
    }
}

