/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.converter;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.converter.RbelConverterPlugin;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelMultiMap;
import de.gematik.rbellogger.data.facet.RbelJsonFacet;
import de.gematik.rbellogger.data.facet.RbelListFacet;
import de.gematik.rbellogger.data.facet.RbelMapFacet;
import de.gematik.rbellogger.data.facet.RbelNestedFacet;
import de.gematik.rbellogger.data.facet.RbelRootFacet;
import de.gematik.rbellogger.data.facet.RbelValueFacet;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;

public class RbelJsonConverter
implements RbelConverterPlugin {
    public Optional<JsonElement> convertToJson(String content) {
        if (content.contains("{") && content.contains("}") || content.contains("[") && content.contains("]")) {
            try {
                return Optional.of(JsonParser.parseString((String)content));
            }
            catch (Exception e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    @Override
    public void consumeElement(RbelElement rbelElement, RbelConverter converter) {
        Optional<JsonElement> jsonOptional = this.convertToJson(rbelElement.getRawStringContent());
        if (jsonOptional.isEmpty()) {
            return;
        }
        if (jsonOptional.get().isJsonObject() || jsonOptional.get().isJsonArray()) {
            this.augmentRbelElementWithJsonFacet(jsonOptional.get(), converter, rbelElement);
            rbelElement.addFacet(new RbelRootFacet<RbelJsonFacet>(rbelElement.getFacetOrFail(RbelJsonFacet.class)));
        }
    }

    private void augmentRbelElementWithJsonFacet(JsonElement jsonElement, RbelConverter context, RbelElement parentElement) {
        parentElement.addFacet(RbelJsonFacet.builder().jsonElement(jsonElement).build());
        if (jsonElement.isJsonObject()) {
            RbelMultiMap elementMap = new RbelMultiMap();
            parentElement.addFacet(RbelMapFacet.builder().childNodes(elementMap).build());
            for (Map.Entry entry : jsonElement.getAsJsonObject().entrySet()) {
                RbelElement newChild = new RbelElement(((JsonElement)entry.getValue()).toString().getBytes(parentElement.getElementCharset()), parentElement);
                this.augmentRbelElementWithJsonFacet((JsonElement)entry.getValue(), context, newChild);
                elementMap.put((String)entry.getKey(), newChild);
            }
        } else if (jsonElement.isJsonArray()) {
            ArrayList<RbelElement> elementList = new ArrayList<RbelElement>();
            parentElement.addFacet(RbelListFacet.builder().childNodes(elementList).build());
            for (JsonElement el : jsonElement.getAsJsonArray()) {
                RbelElement newChild = new RbelElement(el.toString().getBytes(parentElement.getElementCharset()), parentElement);
                this.augmentRbelElementWithJsonFacet(el, context, newChild);
                elementList.add(newChild);
            }
        } else if (jsonElement.isJsonPrimitive()) {
            if (jsonElement.getAsJsonPrimitive().isString()) {
                this.addFacetAndConvertNestedElement(parentElement, jsonElement.getAsString(), context);
            } else if (jsonElement.getAsJsonPrimitive().isNumber()) {
                this.addFacetAndConvertNestedElement(parentElement, jsonElement.getAsLong(), context);
            } else if (jsonElement.getAsJsonPrimitive().isBoolean()) {
                this.addFacetAndConvertNestedElement(parentElement, jsonElement.getAsBoolean(), context);
            }
        } else {
            parentElement.addFacet(RbelValueFacet.builder().value(null).build());
        }
    }

    private void addFacetAndConvertNestedElement(RbelElement parentElement, Object value, RbelConverter context) {
        RbelElement nestedElement = RbelElement.wrap(parentElement, value);
        context.convertElement(nestedElement);
        parentElement.addFacet(new RbelNestedFacet(nestedElement));
    }
}

