/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.converter;

import de.gematik.rbellogger.converter.RbelBase64JsonConverter;
import de.gematik.rbellogger.converter.RbelBearerTokenConverter;
import de.gematik.rbellogger.converter.RbelBundleCriterion;
import de.gematik.rbellogger.converter.RbelConverterPlugin;
import de.gematik.rbellogger.converter.RbelErpVauDecrpytionConverter;
import de.gematik.rbellogger.converter.RbelHttpFormDataConverter;
import de.gematik.rbellogger.converter.RbelHttpRequestConverter;
import de.gematik.rbellogger.converter.RbelHttpResponseConverter;
import de.gematik.rbellogger.converter.RbelJsonConverter;
import de.gematik.rbellogger.converter.RbelJweConverter;
import de.gematik.rbellogger.converter.RbelJwtConverter;
import de.gematik.rbellogger.converter.RbelMtomConverter;
import de.gematik.rbellogger.converter.RbelSicctCommandConverter;
import de.gematik.rbellogger.converter.RbelSicctEnvelopeConverter;
import de.gematik.rbellogger.converter.RbelUriConverter;
import de.gematik.rbellogger.converter.RbelValueShader;
import de.gematik.rbellogger.converter.RbelVauEpaConverter;
import de.gematik.rbellogger.converter.RbelVauKeyDeriver;
import de.gematik.rbellogger.converter.RbelX509Converter;
import de.gematik.rbellogger.converter.RbelXmlConverter;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelHostname;
import de.gematik.rbellogger.data.facet.RbelHostnameFacet;
import de.gematik.rbellogger.data.facet.RbelHttpRequestFacet;
import de.gematik.rbellogger.data.facet.RbelHttpResponseFacet;
import de.gematik.rbellogger.data.facet.RbelMessageTimingFacet;
import de.gematik.rbellogger.data.facet.RbelNoteFacet;
import de.gematik.rbellogger.data.facet.RbelTcpIpMessageFacet;
import de.gematik.rbellogger.key.RbelKeyManager;
import java.beans.ConstructorProperties;
import java.nio.charset.StandardCharsets;
import java.security.Provider;
import java.security.Security;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbelConverter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelConverter.class);
    private int rbelBufferSizeInMb;
    private boolean manageBuffer;
    private final Deque<RbelElement> messageHistory = new ConcurrentLinkedDeque<RbelElement>();
    private final List<RbelBundleCriterion> bundleCriterionList = new ArrayList<RbelBundleCriterion>();
    private final RbelKeyManager rbelKeyManager;
    private final RbelValueShader rbelValueShader = new RbelValueShader();
    private final List<RbelConverterPlugin> postConversionListeners = new ArrayList<RbelConverterPlugin>();
    private final Map<Class<? extends RbelElement>, List<BiFunction<RbelElement, RbelConverter, RbelElement>>> preConversionMappers = new HashMap<Class<? extends RbelElement>, List<BiFunction<RbelElement, RbelConverter, RbelElement>>>();
    private final List<RbelConverterPlugin> converterPlugins = new ArrayList<RbelConverterPlugin>(List.of(new RbelBase64JsonConverter(), new RbelUriConverter(), new RbelHttpResponseConverter(), new RbelHttpRequestConverter(), new RbelJwtConverter(), new RbelHttpFormDataConverter(), new RbelJweConverter(), new RbelErpVauDecrpytionConverter(), new RbelBearerTokenConverter(), new RbelXmlConverter(), new RbelJsonConverter(), new RbelVauKeyDeriver(), new RbelMtomConverter(), new RbelX509Converter(), new RbelSicctEnvelopeConverter(), new RbelSicctCommandConverter(), new RbelVauEpaConverter()));
    private long messageSequenceNumber;
    private int skipParsingWhenMessageLargerThanKb;

    public RbelElement convertElement(byte[] input, RbelElement parentNode) {
        return this.convertElement(RbelElement.builder().parentNode(parentNode).rawContent(input).build());
    }

    public RbelElement convertElement(String input, RbelElement parentNode) {
        return this.convertElement(RbelElement.builder().parentNode(parentNode).rawContent(input.getBytes(Optional.ofNullable(parentNode).map(RbelElement::getElementCharset).orElse(StandardCharsets.UTF_8))).build());
    }

    public RbelElement convertElement(RbelElement rawInput) {
        log.trace("Converting {}...", (Object)rawInput);
        RbelElement convertedInput = this.filterInputThroughPreConversionMappers(rawInput);
        boolean elementIsOversized = this.skipParsingWhenMessageLargerThanKb > -1 && convertedInput.getRawContent().length > this.skipParsingWhenMessageLargerThanKb * 1024;
        for (RbelConverterPlugin plugin : this.converterPlugins) {
            if (!plugin.ignoreOversize() && elementIsOversized) continue;
            try {
                plugin.consumeElement(convertedInput, this);
            }
            catch (RuntimeException e) {
                String msg = "Exception during conversion with plugin '" + plugin.getClass().getName() + "' (" + e.getMessage() + ")";
                log.info(msg, (Throwable)e);
                if (log.isDebugEnabled()) {
                    log.debug("Content in failed conversion-attempt was (B64-encoded) {}", (Object)Base64.getEncoder().encodeToString(rawInput.getRawContent()));
                    if (rawInput.getParentNode() != null) {
                        log.debug("Parent-Content in failed conversion-attempt was (B64-encoded) {}", (Object)Base64.getEncoder().encodeToString(rawInput.getParentNode().getRawContent()));
                    }
                }
                rawInput.addFacet(new RbelNoteFacet(msg, RbelNoteFacet.NoteStyling.ERROR));
            }
        }
        return convertedInput;
    }

    private Optional<RbelElement> findLastRequest() {
        Iterator<RbelElement> iterator = this.messageHistory.descendingIterator();
        while (iterator.hasNext()) {
            RbelElement element = iterator.next();
            if (!element.hasFacet(RbelHttpRequestFacet.class)) continue;
            return Optional.ofNullable(element);
        }
        return Optional.empty();
    }

    public RbelElement filterInputThroughPreConversionMappers(RbelElement input) {
        RbelElement value = input;
        for (BiFunction mapper : this.preConversionMappers.entrySet().stream().filter(entry -> input.getClass().isAssignableFrom((Class)entry.getKey())).map(Map.Entry::getValue).flatMap(Collection::stream).collect(Collectors.toList())) {
            RbelElement newValue = (RbelElement)mapper.apply(value, this);
            if (newValue == value) continue;
            value = this.filterInputThroughPreConversionMappers(newValue);
        }
        return value;
    }

    public void registerListener(RbelConverterPlugin listener) {
        this.postConversionListeners.add(listener);
    }

    public void triggerPostConversionListenerFor(RbelElement element) {
        for (RbelConverterPlugin postConversionListener : this.postConversionListeners) {
            postConversionListener.consumeElement(element, this);
        }
    }

    public void registerMapper(Class<? extends RbelElement> clazz, BiFunction<RbelElement, RbelConverter, RbelElement> mapper) {
        this.preConversionMappers.computeIfAbsent(clazz, key -> new ArrayList()).add(mapper);
    }

    public void addConverter(RbelConverterPlugin converter) {
        this.converterPlugins.add(converter);
    }

    public RbelElement parseMessage(@NonNull byte[] content, RbelHostname sender, RbelHostname receiver, Optional<ZonedDateTime> transmissionTime) {
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        RbelElement rbelMessage = this.convertElement(content, null);
        return this.doMessagePostConversion(rbelMessage, sender, receiver, transmissionTime);
    }

    public RbelElement parseMessage(@NonNull RbelElement rbelElement, RbelHostname sender, RbelHostname receiver, Optional<ZonedDateTime> transmissionTime) {
        if (rbelElement == null) {
            throw new NullPointerException("rbelElement is marked non-null but is null");
        }
        RbelElement rbelMessage = this.convertElement(rbelElement);
        return this.doMessagePostConversion(rbelMessage, sender, receiver, transmissionTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RbelElement doMessagePostConversion(@NonNull RbelElement rbelElement, RbelHostname sender, RbelHostname receiver, Optional<ZonedDateTime> transmissionTime) {
        if (rbelElement == null) {
            throw new NullPointerException("rbelElement is marked non-null but is null");
        }
        if (rbelElement.getFacet(RbelHttpResponseFacet.class).map(resp -> resp.getRequest() == null).orElse(false).booleanValue()) {
            Optional<RbelElement> request = this.findLastRequest();
            rbelElement.addOrReplaceFacet(rbelElement.getFacet(RbelHttpResponseFacet.class).map(RbelHttpResponseFacet::toBuilder).orElse(RbelHttpResponseFacet.builder()).request(request.orElse(null)).build());
            request.flatMap(req -> req.getFacet(RbelHttpRequestFacet.class)).ifPresent(reqFacet -> ((RbelElement)request.get()).addOrReplaceFacet(reqFacet.toBuilder().response(rbelElement).build()));
        }
        rbelElement.addFacet(RbelTcpIpMessageFacet.builder().receiver(RbelHostnameFacet.buildRbelHostnameFacet(rbelElement, receiver)).sender(RbelHostnameFacet.buildRbelHostnameFacet(rbelElement, sender)).sequenceNumber(this.messageSequenceNumber++).build());
        transmissionTime.ifPresent(tt -> rbelElement.addFacet(RbelMessageTimingFacet.builder().transmissionTime((ZonedDateTime)tt).build()));
        rbelElement.triggerPostConversionListener(this);
        Deque<RbelElement> deque = this.messageHistory;
        synchronized (deque) {
            this.messageHistory.add(rbelElement);
        }
        this.manageRbelBufferSize();
        return rbelElement;
    }

    public RbelConverter addPostConversionListener(RbelConverterPlugin postConversionListener) {
        this.postConversionListeners.add(postConversionListener);
        return this;
    }

    public void removeAllConverterPlugins() {
        this.converterPlugins.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void manageRbelBufferSize() {
        if (this.manageBuffer) {
            Deque<RbelElement> deque = this.messageHistory;
            synchronized (deque) {
                if (this.getRbelBufferSizeInMb() <= 0 && !this.getMessageHistory().isEmpty()) {
                    this.getMessageHistory().clear();
                }
                if (this.getRbelBufferSizeInMb() > 0) {
                    long size = this.getMessageHistorySize();
                    long exceedingLimit = this.getExceedingLimit(size);
                    if (exceedingLimit > 0L) {
                        log.trace("Buffer is currently at {} Mb which exceeds the limit of {} Mb", (Object)(size / 1026L), (Object)this.getRbelBufferSizeInMb());
                    }
                    while (exceedingLimit > 0L && !this.getMessageHistory().isEmpty()) {
                        log.trace("Exceeded buffer size, dropping oldest message in history");
                        exceedingLimit -= this.getMessageHistory().getFirst().getSize();
                        this.getMessageHistory().remove(0);
                    }
                }
            }
        }
    }

    private long getMessageHistorySize() {
        return this.getMessageHistory().stream().mapToLong(RbelElement::getSize).sum();
    }

    private long getExceedingLimit(long messageHistorySize) {
        return messageHistorySize - (long)this.getRbelBufferSizeInMb() * 1024L * 1024L;
    }

    @Generated
    private static int $default$rbelBufferSizeInMb() {
        return 1024;
    }

    @Generated
    private static boolean $default$manageBuffer() {
        return false;
    }

    @Generated
    private static long $default$messageSequenceNumber() {
        return 0L;
    }

    @Generated
    private static int $default$skipParsingWhenMessageLargerThanKb() {
        return -1;
    }

    @Generated
    public static RbelConverterBuilder builder() {
        return new RbelConverterBuilder();
    }

    @ConstructorProperties(value={"rbelBufferSizeInMb", "manageBuffer", "rbelKeyManager", "messageSequenceNumber", "skipParsingWhenMessageLargerThanKb"})
    @Generated
    private RbelConverter(int rbelBufferSizeInMb, boolean manageBuffer, RbelKeyManager rbelKeyManager, long messageSequenceNumber, int skipParsingWhenMessageLargerThanKb) {
        this.rbelBufferSizeInMb = rbelBufferSizeInMb;
        this.manageBuffer = manageBuffer;
        this.rbelKeyManager = rbelKeyManager;
        this.messageSequenceNumber = messageSequenceNumber;
        this.skipParsingWhenMessageLargerThanKb = skipParsingWhenMessageLargerThanKb;
    }

    @Generated
    public int getRbelBufferSizeInMb() {
        return this.rbelBufferSizeInMb;
    }

    @Generated
    public boolean isManageBuffer() {
        return this.manageBuffer;
    }

    @Generated
    public Deque<RbelElement> getMessageHistory() {
        return this.messageHistory;
    }

    @Generated
    public List<RbelBundleCriterion> getBundleCriterionList() {
        return this.bundleCriterionList;
    }

    @Generated
    public RbelKeyManager getRbelKeyManager() {
        return this.rbelKeyManager;
    }

    @Generated
    public RbelValueShader getRbelValueShader() {
        return this.rbelValueShader;
    }

    @Generated
    public List<RbelConverterPlugin> getPostConversionListeners() {
        return this.postConversionListeners;
    }

    @Generated
    public Map<Class<? extends RbelElement>, List<BiFunction<RbelElement, RbelConverter, RbelElement>>> getPreConversionMappers() {
        return this.preConversionMappers;
    }

    @Generated
    public List<RbelConverterPlugin> getConverterPlugins() {
        return this.converterPlugins;
    }

    @Generated
    public long getMessageSequenceNumber() {
        return this.messageSequenceNumber;
    }

    @Generated
    public int getSkipParsingWhenMessageLargerThanKb() {
        return this.skipParsingWhenMessageLargerThanKb;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    @Generated
    public static class RbelConverterBuilder {
        @Generated
        private boolean rbelBufferSizeInMb$set;
        @Generated
        private int rbelBufferSizeInMb$value;
        @Generated
        private boolean manageBuffer$set;
        @Generated
        private boolean manageBuffer$value;
        @Generated
        private RbelKeyManager rbelKeyManager;
        @Generated
        private boolean messageSequenceNumber$set;
        @Generated
        private long messageSequenceNumber$value;
        @Generated
        private boolean skipParsingWhenMessageLargerThanKb$set;
        @Generated
        private int skipParsingWhenMessageLargerThanKb$value;

        @Generated
        RbelConverterBuilder() {
        }

        @Generated
        public RbelConverterBuilder rbelBufferSizeInMb(int rbelBufferSizeInMb) {
            this.rbelBufferSizeInMb$value = rbelBufferSizeInMb;
            this.rbelBufferSizeInMb$set = true;
            return this;
        }

        @Generated
        public RbelConverterBuilder manageBuffer(boolean manageBuffer) {
            this.manageBuffer$value = manageBuffer;
            this.manageBuffer$set = true;
            return this;
        }

        @Generated
        public RbelConverterBuilder rbelKeyManager(RbelKeyManager rbelKeyManager) {
            this.rbelKeyManager = rbelKeyManager;
            return this;
        }

        @Generated
        public RbelConverterBuilder messageSequenceNumber(long messageSequenceNumber) {
            this.messageSequenceNumber$value = messageSequenceNumber;
            this.messageSequenceNumber$set = true;
            return this;
        }

        @Generated
        public RbelConverterBuilder skipParsingWhenMessageLargerThanKb(int skipParsingWhenMessageLargerThanKb) {
            this.skipParsingWhenMessageLargerThanKb$value = skipParsingWhenMessageLargerThanKb;
            this.skipParsingWhenMessageLargerThanKb$set = true;
            return this;
        }

        @Generated
        public RbelConverter build() {
            int rbelBufferSizeInMb$value = this.rbelBufferSizeInMb$value;
            if (!this.rbelBufferSizeInMb$set) {
                rbelBufferSizeInMb$value = RbelConverter.$default$rbelBufferSizeInMb();
            }
            boolean manageBuffer$value = this.manageBuffer$value;
            if (!this.manageBuffer$set) {
                manageBuffer$value = RbelConverter.$default$manageBuffer();
            }
            long messageSequenceNumber$value = this.messageSequenceNumber$value;
            if (!this.messageSequenceNumber$set) {
                messageSequenceNumber$value = RbelConverter.$default$messageSequenceNumber();
            }
            int skipParsingWhenMessageLargerThanKb$value = this.skipParsingWhenMessageLargerThanKb$value;
            if (!this.skipParsingWhenMessageLargerThanKb$set) {
                skipParsingWhenMessageLargerThanKb$value = RbelConverter.$default$skipParsingWhenMessageLargerThanKb();
            }
            return new RbelConverter(rbelBufferSizeInMb$value, manageBuffer$value, this.rbelKeyManager, messageSequenceNumber$value, skipParsingWhenMessageLargerThanKb$value);
        }

        @Generated
        public String toString() {
            return "RbelConverter.RbelConverterBuilder(rbelBufferSizeInMb$value=" + this.rbelBufferSizeInMb$value + ", manageBuffer$value=" + this.manageBuffer$value + ", rbelKeyManager=" + this.rbelKeyManager + ", messageSequenceNumber$value=" + this.messageSequenceNumber$value + ", skipParsingWhenMessageLargerThanKb$value=" + this.skipParsingWhenMessageLargerThanKb$value + ")";
        }
    }
}

