/*
 *
 * Copyright 2021-2025 gematik GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * *******
 *
 * For additional notes and disclaimer from gematik and in case of changes by gematik find details in the "Readme" file.
 */
package de.gematik.test.tiger.proxy;

import de.gematik.rbellogger.RbelConversionExecutor;
import de.gematik.rbellogger.RbelConversionPhase;
import de.gematik.rbellogger.RbelConverterPlugin;
import de.gematik.rbellogger.converter.ConverterInfo;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelMessageMetadata;
import de.gematik.rbellogger.data.facet.RbelNonTransmissionMarkerFacet;
import de.gematik.test.tiger.proxy.client.TigerRemoteProxyClient;
import lombok.EqualsAndHashCode;
import lombok.Value;
import lombok.val;

@EqualsAndHashCode(callSuper = true)
@ConverterInfo(addAutomatically = false)
@Value
public class TigerProxyMessageDeletedPlugin extends RbelConverterPlugin {
  TigerRemoteProxyClient tigerProxy;

  @Override
  public RbelConversionPhase getPhase() {
    return RbelConversionPhase.DELETION;
  }

  @Override
  public void consumeElement(RbelElement rbelElement, RbelConversionExecutor converter) {
    val metadataFacet = rbelElement.getFacet(RbelMessageMetadata.class);
    if (metadataFacet.isPresent() && !rbelElement.hasFacet(RbelNonTransmissionMarkerFacet.class)) {
      tigerProxy.signalNewCompletedMessage(rbelElement);
    }
  }
}
