const e=`<!--


    Copyright 2021-2025 gematik GmbH

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    *******

    For additional notes and disclaimer from gematik and in case of changes by gematik find details in the "Readme" file.

-->
<!doctype html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
      <link rel="icon" type="image/png" href="data:image/png;base64,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"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Tiger Proxy Log</title>
      <script id="__TGR_RBEL_LOG__" type="text/javascript"><\/script>
    <script type="module" crossorigin>(function(){const t=document.createElement("link").relList;if(t&&t.supports&&t.supports("modulepreload"))return;for(const r of document.querySelectorAll('link[rel="modulepreload"]'))s(r);new MutationObserver(r=>{for(const i of r)if(i.type==="childList")for(const o of i.addedNodes)o.tagName==="LINK"&&o.rel==="modulepreload"&&s(o)}).observe(document,{childList:!0,subtree:!0});function n(r){const i={};return r.integrity&&(i.integrity=r.integrity),r.referrerPolicy&&(i.referrerPolicy=r.referrerPolicy),r.crossOrigin==="use-credentials"?i.credentials="include":r.crossOrigin==="anonymous"?i.credentials="omit":i.credentials="same-origin",i}function s(r){if(r.ep)return;r.ep=!0;const i=n(r);fetch(r.href,i)}})();const sv="modulepreload",rv=function(e,t){return new URL(e,t).href},eu={},iv=function(t,n,s){let r=Promise.resolve();if(n&&n.length>0){let u=function(c){return Promise.all(c.map(f=>Promise.resolve(f).then(d=>({status:"fulfilled",value:d}),d=>({status:"rejected",reason:d}))))};const o=document.getElementsByTagName("link"),a=document.querySelector("meta[property=csp-nonce]"),l=a?.nonce||a?.getAttribute("nonce");r=u(n.map(c=>{if(c=rv(c,s),c in eu)return;eu[c]=!0;const f=c.endsWith(".css"),d=f?'[rel="stylesheet"]':"";if(!!s)for(let g=o.length-1;g>=0;g--){const _=o[g];if(_.href===c&&(!f||_.rel==="stylesheet"))return}else if(document.querySelector(\`link[href="\${c}"]\${d}\`))return;const p=document.createElement("link");if(p.rel=f?"stylesheet":sv,f||(p.as="script"),p.crossOrigin="",p.href=c,l&&p.setAttribute("nonce",l),document.head.appendChild(p),f)return new Promise((g,_)=>{p.addEventListener("load",g),p.addEventListener("error",()=>_(new Error(\`Unable to preload CSS for \${c}\`)))})}))}function i(o){const a=new Event("vite:preloadError",{cancelable:!0});if(a.payload=o,window.dispatchEvent(a),!a.defaultPrevented)throw o}return r.then(o=>{for(const a of o||[])a.status==="rejected"&&i(a.reason);return t().catch(i)})};/**
* @vue/shared v3.5.21
* (c) 2018-present Yuxi (Evan) You and Vue contributors
* @license MIT
**/function jl(e){const t=Object.create(null);for(const n of e.split(","))t[n]=1;return n=>n in t}const je={},Xs=[],En=()=>{},wd=()=>!1,_o=e=>e.charCodeAt(0)===111&&e.charCodeAt(1)===110&&(e.charCodeAt(2)>122||e.charCodeAt(2)<97),Hl=e=>e.startsWith("onUpdate:"),St=Object.assign,Vl=(e,t)=>{const n=e.indexOf(t);n>-1&&e.splice(n,1)},ov=Object.prototype.hasOwnProperty,Le=(e,t)=>ov.call(e,t),ve=Array.isArray,Js=e=>si(e)==="[object Map]",Eo=e=>si(e)==="[object Set]",tu=e=>si(e)==="[object Date]",ye=e=>typeof e=="function",et=e=>typeof e=="string",cn=e=>typeof e=="symbol",He=e=>e!==null&&typeof e=="object",Sd=e=>(He(e)||ye(e))&&ye(e.then)&&ye(e.catch),xd=Object.prototype.toString,si=e=>xd.call(e),av=e=>si(e).slice(8,-1),Td=e=>si(e)==="[object Object]",Bl=e=>et(e)&&e!=="NaN"&&e[0]!=="-"&&""+parseInt(e,10)===e,kr=jl(",key,ref,ref_for,ref_key,onVnodeBeforeMount,onVnodeMounted,onVnodeBeforeUpdate,onVnodeUpdated,onVnodeBeforeUnmount,onVnodeUnmounted"),wo=e=>{const t=Object.create(null);return(n=>t[n]||(t[n]=e(n)))},lv=/-\\w/g,Zt=wo(e=>e.replace(lv,t=>t.slice(1).toUpperCase())),cv=/\\B([A-Z])/g,hs=wo(e=>e.replace(cv,"-$1").toLowerCase()),So=wo(e=>e.charAt(0).toUpperCase()+e.slice(1)),Hi=wo(e=>e?\`on\${So(e)}\`:""),rs=(e,t)=>!Object.is(e,t),Vi=(e,...t)=>{for(let n=0;n<e.length;n++)e[n](...t)},Ad=(e,t,n,s=!1)=>{Object.defineProperty(e,t,{configurable:!0,enumerable:!1,writable:s,value:n})},Qa=e=>{const t=parseFloat(e);return isNaN(t)?e:t};let nu;const xo=()=>nu||(nu=typeof globalThis<"u"?globalThis:typeof self<"u"?self:typeof window<"u"?window:typeof global<"u"?global:{});function ri(e){if(ve(e)){const t={};for(let n=0;n<e.length;n++){const s=e[n],r=et(s)?hv(s):ri(s);if(r)for(const i in r)t[i]=r[i]}return t}else if(et(e)||He(e))return e}const uv=/;(?![^(]*\\))/g,fv=/:([^]+)/,dv=/\\/\\*[^]*?\\*\\//g;function hv(e){const t={};return e.replace(dv,"").split(uv).forEach(n=>{if(n){const s=n.split(fv);s.length>1&&(t[s[0].trim()]=s[1].trim())}}),t}function $t(e){let t="";if(et(e))t=e;else if(ve(e))for(let n=0;n<e.length;n++){const s=$t(e[n]);s&&(t+=s+" ")}else if(He(e))for(const n in e)e[n]&&(t+=n+" ");return t.trim()}function Od(e){if(!e)return null;let{class:t,style:n}=e;return t&&!et(t)&&(e.class=$t(t)),n&&(e.style=ri(n)),e}const pv="itemscope,allowfullscreen,formnovalidate,ismap,nomodule,novalidate,readonly",gv=jl(pv);function Cd(e){return!!e||e===""}function mv(e,t){if(e.length!==t.length)return!1;let n=!0;for(let s=0;n&&s<e.length;s++)n=rr(e[s],t[s]);return n}function rr(e,t){if(e===t)return!0;let n=tu(e),s=tu(t);if(n||s)return n&&s?e.getTime()===t.getTime():!1;if(n=cn(e),s=cn(t),n||s)return e===t;if(n=ve(e),s=ve(t),n||s)return n&&s?mv(e,t):!1;if(n=He(e),s=He(t),n||s){if(!n||!s)return!1;const r=Object.keys(e).length,i=Object.keys(t).length;if(r!==i)return!1;for(const o in e){const a=e.hasOwnProperty(o),l=t.hasOwnProperty(o);if(a&&!l||!a&&l||!rr(e[o],t[o]))return!1}}return String(e)===String(t)}function Rd(e,t){return e.findIndex(n=>rr(n,t))}const $d=e=>!!(e&&e.__v_isRef===!0),Fe=e=>et(e)?e:e==null?"":ve(e)||He(e)&&(e.toString===xd||!ye(e.toString))?$d(e)?Fe(e.value):JSON.stringify(e,Md,2):String(e),Md=(e,t)=>$d(t)?Md(e,t.value):Js(t)?{[\`Map(\${t.size})\`]:[...t.entries()].reduce((n,[s,r],i)=>(n[la(s,i)+" =>"]=r,n),{})}:Eo(t)?{[\`Set(\${t.size})\`]:[...t.values()].map(n=>la(n))}:cn(t)?la(t):He(t)&&!ve(t)&&!Td(t)?String(t):t,la=(e,t="")=>{var n;return cn(e)?\`Symbol(\${(n=e.description)!=null?n:t})\`:e};/**
* @vue/reactivity v3.5.21
* (c) 2018-present Yuxi (Evan) You and Vue contributors
* @license MIT
**/let _t;class vv{constructor(t=!1){this.detached=t,this._active=!0,this._on=0,this.effects=[],this.cleanups=[],this._isPaused=!1,this.parent=_t,!t&&_t&&(this.index=(_t.scopes||(_t.scopes=[])).push(this)-1)}get active(){return this._active}pause(){if(this._active){this._isPaused=!0;let t,n;if(this.scopes)for(t=0,n=this.scopes.length;t<n;t++)this.scopes[t].pause();for(t=0,n=this.effects.length;t<n;t++)this.effects[t].pause()}}resume(){if(this._active&&this._isPaused){this._isPaused=!1;let t,n;if(this.scopes)for(t=0,n=this.scopes.length;t<n;t++)this.scopes[t].resume();for(t=0,n=this.effects.length;t<n;t++)this.effects[t].resume()}}run(t){if(this._active){const n=_t;try{return _t=this,t()}finally{_t=n}}}on(){++this._on===1&&(this.prevScope=_t,_t=this)}off(){this._on>0&&--this._on===0&&(_t=this.prevScope,this.prevScope=void 0)}stop(t){if(this._active){this._active=!1;let n,s;for(n=0,s=this.effects.length;n<s;n++)this.effects[n].stop();for(this.effects.length=0,n=0,s=this.cleanups.length;n<s;n++)this.cleanups[n]();if(this.cleanups.length=0,this.scopes){for(n=0,s=this.scopes.length;n<s;n++)this.scopes[n].stop(!0);this.scopes.length=0}if(!this.detached&&this.parent&&!t){const r=this.parent.scopes.pop();r&&r!==this&&(this.parent.scopes[this.index]=r,r.index=this.index)}this.parent=void 0}}}function Nd(){return _t}function bv(e,t=!1){_t&&_t.cleanups.push(e)}let Ue;const ca=new WeakSet;class kd{constructor(t){this.fn=t,this.deps=void 0,this.depsTail=void 0,this.flags=5,this.next=void 0,this.cleanup=void 0,this.scheduler=void 0,_t&&_t.active&&_t.effects.push(this)}pause(){this.flags|=64}resume(){this.flags&64&&(this.flags&=-65,ca.has(this)&&(ca.delete(this),this.trigger()))}notify(){this.flags&2&&!(this.flags&32)||this.flags&8||Pd(this)}run(){if(!(this.flags&1))return this.fn();this.flags|=2,su(this),Ld(this);const t=Ue,n=an;Ue=this,an=!0;try{return this.fn()}finally{Dd(this),Ue=t,an=n,this.flags&=-3}}stop(){if(this.flags&1){for(let t=this.deps;t;t=t.nextDep)ql(t);this.deps=this.depsTail=void 0,su(this),this.onStop&&this.onStop(),this.flags&=-2}}trigger(){this.flags&64?ca.add(this):this.scheduler?this.scheduler():this.runIfDirty()}runIfDirty(){Xa(this)&&this.run()}get dirty(){return Xa(this)}}let Id=0,Ir,Pr;function Pd(e,t=!1){if(e.flags|=8,t){e.next=Pr,Pr=e;return}e.next=Ir,Ir=e}function Wl(){Id++}function Ul(){if(--Id>0)return;if(Pr){let t=Pr;for(Pr=void 0;t;){const n=t.next;t.next=void 0,t.flags&=-9,t=n}}let e;for(;Ir;){let t=Ir;for(Ir=void 0;t;){const n=t.next;if(t.next=void 0,t.flags&=-9,t.flags&1)try{t.trigger()}catch(s){e||(e=s)}t=n}}if(e)throw e}function Ld(e){for(let t=e.deps;t;t=t.nextDep)t.version=-1,t.prevActiveLink=t.dep.activeLink,t.dep.activeLink=t}function Dd(e){let t,n=e.depsTail,s=n;for(;s;){const r=s.prevDep;s.version===-1?(s===n&&(n=r),ql(s),yv(s)):t=s,s.dep.activeLink=s.prevActiveLink,s.prevActiveLink=void 0,s=r}e.deps=t,e.depsTail=n}function Xa(e){for(let t=e.deps;t;t=t.nextDep)if(t.dep.version!==t.version||t.dep.computed&&(Fd(t.dep.computed)||t.dep.version!==t.version))return!0;return!!e._dirty}function Fd(e){if(e.flags&4&&!(e.flags&16)||(e.flags&=-17,e.globalVersion===qr)||(e.globalVersion=qr,!e.isSSR&&e.flags&128&&(!e.deps&&!e._dirty||!Xa(e))))return;e.flags|=2;const t=e.dep,n=Ue,s=an;Ue=e,an=!0;try{Ld(e);const r=e.fn(e._value);(t.version===0||rs(r,e._value))&&(e.flags|=128,e._value=r,t.version++)}catch(r){throw t.version++,r}finally{Ue=n,an=s,Dd(e),e.flags&=-3}}function ql(e,t=!1){const{dep:n,prevSub:s,nextSub:r}=e;if(s&&(s.nextSub=r,e.prevSub=void 0),r&&(r.prevSub=s,e.nextSub=void 0),n.subs===e&&(n.subs=s,!s&&n.computed)){n.computed.flags&=-5;for(let i=n.computed.deps;i;i=i.nextDep)ql(i,!0)}!t&&!--n.sc&&n.map&&n.map.delete(n.key)}function yv(e){const{prevDep:t,nextDep:n}=e;t&&(t.nextDep=n,e.prevDep=void 0),n&&(n.prevDep=t,e.nextDep=void 0)}let an=!0;const zd=[];function Ln(){zd.push(an),an=!1}function Dn(){const e=zd.pop();an=e===void 0?!0:e}function su(e){const{cleanup:t}=e;if(e.cleanup=void 0,t){const n=Ue;Ue=void 0;try{t()}finally{Ue=n}}}let qr=0;class _v{constructor(t,n){this.sub=t,this.dep=n,this.version=n.version,this.nextDep=this.prevDep=this.nextSub=this.prevSub=this.prevActiveLink=void 0}}class To{constructor(t){this.computed=t,this.version=0,this.activeLink=void 0,this.subs=void 0,this.map=void 0,this.key=void 0,this.sc=0,this.__v_skip=!0}track(t){if(!Ue||!an||Ue===this.computed)return;let n=this.activeLink;if(n===void 0||n.sub!==Ue)n=this.activeLink=new _v(Ue,this),Ue.deps?(n.prevDep=Ue.depsTail,Ue.depsTail.nextDep=n,Ue.depsTail=n):Ue.deps=Ue.depsTail=n,jd(n);else if(n.version===-1&&(n.version=this.version,n.nextDep)){const s=n.nextDep;s.prevDep=n.prevDep,n.prevDep&&(n.prevDep.nextDep=s),n.prevDep=Ue.depsTail,n.nextDep=void 0,Ue.depsTail.nextDep=n,Ue.depsTail=n,Ue.deps===n&&(Ue.deps=s)}return n}trigger(t){this.version++,qr++,this.notify(t)}notify(t){Wl();try{for(let n=this.subs;n;n=n.prevSub)n.sub.notify()&&n.sub.dep.notify()}finally{Ul()}}}function jd(e){if(e.dep.sc++,e.sub.flags&4){const t=e.dep.computed;if(t&&!e.dep.subs){t.flags|=20;for(let s=t.deps;s;s=s.nextDep)jd(s)}const n=e.dep.subs;n!==e&&(e.prevSub=n,n&&(n.nextSub=e)),e.dep.subs=e}}const to=new WeakMap,Os=Symbol(""),Ja=Symbol(""),Kr=Symbol("");function Et(e,t,n){if(an&&Ue){let s=to.get(e);s||to.set(e,s=new Map);let r=s.get(n);r||(s.set(n,r=new To),r.map=s,r.key=n),r.track()}}function $n(e,t,n,s,r,i){const o=to.get(e);if(!o){qr++;return}const a=l=>{l&&l.trigger()};if(Wl(),t==="clear")o.forEach(a);else{const l=ve(e),u=l&&Bl(n);if(l&&n==="length"){const c=Number(s);o.forEach((f,d)=>{(d==="length"||d===Kr||!cn(d)&&d>=c)&&a(f)})}else switch((n!==void 0||o.has(void 0))&&a(o.get(n)),u&&a(o.get(Kr)),t){case"add":l?u&&a(o.get("length")):(a(o.get(Os)),Js(e)&&a(o.get(Ja)));break;case"delete":l||(a(o.get(Os)),Js(e)&&a(o.get(Ja)));break;case"set":Js(e)&&a(o.get(Os));break}}Ul()}function Ev(e,t){const n=to.get(e);return n&&n.get(t)}function zs(e){const t=Ie(e);return t===e?t:(Et(t,"iterate",Kr),Xt(e)?t:t.map(pt))}function Ao(e){return Et(e=Ie(e),"iterate",Kr),e}const wv={__proto__:null,[Symbol.iterator](){return ua(this,Symbol.iterator,pt)},concat(...e){return zs(this).concat(...e.map(t=>ve(t)?zs(t):t))},entries(){return ua(this,"entries",e=>(e[1]=pt(e[1]),e))},every(e,t){return An(this,"every",e,t,void 0,arguments)},filter(e,t){return An(this,"filter",e,t,n=>n.map(pt),arguments)},find(e,t){return An(this,"find",e,t,pt,arguments)},findIndex(e,t){return An(this,"findIndex",e,t,void 0,arguments)},findLast(e,t){return An(this,"findLast",e,t,pt,arguments)},findLastIndex(e,t){return An(this,"findLastIndex",e,t,void 0,arguments)},forEach(e,t){return An(this,"forEach",e,t,void 0,arguments)},includes(...e){return fa(this,"includes",e)},indexOf(...e){return fa(this,"indexOf",e)},join(e){return zs(this).join(e)},lastIndexOf(...e){return fa(this,"lastIndexOf",e)},map(e,t){return An(this,"map",e,t,void 0,arguments)},pop(){return Ar(this,"pop")},push(...e){return Ar(this,"push",e)},reduce(e,...t){return ru(this,"reduce",e,t)},reduceRight(e,...t){return ru(this,"reduceRight",e,t)},shift(){return Ar(this,"shift")},some(e,t){return An(this,"some",e,t,void 0,arguments)},splice(...e){return Ar(this,"splice",e)},toReversed(){return zs(this).toReversed()},toSorted(e){return zs(this).toSorted(e)},toSpliced(...e){return zs(this).toSpliced(...e)},unshift(...e){return Ar(this,"unshift",e)},values(){return ua(this,"values",pt)}};function ua(e,t,n){const s=Ao(e),r=s[t]();return s!==e&&!Xt(e)&&(r._next=r.next,r.next=()=>{const i=r._next();return i.value&&(i.value=n(i.value)),i}),r}const Sv=Array.prototype;function An(e,t,n,s,r,i){const o=Ao(e),a=o!==e&&!Xt(e),l=o[t];if(l!==Sv[t]){const f=l.apply(e,i);return a?pt(f):f}let u=n;o!==e&&(a?u=function(f,d){return n.call(this,pt(f),d,e)}:n.length>2&&(u=function(f,d){return n.call(this,f,d,e)}));const c=l.call(o,u,s);return a&&r?r(c):c}function ru(e,t,n,s){const r=Ao(e);let i=n;return r!==e&&(Xt(e)?n.length>3&&(i=function(o,a,l){return n.call(this,o,a,l,e)}):i=function(o,a,l){return n.call(this,o,pt(a),l,e)}),r[t](i,...s)}function fa(e,t,n){const s=Ie(e);Et(s,"iterate",Kr);const r=s[t](...n);return(r===-1||r===!1)&&Yl(n[0])?(n[0]=Ie(n[0]),s[t](...n)):r}function Ar(e,t,n=[]){Ln(),Wl();const s=Ie(e)[t].apply(e,n);return Ul(),Dn(),s}const xv=jl("__proto__,__v_isRef,__isVue"),Hd=new Set(Object.getOwnPropertyNames(Symbol).filter(e=>e!=="arguments"&&e!=="caller").map(e=>Symbol[e]).filter(cn));function Tv(e){cn(e)||(e=String(e));const t=Ie(this);return Et(t,"has",e),t.hasOwnProperty(e)}class Vd{constructor(t=!1,n=!1){this._isReadonly=t,this._isShallow=n}get(t,n,s){if(n==="__v_skip")return t.__v_skip;const r=this._isReadonly,i=this._isShallow;if(n==="__v_isReactive")return!r;if(n==="__v_isReadonly")return r;if(n==="__v_isShallow")return i;if(n==="__v_raw")return s===(r?i?Yd:Kd:i?qd:Ud).get(t)||Object.getPrototypeOf(t)===Object.getPrototypeOf(s)?t:void 0;const o=ve(t);if(!r){let l;if(o&&(l=wv[n]))return l;if(n==="hasOwnProperty")return Tv}const a=Reflect.get(t,n,Ze(t)?t:s);return(cn(n)?Hd.has(n):xv(n))||(r||Et(t,"get",n),i)?a:Ze(a)?o&&Bl(n)?a:a.value:He(a)?r?Mt(a):Co(a):a}}class Bd extends Vd{constructor(t=!1){super(!1,t)}set(t,n,s,r){let i=t[n];if(!this._isShallow){const l=is(i);if(!Xt(s)&&!is(s)&&(i=Ie(i),s=Ie(s)),!ve(t)&&Ze(i)&&!Ze(s))return l||(i.value=s),!0}const o=ve(t)&&Bl(n)?Number(n)<t.length:Le(t,n),a=Reflect.set(t,n,s,Ze(t)?t:r);return t===Ie(r)&&(o?rs(s,i)&&$n(t,"set",n,s):$n(t,"add",n,s)),a}deleteProperty(t,n){const s=Le(t,n);t[n];const r=Reflect.deleteProperty(t,n);return r&&s&&$n(t,"delete",n,void 0),r}has(t,n){const s=Reflect.has(t,n);return(!cn(n)||!Hd.has(n))&&Et(t,"has",n),s}ownKeys(t){return Et(t,"iterate",ve(t)?"length":Os),Reflect.ownKeys(t)}}class Wd extends Vd{constructor(t=!1){super(!0,t)}set(t,n){return!0}deleteProperty(t,n){return!0}}const Av=new Bd,Ov=new Wd,Cv=new Bd(!0),Rv=new Wd(!0),Za=e=>e,Ai=e=>Reflect.getPrototypeOf(e);function $v(e,t,n){return function(...s){const r=this.__v_raw,i=Ie(r),o=Js(i),a=e==="entries"||e===Symbol.iterator&&o,l=e==="keys"&&o,u=r[e](...s),c=n?Za:t?no:pt;return!t&&Et(i,"iterate",l?Ja:Os),{next(){const{value:f,done:d}=u.next();return d?{value:f,done:d}:{value:a?[c(f[0]),c(f[1])]:c(f),done:d}},[Symbol.iterator](){return this}}}}function Oi(e){return function(...t){return e==="delete"?!1:e==="clear"?void 0:this}}function Mv(e,t){const n={get(r){const i=this.__v_raw,o=Ie(i),a=Ie(r);e||(rs(r,a)&&Et(o,"get",r),Et(o,"get",a));const{has:l}=Ai(o),u=t?Za:e?no:pt;if(l.call(o,r))return u(i.get(r));if(l.call(o,a))return u(i.get(a));i!==o&&i.get(r)},get size(){const r=this.__v_raw;return!e&&Et(Ie(r),"iterate",Os),r.size},has(r){const i=this.__v_raw,o=Ie(i),a=Ie(r);return e||(rs(r,a)&&Et(o,"has",r),Et(o,"has",a)),r===a?i.has(r):i.has(r)||i.has(a)},forEach(r,i){const o=this,a=o.__v_raw,l=Ie(a),u=t?Za:e?no:pt;return!e&&Et(l,"iterate",Os),a.forEach((c,f)=>r.call(i,u(c),u(f),o))}};return St(n,e?{add:Oi("add"),set:Oi("set"),delete:Oi("delete"),clear:Oi("clear")}:{add(r){!t&&!Xt(r)&&!is(r)&&(r=Ie(r));const i=Ie(this);return Ai(i).has.call(i,r)||(i.add(r),$n(i,"add",r,r)),this},set(r,i){!t&&!Xt(i)&&!is(i)&&(i=Ie(i));const o=Ie(this),{has:a,get:l}=Ai(o);let u=a.call(o,r);u||(r=Ie(r),u=a.call(o,r));const c=l.call(o,r);return o.set(r,i),u?rs(i,c)&&$n(o,"set",r,i):$n(o,"add",r,i),this},delete(r){const i=Ie(this),{has:o,get:a}=Ai(i);let l=o.call(i,r);l||(r=Ie(r),l=o.call(i,r)),a&&a.call(i,r);const u=i.delete(r);return l&&$n(i,"delete",r,void 0),u},clear(){const r=Ie(this),i=r.size!==0,o=r.clear();return i&&$n(r,"clear",void 0,void 0),o}}),["keys","values","entries",Symbol.iterator].forEach(r=>{n[r]=$v(r,e,t)}),n}function Oo(e,t){const n=Mv(e,t);return(s,r,i)=>r==="__v_isReactive"?!e:r==="__v_isReadonly"?e:r==="__v_raw"?s:Reflect.get(Le(n,r)&&r in s?n:s,r,i)}const Nv={get:Oo(!1,!1)},kv={get:Oo(!1,!0)},Iv={get:Oo(!0,!1)},Pv={get:Oo(!0,!0)},Ud=new WeakMap,qd=new WeakMap,Kd=new WeakMap,Yd=new WeakMap;function Lv(e){switch(e){case"Object":case"Array":return 1;case"Map":case"Set":case"WeakMap":case"WeakSet":return 2;default:return 0}}function Dv(e){return e.__v_skip||!Object.isExtensible(e)?0:Lv(av(e))}function Co(e){return is(e)?e:Ro(e,!1,Av,Nv,Ud)}function Kl(e){return Ro(e,!1,Cv,kv,qd)}function Mt(e){return Ro(e,!0,Ov,Iv,Kd)}function Gd(e){return Ro(e,!0,Rv,Pv,Yd)}function Ro(e,t,n,s,r){if(!He(e)||e.__v_raw&&!(t&&e.__v_isReactive))return e;const i=Dv(e);if(i===0)return e;const o=r.get(e);if(o)return o;const a=new Proxy(e,i===2?s:n);return r.set(e,a),a}function Zs(e){return is(e)?Zs(e.__v_raw):!!(e&&e.__v_isReactive)}function is(e){return!!(e&&e.__v_isReadonly)}function Xt(e){return!!(e&&e.__v_isShallow)}function Yl(e){return e?!!e.__v_raw:!1}function Ie(e){const t=e&&e.__v_raw;return t?Ie(t):e}function Qd(e){return!Le(e,"__v_skip")&&Object.isExtensible(e)&&Ad(e,"__v_skip",!0),e}const pt=e=>He(e)?Co(e):e,no=e=>He(e)?Mt(e):e;function Ze(e){return e?e.__v_isRef===!0:!1}function re(e){return Xd(e,!1)}function Nt(e){return Xd(e,!0)}function Xd(e,t){return Ze(e)?e:new Fv(e,t)}class Fv{constructor(t,n){this.dep=new To,this.__v_isRef=!0,this.__v_isShallow=!1,this._rawValue=n?t:Ie(t),this._value=n?t:pt(t),this.__v_isShallow=n}get value(){return this.dep.track(),this._value}set value(t){const n=this._rawValue,s=this.__v_isShallow||Xt(t)||is(t);t=s?t:Ie(t),rs(t,n)&&(this._rawValue=t,this._value=s?t:pt(t),this.dep.trigger())}}function zv(e){e.dep&&e.dep.trigger()}function A(e){return Ze(e)?e.value:e}function dt(e){return ye(e)?e():A(e)}const jv={get:(e,t,n)=>t==="__v_raw"?e:A(Reflect.get(e,t,n)),set:(e,t,n,s)=>{const r=e[t];return Ze(r)&&!Ze(n)?(r.value=n,!0):Reflect.set(e,t,n,s)}};function Jd(e){return Zs(e)?e:new Proxy(e,jv)}class Hv{constructor(t){this.__v_isRef=!0,this._value=void 0;const n=this.dep=new To,{get:s,set:r}=t(n.track.bind(n),n.trigger.bind(n));this._get=s,this._set=r}get value(){return this._value=this._get()}set value(t){this._set(t)}}function Gl(e){return new Hv(e)}class Vv{constructor(t,n,s){this._object=t,this._key=n,this._defaultValue=s,this.__v_isRef=!0,this._value=void 0}get value(){const t=this._object[this._key];return this._value=t===void 0?this._defaultValue:t}set value(t){this._object[this._key]=t}get dep(){return Ev(Ie(this._object),this._key)}}class Bv{constructor(t){this._getter=t,this.__v_isRef=!0,this.__v_isReadonly=!0,this._value=void 0}get value(){return this._value=this._getter()}}function Wv(e,t,n){return Ze(e)?e:ye(e)?new Bv(e):He(e)&&arguments.length>1?Uv(e,t,n):re(e)}function Uv(e,t,n){const s=e[t];return Ze(s)?s:new Vv(e,t,n)}class qv{constructor(t,n,s){this.fn=t,this.setter=n,this._value=void 0,this.dep=new To(this),this.__v_isRef=!0,this.deps=void 0,this.depsTail=void 0,this.flags=16,this.globalVersion=qr-1,this.next=void 0,this.effect=this,this.__v_isReadonly=!n,this.isSSR=s}notify(){if(this.flags|=16,!(this.flags&8)&&Ue!==this)return Pd(this,!0),!0}get value(){const t=this.dep.track();return Fd(this),t&&(t.version=this.dep.version),this._value}set value(t){this.setter&&this.setter(t)}}function Kv(e,t,n=!1){let s,r;return ye(e)?s=e:(s=e.get,r=e.set),new qv(s,r,n)}const Ci={},so=new WeakMap;let Ss;function Yv(e,t=!1,n=Ss){if(n){let s=so.get(n);s||so.set(n,s=[]),s.push(e)}}function Gv(e,t,n=je){const{immediate:s,deep:r,once:i,scheduler:o,augmentJob:a,call:l}=n,u=x=>r?x:Xt(x)||r===!1||r===0?Mn(x,1):Mn(x);let c,f,d,h,p=!1,g=!1;if(Ze(e)?(f=()=>e.value,p=Xt(e)):Zs(e)?(f=()=>u(e),p=!0):ve(e)?(g=!0,p=e.some(x=>Zs(x)||Xt(x)),f=()=>e.map(x=>{if(Ze(x))return x.value;if(Zs(x))return u(x);if(ye(x))return l?l(x,2):x()})):ye(e)?t?f=l?()=>l(e,2):e:f=()=>{if(d){Ln();try{d()}finally{Dn()}}const x=Ss;Ss=c;try{return l?l(e,3,[h]):e(h)}finally{Ss=x}}:f=En,t&&r){const x=f,O=r===!0?1/0:r;f=()=>Mn(x(),O)}const _=Nd(),b=()=>{c.stop(),_&&_.active&&Vl(_.effects,c)};if(i&&t){const x=t;t=(...O)=>{x(...O),b()}}let y=g?new Array(e.length).fill(Ci):Ci;const T=x=>{if(!(!(c.flags&1)||!c.dirty&&!x))if(t){const O=c.run();if(r||p||(g?O.some(($,F)=>rs($,y[F])):rs(O,y))){d&&d();const $=Ss;Ss=c;try{const F=[O,y===Ci?void 0:g&&y[0]===Ci?[]:y,h];y=O,l?l(t,3,F):t(...F)}finally{Ss=$}}}else c.run()};return a&&a(T),c=new kd(f),c.scheduler=o?()=>o(T,!1):T,h=x=>Yv(x,!1,c),d=c.onStop=()=>{const x=so.get(c);if(x){if(l)l(x,4);else for(const O of x)O();so.delete(c)}},t?s?T(!0):y=c.run():o?o(T.bind(null,!0),!0):c.run(),b.pause=c.pause.bind(c),b.resume=c.resume.bind(c),b.stop=b,b}function Mn(e,t=1/0,n){if(t<=0||!He(e)||e.__v_skip||(n=n||new Map,(n.get(e)||0)>=t))return e;if(n.set(e,t),t--,Ze(e))Mn(e.value,t,n);else if(ve(e))for(let s=0;s<e.length;s++)Mn(e[s],t,n);else if(Eo(e)||Js(e))e.forEach(s=>{Mn(s,t,n)});else if(Td(e)){for(const s in e)Mn(e[s],t,n);for(const s of Object.getOwnPropertySymbols(e))Object.prototype.propertyIsEnumerable.call(e,s)&&Mn(e[s],t,n)}return e}/**
* @vue/runtime-core v3.5.21
* (c) 2018-present Yuxi (Evan) You and Vue contributors
* @license MIT
**/function ii(e,t,n,s){try{return s?e(...s):e()}catch(r){$o(r,t,n)}}function Sn(e,t,n,s){if(ye(e)){const r=ii(e,t,n,s);return r&&Sd(r)&&r.catch(i=>{$o(i,t,n)}),r}if(ve(e)){const r=[];for(let i=0;i<e.length;i++)r.push(Sn(e[i],t,n,s));return r}}function $o(e,t,n,s=!0){const r=t?t.vnode:null,{errorHandler:i,throwUnhandledErrorInProduction:o}=t&&t.appContext.config||je;if(t){let a=t.parent;const l=t.proxy,u=\`https://vuejs.org/error-reference/#runtime-\${n}\`;for(;a;){const c=a.ec;if(c){for(let f=0;f<c.length;f++)if(c[f](e,l,u)===!1)return}a=a.parent}if(i){Ln(),ii(i,null,10,[e,l,u]),Dn();return}}Qv(e,n,r,s,o)}function Qv(e,t,n,s=!0,r=!1){if(r)throw e;console.error(e)}const Ot=[];let vn=-1;const er=[];let Jn=null,Bs=0;const Zd=Promise.resolve();let ro=null;function un(e){const t=ro||Zd;return e?t.then(this?e.bind(this):e):t}function Xv(e){let t=vn+1,n=Ot.length;for(;t<n;){const s=t+n>>>1,r=Ot[s],i=Yr(r);i<e||i===e&&r.flags&2?t=s+1:n=s}return t}function Ql(e){if(!(e.flags&1)){const t=Yr(e),n=Ot[Ot.length-1];!n||!(e.flags&2)&&t>=Yr(n)?Ot.push(e):Ot.splice(Xv(t),0,e),e.flags|=1,eh()}}function eh(){ro||(ro=Zd.then(nh))}function Jv(e){ve(e)?er.push(...e):Jn&&e.id===-1?Jn.splice(Bs+1,0,e):e.flags&1||(er.push(e),e.flags|=1),eh()}function iu(e,t,n=vn+1){for(;n<Ot.length;n++){const s=Ot[n];if(s&&s.flags&2){if(e&&s.id!==e.uid)continue;Ot.splice(n,1),n--,s.flags&4&&(s.flags&=-2),s(),s.flags&4||(s.flags&=-2)}}}function th(e){if(er.length){const t=[...new Set(er)].sort((n,s)=>Yr(n)-Yr(s));if(er.length=0,Jn){Jn.push(...t);return}for(Jn=t,Bs=0;Bs<Jn.length;Bs++){const n=Jn[Bs];n.flags&4&&(n.flags&=-2),n.flags&8||n(),n.flags&=-2}Jn=null,Bs=0}}const Yr=e=>e.id==null?e.flags&2?-1:1/0:e.id;function nh(e){try{for(vn=0;vn<Ot.length;vn++){const t=Ot[vn];t&&!(t.flags&8)&&(t.flags&4&&(t.flags&=-2),ii(t,t.i,t.i?15:14),t.flags&4||(t.flags&=-2))}}finally{for(;vn<Ot.length;vn++){const t=Ot[vn];t&&(t.flags&=-2)}vn=-1,Ot.length=0,th(),ro=null,(Ot.length||er.length)&&nh()}}let gt=null,Mo=null;function io(e){const t=gt;return gt=e,Mo=e&&e.type.__scopeId||null,t}function Zv(e){Mo=e}function eb(){Mo=null}const tb=e=>Qt;function Qt(e,t=gt,n){if(!t||e._n)return e;const s=(...r)=>{s._d&&lo(-1);const i=io(t);let o;try{o=e(...r)}finally{io(i),s._d&&lo(1)}return o};return s._n=!0,s._c=!0,s._d=!0,s}function jt(e,t){if(gt===null)return e;const n=Do(gt),s=e.dirs||(e.dirs=[]);for(let r=0;r<t.length;r++){let[i,o,a,l=je]=t[r];i&&(ye(i)&&(i={mounted:i,updated:i}),i.deep&&Mn(o),s.push({dir:i,instance:n,value:o,oldValue:void 0,arg:a,modifiers:l}))}return e}function Es(e,t,n,s){const r=e.dirs,i=t&&t.dirs;for(let o=0;o<r.length;o++){const a=r[o];i&&(a.oldValue=i[o].value);let l=a.dir[s];l&&(Ln(),Sn(l,n,8,[e.el,a,e,t]),Dn())}}const nb=Symbol("_vte"),sb=e=>e.__isTeleport,rb=Symbol("_leaveCb");function Xl(e,t){e.shapeFlag&6&&e.component?(e.transition=t,Xl(e.component.subTree,t)):e.shapeFlag&128?(e.ssContent.transition=t.clone(e.ssContent),e.ssFallback.transition=t.clone(e.ssFallback)):e.transition=t}function at(e,t){return ye(e)?St({name:e.name},t,{setup:e}):e}function sh(e){e.ids=[e.ids[0]+e.ids[2]+++"-",0,0]}const oo=new WeakMap;function Lr(e,t,n,s,r=!1){if(ve(e)){e.forEach((p,g)=>Lr(p,t&&(ve(t)?t[g]:t),n,s,r));return}if(tr(s)&&!r){s.shapeFlag&512&&s.type.__asyncResolved&&s.component.subTree.component&&Lr(e,t,n,s.component.subTree);return}const i=s.shapeFlag&4?Do(s.component):s.el,o=r?null:i,{i:a,r:l}=e,u=t&&t.r,c=a.refs===je?a.refs={}:a.refs,f=a.setupState,d=Ie(f),h=f===je?wd:p=>Le(d,p);if(u!=null&&u!==l){if(ou(t),et(u))c[u]=null,h(u)&&(f[u]=null);else if(Ze(u)){u.value=null;const p=t;p.k&&(c[p.k]=null)}}if(ye(l))ii(l,a,12,[o,c]);else{const p=et(l),g=Ze(l);if(p||g){const _=()=>{if(e.f){const b=p?h(l)?f[l]:c[l]:l.value;if(r)ve(b)&&Vl(b,i);else if(ve(b))b.includes(i)||b.push(i);else if(p)c[l]=[i],h(l)&&(f[l]=c[l]);else{const y=[i];l.value=y,e.k&&(c[e.k]=y)}}else p?(c[l]=o,h(l)&&(f[l]=o)):g&&(l.value=o,e.k&&(c[e.k]=o))};if(o){const b=()=>{_(),oo.delete(e)};b.id=-1,oo.set(e,b),Ft(b,n)}else ou(e),_()}}}function ou(e){const t=oo.get(e);t&&(t.flags|=8,oo.delete(e))}xo().requestIdleCallback;xo().cancelIdleCallback;const tr=e=>!!e.type.__asyncLoader,rh=e=>e.type.__isKeepAlive;function ib(e,t){ih(e,"a",t)}function ob(e,t){ih(e,"da",t)}function ih(e,t,n=wt){const s=e.__wdc||(e.__wdc=()=>{let r=n;for(;r;){if(r.isDeactivated)return;r=r.parent}return e()});if(No(t,s,n),n){let r=n.parent;for(;r&&r.parent;)rh(r.parent.vnode)&&ab(s,t,n,r),r=r.parent}}function ab(e,t,n,s){const r=No(t,e,s,!0);Jl(()=>{Vl(s[t],r)},n)}function No(e,t,n=wt,s=!1){if(n){const r=n[e]||(n[e]=[]),i=t.__weh||(t.__weh=(...o)=>{Ln();const a=oi(n),l=Sn(t,n,e,o);return a(),Dn(),l});return s?r.unshift(i):r.push(i),i}}const Bn=e=>(t,n=wt)=>{(!Xr||e==="sp")&&No(e,(...s)=>t(...s),n)},lb=Bn("bm"),Lt=Bn("m"),oh=Bn("bu"),cb=Bn("u"),ah=Bn("bum"),Jl=Bn("um"),ub=Bn("sp"),fb=Bn("rtg"),db=Bn("rtc");function hb(e,t=wt){No("ec",e,t)}const Zl="components",pb="directives";function ec(e,t){return tc(Zl,e,!0,t)||e}const lh=Symbol.for("v-ndc");function au(e){return et(e)?tc(Zl,e,!1)||e:e||lh}function gb(e){return tc(pb,e)}function tc(e,t,n=!0,s=!1){const r=gt||wt;if(r){const i=r.type;if(e===Zl){const a=ny(i,!1);if(a&&(a===t||a===Zt(t)||a===So(Zt(t))))return i}const o=lu(r[e]||i[e],t)||lu(r.appContext[e],t);return!o&&s?i:o}}function lu(e,t){return e&&(e[t]||e[Zt(t)]||e[So(Zt(t))])}function Fn(e,t,n,s){let r;const i=n,o=ve(e);if(o||et(e)){const a=o&&Zs(e);let l=!1,u=!1;a&&(l=!Xt(e),u=is(e),e=Ao(e)),r=new Array(e.length);for(let c=0,f=e.length;c<f;c++)r[c]=t(l?u?no(pt(e[c])):pt(e[c]):e[c],c,void 0,i)}else if(typeof e=="number"){r=new Array(e);for(let a=0;a<e;a++)r[a]=t(a+1,a,void 0,i)}else if(He(e))if(e[Symbol.iterator])r=Array.from(e,(a,l)=>t(a,l,void 0,i));else{const a=Object.keys(e);r=new Array(a.length);for(let l=0,u=a.length;l<u;l++){const c=a[l];r[l]=t(e[c],c,l,i)}}else r=[];return r}function yn(e,t,n={},s,r){if(gt.ce||gt.parent&&tr(gt.parent)&&gt.parent.ce)return t!=="default"&&(n.name=t),H(),qe(Xe,null,[Ae("slot",n,s&&s())],64);let i=e[t];i&&i._c&&(i._d=!1),H();const o=i&&ch(i(n)),a=n.key||o&&o.key,l=qe(Xe,{key:(a&&!cn(a)?a:\`_\${t}\`)+(!o&&s?"_fb":"")},o||(s?s():[]),o&&e._===1?64:-2);return l.scopeId&&(l.slotScopeIds=[l.scopeId+"-s"]),i&&i._c&&(i._d=!0),l}function ch(e){return e.some(t=>Qr(t)?!(t.type===zn||t.type===Xe&&!ch(t.children)):!0)?e:null}function mb(e,t){const n={};for(const s in e)n[Hi(s)]=e[s];return n}const el=e=>e?Rh(e)?Do(e):el(e.parent):null,Dr=St(Object.create(null),{$:e=>e,$el:e=>e.vnode.el,$data:e=>e.data,$props:e=>e.props,$attrs:e=>e.attrs,$slots:e=>e.slots,$refs:e=>e.refs,$parent:e=>el(e.parent),$root:e=>el(e.root),$host:e=>e.ce,$emit:e=>e.emit,$options:e=>fh(e),$forceUpdate:e=>e.f||(e.f=()=>{Ql(e.update)}),$nextTick:e=>e.n||(e.n=un.bind(e.proxy)),$watch:e=>zb.bind(e)}),da=(e,t)=>e!==je&&!e.__isScriptSetup&&Le(e,t),vb={get({_:e},t){if(t==="__v_skip")return!0;const{ctx:n,setupState:s,data:r,props:i,accessCache:o,type:a,appContext:l}=e;let u;if(t[0]!=="$"){const h=o[t];if(h!==void 0)switch(h){case 1:return s[t];case 2:return r[t];case 4:return n[t];case 3:return i[t]}else{if(da(s,t))return o[t]=1,s[t];if(r!==je&&Le(r,t))return o[t]=2,r[t];if((u=e.propsOptions[0])&&Le(u,t))return o[t]=3,i[t];if(n!==je&&Le(n,t))return o[t]=4,n[t];tl&&(o[t]=0)}}const c=Dr[t];let f,d;if(c)return t==="$attrs"&&Et(e.attrs,"get",""),c(e);if((f=a.__cssModules)&&(f=f[t]))return f;if(n!==je&&Le(n,t))return o[t]=4,n[t];if(d=l.config.globalProperties,Le(d,t))return d[t]},set({_:e},t,n){const{data:s,setupState:r,ctx:i}=e;return da(r,t)?(r[t]=n,!0):s!==je&&Le(s,t)?(s[t]=n,!0):Le(e.props,t)||t[0]==="$"&&t.slice(1)in e?!1:(i[t]=n,!0)},has({_:{data:e,setupState:t,accessCache:n,ctx:s,appContext:r,propsOptions:i,type:o}},a){let l,u;return!!(n[a]||e!==je&&a[0]!=="$"&&Le(e,a)||da(t,a)||(l=i[0])&&Le(l,a)||Le(s,a)||Le(Dr,a)||Le(r.config.globalProperties,a)||(u=o.__cssModules)&&u[a])},defineProperty(e,t,n){return n.get!=null?e._.accessCache[t]=0:Le(n,"value")&&this.set(e,t,n.value,null),Reflect.defineProperty(e,t,n)}};function bb(){return yb().slots}function yb(e){const t=Lo();return t.setupContext||(t.setupContext=Mh(t))}function cu(e){return ve(e)?e.reduce((t,n)=>(t[n]=null,t),{}):e}let tl=!0;function _b(e){const t=fh(e),n=e.proxy,s=e.ctx;tl=!1,t.beforeCreate&&uu(t.beforeCreate,e,"bc");const{data:r,computed:i,methods:o,watch:a,provide:l,inject:u,created:c,beforeMount:f,mounted:d,beforeUpdate:h,updated:p,activated:g,deactivated:_,beforeDestroy:b,beforeUnmount:y,destroyed:T,unmounted:x,render:O,renderTracked:$,renderTriggered:F,errorCaptured:Q,serverPrefetch:P,expose:C,inheritAttrs:q,components:ne,directives:W,filters:L}=t;if(u&&Eb(u,s,null),o)for(const ue in o){const Z=o[ue];ye(Z)&&(s[ue]=Z.bind(n))}if(r){const ue=r.call(n,n);He(ue)&&(e.data=Co(ue))}if(tl=!0,i)for(const ue in i){const Z=i[ue],we=ye(Z)?Z.bind(n,n):ye(Z.get)?Z.get.bind(n,n):En,Ke=!ye(Z)&&ye(Z.set)?Z.set.bind(n):En,rt=xe({get:we,set:Ke});Object.defineProperty(s,ue,{enumerable:!0,configurable:!0,get:()=>rt.value,set:Ve=>rt.value=Ve})}if(a)for(const ue in a)uh(a[ue],s,n,ue);if(l){const ue=ye(l)?l.call(n):l;Reflect.ownKeys(ue).forEach(Z=>{It(Z,ue[Z])})}c&&uu(c,e,"c");function B(ue,Z){ve(Z)?Z.forEach(we=>ue(we.bind(n))):Z&&ue(Z.bind(n))}if(B(lb,f),B(Lt,d),B(oh,h),B(cb,p),B(ib,g),B(ob,_),B(hb,Q),B(db,$),B(fb,F),B(ah,y),B(Jl,x),B(ub,P),ve(C))if(C.length){const ue=e.exposed||(e.exposed={});C.forEach(Z=>{Object.defineProperty(ue,Z,{get:()=>n[Z],set:we=>n[Z]=we,enumerable:!0})})}else e.exposed||(e.exposed={});O&&e.render===En&&(e.render=O),q!=null&&(e.inheritAttrs=q),ne&&(e.components=ne),W&&(e.directives=W),P&&sh(e)}function Eb(e,t,n=En){ve(e)&&(e=nl(e));for(const s in e){const r=e[s];let i;He(r)?"default"in r?i=Ne(r.from||s,r.default,!0):i=Ne(r.from||s):i=Ne(r),Ze(i)?Object.defineProperty(t,s,{enumerable:!0,configurable:!0,get:()=>i.value,set:o=>i.value=o}):t[s]=i}}function uu(e,t,n){Sn(ve(e)?e.map(s=>s.bind(t.proxy)):e.bind(t.proxy),t,n)}function uh(e,t,n,s){let r=s.includes(".")?xh(n,s):()=>n[s];if(et(e)){const i=t[e];ye(i)&&Je(r,i)}else if(ye(e))Je(r,e.bind(n));else if(He(e))if(ve(e))e.forEach(i=>uh(i,t,n,s));else{const i=ye(e.handler)?e.handler.bind(n):t[e.handler];ye(i)&&Je(r,i,e)}}function fh(e){const t=e.type,{mixins:n,extends:s}=t,{mixins:r,optionsCache:i,config:{optionMergeStrategies:o}}=e.appContext,a=i.get(t);let l;return a?l=a:!r.length&&!n&&!s?l=t:(l={},r.length&&r.forEach(u=>ao(l,u,o,!0)),ao(l,t,o)),He(t)&&i.set(t,l),l}function ao(e,t,n,s=!1){const{mixins:r,extends:i}=t;i&&ao(e,i,n,!0),r&&r.forEach(o=>ao(e,o,n,!0));for(const o in t)if(!(s&&o==="expose")){const a=wb[o]||n&&n[o];e[o]=a?a(e[o],t[o]):t[o]}return e}const wb={data:fu,props:du,emits:du,methods:Mr,computed:Mr,beforeCreate:At,created:At,beforeMount:At,mounted:At,beforeUpdate:At,updated:At,beforeDestroy:At,beforeUnmount:At,destroyed:At,unmounted:At,activated:At,deactivated:At,errorCaptured:At,serverPrefetch:At,components:Mr,directives:Mr,watch:xb,provide:fu,inject:Sb};function fu(e,t){return t?e?function(){return St(ye(e)?e.call(this,this):e,ye(t)?t.call(this,this):t)}:t:e}function Sb(e,t){return Mr(nl(e),nl(t))}function nl(e){if(ve(e)){const t={};for(let n=0;n<e.length;n++)t[e[n]]=e[n];return t}return e}function At(e,t){return e?[...new Set([].concat(e,t))]:t}function Mr(e,t){return e?St(Object.create(null),e,t):t}function du(e,t){return e?ve(e)&&ve(t)?[...new Set([...e,...t])]:St(Object.create(null),cu(e),cu(t??{})):t}function xb(e,t){if(!e)return t;if(!t)return e;const n=St(Object.create(null),e);for(const s in t)n[s]=At(e[s],t[s]);return n}function dh(){return{app:null,config:{isNativeTag:wd,performance:!1,globalProperties:{},optionMergeStrategies:{},errorHandler:void 0,warnHandler:void 0,compilerOptions:{}},mixins:[],components:{},directives:{},provides:Object.create(null),optionsCache:new WeakMap,propsCache:new WeakMap,emitsCache:new WeakMap}}let Tb=0;function Ab(e,t){return function(s,r=null){ye(s)||(s=St({},s)),r!=null&&!He(r)&&(r=null);const i=dh(),o=new WeakSet,a=[];let l=!1;const u=i.app={_uid:Tb++,_component:s,_props:r,_container:null,_context:i,_instance:null,version:ry,get config(){return i.config},set config(c){},use(c,...f){return o.has(c)||(c&&ye(c.install)?(o.add(c),c.install(u,...f)):ye(c)&&(o.add(c),c(u,...f))),u},mixin(c){return i.mixins.includes(c)||i.mixins.push(c),u},component(c,f){return f?(i.components[c]=f,u):i.components[c]},directive(c,f){return f?(i.directives[c]=f,u):i.directives[c]},mount(c,f,d){if(!l){const h=u._ceVNode||Ae(s,r);return h.appContext=i,d===!0?d="svg":d===!1&&(d=void 0),e(h,c,d),l=!0,u._container=c,c.__vue_app__=u,Do(h.component)}},onUnmount(c){a.push(c)},unmount(){l&&(Sn(a,u._instance,16),e(null,u._container),delete u._container.__vue_app__)},provide(c,f){return i.provides[c]=f,u},runWithContext(c){const f=nr;nr=u;try{return c()}finally{nr=f}}};return u}}let nr=null;function It(e,t){if(wt){let n=wt.provides;const s=wt.parent&&wt.parent.provides;s===n&&(n=wt.provides=Object.create(s)),n[e]=t}}function Ne(e,t,n=!1){const s=Lo();if(s||nr){let r=nr?nr._context.provides:s?s.parent==null||s.ce?s.vnode.appContext&&s.vnode.appContext.provides:s.parent.provides:void 0;if(r&&e in r)return r[e];if(arguments.length>1)return n&&ye(t)?t.call(s&&s.proxy):t}}const hh={},ph=()=>Object.create(hh),gh=e=>Object.getPrototypeOf(e)===hh;function Ob(e,t,n,s=!1){const r={},i=ph();e.propsDefaults=Object.create(null),mh(e,t,r,i);for(const o in e.propsOptions[0])o in r||(r[o]=void 0);n?e.props=s?r:Kl(r):e.type.props?e.props=r:e.props=i,e.attrs=i}function Cb(e,t,n,s){const{props:r,attrs:i,vnode:{patchFlag:o}}=e,a=Ie(r),[l]=e.propsOptions;let u=!1;if((s||o>0)&&!(o&16)){if(o&8){const c=e.vnode.dynamicProps;for(let f=0;f<c.length;f++){let d=c[f];if(ko(e.emitsOptions,d))continue;const h=t[d];if(l)if(Le(i,d))h!==i[d]&&(i[d]=h,u=!0);else{const p=Zt(d);r[p]=sl(l,a,p,h,e,!1)}else h!==i[d]&&(i[d]=h,u=!0)}}}else{mh(e,t,r,i)&&(u=!0);let c;for(const f in a)(!t||!Le(t,f)&&((c=hs(f))===f||!Le(t,c)))&&(l?n&&(n[f]!==void 0||n[c]!==void 0)&&(r[f]=sl(l,a,f,void 0,e,!0)):delete r[f]);if(i!==a)for(const f in i)(!t||!Le(t,f))&&(delete i[f],u=!0)}u&&$n(e.attrs,"set","")}function mh(e,t,n,s){const[r,i]=e.propsOptions;let o=!1,a;if(t)for(let l in t){if(kr(l))continue;const u=t[l];let c;r&&Le(r,c=Zt(l))?!i||!i.includes(c)?n[c]=u:(a||(a={}))[c]=u:ko(e.emitsOptions,l)||(!(l in s)||u!==s[l])&&(s[l]=u,o=!0)}if(i){const l=Ie(n),u=a||je;for(let c=0;c<i.length;c++){const f=i[c];n[f]=sl(r,l,f,u[f],e,!Le(u,f))}}return o}function sl(e,t,n,s,r,i){const o=e[n];if(o!=null){const a=Le(o,"default");if(a&&s===void 0){const l=o.default;if(o.type!==Function&&!o.skipFactory&&ye(l)){const{propsDefaults:u}=r;if(n in u)s=u[n];else{const c=oi(r);s=u[n]=l.call(null,t),c()}}else s=l;r.ce&&r.ce._setProp(n,s)}o[0]&&(i&&!a?s=!1:o[1]&&(s===""||s===hs(n))&&(s=!0))}return s}const Rb=new WeakMap;function vh(e,t,n=!1){const s=n?Rb:t.propsCache,r=s.get(e);if(r)return r;const i=e.props,o={},a=[];let l=!1;if(!ye(e)){const c=f=>{l=!0;const[d,h]=vh(f,t,!0);St(o,d),h&&a.push(...h)};!n&&t.mixins.length&&t.mixins.forEach(c),e.extends&&c(e.extends),e.mixins&&e.mixins.forEach(c)}if(!i&&!l)return He(e)&&s.set(e,Xs),Xs;if(ve(i))for(let c=0;c<i.length;c++){const f=Zt(i[c]);hu(f)&&(o[f]=je)}else if(i)for(const c in i){const f=Zt(c);if(hu(f)){const d=i[c],h=o[f]=ve(d)||ye(d)?{type:d}:St({},d),p=h.type;let g=!1,_=!0;if(ve(p))for(let b=0;b<p.length;++b){const y=p[b],T=ye(y)&&y.name;if(T==="Boolean"){g=!0;break}else T==="String"&&(_=!1)}else g=ye(p)&&p.name==="Boolean";h[0]=g,h[1]=_,(g||Le(h,"default"))&&a.push(f)}}const u=[o,a];return He(e)&&s.set(e,u),u}function hu(e){return e[0]!=="$"&&!kr(e)}const nc=e=>e==="_"||e==="_ctx"||e==="$stable",sc=e=>ve(e)?e.map(bn):[bn(e)],$b=(e,t,n)=>{if(t._n)return t;const s=Qt((...r)=>sc(t(...r)),n);return s._c=!1,s},bh=(e,t,n)=>{const s=e._ctx;for(const r in e){if(nc(r))continue;const i=e[r];if(ye(i))t[r]=$b(r,i,s);else if(i!=null){const o=sc(i);t[r]=()=>o}}},yh=(e,t)=>{const n=sc(t);e.slots.default=()=>n},_h=(e,t,n)=>{for(const s in t)(n||!nc(s))&&(e[s]=t[s])},Mb=(e,t,n)=>{const s=e.slots=ph();if(e.vnode.shapeFlag&32){const r=t._;r?(_h(s,t,n),n&&Ad(s,"_",r,!0)):bh(t,s)}else t&&yh(e,t)},Nb=(e,t,n)=>{const{vnode:s,slots:r}=e;let i=!0,o=je;if(s.shapeFlag&32){const a=t._;a?n&&a===1?i=!1:_h(r,t,n):(i=!t.$stable,bh(t,r)),o=t}else t&&(yh(e,t),o={default:1});if(i)for(const a in r)!nc(a)&&o[a]==null&&delete r[a]},Ft=Kb;function kb(e){return Ib(e)}function Ib(e,t){const n=xo();n.__VUE__=!0;const{insert:s,remove:r,patchProp:i,createElement:o,createText:a,createComment:l,setText:u,setElementText:c,parentNode:f,nextSibling:d,setScopeId:h=En,insertStaticContent:p}=e,g=(m,v,S,N=null,I=null,M=null,X=void 0,K=null,j=!!v.dynamicChildren)=>{if(m===v)return;m&&!Or(m,v)&&(N=R(m),Ve(m,I,M,!0),m=null),v.patchFlag===-2&&(j=!1,v.dynamicChildren=null);const{type:z,ref:de,shapeFlag:ee}=v;switch(z){case Io:_(m,v,S,N);break;case zn:b(m,v,S,N);break;case Bi:m==null&&y(v,S,N,X);break;case Xe:ne(m,v,S,N,I,M,X,K,j);break;default:ee&1?O(m,v,S,N,I,M,X,K,j):ee&6?W(m,v,S,N,I,M,X,K,j):(ee&64||ee&128)&&z.process(m,v,S,N,I,M,X,K,j,se)}de!=null&&I?Lr(de,m&&m.ref,M,v||m,!v):de==null&&m&&m.ref!=null&&Lr(m.ref,null,M,m,!0)},_=(m,v,S,N)=>{if(m==null)s(v.el=a(v.children),S,N);else{const I=v.el=m.el;v.children!==m.children&&u(I,v.children)}},b=(m,v,S,N)=>{m==null?s(v.el=l(v.children||""),S,N):v.el=m.el},y=(m,v,S,N)=>{[m.el,m.anchor]=p(m.children,v,S,N,m.el,m.anchor)},T=({el:m,anchor:v},S,N)=>{let I;for(;m&&m!==v;)I=d(m),s(m,S,N),m=I;s(v,S,N)},x=({el:m,anchor:v})=>{let S;for(;m&&m!==v;)S=d(m),r(m),m=S;r(v)},O=(m,v,S,N,I,M,X,K,j)=>{v.type==="svg"?X="svg":v.type==="math"&&(X="mathml"),m==null?$(v,S,N,I,M,X,K,j):P(m,v,I,M,X,K,j)},$=(m,v,S,N,I,M,X,K)=>{let j,z;const{props:de,shapeFlag:ee,transition:ae,dirs:me}=m;if(j=m.el=o(m.type,M,de&&de.is,de),ee&8?c(j,m.children):ee&16&&Q(m.children,j,null,N,I,ha(m,M),X,K),me&&Es(m,null,N,"created"),F(j,m,m.scopeId,X,N),de){for(const ke in de)ke!=="value"&&!kr(ke)&&i(j,ke,null,de[ke],M,N);"value"in de&&i(j,"value",null,de.value,M),(z=de.onVnodeBeforeMount)&&mn(z,N,m)}me&&Es(m,null,N,"beforeMount");const _e=Pb(I,ae);_e&&ae.beforeEnter(j),s(j,v,S),((z=de&&de.onVnodeMounted)||_e||me)&&Ft(()=>{z&&mn(z,N,m),_e&&ae.enter(j),me&&Es(m,null,N,"mounted")},I)},F=(m,v,S,N,I)=>{if(S&&h(m,S),N)for(let M=0;M<N.length;M++)h(m,N[M]);if(I){let M=I.subTree;if(v===M||Ah(M.type)&&(M.ssContent===v||M.ssFallback===v)){const X=I.vnode;F(m,X,X.scopeId,X.slotScopeIds,I.parent)}}},Q=(m,v,S,N,I,M,X,K,j=0)=>{for(let z=j;z<m.length;z++){const de=m[z]=K?Zn(m[z]):bn(m[z]);g(null,de,v,S,N,I,M,X,K)}},P=(m,v,S,N,I,M,X)=>{const K=v.el=m.el;let{patchFlag:j,dynamicChildren:z,dirs:de}=v;j|=m.patchFlag&16;const ee=m.props||je,ae=v.props||je;let me;if(S&&ws(S,!1),(me=ae.onVnodeBeforeUpdate)&&mn(me,S,v,m),de&&Es(v,m,S,"beforeUpdate"),S&&ws(S,!0),(ee.innerHTML&&ae.innerHTML==null||ee.textContent&&ae.textContent==null)&&c(K,""),z?C(m.dynamicChildren,z,K,S,N,ha(v,I),M):X||Z(m,v,K,null,S,N,ha(v,I),M,!1),j>0){if(j&16)q(K,ee,ae,S,I);else if(j&2&&ee.class!==ae.class&&i(K,"class",null,ae.class,I),j&4&&i(K,"style",ee.style,ae.style,I),j&8){const _e=v.dynamicProps;for(let ke=0;ke<_e.length;ke++){const Re=_e[ke],mt=ee[Re],vt=ae[Re];(vt!==mt||Re==="value")&&i(K,Re,mt,vt,I,S)}}j&1&&m.children!==v.children&&c(K,v.children)}else!X&&z==null&&q(K,ee,ae,S,I);((me=ae.onVnodeUpdated)||de)&&Ft(()=>{me&&mn(me,S,v,m),de&&Es(v,m,S,"updated")},N)},C=(m,v,S,N,I,M,X)=>{for(let K=0;K<v.length;K++){const j=m[K],z=v[K],de=j.el&&(j.type===Xe||!Or(j,z)||j.shapeFlag&198)?f(j.el):S;g(j,z,de,null,N,I,M,X,!0)}},q=(m,v,S,N,I)=>{if(v!==S){if(v!==je)for(const M in v)!kr(M)&&!(M in S)&&i(m,M,v[M],null,I,N);for(const M in S){if(kr(M))continue;const X=S[M],K=v[M];X!==K&&M!=="value"&&i(m,M,K,X,I,N)}"value"in S&&i(m,"value",v.value,S.value,I)}},ne=(m,v,S,N,I,M,X,K,j)=>{const z=v.el=m?m.el:a(""),de=v.anchor=m?m.anchor:a("");let{patchFlag:ee,dynamicChildren:ae,slotScopeIds:me}=v;me&&(K=K?K.concat(me):me),m==null?(s(z,S,N),s(de,S,N),Q(v.children||[],S,de,I,M,X,K,j)):ee>0&&ee&64&&ae&&m.dynamicChildren?(C(m.dynamicChildren,ae,S,I,M,X,K),(v.key!=null||I&&v===I.subTree)&&Eh(m,v,!0)):Z(m,v,S,de,I,M,X,K,j)},W=(m,v,S,N,I,M,X,K,j)=>{v.slotScopeIds=K,m==null?v.shapeFlag&512?I.ctx.activate(v,S,N,X,j):L(v,S,N,I,M,X,j):le(m,v,j)},L=(m,v,S,N,I,M,X)=>{const K=m.component=Jb(m,N,I);if(rh(m)&&(K.ctx.renderer=se),Zb(K,!1,X),K.asyncDep){if(I&&I.registerDep(K,B,X),!m.el){const j=K.subTree=Ae(zn);b(null,j,v,S),m.placeholder=j.el}}else B(K,m,v,S,I,M,X)},le=(m,v,S)=>{const N=v.component=m.component;if(Ub(m,v,S))if(N.asyncDep&&!N.asyncResolved){ue(N,v,S);return}else N.next=v,N.update();else v.el=m.el,N.vnode=v},B=(m,v,S,N,I,M,X)=>{const K=()=>{if(m.isMounted){let{next:ee,bu:ae,u:me,parent:_e,vnode:ke}=m;{const qt=wh(m);if(qt){ee&&(ee.el=ke.el,ue(m,ee,X)),qt.asyncDep.then(()=>{m.isUnmounted||K()});return}}let Re=ee,mt;ws(m,!1),ee?(ee.el=ke.el,ue(m,ee,X)):ee=ke,ae&&Vi(ae),(mt=ee.props&&ee.props.onVnodeBeforeUpdate)&&mn(mt,_e,ee,ke),ws(m,!0);const vt=gu(m),Ut=m.subTree;m.subTree=vt,g(Ut,vt,f(Ut.el),R(Ut),m,I,M),ee.el=vt.el,Re===null&&qb(m,vt.el),me&&Ft(me,I),(mt=ee.props&&ee.props.onVnodeUpdated)&&Ft(()=>mn(mt,_e,ee,ke),I)}else{let ee;const{el:ae,props:me}=v,{bm:_e,m:ke,parent:Re,root:mt,type:vt}=m,Ut=tr(v);ws(m,!1),_e&&Vi(_e),!Ut&&(ee=me&&me.onVnodeBeforeMount)&&mn(ee,Re,v),ws(m,!0);{mt.ce&&mt.ce._def.shadowRoot!==!1&&mt.ce._injectChildStyle(vt);const qt=m.subTree=gu(m);g(null,qt,S,N,m,I,M),v.el=qt.el}if(ke&&Ft(ke,I),!Ut&&(ee=me&&me.onVnodeMounted)){const qt=v;Ft(()=>mn(ee,Re,qt),I)}(v.shapeFlag&256||Re&&tr(Re.vnode)&&Re.vnode.shapeFlag&256)&&m.a&&Ft(m.a,I),m.isMounted=!0,v=S=N=null}};m.scope.on();const j=m.effect=new kd(K);m.scope.off();const z=m.update=j.run.bind(j),de=m.job=j.runIfDirty.bind(j);de.i=m,de.id=m.uid,j.scheduler=()=>Ql(de),ws(m,!0),z()},ue=(m,v,S)=>{v.component=m;const N=m.vnode.props;m.vnode=v,m.next=null,Cb(m,v.props,N,S),Nb(m,v.children,S),Ln(),iu(m),Dn()},Z=(m,v,S,N,I,M,X,K,j=!1)=>{const z=m&&m.children,de=m?m.shapeFlag:0,ee=v.children,{patchFlag:ae,shapeFlag:me}=v;if(ae>0){if(ae&128){Ke(z,ee,S,N,I,M,X,K,j);return}else if(ae&256){we(z,ee,S,N,I,M,X,K,j);return}}me&8?(de&16&&Qe(z,I,M),ee!==z&&c(S,ee)):de&16?me&16?Ke(z,ee,S,N,I,M,X,K,j):Qe(z,I,M,!0):(de&8&&c(S,""),me&16&&Q(ee,S,N,I,M,X,K,j))},we=(m,v,S,N,I,M,X,K,j)=>{m=m||Xs,v=v||Xs;const z=m.length,de=v.length,ee=Math.min(z,de);let ae;for(ae=0;ae<ee;ae++){const me=v[ae]=j?Zn(v[ae]):bn(v[ae]);g(m[ae],me,S,null,I,M,X,K,j)}z>de?Qe(m,I,M,!0,!1,ee):Q(v,S,N,I,M,X,K,j,ee)},Ke=(m,v,S,N,I,M,X,K,j)=>{let z=0;const de=v.length;let ee=m.length-1,ae=de-1;for(;z<=ee&&z<=ae;){const me=m[z],_e=v[z]=j?Zn(v[z]):bn(v[z]);if(Or(me,_e))g(me,_e,S,null,I,M,X,K,j);else break;z++}for(;z<=ee&&z<=ae;){const me=m[ee],_e=v[ae]=j?Zn(v[ae]):bn(v[ae]);if(Or(me,_e))g(me,_e,S,null,I,M,X,K,j);else break;ee--,ae--}if(z>ee){if(z<=ae){const me=ae+1,_e=me<de?v[me].el:N;for(;z<=ae;)g(null,v[z]=j?Zn(v[z]):bn(v[z]),S,_e,I,M,X,K,j),z++}}else if(z>ae)for(;z<=ee;)Ve(m[z],I,M,!0),z++;else{const me=z,_e=z,ke=new Map;for(z=_e;z<=ae;z++){const Tt=v[z]=j?Zn(v[z]):bn(v[z]);Tt.key!=null&&ke.set(Tt.key,z)}let Re,mt=0;const vt=ae-_e+1;let Ut=!1,qt=0;const ys=new Array(vt);for(z=0;z<vt;z++)ys[z]=0;for(z=me;z<=ee;z++){const Tt=m[z];if(mt>=vt){Ve(Tt,I,M,!0);continue}let Kt;if(Tt.key!=null)Kt=ke.get(Tt.key);else for(Re=_e;Re<=ae;Re++)if(ys[Re-_e]===0&&Or(Tt,v[Re])){Kt=Re;break}Kt===void 0?Ve(Tt,I,M,!0):(ys[Kt-_e]=z+1,Kt>=qt?qt=Kt:Ut=!0,g(Tt,v[Kt],S,null,I,M,X,K,j),mt++)}const xr=Ut?Lb(ys):Xs;for(Re=xr.length-1,z=vt-1;z>=0;z--){const Tt=_e+z,Kt=v[Tt],_i=v[Tt+1],Ds=Tt+1<de?_i.el||_i.placeholder:N;ys[z]===0?g(null,Kt,S,Ds,I,M,X,K,j):Ut&&(Re<0||z!==xr[Re]?rt(Kt,S,Ds,2):Re--)}}},rt=(m,v,S,N,I=null)=>{const{el:M,type:X,transition:K,children:j,shapeFlag:z}=m;if(z&6){rt(m.component.subTree,v,S,N);return}if(z&128){m.suspense.move(v,S,N);return}if(z&64){X.move(m,v,S,se);return}if(X===Xe){s(M,v,S);for(let ee=0;ee<j.length;ee++)rt(j[ee],v,S,N);s(m.anchor,v,S);return}if(X===Bi){T(m,v,S);return}if(N!==2&&z&1&&K)if(N===0)K.beforeEnter(M),s(M,v,S),Ft(()=>K.enter(M),I);else{const{leave:ee,delayLeave:ae,afterLeave:me}=K,_e=()=>{m.ctx.isUnmounted?r(M):s(M,v,S)},ke=()=>{M._isLeaving&&M[rb](!0),ee(M,()=>{_e(),me&&me()})};ae?ae(M,_e,ke):ke()}else s(M,v,S)},Ve=(m,v,S,N=!1,I=!1)=>{const{type:M,props:X,ref:K,children:j,dynamicChildren:z,shapeFlag:de,patchFlag:ee,dirs:ae,cacheIndex:me}=m;if(ee===-2&&(I=!1),K!=null&&(Ln(),Lr(K,null,S,m,!0),Dn()),me!=null&&(v.renderCache[me]=void 0),de&256){v.ctx.deactivate(m);return}const _e=de&1&&ae,ke=!tr(m);let Re;if(ke&&(Re=X&&X.onVnodeBeforeUnmount)&&mn(Re,v,m),de&6)tt(m.component,S,N);else{if(de&128){m.suspense.unmount(S,N);return}_e&&Es(m,null,v,"beforeUnmount"),de&64?m.type.remove(m,v,S,se,N):z&&!z.hasOnce&&(M!==Xe||ee>0&&ee&64)?Qe(z,v,S,!1,!0):(M===Xe&&ee&384||!I&&de&16)&&Qe(j,v,S),N&&it(m)}(ke&&(Re=X&&X.onVnodeUnmounted)||_e)&&Ft(()=>{Re&&mn(Re,v,m),_e&&Es(m,null,v,"unmounted")},S)},it=m=>{const{type:v,el:S,anchor:N,transition:I}=m;if(v===Xe){ct(S,N);return}if(v===Bi){x(m);return}const M=()=>{r(S),I&&!I.persisted&&I.afterLeave&&I.afterLeave()};if(m.shapeFlag&1&&I&&!I.persisted){const{leave:X,delayLeave:K}=I,j=()=>X(S,M);K?K(m.el,M,j):j()}else M()},ct=(m,v)=>{let S;for(;m!==v;)S=d(m),r(m),m=S;r(v)},tt=(m,v,S)=>{const{bum:N,scope:I,job:M,subTree:X,um:K,m:j,a:z}=m;pu(j),pu(z),N&&Vi(N),I.stop(),M&&(M.flags|=8,Ve(X,m,v,S)),K&&Ft(K,v),Ft(()=>{m.isUnmounted=!0},v)},Qe=(m,v,S,N=!1,I=!1,M=0)=>{for(let X=M;X<m.length;X++)Ve(m[X],v,S,N,I)},R=m=>{if(m.shapeFlag&6)return R(m.component.subTree);if(m.shapeFlag&128)return m.suspense.next();const v=d(m.anchor||m.el),S=v&&v[nb];return S?d(S):v};let G=!1;const Y=(m,v,S)=>{m==null?v._vnode&&Ve(v._vnode,null,null,!0):g(v._vnode||null,m,v,null,null,null,S),v._vnode=m,G||(G=!0,iu(),th(),G=!1)},se={p:g,um:Ve,m:rt,r:it,mt:L,mc:Q,pc:Z,pbc:C,n:R,o:e};return{render:Y,hydrate:void 0,createApp:Ab(Y)}}function ha({type:e,props:t},n){return n==="svg"&&e==="foreignObject"||n==="mathml"&&e==="annotation-xml"&&t&&t.encoding&&t.encoding.includes("html")?void 0:n}function ws({effect:e,job:t},n){n?(e.flags|=32,t.flags|=4):(e.flags&=-33,t.flags&=-5)}function Pb(e,t){return(!e||e&&!e.pendingBranch)&&t&&!t.persisted}function Eh(e,t,n=!1){const s=e.children,r=t.children;if(ve(s)&&ve(r))for(let i=0;i<s.length;i++){const o=s[i];let a=r[i];a.shapeFlag&1&&!a.dynamicChildren&&((a.patchFlag<=0||a.patchFlag===32)&&(a=r[i]=Zn(r[i]),a.el=o.el),!n&&a.patchFlag!==-2&&Eh(o,a)),a.type===Io&&a.patchFlag!==-1&&(a.el=o.el),a.type===zn&&!a.el&&(a.el=o.el)}}function Lb(e){const t=e.slice(),n=[0];let s,r,i,o,a;const l=e.length;for(s=0;s<l;s++){const u=e[s];if(u!==0){if(r=n[n.length-1],e[r]<u){t[s]=r,n.push(s);continue}for(i=0,o=n.length-1;i<o;)a=i+o>>1,e[n[a]]<u?i=a+1:o=a;u<e[n[i]]&&(i>0&&(t[s]=n[i-1]),n[i]=s)}}for(i=n.length,o=n[i-1];i-- >0;)n[i]=o,o=t[o];return n}function wh(e){const t=e.subTree.component;if(t)return t.asyncDep&&!t.asyncResolved?t:wh(t)}function pu(e){if(e)for(let t=0;t<e.length;t++)e[t].flags|=8}const Db=Symbol.for("v-scx"),Fb=()=>Ne(Db);function Sh(e,t){return rc(e,null,t)}function Je(e,t,n){return rc(e,t,n)}function rc(e,t,n=je){const{immediate:s,deep:r,flush:i,once:o}=n,a=St({},n),l=t&&s||!t&&i!=="post";let u;if(Xr){if(i==="sync"){const h=Fb();u=h.__watcherHandles||(h.__watcherHandles=[])}else if(!l){const h=()=>{};return h.stop=En,h.resume=En,h.pause=En,h}}const c=wt;a.call=(h,p,g)=>Sn(h,c,p,g);let f=!1;i==="post"?a.scheduler=h=>{Ft(h,c&&c.suspense)}:i!=="sync"&&(f=!0,a.scheduler=(h,p)=>{p?h():Ql(h)}),a.augmentJob=h=>{t&&(h.flags|=4),f&&(h.flags|=2,c&&(h.id=c.uid,h.i=c))};const d=Gv(e,t,a);return Xr&&(u?u.push(d):l&&d()),d}function zb(e,t,n){const s=this.proxy,r=et(e)?e.includes(".")?xh(s,e):()=>s[e]:e.bind(s,s);let i;ye(t)?i=t:(i=t.handler,n=t);const o=oi(this),a=rc(r,i.bind(s),n);return o(),a}function xh(e,t){const n=t.split(".");return()=>{let s=e;for(let r=0;r<n.length&&s;r++)s=s[n[r]];return s}}const jb=(e,t)=>t==="modelValue"||t==="model-value"?e.modelModifiers:e[\`\${t}Modifiers\`]||e[\`\${Zt(t)}Modifiers\`]||e[\`\${hs(t)}Modifiers\`];function Hb(e,t,...n){if(e.isUnmounted)return;const s=e.vnode.props||je;let r=n;const i=t.startsWith("update:"),o=i&&jb(s,t.slice(7));o&&(o.trim&&(r=n.map(c=>et(c)?c.trim():c)),o.number&&(r=n.map(Qa)));let a,l=s[a=Hi(t)]||s[a=Hi(Zt(t))];!l&&i&&(l=s[a=Hi(hs(t))]),l&&Sn(l,e,6,r);const u=s[a+"Once"];if(u){if(!e.emitted)e.emitted={};else if(e.emitted[a])return;e.emitted[a]=!0,Sn(u,e,6,r)}}const Vb=new WeakMap;function Th(e,t,n=!1){const s=n?Vb:t.emitsCache,r=s.get(e);if(r!==void 0)return r;const i=e.emits;let o={},a=!1;if(!ye(e)){const l=u=>{const c=Th(u,t,!0);c&&(a=!0,St(o,c))};!n&&t.mixins.length&&t.mixins.forEach(l),e.extends&&l(e.extends),e.mixins&&e.mixins.forEach(l)}return!i&&!a?(He(e)&&s.set(e,null),null):(ve(i)?i.forEach(l=>o[l]=null):St(o,i),He(e)&&s.set(e,o),o)}function ko(e,t){return!e||!_o(t)?!1:(t=t.slice(2).replace(/Once$/,""),Le(e,t[0].toLowerCase()+t.slice(1))||Le(e,hs(t))||Le(e,t))}function gu(e){const{type:t,vnode:n,proxy:s,withProxy:r,propsOptions:[i],slots:o,attrs:a,emit:l,render:u,renderCache:c,props:f,data:d,setupState:h,ctx:p,inheritAttrs:g}=e,_=io(e);let b,y;try{if(n.shapeFlag&4){const x=r||s,O=x;b=bn(u.call(O,x,c,f,h,d,p)),y=a}else{const x=t;b=bn(x.length>1?x(f,{attrs:a,slots:o,emit:l}):x(f,null)),y=t.props?a:Bb(a)}}catch(x){Fr.length=0,$o(x,e,1),b=Ae(zn)}let T=b;if(y&&g!==!1){const x=Object.keys(y),{shapeFlag:O}=T;x.length&&O&7&&(i&&x.some(Hl)&&(y=Wb(y,i)),T=ir(T,y,!1,!0))}return n.dirs&&(T=ir(T,null,!1,!0),T.dirs=T.dirs?T.dirs.concat(n.dirs):n.dirs),n.transition&&Xl(T,n.transition),b=T,io(_),b}const Bb=e=>{let t;for(const n in e)(n==="class"||n==="style"||_o(n))&&((t||(t={}))[n]=e[n]);return t},Wb=(e,t)=>{const n={};for(const s in e)(!Hl(s)||!(s.slice(9)in t))&&(n[s]=e[s]);return n};function Ub(e,t,n){const{props:s,children:r,component:i}=e,{props:o,children:a,patchFlag:l}=t,u=i.emitsOptions;if(t.dirs||t.transition)return!0;if(n&&l>=0){if(l&1024)return!0;if(l&16)return s?mu(s,o,u):!!o;if(l&8){const c=t.dynamicProps;for(let f=0;f<c.length;f++){const d=c[f];if(o[d]!==s[d]&&!ko(u,d))return!0}}}else return(r||a)&&(!a||!a.$stable)?!0:s===o?!1:s?o?mu(s,o,u):!0:!!o;return!1}function mu(e,t,n){const s=Object.keys(t);if(s.length!==Object.keys(e).length)return!0;for(let r=0;r<s.length;r++){const i=s[r];if(t[i]!==e[i]&&!ko(n,i))return!0}return!1}function qb({vnode:e,parent:t},n){for(;t;){const s=t.subTree;if(s.suspense&&s.suspense.activeBranch===e&&(s.el=e.el),s===e)(e=t.vnode).el=n,t=t.parent;else break}}const Ah=e=>e.__isSuspense;function Kb(e,t){t&&t.pendingBranch?ve(e)?t.effects.push(...e):t.effects.push(e):Jv(e)}const Xe=Symbol.for("v-fgt"),Io=Symbol.for("v-txt"),zn=Symbol.for("v-cmt"),Bi=Symbol.for("v-stc"),Fr=[];let zt=null;function H(e=!1){Fr.push(zt=e?null:[])}function Yb(){Fr.pop(),zt=Fr[Fr.length-1]||null}let Gr=1;function lo(e,t=!1){Gr+=e,e<0&&zt&&t&&(zt.hasOnce=!0)}function Oh(e){return e.dynamicChildren=Gr>0?zt||Xs:null,Yb(),Gr>0&&zt&&zt.push(e),e}function oe(e,t,n,s,r,i){return Oh(w(e,t,n,s,r,i,!0))}function qe(e,t,n,s,r){return Oh(Ae(e,t,n,s,r,!0))}function Qr(e){return e?e.__v_isVNode===!0:!1}function Or(e,t){return e.type===t.type&&e.key===t.key}const Ch=({key:e})=>e??null,Wi=({ref:e,ref_key:t,ref_for:n})=>(typeof e=="number"&&(e=""+e),e!=null?et(e)||Ze(e)||ye(e)?{i:gt,r:e,k:t,f:!!n}:e:null);function w(e,t=null,n=null,s=0,r=null,i=e===Xe?0:1,o=!1,a=!1){const l={__v_isVNode:!0,__v_skip:!0,type:e,props:t,key:t&&Ch(t),ref:t&&Wi(t),scopeId:Mo,slotScopeIds:null,children:n,component:null,suspense:null,ssContent:null,ssFallback:null,dirs:null,transition:null,el:null,anchor:null,target:null,targetStart:null,targetAnchor:null,staticCount:0,shapeFlag:i,patchFlag:s,dynamicProps:r,dynamicChildren:null,appContext:null,ctx:gt};return a?(oc(l,n),i&128&&e.normalize(l)):n&&(l.shapeFlag|=et(n)?8:16),Gr>0&&!o&&zt&&(l.patchFlag>0||i&6)&&l.patchFlag!==32&&zt.push(l),l}const Ae=Gb;function Gb(e,t=null,n=null,s=0,r=null,i=!1){if((!e||e===lh)&&(e=zn),Qr(e)){const a=ir(e,t,!0);return n&&oc(a,n),Gr>0&&!i&&zt&&(a.shapeFlag&6?zt[zt.indexOf(e)]=a:zt.push(a)),a.patchFlag=-2,a}if(sy(e)&&(e=e.__vccOpts),t){t=ic(t);let{class:a,style:l}=t;a&&!et(a)&&(t.class=$t(a)),He(l)&&(Yl(l)&&!ve(l)&&(l=St({},l)),t.style=ri(l))}const o=et(e)?1:Ah(e)?128:sb(e)?64:He(e)?4:ye(e)?2:0;return w(e,t,n,s,r,o,i,!0)}function ic(e){return e?Yl(e)||gh(e)?St({},e):e:null}function ir(e,t,n=!1,s=!1){const{props:r,ref:i,patchFlag:o,children:a,transition:l}=e,u=t?Po(r||{},t):r,c={__v_isVNode:!0,__v_skip:!0,type:e.type,props:u,key:u&&Ch(u),ref:t&&t.ref?n&&i?ve(i)?i.concat(Wi(t)):[i,Wi(t)]:Wi(t):i,scopeId:e.scopeId,slotScopeIds:e.slotScopeIds,children:a,target:e.target,targetStart:e.targetStart,targetAnchor:e.targetAnchor,staticCount:e.staticCount,shapeFlag:e.shapeFlag,patchFlag:t&&e.type!==Xe?o===-1?16:o|16:o,dynamicProps:e.dynamicProps,dynamicChildren:e.dynamicChildren,appContext:e.appContext,dirs:e.dirs,transition:l,component:e.component,suspense:e.suspense,ssContent:e.ssContent&&ir(e.ssContent),ssFallback:e.ssFallback&&ir(e.ssFallback),placeholder:e.placeholder,el:e.el,anchor:e.anchor,ctx:e.ctx,ce:e.ce};return l&&s&&Xl(c,l.clone(c)),c}function ze(e=" ",t=0){return Ae(Io,null,e,t)}function rl(e,t){const n=Ae(Bi,null,e);return n.staticCount=t,n}function Ce(e="",t=!1){return t?(H(),qe(zn,null,e)):Ae(zn,null,e)}function bn(e){return e==null||typeof e=="boolean"?Ae(zn):ve(e)?Ae(Xe,null,e.slice()):Qr(e)?Zn(e):Ae(Io,null,String(e))}function Zn(e){return e.el===null&&e.patchFlag!==-1||e.memo?e:ir(e)}function oc(e,t){let n=0;const{shapeFlag:s}=e;if(t==null)t=null;else if(ve(t))n=16;else if(typeof t=="object")if(s&65){const r=t.default;r&&(r._c&&(r._d=!1),oc(e,r()),r._c&&(r._d=!0));return}else{n=32;const r=t._;!r&&!gh(t)?t._ctx=gt:r===3&&gt&&(gt.slots._===1?t._=1:(t._=2,e.patchFlag|=1024))}else ye(t)?(t={default:t,_ctx:gt},n=32):(t=String(t),s&64?(n=16,t=[ze(t)]):n=8);e.children=t,e.shapeFlag|=n}function Po(...e){const t={};for(let n=0;n<e.length;n++){const s=e[n];for(const r in s)if(r==="class")t.class!==s.class&&(t.class=$t([t.class,s.class]));else if(r==="style")t.style=ri([t.style,s.style]);else if(_o(r)){const i=t[r],o=s[r];o&&i!==o&&!(ve(i)&&i.includes(o))&&(t[r]=i?[].concat(i,o):o)}else r!==""&&(t[r]=s[r])}return t}function mn(e,t,n,s=null){Sn(e,t,7,[n,s])}const Qb=dh();let Xb=0;function Jb(e,t,n){const s=e.type,r=(t?t.appContext:e.appContext)||Qb,i={uid:Xb++,vnode:e,type:s,parent:t,appContext:r,root:null,next:null,subTree:null,effect:null,update:null,job:null,scope:new vv(!0),render:null,proxy:null,exposed:null,exposeProxy:null,withProxy:null,provides:t?t.provides:Object.create(r.provides),ids:t?t.ids:["",0,0],accessCache:null,renderCache:[],components:null,directives:null,propsOptions:vh(s,r),emitsOptions:Th(s,r),emit:null,emitted:null,propsDefaults:je,inheritAttrs:s.inheritAttrs,ctx:je,data:je,props:je,attrs:je,slots:je,refs:je,setupState:je,setupContext:null,suspense:n,suspenseId:n?n.pendingId:0,asyncDep:null,asyncResolved:!1,isMounted:!1,isUnmounted:!1,isDeactivated:!1,bc:null,c:null,bm:null,m:null,bu:null,u:null,um:null,bum:null,da:null,a:null,rtg:null,rtc:null,ec:null,sp:null};return i.ctx={_:i},i.root=t?t.root:i,i.emit=Hb.bind(null,i),e.ce&&e.ce(i),i}let wt=null;const Lo=()=>wt||gt;let co,il;{const e=xo(),t=(n,s)=>{let r;return(r=e[n])||(r=e[n]=[]),r.push(s),i=>{r.length>1?r.forEach(o=>o(i)):r[0](i)}};co=t("__VUE_INSTANCE_SETTERS__",n=>wt=n),il=t("__VUE_SSR_SETTERS__",n=>Xr=n)}const oi=e=>{const t=wt;return co(e),e.scope.on(),()=>{e.scope.off(),co(t)}},vu=()=>{wt&&wt.scope.off(),co(null)};function Rh(e){return e.vnode.shapeFlag&4}let Xr=!1;function Zb(e,t=!1,n=!1){t&&il(t);const{props:s,children:r}=e.vnode,i=Rh(e);Ob(e,s,i,t),Mb(e,r,n||t);const o=i?ey(e,t):void 0;return t&&il(!1),o}function ey(e,t){const n=e.type;e.accessCache=Object.create(null),e.proxy=new Proxy(e.ctx,vb);const{setup:s}=n;if(s){Ln();const r=e.setupContext=s.length>1?Mh(e):null,i=oi(e),o=ii(s,e,0,[e.props,r]),a=Sd(o);if(Dn(),i(),(a||e.sp)&&!tr(e)&&sh(e),a){if(o.then(vu,vu),t)return o.then(l=>{bu(e,l)}).catch(l=>{$o(l,e,0)});e.asyncDep=o}else bu(e,o)}else $h(e)}function bu(e,t,n){ye(t)?e.type.__ssrInlineRender?e.ssrRender=t:e.render=t:He(t)&&(e.setupState=Jd(t)),$h(e)}function $h(e,t,n){const s=e.type;e.render||(e.render=s.render||En);{const r=oi(e);Ln();try{_b(e)}finally{Dn(),r()}}}const ty={get(e,t){return Et(e,"get",""),e[t]}};function Mh(e){const t=n=>{e.exposed=n||{}};return{attrs:new Proxy(e.attrs,ty),slots:e.slots,emit:e.emit,expose:t}}function Do(e){return e.exposed?e.exposeProxy||(e.exposeProxy=new Proxy(Jd(Qd(e.exposed)),{get(t,n){if(n in t)return t[n];if(n in Dr)return Dr[n](e)},has(t,n){return n in t||n in Dr}})):e.proxy}function ny(e,t=!0){return ye(e)?e.displayName||e.name:e.name||t&&e.__name}function sy(e){return ye(e)&&"__vccOpts"in e}const xe=(e,t)=>Kv(e,t,Xr);function Fo(e,t,n){const s=(i,o,a)=>{lo(-1);try{return Ae(i,o,a)}finally{lo(1)}},r=arguments.length;return r===2?He(t)&&!ve(t)?Qr(t)?s(e,null,[t]):s(e,t):s(e,null,t):(r>3?n=Array.prototype.slice.call(arguments,2):r===3&&Qr(n)&&(n=[n]),s(e,t,n))}const ry="3.5.21";/**
* @vue/runtime-dom v3.5.21
* (c) 2018-present Yuxi (Evan) You and Vue contributors
* @license MIT
**/let ol;const yu=typeof window<"u"&&window.trustedTypes;if(yu)try{ol=yu.createPolicy("vue",{createHTML:e=>e})}catch{}const Nh=ol?e=>ol.createHTML(e):e=>e,iy="http://www.w3.org/2000/svg",oy="http://www.w3.org/1998/Math/MathML",Rn=typeof document<"u"?document:null,_u=Rn&&Rn.createElement("template"),ay={insert:(e,t,n)=>{t.insertBefore(e,n||null)},remove:e=>{const t=e.parentNode;t&&t.removeChild(e)},createElement:(e,t,n,s)=>{const r=t==="svg"?Rn.createElementNS(iy,e):t==="mathml"?Rn.createElementNS(oy,e):n?Rn.createElement(e,{is:n}):Rn.createElement(e);return e==="select"&&s&&s.multiple!=null&&r.setAttribute("multiple",s.multiple),r},createText:e=>Rn.createTextNode(e),createComment:e=>Rn.createComment(e),setText:(e,t)=>{e.nodeValue=t},setElementText:(e,t)=>{e.textContent=t},parentNode:e=>e.parentNode,nextSibling:e=>e.nextSibling,querySelector:e=>Rn.querySelector(e),setScopeId(e,t){e.setAttribute(t,"")},insertStaticContent(e,t,n,s,r,i){const o=n?n.previousSibling:t.lastChild;if(r&&(r===i||r.nextSibling))for(;t.insertBefore(r.cloneNode(!0),n),!(r===i||!(r=r.nextSibling)););else{_u.innerHTML=Nh(s==="svg"?\`<svg>\${e}</svg>\`:s==="mathml"?\`<math>\${e}</math>\`:e);const a=_u.content;if(s==="svg"||s==="mathml"){const l=a.firstChild;for(;l.firstChild;)a.appendChild(l.firstChild);a.removeChild(l)}t.insertBefore(a,n)}return[o?o.nextSibling:t.firstChild,n?n.previousSibling:t.lastChild]}},ly=Symbol("_vtc");function cy(e,t,n){const s=e[ly];s&&(t=(t?[t,...s]:[...s]).join(" ")),t==null?e.removeAttribute("class"):n?e.setAttribute("class",t):e.className=t}const Eu=Symbol("_vod"),uy=Symbol("_vsh"),fy=Symbol(""),dy=/(?:^|;)\\s*display\\s*:/;function hy(e,t,n){const s=e.style,r=et(n);let i=!1;if(n&&!r){if(t)if(et(t))for(const o of t.split(";")){const a=o.slice(0,o.indexOf(":")).trim();n[a]==null&&Ui(s,a,"")}else for(const o in t)n[o]==null&&Ui(s,o,"");for(const o in n)o==="display"&&(i=!0),Ui(s,o,n[o])}else if(r){if(t!==n){const o=s[fy];o&&(n+=";"+o),s.cssText=n,i=dy.test(n)}}else t&&e.removeAttribute("style");Eu in e&&(e[Eu]=i?s.display:"",e[uy]&&(s.display="none"))}const wu=/\\s*!important$/;function Ui(e,t,n){if(ve(n))n.forEach(s=>Ui(e,t,s));else if(n==null&&(n=""),t.startsWith("--"))e.setProperty(t,n);else{const s=py(e,t);wu.test(n)?e.setProperty(hs(s),n.replace(wu,""),"important"):e[s]=n}}const Su=["Webkit","Moz","ms"],pa={};function py(e,t){const n=pa[t];if(n)return n;let s=Zt(t);if(s!=="filter"&&s in e)return pa[t]=s;s=So(s);for(let r=0;r<Su.length;r++){const i=Su[r]+s;if(i in e)return pa[t]=i}return t}const xu="http://www.w3.org/1999/xlink";function Tu(e,t,n,s,r,i=gv(t)){s&&t.startsWith("xlink:")?n==null?e.removeAttributeNS(xu,t.slice(6,t.length)):e.setAttributeNS(xu,t,n):n==null||i&&!Cd(n)?e.removeAttribute(t):e.setAttribute(t,i?"":cn(n)?String(n):n)}function Au(e,t,n,s,r){if(t==="innerHTML"||t==="textContent"){n!=null&&(e[t]=t==="innerHTML"?Nh(n):n);return}const i=e.tagName;if(t==="value"&&i!=="PROGRESS"&&!i.includes("-")){const a=i==="OPTION"?e.getAttribute("value")||"":e.value,l=n==null?e.type==="checkbox"?"on":"":String(n);(a!==l||!("_value"in e))&&(e.value=l),n==null&&e.removeAttribute(t),e._value=n;return}let o=!1;if(n===""||n==null){const a=typeof e[t];a==="boolean"?n=Cd(n):n==null&&a==="string"?(n="",o=!0):a==="number"&&(n=0,o=!0)}try{e[t]=n}catch{}o&&e.removeAttribute(r||t)}function ts(e,t,n,s){e.addEventListener(t,n,s)}function gy(e,t,n,s){e.removeEventListener(t,n,s)}const Ou=Symbol("_vei");function my(e,t,n,s,r=null){const i=e[Ou]||(e[Ou]={}),o=i[t];if(s&&o)o.value=s;else{const[a,l]=vy(t);if(s){const u=i[t]=_y(s,r);ts(e,a,u,l)}else o&&(gy(e,a,o,l),i[t]=void 0)}}const Cu=/(?:Once|Passive|Capture)$/;function vy(e){let t;if(Cu.test(e)){t={};let s;for(;s=e.match(Cu);)e=e.slice(0,e.length-s[0].length),t[s[0].toLowerCase()]=!0}return[e[2]===":"?e.slice(3):hs(e.slice(2)),t]}let ga=0;const by=Promise.resolve(),yy=()=>ga||(by.then(()=>ga=0),ga=Date.now());function _y(e,t){const n=s=>{if(!s._vts)s._vts=Date.now();else if(s._vts<=n.attached)return;Sn(Ey(s,n.value),t,5,[s])};return n.value=e,n.attached=yy(),n}function Ey(e,t){if(ve(t)){const n=e.stopImmediatePropagation;return e.stopImmediatePropagation=()=>{n.call(e),e._stopped=!0},t.map(s=>r=>!r._stopped&&s&&s(r))}else return t}const Ru=e=>e.charCodeAt(0)===111&&e.charCodeAt(1)===110&&e.charCodeAt(2)>96&&e.charCodeAt(2)<123,wy=(e,t,n,s,r,i)=>{const o=r==="svg";t==="class"?cy(e,s,o):t==="style"?hy(e,n,s):_o(t)?Hl(t)||my(e,t,n,s,i):(t[0]==="."?(t=t.slice(1),!0):t[0]==="^"?(t=t.slice(1),!1):Sy(e,t,s,o))?(Au(e,t,s),!e.tagName.includes("-")&&(t==="value"||t==="checked"||t==="selected")&&Tu(e,t,s,o,i,t!=="value")):e._isVueCE&&(/[A-Z]/.test(t)||!et(s))?Au(e,Zt(t),s,i,t):(t==="true-value"?e._trueValue=s:t==="false-value"&&(e._falseValue=s),Tu(e,t,s,o))};function Sy(e,t,n,s){if(s)return!!(t==="innerHTML"||t==="textContent"||t in e&&Ru(t)&&ye(n));if(t==="spellcheck"||t==="draggable"||t==="translate"||t==="autocorrect"||t==="form"||t==="list"&&e.tagName==="INPUT"||t==="type"&&e.tagName==="TEXTAREA")return!1;if(t==="width"||t==="height"){const r=e.tagName;if(r==="IMG"||r==="VIDEO"||r==="CANVAS"||r==="SOURCE")return!1}return Ru(t)&&et(n)?!1:t in e}const or=e=>{const t=e.props["onUpdate:modelValue"]||!1;return ve(t)?n=>Vi(t,n):t};function xy(e){e.target.composing=!0}function $u(e){const t=e.target;t.composing&&(t.composing=!1,t.dispatchEvent(new Event("input")))}const kn=Symbol("_assign"),Rs={created(e,{modifiers:{lazy:t,trim:n,number:s}},r){e[kn]=or(r);const i=s||r.props&&r.props.type==="number";ts(e,t?"change":"input",o=>{if(o.target.composing)return;let a=e.value;n&&(a=a.trim()),i&&(a=Qa(a)),e[kn](a)}),n&&ts(e,"change",()=>{e.value=e.value.trim()}),t||(ts(e,"compositionstart",xy),ts(e,"compositionend",$u),ts(e,"change",$u))},mounted(e,{value:t}){e.value=t??""},beforeUpdate(e,{value:t,oldValue:n,modifiers:{lazy:s,trim:r,number:i}},o){if(e[kn]=or(o),e.composing)return;const a=(i||e.type==="number")&&!/^0\\d/.test(e.value)?Qa(e.value):e.value,l=t??"";a!==l&&(document.activeElement===e&&e.type!=="range"&&(s&&t===n||r&&e.value.trim()===l)||(e.value=l))}},al={deep:!0,created(e,t,n){e[kn]=or(n),ts(e,"change",()=>{const s=e._modelValue,r=kh(e),i=e.checked,o=e[kn];if(ve(s)){const a=Rd(s,r),l=a!==-1;if(i&&!l)o(s.concat(r));else if(!i&&l){const u=[...s];u.splice(a,1),o(u)}}else if(Eo(s)){const a=new Set(s);i?a.add(r):a.delete(r),o(a)}else o(Ih(e,i))})},mounted:Mu,beforeUpdate(e,t,n){e[kn]=or(n),Mu(e,t,n)}};function Mu(e,{value:t,oldValue:n},s){e._modelValue=t;let r;if(ve(t))r=Rd(t,s.props.value)>-1;else if(Eo(t))r=t.has(s.props.value);else{if(t===n)return;r=rr(t,Ih(e,!0))}e.checked!==r&&(e.checked=r)}const Nu={created(e,{value:t},n){e.checked=rr(t,n.props.value),e[kn]=or(n),ts(e,"change",()=>{e[kn](kh(e))})},beforeUpdate(e,{value:t,oldValue:n},s){e[kn]=or(s),t!==n&&(e.checked=rr(t,s.props.value))}};function kh(e){return"_value"in e?e._value:e.value}function Ih(e,t){const n=t?"_trueValue":"_falseValue";return n in e?e[n]:t}const Ty=["ctrl","shift","alt","meta"],Ay={stop:e=>e.stopPropagation(),prevent:e=>e.preventDefault(),self:e=>e.target!==e.currentTarget,ctrl:e=>!e.ctrlKey,shift:e=>!e.shiftKey,alt:e=>!e.altKey,meta:e=>!e.metaKey,left:e=>"button"in e&&e.button!==0,middle:e=>"button"in e&&e.button!==1,right:e=>"button"in e&&e.button!==2,exact:(e,t)=>Ty.some(n=>e[\`\${n}Key\`]&&!t.includes(n))},Ph=(e,t)=>{const n=e._withMods||(e._withMods={}),s=t.join(".");return n[s]||(n[s]=((r,...i)=>{for(let o=0;o<t.length;o++){const a=Ay[t[o]];if(a&&a(r,t))return}return e(r,...i)}))},Oy={esc:"escape",space:" ",up:"arrow-up",left:"arrow-left",right:"arrow-right",down:"arrow-down",delete:"backspace"},ac=(e,t)=>{const n=e._withKeys||(e._withKeys={}),s=t.join(".");return n[s]||(n[s]=(r=>{if(!("key"in r))return;const i=hs(r.key);if(t.some(o=>o===i||Oy[o]===i))return e(r)}))},Cy=St({patchProp:wy},ay);let ku;function Ry(){return ku||(ku=kb(Cy))}const $y=((...e)=>{const t=Ry().createApp(...e),{mount:n}=t;return t.mount=s=>{const r=Ny(s);if(!r)return;const i=t._component;!ye(i)&&!i.render&&!i.template&&(i.template=r.innerHTML),r.nodeType===1&&(r.textContent="");const o=n(r,!1,My(r));return r instanceof Element&&(r.removeAttribute("v-cloak"),r.setAttribute("data-v-app","")),o},t});function My(e){if(e instanceof SVGElement)return"svg";if(typeof MathMLElement=="function"&&e instanceof MathMLElement)return"mathml"}function Ny(e){return et(e)?document.querySelector(e):e}const ky=at({__name:"MainApp",setup(e){return(t,n)=>{const s=ec("router-view");return H(),qe(s)}}});var Ct="top",Ht="bottom",Vt="right",Rt="left",zo="auto",vr=[Ct,Ht,Vt,Rt],$s="start",ar="end",Lh="clippingParents",lc="viewport",Ws="popper",Dh="reference",ll=vr.reduce(function(e,t){return e.concat([t+"-"+$s,t+"-"+ar])},[]),cc=[].concat(vr,[zo]).reduce(function(e,t){return e.concat([t,t+"-"+$s,t+"-"+ar])},[]),Fh="beforeRead",zh="read",jh="afterRead",Hh="beforeMain",Vh="main",Bh="afterMain",Wh="beforeWrite",Uh="write",qh="afterWrite",Kh=[Fh,zh,jh,Hh,Vh,Bh,Wh,Uh,qh];function xn(e){return e?(e.nodeName||"").toLowerCase():null}function Bt(e){if(e==null)return window;if(e.toString()!=="[object Window]"){var t=e.ownerDocument;return t&&t.defaultView||window}return e}function Ms(e){var t=Bt(e).Element;return e instanceof t||e instanceof Element}function Jt(e){var t=Bt(e).HTMLElement;return e instanceof t||e instanceof HTMLElement}function uc(e){if(typeof ShadowRoot>"u")return!1;var t=Bt(e).ShadowRoot;return e instanceof t||e instanceof ShadowRoot}function Iy(e){var t=e.state;Object.keys(t.elements).forEach(function(n){var s=t.styles[n]||{},r=t.attributes[n]||{},i=t.elements[n];!Jt(i)||!xn(i)||(Object.assign(i.style,s),Object.keys(r).forEach(function(o){var a=r[o];a===!1?i.removeAttribute(o):i.setAttribute(o,a===!0?"":a)}))})}function Py(e){var t=e.state,n={popper:{position:t.options.strategy,left:"0",top:"0",margin:"0"},arrow:{position:"absolute"},reference:{}};return Object.assign(t.elements.popper.style,n.popper),t.styles=n,t.elements.arrow&&Object.assign(t.elements.arrow.style,n.arrow),function(){Object.keys(t.elements).forEach(function(s){var r=t.elements[s],i=t.attributes[s]||{},o=Object.keys(t.styles.hasOwnProperty(s)?t.styles[s]:n[s]),a=o.reduce(function(l,u){return l[u]="",l},{});!Jt(r)||!xn(r)||(Object.assign(r.style,a),Object.keys(i).forEach(function(l){r.removeAttribute(l)}))})}}const fc={name:"applyStyles",enabled:!0,phase:"write",fn:Iy,effect:Py,requires:["computeStyles"]};function wn(e){return e.split("-")[0]}var Cs=Math.max,uo=Math.min,lr=Math.round;function cl(){var e=navigator.userAgentData;return e!=null&&e.brands&&Array.isArray(e.brands)?e.brands.map(function(t){return t.brand+"/"+t.version}).join(" "):navigator.userAgent}function Yh(){return!/^((?!chrome|android).)*safari/i.test(cl())}function cr(e,t,n){t===void 0&&(t=!1),n===void 0&&(n=!1);var s=e.getBoundingClientRect(),r=1,i=1;t&&Jt(e)&&(r=e.offsetWidth>0&&lr(s.width)/e.offsetWidth||1,i=e.offsetHeight>0&&lr(s.height)/e.offsetHeight||1);var o=Ms(e)?Bt(e):window,a=o.visualViewport,l=!Yh()&&n,u=(s.left+(l&&a?a.offsetLeft:0))/r,c=(s.top+(l&&a?a.offsetTop:0))/i,f=s.width/r,d=s.height/i;return{width:f,height:d,top:c,right:u+f,bottom:c+d,left:u,x:u,y:c}}function dc(e){var t=cr(e),n=e.offsetWidth,s=e.offsetHeight;return Math.abs(t.width-n)<=1&&(n=t.width),Math.abs(t.height-s)<=1&&(s=t.height),{x:e.offsetLeft,y:e.offsetTop,width:n,height:s}}function Gh(e,t){var n=t.getRootNode&&t.getRootNode();if(e.contains(t))return!0;if(n&&uc(n)){var s=t;do{if(s&&e.isSameNode(s))return!0;s=s.parentNode||s.host}while(s)}return!1}function jn(e){return Bt(e).getComputedStyle(e)}function Ly(e){return["table","td","th"].indexOf(xn(e))>=0}function ps(e){return((Ms(e)?e.ownerDocument:e.document)||window.document).documentElement}function jo(e){return xn(e)==="html"?e:e.assignedSlot||e.parentNode||(uc(e)?e.host:null)||ps(e)}function Iu(e){return!Jt(e)||jn(e).position==="fixed"?null:e.offsetParent}function Dy(e){var t=/firefox/i.test(cl()),n=/Trident/i.test(cl());if(n&&Jt(e)){var s=jn(e);if(s.position==="fixed")return null}var r=jo(e);for(uc(r)&&(r=r.host);Jt(r)&&["html","body"].indexOf(xn(r))<0;){var i=jn(r);if(i.transform!=="none"||i.perspective!=="none"||i.contain==="paint"||["transform","perspective"].indexOf(i.willChange)!==-1||t&&i.willChange==="filter"||t&&i.filter&&i.filter!=="none")return r;r=r.parentNode}return null}function ai(e){for(var t=Bt(e),n=Iu(e);n&&Ly(n)&&jn(n).position==="static";)n=Iu(n);return n&&(xn(n)==="html"||xn(n)==="body"&&jn(n).position==="static")?t:n||Dy(e)||t}function hc(e){return["top","bottom"].indexOf(e)>=0?"x":"y"}function zr(e,t,n){return Cs(e,uo(t,n))}function Fy(e,t,n){var s=zr(e,t,n);return s>n?n:s}function Qh(){return{top:0,right:0,bottom:0,left:0}}function Xh(e){return Object.assign({},Qh(),e)}function Jh(e,t){return t.reduce(function(n,s){return n[s]=e,n},{})}var zy=function(t,n){return t=typeof t=="function"?t(Object.assign({},n.rects,{placement:n.placement})):t,Xh(typeof t!="number"?t:Jh(t,vr))};function jy(e){var t,n=e.state,s=e.name,r=e.options,i=n.elements.arrow,o=n.modifiersData.popperOffsets,a=wn(n.placement),l=hc(a),u=[Rt,Vt].indexOf(a)>=0,c=u?"height":"width";if(!(!i||!o)){var f=zy(r.padding,n),d=dc(i),h=l==="y"?Ct:Rt,p=l==="y"?Ht:Vt,g=n.rects.reference[c]+n.rects.reference[l]-o[l]-n.rects.popper[c],_=o[l]-n.rects.reference[l],b=ai(i),y=b?l==="y"?b.clientHeight||0:b.clientWidth||0:0,T=g/2-_/2,x=f[h],O=y-d[c]-f[p],$=y/2-d[c]/2+T,F=zr(x,$,O),Q=l;n.modifiersData[s]=(t={},t[Q]=F,t.centerOffset=F-$,t)}}function Hy(e){var t=e.state,n=e.options,s=n.element,r=s===void 0?"[data-popper-arrow]":s;r!=null&&(typeof r=="string"&&(r=t.elements.popper.querySelector(r),!r)||Gh(t.elements.popper,r)&&(t.elements.arrow=r))}const Zh={name:"arrow",enabled:!0,phase:"main",fn:jy,effect:Hy,requires:["popperOffsets"],requiresIfExists:["preventOverflow"]};function ur(e){return e.split("-")[1]}var Vy={top:"auto",right:"auto",bottom:"auto",left:"auto"};function By(e,t){var n=e.x,s=e.y,r=t.devicePixelRatio||1;return{x:lr(n*r)/r||0,y:lr(s*r)/r||0}}function Pu(e){var t,n=e.popper,s=e.popperRect,r=e.placement,i=e.variation,o=e.offsets,a=e.position,l=e.gpuAcceleration,u=e.adaptive,c=e.roundOffsets,f=e.isFixed,d=o.x,h=d===void 0?0:d,p=o.y,g=p===void 0?0:p,_=typeof c=="function"?c({x:h,y:g}):{x:h,y:g};h=_.x,g=_.y;var b=o.hasOwnProperty("x"),y=o.hasOwnProperty("y"),T=Rt,x=Ct,O=window;if(u){var $=ai(n),F="clientHeight",Q="clientWidth";if($===Bt(n)&&($=ps(n),jn($).position!=="static"&&a==="absolute"&&(F="scrollHeight",Q="scrollWidth")),$=$,r===Ct||(r===Rt||r===Vt)&&i===ar){x=Ht;var P=f&&$===O&&O.visualViewport?O.visualViewport.height:$[F];g-=P-s.height,g*=l?1:-1}if(r===Rt||(r===Ct||r===Ht)&&i===ar){T=Vt;var C=f&&$===O&&O.visualViewport?O.visualViewport.width:$[Q];h-=C-s.width,h*=l?1:-1}}var q=Object.assign({position:a},u&&Vy),ne=c===!0?By({x:h,y:g},Bt(n)):{x:h,y:g};if(h=ne.x,g=ne.y,l){var W;return Object.assign({},q,(W={},W[x]=y?"0":"",W[T]=b?"0":"",W.transform=(O.devicePixelRatio||1)<=1?"translate("+h+"px, "+g+"px)":"translate3d("+h+"px, "+g+"px, 0)",W))}return Object.assign({},q,(t={},t[x]=y?g+"px":"",t[T]=b?h+"px":"",t.transform="",t))}function Wy(e){var t=e.state,n=e.options,s=n.gpuAcceleration,r=s===void 0?!0:s,i=n.adaptive,o=i===void 0?!0:i,a=n.roundOffsets,l=a===void 0?!0:a,u={placement:wn(t.placement),variation:ur(t.placement),popper:t.elements.popper,popperRect:t.rects.popper,gpuAcceleration:r,isFixed:t.options.strategy==="fixed"};t.modifiersData.popperOffsets!=null&&(t.styles.popper=Object.assign({},t.styles.popper,Pu(Object.assign({},u,{offsets:t.modifiersData.popperOffsets,position:t.options.strategy,adaptive:o,roundOffsets:l})))),t.modifiersData.arrow!=null&&(t.styles.arrow=Object.assign({},t.styles.arrow,Pu(Object.assign({},u,{offsets:t.modifiersData.arrow,position:"absolute",adaptive:!1,roundOffsets:l})))),t.attributes.popper=Object.assign({},t.attributes.popper,{"data-popper-placement":t.placement})}const pc={name:"computeStyles",enabled:!0,phase:"beforeWrite",fn:Wy,data:{}};var Ri={passive:!0};function Uy(e){var t=e.state,n=e.instance,s=e.options,r=s.scroll,i=r===void 0?!0:r,o=s.resize,a=o===void 0?!0:o,l=Bt(t.elements.popper),u=[].concat(t.scrollParents.reference,t.scrollParents.popper);return i&&u.forEach(function(c){c.addEventListener("scroll",n.update,Ri)}),a&&l.addEventListener("resize",n.update,Ri),function(){i&&u.forEach(function(c){c.removeEventListener("scroll",n.update,Ri)}),a&&l.removeEventListener("resize",n.update,Ri)}}const gc={name:"eventListeners",enabled:!0,phase:"write",fn:function(){},effect:Uy,data:{}};var qy={left:"right",right:"left",bottom:"top",top:"bottom"};function qi(e){return e.replace(/left|right|bottom|top/g,function(t){return qy[t]})}var Ky={start:"end",end:"start"};function Lu(e){return e.replace(/start|end/g,function(t){return Ky[t]})}function mc(e){var t=Bt(e),n=t.pageXOffset,s=t.pageYOffset;return{scrollLeft:n,scrollTop:s}}function vc(e){return cr(ps(e)).left+mc(e).scrollLeft}function Yy(e,t){var n=Bt(e),s=ps(e),r=n.visualViewport,i=s.clientWidth,o=s.clientHeight,a=0,l=0;if(r){i=r.width,o=r.height;var u=Yh();(u||!u&&t==="fixed")&&(a=r.offsetLeft,l=r.offsetTop)}return{width:i,height:o,x:a+vc(e),y:l}}function Gy(e){var t,n=ps(e),s=mc(e),r=(t=e.ownerDocument)==null?void 0:t.body,i=Cs(n.scrollWidth,n.clientWidth,r?r.scrollWidth:0,r?r.clientWidth:0),o=Cs(n.scrollHeight,n.clientHeight,r?r.scrollHeight:0,r?r.clientHeight:0),a=-s.scrollLeft+vc(e),l=-s.scrollTop;return jn(r||n).direction==="rtl"&&(a+=Cs(n.clientWidth,r?r.clientWidth:0)-i),{width:i,height:o,x:a,y:l}}function bc(e){var t=jn(e),n=t.overflow,s=t.overflowX,r=t.overflowY;return/auto|scroll|overlay|hidden/.test(n+r+s)}function ep(e){return["html","body","#document"].indexOf(xn(e))>=0?e.ownerDocument.body:Jt(e)&&bc(e)?e:ep(jo(e))}function jr(e,t){var n;t===void 0&&(t=[]);var s=ep(e),r=s===((n=e.ownerDocument)==null?void 0:n.body),i=Bt(s),o=r?[i].concat(i.visualViewport||[],bc(s)?s:[]):s,a=t.concat(o);return r?a:a.concat(jr(jo(o)))}function ul(e){return Object.assign({},e,{left:e.x,top:e.y,right:e.x+e.width,bottom:e.y+e.height})}function Qy(e,t){var n=cr(e,!1,t==="fixed");return n.top=n.top+e.clientTop,n.left=n.left+e.clientLeft,n.bottom=n.top+e.clientHeight,n.right=n.left+e.clientWidth,n.width=e.clientWidth,n.height=e.clientHeight,n.x=n.left,n.y=n.top,n}function Du(e,t,n){return t===lc?ul(Yy(e,n)):Ms(t)?Qy(t,n):ul(Gy(ps(e)))}function Xy(e){var t=jr(jo(e)),n=["absolute","fixed"].indexOf(jn(e).position)>=0,s=n&&Jt(e)?ai(e):e;return Ms(s)?t.filter(function(r){return Ms(r)&&Gh(r,s)&&xn(r)!=="body"}):[]}function Jy(e,t,n,s){var r=t==="clippingParents"?Xy(e):[].concat(t),i=[].concat(r,[n]),o=i[0],a=i.reduce(function(l,u){var c=Du(e,u,s);return l.top=Cs(c.top,l.top),l.right=uo(c.right,l.right),l.bottom=uo(c.bottom,l.bottom),l.left=Cs(c.left,l.left),l},Du(e,o,s));return a.width=a.right-a.left,a.height=a.bottom-a.top,a.x=a.left,a.y=a.top,a}function tp(e){var t=e.reference,n=e.element,s=e.placement,r=s?wn(s):null,i=s?ur(s):null,o=t.x+t.width/2-n.width/2,a=t.y+t.height/2-n.height/2,l;switch(r){case Ct:l={x:o,y:t.y-n.height};break;case Ht:l={x:o,y:t.y+t.height};break;case Vt:l={x:t.x+t.width,y:a};break;case Rt:l={x:t.x-n.width,y:a};break;default:l={x:t.x,y:t.y}}var u=r?hc(r):null;if(u!=null){var c=u==="y"?"height":"width";switch(i){case $s:l[u]=l[u]-(t[c]/2-n[c]/2);break;case ar:l[u]=l[u]+(t[c]/2-n[c]/2);break}}return l}function fr(e,t){t===void 0&&(t={});var n=t,s=n.placement,r=s===void 0?e.placement:s,i=n.strategy,o=i===void 0?e.strategy:i,a=n.boundary,l=a===void 0?Lh:a,u=n.rootBoundary,c=u===void 0?lc:u,f=n.elementContext,d=f===void 0?Ws:f,h=n.altBoundary,p=h===void 0?!1:h,g=n.padding,_=g===void 0?0:g,b=Xh(typeof _!="number"?_:Jh(_,vr)),y=d===Ws?Dh:Ws,T=e.rects.popper,x=e.elements[p?y:d],O=Jy(Ms(x)?x:x.contextElement||ps(e.elements.popper),l,c,o),$=cr(e.elements.reference),F=tp({reference:$,element:T,placement:r}),Q=ul(Object.assign({},T,F)),P=d===Ws?Q:$,C={top:O.top-P.top+b.top,bottom:P.bottom-O.bottom+b.bottom,left:O.left-P.left+b.left,right:P.right-O.right+b.right},q=e.modifiersData.offset;if(d===Ws&&q){var ne=q[r];Object.keys(C).forEach(function(W){var L=[Vt,Ht].indexOf(W)>=0?1:-1,le=[Ct,Ht].indexOf(W)>=0?"y":"x";C[W]+=ne[le]*L})}return C}function Zy(e,t){t===void 0&&(t={});var n=t,s=n.placement,r=n.boundary,i=n.rootBoundary,o=n.padding,a=n.flipVariations,l=n.allowedAutoPlacements,u=l===void 0?cc:l,c=ur(s),f=c?a?ll:ll.filter(function(p){return ur(p)===c}):vr,d=f.filter(function(p){return u.indexOf(p)>=0});d.length===0&&(d=f);var h=d.reduce(function(p,g){return p[g]=fr(e,{placement:g,boundary:r,rootBoundary:i,padding:o})[wn(g)],p},{});return Object.keys(h).sort(function(p,g){return h[p]-h[g]})}function e_(e){if(wn(e)===zo)return[];var t=qi(e);return[Lu(e),t,Lu(t)]}function t_(e){var t=e.state,n=e.options,s=e.name;if(!t.modifiersData[s]._skip){for(var r=n.mainAxis,i=r===void 0?!0:r,o=n.altAxis,a=o===void 0?!0:o,l=n.fallbackPlacements,u=n.padding,c=n.boundary,f=n.rootBoundary,d=n.altBoundary,h=n.flipVariations,p=h===void 0?!0:h,g=n.allowedAutoPlacements,_=t.options.placement,b=wn(_),y=b===_,T=l||(y||!p?[qi(_)]:e_(_)),x=[_].concat(T).reduce(function(ct,tt){return ct.concat(wn(tt)===zo?Zy(t,{placement:tt,boundary:c,rootBoundary:f,padding:u,flipVariations:p,allowedAutoPlacements:g}):tt)},[]),O=t.rects.reference,$=t.rects.popper,F=new Map,Q=!0,P=x[0],C=0;C<x.length;C++){var q=x[C],ne=wn(q),W=ur(q)===$s,L=[Ct,Ht].indexOf(ne)>=0,le=L?"width":"height",B=fr(t,{placement:q,boundary:c,rootBoundary:f,altBoundary:d,padding:u}),ue=L?W?Vt:Rt:W?Ht:Ct;O[le]>$[le]&&(ue=qi(ue));var Z=qi(ue),we=[];if(i&&we.push(B[ne]<=0),a&&we.push(B[ue]<=0,B[Z]<=0),we.every(function(ct){return ct})){P=q,Q=!1;break}F.set(q,we)}if(Q)for(var Ke=p?3:1,rt=function(tt){var Qe=x.find(function(R){var G=F.get(R);if(G)return G.slice(0,tt).every(function(Y){return Y})});if(Qe)return P=Qe,"break"},Ve=Ke;Ve>0;Ve--){var it=rt(Ve);if(it==="break")break}t.placement!==P&&(t.modifiersData[s]._skip=!0,t.placement=P,t.reset=!0)}}const np={name:"flip",enabled:!0,phase:"main",fn:t_,requiresIfExists:["offset"],data:{_skip:!1}};function Fu(e,t,n){return n===void 0&&(n={x:0,y:0}),{top:e.top-t.height-n.y,right:e.right-t.width+n.x,bottom:e.bottom-t.height+n.y,left:e.left-t.width-n.x}}function zu(e){return[Ct,Vt,Ht,Rt].some(function(t){return e[t]>=0})}function n_(e){var t=e.state,n=e.name,s=t.rects.reference,r=t.rects.popper,i=t.modifiersData.preventOverflow,o=fr(t,{elementContext:"reference"}),a=fr(t,{altBoundary:!0}),l=Fu(o,s),u=Fu(a,r,i),c=zu(l),f=zu(u);t.modifiersData[n]={referenceClippingOffsets:l,popperEscapeOffsets:u,isReferenceHidden:c,hasPopperEscaped:f},t.attributes.popper=Object.assign({},t.attributes.popper,{"data-popper-reference-hidden":c,"data-popper-escaped":f})}const sp={name:"hide",enabled:!0,phase:"main",requiresIfExists:["preventOverflow"],fn:n_};function s_(e,t,n){var s=wn(e),r=[Rt,Ct].indexOf(s)>=0?-1:1,i=typeof n=="function"?n(Object.assign({},t,{placement:e})):n,o=i[0],a=i[1];return o=o||0,a=(a||0)*r,[Rt,Vt].indexOf(s)>=0?{x:a,y:o}:{x:o,y:a}}function r_(e){var t=e.state,n=e.options,s=e.name,r=n.offset,i=r===void 0?[0,0]:r,o=cc.reduce(function(c,f){return c[f]=s_(f,t.rects,i),c},{}),a=o[t.placement],l=a.x,u=a.y;t.modifiersData.popperOffsets!=null&&(t.modifiersData.popperOffsets.x+=l,t.modifiersData.popperOffsets.y+=u),t.modifiersData[s]=o}const rp={name:"offset",enabled:!0,phase:"main",requires:["popperOffsets"],fn:r_};function i_(e){var t=e.state,n=e.name;t.modifiersData[n]=tp({reference:t.rects.reference,element:t.rects.popper,placement:t.placement})}const yc={name:"popperOffsets",enabled:!0,phase:"read",fn:i_,data:{}};function o_(e){return e==="x"?"y":"x"}function a_(e){var t=e.state,n=e.options,s=e.name,r=n.mainAxis,i=r===void 0?!0:r,o=n.altAxis,a=o===void 0?!1:o,l=n.boundary,u=n.rootBoundary,c=n.altBoundary,f=n.padding,d=n.tether,h=d===void 0?!0:d,p=n.tetherOffset,g=p===void 0?0:p,_=fr(t,{boundary:l,rootBoundary:u,padding:f,altBoundary:c}),b=wn(t.placement),y=ur(t.placement),T=!y,x=hc(b),O=o_(x),$=t.modifiersData.popperOffsets,F=t.rects.reference,Q=t.rects.popper,P=typeof g=="function"?g(Object.assign({},t.rects,{placement:t.placement})):g,C=typeof P=="number"?{mainAxis:P,altAxis:P}:Object.assign({mainAxis:0,altAxis:0},P),q=t.modifiersData.offset?t.modifiersData.offset[t.placement]:null,ne={x:0,y:0};if($){if(i){var W,L=x==="y"?Ct:Rt,le=x==="y"?Ht:Vt,B=x==="y"?"height":"width",ue=$[x],Z=ue+_[L],we=ue-_[le],Ke=h?-Q[B]/2:0,rt=y===$s?F[B]:Q[B],Ve=y===$s?-Q[B]:-F[B],it=t.elements.arrow,ct=h&&it?dc(it):{width:0,height:0},tt=t.modifiersData["arrow#persistent"]?t.modifiersData["arrow#persistent"].padding:Qh(),Qe=tt[L],R=tt[le],G=zr(0,F[B],ct[B]),Y=T?F[B]/2-Ke-G-Qe-C.mainAxis:rt-G-Qe-C.mainAxis,se=T?-F[B]/2+Ke+G+R+C.mainAxis:Ve+G+R+C.mainAxis,Oe=t.elements.arrow&&ai(t.elements.arrow),m=Oe?x==="y"?Oe.clientTop||0:Oe.clientLeft||0:0,v=(W=q?.[x])!=null?W:0,S=ue+Y-v-m,N=ue+se-v,I=zr(h?uo(Z,S):Z,ue,h?Cs(we,N):we);$[x]=I,ne[x]=I-ue}if(a){var M,X=x==="x"?Ct:Rt,K=x==="x"?Ht:Vt,j=$[O],z=O==="y"?"height":"width",de=j+_[X],ee=j-_[K],ae=[Ct,Rt].indexOf(b)!==-1,me=(M=q?.[O])!=null?M:0,_e=ae?de:j-F[z]-Q[z]-me+C.altAxis,ke=ae?j+F[z]+Q[z]-me-C.altAxis:ee,Re=h&&ae?Fy(_e,j,ke):zr(h?_e:de,j,h?ke:ee);$[O]=Re,ne[O]=Re-j}t.modifiersData[s]=ne}}const ip={name:"preventOverflow",enabled:!0,phase:"main",fn:a_,requiresIfExists:["offset"]};function l_(e){return{scrollLeft:e.scrollLeft,scrollTop:e.scrollTop}}function c_(e){return e===Bt(e)||!Jt(e)?mc(e):l_(e)}function u_(e){var t=e.getBoundingClientRect(),n=lr(t.width)/e.offsetWidth||1,s=lr(t.height)/e.offsetHeight||1;return n!==1||s!==1}function f_(e,t,n){n===void 0&&(n=!1);var s=Jt(t),r=Jt(t)&&u_(t),i=ps(t),o=cr(e,r,n),a={scrollLeft:0,scrollTop:0},l={x:0,y:0};return(s||!s&&!n)&&((xn(t)!=="body"||bc(i))&&(a=c_(t)),Jt(t)?(l=cr(t,!0),l.x+=t.clientLeft,l.y+=t.clientTop):i&&(l.x=vc(i))),{x:o.left+a.scrollLeft-l.x,y:o.top+a.scrollTop-l.y,width:o.width,height:o.height}}function d_(e){var t=new Map,n=new Set,s=[];e.forEach(function(i){t.set(i.name,i)});function r(i){n.add(i.name);var o=[].concat(i.requires||[],i.requiresIfExists||[]);o.forEach(function(a){if(!n.has(a)){var l=t.get(a);l&&r(l)}}),s.push(i)}return e.forEach(function(i){n.has(i.name)||r(i)}),s}function h_(e){var t=d_(e);return Kh.reduce(function(n,s){return n.concat(t.filter(function(r){return r.phase===s}))},[])}function p_(e){var t;return function(){return t||(t=new Promise(function(n){Promise.resolve().then(function(){t=void 0,n(e())})})),t}}function g_(e){var t=e.reduce(function(n,s){var r=n[s.name];return n[s.name]=r?Object.assign({},r,s,{options:Object.assign({},r.options,s.options),data:Object.assign({},r.data,s.data)}):s,n},{});return Object.keys(t).map(function(n){return t[n]})}var ju={placement:"bottom",modifiers:[],strategy:"absolute"};function Hu(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];return!t.some(function(s){return!(s&&typeof s.getBoundingClientRect=="function")})}function Ho(e){e===void 0&&(e={});var t=e,n=t.defaultModifiers,s=n===void 0?[]:n,r=t.defaultOptions,i=r===void 0?ju:r;return function(a,l,u){u===void 0&&(u=i);var c={placement:"bottom",orderedModifiers:[],options:Object.assign({},ju,i),modifiersData:{},elements:{reference:a,popper:l},attributes:{},styles:{}},f=[],d=!1,h={state:c,setOptions:function(b){var y=typeof b=="function"?b(c.options):b;g(),c.options=Object.assign({},i,c.options,y),c.scrollParents={reference:Ms(a)?jr(a):a.contextElement?jr(a.contextElement):[],popper:jr(l)};var T=h_(g_([].concat(s,c.options.modifiers)));return c.orderedModifiers=T.filter(function(x){return x.enabled}),p(),h.update()},forceUpdate:function(){if(!d){var b=c.elements,y=b.reference,T=b.popper;if(Hu(y,T)){c.rects={reference:f_(y,ai(T),c.options.strategy==="fixed"),popper:dc(T)},c.reset=!1,c.placement=c.options.placement,c.orderedModifiers.forEach(function(C){return c.modifiersData[C.name]=Object.assign({},C.data)});for(var x=0;x<c.orderedModifiers.length;x++){if(c.reset===!0){c.reset=!1,x=-1;continue}var O=c.orderedModifiers[x],$=O.fn,F=O.options,Q=F===void 0?{}:F,P=O.name;typeof $=="function"&&(c=$({state:c,options:Q,name:P,instance:h})||c)}}}},update:p_(function(){return new Promise(function(_){h.forceUpdate(),_(c)})}),destroy:function(){g(),d=!0}};if(!Hu(a,l))return h;h.setOptions(u).then(function(_){!d&&u.onFirstUpdate&&u.onFirstUpdate(_)});function p(){c.orderedModifiers.forEach(function(_){var b=_.name,y=_.options,T=y===void 0?{}:y,x=_.effect;if(typeof x=="function"){var O=x({state:c,name:b,instance:h,options:T}),$=function(){};f.push(O||$)}})}function g(){f.forEach(function(_){return _()}),f=[]}return h}}var m_=Ho(),v_=[gc,yc,pc,fc],b_=Ho({defaultModifiers:v_}),y_=[gc,yc,pc,fc,rp,np,ip,Zh,sp],_c=Ho({defaultModifiers:y_});const op=Object.freeze(Object.defineProperty({__proto__:null,afterMain:Bh,afterRead:jh,afterWrite:qh,applyStyles:fc,arrow:Zh,auto:zo,basePlacements:vr,beforeMain:Hh,beforeRead:Fh,beforeWrite:Wh,bottom:Ht,clippingParents:Lh,computeStyles:pc,createPopper:_c,createPopperBase:m_,createPopperLite:b_,detectOverflow:fr,end:ar,eventListeners:gc,flip:np,hide:sp,left:Rt,main:Vh,modifierPhases:Kh,offset:rp,placements:cc,popper:Ws,popperGenerator:Ho,popperOffsets:yc,preventOverflow:ip,read:zh,reference:Dh,right:Vt,start:$s,top:Ct,variationPlacements:ll,viewport:lc,write:Uh},Symbol.toStringTag,{value:"Module"}));/*!
  * Bootstrap v5.3.8 (https://getbootstrap.com/)
  * Copyright 2011-2025 The Bootstrap Authors (https://github.com/twbs/bootstrap/graphs/contributors)
  * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)
  */const Gn=new Map,ma={set(e,t,n){Gn.has(e)||Gn.set(e,new Map);const s=Gn.get(e);if(!s.has(t)&&s.size!==0){console.error(\`Bootstrap doesn't allow more than one instance per element. Bound instance: \${Array.from(s.keys())[0]}.\`);return}s.set(t,n)},get(e,t){return Gn.has(e)&&Gn.get(e).get(t)||null},remove(e,t){if(!Gn.has(e))return;const n=Gn.get(e);n.delete(t),n.size===0&&Gn.delete(e)}},__=1e6,E_=1e3,fl="transitionend",ap=e=>(e&&window.CSS&&window.CSS.escape&&(e=e.replace(/#([^\\s"#']+)/g,(t,n)=>\`#\${CSS.escape(n)}\`)),e),w_=e=>e==null?\`\${e}\`:Object.prototype.toString.call(e).match(/\\s([a-z]+)/i)[1].toLowerCase(),S_=e=>{do e+=Math.floor(Math.random()*__);while(document.getElementById(e));return e},x_=e=>{if(!e)return 0;let{transitionDuration:t,transitionDelay:n}=window.getComputedStyle(e);const s=Number.parseFloat(t),r=Number.parseFloat(n);return!s&&!r?0:(t=t.split(",")[0],n=n.split(",")[0],(Number.parseFloat(t)+Number.parseFloat(n))*E_)},lp=e=>{e.dispatchEvent(new Event(fl))},In=e=>!e||typeof e!="object"?!1:(typeof e.jquery<"u"&&(e=e[0]),typeof e.nodeType<"u"),os=e=>In(e)?e.jquery?e[0]:e:typeof e=="string"&&e.length>0?document.querySelector(ap(e)):null,br=e=>{if(!In(e)||e.getClientRects().length===0)return!1;const t=getComputedStyle(e).getPropertyValue("visibility")==="visible",n=e.closest("details:not([open])");if(!n)return t;if(n!==e){const s=e.closest("summary");if(s&&s.parentNode!==n||s===null)return!1}return t},as=e=>!e||e.nodeType!==Node.ELEMENT_NODE||e.classList.contains("disabled")?!0:typeof e.disabled<"u"?e.disabled:e.hasAttribute("disabled")&&e.getAttribute("disabled")!=="false",cp=e=>{if(!document.documentElement.attachShadow)return null;if(typeof e.getRootNode=="function"){const t=e.getRootNode();return t instanceof ShadowRoot?t:null}return e instanceof ShadowRoot?e:e.parentNode?cp(e.parentNode):null},fo=()=>{},li=e=>{e.offsetHeight},up=()=>window.jQuery&&!document.body.hasAttribute("data-bs-no-jquery")?window.jQuery:null,va=[],T_=e=>{document.readyState==="loading"?(va.length||document.addEventListener("DOMContentLoaded",()=>{for(const t of va)t()}),va.push(e)):e()},en=()=>document.documentElement.dir==="rtl",nn=e=>{T_(()=>{const t=up();if(t){const n=e.NAME,s=t.fn[n];t.fn[n]=e.jQueryInterface,t.fn[n].Constructor=e,t.fn[n].noConflict=()=>(t.fn[n]=s,e.jQueryInterface)}})},Pt=(e,t=[],n=e)=>typeof e=="function"?e.call(...t):n,fp=(e,t,n=!0)=>{if(!n){Pt(e);return}const r=x_(t)+5;let i=!1;const o=({target:a})=>{a===t&&(i=!0,t.removeEventListener(fl,o),Pt(e))};t.addEventListener(fl,o),setTimeout(()=>{i||lp(t)},r)},Ec=(e,t,n,s)=>{const r=e.length;let i=e.indexOf(t);return i===-1?!n&&s?e[r-1]:e[0]:(i+=n?1:-1,s&&(i=(i+r)%r),e[Math.max(0,Math.min(i,r-1))])},A_=/[^.]*(?=\\..*)\\.|.*/,O_=/\\..*/,C_=/::\\d+$/,ba={};let Vu=1;const dp={mouseenter:"mouseover",mouseleave:"mouseout"},R_=new Set(["click","dblclick","mouseup","mousedown","contextmenu","mousewheel","DOMMouseScroll","mouseover","mouseout","mousemove","selectstart","selectend","keydown","keypress","keyup","orientationchange","touchstart","touchmove","touchend","touchcancel","pointerdown","pointermove","pointerup","pointerleave","pointercancel","gesturestart","gesturechange","gestureend","focus","blur","change","reset","select","submit","focusin","focusout","load","unload","beforeunload","resize","move","DOMContentLoaded","readystatechange","error","abort","scroll"]);function hp(e,t){return t&&\`\${t}::\${Vu++}\`||e.uidEvent||Vu++}function pp(e){const t=hp(e);return e.uidEvent=t,ba[t]=ba[t]||{},ba[t]}function $_(e,t){return function n(s){return wc(s,{delegateTarget:e}),n.oneOff&&D.off(e,s.type,t),t.apply(e,[s])}}function M_(e,t,n){return function s(r){const i=e.querySelectorAll(t);for(let{target:o}=r;o&&o!==this;o=o.parentNode)for(const a of i)if(a===o)return wc(r,{delegateTarget:o}),s.oneOff&&D.off(e,r.type,t,n),n.apply(o,[r])}}function gp(e,t,n=null){return Object.values(e).find(s=>s.callable===t&&s.delegationSelector===n)}function mp(e,t,n){const s=typeof t=="string",r=s?n:t||n;let i=vp(e);return R_.has(i)||(i=e),[s,r,i]}function Bu(e,t,n,s,r){if(typeof t!="string"||!e)return;let[i,o,a]=mp(t,n,s);t in dp&&(o=(p=>function(g){if(!g.relatedTarget||g.relatedTarget!==g.delegateTarget&&!g.delegateTarget.contains(g.relatedTarget))return p.call(this,g)})(o));const l=pp(e),u=l[a]||(l[a]={}),c=gp(u,o,i?n:null);if(c){c.oneOff=c.oneOff&&r;return}const f=hp(o,t.replace(A_,"")),d=i?M_(e,n,o):$_(e,o);d.delegationSelector=i?n:null,d.callable=o,d.oneOff=r,d.uidEvent=f,u[f]=d,e.addEventListener(a,d,i)}function dl(e,t,n,s,r){const i=gp(t[n],s,r);i&&(e.removeEventListener(n,i,!!r),delete t[n][i.uidEvent])}function N_(e,t,n,s){const r=t[n]||{};for(const[i,o]of Object.entries(r))i.includes(s)&&dl(e,t,n,o.callable,o.delegationSelector)}function vp(e){return e=e.replace(O_,""),dp[e]||e}const D={on(e,t,n,s){Bu(e,t,n,s,!1)},one(e,t,n,s){Bu(e,t,n,s,!0)},off(e,t,n,s){if(typeof t!="string"||!e)return;const[r,i,o]=mp(t,n,s),a=o!==t,l=pp(e),u=l[o]||{},c=t.startsWith(".");if(typeof i<"u"){if(!Object.keys(u).length)return;dl(e,l,o,i,r?n:null);return}if(c)for(const f of Object.keys(l))N_(e,l,f,t.slice(1));for(const[f,d]of Object.entries(u)){const h=f.replace(C_,"");(!a||t.includes(h))&&dl(e,l,o,d.callable,d.delegationSelector)}},trigger(e,t,n){if(typeof t!="string"||!e)return null;const s=up(),r=vp(t),i=t!==r;let o=null,a=!0,l=!0,u=!1;i&&s&&(o=s.Event(t,n),s(e).trigger(o),a=!o.isPropagationStopped(),l=!o.isImmediatePropagationStopped(),u=o.isDefaultPrevented());const c=wc(new Event(t,{bubbles:a,cancelable:!0}),n);return u&&c.preventDefault(),l&&e.dispatchEvent(c),c.defaultPrevented&&o&&o.preventDefault(),c}};function wc(e,t={}){for(const[n,s]of Object.entries(t))try{e[n]=s}catch{Object.defineProperty(e,n,{configurable:!0,get(){return s}})}return e}function Wu(e){if(e==="true")return!0;if(e==="false")return!1;if(e===Number(e).toString())return Number(e);if(e===""||e==="null")return null;if(typeof e!="string")return e;try{return JSON.parse(decodeURIComponent(e))}catch{return e}}function ya(e){return e.replace(/[A-Z]/g,t=>\`-\${t.toLowerCase()}\`)}const Pn={setDataAttribute(e,t,n){e.setAttribute(\`data-bs-\${ya(t)}\`,n)},removeDataAttribute(e,t){e.removeAttribute(\`data-bs-\${ya(t)}\`)},getDataAttributes(e){if(!e)return{};const t={},n=Object.keys(e.dataset).filter(s=>s.startsWith("bs")&&!s.startsWith("bsConfig"));for(const s of n){let r=s.replace(/^bs/,"");r=r.charAt(0).toLowerCase()+r.slice(1),t[r]=Wu(e.dataset[s])}return t},getDataAttribute(e,t){return Wu(e.getAttribute(\`data-bs-\${ya(t)}\`))}};class ci{static get Default(){return{}}static get DefaultType(){return{}}static get NAME(){throw new Error('You have to implement the static method "NAME", for each component!')}_getConfig(t){return t=this._mergeConfigObj(t),t=this._configAfterMerge(t),this._typeCheckConfig(t),t}_configAfterMerge(t){return t}_mergeConfigObj(t,n){const s=In(n)?Pn.getDataAttribute(n,"config"):{};return{...this.constructor.Default,...typeof s=="object"?s:{},...In(n)?Pn.getDataAttributes(n):{},...typeof t=="object"?t:{}}}_typeCheckConfig(t,n=this.constructor.DefaultType){for(const[s,r]of Object.entries(n)){const i=t[s],o=In(i)?"element":w_(i);if(!new RegExp(r).test(o))throw new TypeError(\`\${this.constructor.NAME.toUpperCase()}: Option "\${s}" provided type "\${o}" but expected type "\${r}".\`)}}}const k_="5.3.8";class hn extends ci{constructor(t,n){super(),t=os(t),t&&(this._element=t,this._config=this._getConfig(n),ma.set(this._element,this.constructor.DATA_KEY,this))}dispose(){ma.remove(this._element,this.constructor.DATA_KEY),D.off(this._element,this.constructor.EVENT_KEY);for(const t of Object.getOwnPropertyNames(this))this[t]=null}_queueCallback(t,n,s=!0){fp(t,n,s)}_getConfig(t){return t=this._mergeConfigObj(t,this._element),t=this._configAfterMerge(t),this._typeCheckConfig(t),t}static getInstance(t){return ma.get(os(t),this.DATA_KEY)}static getOrCreateInstance(t,n={}){return this.getInstance(t)||new this(t,typeof n=="object"?n:null)}static get VERSION(){return k_}static get DATA_KEY(){return\`bs.\${this.NAME}\`}static get EVENT_KEY(){return\`.\${this.DATA_KEY}\`}static eventName(t){return\`\${t}\${this.EVENT_KEY}\`}}const _a=e=>{let t=e.getAttribute("data-bs-target");if(!t||t==="#"){let n=e.getAttribute("href");if(!n||!n.includes("#")&&!n.startsWith("."))return null;n.includes("#")&&!n.startsWith("#")&&(n=\`#\${n.split("#")[1]}\`),t=n&&n!=="#"?n.trim():null}return t?t.split(",").map(n=>ap(n)).join(","):null},ge={find(e,t=document.documentElement){return[].concat(...Element.prototype.querySelectorAll.call(t,e))},findOne(e,t=document.documentElement){return Element.prototype.querySelector.call(t,e)},children(e,t){return[].concat(...e.children).filter(n=>n.matches(t))},parents(e,t){const n=[];let s=e.parentNode.closest(t);for(;s;)n.push(s),s=s.parentNode.closest(t);return n},prev(e,t){let n=e.previousElementSibling;for(;n;){if(n.matches(t))return[n];n=n.previousElementSibling}return[]},next(e,t){let n=e.nextElementSibling;for(;n;){if(n.matches(t))return[n];n=n.nextElementSibling}return[]},focusableChildren(e){const t=["a","button","input","textarea","select","details","[tabindex]",'[contenteditable="true"]'].map(n=>\`\${n}:not([tabindex^="-"])\`).join(",");return this.find(t,e).filter(n=>!as(n)&&br(n))},getSelectorFromElement(e){const t=_a(e);return t&&ge.findOne(t)?t:null},getElementFromSelector(e){const t=_a(e);return t?ge.findOne(t):null},getMultipleElementsFromSelector(e){const t=_a(e);return t?ge.find(t):[]}},Vo=(e,t="hide")=>{const n=\`click.dismiss\${e.EVENT_KEY}\`,s=e.NAME;D.on(document,n,\`[data-bs-dismiss="\${s}"]\`,function(r){if(["A","AREA"].includes(this.tagName)&&r.preventDefault(),as(this))return;const i=ge.getElementFromSelector(this)||this.closest(\`.\${s}\`);e.getOrCreateInstance(i)[t]()})},I_="alert",P_="bs.alert",bp=\`.\${P_}\`,L_=\`close\${bp}\`,D_=\`closed\${bp}\`,F_="fade",z_="show";class Bo extends hn{static get NAME(){return I_}close(){if(D.trigger(this._element,L_).defaultPrevented)return;this._element.classList.remove(z_);const n=this._element.classList.contains(F_);this._queueCallback(()=>this._destroyElement(),this._element,n)}_destroyElement(){this._element.remove(),D.trigger(this._element,D_),this.dispose()}static jQueryInterface(t){return this.each(function(){const n=Bo.getOrCreateInstance(this);if(typeof t=="string"){if(n[t]===void 0||t.startsWith("_")||t==="constructor")throw new TypeError(\`No method named "\${t}"\`);n[t](this)}})}}Vo(Bo,"close");nn(Bo);const j_="button",H_="bs.button",V_=\`.\${H_}\`,B_=".data-api",W_="active",Uu='[data-bs-toggle="button"]',U_=\`click\${V_}\${B_}\`;class Wo extends hn{static get NAME(){return j_}toggle(){this._element.setAttribute("aria-pressed",this._element.classList.toggle(W_))}static jQueryInterface(t){return this.each(function(){const n=Wo.getOrCreateInstance(this);t==="toggle"&&n[t]()})}}D.on(document,U_,Uu,e=>{e.preventDefault();const t=e.target.closest(Uu);Wo.getOrCreateInstance(t).toggle()});nn(Wo);const q_="swipe",yr=".bs.swipe",K_=\`touchstart\${yr}\`,Y_=\`touchmove\${yr}\`,G_=\`touchend\${yr}\`,Q_=\`pointerdown\${yr}\`,X_=\`pointerup\${yr}\`,J_="touch",Z_="pen",e0="pointer-event",t0=40,n0={endCallback:null,leftCallback:null,rightCallback:null},s0={endCallback:"(function|null)",leftCallback:"(function|null)",rightCallback:"(function|null)"};class ho extends ci{constructor(t,n){super(),this._element=t,!(!t||!ho.isSupported())&&(this._config=this._getConfig(n),this._deltaX=0,this._supportPointerEvents=!!window.PointerEvent,this._initEvents())}static get Default(){return n0}static get DefaultType(){return s0}static get NAME(){return q_}dispose(){D.off(this._element,yr)}_start(t){if(!this._supportPointerEvents){this._deltaX=t.touches[0].clientX;return}this._eventIsPointerPenTouch(t)&&(this._deltaX=t.clientX)}_end(t){this._eventIsPointerPenTouch(t)&&(this._deltaX=t.clientX-this._deltaX),this._handleSwipe(),Pt(this._config.endCallback)}_move(t){this._deltaX=t.touches&&t.touches.length>1?0:t.touches[0].clientX-this._deltaX}_handleSwipe(){const t=Math.abs(this._deltaX);if(t<=t0)return;const n=t/this._deltaX;this._deltaX=0,n&&Pt(n>0?this._config.rightCallback:this._config.leftCallback)}_initEvents(){this._supportPointerEvents?(D.on(this._element,Q_,t=>this._start(t)),D.on(this._element,X_,t=>this._end(t)),this._element.classList.add(e0)):(D.on(this._element,K_,t=>this._start(t)),D.on(this._element,Y_,t=>this._move(t)),D.on(this._element,G_,t=>this._end(t)))}_eventIsPointerPenTouch(t){return this._supportPointerEvents&&(t.pointerType===Z_||t.pointerType===J_)}static isSupported(){return"ontouchstart"in document.documentElement||navigator.maxTouchPoints>0}}const r0="carousel",i0="bs.carousel",gs=\`.\${i0}\`,yp=".data-api",o0="ArrowLeft",a0="ArrowRight",l0=500,Cr="next",js="prev",Us="left",Ki="right",c0=\`slide\${gs}\`,Ea=\`slid\${gs}\`,u0=\`keydown\${gs}\`,f0=\`mouseenter\${gs}\`,d0=\`mouseleave\${gs}\`,h0=\`dragstart\${gs}\`,p0=\`load\${gs}\${yp}\`,g0=\`click\${gs}\${yp}\`,_p="carousel",$i="active",m0="slide",v0="carousel-item-end",b0="carousel-item-start",y0="carousel-item-next",_0="carousel-item-prev",Ep=".active",wp=".carousel-item",E0=Ep+wp,w0=".carousel-item img",S0=".carousel-indicators",x0="[data-bs-slide], [data-bs-slide-to]",T0='[data-bs-ride="carousel"]',A0={[o0]:Ki,[a0]:Us},O0={interval:5e3,keyboard:!0,pause:"hover",ride:!1,touch:!0,wrap:!0},C0={interval:"(number|boolean)",keyboard:"boolean",pause:"(string|boolean)",ride:"(boolean|string)",touch:"boolean",wrap:"boolean"};class ui extends hn{constructor(t,n){super(t,n),this._interval=null,this._activeElement=null,this._isSliding=!1,this.touchTimeout=null,this._swipeHelper=null,this._indicatorsElement=ge.findOne(S0,this._element),this._addEventListeners(),this._config.ride===_p&&this.cycle()}static get Default(){return O0}static get DefaultType(){return C0}static get NAME(){return r0}next(){this._slide(Cr)}nextWhenVisible(){!document.hidden&&br(this._element)&&this.next()}prev(){this._slide(js)}pause(){this._isSliding&&lp(this._element),this._clearInterval()}cycle(){this._clearInterval(),this._updateInterval(),this._interval=setInterval(()=>this.nextWhenVisible(),this._config.interval)}_maybeEnableCycle(){if(this._config.ride){if(this._isSliding){D.one(this._element,Ea,()=>this.cycle());return}this.cycle()}}to(t){const n=this._getItems();if(t>n.length-1||t<0)return;if(this._isSliding){D.one(this._element,Ea,()=>this.to(t));return}const s=this._getItemIndex(this._getActive());if(s===t)return;const r=t>s?Cr:js;this._slide(r,n[t])}dispose(){this._swipeHelper&&this._swipeHelper.dispose(),super.dispose()}_configAfterMerge(t){return t.defaultInterval=t.interval,t}_addEventListeners(){this._config.keyboard&&D.on(this._element,u0,t=>this._keydown(t)),this._config.pause==="hover"&&(D.on(this._element,f0,()=>this.pause()),D.on(this._element,d0,()=>this._maybeEnableCycle())),this._config.touch&&ho.isSupported()&&this._addTouchEventListeners()}_addTouchEventListeners(){for(const s of ge.find(w0,this._element))D.on(s,h0,r=>r.preventDefault());const n={leftCallback:()=>this._slide(this._directionToOrder(Us)),rightCallback:()=>this._slide(this._directionToOrder(Ki)),endCallback:()=>{this._config.pause==="hover"&&(this.pause(),this.touchTimeout&&clearTimeout(this.touchTimeout),this.touchTimeout=setTimeout(()=>this._maybeEnableCycle(),l0+this._config.interval))}};this._swipeHelper=new ho(this._element,n)}_keydown(t){if(/input|textarea/i.test(t.target.tagName))return;const n=A0[t.key];n&&(t.preventDefault(),this._slide(this._directionToOrder(n)))}_getItemIndex(t){return this._getItems().indexOf(t)}_setActiveIndicatorElement(t){if(!this._indicatorsElement)return;const n=ge.findOne(Ep,this._indicatorsElement);n.classList.remove($i),n.removeAttribute("aria-current");const s=ge.findOne(\`[data-bs-slide-to="\${t}"]\`,this._indicatorsElement);s&&(s.classList.add($i),s.setAttribute("aria-current","true"))}_updateInterval(){const t=this._activeElement||this._getActive();if(!t)return;const n=Number.parseInt(t.getAttribute("data-bs-interval"),10);this._config.interval=n||this._config.defaultInterval}_slide(t,n=null){if(this._isSliding)return;const s=this._getActive(),r=t===Cr,i=n||Ec(this._getItems(),s,r,this._config.wrap);if(i===s)return;const o=this._getItemIndex(i),a=h=>D.trigger(this._element,h,{relatedTarget:i,direction:this._orderToDirection(t),from:this._getItemIndex(s),to:o});if(a(c0).defaultPrevented||!s||!i)return;const u=!!this._interval;this.pause(),this._isSliding=!0,this._setActiveIndicatorElement(o),this._activeElement=i;const c=r?b0:v0,f=r?y0:_0;i.classList.add(f),li(i),s.classList.add(c),i.classList.add(c);const d=()=>{i.classList.remove(c,f),i.classList.add($i),s.classList.remove($i,f,c),this._isSliding=!1,a(Ea)};this._queueCallback(d,s,this._isAnimated()),u&&this.cycle()}_isAnimated(){return this._element.classList.contains(m0)}_getActive(){return ge.findOne(E0,this._element)}_getItems(){return ge.find(wp,this._element)}_clearInterval(){this._interval&&(clearInterval(this._interval),this._interval=null)}_directionToOrder(t){return en()?t===Us?js:Cr:t===Us?Cr:js}_orderToDirection(t){return en()?t===js?Us:Ki:t===js?Ki:Us}static jQueryInterface(t){return this.each(function(){const n=ui.getOrCreateInstance(this,t);if(typeof t=="number"){n.to(t);return}if(typeof t=="string"){if(n[t]===void 0||t.startsWith("_")||t==="constructor")throw new TypeError(\`No method named "\${t}"\`);n[t]()}})}}D.on(document,g0,x0,function(e){const t=ge.getElementFromSelector(this);if(!t||!t.classList.contains(_p))return;e.preventDefault();const n=ui.getOrCreateInstance(t),s=this.getAttribute("data-bs-slide-to");if(s){n.to(s),n._maybeEnableCycle();return}if(Pn.getDataAttribute(this,"slide")==="next"){n.next(),n._maybeEnableCycle();return}n.prev(),n._maybeEnableCycle()});D.on(window,p0,()=>{const e=ge.find(T0);for(const t of e)ui.getOrCreateInstance(t)});nn(ui);const R0="collapse",$0="bs.collapse",fi=\`.\${$0}\`,M0=".data-api",N0=\`show\${fi}\`,k0=\`shown\${fi}\`,I0=\`hide\${fi}\`,P0=\`hidden\${fi}\`,L0=\`click\${fi}\${M0}\`,wa="show",Ys="collapse",Mi="collapsing",D0="collapsed",F0=\`:scope .\${Ys} .\${Ys}\`,z0="collapse-horizontal",j0="width",H0="height",V0=".collapse.show, .collapse.collapsing",hl='[data-bs-toggle="collapse"]',B0={parent:null,toggle:!0},W0={parent:"(null|element)",toggle:"boolean"};class Jr extends hn{constructor(t,n){super(t,n),this._isTransitioning=!1,this._triggerArray=[];const s=ge.find(hl);for(const r of s){const i=ge.getSelectorFromElement(r),o=ge.find(i).filter(a=>a===this._element);i!==null&&o.length&&this._triggerArray.push(r)}this._initializeChildren(),this._config.parent||this._addAriaAndCollapsedClass(this._triggerArray,this._isShown()),this._config.toggle&&this.toggle()}static get Default(){return B0}static get DefaultType(){return W0}static get NAME(){return R0}toggle(){this._isShown()?this.hide():this.show()}show(){if(this._isTransitioning||this._isShown())return;let t=[];if(this._config.parent&&(t=this._getFirstLevelChildren(V0).filter(a=>a!==this._element).map(a=>Jr.getOrCreateInstance(a,{toggle:!1}))),t.length&&t[0]._isTransitioning||D.trigger(this._element,N0).defaultPrevented)return;for(const a of t)a.hide();const s=this._getDimension();this._element.classList.remove(Ys),this._element.classList.add(Mi),this._element.style[s]=0,this._addAriaAndCollapsedClass(this._triggerArray,!0),this._isTransitioning=!0;const r=()=>{this._isTransitioning=!1,this._element.classList.remove(Mi),this._element.classList.add(Ys,wa),this._element.style[s]="",D.trigger(this._element,k0)},o=\`scroll\${s[0].toUpperCase()+s.slice(1)}\`;this._queueCallback(r,this._element,!0),this._element.style[s]=\`\${this._element[o]}px\`}hide(){if(this._isTransitioning||!this._isShown()||D.trigger(this._element,I0).defaultPrevented)return;const n=this._getDimension();this._element.style[n]=\`\${this._element.getBoundingClientRect()[n]}px\`,li(this._element),this._element.classList.add(Mi),this._element.classList.remove(Ys,wa);for(const r of this._triggerArray){const i=ge.getElementFromSelector(r);i&&!this._isShown(i)&&this._addAriaAndCollapsedClass([r],!1)}this._isTransitioning=!0;const s=()=>{this._isTransitioning=!1,this._element.classList.remove(Mi),this._element.classList.add(Ys),D.trigger(this._element,P0)};this._element.style[n]="",this._queueCallback(s,this._element,!0)}_isShown(t=this._element){return t.classList.contains(wa)}_configAfterMerge(t){return t.toggle=!!t.toggle,t.parent=os(t.parent),t}_getDimension(){return this._element.classList.contains(z0)?j0:H0}_initializeChildren(){if(!this._config.parent)return;const t=this._getFirstLevelChildren(hl);for(const n of t){const s=ge.getElementFromSelector(n);s&&this._addAriaAndCollapsedClass([n],this._isShown(s))}}_getFirstLevelChildren(t){const n=ge.find(F0,this._config.parent);return ge.find(t,this._config.parent).filter(s=>!n.includes(s))}_addAriaAndCollapsedClass(t,n){if(t.length)for(const s of t)s.classList.toggle(D0,!n),s.setAttribute("aria-expanded",n)}static jQueryInterface(t){const n={};return typeof t=="string"&&/show|hide/.test(t)&&(n.toggle=!1),this.each(function(){const s=Jr.getOrCreateInstance(this,n);if(typeof t=="string"){if(typeof s[t]>"u")throw new TypeError(\`No method named "\${t}"\`);s[t]()}})}}D.on(document,L0,hl,function(e){(e.target.tagName==="A"||e.delegateTarget&&e.delegateTarget.tagName==="A")&&e.preventDefault();for(const t of ge.getMultipleElementsFromSelector(this))Jr.getOrCreateInstance(t,{toggle:!1}).toggle()});nn(Jr);const qu="dropdown",U0="bs.dropdown",Ps=\`.\${U0}\`,Sc=".data-api",q0="Escape",Ku="Tab",K0="ArrowUp",Yu="ArrowDown",Y0=2,G0=\`hide\${Ps}\`,Q0=\`hidden\${Ps}\`,X0=\`show\${Ps}\`,J0=\`shown\${Ps}\`,Sp=\`click\${Ps}\${Sc}\`,xp=\`keydown\${Ps}\${Sc}\`,Z0=\`keyup\${Ps}\${Sc}\`,qs="show",e1="dropup",t1="dropend",n1="dropstart",s1="dropup-center",r1="dropdown-center",xs='[data-bs-toggle="dropdown"]:not(.disabled):not(:disabled)',i1=\`\${xs}.\${qs}\`,Yi=".dropdown-menu",o1=".navbar",a1=".navbar-nav",l1=".dropdown-menu .dropdown-item:not(.disabled):not(:disabled)",c1=en()?"top-end":"top-start",u1=en()?"top-start":"top-end",f1=en()?"bottom-end":"bottom-start",d1=en()?"bottom-start":"bottom-end",h1=en()?"left-start":"right-start",p1=en()?"right-start":"left-start",g1="top",m1="bottom",v1={autoClose:!0,boundary:"clippingParents",display:"dynamic",offset:[0,2],popperConfig:null,reference:"toggle"},b1={autoClose:"(boolean|string)",boundary:"(string|element)",display:"string",offset:"(array|string|function)",popperConfig:"(null|object|function)",reference:"(string|element|object)"};class ln extends hn{constructor(t,n){super(t,n),this._popper=null,this._parent=this._element.parentNode,this._menu=ge.next(this._element,Yi)[0]||ge.prev(this._element,Yi)[0]||ge.findOne(Yi,this._parent),this._inNavbar=this._detectNavbar()}static get Default(){return v1}static get DefaultType(){return b1}static get NAME(){return qu}toggle(){return this._isShown()?this.hide():this.show()}show(){if(as(this._element)||this._isShown())return;const t={relatedTarget:this._element};if(!D.trigger(this._element,X0,t).defaultPrevented){if(this._createPopper(),"ontouchstart"in document.documentElement&&!this._parent.closest(a1))for(const s of[].concat(...document.body.children))D.on(s,"mouseover",fo);this._element.focus(),this._element.setAttribute("aria-expanded",!0),this._menu.classList.add(qs),this._element.classList.add(qs),D.trigger(this._element,J0,t)}}hide(){if(as(this._element)||!this._isShown())return;const t={relatedTarget:this._element};this._completeHide(t)}dispose(){this._popper&&this._popper.destroy(),super.dispose()}update(){this._inNavbar=this._detectNavbar(),this._popper&&this._popper.update()}_completeHide(t){if(!D.trigger(this._element,G0,t).defaultPrevented){if("ontouchstart"in document.documentElement)for(const s of[].concat(...document.body.children))D.off(s,"mouseover",fo);this._popper&&this._popper.destroy(),this._menu.classList.remove(qs),this._element.classList.remove(qs),this._element.setAttribute("aria-expanded","false"),Pn.removeDataAttribute(this._menu,"popper"),D.trigger(this._element,Q0,t)}}_getConfig(t){if(t=super._getConfig(t),typeof t.reference=="object"&&!In(t.reference)&&typeof t.reference.getBoundingClientRect!="function")throw new TypeError(\`\${qu.toUpperCase()}: Option "reference" provided type "object" without a required "getBoundingClientRect" method.\`);return t}_createPopper(){if(typeof op>"u")throw new TypeError("Bootstrap's dropdowns require Popper (https://popper.js.org/docs/v2/)");let t=this._element;this._config.reference==="parent"?t=this._parent:In(this._config.reference)?t=os(this._config.reference):typeof this._config.reference=="object"&&(t=this._config.reference);const n=this._getPopperConfig();this._popper=_c(t,this._menu,n)}_isShown(){return this._menu.classList.contains(qs)}_getPlacement(){const t=this._parent;if(t.classList.contains(t1))return h1;if(t.classList.contains(n1))return p1;if(t.classList.contains(s1))return g1;if(t.classList.contains(r1))return m1;const n=getComputedStyle(this._menu).getPropertyValue("--bs-position").trim()==="end";return t.classList.contains(e1)?n?u1:c1:n?d1:f1}_detectNavbar(){return this._element.closest(o1)!==null}_getOffset(){const{offset:t}=this._config;return typeof t=="string"?t.split(",").map(n=>Number.parseInt(n,10)):typeof t=="function"?n=>t(n,this._element):t}_getPopperConfig(){const t={placement:this._getPlacement(),modifiers:[{name:"preventOverflow",options:{boundary:this._config.boundary}},{name:"offset",options:{offset:this._getOffset()}}]};return(this._inNavbar||this._config.display==="static")&&(Pn.setDataAttribute(this._menu,"popper","static"),t.modifiers=[{name:"applyStyles",enabled:!1}]),{...t,...Pt(this._config.popperConfig,[void 0,t])}}_selectMenuItem({key:t,target:n}){const s=ge.find(l1,this._menu).filter(r=>br(r));s.length&&Ec(s,n,t===Yu,!s.includes(n)).focus()}static jQueryInterface(t){return this.each(function(){const n=ln.getOrCreateInstance(this,t);if(typeof t=="string"){if(typeof n[t]>"u")throw new TypeError(\`No method named "\${t}"\`);n[t]()}})}static clearMenus(t){if(t.button===Y0||t.type==="keyup"&&t.key!==Ku)return;const n=ge.find(i1);for(const s of n){const r=ln.getInstance(s);if(!r||r._config.autoClose===!1)continue;const i=t.composedPath(),o=i.includes(r._menu);if(i.includes(r._element)||r._config.autoClose==="inside"&&!o||r._config.autoClose==="outside"&&o||r._menu.contains(t.target)&&(t.type==="keyup"&&t.key===Ku||/input|select|option|textarea|form/i.test(t.target.tagName)))continue;const a={relatedTarget:r._element};t.type==="click"&&(a.clickEvent=t),r._completeHide(a)}}static dataApiKeydownHandler(t){const n=/input|textarea/i.test(t.target.tagName),s=t.key===q0,r=[K0,Yu].includes(t.key);if(!r&&!s||n&&!s)return;t.preventDefault();const i=this.matches(xs)?this:ge.prev(this,xs)[0]||ge.next(this,xs)[0]||ge.findOne(xs,t.delegateTarget.parentNode),o=ln.getOrCreateInstance(i);if(r){t.stopPropagation(),o.show(),o._selectMenuItem(t);return}o._isShown()&&(t.stopPropagation(),o.hide(),i.focus())}}D.on(document,xp,xs,ln.dataApiKeydownHandler);D.on(document,xp,Yi,ln.dataApiKeydownHandler);D.on(document,Sp,ln.clearMenus);D.on(document,Z0,ln.clearMenus);D.on(document,Sp,xs,function(e){e.preventDefault(),ln.getOrCreateInstance(this).toggle()});nn(ln);const Tp="backdrop",y1="fade",Gu="show",Qu=\`mousedown.bs.\${Tp}\`,_1={className:"modal-backdrop",clickCallback:null,isAnimated:!1,isVisible:!0,rootElement:"body"},E1={className:"string",clickCallback:"(function|null)",isAnimated:"boolean",isVisible:"boolean",rootElement:"(element|string)"};class Ap extends ci{constructor(t){super(),this._config=this._getConfig(t),this._isAppended=!1,this._element=null}static get Default(){return _1}static get DefaultType(){return E1}static get NAME(){return Tp}show(t){if(!this._config.isVisible){Pt(t);return}this._append();const n=this._getElement();this._config.isAnimated&&li(n),n.classList.add(Gu),this._emulateAnimation(()=>{Pt(t)})}hide(t){if(!this._config.isVisible){Pt(t);return}this._getElement().classList.remove(Gu),this._emulateAnimation(()=>{this.dispose(),Pt(t)})}dispose(){this._isAppended&&(D.off(this._element,Qu),this._element.remove(),this._isAppended=!1)}_getElement(){if(!this._element){const t=document.createElement("div");t.className=this._config.className,this._config.isAnimated&&t.classList.add(y1),this._element=t}return this._element}_configAfterMerge(t){return t.rootElement=os(t.rootElement),t}_append(){if(this._isAppended)return;const t=this._getElement();this._config.rootElement.append(t),D.on(t,Qu,()=>{Pt(this._config.clickCallback)}),this._isAppended=!0}_emulateAnimation(t){fp(t,this._getElement(),this._config.isAnimated)}}const w1="focustrap",S1="bs.focustrap",po=\`.\${S1}\`,x1=\`focusin\${po}\`,T1=\`keydown.tab\${po}\`,A1="Tab",O1="forward",Xu="backward",C1={autofocus:!0,trapElement:null},R1={autofocus:"boolean",trapElement:"element"};class Op extends ci{constructor(t){super(),this._config=this._getConfig(t),this._isActive=!1,this._lastTabNavDirection=null}static get Default(){return C1}static get DefaultType(){return R1}static get NAME(){return w1}activate(){this._isActive||(this._config.autofocus&&this._config.trapElement.focus(),D.off(document,po),D.on(document,x1,t=>this._handleFocusin(t)),D.on(document,T1,t=>this._handleKeydown(t)),this._isActive=!0)}deactivate(){this._isActive&&(this._isActive=!1,D.off(document,po))}_handleFocusin(t){const{trapElement:n}=this._config;if(t.target===document||t.target===n||n.contains(t.target))return;const s=ge.focusableChildren(n);s.length===0?n.focus():this._lastTabNavDirection===Xu?s[s.length-1].focus():s[0].focus()}_handleKeydown(t){t.key===A1&&(this._lastTabNavDirection=t.shiftKey?Xu:O1)}}const Ju=".fixed-top, .fixed-bottom, .is-fixed, .sticky-top",Zu=".sticky-top",Ni="padding-right",ef="margin-right";class pl{constructor(){this._element=document.body}getWidth(){const t=document.documentElement.clientWidth;return Math.abs(window.innerWidth-t)}hide(){const t=this.getWidth();this._disableOverFlow(),this._setElementAttributes(this._element,Ni,n=>n+t),this._setElementAttributes(Ju,Ni,n=>n+t),this._setElementAttributes(Zu,ef,n=>n-t)}reset(){this._resetElementAttributes(this._element,"overflow"),this._resetElementAttributes(this._element,Ni),this._resetElementAttributes(Ju,Ni),this._resetElementAttributes(Zu,ef)}isOverflowing(){return this.getWidth()>0}_disableOverFlow(){this._saveInitialAttribute(this._element,"overflow"),this._element.style.overflow="hidden"}_setElementAttributes(t,n,s){const r=this.getWidth(),i=o=>{if(o!==this._element&&window.innerWidth>o.clientWidth+r)return;this._saveInitialAttribute(o,n);const a=window.getComputedStyle(o).getPropertyValue(n);o.style.setProperty(n,\`\${s(Number.parseFloat(a))}px\`)};this._applyManipulationCallback(t,i)}_saveInitialAttribute(t,n){const s=t.style.getPropertyValue(n);s&&Pn.setDataAttribute(t,n,s)}_resetElementAttributes(t,n){const s=r=>{const i=Pn.getDataAttribute(r,n);if(i===null){r.style.removeProperty(n);return}Pn.removeDataAttribute(r,n),r.style.setProperty(n,i)};this._applyManipulationCallback(t,s)}_applyManipulationCallback(t,n){if(In(t)){n(t);return}for(const s of ge.find(t,this._element))n(s)}}const $1="modal",M1="bs.modal",tn=\`.\${M1}\`,N1=".data-api",k1="Escape",I1=\`hide\${tn}\`,P1=\`hidePrevented\${tn}\`,Cp=\`hidden\${tn}\`,Rp=\`show\${tn}\`,L1=\`shown\${tn}\`,D1=\`resize\${tn}\`,F1=\`click.dismiss\${tn}\`,z1=\`mousedown.dismiss\${tn}\`,j1=\`keydown.dismiss\${tn}\`,H1=\`click\${tn}\${N1}\`,tf="modal-open",V1="fade",nf="show",Sa="modal-static",B1=".modal.show",W1=".modal-dialog",U1=".modal-body",q1='[data-bs-toggle="modal"]',K1={backdrop:!0,focus:!0,keyboard:!0},Y1={backdrop:"(boolean|string)",focus:"boolean",keyboard:"boolean"};class ls extends hn{constructor(t,n){super(t,n),this._dialog=ge.findOne(W1,this._element),this._backdrop=this._initializeBackDrop(),this._focustrap=this._initializeFocusTrap(),this._isShown=!1,this._isTransitioning=!1,this._scrollBar=new pl,this._addEventListeners()}static get Default(){return K1}static get DefaultType(){return Y1}static get NAME(){return $1}toggle(t){return this._isShown?this.hide():this.show(t)}show(t){this._isShown||this._isTransitioning||D.trigger(this._element,Rp,{relatedTarget:t}).defaultPrevented||(this._isShown=!0,this._isTransitioning=!0,this._scrollBar.hide(),document.body.classList.add(tf),this._adjustDialog(),this._backdrop.show(()=>this._showElement(t)))}hide(){!this._isShown||this._isTransitioning||D.trigger(this._element,I1).defaultPrevented||(this._isShown=!1,this._isTransitioning=!0,this._focustrap.deactivate(),this._element.classList.remove(nf),this._queueCallback(()=>this._hideModal(),this._element,this._isAnimated()))}dispose(){D.off(window,tn),D.off(this._dialog,tn),this._backdrop.dispose(),this._focustrap.deactivate(),super.dispose()}handleUpdate(){this._adjustDialog()}_initializeBackDrop(){return new Ap({isVisible:!!this._config.backdrop,isAnimated:this._isAnimated()})}_initializeFocusTrap(){return new Op({trapElement:this._element})}_showElement(t){document.body.contains(this._element)||document.body.append(this._element),this._element.style.display="block",this._element.removeAttribute("aria-hidden"),this._element.setAttribute("aria-modal",!0),this._element.setAttribute("role","dialog"),this._element.scrollTop=0;const n=ge.findOne(U1,this._dialog);n&&(n.scrollTop=0),li(this._element),this._element.classList.add(nf);const s=()=>{this._config.focus&&this._focustrap.activate(),this._isTransitioning=!1,D.trigger(this._element,L1,{relatedTarget:t})};this._queueCallback(s,this._dialog,this._isAnimated())}_addEventListeners(){D.on(this._element,j1,t=>{if(t.key===k1){if(this._config.keyboard){this.hide();return}this._triggerBackdropTransition()}}),D.on(window,D1,()=>{this._isShown&&!this._isTransitioning&&this._adjustDialog()}),D.on(this._element,z1,t=>{D.one(this._element,F1,n=>{if(!(this._element!==t.target||this._element!==n.target)){if(this._config.backdrop==="static"){this._triggerBackdropTransition();return}this._config.backdrop&&this.hide()}})})}_hideModal(){this._element.style.display="none",this._element.setAttribute("aria-hidden",!0),this._element.removeAttribute("aria-modal"),this._element.removeAttribute("role"),this._isTransitioning=!1,this._backdrop.hide(()=>{document.body.classList.remove(tf),this._resetAdjustments(),this._scrollBar.reset(),D.trigger(this._element,Cp)})}_isAnimated(){return this._element.classList.contains(V1)}_triggerBackdropTransition(){if(D.trigger(this._element,P1).defaultPrevented)return;const n=this._element.scrollHeight>document.documentElement.clientHeight,s=this._element.style.overflowY;s==="hidden"||this._element.classList.contains(Sa)||(n||(this._element.style.overflowY="hidden"),this._element.classList.add(Sa),this._queueCallback(()=>{this._element.classList.remove(Sa),this._queueCallback(()=>{this._element.style.overflowY=s},this._dialog)},this._dialog),this._element.focus())}_adjustDialog(){const t=this._element.scrollHeight>document.documentElement.clientHeight,n=this._scrollBar.getWidth(),s=n>0;if(s&&!t){const r=en()?"paddingLeft":"paddingRight";this._element.style[r]=\`\${n}px\`}if(!s&&t){const r=en()?"paddingRight":"paddingLeft";this._element.style[r]=\`\${n}px\`}}_resetAdjustments(){this._element.style.paddingLeft="",this._element.style.paddingRight=""}static jQueryInterface(t,n){return this.each(function(){const s=ls.getOrCreateInstance(this,t);if(typeof t=="string"){if(typeof s[t]>"u")throw new TypeError(\`No method named "\${t}"\`);s[t](n)}})}}D.on(document,H1,q1,function(e){const t=ge.getElementFromSelector(this);["A","AREA"].includes(this.tagName)&&e.preventDefault(),D.one(t,Rp,r=>{r.defaultPrevented||D.one(t,Cp,()=>{br(this)&&this.focus()})});const n=ge.findOne(B1);n&&ls.getInstance(n).hide(),ls.getOrCreateInstance(t).toggle(this)});Vo(ls);nn(ls);const G1="offcanvas",Q1="bs.offcanvas",Wn=\`.\${Q1}\`,$p=".data-api",X1=\`load\${Wn}\${$p}\`,J1="Escape",sf="show",rf="showing",of="hiding",Z1="offcanvas-backdrop",Mp=".offcanvas.show",eE=\`show\${Wn}\`,tE=\`shown\${Wn}\`,nE=\`hide\${Wn}\`,af=\`hidePrevented\${Wn}\`,Np=\`hidden\${Wn}\`,sE=\`resize\${Wn}\`,rE=\`click\${Wn}\${$p}\`,iE=\`keydown.dismiss\${Wn}\`,oE='[data-bs-toggle="offcanvas"]',aE={backdrop:!0,keyboard:!0,scroll:!1},lE={backdrop:"(boolean|string)",keyboard:"boolean",scroll:"boolean"};class cs extends hn{constructor(t,n){super(t,n),this._isShown=!1,this._backdrop=this._initializeBackDrop(),this._focustrap=this._initializeFocusTrap(),this._addEventListeners()}static get Default(){return aE}static get DefaultType(){return lE}static get NAME(){return G1}toggle(t){return this._isShown?this.hide():this.show(t)}show(t){if(this._isShown||D.trigger(this._element,eE,{relatedTarget:t}).defaultPrevented)return;this._isShown=!0,this._backdrop.show(),this._config.scroll||new pl().hide(),this._element.setAttribute("aria-modal",!0),this._element.setAttribute("role","dialog"),this._element.classList.add(rf);const s=()=>{(!this._config.scroll||this._config.backdrop)&&this._focustrap.activate(),this._element.classList.add(sf),this._element.classList.remove(rf),D.trigger(this._element,tE,{relatedTarget:t})};this._queueCallback(s,this._element,!0)}hide(){if(!this._isShown||D.trigger(this._element,nE).defaultPrevented)return;this._focustrap.deactivate(),this._element.blur(),this._isShown=!1,this._element.classList.add(of),this._backdrop.hide();const n=()=>{this._element.classList.remove(sf,of),this._element.removeAttribute("aria-modal"),this._element.removeAttribute("role"),this._config.scroll||new pl().reset(),D.trigger(this._element,Np)};this._queueCallback(n,this._element,!0)}dispose(){this._backdrop.dispose(),this._focustrap.deactivate(),super.dispose()}_initializeBackDrop(){const t=()=>{if(this._config.backdrop==="static"){D.trigger(this._element,af);return}this.hide()},n=!!this._config.backdrop;return new Ap({className:Z1,isVisible:n,isAnimated:!0,rootElement:this._element.parentNode,clickCallback:n?t:null})}_initializeFocusTrap(){return new Op({trapElement:this._element})}_addEventListeners(){D.on(this._element,iE,t=>{if(t.key===J1){if(this._config.keyboard){this.hide();return}D.trigger(this._element,af)}})}static jQueryInterface(t){return this.each(function(){const n=cs.getOrCreateInstance(this,t);if(typeof t=="string"){if(n[t]===void 0||t.startsWith("_")||t==="constructor")throw new TypeError(\`No method named "\${t}"\`);n[t](this)}})}}D.on(document,rE,oE,function(e){const t=ge.getElementFromSelector(this);if(["A","AREA"].includes(this.tagName)&&e.preventDefault(),as(this))return;D.one(t,Np,()=>{br(this)&&this.focus()});const n=ge.findOne(Mp);n&&n!==t&&cs.getInstance(n).hide(),cs.getOrCreateInstance(t).toggle(this)});D.on(window,X1,()=>{for(const e of ge.find(Mp))cs.getOrCreateInstance(e).show()});D.on(window,sE,()=>{for(const e of ge.find("[aria-modal][class*=show][class*=offcanvas-]"))getComputedStyle(e).position!=="fixed"&&cs.getOrCreateInstance(e).hide()});Vo(cs);nn(cs);const cE=/^aria-[\\w-]*$/i,kp={"*":["class","dir","id","lang","role",cE],a:["target","href","title","rel"],area:[],b:[],br:[],col:[],code:[],dd:[],div:[],dl:[],dt:[],em:[],hr:[],h1:[],h2:[],h3:[],h4:[],h5:[],h6:[],i:[],img:["src","srcset","alt","title","width","height"],li:[],ol:[],p:[],pre:[],s:[],small:[],span:[],sub:[],sup:[],strong:[],u:[],ul:[]},uE=new Set(["background","cite","href","itemtype","longdesc","poster","src","xlink:href"]),fE=/^(?!javascript:)(?:[a-z0-9+.-]+:|[^&:/?#]*(?:[/?#]|$))/i,dE=(e,t)=>{const n=e.nodeName.toLowerCase();return t.includes(n)?uE.has(n)?!!fE.test(e.nodeValue):!0:t.filter(s=>s instanceof RegExp).some(s=>s.test(n))};function hE(e,t,n){if(!e.length)return e;if(n&&typeof n=="function")return n(e);const r=new window.DOMParser().parseFromString(e,"text/html"),i=[].concat(...r.body.querySelectorAll("*"));for(const o of i){const a=o.nodeName.toLowerCase();if(!Object.keys(t).includes(a)){o.remove();continue}const l=[].concat(...o.attributes),u=[].concat(t["*"]||[],t[a]||[]);for(const c of l)dE(c,u)||o.removeAttribute(c.nodeName)}return r.body.innerHTML}const pE="TemplateFactory",gE={allowList:kp,content:{},extraClass:"",html:!1,sanitize:!0,sanitizeFn:null,template:"<div></div>"},mE={allowList:"object",content:"object",extraClass:"(string|function)",html:"boolean",sanitize:"boolean",sanitizeFn:"(null|function)",template:"string"},vE={entry:"(string|element|function|null)",selector:"(string|element)"};class bE extends ci{constructor(t){super(),this._config=this._getConfig(t)}static get Default(){return gE}static get DefaultType(){return mE}static get NAME(){return pE}getContent(){return Object.values(this._config.content).map(t=>this._resolvePossibleFunction(t)).filter(Boolean)}hasContent(){return this.getContent().length>0}changeContent(t){return this._checkContent(t),this._config.content={...this._config.content,...t},this}toHtml(){const t=document.createElement("div");t.innerHTML=this._maybeSanitize(this._config.template);for(const[r,i]of Object.entries(this._config.content))this._setContent(t,i,r);const n=t.children[0],s=this._resolvePossibleFunction(this._config.extraClass);return s&&n.classList.add(...s.split(" ")),n}_typeCheckConfig(t){super._typeCheckConfig(t),this._checkContent(t.content)}_checkContent(t){for(const[n,s]of Object.entries(t))super._typeCheckConfig({selector:n,entry:s},vE)}_setContent(t,n,s){const r=ge.findOne(s,t);if(r){if(n=this._resolvePossibleFunction(n),!n){r.remove();return}if(In(n)){this._putElementInTemplate(os(n),r);return}if(this._config.html){r.innerHTML=this._maybeSanitize(n);return}r.textContent=n}}_maybeSanitize(t){return this._config.sanitize?hE(t,this._config.allowList,this._config.sanitizeFn):t}_resolvePossibleFunction(t){return Pt(t,[void 0,this])}_putElementInTemplate(t,n){if(this._config.html){n.innerHTML="",n.append(t);return}n.textContent=t.textContent}}const yE="tooltip",_E=new Set(["sanitize","allowList","sanitizeFn"]),xa="fade",EE="modal",ki="show",wE=".tooltip-inner",lf=\`.\${EE}\`,cf="hide.bs.modal",Rr="hover",Ta="focus",Aa="click",SE="manual",xE="hide",TE="hidden",AE="show",OE="shown",CE="inserted",RE="click",$E="focusin",ME="focusout",NE="mouseenter",kE="mouseleave",IE={AUTO:"auto",TOP:"top",RIGHT:en()?"left":"right",BOTTOM:"bottom",LEFT:en()?"right":"left"},PE={allowList:kp,animation:!0,boundary:"clippingParents",container:!1,customClass:"",delay:0,fallbackPlacements:["top","right","bottom","left"],html:!1,offset:[0,6],placement:"top",popperConfig:null,sanitize:!0,sanitizeFn:null,selector:!1,template:'<div class="tooltip" role="tooltip"><div class="tooltip-arrow"></div><div class="tooltip-inner"></div></div>',title:"",trigger:"hover focus"},LE={allowList:"object",animation:"boolean",boundary:"(string|element)",container:"(string|element|boolean)",customClass:"(string|function)",delay:"(number|object)",fallbackPlacements:"array",html:"boolean",offset:"(array|string|function)",placement:"(string|function)",popperConfig:"(null|object|function)",sanitize:"boolean",sanitizeFn:"(null|function)",selector:"(string|boolean)",template:"string",title:"(string|element|function)",trigger:"string"};class _r extends hn{constructor(t,n){if(typeof op>"u")throw new TypeError("Bootstrap's tooltips require Popper (https://popper.js.org/docs/v2/)");super(t,n),this._isEnabled=!0,this._timeout=0,this._isHovered=null,this._activeTrigger={},this._popper=null,this._templateFactory=null,this._newContent=null,this.tip=null,this._setListeners(),this._config.selector||this._fixTitle()}static get Default(){return PE}static get DefaultType(){return LE}static get NAME(){return yE}enable(){this._isEnabled=!0}disable(){this._isEnabled=!1}toggleEnabled(){this._isEnabled=!this._isEnabled}toggle(){if(this._isEnabled){if(this._isShown()){this._leave();return}this._enter()}}dispose(){clearTimeout(this._timeout),D.off(this._element.closest(lf),cf,this._hideModalHandler),this._element.getAttribute("data-bs-original-title")&&this._element.setAttribute("title",this._element.getAttribute("data-bs-original-title")),this._disposePopper(),super.dispose()}show(){if(this._element.style.display==="none")throw new Error("Please use show on visible elements");if(!(this._isWithContent()&&this._isEnabled))return;const t=D.trigger(this._element,this.constructor.eventName(AE)),s=(cp(this._element)||this._element.ownerDocument.documentElement).contains(this._element);if(t.defaultPrevented||!s)return;this._disposePopper();const r=this._getTipElement();this._element.setAttribute("aria-describedby",r.getAttribute("id"));const{container:i}=this._config;if(this._element.ownerDocument.documentElement.contains(this.tip)||(i.append(r),D.trigger(this._element,this.constructor.eventName(CE))),this._popper=this._createPopper(r),r.classList.add(ki),"ontouchstart"in document.documentElement)for(const a of[].concat(...document.body.children))D.on(a,"mouseover",fo);const o=()=>{D.trigger(this._element,this.constructor.eventName(OE)),this._isHovered===!1&&this._leave(),this._isHovered=!1};this._queueCallback(o,this.tip,this._isAnimated())}hide(){if(!this._isShown()||D.trigger(this._element,this.constructor.eventName(xE)).defaultPrevented)return;if(this._getTipElement().classList.remove(ki),"ontouchstart"in document.documentElement)for(const r of[].concat(...document.body.children))D.off(r,"mouseover",fo);this._activeTrigger[Aa]=!1,this._activeTrigger[Ta]=!1,this._activeTrigger[Rr]=!1,this._isHovered=null;const s=()=>{this._isWithActiveTrigger()||(this._isHovered||this._disposePopper(),this._element.removeAttribute("aria-describedby"),D.trigger(this._element,this.constructor.eventName(TE)))};this._queueCallback(s,this.tip,this._isAnimated())}update(){this._popper&&this._popper.update()}_isWithContent(){return!!this._getTitle()}_getTipElement(){return this.tip||(this.tip=this._createTipElement(this._newContent||this._getContentForTemplate())),this.tip}_createTipElement(t){const n=this._getTemplateFactory(t).toHtml();if(!n)return null;n.classList.remove(xa,ki),n.classList.add(\`bs-\${this.constructor.NAME}-auto\`);const s=S_(this.constructor.NAME).toString();return n.setAttribute("id",s),this._isAnimated()&&n.classList.add(xa),n}setContent(t){this._newContent=t,this._isShown()&&(this._disposePopper(),this.show())}_getTemplateFactory(t){return this._templateFactory?this._templateFactory.changeContent(t):this._templateFactory=new bE({...this._config,content:t,extraClass:this._resolvePossibleFunction(this._config.customClass)}),this._templateFactory}_getContentForTemplate(){return{[wE]:this._getTitle()}}_getTitle(){return this._resolvePossibleFunction(this._config.title)||this._element.getAttribute("data-bs-original-title")}_initializeOnDelegatedTarget(t){return this.constructor.getOrCreateInstance(t.delegateTarget,this._getDelegateConfig())}_isAnimated(){return this._config.animation||this.tip&&this.tip.classList.contains(xa)}_isShown(){return this.tip&&this.tip.classList.contains(ki)}_createPopper(t){const n=Pt(this._config.placement,[this,t,this._element]),s=IE[n.toUpperCase()];return _c(this._element,t,this._getPopperConfig(s))}_getOffset(){const{offset:t}=this._config;return typeof t=="string"?t.split(",").map(n=>Number.parseInt(n,10)):typeof t=="function"?n=>t(n,this._element):t}_resolvePossibleFunction(t){return Pt(t,[this._element,this._element])}_getPopperConfig(t){const n={placement:t,modifiers:[{name:"flip",options:{fallbackPlacements:this._config.fallbackPlacements}},{name:"offset",options:{offset:this._getOffset()}},{name:"preventOverflow",options:{boundary:this._config.boundary}},{name:"arrow",options:{element:\`.\${this.constructor.NAME}-arrow\`}},{name:"preSetPlacement",enabled:!0,phase:"beforeMain",fn:s=>{this._getTipElement().setAttribute("data-popper-placement",s.state.placement)}}]};return{...n,...Pt(this._config.popperConfig,[void 0,n])}}_setListeners(){const t=this._config.trigger.split(" ");for(const n of t)if(n==="click")D.on(this._element,this.constructor.eventName(RE),this._config.selector,s=>{const r=this._initializeOnDelegatedTarget(s);r._activeTrigger[Aa]=!(r._isShown()&&r._activeTrigger[Aa]),r.toggle()});else if(n!==SE){const s=n===Rr?this.constructor.eventName(NE):this.constructor.eventName($E),r=n===Rr?this.constructor.eventName(kE):this.constructor.eventName(ME);D.on(this._element,s,this._config.selector,i=>{const o=this._initializeOnDelegatedTarget(i);o._activeTrigger[i.type==="focusin"?Ta:Rr]=!0,o._enter()}),D.on(this._element,r,this._config.selector,i=>{const o=this._initializeOnDelegatedTarget(i);o._activeTrigger[i.type==="focusout"?Ta:Rr]=o._element.contains(i.relatedTarget),o._leave()})}this._hideModalHandler=()=>{this._element&&this.hide()},D.on(this._element.closest(lf),cf,this._hideModalHandler)}_fixTitle(){const t=this._element.getAttribute("title");t&&(!this._element.getAttribute("aria-label")&&!this._element.textContent.trim()&&this._element.setAttribute("aria-label",t),this._element.setAttribute("data-bs-original-title",t),this._element.removeAttribute("title"))}_enter(){if(this._isShown()||this._isHovered){this._isHovered=!0;return}this._isHovered=!0,this._setTimeout(()=>{this._isHovered&&this.show()},this._config.delay.show)}_leave(){this._isWithActiveTrigger()||(this._isHovered=!1,this._setTimeout(()=>{this._isHovered||this.hide()},this._config.delay.hide))}_setTimeout(t,n){clearTimeout(this._timeout),this._timeout=setTimeout(t,n)}_isWithActiveTrigger(){return Object.values(this._activeTrigger).includes(!0)}_getConfig(t){const n=Pn.getDataAttributes(this._element);for(const s of Object.keys(n))_E.has(s)&&delete n[s];return t={...n,...typeof t=="object"&&t?t:{}},t=this._mergeConfigObj(t),t=this._configAfterMerge(t),this._typeCheckConfig(t),t}_configAfterMerge(t){return t.container=t.container===!1?document.body:os(t.container),typeof t.delay=="number"&&(t.delay={show:t.delay,hide:t.delay}),typeof t.title=="number"&&(t.title=t.title.toString()),typeof t.content=="number"&&(t.content=t.content.toString()),t}_getDelegateConfig(){const t={};for(const[n,s]of Object.entries(this._config))this.constructor.Default[n]!==s&&(t[n]=s);return t.selector=!1,t.trigger="manual",t}_disposePopper(){this._popper&&(this._popper.destroy(),this._popper=null),this.tip&&(this.tip.remove(),this.tip=null)}static jQueryInterface(t){return this.each(function(){const n=_r.getOrCreateInstance(this,t);if(typeof t=="string"){if(typeof n[t]>"u")throw new TypeError(\`No method named "\${t}"\`);n[t]()}})}}nn(_r);const DE="popover",FE=".popover-header",zE=".popover-body",jE={..._r.Default,content:"",offset:[0,8],placement:"right",template:'<div class="popover" role="tooltip"><div class="popover-arrow"></div><h3 class="popover-header"></h3><div class="popover-body"></div></div>',trigger:"click"},HE={..._r.DefaultType,content:"(null|string|element|function)"};class xc extends _r{static get Default(){return jE}static get DefaultType(){return HE}static get NAME(){return DE}_isWithContent(){return this._getTitle()||this._getContent()}_getContentForTemplate(){return{[FE]:this._getTitle(),[zE]:this._getContent()}}_getContent(){return this._resolvePossibleFunction(this._config.content)}static jQueryInterface(t){return this.each(function(){const n=xc.getOrCreateInstance(this,t);if(typeof t=="string"){if(typeof n[t]>"u")throw new TypeError(\`No method named "\${t}"\`);n[t]()}})}}nn(xc);const VE="scrollspy",BE="bs.scrollspy",Tc=\`.\${BE}\`,WE=".data-api",UE=\`activate\${Tc}\`,uf=\`click\${Tc}\`,qE=\`load\${Tc}\${WE}\`,KE="dropdown-item",Hs="active",YE='[data-bs-spy="scroll"]',Oa="[href]",GE=".nav, .list-group",ff=".nav-link",QE=".nav-item",XE=".list-group-item",JE=\`\${ff}, \${QE} > \${ff}, \${XE}\`,ZE=".dropdown",ew=".dropdown-toggle",tw={offset:null,rootMargin:"0px 0px -25%",smoothScroll:!1,target:null,threshold:[.1,.5,1]},nw={offset:"(number|null)",rootMargin:"string",smoothScroll:"boolean",target:"element",threshold:"array"};class Uo extends hn{constructor(t,n){super(t,n),this._targetLinks=new Map,this._observableSections=new Map,this._rootElement=getComputedStyle(this._element).overflowY==="visible"?null:this._element,this._activeTarget=null,this._observer=null,this._previousScrollData={visibleEntryTop:0,parentScrollTop:0},this.refresh()}static get Default(){return tw}static get DefaultType(){return nw}static get NAME(){return VE}refresh(){this._initializeTargetsAndObservables(),this._maybeEnableSmoothScroll(),this._observer?this._observer.disconnect():this._observer=this._getNewObserver();for(const t of this._observableSections.values())this._observer.observe(t)}dispose(){this._observer.disconnect(),super.dispose()}_configAfterMerge(t){return t.target=os(t.target)||document.body,t.rootMargin=t.offset?\`\${t.offset}px 0px -30%\`:t.rootMargin,typeof t.threshold=="string"&&(t.threshold=t.threshold.split(",").map(n=>Number.parseFloat(n))),t}_maybeEnableSmoothScroll(){this._config.smoothScroll&&(D.off(this._config.target,uf),D.on(this._config.target,uf,Oa,t=>{const n=this._observableSections.get(t.target.hash);if(n){t.preventDefault();const s=this._rootElement||window,r=n.offsetTop-this._element.offsetTop;if(s.scrollTo){s.scrollTo({top:r,behavior:"smooth"});return}s.scrollTop=r}}))}_getNewObserver(){const t={root:this._rootElement,threshold:this._config.threshold,rootMargin:this._config.rootMargin};return new IntersectionObserver(n=>this._observerCallback(n),t)}_observerCallback(t){const n=o=>this._targetLinks.get(\`#\${o.target.id}\`),s=o=>{this._previousScrollData.visibleEntryTop=o.target.offsetTop,this._process(n(o))},r=(this._rootElement||document.documentElement).scrollTop,i=r>=this._previousScrollData.parentScrollTop;this._previousScrollData.parentScrollTop=r;for(const o of t){if(!o.isIntersecting){this._activeTarget=null,this._clearActiveClass(n(o));continue}const a=o.target.offsetTop>=this._previousScrollData.visibleEntryTop;if(i&&a){if(s(o),!r)return;continue}!i&&!a&&s(o)}}_initializeTargetsAndObservables(){this._targetLinks=new Map,this._observableSections=new Map;const t=ge.find(Oa,this._config.target);for(const n of t){if(!n.hash||as(n))continue;const s=ge.findOne(decodeURI(n.hash),this._element);br(s)&&(this._targetLinks.set(decodeURI(n.hash),n),this._observableSections.set(n.hash,s))}}_process(t){this._activeTarget!==t&&(this._clearActiveClass(this._config.target),this._activeTarget=t,t.classList.add(Hs),this._activateParents(t),D.trigger(this._element,UE,{relatedTarget:t}))}_activateParents(t){if(t.classList.contains(KE)){ge.findOne(ew,t.closest(ZE)).classList.add(Hs);return}for(const n of ge.parents(t,GE))for(const s of ge.prev(n,JE))s.classList.add(Hs)}_clearActiveClass(t){t.classList.remove(Hs);const n=ge.find(\`\${Oa}.\${Hs}\`,t);for(const s of n)s.classList.remove(Hs)}static jQueryInterface(t){return this.each(function(){const n=Uo.getOrCreateInstance(this,t);if(typeof t=="string"){if(n[t]===void 0||t.startsWith("_")||t==="constructor")throw new TypeError(\`No method named "\${t}"\`);n[t]()}})}}D.on(window,qE,()=>{for(const e of ge.find(YE))Uo.getOrCreateInstance(e)});nn(Uo);const sw="tab",rw="bs.tab",Ls=\`.\${rw}\`,iw=\`hide\${Ls}\`,ow=\`hidden\${Ls}\`,aw=\`show\${Ls}\`,lw=\`shown\${Ls}\`,cw=\`click\${Ls}\`,uw=\`keydown\${Ls}\`,fw=\`load\${Ls}\`,dw="ArrowLeft",df="ArrowRight",hw="ArrowUp",hf="ArrowDown",Ca="Home",pf="End",Ts="active",gf="fade",Ra="show",pw="dropdown",Ip=".dropdown-toggle",gw=".dropdown-menu",$a=\`:not(\${Ip})\`,mw='.list-group, .nav, [role="tablist"]',vw=".nav-item, .list-group-item",bw=\`.nav-link\${$a}, .list-group-item\${$a}, [role="tab"]\${$a}\`,Pp='[data-bs-toggle="tab"], [data-bs-toggle="pill"], [data-bs-toggle="list"]',Ma=\`\${bw}, \${Pp}\`,yw=\`.\${Ts}[data-bs-toggle="tab"], .\${Ts}[data-bs-toggle="pill"], .\${Ts}[data-bs-toggle="list"]\`;class dr extends hn{constructor(t){super(t),this._parent=this._element.closest(mw),this._parent&&(this._setInitialAttributes(this._parent,this._getChildren()),D.on(this._element,uw,n=>this._keydown(n)))}static get NAME(){return sw}show(){const t=this._element;if(this._elemIsActive(t))return;const n=this._getActiveElem(),s=n?D.trigger(n,iw,{relatedTarget:t}):null;D.trigger(t,aw,{relatedTarget:n}).defaultPrevented||s&&s.defaultPrevented||(this._deactivate(n,t),this._activate(t,n))}_activate(t,n){if(!t)return;t.classList.add(Ts),this._activate(ge.getElementFromSelector(t));const s=()=>{if(t.getAttribute("role")!=="tab"){t.classList.add(Ra);return}t.removeAttribute("tabindex"),t.setAttribute("aria-selected",!0),this._toggleDropDown(t,!0),D.trigger(t,lw,{relatedTarget:n})};this._queueCallback(s,t,t.classList.contains(gf))}_deactivate(t,n){if(!t)return;t.classList.remove(Ts),t.blur(),this._deactivate(ge.getElementFromSelector(t));const s=()=>{if(t.getAttribute("role")!=="tab"){t.classList.remove(Ra);return}t.setAttribute("aria-selected",!1),t.setAttribute("tabindex","-1"),this._toggleDropDown(t,!1),D.trigger(t,ow,{relatedTarget:n})};this._queueCallback(s,t,t.classList.contains(gf))}_keydown(t){if(![dw,df,hw,hf,Ca,pf].includes(t.key))return;t.stopPropagation(),t.preventDefault();const n=this._getChildren().filter(r=>!as(r));let s;if([Ca,pf].includes(t.key))s=n[t.key===Ca?0:n.length-1];else{const r=[df,hf].includes(t.key);s=Ec(n,t.target,r,!0)}s&&(s.focus({preventScroll:!0}),dr.getOrCreateInstance(s).show())}_getChildren(){return ge.find(Ma,this._parent)}_getActiveElem(){return this._getChildren().find(t=>this._elemIsActive(t))||null}_setInitialAttributes(t,n){this._setAttributeIfNotExists(t,"role","tablist");for(const s of n)this._setInitialAttributesOnChild(s)}_setInitialAttributesOnChild(t){t=this._getInnerElement(t);const n=this._elemIsActive(t),s=this._getOuterElement(t);t.setAttribute("aria-selected",n),s!==t&&this._setAttributeIfNotExists(s,"role","presentation"),n||t.setAttribute("tabindex","-1"),this._setAttributeIfNotExists(t,"role","tab"),this._setInitialAttributesOnTargetPanel(t)}_setInitialAttributesOnTargetPanel(t){const n=ge.getElementFromSelector(t);n&&(this._setAttributeIfNotExists(n,"role","tabpanel"),t.id&&this._setAttributeIfNotExists(n,"aria-labelledby",\`\${t.id}\`))}_toggleDropDown(t,n){const s=this._getOuterElement(t);if(!s.classList.contains(pw))return;const r=(i,o)=>{const a=ge.findOne(i,s);a&&a.classList.toggle(o,n)};r(Ip,Ts),r(gw,Ra),s.setAttribute("aria-expanded",n)}_setAttributeIfNotExists(t,n,s){t.hasAttribute(n)||t.setAttribute(n,s)}_elemIsActive(t){return t.classList.contains(Ts)}_getInnerElement(t){return t.matches(Ma)?t:ge.findOne(Ma,t)}_getOuterElement(t){return t.closest(vw)||t}static jQueryInterface(t){return this.each(function(){const n=dr.getOrCreateInstance(this);if(typeof t=="string"){if(n[t]===void 0||t.startsWith("_")||t==="constructor")throw new TypeError(\`No method named "\${t}"\`);n[t]()}})}}D.on(document,cw,Pp,function(e){["A","AREA"].includes(this.tagName)&&e.preventDefault(),!as(this)&&dr.getOrCreateInstance(this).show()});D.on(window,fw,()=>{for(const e of ge.find(yw))dr.getOrCreateInstance(e)});nn(dr);const _w="toast",Ew="bs.toast",ms=\`.\${Ew}\`,ww=\`mouseover\${ms}\`,Sw=\`mouseout\${ms}\`,xw=\`focusin\${ms}\`,Tw=\`focusout\${ms}\`,Aw=\`hide\${ms}\`,Ow=\`hidden\${ms}\`,Cw=\`show\${ms}\`,Rw=\`shown\${ms}\`,$w="fade",mf="hide",Ii="show",Pi="showing",Mw={animation:"boolean",autohide:"boolean",delay:"number"},Nw={animation:!0,autohide:!0,delay:5e3};class di extends hn{constructor(t,n){super(t,n),this._timeout=null,this._hasMouseInteraction=!1,this._hasKeyboardInteraction=!1,this._setListeners()}static get Default(){return Nw}static get DefaultType(){return Mw}static get NAME(){return _w}show(){if(D.trigger(this._element,Cw).defaultPrevented)return;this._clearTimeout(),this._config.animation&&this._element.classList.add($w);const n=()=>{this._element.classList.remove(Pi),D.trigger(this._element,Rw),this._maybeScheduleHide()};this._element.classList.remove(mf),li(this._element),this._element.classList.add(Ii,Pi),this._queueCallback(n,this._element,this._config.animation)}hide(){if(!this.isShown()||D.trigger(this._element,Aw).defaultPrevented)return;const n=()=>{this._element.classList.add(mf),this._element.classList.remove(Pi,Ii),D.trigger(this._element,Ow)};this._element.classList.add(Pi),this._queueCallback(n,this._element,this._config.animation)}dispose(){this._clearTimeout(),this.isShown()&&this._element.classList.remove(Ii),super.dispose()}isShown(){return this._element.classList.contains(Ii)}_maybeScheduleHide(){this._config.autohide&&(this._hasMouseInteraction||this._hasKeyboardInteraction||(this._timeout=setTimeout(()=>{this.hide()},this._config.delay)))}_onInteraction(t,n){switch(t.type){case"mouseover":case"mouseout":{this._hasMouseInteraction=n;break}case"focusin":case"focusout":{this._hasKeyboardInteraction=n;break}}if(n){this._clearTimeout();return}const s=t.relatedTarget;this._element===s||this._element.contains(s)||this._maybeScheduleHide()}_setListeners(){D.on(this._element,ww,t=>this._onInteraction(t,!0)),D.on(this._element,Sw,t=>this._onInteraction(t,!1)),D.on(this._element,xw,t=>this._onInteraction(t,!0)),D.on(this._element,Tw,t=>this._onInteraction(t,!1))}_clearTimeout(){clearTimeout(this._timeout),this._timeout=null}static jQueryInterface(t){return this.each(function(){const n=di.getOrCreateInstance(this,t);if(typeof t=="string"){if(typeof n[t]>"u")throw new TypeError(\`No method named "\${t}"\`);n[t](this)}})}}Vo(di);nn(di);/*!
  * vue-router v4.5.1
  * (c) 2025 Eduardo San Martin Morote
  * @license MIT
  */const Ks=typeof document<"u";function Lp(e){return typeof e=="object"||"displayName"in e||"props"in e||"__vccOpts"in e}function kw(e){return e.__esModule||e[Symbol.toStringTag]==="Module"||e.default&&Lp(e.default)}const Pe=Object.assign;function Na(e,t){const n={};for(const s in t){const r=t[s];n[s]=fn(r)?r.map(e):e(r)}return n}const Hr=()=>{},fn=Array.isArray,Dp=/#/g,Iw=/&/g,Pw=/\\//g,Lw=/=/g,Dw=/\\?/g,Fp=/\\+/g,Fw=/%5B/g,zw=/%5D/g,zp=/%5E/g,jw=/%60/g,jp=/%7B/g,Hw=/%7C/g,Hp=/%7D/g,Vw=/%20/g;function Ac(e){return encodeURI(""+e).replace(Hw,"|").replace(Fw,"[").replace(zw,"]")}function Bw(e){return Ac(e).replace(jp,"{").replace(Hp,"}").replace(zp,"^")}function gl(e){return Ac(e).replace(Fp,"%2B").replace(Vw,"+").replace(Dp,"%23").replace(Iw,"%26").replace(jw,"\`").replace(jp,"{").replace(Hp,"}").replace(zp,"^")}function Ww(e){return gl(e).replace(Lw,"%3D")}function Uw(e){return Ac(e).replace(Dp,"%23").replace(Dw,"%3F")}function qw(e){return e==null?"":Uw(e).replace(Pw,"%2F")}function Zr(e){try{return decodeURIComponent(""+e)}catch{}return""+e}const Kw=/\\/$/,Yw=e=>e.replace(Kw,"");function ka(e,t,n="/"){let s,r={},i="",o="";const a=t.indexOf("#");let l=t.indexOf("?");return a<l&&a>=0&&(l=-1),l>-1&&(s=t.slice(0,l),i=t.slice(l+1,a>-1?a:t.length),r=e(i)),a>-1&&(s=s||t.slice(0,a),o=t.slice(a,t.length)),s=Jw(s??t,n),{fullPath:s+(i&&"?")+i+o,path:s,query:r,hash:Zr(o)}}function Gw(e,t){const n=t.query?e(t.query):"";return t.path+(n&&"?")+n+(t.hash||"")}function vf(e,t){return!t||!e.toLowerCase().startsWith(t.toLowerCase())?e:e.slice(t.length)||"/"}function Qw(e,t,n){const s=t.matched.length-1,r=n.matched.length-1;return s>-1&&s===r&&hr(t.matched[s],n.matched[r])&&Vp(t.params,n.params)&&e(t.query)===e(n.query)&&t.hash===n.hash}function hr(e,t){return(e.aliasOf||e)===(t.aliasOf||t)}function Vp(e,t){if(Object.keys(e).length!==Object.keys(t).length)return!1;for(const n in e)if(!Xw(e[n],t[n]))return!1;return!0}function Xw(e,t){return fn(e)?bf(e,t):fn(t)?bf(t,e):e===t}function bf(e,t){return fn(t)?e.length===t.length&&e.every((n,s)=>n===t[s]):e.length===1&&e[0]===t}function Jw(e,t){if(e.startsWith("/"))return e;if(!e)return t;const n=t.split("/"),s=e.split("/"),r=s[s.length-1];(r===".."||r===".")&&s.push("");let i=n.length-1,o,a;for(o=0;o<s.length;o++)if(a=s[o],a!==".")if(a==="..")i>1&&i--;else break;return n.slice(0,i).join("/")+"/"+s.slice(o).join("/")}const Qn={path:"/",name:void 0,params:{},query:{},hash:"",fullPath:"/",matched:[],meta:{},redirectedFrom:void 0};var ei;(function(e){e.pop="pop",e.push="push"})(ei||(ei={}));var Vr;(function(e){e.back="back",e.forward="forward",e.unknown=""})(Vr||(Vr={}));function Zw(e){if(!e)if(Ks){const t=document.querySelector("base");e=t&&t.getAttribute("href")||"/",e=e.replace(/^\\w+:\\/\\/[^\\/]+/,"")}else e="/";return e[0]!=="/"&&e[0]!=="#"&&(e="/"+e),Yw(e)}const eS=/^[^#]+#/;function tS(e,t){return e.replace(eS,"#")+t}function nS(e,t){const n=document.documentElement.getBoundingClientRect(),s=e.getBoundingClientRect();return{behavior:t.behavior,left:s.left-n.left-(t.left||0),top:s.top-n.top-(t.top||0)}}const qo=()=>({left:window.scrollX,top:window.scrollY});function sS(e){let t;if("el"in e){const n=e.el,s=typeof n=="string"&&n.startsWith("#"),r=typeof n=="string"?s?document.getElementById(n.slice(1)):document.querySelector(n):n;if(!r)return;t=nS(r,e)}else t=e;"scrollBehavior"in document.documentElement.style?window.scrollTo(t):window.scrollTo(t.left!=null?t.left:window.scrollX,t.top!=null?t.top:window.scrollY)}function yf(e,t){return(history.state?history.state.position-t:-1)+e}const ml=new Map;function rS(e,t){ml.set(e,t)}function iS(e){const t=ml.get(e);return ml.delete(e),t}let oS=()=>location.protocol+"//"+location.host;function Bp(e,t){const{pathname:n,search:s,hash:r}=t,i=e.indexOf("#");if(i>-1){let a=r.includes(e.slice(i))?e.slice(i).length:1,l=r.slice(a);return l[0]!=="/"&&(l="/"+l),vf(l,"")}return vf(n,e)+s+r}function aS(e,t,n,s){let r=[],i=[],o=null;const a=({state:d})=>{const h=Bp(e,location),p=n.value,g=t.value;let _=0;if(d){if(n.value=h,t.value=d,o&&o===p){o=null;return}_=g?d.position-g.position:0}else s(h);r.forEach(b=>{b(n.value,p,{delta:_,type:ei.pop,direction:_?_>0?Vr.forward:Vr.back:Vr.unknown})})};function l(){o=n.value}function u(d){r.push(d);const h=()=>{const p=r.indexOf(d);p>-1&&r.splice(p,1)};return i.push(h),h}function c(){const{history:d}=window;d.state&&d.replaceState(Pe({},d.state,{scroll:qo()}),"")}function f(){for(const d of i)d();i=[],window.removeEventListener("popstate",a),window.removeEventListener("beforeunload",c)}return window.addEventListener("popstate",a),window.addEventListener("beforeunload",c,{passive:!0}),{pauseListeners:l,listen:u,destroy:f}}function _f(e,t,n,s=!1,r=!1){return{back:e,current:t,forward:n,replaced:s,position:window.history.length,scroll:r?qo():null}}function lS(e){const{history:t,location:n}=window,s={value:Bp(e,n)},r={value:t.state};r.value||i(s.value,{back:null,current:s.value,forward:null,position:t.length-1,replaced:!0,scroll:null},!0);function i(l,u,c){const f=e.indexOf("#"),d=f>-1?(n.host&&document.querySelector("base")?e:e.slice(f))+l:oS()+e+l;try{t[c?"replaceState":"pushState"](u,"",d),r.value=u}catch(h){console.error(h),n[c?"replace":"assign"](d)}}function o(l,u){const c=Pe({},t.state,_f(r.value.back,l,r.value.forward,!0),u,{position:r.value.position});i(l,c,!0),s.value=l}function a(l,u){const c=Pe({},r.value,t.state,{forward:l,scroll:qo()});i(c.current,c,!0);const f=Pe({},_f(s.value,l,null),{position:c.position+1},u);i(l,f,!1),s.value=l}return{location:s,state:r,push:a,replace:o}}function cS(e){e=Zw(e);const t=lS(e),n=aS(e,t.state,t.location,t.replace);function s(i,o=!0){o||n.pauseListeners(),history.go(i)}const r=Pe({location:"",base:e,go:s,createHref:tS.bind(null,e)},t,n);return Object.defineProperty(r,"location",{enumerable:!0,get:()=>t.location.value}),Object.defineProperty(r,"state",{enumerable:!0,get:()=>t.state.value}),r}function uS(e){return typeof e=="string"||e&&typeof e=="object"}function Wp(e){return typeof e=="string"||typeof e=="symbol"}const Up=Symbol("");var Ef;(function(e){e[e.aborted=4]="aborted",e[e.cancelled=8]="cancelled",e[e.duplicated=16]="duplicated"})(Ef||(Ef={}));function pr(e,t){return Pe(new Error,{type:e,[Up]:!0},t)}function On(e,t){return e instanceof Error&&Up in e&&(t==null||!!(e.type&t))}const wf="[^/]+?",fS={sensitive:!1,strict:!1,start:!0,end:!0},dS=/[.+*?^\${}()[\\]/\\\\]/g;function hS(e,t){const n=Pe({},fS,t),s=[];let r=n.start?"^":"";const i=[];for(const u of e){const c=u.length?[]:[90];n.strict&&!u.length&&(r+="/");for(let f=0;f<u.length;f++){const d=u[f];let h=40+(n.sensitive?.25:0);if(d.type===0)f||(r+="/"),r+=d.value.replace(dS,"\\\\$&"),h+=40;else if(d.type===1){const{value:p,repeatable:g,optional:_,regexp:b}=d;i.push({name:p,repeatable:g,optional:_});const y=b||wf;if(y!==wf){h+=10;try{new RegExp(\`(\${y})\`)}catch(x){throw new Error(\`Invalid custom RegExp for param "\${p}" (\${y}): \`+x.message)}}let T=g?\`((?:\${y})(?:/(?:\${y}))*)\`:\`(\${y})\`;f||(T=_&&u.length<2?\`(?:/\${T})\`:"/"+T),_&&(T+="?"),r+=T,h+=20,_&&(h+=-8),g&&(h+=-20),y===".*"&&(h+=-50)}c.push(h)}s.push(c)}if(n.strict&&n.end){const u=s.length-1;s[u][s[u].length-1]+=.7000000000000001}n.strict||(r+="/?"),n.end?r+="$":n.strict&&!r.endsWith("/")&&(r+="(?:/|$)");const o=new RegExp(r,n.sensitive?"":"i");function a(u){const c=u.match(o),f={};if(!c)return null;for(let d=1;d<c.length;d++){const h=c[d]||"",p=i[d-1];f[p.name]=h&&p.repeatable?h.split("/"):h}return f}function l(u){let c="",f=!1;for(const d of e){(!f||!c.endsWith("/"))&&(c+="/"),f=!1;for(const h of d)if(h.type===0)c+=h.value;else if(h.type===1){const{value:p,repeatable:g,optional:_}=h,b=p in u?u[p]:"";if(fn(b)&&!g)throw new Error(\`Provided param "\${p}" is an array but it is not repeatable (* or + modifiers)\`);const y=fn(b)?b.join("/"):b;if(!y)if(_)d.length<2&&(c.endsWith("/")?c=c.slice(0,-1):f=!0);else throw new Error(\`Missing required param "\${p}"\`);c+=y}}return c||"/"}return{re:o,score:s,keys:i,parse:a,stringify:l}}function pS(e,t){let n=0;for(;n<e.length&&n<t.length;){const s=t[n]-e[n];if(s)return s;n++}return e.length<t.length?e.length===1&&e[0]===80?-1:1:e.length>t.length?t.length===1&&t[0]===80?1:-1:0}function qp(e,t){let n=0;const s=e.score,r=t.score;for(;n<s.length&&n<r.length;){const i=pS(s[n],r[n]);if(i)return i;n++}if(Math.abs(r.length-s.length)===1){if(Sf(s))return 1;if(Sf(r))return-1}return r.length-s.length}function Sf(e){const t=e[e.length-1];return e.length>0&&t[t.length-1]<0}const gS={type:0,value:""},mS=/[a-zA-Z0-9_]/;function vS(e){if(!e)return[[]];if(e==="/")return[[gS]];if(!e.startsWith("/"))throw new Error(\`Invalid path "\${e}"\`);function t(h){throw new Error(\`ERR (\${n})/"\${u}": \${h}\`)}let n=0,s=n;const r=[];let i;function o(){i&&r.push(i),i=[]}let a=0,l,u="",c="";function f(){u&&(n===0?i.push({type:0,value:u}):n===1||n===2||n===3?(i.length>1&&(l==="*"||l==="+")&&t(\`A repeatable param (\${u}) must be alone in its segment. eg: '/:ids+.\`),i.push({type:1,value:u,regexp:c,repeatable:l==="*"||l==="+",optional:l==="*"||l==="?"})):t("Invalid state to consume buffer"),u="")}function d(){u+=l}for(;a<e.length;){if(l=e[a++],l==="\\\\"&&n!==2){s=n,n=4;continue}switch(n){case 0:l==="/"?(u&&f(),o()):l===":"?(f(),n=1):d();break;case 4:d(),n=s;break;case 1:l==="("?n=2:mS.test(l)?d():(f(),n=0,l!=="*"&&l!=="?"&&l!=="+"&&a--);break;case 2:l===")"?c[c.length-1]=="\\\\"?c=c.slice(0,-1)+l:n=3:c+=l;break;case 3:f(),n=0,l!=="*"&&l!=="?"&&l!=="+"&&a--,c="";break;default:t("Unknown state");break}}return n===2&&t(\`Unfinished custom RegExp for param "\${u}"\`),f(),o(),r}function bS(e,t,n){const s=hS(vS(e.path),n),r=Pe(s,{record:e,parent:t,children:[],alias:[]});return t&&!r.record.aliasOf==!t.record.aliasOf&&t.children.push(r),r}function yS(e,t){const n=[],s=new Map;t=Of({strict:!1,end:!0,sensitive:!1},t);function r(f){return s.get(f)}function i(f,d,h){const p=!h,g=Tf(f);g.aliasOf=h&&h.record;const _=Of(t,f),b=[g];if("alias"in f){const x=typeof f.alias=="string"?[f.alias]:f.alias;for(const O of x)b.push(Tf(Pe({},g,{components:h?h.record.components:g.components,path:O,aliasOf:h?h.record:g})))}let y,T;for(const x of b){const{path:O}=x;if(d&&O[0]!=="/"){const $=d.record.path,F=$[$.length-1]==="/"?"":"/";x.path=d.record.path+(O&&F+O)}if(y=bS(x,d,_),h?h.alias.push(y):(T=T||y,T!==y&&T.alias.push(y),p&&f.name&&!Af(y)&&o(f.name)),Kp(y)&&l(y),g.children){const $=g.children;for(let F=0;F<$.length;F++)i($[F],y,h&&h.children[F])}h=h||y}return T?()=>{o(T)}:Hr}function o(f){if(Wp(f)){const d=s.get(f);d&&(s.delete(f),n.splice(n.indexOf(d),1),d.children.forEach(o),d.alias.forEach(o))}else{const d=n.indexOf(f);d>-1&&(n.splice(d,1),f.record.name&&s.delete(f.record.name),f.children.forEach(o),f.alias.forEach(o))}}function a(){return n}function l(f){const d=wS(f,n);n.splice(d,0,f),f.record.name&&!Af(f)&&s.set(f.record.name,f)}function u(f,d){let h,p={},g,_;if("name"in f&&f.name){if(h=s.get(f.name),!h)throw pr(1,{location:f});_=h.record.name,p=Pe(xf(d.params,h.keys.filter(T=>!T.optional).concat(h.parent?h.parent.keys.filter(T=>T.optional):[]).map(T=>T.name)),f.params&&xf(f.params,h.keys.map(T=>T.name))),g=h.stringify(p)}else if(f.path!=null)g=f.path,h=n.find(T=>T.re.test(g)),h&&(p=h.parse(g),_=h.record.name);else{if(h=d.name?s.get(d.name):n.find(T=>T.re.test(d.path)),!h)throw pr(1,{location:f,currentLocation:d});_=h.record.name,p=Pe({},d.params,f.params),g=h.stringify(p)}const b=[];let y=h;for(;y;)b.unshift(y.record),y=y.parent;return{name:_,path:g,params:p,matched:b,meta:ES(b)}}e.forEach(f=>i(f));function c(){n.length=0,s.clear()}return{addRoute:i,resolve:u,removeRoute:o,clearRoutes:c,getRoutes:a,getRecordMatcher:r}}function xf(e,t){const n={};for(const s of t)s in e&&(n[s]=e[s]);return n}function Tf(e){const t={path:e.path,redirect:e.redirect,name:e.name,meta:e.meta||{},aliasOf:e.aliasOf,beforeEnter:e.beforeEnter,props:_S(e),children:e.children||[],instances:{},leaveGuards:new Set,updateGuards:new Set,enterCallbacks:{},components:"components"in e?e.components||null:e.component&&{default:e.component}};return Object.defineProperty(t,"mods",{value:{}}),t}function _S(e){const t={},n=e.props||!1;if("component"in e)t.default=n;else for(const s in e.components)t[s]=typeof n=="object"?n[s]:n;return t}function Af(e){for(;e;){if(e.record.aliasOf)return!0;e=e.parent}return!1}function ES(e){return e.reduce((t,n)=>Pe(t,n.meta),{})}function Of(e,t){const n={};for(const s in e)n[s]=s in t?t[s]:e[s];return n}function wS(e,t){let n=0,s=t.length;for(;n!==s;){const i=n+s>>1;qp(e,t[i])<0?s=i:n=i+1}const r=SS(e);return r&&(s=t.lastIndexOf(r,s-1)),s}function SS(e){let t=e;for(;t=t.parent;)if(Kp(t)&&qp(e,t)===0)return t}function Kp({record:e}){return!!(e.name||e.components&&Object.keys(e.components).length||e.redirect)}function xS(e){const t={};if(e===""||e==="?")return t;const s=(e[0]==="?"?e.slice(1):e).split("&");for(let r=0;r<s.length;++r){const i=s[r].replace(Fp," "),o=i.indexOf("="),a=Zr(o<0?i:i.slice(0,o)),l=o<0?null:Zr(i.slice(o+1));if(a in t){let u=t[a];fn(u)||(u=t[a]=[u]),u.push(l)}else t[a]=l}return t}function Cf(e){let t="";for(let n in e){const s=e[n];if(n=Ww(n),s==null){s!==void 0&&(t+=(t.length?"&":"")+n);continue}(fn(s)?s.map(i=>i&&gl(i)):[s&&gl(s)]).forEach(i=>{i!==void 0&&(t+=(t.length?"&":"")+n,i!=null&&(t+="="+i))})}return t}function TS(e){const t={};for(const n in e){const s=e[n];s!==void 0&&(t[n]=fn(s)?s.map(r=>r==null?null:""+r):s==null?s:""+s)}return t}const AS=Symbol(""),Rf=Symbol(""),Ko=Symbol(""),Oc=Symbol(""),vl=Symbol("");function $r(){let e=[];function t(s){return e.push(s),()=>{const r=e.indexOf(s);r>-1&&e.splice(r,1)}}function n(){e=[]}return{add:t,list:()=>e.slice(),reset:n}}function es(e,t,n,s,r,i=o=>o()){const o=s&&(s.enterCallbacks[r]=s.enterCallbacks[r]||[]);return()=>new Promise((a,l)=>{const u=d=>{d===!1?l(pr(4,{from:n,to:t})):d instanceof Error?l(d):uS(d)?l(pr(2,{from:t,to:d})):(o&&s.enterCallbacks[r]===o&&typeof d=="function"&&o.push(d),a())},c=i(()=>e.call(s&&s.instances[r],t,n,u));let f=Promise.resolve(c);e.length<3&&(f=f.then(u)),f.catch(d=>l(d))})}function Ia(e,t,n,s,r=i=>i()){const i=[];for(const o of e)for(const a in o.components){let l=o.components[a];if(!(t!=="beforeRouteEnter"&&!o.instances[a]))if(Lp(l)){const c=(l.__vccOpts||l)[t];c&&i.push(es(c,n,s,o,a,r))}else{let u=l();i.push(()=>u.then(c=>{if(!c)throw new Error(\`Couldn't resolve component "\${a}" at "\${o.path}"\`);const f=kw(c)?c.default:c;o.mods[a]=c,o.components[a]=f;const h=(f.__vccOpts||f)[t];return h&&es(h,n,s,o,a,r)()}))}}return i}function $f(e){const t=Ne(Ko),n=Ne(Oc),s=xe(()=>{const l=A(e.to);return t.resolve(l)}),r=xe(()=>{const{matched:l}=s.value,{length:u}=l,c=l[u-1],f=n.matched;if(!c||!f.length)return-1;const d=f.findIndex(hr.bind(null,c));if(d>-1)return d;const h=Mf(l[u-2]);return u>1&&Mf(c)===h&&f[f.length-1].path!==h?f.findIndex(hr.bind(null,l[u-2])):d}),i=xe(()=>r.value>-1&&MS(n.params,s.value.params)),o=xe(()=>r.value>-1&&r.value===n.matched.length-1&&Vp(n.params,s.value.params));function a(l={}){if($S(l)){const u=t[A(e.replace)?"replace":"push"](A(e.to)).catch(Hr);return e.viewTransition&&typeof document<"u"&&"startViewTransition"in document&&document.startViewTransition(()=>u),u}return Promise.resolve()}return{route:s,href:xe(()=>s.value.href),isActive:i,isExactActive:o,navigate:a}}function OS(e){return e.length===1?e[0]:e}const CS=at({name:"RouterLink",compatConfig:{MODE:3},props:{to:{type:[String,Object],required:!0},replace:Boolean,activeClass:String,exactActiveClass:String,custom:Boolean,ariaCurrentValue:{type:String,default:"page"},viewTransition:Boolean},useLink:$f,setup(e,{slots:t}){const n=Co($f(e)),{options:s}=Ne(Ko),r=xe(()=>({[Nf(e.activeClass,s.linkActiveClass,"router-link-active")]:n.isActive,[Nf(e.exactActiveClass,s.linkExactActiveClass,"router-link-exact-active")]:n.isExactActive}));return()=>{const i=t.default&&OS(t.default(n));return e.custom?i:Fo("a",{"aria-current":n.isExactActive?e.ariaCurrentValue:null,href:n.href,onClick:n.navigate,class:r.value},i)}}}),RS=CS;function $S(e){if(!(e.metaKey||e.altKey||e.ctrlKey||e.shiftKey)&&!e.defaultPrevented&&!(e.button!==void 0&&e.button!==0)){if(e.currentTarget&&e.currentTarget.getAttribute){const t=e.currentTarget.getAttribute("target");if(/\\b_blank\\b/i.test(t))return}return e.preventDefault&&e.preventDefault(),!0}}function MS(e,t){for(const n in t){const s=t[n],r=e[n];if(typeof s=="string"){if(s!==r)return!1}else if(!fn(r)||r.length!==s.length||s.some((i,o)=>i!==r[o]))return!1}return!0}function Mf(e){return e?e.aliasOf?e.aliasOf.path:e.path:""}const Nf=(e,t,n)=>e??t??n,NS=at({name:"RouterView",inheritAttrs:!1,props:{name:{type:String,default:"default"},route:Object},compatConfig:{MODE:3},setup(e,{attrs:t,slots:n}){const s=Ne(vl),r=xe(()=>e.route||s.value),i=Ne(Rf,0),o=xe(()=>{let u=A(i);const{matched:c}=r.value;let f;for(;(f=c[u])&&!f.components;)u++;return u}),a=xe(()=>r.value.matched[o.value]);It(Rf,xe(()=>o.value+1)),It(AS,a),It(vl,r);const l=re();return Je(()=>[l.value,a.value,e.name],([u,c,f],[d,h,p])=>{c&&(c.instances[f]=u,h&&h!==c&&u&&u===d&&(c.leaveGuards.size||(c.leaveGuards=h.leaveGuards),c.updateGuards.size||(c.updateGuards=h.updateGuards))),u&&c&&(!h||!hr(c,h)||!d)&&(c.enterCallbacks[f]||[]).forEach(g=>g(u))},{flush:"post"}),()=>{const u=r.value,c=e.name,f=a.value,d=f&&f.components[c];if(!d)return kf(n.default,{Component:d,route:u});const h=f.props[c],p=h?h===!0?u.params:typeof h=="function"?h(u):h:null,_=Fo(d,Pe({},p,t,{onVnodeUnmounted:b=>{b.component.isUnmounted&&(f.instances[c]=null)},ref:l}));return kf(n.default,{Component:_,route:u})||_}}});function kf(e,t){if(!e)return null;const n=e(t);return n.length===1?n[0]:n}const kS=NS;function IS(e){const t=yS(e.routes,e),n=e.parseQuery||xS,s=e.stringifyQuery||Cf,r=e.history,i=$r(),o=$r(),a=$r(),l=Nt(Qn);let u=Qn;Ks&&e.scrollBehavior&&"scrollRestoration"in history&&(history.scrollRestoration="manual");const c=Na.bind(null,R=>""+R),f=Na.bind(null,qw),d=Na.bind(null,Zr);function h(R,G){let Y,se;return Wp(R)?(Y=t.getRecordMatcher(R),se=G):se=R,t.addRoute(se,Y)}function p(R){const G=t.getRecordMatcher(R);G&&t.removeRoute(G)}function g(){return t.getRoutes().map(R=>R.record)}function _(R){return!!t.getRecordMatcher(R)}function b(R,G){if(G=Pe({},G||l.value),typeof R=="string"){const S=ka(n,R,G.path),N=t.resolve({path:S.path},G),I=r.createHref(S.fullPath);return Pe(S,N,{params:d(N.params),hash:Zr(S.hash),redirectedFrom:void 0,href:I})}let Y;if(R.path!=null)Y=Pe({},R,{path:ka(n,R.path,G.path).path});else{const S=Pe({},R.params);for(const N in S)S[N]==null&&delete S[N];Y=Pe({},R,{params:f(S)}),G.params=f(G.params)}const se=t.resolve(Y,G),Oe=R.hash||"";se.params=c(d(se.params));const m=Gw(s,Pe({},R,{hash:Bw(Oe),path:se.path})),v=r.createHref(m);return Pe({fullPath:m,hash:Oe,query:s===Cf?TS(R.query):R.query||{}},se,{redirectedFrom:void 0,href:v})}function y(R){return typeof R=="string"?ka(n,R,l.value.path):Pe({},R)}function T(R,G){if(u!==R)return pr(8,{from:G,to:R})}function x(R){return F(R)}function O(R){return x(Pe(y(R),{replace:!0}))}function $(R){const G=R.matched[R.matched.length-1];if(G&&G.redirect){const{redirect:Y}=G;let se=typeof Y=="function"?Y(R):Y;return typeof se=="string"&&(se=se.includes("?")||se.includes("#")?se=y(se):{path:se},se.params={}),Pe({query:R.query,hash:R.hash,params:se.path!=null?{}:R.params},se)}}function F(R,G){const Y=u=b(R),se=l.value,Oe=R.state,m=R.force,v=R.replace===!0,S=$(Y);if(S)return F(Pe(y(S),{state:typeof S=="object"?Pe({},Oe,S.state):Oe,force:m,replace:v}),G||Y);const N=Y;N.redirectedFrom=G;let I;return!m&&Qw(s,se,Y)&&(I=pr(16,{to:N,from:se}),rt(se,se,!0,!1)),(I?Promise.resolve(I):C(N,se)).catch(M=>On(M)?On(M,2)?M:Ke(M):Z(M,N,se)).then(M=>{if(M){if(On(M,2))return F(Pe({replace:v},y(M.to),{state:typeof M.to=="object"?Pe({},Oe,M.to.state):Oe,force:m}),G||N)}else M=ne(N,se,!0,v,Oe);return q(N,se,M),M})}function Q(R,G){const Y=T(R,G);return Y?Promise.reject(Y):Promise.resolve()}function P(R){const G=ct.values().next().value;return G&&typeof G.runWithContext=="function"?G.runWithContext(R):R()}function C(R,G){let Y;const[se,Oe,m]=PS(R,G);Y=Ia(se.reverse(),"beforeRouteLeave",R,G);for(const S of se)S.leaveGuards.forEach(N=>{Y.push(es(N,R,G))});const v=Q.bind(null,R,G);return Y.push(v),Qe(Y).then(()=>{Y=[];for(const S of i.list())Y.push(es(S,R,G));return Y.push(v),Qe(Y)}).then(()=>{Y=Ia(Oe,"beforeRouteUpdate",R,G);for(const S of Oe)S.updateGuards.forEach(N=>{Y.push(es(N,R,G))});return Y.push(v),Qe(Y)}).then(()=>{Y=[];for(const S of m)if(S.beforeEnter)if(fn(S.beforeEnter))for(const N of S.beforeEnter)Y.push(es(N,R,G));else Y.push(es(S.beforeEnter,R,G));return Y.push(v),Qe(Y)}).then(()=>(R.matched.forEach(S=>S.enterCallbacks={}),Y=Ia(m,"beforeRouteEnter",R,G,P),Y.push(v),Qe(Y))).then(()=>{Y=[];for(const S of o.list())Y.push(es(S,R,G));return Y.push(v),Qe(Y)}).catch(S=>On(S,8)?S:Promise.reject(S))}function q(R,G,Y){a.list().forEach(se=>P(()=>se(R,G,Y)))}function ne(R,G,Y,se,Oe){const m=T(R,G);if(m)return m;const v=G===Qn,S=Ks?history.state:{};Y&&(se||v?r.replace(R.fullPath,Pe({scroll:v&&S&&S.scroll},Oe)):r.push(R.fullPath,Oe)),l.value=R,rt(R,G,Y,v),Ke()}let W;function L(){W||(W=r.listen((R,G,Y)=>{if(!tt.listening)return;const se=b(R),Oe=$(se);if(Oe){F(Pe(Oe,{replace:!0,force:!0}),se).catch(Hr);return}u=se;const m=l.value;Ks&&rS(yf(m.fullPath,Y.delta),qo()),C(se,m).catch(v=>On(v,12)?v:On(v,2)?(F(Pe(y(v.to),{force:!0}),se).then(S=>{On(S,20)&&!Y.delta&&Y.type===ei.pop&&r.go(-1,!1)}).catch(Hr),Promise.reject()):(Y.delta&&r.go(-Y.delta,!1),Z(v,se,m))).then(v=>{v=v||ne(se,m,!1),v&&(Y.delta&&!On(v,8)?r.go(-Y.delta,!1):Y.type===ei.pop&&On(v,20)&&r.go(-1,!1)),q(se,m,v)}).catch(Hr)}))}let le=$r(),B=$r(),ue;function Z(R,G,Y){Ke(R);const se=B.list();return se.length?se.forEach(Oe=>Oe(R,G,Y)):console.error(R),Promise.reject(R)}function we(){return ue&&l.value!==Qn?Promise.resolve():new Promise((R,G)=>{le.add([R,G])})}function Ke(R){return ue||(ue=!R,L(),le.list().forEach(([G,Y])=>R?Y(R):G()),le.reset()),R}function rt(R,G,Y,se){const{scrollBehavior:Oe}=e;if(!Ks||!Oe)return Promise.resolve();const m=!Y&&iS(yf(R.fullPath,0))||(se||!Y)&&history.state&&history.state.scroll||null;return un().then(()=>Oe(R,G,m)).then(v=>v&&sS(v)).catch(v=>Z(v,R,G))}const Ve=R=>r.go(R);let it;const ct=new Set,tt={currentRoute:l,listening:!0,addRoute:h,removeRoute:p,clearRoutes:t.clearRoutes,hasRoute:_,getRoutes:g,resolve:b,options:e,push:x,replace:O,go:Ve,back:()=>Ve(-1),forward:()=>Ve(1),beforeEach:i.add,beforeResolve:o.add,afterEach:a.add,onError:B.add,isReady:we,install(R){const G=this;R.component("RouterLink",RS),R.component("RouterView",kS),R.config.globalProperties.$router=G,Object.defineProperty(R.config.globalProperties,"$route",{enumerable:!0,get:()=>A(l)}),Ks&&!it&&l.value===Qn&&(it=!0,x(r.location).catch(Oe=>{}));const Y={};for(const Oe in Qn)Object.defineProperty(Y,Oe,{get:()=>l.value[Oe],enumerable:!0});R.provide(Ko,G),R.provide(Oc,Kl(Y)),R.provide(vl,l);const se=R.unmount;ct.add(R),R.unmount=function(){ct.delete(R),ct.size<1&&(u=Qn,W&&W(),W=null,l.value=Qn,it=!1,ue=!1),se()}}};function Qe(R){return R.reduce((G,Y)=>G.then(()=>P(Y)),Promise.resolve())}return tt}function PS(e,t){const n=[],s=[],r=[],i=Math.max(t.matched.length,e.matched.length);for(let o=0;o<i;o++){const a=t.matched[o];a&&(e.matched.find(u=>hr(u,a))?s.push(a):n.push(a));const l=e.matched[o];l&&(t.matched.find(u=>hr(u,l))||r.push(l))}return[n,s,r]}function LS(){return Ne(Ko)}function DS(e){return Ne(Oc)}function go(e,t,n={}){let s,r,i,o=!0;const a=()=>{o=!0,i()};Je(e,a,{flush:"sync",...n});const l=typeof t=="function"?t:t.get,u=typeof t=="function"?void 0:t.set,c=Gl((f,d)=>(r=f,i=d,{get(){return o&&(s=l(s),o=!1),r(),s},set(h){u?.(h)}}));return c.trigger=a,c}function gr(e){return Nd()?(bv(e),!0):!1}function If(){const e=new Set,t=i=>{e.delete(i)};return{on:i=>{e.add(i);const o=()=>t(i);return gr(o),{off:o}},off:t,trigger:(...i)=>Promise.all(Array.from(e).map(o=>o(...i))),clear:()=>{e.clear()}}}function FS(e,t,{enumerable:n=!1,unwrap:s=!0}={}){for(const[r,i]of Object.entries(t))r!=="value"&&(Ze(i)&&s?Object.defineProperty(e,r,{get(){return i.value},set(o){i.value=o},enumerable:n}):Object.defineProperty(e,r,{value:i,enumerable:n}));return e}const Ns=typeof window<"u"&&typeof document<"u";typeof WorkerGlobalScope<"u"&&globalThis instanceof WorkerGlobalScope;const zS=Object.prototype.toString,jS=e=>zS.call(e)==="[object Object]",bl=()=>{},HS=(e,t)=>Object.prototype.hasOwnProperty.call(e,t);function VS(...e){if(e.length!==1)return Wv(...e);const t=e[0];return typeof t=="function"?Mt(Gl(()=>({get:t,set:bl}))):re(t)}function Yp(e,t){function n(...s){return new Promise((r,i)=>{Promise.resolve(e(()=>t.apply(this,s),{fn:t,thisArg:this,args:s})).then(r).catch(i)})}return n}const Gp=e=>e();function BS(e,t={}){let n,s,r=bl;const i=l=>{clearTimeout(l),r(),r=bl};let o;return l=>{const u=dt(e),c=dt(t.maxWait);return n&&i(n),u<=0||c!==void 0&&c<=0?(s&&(i(s),s=void 0),Promise.resolve(l())):new Promise((f,d)=>{r=t.rejectOnCancel?d:f,o=l,c&&!s&&(s=setTimeout(()=>{n&&i(n),s=void 0,f(o())},c)),n=setTimeout(()=>{s&&i(s),s=void 0,f(l())},u)})}}function WS(e=Gp,t={}){const{initialState:n="active"}=t,s=VS(n==="active");function r(){s.value=!1}function i(){s.value=!0}const o=(...a)=>{s.value&&e(...a)};return{isActive:Mt(s),pause:r,resume:i,eventFilter:o}}function US(e){let t;function n(){return t||(t=e()),t}return n.reset=async()=>{const s=t;t=void 0,s&&await s},n}function Gi(e){return Array.isArray(e)?e:[e]}function qS(e){return Lo()}function yl(e,t=200,n={}){return Yp(BS(t,n),e)}function Qp(e,t={}){let n=e,s,r;const i=Gl((d,h)=>(s=d,r=h,{get(){return o()},set(p){a(p)}}));function o(d=!0){return d&&s(),n}function a(d,h=!0){var p,g;if(d===n)return;const _=n;((p=t.onBeforeChange)==null?void 0:p.call(t,d,_))!==!1&&(n=d,(g=t.onChanged)==null||g.call(t,d,_),h&&r())}return FS(i,{get:o,set:a,untrackedGet:()=>o(!1),silentSet:d=>a(d,!1),peek:()=>o(!1),lay:d=>a(d,!1)},{enumerable:!0})}function KS(e,t,n={}){const{eventFilter:s=Gp,...r}=n;return Je(e,Yp(s,t),r)}function YS(e,t,n={}){const{eventFilter:s,initialState:r="active",...i}=n,{eventFilter:o,pause:a,resume:l,isActive:u}=WS(s,{initialState:r});return{stop:KS(e,t,{...i,eventFilter:o}),pause:a,resume:l,isActive:u}}function Xp(e,t=!0,n){qS()?Lt(e,n):t?e():un(e)}function GS(e,t=1e3,n={}){const{immediate:s=!0,immediateCallback:r=!1}=n;let i=null;const o=Nt(!1);function a(){i&&(clearInterval(i),i=null)}function l(){o.value=!1,a()}function u(){const c=dt(t);c<=0||(o.value=!0,r&&e(),a(),o.value&&(i=setInterval(e,c)))}if(s&&Ns&&u(),Ze(t)||typeof t=="function"){const c=Je(t,()=>{o.value&&Ns&&u()});gr(c)}return gr(l),{isActive:Gd(o),pause:l,resume:u}}function QS(e,t,n={}){const{immediate:s=!0,immediateCallback:r=!1}=n,i=Nt(!1);let o;function a(){o&&(clearTimeout(o),o=void 0)}function l(){i.value=!1,a()}function u(...c){r&&e(),a(),i.value=!0,o=setTimeout(()=>{i.value=!1,o=void 0,e(...c)},dt(t))}return s&&(i.value=!0,Ns&&u()),gr(l),{isPending:Gd(i),start:u,stop:l}}function XS(e,t,n){return Je(e,t,{...n,immediate:!0})}const ti=Ns?window:void 0,JS=Ns?window.document:void 0,Jp=Ns?window.navigator:void 0;function ns(e){var t;const n=dt(e);return(t=n?.$el)!=null?t:n}function ss(...e){const t=[],n=()=>{t.forEach(a=>a()),t.length=0},s=(a,l,u,c)=>(a.addEventListener(l,u,c),()=>a.removeEventListener(l,u,c)),r=xe(()=>{const a=Gi(dt(e[0])).filter(l=>l!=null);return a.every(l=>typeof l!="string")?a:void 0}),i=XS(()=>{var a,l;return[(l=(a=r.value)==null?void 0:a.map(u=>ns(u)))!=null?l:[ti].filter(u=>u!=null),Gi(dt(r.value?e[1]:e[0])),Gi(A(r.value?e[2]:e[1])),dt(r.value?e[3]:e[2])]},([a,l,u,c])=>{if(n(),!a?.length||!l?.length||!u?.length)return;const f=jS(c)?{...c}:c;t.push(...a.flatMap(d=>l.flatMap(h=>u.map(p=>s(d,h,p,f)))))},{flush:"post"}),o=()=>{i(),n()};return gr(n),o}function ZS(){const e=Nt(!1),t=Lo();return t&&Lt(()=>{e.value=!0},t),e}function Cc(e){const t=ZS();return xe(()=>(t.value,!!e()))}function Pf(e,t={}){const{controls:n=!1,navigator:s=Jp}=t,r=Cc(()=>s&&"permissions"in s),i=Nt(),o=typeof e=="string"?{name:e}:e,a=Nt(),l=()=>{var c,f;a.value=(f=(c=i.value)==null?void 0:c.state)!=null?f:"prompt"};ss(i,"change",l,{passive:!0});const u=US(async()=>{if(r.value){if(!i.value)try{i.value=await s.permissions.query(o)}catch{i.value=void 0}finally{l()}if(n)return Ie(i.value)}});return u(),n?{state:a,isSupported:r,query:u}:a}function ex(e={}){const{navigator:t=Jp,read:n=!1,source:s,copiedDuring:r=1500,legacy:i=!1}=e,o=Cc(()=>t&&"clipboard"in t),a=Pf("clipboard-read"),l=Pf("clipboard-write"),u=xe(()=>o.value||i),c=Nt(""),f=Nt(!1),d=QS(()=>f.value=!1,r,{immediate:!1});async function h(){let y=!(o.value&&b(a.value));if(!y)try{c.value=await t.clipboard.readText()}catch{y=!0}y&&(c.value=_())}u.value&&n&&ss(["copy","cut"],h,{passive:!0});async function p(y=dt(s)){if(u.value&&y!=null){let T=!(o.value&&b(l.value));if(!T)try{await t.clipboard.writeText(y)}catch{T=!0}T&&g(y),c.value=y,f.value=!0,d.start()}}function g(y){const T=document.createElement("textarea");T.value=y??"",T.style.position="absolute",T.style.opacity="0",document.body.appendChild(T),T.select(),document.execCommand("copy"),T.remove()}function _(){var y,T,x;return(x=(T=(y=document?.getSelection)==null?void 0:y.call(document))==null?void 0:T.toString())!=null?x:""}function b(y){return y==="granted"||y==="prompt"}return{isSupported:u,text:c,copied:f,copy:p}}const Li=typeof globalThis<"u"?globalThis:typeof window<"u"?window:typeof global<"u"?global:typeof self<"u"?self:{},Di="__vueuse_ssr_handlers__",tx=nx();function nx(){return Di in Li||(Li[Di]=Li[Di]||{}),Li[Di]}function sx(e,t){return tx[e]||t}function rx(e){return e==null?"any":e instanceof Set?"set":e instanceof Map?"map":e instanceof Date?"date":typeof e=="boolean"?"boolean":typeof e=="string"?"string":typeof e=="object"?"object":Number.isNaN(e)?"any":"number"}const ix={boolean:{read:e=>e==="true",write:e=>String(e)},object:{read:e=>JSON.parse(e),write:e=>JSON.stringify(e)},number:{read:e=>Number.parseFloat(e),write:e=>String(e)},any:{read:e=>e,write:e=>String(e)},string:{read:e=>e,write:e=>String(e)},map:{read:e=>new Map(JSON.parse(e)),write:e=>JSON.stringify(Array.from(e.entries()))},set:{read:e=>new Set(JSON.parse(e)),write:e=>JSON.stringify(Array.from(e))},date:{read:e=>new Date(e),write:e=>e.toISOString()}},Lf="vueuse-storage";function Pa(e,t,n,s={}){var r;const{flush:i="pre",deep:o=!0,listenToStorageChanges:a=!0,writeDefaults:l=!0,mergeDefaults:u=!1,shallow:c,window:f=ti,eventFilter:d,onError:h=L=>{console.error(L)},initOnMounted:p}=s,g=(c?Nt:re)(t),_=xe(()=>dt(e));if(!n)try{n=sx("getDefaultStorage",()=>{var L;return(L=ti)==null?void 0:L.localStorage})()}catch(L){h(L)}if(!n)return g;const b=dt(t),y=rx(b),T=(r=s.serializer)!=null?r:ix[y],{pause:x,resume:O}=YS(g,L=>C(L),{flush:i,deep:o,eventFilter:d});Je(_,()=>ne(),{flush:i});let $=!1;const F=L=>{p&&!$||ne(L)},Q=L=>{p&&!$||W(L)};f&&a&&(n instanceof Storage?ss(f,"storage",F,{passive:!0}):ss(f,Lf,Q)),p?Xp(()=>{$=!0,ne()}):ne();function P(L,le){if(f){const B={key:_.value,oldValue:L,newValue:le,storageArea:n};f.dispatchEvent(n instanceof Storage?new StorageEvent("storage",B):new CustomEvent(Lf,{detail:B}))}}function C(L){try{const le=n.getItem(_.value);if(L==null)P(le,null),n.removeItem(_.value);else{const B=T.write(L);le!==B&&(n.setItem(_.value,B),P(le,B))}}catch(le){h(le)}}function q(L){const le=L?L.newValue:n.getItem(_.value);if(le==null)return l&&b!=null&&n.setItem(_.value,T.write(b)),b;if(!L&&u){const B=T.read(le);return typeof u=="function"?u(B,b):y==="object"&&!Array.isArray(B)?{...b,...B}:B}else return typeof le!="string"?le:T.read(le)}function ne(L){if(!(L&&L.storageArea!==n)){if(L&&L.key==null){g.value=b;return}if(!(L&&L.key!==_.value)){x();try{const le=T.write(g.value);(L===void 0||L?.newValue!==le)&&(g.value=q(L))}catch(le){h(le)}finally{L?un(O):O()}}}}function W(L){ne(L.detail)}return g}function ox(e,t={}){var n,s;const r=Nt(!1),i=Nt(null);let o=0,a=!0;if(Ns){const l=typeof t=="function"?{onDrop:t}:t,u=(n=l.multiple)!=null?n:!0,c=(s=l.preventDefaultForUnhandled)!=null?s:!1,f=_=>{var b,y;const T=Array.from((y=(b=_.dataTransfer)==null?void 0:b.files)!=null?y:[]);return T.length===0?null:u?T:[T[0]]},d=_=>{const b=A(l.dataTypes);return typeof b=="function"?b(_):b?.length?_.length===0?!1:_.every(y=>b.some(T=>y.includes(T))):!0},h=_=>{const b=Array.from(_??[]).map(x=>x.type),y=d(b),T=u||_.length<=1;return y&&T},p=()=>/^(?:(?!chrome|android).)*safari/i.test(navigator.userAgent)&&!("chrome"in window),g=(_,b)=>{var y,T,x,O,$,F;const Q=(y=_.dataTransfer)==null?void 0:y.items;if(a=(T=Q&&h(Q))!=null?T:!1,c&&_.preventDefault(),!p()&&!a){_.dataTransfer&&(_.dataTransfer.dropEffect="none");return}_.preventDefault(),_.dataTransfer&&(_.dataTransfer.dropEffect="copy");const P=f(_);switch(b){case"enter":o+=1,r.value=!0,(x=l.onEnter)==null||x.call(l,null,_);break;case"over":(O=l.onOver)==null||O.call(l,null,_);break;case"leave":o-=1,o===0&&(r.value=!1),($=l.onLeave)==null||$.call(l,null,_);break;case"drop":o=0,r.value=!1,a&&(i.value=P,(F=l.onDrop)==null||F.call(l,P,_));break}};ss(e,"dragenter",_=>g(_,"enter")),ss(e,"dragover",_=>g(_,"over")),ss(e,"dragleave",_=>g(_,"leave")),ss(e,"drop",_=>g(_,"drop"))}return{files:i,isOverDropZone:r}}function Zp(e,t,n={}){const{window:s=ti,...r}=n;let i;const o=Cc(()=>s&&"ResizeObserver"in s),a=()=>{i&&(i.disconnect(),i=void 0)},l=xe(()=>{const f=dt(e);return Array.isArray(f)?f.map(d=>ns(d)):[ns(f)]}),u=Je(l,f=>{if(a(),o.value&&s){i=new ResizeObserver(t);for(const d of f)d&&i.observe(d,r)}},{immediate:!0,flush:"post"}),c=()=>{a(),u()};return gr(c),{isSupported:o,stop:c}}function ax(e,t={width:0,height:0},n={}){const{window:s=ti,box:r="content-box"}=n,i=xe(()=>{var f,d;return(d=(f=ns(e))==null?void 0:f.namespaceURI)==null?void 0:d.includes("svg")}),o=Nt(t.width),a=Nt(t.height),{stop:l}=Zp(e,([f])=>{const d=r==="border-box"?f.borderBoxSize:r==="content-box"?f.contentBoxSize:f.devicePixelContentBoxSize;if(s&&i.value){const h=ns(e);if(h){const p=h.getBoundingClientRect();o.value=p.width,a.value=p.height}}else if(d){const h=Gi(d);o.value=h.reduce((p,{inlineSize:g})=>p+g,0),a.value=h.reduce((p,{blockSize:g})=>p+g,0)}else o.value=f.contentRect.width,a.value=f.contentRect.height},n);Xp(()=>{const f=ns(e);f&&(o.value="offsetWidth"in f?f.offsetWidth:t.width,a.value="offsetHeight"in f?f.offsetHeight:t.height)});const u=Je(()=>ns(e),f=>{o.value=f?t.width:0,a.value=f?t.height:0});function c(){l(),u()}return{width:o,height:a,stop:c}}const lx={multiple:!0,accept:"*",reset:!1,directory:!1};function cx(e){if(!e)return null;if(e instanceof FileList)return e;const t=new DataTransfer;for(const n of e)t.items.add(n);return t.files}function ux(e={}){const{document:t=JS}=e,n=re(cx(e.initialFiles)),{on:s,trigger:r}=If(),{on:i,trigger:o}=If(),a=xe(()=>{var f;const d=(f=ns(e.input))!=null?f:t?t.createElement("input"):void 0;return d&&(d.type="file",d.onchange=h=>{const p=h.target;n.value=p.files,r(n.value)},d.oncancel=()=>{o()}),d}),l=()=>{n.value=null,a.value&&a.value.value&&(a.value.value="",r(null))},u=f=>{const d=a.value;d&&(d.multiple=dt(f.multiple),d.accept=dt(f.accept),d.webkitdirectory=dt(f.directory),HS(f,"capture")&&(d.capture=dt(f.capture)))},c=f=>{const d=a.value;if(!d)return;const h={...lx,...e,...f};u(h),dt(h.reset)&&l(),d.click()};return Sh(()=>{u(e)}),{files:Mt(n),open:c,reset:l,onCancel:i,onChange:s}}function fx(e,t){const{containerStyle:n,wrapperProps:s,scrollTo:r,calculateRange:i,currentList:o,containerRef:a}="itemHeight"in t?px(t,e):hx(t,e);return{list:o,scrollTo:r,containerProps:{ref:a,onScroll:()=>{i()},style:n},wrapperProps:s}}function eg(e){const t=Nt(null),n=ax(t),s=re([]),r=Nt(e);return{state:re({start:0,end:10}),source:r,currentList:s,size:n,containerRef:t}}function tg(e,t,n){return s=>{if(typeof n=="number")return Math.ceil(s/n);const{start:r=0}=e.value;let i=0,o=0;for(let a=r;a<t.value.length;a++){const l=n(a);if(i+=l,o=a,i>s)break}return o-r}}function ng(e,t){return n=>{if(typeof t=="number")return Math.floor(n/t)+1;let s=0,r=0;for(let i=0;i<e.value.length;i++){const o=t(i);if(s+=o,s>=n){r=i;break}}return r+1}}function sg(e,t,n,s,{containerRef:r,state:i,currentList:o,source:a}){return()=>{const l=r.value;if(l){const u=n(e==="vertical"?l.scrollTop:l.scrollLeft),c=s(e==="vertical"?l.clientHeight:l.clientWidth),f=u-t,d=u+c+t;i.value={start:f<0?0:f,end:d>a.value.length?a.value.length:d},o.value=a.value.slice(i.value.start,i.value.end).map((h,p)=>({data:h,index:p+i.value.start}))}}}function rg(e,t){return n=>typeof e=="number"?n*e:t.value.slice(0,n).reduce((r,i,o)=>r+e(o),0)}function ig(e,t,n,s){Je([e.width,e.height,()=>dt(t),n],()=>{s()})}function og(e,t){return xe(()=>typeof e=="number"?t.value.length*e:t.value.reduce((n,s,r)=>n+e(r),0))}const dx={horizontal:"scrollLeft",vertical:"scrollTop"};function ag(e,t,n,s){return r=>{s.value&&(s.value[dx[e]]=n(r),t())}}function hx(e,t){const n=eg(t),{state:s,source:r,currentList:i,size:o,containerRef:a}=n,l={overflowX:"auto"},{itemWidth:u,overscan:c=5}=e,f=tg(s,r,u),d=ng(r,u),h=sg("horizontal",c,d,f,n),p=rg(u,r),g=xe(()=>p(s.value.start)),_=og(u,r);ig(o,t,a,h);const b=ag("horizontal",h,p,a),y=xe(()=>({style:{height:"100%",width:\`\${_.value-g.value}px\`,marginLeft:\`\${g.value}px\`,display:"flex"}}));return{scrollTo:b,calculateRange:h,wrapperProps:y,containerStyle:l,currentList:i,containerRef:a}}function px(e,t){const n=eg(t),{state:s,source:r,currentList:i,size:o,containerRef:a}=n,l={overflowY:"auto"},{itemHeight:u,overscan:c=5}=e,f=tg(s,r,u),d=ng(r,u),h=sg("vertical",c,d,f,n),p=rg(u,r),g=xe(()=>p(s.value.start)),_=og(u,r);ig(o,t,a,h);const b=ag("vertical",h,p,a),y=xe(()=>({style:{width:"100%",height:\`\${_.value-g.value}px\`,marginTop:\`\${g.value}px\`}}));return{calculateRange:h,scrollTo:b,containerStyle:l,wrapperProps:y,currentList:i,containerRef:a}}var Gt=Uint8Array,Gs=Uint16Array,gx=Int32Array,lg=new Gt([0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5,5,0,0,0,0]),cg=new Gt([0,0,0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,0,0]),mx=new Gt([16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15]),ug=function(e,t){for(var n=new Gs(31),s=0;s<31;++s)n[s]=t+=1<<e[s-1];for(var r=new gx(n[30]),s=1;s<30;++s)for(var i=n[s];i<n[s+1];++i)r[i]=i-n[s]<<5|s;return{b:n,r}},fg=ug(lg,2),dg=fg.b,vx=fg.r;dg[28]=258,vx[258]=28;var bx=ug(cg,0),yx=bx.b,_l=new Gs(32768);for(var Ye=0;Ye<32768;++Ye){var Xn=(Ye&43690)>>1|(Ye&21845)<<1;Xn=(Xn&52428)>>2|(Xn&13107)<<2,Xn=(Xn&61680)>>4|(Xn&3855)<<4,_l[Ye]=((Xn&65280)>>8|(Xn&255)<<8)>>1}var Br=(function(e,t,n){for(var s=e.length,r=0,i=new Gs(t);r<s;++r)e[r]&&++i[e[r]-1];var o=new Gs(t);for(r=1;r<t;++r)o[r]=o[r-1]+i[r-1]<<1;var a;if(n){a=new Gs(1<<t);var l=15-t;for(r=0;r<s;++r)if(e[r])for(var u=r<<4|e[r],c=t-e[r],f=o[e[r]-1]++<<c,d=f|(1<<c)-1;f<=d;++f)a[_l[f]>>l]=u}else for(a=new Gs(s),r=0;r<s;++r)e[r]&&(a[r]=_l[o[e[r]-1]++]>>15-e[r]);return a}),hi=new Gt(288);for(var Ye=0;Ye<144;++Ye)hi[Ye]=8;for(var Ye=144;Ye<256;++Ye)hi[Ye]=9;for(var Ye=256;Ye<280;++Ye)hi[Ye]=7;for(var Ye=280;Ye<288;++Ye)hi[Ye]=8;var hg=new Gt(32);for(var Ye=0;Ye<32;++Ye)hg[Ye]=5;var _x=Br(hi,9,1),Ex=Br(hg,5,1),La=function(e){for(var t=e[0],n=1;n<e.length;++n)e[n]>t&&(t=e[n]);return t},rn=function(e,t,n){var s=t/8|0;return(e[s]|e[s+1]<<8)>>(t&7)&n},Da=function(e,t){var n=t/8|0;return(e[n]|e[n+1]<<8|e[n+2]<<16)>>(t&7)},wx=function(e){return(e+7)/8|0},Sx=function(e,t,n){return(n==null||n>e.length)&&(n=e.length),new Gt(e.subarray(t,n))},xx=["unexpected EOF","invalid block type","invalid length/literal","invalid distance","stream finished","no stream handler",,"no callback","invalid UTF-8 data","extra field too long","date not in range 1980-2099","filename too long","stream finishing","invalid zip data"],Cn=function(e,t,n){var s=new Error(t||xx[e]);if(s.code=e,Error.captureStackTrace&&Error.captureStackTrace(s,Cn),!n)throw s;return s},Tx=function(e,t,n,s){var r=e.length,i=0;if(!r||t.f&&!t.l)return n||new Gt(0);var o=!n,a=o||t.i!=2,l=t.i;o&&(n=new Gt(r*3));var u=function(Oe){var m=n.length;if(Oe>m){var v=new Gt(Math.max(m*2,Oe));v.set(n),n=v}},c=t.f||0,f=t.p||0,d=t.b||0,h=t.l,p=t.d,g=t.m,_=t.n,b=r*8;do{if(!h){c=rn(e,f,1);var y=rn(e,f+1,3);if(f+=3,y)if(y==1)h=_x,p=Ex,g=9,_=5;else if(y==2){var $=rn(e,f,31)+257,F=rn(e,f+10,15)+4,Q=$+rn(e,f+5,31)+1;f+=14;for(var P=new Gt(Q),C=new Gt(19),q=0;q<F;++q)C[mx[q]]=rn(e,f+q*3,7);f+=F*3;for(var ne=La(C),W=(1<<ne)-1,L=Br(C,ne,1),q=0;q<Q;){var le=L[rn(e,f,W)];f+=le&15;var T=le>>4;if(T<16)P[q++]=T;else{var B=0,ue=0;for(T==16?(ue=3+rn(e,f,3),f+=2,B=P[q-1]):T==17?(ue=3+rn(e,f,7),f+=3):T==18&&(ue=11+rn(e,f,127),f+=7);ue--;)P[q++]=B}}var Z=P.subarray(0,$),we=P.subarray($);g=La(Z),_=La(we),h=Br(Z,g,1),p=Br(we,_,1)}else Cn(1);else{var T=wx(f)+4,x=e[T-4]|e[T-3]<<8,O=T+x;if(O>r){l&&Cn(0);break}a&&u(d+x),n.set(e.subarray(T,O),d),t.b=d+=x,t.p=f=O*8,t.f=c;continue}if(f>b){l&&Cn(0);break}}a&&u(d+131072);for(var Ke=(1<<g)-1,rt=(1<<_)-1,Ve=f;;Ve=f){var B=h[Da(e,f)&Ke],it=B>>4;if(f+=B&15,f>b){l&&Cn(0);break}if(B||Cn(2),it<256)n[d++]=it;else if(it==256){Ve=f,h=null;break}else{var ct=it-254;if(it>264){var q=it-257,tt=lg[q];ct=rn(e,f,(1<<tt)-1)+dg[q],f+=tt}var Qe=p[Da(e,f)&rt],R=Qe>>4;Qe||Cn(3),f+=Qe&15;var we=yx[R];if(R>3){var tt=cg[R];we+=Da(e,f)&(1<<tt)-1,f+=tt}if(f>b){l&&Cn(0);break}a&&u(d+131072);var G=d+ct;if(d<we){var Y=i-we,se=Math.min(we,G);for(Y+d<0&&Cn(3);d<se;++d)n[d]=s[Y+d]}for(;d<G;++d)n[d]=n[d-we]}}t.l=h,t.p=Ve,t.b=d,t.f=c,h&&(c=1,t.m=g,t.d=p,t.n=_)}while(!c);return d!=n.length&&o?Sx(n,0,d):n.subarray(0,d)},Ax=new Gt(0);function Ox(e,t){return Tx(e,{i:2},t,t)}var Cx=typeof TextDecoder<"u"&&new TextDecoder,Rx=0;try{Cx.decode(Ax,{stream:!0}),Rx=1}catch{}class pg extends Error{response;constructor(t){super(t.statusText),this.response=t}}function $x(){return Mx}function Yt(){throw new Error("Not implemented")}let Fa=null;async function Df(){if(!Fa){const e=window.__TGR_RBEL_LOG__;if(e){const n=await(await fetch(e)).arrayBuffer(),s=Ox(new Uint8Array(n));Fa=JSON.parse(new TextDecoder().decode(s))}else return null}return Fa}const Mx={async fetchMessagesWithHtml(e){const t=(await Df()).messagesWithHtml;return Promise.resolve({...t,messages:t.messages.slice(e.fromOffset,e.toOffsetExcluding),fromOffset:e.fromOffset,toOffsetExcluding:e.toOffsetExcluding})},async fetchMessagesWithMeta(){const e=(await Df()).messagesWithMeta;return Promise.resolve(e)},fetchQuitProxy(){Yt()},fetchResetMessages(){Yt()},fetchTestFilter(){Yt()},fetchTestJexlQuery(){Yt()},fetchTestRbelTreeQuery(){Yt()},searchMessages(){Yt()},fetchAddProxyRoute(){Yt()},fetchAllProxyRoutes(){Yt()},fetchDeleteProxyRoute(){Yt()},fetchImportTraffic(){Yt()},fetchDownloadTraffic(){Yt()},fetchFullyRenderedMessage(){Yt()}},kt=$x();function vs(e){const t=(s,r)=>{if((r?.suppressError===void 0||r?.suppressError===!1)&&s instanceof pg&&e.onError&&e.onError(s.message,s.response.status),r?.propagateError===!0)throw s},n=async(s,r)=>{try{return e.onLoading&&e.onLoading(!0),await s()}catch(i){t(i,r)}finally{e.onLoading&&e.onLoading(!1)}};return{getMetaMessages:(s,r)=>n(()=>kt.fetchMessagesWithMeta(s),r),getMessages:(s,r)=>n(()=>kt.fetchMessagesWithHtml(s),r),getFullyRenderedMessage:(s,r)=>n(()=>kt.fetchFullyRenderedMessage(s),r),resetMessageQueue:s=>n(()=>kt.fetchResetMessages(),s),quitProxy:s=>n(()=>kt.fetchQuitProxy(),s),testFilter:(s,r)=>n(()=>kt.fetchTestFilter(s),r),searchMessages:(s,r)=>n(()=>kt.searchMessages(s),r),testRbelJexlQuery:(s,r)=>n(()=>kt.fetchTestJexlQuery(s),r),testRbelTreeQuery:(s,r)=>n(()=>kt.fetchTestRbelTreeQuery(s),r),importRbelLogFile:(s,r)=>n(()=>kt.fetchImportTraffic(s),r),downloadRbelLogFile:(s,r)=>n(()=>kt.fetchDownloadTraffic(s),r),getProxyRoutes:s=>n(()=>kt.fetchAllProxyRoutes(),s),deleteProxyRoute:(s,r)=>n(()=>kt.fetchDeleteProxyRoute(s),r),addProxyRoute:(s,r)=>n(()=>kt.fetchAddProxyRoute(s),r)}}const pi=Symbol("messageQueueSymbol");function Nx(e,t,n){const s=vs(n),r=re(null),i=re(null),o=re(null),a=xe(()=>{const O=r.value?.messages??[];return e.value?O.toReversed():O}),l=go(t,()=>{const O=t.value.trim();return O.length>0?O:void 0});async function u(){const O=r.value,$=await s.getMetaMessages({filterRbelPath:l.value});$&&(O?.totalFiltered!==$.totalFiltered||O?.hash!==$.hash)&&(r.value=$)}Je(l,async(O,$)=>{O!==$&&(i.value=null,await u())});const{resume:c,pause:f}=GS(async()=>{await u()},1e3,{immediate:!1,immediateCallback:!0});Lt(()=>{c()}),Jl(()=>{f()});const d=xe(()=>r.value?.totalFiltered??0),h=xe(()=>{const O=r.value;if(!O)return[];const $=e.value??!1,F=new Array(O.totalFiltered);for(let Q=0;Q<O.totalFiltered;Q++){const P=i.value?.messages?.find(C=>C.offset===Q);P?F[Q]={type:"loaded",htmlContent:P.content,index:Q,uuid:O.messages[Q].uuid,sequenceNumber:O.messages[Q].sequenceNumber}:F[Q]={type:"loading",index:Q,uuid:O.messages[Q].uuid,sequenceNumber:O.messages[Q].sequenceNumber}}return $?F.toReversed():F});let p={fromOffset:-1,toOffsetExcluding:-1,filterRbelPath:""},g=new AbortController;const _=async(O,$)=>{const F=e.value??!1,Q=h.value.length,P=h.value[Math.min(Q-1,O)].index,C=h.value[Math.min(Q-1,$)].index,q=F?C:P,ne=F?P:C,W=p?.fromOffset===q&&p?.toOffsetExcluding===ne+1&&p?.filterRbelPath===l.value;if(i.value==null||!W)try{g.signal.aborted||g.abort(),g=new AbortController,p={fromOffset:q,toOffsetExcluding:ne+1,filterRbelPath:l.value};const L=await s.getMessages({...p,signal:g.signal},{suppressError:!0,propagateError:!0});L&&(i.value=L)}catch{}},b=yl(O=>{const $=h.value.findIndex(F=>F.uuid===O);o.value?.scrollToItem($),un(async()=>{await new Promise(F=>setTimeout(F,100)),o.value?.scrollToItem($)})},150,{rejectOnCancel:!0}),y=yl(O=>{const $=h.value.findIndex(F=>F.sequenceNumber===O);o.value?.scrollToItem($),un(async()=>{await new Promise(F=>setTimeout(F,100)),o.value?.scrollToItem($)})},150,{rejectOnCancel:!0}),T=(O,$)=>{if(O===""&&$){y($);return}b(O)},x=()=>{r.value=null};return{messagesMeta:a,total:d,reversedMessageQueue:Mt(e),scrollToMessage:T,reset:x,internal:{update:_,messages:h,ref:o}}}/*!
 * Font Awesome Free 7.0.0 by @fontawesome - https://fontawesome.com
 * License - https://fontawesome.com/license/free (Icons: CC BY 4.0, Fonts: SIL OFL 1.1, Code: MIT License)
 * Copyright 2025 Fonticons, Inc.
 */function El(e,t){(t==null||t>e.length)&&(t=e.length);for(var n=0,s=Array(t);n<t;n++)s[n]=e[n];return s}function kx(e){if(Array.isArray(e))return e}function Ix(e){if(Array.isArray(e))return El(e)}function Px(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}function Lx(e,t){for(var n=0;n<t.length;n++){var s=t[n];s.enumerable=s.enumerable||!1,s.configurable=!0,"value"in s&&(s.writable=!0),Object.defineProperty(e,gg(s.key),s)}}function Dx(e,t,n){return t&&Lx(e.prototype,t),Object.defineProperty(e,"prototype",{writable:!1}),e}function Qi(e,t){var n=typeof Symbol<"u"&&e[Symbol.iterator]||e["@@iterator"];if(!n){if(Array.isArray(e)||(n=Rc(e))||t){n&&(e=n);var s=0,r=function(){};return{s:r,n:function(){return s>=e.length?{done:!0}:{done:!1,value:e[s++]}},e:function(l){throw l},f:r}}throw new TypeError(\`Invalid attempt to iterate non-iterable instance.
In order to be iterable, non-array objects must have a [Symbol.iterator]() method.\`)}var i,o=!0,a=!1;return{s:function(){n=n.call(e)},n:function(){var l=n.next();return o=l.done,l},e:function(l){a=!0,i=l},f:function(){try{o||n.return==null||n.return()}finally{if(a)throw i}}}}function Me(e,t,n){return(t=gg(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function Fx(e){if(typeof Symbol<"u"&&e[Symbol.iterator]!=null||e["@@iterator"]!=null)return Array.from(e)}function zx(e,t){var n=e==null?null:typeof Symbol<"u"&&e[Symbol.iterator]||e["@@iterator"];if(n!=null){var s,r,i,o,a=[],l=!0,u=!1;try{if(i=(n=n.call(e)).next,t===0){if(Object(n)!==n)return;l=!1}else for(;!(l=(s=i.call(n)).done)&&(a.push(s.value),a.length!==t);l=!0);}catch(c){u=!0,r=c}finally{try{if(!l&&n.return!=null&&(o=n.return(),Object(o)!==o))return}finally{if(u)throw r}}return a}}function jx(){throw new TypeError(\`Invalid attempt to destructure non-iterable instance.
In order to be iterable, non-array objects must have a [Symbol.iterator]() method.\`)}function Hx(){throw new TypeError(\`Invalid attempt to spread non-iterable instance.
In order to be iterable, non-array objects must have a [Symbol.iterator]() method.\`)}function Ff(e,t){var n=Object.keys(e);if(Object.getOwnPropertySymbols){var s=Object.getOwnPropertySymbols(e);t&&(s=s.filter(function(r){return Object.getOwnPropertyDescriptor(e,r).enumerable})),n.push.apply(n,s)}return n}function V(e){for(var t=1;t<arguments.length;t++){var n=arguments[t]!=null?arguments[t]:{};t%2?Ff(Object(n),!0).forEach(function(s){Me(e,s,n[s])}):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(n)):Ff(Object(n)).forEach(function(s){Object.defineProperty(e,s,Object.getOwnPropertyDescriptor(n,s))})}return e}function Yo(e,t){return kx(e)||zx(e,t)||Rc(e,t)||jx()}function dn(e){return Ix(e)||Fx(e)||Rc(e)||Hx()}function Vx(e,t){if(typeof e!="object"||!e)return e;var n=e[Symbol.toPrimitive];if(n!==void 0){var s=n.call(e,t);if(typeof s!="object")return s;throw new TypeError("@@toPrimitive must return a primitive value.")}return(t==="string"?String:Number)(e)}function gg(e){var t=Vx(e,"string");return typeof t=="symbol"?t:t+""}function mo(e){"@babel/helpers - typeof";return mo=typeof Symbol=="function"&&typeof Symbol.iterator=="symbol"?function(t){return typeof t}:function(t){return t&&typeof Symbol=="function"&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},mo(e)}function Rc(e,t){if(e){if(typeof e=="string")return El(e,t);var n={}.toString.call(e).slice(8,-1);return n==="Object"&&e.constructor&&(n=e.constructor.name),n==="Map"||n==="Set"?Array.from(e):n==="Arguments"||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)?El(e,t):void 0}}var zf=function(){},$c={},mg={},vg=null,bg={mark:zf,measure:zf};try{typeof window<"u"&&($c=window),typeof document<"u"&&(mg=document),typeof MutationObserver<"u"&&(vg=MutationObserver),typeof performance<"u"&&(bg=performance)}catch{}var Bx=$c.navigator||{},jf=Bx.userAgent,Hf=jf===void 0?"":jf,us=$c,Ge=mg,Vf=vg,Fi=bg;us.document;var Un=!!Ge.documentElement&&!!Ge.head&&typeof Ge.addEventListener=="function"&&typeof Ge.createElement=="function",yg=~Hf.indexOf("MSIE")||~Hf.indexOf("Trident/"),za,Wx=/fa(k|kd|s|r|l|t|d|dr|dl|dt|b|slr|slpr|wsb|tl|ns|nds|es|jr|jfr|jdr|cr|ss|sr|sl|st|sds|sdr|sdl|sdt)?[\\-\\ ]/,Ux=/Font ?Awesome ?([567 ]*)(Solid|Regular|Light|Thin|Duotone|Brands|Free|Pro|Sharp Duotone|Sharp|Kit|Notdog Duo|Notdog|Chisel|Etch|Thumbprint|Jelly Fill|Jelly Duo|Jelly|Slab Press|Slab|Whiteboard)?.*/i,_g={classic:{fa:"solid",fas:"solid","fa-solid":"solid",far:"regular","fa-regular":"regular",fal:"light","fa-light":"light",fat:"thin","fa-thin":"thin",fab:"brands","fa-brands":"brands"},duotone:{fa:"solid",fad:"solid","fa-solid":"solid","fa-duotone":"solid",fadr:"regular","fa-regular":"regular",fadl:"light","fa-light":"light",fadt:"thin","fa-thin":"thin"},sharp:{fa:"solid",fass:"solid","fa-solid":"solid",fasr:"regular","fa-regular":"regular",fasl:"light","fa-light":"light",fast:"thin","fa-thin":"thin"},"sharp-duotone":{fa:"solid",fasds:"solid","fa-solid":"solid",fasdr:"regular","fa-regular":"regular",fasdl:"light","fa-light":"light",fasdt:"thin","fa-thin":"thin"},slab:{"fa-regular":"regular",faslr:"regular"},"slab-press":{"fa-regular":"regular",faslpr:"regular"},thumbprint:{"fa-light":"light",fatl:"light"},whiteboard:{"fa-semibold":"semibold",fawsb:"semibold"},notdog:{"fa-solid":"solid",fans:"solid"},"notdog-duo":{"fa-solid":"solid",fands:"solid"},etch:{"fa-solid":"solid",faes:"solid"},jelly:{"fa-regular":"regular",fajr:"regular"},"jelly-fill":{"fa-regular":"regular",fajfr:"regular"},"jelly-duo":{"fa-regular":"regular",fajdr:"regular"},chisel:{"fa-regular":"regular",facr:"regular"}},qx={GROUP:"duotone-group",PRIMARY:"primary",SECONDARY:"secondary"},Eg=["fa-classic","fa-duotone","fa-sharp","fa-sharp-duotone","fa-thumbprint","fa-whiteboard","fa-notdog","fa-notdog-duo","fa-chisel","fa-etch","fa-jelly","fa-jelly-fill","fa-jelly-duo","fa-slab","fa-slab-press"],xt="classic",gi="duotone",wg="sharp",Sg="sharp-duotone",xg="chisel",Tg="etch",Ag="jelly",Og="jelly-duo",Cg="jelly-fill",Rg="notdog",$g="notdog-duo",Mg="slab",Ng="slab-press",kg="thumbprint",Ig="whiteboard",Kx="Classic",Yx="Duotone",Gx="Sharp",Qx="Sharp Duotone",Xx="Chisel",Jx="Etch",Zx="Jelly",eT="Jelly Duo",tT="Jelly Fill",nT="Notdog",sT="Notdog Duo",rT="Slab",iT="Slab Press",oT="Thumbprint",aT="Whiteboard",Pg=[xt,gi,wg,Sg,xg,Tg,Ag,Og,Cg,Rg,$g,Mg,Ng,kg,Ig];za={},Me(Me(Me(Me(Me(Me(Me(Me(Me(Me(za,xt,Kx),gi,Yx),wg,Gx),Sg,Qx),xg,Xx),Tg,Jx),Ag,Zx),Og,eT),Cg,tT),Rg,nT),Me(Me(Me(Me(Me(za,$g,sT),Mg,rT),Ng,iT),kg,oT),Ig,aT);var lT={classic:{900:"fas",400:"far",normal:"far",300:"fal",100:"fat"},duotone:{900:"fad",400:"fadr",300:"fadl",100:"fadt"},sharp:{900:"fass",400:"fasr",300:"fasl",100:"fast"},"sharp-duotone":{900:"fasds",400:"fasdr",300:"fasdl",100:"fasdt"},slab:{400:"faslr"},"slab-press":{400:"faslpr"},whiteboard:{600:"fawsb"},thumbprint:{300:"fatl"},notdog:{900:"fans"},"notdog-duo":{900:"fands"},etch:{900:"faes"},chisel:{400:"facr"},jelly:{400:"fajr"},"jelly-fill":{400:"fajfr"},"jelly-duo":{400:"fajdr"}},cT={"Font Awesome 7 Free":{900:"fas",400:"far"},"Font Awesome 7 Pro":{900:"fas",400:"far",normal:"far",300:"fal",100:"fat"},"Font Awesome 7 Brands":{400:"fab",normal:"fab"},"Font Awesome 7 Duotone":{900:"fad",400:"fadr",normal:"fadr",300:"fadl",100:"fadt"},"Font Awesome 7 Sharp":{900:"fass",400:"fasr",normal:"fasr",300:"fasl",100:"fast"},"Font Awesome 7 Sharp Duotone":{900:"fasds",400:"fasdr",normal:"fasdr",300:"fasdl",100:"fasdt"},"Font Awesome 7 Jelly":{400:"fajr",normal:"fajr"},"Font Awesome 7 Jelly Fill":{400:"fajfr",normal:"fajfr"},"Font Awesome 7 Jelly Duo":{400:"fajdr",normal:"fajdr"},"Font Awesome 7 Slab":{400:"faslr",normal:"faslr"},"Font Awesome 7 Slab Press":{400:"faslpr",normal:"faslpr"},"Font Awesome 7 Thumbprint":{300:"fatl",normal:"fatl"},"Font Awesome 7 Notdog":{900:"fans",normal:"fans"},"Font Awesome 7 Notdog Duo":{900:"fands",normal:"fands"},"Font Awesome 7 Etch":{900:"faes",normal:"faes"},"Font Awesome 7 Chisel":{400:"facr",normal:"facr"},"Font Awesome 7 Whiteboard":{600:"fawsb",normal:"fawsb"}},uT=new Map([["classic",{defaultShortPrefixId:"fas",defaultStyleId:"solid",styleIds:["solid","regular","light","thin","brands"],futureStyleIds:[],defaultFontWeight:900}],["duotone",{defaultShortPrefixId:"fad",defaultStyleId:"solid",styleIds:["solid","regular","light","thin"],futureStyleIds:[],defaultFontWeight:900}],["sharp",{defaultShortPrefixId:"fass",defaultStyleId:"solid",styleIds:["solid","regular","light","thin"],futureStyleIds:[],defaultFontWeight:900}],["sharp-duotone",{defaultShortPrefixId:"fasds",defaultStyleId:"solid",styleIds:["solid","regular","light","thin"],futureStyleIds:[],defaultFontWeight:900}],["chisel",{defaultShortPrefixId:"facr",defaultStyleId:"regular",styleIds:["regular"],futureStyleIds:[],defaultFontWeight:400}],["etch",{defaultShortPrefixId:"faes",defaultStyleId:"solid",styleIds:["solid"],futureStyleIds:[],defaultFontWeight:900}],["jelly",{defaultShortPrefixId:"fajr",defaultStyleId:"regular",styleIds:["regular"],futureStyleIds:[],defaultFontWeight:400}],["jelly-duo",{defaultShortPrefixId:"fajdr",defaultStyleId:"regular",styleIds:["regular"],futureStyleIds:[],defaultFontWeight:400}],["jelly-fill",{defaultShortPrefixId:"fajfr",defaultStyleId:"regular",styleIds:["regular"],futureStyleIds:[],defaultFontWeight:400}],["notdog",{defaultShortPrefixId:"fans",defaultStyleId:"solid",styleIds:["solid"],futureStyleIds:[],defaultFontWeight:900}],["notdog-duo",{defaultShortPrefixId:"fands",defaultStyleId:"solid",styleIds:["solid"],futureStyleIds:[],defaultFontWeight:900}],["slab",{defaultShortPrefixId:"faslr",defaultStyleId:"regular",styleIds:["regular"],futureStyleIds:[],defaultFontWeight:400}],["slab-press",{defaultShortPrefixId:"faslpr",defaultStyleId:"regular",styleIds:["regular"],futureStyleIds:[],defaultFontWeight:400}],["thumbprint",{defaultShortPrefixId:"fatl",defaultStyleId:"light",styleIds:["light"],futureStyleIds:[],defaultFontWeight:300}],["whiteboard",{defaultShortPrefixId:"fawsb",defaultStyleId:"semibold",styleIds:["semibold"],futureStyleIds:[],defaultFontWeight:600}]]),fT={chisel:{regular:"facr"},classic:{brands:"fab",light:"fal",regular:"far",solid:"fas",thin:"fat"},duotone:{light:"fadl",regular:"fadr",solid:"fad",thin:"fadt"},etch:{solid:"faes"},jelly:{regular:"fajr"},"jelly-duo":{regular:"fajdr"},"jelly-fill":{regular:"fajfr"},notdog:{solid:"fans"},"notdog-duo":{solid:"fands"},sharp:{light:"fasl",regular:"fasr",solid:"fass",thin:"fast"},"sharp-duotone":{light:"fasdl",regular:"fasdr",solid:"fasds",thin:"fasdt"},slab:{regular:"faslr"},"slab-press":{regular:"faslpr"},thumbprint:{light:"fatl"},whiteboard:{semibold:"fawsb"}},Lg=["fak","fa-kit","fakd","fa-kit-duotone"],Bf={kit:{fak:"kit","fa-kit":"kit"},"kit-duotone":{fakd:"kit-duotone","fa-kit-duotone":"kit-duotone"}},dT=["kit"],hT="kit",pT="kit-duotone",gT="Kit",mT="Kit Duotone";Me(Me({},hT,gT),pT,mT);var vT={kit:{"fa-kit":"fak"}},bT={"Font Awesome Kit":{400:"fak",normal:"fak"},"Font Awesome Kit Duotone":{400:"fakd",normal:"fakd"}},yT={kit:{fak:"fa-kit"}},Wf={kit:{kit:"fak"},"kit-duotone":{"kit-duotone":"fakd"}},ja,zi={GROUP:"duotone-group",SWAP_OPACITY:"swap-opacity",PRIMARY:"primary",SECONDARY:"secondary"},_T=["fa-classic","fa-duotone","fa-sharp","fa-sharp-duotone","fa-thumbprint","fa-whiteboard","fa-notdog","fa-notdog-duo","fa-chisel","fa-etch","fa-jelly","fa-jelly-fill","fa-jelly-duo","fa-slab","fa-slab-press"],ET="classic",wT="duotone",ST="sharp",xT="sharp-duotone",TT="chisel",AT="etch",OT="jelly",CT="jelly-duo",RT="jelly-fill",$T="notdog",MT="notdog-duo",NT="slab",kT="slab-press",IT="thumbprint",PT="whiteboard",LT="Classic",DT="Duotone",FT="Sharp",zT="Sharp Duotone",jT="Chisel",HT="Etch",VT="Jelly",BT="Jelly Duo",WT="Jelly Fill",UT="Notdog",qT="Notdog Duo",KT="Slab",YT="Slab Press",GT="Thumbprint",QT="Whiteboard";ja={},Me(Me(Me(Me(Me(Me(Me(Me(Me(Me(ja,ET,LT),wT,DT),ST,FT),xT,zT),TT,jT),AT,HT),OT,VT),CT,BT),RT,WT),$T,UT),Me(Me(Me(Me(Me(ja,MT,qT),NT,KT),kT,YT),IT,GT),PT,QT);var XT="kit",JT="kit-duotone",ZT="Kit",eA="Kit Duotone";Me(Me({},XT,ZT),JT,eA);var tA={classic:{"fa-brands":"fab","fa-duotone":"fad","fa-light":"fal","fa-regular":"far","fa-solid":"fas","fa-thin":"fat"},duotone:{"fa-regular":"fadr","fa-light":"fadl","fa-thin":"fadt"},sharp:{"fa-solid":"fass","fa-regular":"fasr","fa-light":"fasl","fa-thin":"fast"},"sharp-duotone":{"fa-solid":"fasds","fa-regular":"fasdr","fa-light":"fasdl","fa-thin":"fasdt"},slab:{"fa-regular":"faslr"},"slab-press":{"fa-regular":"faslpr"},whiteboard:{"fa-semibold":"fawsb"},thumbprint:{"fa-light":"fatl"},notdog:{"fa-solid":"fans"},"notdog-duo":{"fa-solid":"fands"},etch:{"fa-solid":"faes"},jelly:{"fa-regular":"fajr"},"jelly-fill":{"fa-regular":"fajfr"},"jelly-duo":{"fa-regular":"fajdr"},chisel:{"fa-regular":"facr"}},nA={classic:["fas","far","fal","fat","fad"],duotone:["fadr","fadl","fadt"],sharp:["fass","fasr","fasl","fast"],"sharp-duotone":["fasds","fasdr","fasdl","fasdt"],slab:["faslr"],"slab-press":["faslpr"],whiteboard:["fawsb"],thumbprint:["fatl"],notdog:["fans"],"notdog-duo":["fands"],etch:["faes"],jelly:["fajr"],"jelly-fill":["fajfr"],"jelly-duo":["fajdr"],chisel:["facr"]},wl={classic:{fab:"fa-brands",fad:"fa-duotone",fal:"fa-light",far:"fa-regular",fas:"fa-solid",fat:"fa-thin"},duotone:{fadr:"fa-regular",fadl:"fa-light",fadt:"fa-thin"},sharp:{fass:"fa-solid",fasr:"fa-regular",fasl:"fa-light",fast:"fa-thin"},"sharp-duotone":{fasds:"fa-solid",fasdr:"fa-regular",fasdl:"fa-light",fasdt:"fa-thin"},slab:{faslr:"fa-regular"},"slab-press":{faslpr:"fa-regular"},whiteboard:{fawsb:"fa-semibold"},thumbprint:{fatl:"fa-light"},notdog:{fans:"fa-solid"},"notdog-duo":{fands:"fa-solid"},etch:{faes:"fa-solid"},jelly:{fajr:"fa-regular"},"jelly-fill":{fajfr:"fa-regular"},"jelly-duo":{fajdr:"fa-regular"},chisel:{facr:"fa-regular"}},sA=["fa-solid","fa-regular","fa-light","fa-thin","fa-duotone","fa-brands","fa-semibold"],Dg=["fa","fas","far","fal","fat","fad","fadr","fadl","fadt","fab","fass","fasr","fasl","fast","fasds","fasdr","fasdl","fasdt","faslr","faslpr","fawsb","fatl","fans","fands","faes","fajr","fajfr","fajdr","facr"].concat(_T,sA),rA=["solid","regular","light","thin","duotone","brands","semibold"],Fg=[1,2,3,4,5,6,7,8,9,10],iA=Fg.concat([11,12,13,14,15,16,17,18,19,20]),oA=["aw","fw","pull-left","pull-right"],aA=[].concat(dn(Object.keys(nA)),rA,oA,["2xs","xs","sm","lg","xl","2xl","beat","border","fade","beat-fade","bounce","flip-both","flip-horizontal","flip-vertical","flip","inverse","layers","layers-bottom-left","layers-bottom-right","layers-counter","layers-text","layers-top-left","layers-top-right","li","pull-end","pull-start","pulse","rotate-180","rotate-270","rotate-90","rotate-by","shake","spin-pulse","spin-reverse","spin","stack-1x","stack-2x","stack","ul","width-auto","width-fixed",zi.GROUP,zi.SWAP_OPACITY,zi.PRIMARY,zi.SECONDARY]).concat(Fg.map(function(e){return"".concat(e,"x")})).concat(iA.map(function(e){return"w-".concat(e)})),lA={"Font Awesome 5 Free":{900:"fas",400:"far"},"Font Awesome 5 Pro":{900:"fas",400:"far",normal:"far",300:"fal"},"Font Awesome 5 Brands":{400:"fab",normal:"fab"},"Font Awesome 5 Duotone":{900:"fad"}},Hn="___FONT_AWESOME___",Sl=16,zg="fa",jg="svg-inline--fa",ks="data-fa-i2svg",xl="data-fa-pseudo-element",cA="data-fa-pseudo-element-pending",Mc="data-prefix",Nc="data-icon",Uf="fontawesome-i2svg",uA="async",fA=["HTML","HEAD","STYLE","SCRIPT"],Hg=["::before","::after",":before",":after"],Vg=(function(){try{return!0}catch{return!1}})();function mi(e){return new Proxy(e,{get:function(n,s){return s in n?n[s]:n[xt]}})}var Bg=V({},_g);Bg[xt]=V(V(V(V({},{"fa-duotone":"duotone"}),_g[xt]),Bf.kit),Bf["kit-duotone"]);var dA=mi(Bg),Tl=V({},fT);Tl[xt]=V(V(V(V({},{duotone:"fad"}),Tl[xt]),Wf.kit),Wf["kit-duotone"]);var qf=mi(Tl),Al=V({},wl);Al[xt]=V(V({},Al[xt]),yT.kit);var Wg=mi(Al),Ol=V({},tA);Ol[xt]=V(V({},Ol[xt]),vT.kit);mi(Ol);var hA=Wx,Ug="fa-layers-text",pA=Ux,gA=V({},lT);mi(gA);var mA=["class","data-prefix","data-icon","data-fa-transform","data-fa-mask"],Ha=qx,vA=[].concat(dn(dT),dn(aA)),Wr=us.FontAwesomeConfig||{};function bA(e){var t=Ge.querySelector("script["+e+"]");if(t)return t.getAttribute(e)}function yA(e){return e===""?!0:e==="false"?!1:e==="true"?!0:e}if(Ge&&typeof Ge.querySelector=="function"){var _A=[["data-family-prefix","familyPrefix"],["data-css-prefix","cssPrefix"],["data-family-default","familyDefault"],["data-style-default","styleDefault"],["data-replacement-class","replacementClass"],["data-auto-replace-svg","autoReplaceSvg"],["data-auto-add-css","autoAddCss"],["data-search-pseudo-elements","searchPseudoElements"],["data-search-pseudo-elements-warnings","searchPseudoElementsWarnings"],["data-search-pseudo-elements-full-scan","searchPseudoElementsFullScan"],["data-observe-mutations","observeMutations"],["data-mutate-approach","mutateApproach"],["data-keep-original-source","keepOriginalSource"],["data-measure-performance","measurePerformance"],["data-show-missing-icons","showMissingIcons"]];_A.forEach(function(e){var t=Yo(e,2),n=t[0],s=t[1],r=yA(bA(n));r!=null&&(Wr[s]=r)})}var qg={styleDefault:"solid",familyDefault:xt,cssPrefix:zg,replacementClass:jg,autoReplaceSvg:!0,autoAddCss:!0,searchPseudoElements:!1,searchPseudoElementsWarnings:!0,searchPseudoElementsFullScan:!1,observeMutations:!0,mutateApproach:"async",keepOriginalSource:!0,measurePerformance:!1,showMissingIcons:!0};Wr.familyPrefix&&(Wr.cssPrefix=Wr.familyPrefix);var mr=V(V({},qg),Wr);mr.autoReplaceSvg||(mr.observeMutations=!1);var he={};Object.keys(qg).forEach(function(e){Object.defineProperty(he,e,{enumerable:!0,set:function(n){mr[e]=n,Ur.forEach(function(s){return s(he)})},get:function(){return mr[e]}})});Object.defineProperty(he,"familyPrefix",{enumerable:!0,set:function(t){mr.cssPrefix=t,Ur.forEach(function(n){return n(he)})},get:function(){return mr.cssPrefix}});us.FontAwesomeConfig=he;var Ur=[];function EA(e){return Ur.push(e),function(){Ur.splice(Ur.indexOf(e),1)}}var Vs=Sl,_n={size:16,x:0,y:0,rotate:0,flipX:!1,flipY:!1};function wA(e){if(!(!e||!Un)){var t=Ge.createElement("style");t.setAttribute("type","text/css"),t.innerHTML=e;for(var n=Ge.head.childNodes,s=null,r=n.length-1;r>-1;r--){var i=n[r],o=(i.tagName||"").toUpperCase();["STYLE","LINK"].indexOf(o)>-1&&(s=i)}return Ge.head.insertBefore(t,s),e}}var SA="0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";function Kf(){for(var e=12,t="";e-- >0;)t+=SA[Math.random()*62|0];return t}function Er(e){for(var t=[],n=(e||[]).length>>>0;n--;)t[n]=e[n];return t}function kc(e){return e.classList?Er(e.classList):(e.getAttribute("class")||"").split(" ").filter(function(t){return t})}function Kg(e){return"".concat(e).replace(/&/g,"&amp;").replace(/"/g,"&quot;").replace(/'/g,"&#39;").replace(/</g,"&lt;").replace(/>/g,"&gt;")}function xA(e){return Object.keys(e||{}).reduce(function(t,n){return t+"".concat(n,'="').concat(Kg(e[n]),'" ')},"").trim()}function Go(e){return Object.keys(e||{}).reduce(function(t,n){return t+"".concat(n,": ").concat(e[n].trim(),";")},"")}function Ic(e){return e.size!==_n.size||e.x!==_n.x||e.y!==_n.y||e.rotate!==_n.rotate||e.flipX||e.flipY}function TA(e){var t=e.transform,n=e.containerWidth,s=e.iconWidth,r={transform:"translate(".concat(n/2," 256)")},i="translate(".concat(t.x*32,", ").concat(t.y*32,") "),o="scale(".concat(t.size/16*(t.flipX?-1:1),", ").concat(t.size/16*(t.flipY?-1:1),") "),a="rotate(".concat(t.rotate," 0 0)"),l={transform:"".concat(i," ").concat(o," ").concat(a)},u={transform:"translate(".concat(s/2*-1," -256)")};return{outer:r,inner:l,path:u}}function AA(e){var t=e.transform,n=e.width,s=n===void 0?Sl:n,r=e.height,i=r===void 0?Sl:r,o="";return yg?o+="translate(".concat(t.x/Vs-s/2,"em, ").concat(t.y/Vs-i/2,"em) "):o+="translate(calc(-50% + ".concat(t.x/Vs,"em), calc(-50% + ").concat(t.y/Vs,"em)) "),o+="scale(".concat(t.size/Vs*(t.flipX?-1:1),", ").concat(t.size/Vs*(t.flipY?-1:1),") "),o+="rotate(".concat(t.rotate,"deg) "),o}var OA=\`:root, :host {
  --fa-font-solid: normal 900 1em/1 "Font Awesome 7 Free";
  --fa-font-regular: normal 400 1em/1 "Font Awesome 7 Free";
  --fa-font-light: normal 300 1em/1 "Font Awesome 7 Pro";
  --fa-font-thin: normal 100 1em/1 "Font Awesome 7 Pro";
  --fa-font-duotone: normal 900 1em/1 "Font Awesome 7 Duotone";
  --fa-font-duotone-regular: normal 400 1em/1 "Font Awesome 7 Duotone";
  --fa-font-duotone-light: normal 300 1em/1 "Font Awesome 7 Duotone";
  --fa-font-duotone-thin: normal 100 1em/1 "Font Awesome 7 Duotone";
  --fa-font-brands: normal 400 1em/1 "Font Awesome 7 Brands";
  --fa-font-sharp-solid: normal 900 1em/1 "Font Awesome 7 Sharp";
  --fa-font-sharp-regular: normal 400 1em/1 "Font Awesome 7 Sharp";
  --fa-font-sharp-light: normal 300 1em/1 "Font Awesome 7 Sharp";
  --fa-font-sharp-thin: normal 100 1em/1 "Font Awesome 7 Sharp";
  --fa-font-sharp-duotone-solid: normal 900 1em/1 "Font Awesome 7 Sharp Duotone";
  --fa-font-sharp-duotone-regular: normal 400 1em/1 "Font Awesome 7 Sharp Duotone";
  --fa-font-sharp-duotone-light: normal 300 1em/1 "Font Awesome 7 Sharp Duotone";
  --fa-font-sharp-duotone-thin: normal 100 1em/1 "Font Awesome 7 Sharp Duotone";
  --fa-font-slab-regular: normal 400 1em/1 "Font Awesome 7 Slab";
  --fa-font-slab-press-regular: normal 400 1em/1 "Font Awesome 7 Slab Press";
  --fa-font-whiteboard-semibold: normal 600 1em/1 "Font Awesome 7 Whiteboard";
  --fa-font-thumbprint-light: normal 300 1em/1 "Font Awesome 7 Thumbprint";
  --fa-font-notdog-solid: normal 900 1em/1 "Font Awesome 7 Notdog";
  --fa-font-notdog-duo-solid: normal 900 1em/1 "Font Awesome 7 Notdog Duo";
  --fa-font-etch-solid: normal 900 1em/1 "Font Awesome 7 Etch";
  --fa-font-jelly-regular: normal 400 1em/1 "Font Awesome 7 Jelly";
  --fa-font-jelly-fill-regular: normal 400 1em/1 "Font Awesome 7 Jelly Fill";
  --fa-font-jelly-duo-regular: normal 400 1em/1 "Font Awesome 7 Jelly Duo";
  --fa-font-chisel-regular: normal 400 1em/1 "Font Awesome 7 Chisel";
}

.svg-inline--fa {
  box-sizing: content-box;
  display: var(--fa-display, inline-block);
  height: 1em;
  overflow: visible;
  vertical-align: -0.125em;
  width: var(--fa-width, 1.25em);
}
.svg-inline--fa.fa-2xs {
  vertical-align: 0.1em;
}
.svg-inline--fa.fa-xs {
  vertical-align: 0em;
}
.svg-inline--fa.fa-sm {
  vertical-align: -0.0714285714em;
}
.svg-inline--fa.fa-lg {
  vertical-align: -0.2em;
}
.svg-inline--fa.fa-xl {
  vertical-align: -0.25em;
}
.svg-inline--fa.fa-2xl {
  vertical-align: -0.3125em;
}
.svg-inline--fa.fa-pull-left,
.svg-inline--fa .fa-pull-start {
  float: inline-start;
  margin-inline-end: var(--fa-pull-margin, 0.3em);
}
.svg-inline--fa.fa-pull-right,
.svg-inline--fa .fa-pull-end {
  float: inline-end;
  margin-inline-start: var(--fa-pull-margin, 0.3em);
}
.svg-inline--fa.fa-li {
  width: var(--fa-li-width, 2em);
  inset-inline-start: calc(-1 * var(--fa-li-width, 2em));
  inset-block-start: 0.25em; /* syncing vertical alignment with Web Font rendering */
}

.fa-layers-counter, .fa-layers-text {
  display: inline-block;
  position: absolute;
  text-align: center;
}

.fa-layers {
  display: inline-block;
  height: 1em;
  position: relative;
  text-align: center;
  vertical-align: -0.125em;
  width: var(--fa-width, 1.25em);
}
.fa-layers .svg-inline--fa {
  inset: 0;
  margin: auto;
  position: absolute;
  transform-origin: center center;
}

.fa-layers-text {
  left: 50%;
  top: 50%;
  transform: translate(-50%, -50%);
  transform-origin: center center;
}

.fa-layers-counter {
  background-color: var(--fa-counter-background-color, #ff253a);
  border-radius: var(--fa-counter-border-radius, 1em);
  box-sizing: border-box;
  color: var(--fa-inverse, #fff);
  line-height: var(--fa-counter-line-height, 1);
  max-width: var(--fa-counter-max-width, 5em);
  min-width: var(--fa-counter-min-width, 1.5em);
  overflow: hidden;
  padding: var(--fa-counter-padding, 0.25em 0.5em);
  right: var(--fa-right, 0);
  text-overflow: ellipsis;
  top: var(--fa-top, 0);
  transform: scale(var(--fa-counter-scale, 0.25));
  transform-origin: top right;
}

.fa-layers-bottom-right {
  bottom: var(--fa-bottom, 0);
  right: var(--fa-right, 0);
  top: auto;
  transform: scale(var(--fa-layers-scale, 0.25));
  transform-origin: bottom right;
}

.fa-layers-bottom-left {
  bottom: var(--fa-bottom, 0);
  left: var(--fa-left, 0);
  right: auto;
  top: auto;
  transform: scale(var(--fa-layers-scale, 0.25));
  transform-origin: bottom left;
}

.fa-layers-top-right {
  top: var(--fa-top, 0);
  right: var(--fa-right, 0);
  transform: scale(var(--fa-layers-scale, 0.25));
  transform-origin: top right;
}

.fa-layers-top-left {
  left: var(--fa-left, 0);
  right: auto;
  top: var(--fa-top, 0);
  transform: scale(var(--fa-layers-scale, 0.25));
  transform-origin: top left;
}

.fa-1x {
  font-size: 1em;
}

.fa-2x {
  font-size: 2em;
}

.fa-3x {
  font-size: 3em;
}

.fa-4x {
  font-size: 4em;
}

.fa-5x {
  font-size: 5em;
}

.fa-6x {
  font-size: 6em;
}

.fa-7x {
  font-size: 7em;
}

.fa-8x {
  font-size: 8em;
}

.fa-9x {
  font-size: 9em;
}

.fa-10x {
  font-size: 10em;
}

.fa-2xs {
  font-size: calc(10 / 16 * 1em); /* converts a 10px size into an em-based value that's relative to the scale's 16px base */
  line-height: calc(1 / 10 * 1em); /* sets the line-height of the icon back to that of it's parent */
  vertical-align: calc((6 / 10 - 0.375) * 1em); /* vertically centers the icon taking into account the surrounding text's descender */
}

.fa-xs {
  font-size: calc(12 / 16 * 1em); /* converts a 12px size into an em-based value that's relative to the scale's 16px base */
  line-height: calc(1 / 12 * 1em); /* sets the line-height of the icon back to that of it's parent */
  vertical-align: calc((6 / 12 - 0.375) * 1em); /* vertically centers the icon taking into account the surrounding text's descender */
}

.fa-sm {
  font-size: calc(14 / 16 * 1em); /* converts a 14px size into an em-based value that's relative to the scale's 16px base */
  line-height: calc(1 / 14 * 1em); /* sets the line-height of the icon back to that of it's parent */
  vertical-align: calc((6 / 14 - 0.375) * 1em); /* vertically centers the icon taking into account the surrounding text's descender */
}

.fa-lg {
  font-size: calc(20 / 16 * 1em); /* converts a 20px size into an em-based value that's relative to the scale's 16px base */
  line-height: calc(1 / 20 * 1em); /* sets the line-height of the icon back to that of it's parent */
  vertical-align: calc((6 / 20 - 0.375) * 1em); /* vertically centers the icon taking into account the surrounding text's descender */
}

.fa-xl {
  font-size: calc(24 / 16 * 1em); /* converts a 24px size into an em-based value that's relative to the scale's 16px base */
  line-height: calc(1 / 24 * 1em); /* sets the line-height of the icon back to that of it's parent */
  vertical-align: calc((6 / 24 - 0.375) * 1em); /* vertically centers the icon taking into account the surrounding text's descender */
}

.fa-2xl {
  font-size: calc(32 / 16 * 1em); /* converts a 32px size into an em-based value that's relative to the scale's 16px base */
  line-height: calc(1 / 32 * 1em); /* sets the line-height of the icon back to that of it's parent */
  vertical-align: calc((6 / 32 - 0.375) * 1em); /* vertically centers the icon taking into account the surrounding text's descender */
}

.fa-width-auto {
  --fa-width: auto;
}

.fa-fw,
.fa-width-fixed {
  --fa-width: 1.25em;
}

.fa-ul {
  list-style-type: none;
  margin-inline-start: var(--fa-li-margin, 2.5em);
  padding-inline-start: 0;
}
.fa-ul > li {
  position: relative;
}

.fa-li {
  inset-inline-start: calc(-1 * var(--fa-li-width, 2em));
  position: absolute;
  text-align: center;
  width: var(--fa-li-width, 2em);
  line-height: inherit;
}

/* Heads Up: Bordered Icons will not be supported in the future!
  - This feature will be deprecated in the next major release of Font Awesome (v8)!
  - You may continue to use it in this version *v7), but it will not be supported in Font Awesome v8.
*/
/* Notes:
* --@{v.$css-prefix}-border-width = 1/16 by default (to render as ~1px based on a 16px default font-size)
* --@{v.$css-prefix}-border-padding =
  ** 3/16 for vertical padding (to give ~2px of vertical whitespace around an icon considering it's vertical alignment)
  ** 4/16 for horizontal padding (to give ~4px of horizontal whitespace around an icon)
*/
.fa-border {
  border-color: var(--fa-border-color, #eee);
  border-radius: var(--fa-border-radius, 0.1em);
  border-style: var(--fa-border-style, solid);
  border-width: var(--fa-border-width, 0.0625em);
  box-sizing: var(--fa-border-box-sizing, content-box);
  padding: var(--fa-border-padding, 0.1875em 0.25em);
}

.fa-pull-left,
.fa-pull-start {
  float: inline-start;
  margin-inline-end: var(--fa-pull-margin, 0.3em);
}

.fa-pull-right,
.fa-pull-end {
  float: inline-end;
  margin-inline-start: var(--fa-pull-margin, 0.3em);
}

.fa-beat {
  animation-name: fa-beat;
  animation-delay: var(--fa-animation-delay, 0s);
  animation-direction: var(--fa-animation-direction, normal);
  animation-duration: var(--fa-animation-duration, 1s);
  animation-iteration-count: var(--fa-animation-iteration-count, infinite);
  animation-timing-function: var(--fa-animation-timing, ease-in-out);
}

.fa-bounce {
  animation-name: fa-bounce;
  animation-delay: var(--fa-animation-delay, 0s);
  animation-direction: var(--fa-animation-direction, normal);
  animation-duration: var(--fa-animation-duration, 1s);
  animation-iteration-count: var(--fa-animation-iteration-count, infinite);
  animation-timing-function: var(--fa-animation-timing, cubic-bezier(0.28, 0.84, 0.42, 1));
}

.fa-fade {
  animation-name: fa-fade;
  animation-delay: var(--fa-animation-delay, 0s);
  animation-direction: var(--fa-animation-direction, normal);
  animation-duration: var(--fa-animation-duration, 1s);
  animation-iteration-count: var(--fa-animation-iteration-count, infinite);
  animation-timing-function: var(--fa-animation-timing, cubic-bezier(0.4, 0, 0.6, 1));
}

.fa-beat-fade {
  animation-name: fa-beat-fade;
  animation-delay: var(--fa-animation-delay, 0s);
  animation-direction: var(--fa-animation-direction, normal);
  animation-duration: var(--fa-animation-duration, 1s);
  animation-iteration-count: var(--fa-animation-iteration-count, infinite);
  animation-timing-function: var(--fa-animation-timing, cubic-bezier(0.4, 0, 0.6, 1));
}

.fa-flip {
  animation-name: fa-flip;
  animation-delay: var(--fa-animation-delay, 0s);
  animation-direction: var(--fa-animation-direction, normal);
  animation-duration: var(--fa-animation-duration, 1s);
  animation-iteration-count: var(--fa-animation-iteration-count, infinite);
  animation-timing-function: var(--fa-animation-timing, ease-in-out);
}

.fa-shake {
  animation-name: fa-shake;
  animation-delay: var(--fa-animation-delay, 0s);
  animation-direction: var(--fa-animation-direction, normal);
  animation-duration: var(--fa-animation-duration, 1s);
  animation-iteration-count: var(--fa-animation-iteration-count, infinite);
  animation-timing-function: var(--fa-animation-timing, linear);
}

.fa-spin {
  animation-name: fa-spin;
  animation-delay: var(--fa-animation-delay, 0s);
  animation-direction: var(--fa-animation-direction, normal);
  animation-duration: var(--fa-animation-duration, 2s);
  animation-iteration-count: var(--fa-animation-iteration-count, infinite);
  animation-timing-function: var(--fa-animation-timing, linear);
}

.fa-spin-reverse {
  --fa-animation-direction: reverse;
}

.fa-pulse,
.fa-spin-pulse {
  animation-name: fa-spin;
  animation-direction: var(--fa-animation-direction, normal);
  animation-duration: var(--fa-animation-duration, 1s);
  animation-iteration-count: var(--fa-animation-iteration-count, infinite);
  animation-timing-function: var(--fa-animation-timing, steps(8));
}

@media (prefers-reduced-motion: reduce) {
  .fa-beat,
  .fa-bounce,
  .fa-fade,
  .fa-beat-fade,
  .fa-flip,
  .fa-pulse,
  .fa-shake,
  .fa-spin,
  .fa-spin-pulse {
    animation: none !important;
    transition: none !important;
  }
}
@keyframes fa-beat {
  0%, 90% {
    transform: scale(1);
  }
  45% {
    transform: scale(var(--fa-beat-scale, 1.25));
  }
}
@keyframes fa-bounce {
  0% {
    transform: scale(1, 1) translateY(0);
  }
  10% {
    transform: scale(var(--fa-bounce-start-scale-x, 1.1), var(--fa-bounce-start-scale-y, 0.9)) translateY(0);
  }
  30% {
    transform: scale(var(--fa-bounce-jump-scale-x, 0.9), var(--fa-bounce-jump-scale-y, 1.1)) translateY(var(--fa-bounce-height, -0.5em));
  }
  50% {
    transform: scale(var(--fa-bounce-land-scale-x, 1.05), var(--fa-bounce-land-scale-y, 0.95)) translateY(0);
  }
  57% {
    transform: scale(1, 1) translateY(var(--fa-bounce-rebound, -0.125em));
  }
  64% {
    transform: scale(1, 1) translateY(0);
  }
  100% {
    transform: scale(1, 1) translateY(0);
  }
}
@keyframes fa-fade {
  50% {
    opacity: var(--fa-fade-opacity, 0.4);
  }
}
@keyframes fa-beat-fade {
  0%, 100% {
    opacity: var(--fa-beat-fade-opacity, 0.4);
    transform: scale(1);
  }
  50% {
    opacity: 1;
    transform: scale(var(--fa-beat-fade-scale, 1.125));
  }
}
@keyframes fa-flip {
  50% {
    transform: rotate3d(var(--fa-flip-x, 0), var(--fa-flip-y, 1), var(--fa-flip-z, 0), var(--fa-flip-angle, -180deg));
  }
}
@keyframes fa-shake {
  0% {
    transform: rotate(-15deg);
  }
  4% {
    transform: rotate(15deg);
  }
  8%, 24% {
    transform: rotate(-18deg);
  }
  12%, 28% {
    transform: rotate(18deg);
  }
  16% {
    transform: rotate(-22deg);
  }
  20% {
    transform: rotate(22deg);
  }
  32% {
    transform: rotate(-12deg);
  }
  36% {
    transform: rotate(12deg);
  }
  40%, 100% {
    transform: rotate(0deg);
  }
}
@keyframes fa-spin {
  0% {
    transform: rotate(0deg);
  }
  100% {
    transform: rotate(360deg);
  }
}
.fa-rotate-90 {
  transform: rotate(90deg);
}

.fa-rotate-180 {
  transform: rotate(180deg);
}

.fa-rotate-270 {
  transform: rotate(270deg);
}

.fa-flip-horizontal {
  transform: scale(-1, 1);
}

.fa-flip-vertical {
  transform: scale(1, -1);
}

.fa-flip-both,
.fa-flip-horizontal.fa-flip-vertical {
  transform: scale(-1, -1);
}

.fa-rotate-by {
  transform: rotate(var(--fa-rotate-angle, 0));
}

.svg-inline--fa .fa-primary {
  fill: var(--fa-primary-color, currentColor);
  opacity: var(--fa-primary-opacity, 1);
}

.svg-inline--fa .fa-secondary {
  fill: var(--fa-secondary-color, currentColor);
  opacity: var(--fa-secondary-opacity, 0.4);
}

.svg-inline--fa.fa-swap-opacity .fa-primary {
  opacity: var(--fa-secondary-opacity, 0.4);
}

.svg-inline--fa.fa-swap-opacity .fa-secondary {
  opacity: var(--fa-primary-opacity, 1);
}

.svg-inline--fa mask .fa-primary,
.svg-inline--fa mask .fa-secondary {
  fill: black;
}

.svg-inline--fa.fa-inverse {
  fill: var(--fa-inverse, #fff);
}

.fa-stack {
  display: inline-block;
  height: 2em;
  line-height: 2em;
  position: relative;
  vertical-align: middle;
  width: 2.5em;
}

.fa-inverse {
  color: var(--fa-inverse, #fff);
}

.svg-inline--fa.fa-stack-1x {
  height: 1em;
  width: 1.25em;
}
.svg-inline--fa.fa-stack-2x {
  height: 2em;
  width: 2.5em;
}

.fa-stack-1x,
.fa-stack-2x {
  bottom: 0;
  left: 0;
  margin: auto;
  position: absolute;
  right: 0;
  top: 0;
  z-index: var(--fa-stack-z-index, auto);
}\`;function Yg(){var e=zg,t=jg,n=he.cssPrefix,s=he.replacementClass,r=OA;if(n!==e||s!==t){var i=new RegExp("\\\\.".concat(e,"\\\\-"),"g"),o=new RegExp("\\\\--".concat(e,"\\\\-"),"g"),a=new RegExp("\\\\.".concat(t),"g");r=r.replace(i,".".concat(n,"-")).replace(o,"--".concat(n,"-")).replace(a,".".concat(s))}return r}var Yf=!1;function Va(){he.autoAddCss&&!Yf&&(wA(Yg()),Yf=!0)}var CA={mixout:function(){return{dom:{css:Yg,insertCss:Va}}},hooks:function(){return{beforeDOMElementCreation:function(){Va()},beforeI2svg:function(){Va()}}}},Vn=us||{};Vn[Hn]||(Vn[Hn]={});Vn[Hn].styles||(Vn[Hn].styles={});Vn[Hn].hooks||(Vn[Hn].hooks={});Vn[Hn].shims||(Vn[Hn].shims=[]);var on=Vn[Hn],Gg=[],Qg=function(){Ge.removeEventListener("DOMContentLoaded",Qg),vo=1,Gg.map(function(t){return t()})},vo=!1;Un&&(vo=(Ge.documentElement.doScroll?/^loaded|^c/:/^loaded|^i|^c/).test(Ge.readyState),vo||Ge.addEventListener("DOMContentLoaded",Qg));function RA(e){Un&&(vo?setTimeout(e,0):Gg.push(e))}function vi(e){var t=e.tag,n=e.attributes,s=n===void 0?{}:n,r=e.children,i=r===void 0?[]:r;return typeof e=="string"?Kg(e):"<".concat(t," ").concat(xA(s),">").concat(i.map(vi).join(""),"</").concat(t,">")}function Gf(e,t,n){if(e&&e[t]&&e[t][n])return{prefix:t,iconName:n,icon:e[t][n]}}var Ba=function(t,n,s,r){var i=Object.keys(t),o=i.length,a=n,l,u,c;for(s===void 0?(l=1,c=t[i[0]]):(l=0,c=s);l<o;l++)u=i[l],c=a(c,t[u],u,t);return c};function Xg(e){return dn(e).length!==1?null:e.codePointAt(0).toString(16)}function Qf(e){return Object.keys(e).reduce(function(t,n){var s=e[n],r=!!s.icon;return r?t[s.iconName]=s.icon:t[n]=s,t},{})}function Jg(e,t){var n=arguments.length>2&&arguments[2]!==void 0?arguments[2]:{},s=n.skipHooks,r=s===void 0?!1:s,i=Qf(t);typeof on.hooks.addPack=="function"&&!r?on.hooks.addPack(e,Qf(t)):on.styles[e]=V(V({},on.styles[e]||{}),i),e==="fas"&&Jg("fa",t)}var ni=on.styles,$A=on.shims,Zg=Object.keys(Wg),MA=Zg.reduce(function(e,t){return e[t]=Object.keys(Wg[t]),e},{}),Pc=null,em={},tm={},nm={},sm={},rm={};function NA(e){return~vA.indexOf(e)}function kA(e,t){var n=t.split("-"),s=n[0],r=n.slice(1).join("-");return s===e&&r!==""&&!NA(r)?r:null}var im=function(){var t=function(i){return Ba(ni,function(o,a,l){return o[l]=Ba(a,i,{}),o},{})};em=t(function(r,i,o){if(i[3]&&(r[i[3]]=o),i[2]){var a=i[2].filter(function(l){return typeof l=="number"});a.forEach(function(l){r[l.toString(16)]=o})}return r}),tm=t(function(r,i,o){if(r[o]=o,i[2]){var a=i[2].filter(function(l){return typeof l=="string"});a.forEach(function(l){r[l]=o})}return r}),rm=t(function(r,i,o){var a=i[2];return r[o]=o,a.forEach(function(l){r[l]=o}),r});var n="far"in ni||he.autoFetchSvg,s=Ba($A,function(r,i){var o=i[0],a=i[1],l=i[2];return a==="far"&&!n&&(a="fas"),typeof o=="string"&&(r.names[o]={prefix:a,iconName:l}),typeof o=="number"&&(r.unicodes[o.toString(16)]={prefix:a,iconName:l}),r},{names:{},unicodes:{}});nm=s.names,sm=s.unicodes,Pc=Qo(he.styleDefault,{family:he.familyDefault})};EA(function(e){Pc=Qo(e.styleDefault,{family:he.familyDefault})});im();function Lc(e,t){return(em[e]||{})[t]}function IA(e,t){return(tm[e]||{})[t]}function As(e,t){return(rm[e]||{})[t]}function om(e){return nm[e]||{prefix:null,iconName:null}}function PA(e){var t=sm[e],n=Lc("fas",e);return t||(n?{prefix:"fas",iconName:n}:null)||{prefix:null,iconName:null}}function fs(){return Pc}var am=function(){return{prefix:null,iconName:null,rest:[]}};function LA(e){var t=xt,n=Zg.reduce(function(s,r){return s[r]="".concat(he.cssPrefix,"-").concat(r),s},{});return Pg.forEach(function(s){(e.includes(n[s])||e.some(function(r){return MA[s].includes(r)}))&&(t=s)}),t}function Qo(e){var t=arguments.length>1&&arguments[1]!==void 0?arguments[1]:{},n=t.family,s=n===void 0?xt:n,r=dA[s][e];if(s===gi&&!e)return"fad";var i=qf[s][e]||qf[s][r],o=e in on.styles?e:null,a=i||o||null;return a}function DA(e){var t=[],n=null;return e.forEach(function(s){var r=kA(he.cssPrefix,s);r?n=r:s&&t.push(s)}),{iconName:n,rest:t}}function Xf(e){return e.sort().filter(function(t,n,s){return s.indexOf(t)===n})}var Jf=Dg.concat(Lg);function Xo(e){var t=arguments.length>1&&arguments[1]!==void 0?arguments[1]:{},n=t.skipLookups,s=n===void 0?!1:n,r=null,i=Xf(e.filter(function(h){return Jf.includes(h)})),o=Xf(e.filter(function(h){return!Jf.includes(h)})),a=i.filter(function(h){return r=h,!Eg.includes(h)}),l=Yo(a,1),u=l[0],c=u===void 0?null:u,f=LA(i),d=V(V({},DA(o)),{},{prefix:Qo(c,{family:f})});return V(V(V({},d),HA({values:e,family:f,styles:ni,config:he,canonical:d,givenPrefix:r})),FA(s,r,d))}function FA(e,t,n){var s=n.prefix,r=n.iconName;if(e||!s||!r)return{prefix:s,iconName:r};var i=t==="fa"?om(r):{},o=As(s,r);return r=i.iconName||o||r,s=i.prefix||s,s==="far"&&!ni.far&&ni.fas&&!he.autoFetchSvg&&(s="fas"),{prefix:s,iconName:r}}var zA=Pg.filter(function(e){return e!==xt||e!==gi}),jA=Object.keys(wl).filter(function(e){return e!==xt}).map(function(e){return Object.keys(wl[e])}).flat();function HA(e){var t=e.values,n=e.family,s=e.canonical,r=e.givenPrefix,i=r===void 0?"":r,o=e.styles,a=o===void 0?{}:o,l=e.config,u=l===void 0?{}:l,c=n===gi,f=t.includes("fa-duotone")||t.includes("fad"),d=u.familyDefault==="duotone",h=s.prefix==="fad"||s.prefix==="fa-duotone";if(!c&&(f||d||h)&&(s.prefix="fad"),(t.includes("fa-brands")||t.includes("fab"))&&(s.prefix="fab"),!s.prefix&&zA.includes(n)){var p=Object.keys(a).find(function(_){return jA.includes(_)});if(p||u.autoFetchSvg){var g=uT.get(n).defaultShortPrefixId;s.prefix=g,s.iconName=As(s.prefix,s.iconName)||s.iconName}}return(s.prefix==="fa"||i==="fa")&&(s.prefix=fs()||"fas"),s}var VA=(function(){function e(){Px(this,e),this.definitions={}}return Dx(e,[{key:"add",value:function(){for(var n=this,s=arguments.length,r=new Array(s),i=0;i<s;i++)r[i]=arguments[i];var o=r.reduce(this._pullDefinitions,{});Object.keys(o).forEach(function(a){n.definitions[a]=V(V({},n.definitions[a]||{}),o[a]),Jg(a,o[a]),im()})}},{key:"reset",value:function(){this.definitions={}}},{key:"_pullDefinitions",value:function(n,s){var r=s.prefix&&s.iconName&&s.icon?{0:s}:s;return Object.keys(r).map(function(i){var o=r[i],a=o.prefix,l=o.iconName,u=o.icon,c=u[2];n[a]||(n[a]={}),c.length>0&&c.forEach(function(f){typeof f=="string"&&(n[a][f]=u)}),n[a][l]=u}),n}}])})(),Zf=[],Qs={},sr={},BA=Object.keys(sr);function WA(e,t){var n=t.mixoutsTo;return Zf=e,Qs={},Object.keys(sr).forEach(function(s){BA.indexOf(s)===-1&&delete sr[s]}),Zf.forEach(function(s){var r=s.mixout?s.mixout():{};if(Object.keys(r).forEach(function(o){typeof r[o]=="function"&&(n[o]=r[o]),mo(r[o])==="object"&&Object.keys(r[o]).forEach(function(a){n[o]||(n[o]={}),n[o][a]=r[o][a]})}),s.hooks){var i=s.hooks();Object.keys(i).forEach(function(o){Qs[o]||(Qs[o]=[]),Qs[o].push(i[o])})}s.provides&&s.provides(sr)}),n}function Cl(e,t){for(var n=arguments.length,s=new Array(n>2?n-2:0),r=2;r<n;r++)s[r-2]=arguments[r];var i=Qs[e]||[];return i.forEach(function(o){t=o.apply(null,[t].concat(s))}),t}function Is(e){for(var t=arguments.length,n=new Array(t>1?t-1:0),s=1;s<t;s++)n[s-1]=arguments[s];var r=Qs[e]||[];r.forEach(function(i){i.apply(null,n)})}function ds(){var e=arguments[0],t=Array.prototype.slice.call(arguments,1);return sr[e]?sr[e].apply(null,t):void 0}function Rl(e){e.prefix==="fa"&&(e.prefix="fas");var t=e.iconName,n=e.prefix||fs();if(t)return t=As(n,t)||t,Gf(lm.definitions,n,t)||Gf(on.styles,n,t)}var lm=new VA,UA=function(){he.autoReplaceSvg=!1,he.observeMutations=!1,Is("noAuto")},qA={i2svg:function(){var t=arguments.length>0&&arguments[0]!==void 0?arguments[0]:{};return Un?(Is("beforeI2svg",t),ds("pseudoElements2svg",t),ds("i2svg",t)):Promise.reject(new Error("Operation requires a DOM of some kind."))},watch:function(){var t=arguments.length>0&&arguments[0]!==void 0?arguments[0]:{},n=t.autoReplaceSvgRoot;he.autoReplaceSvg===!1&&(he.autoReplaceSvg=!0),he.observeMutations=!0,RA(function(){YA({autoReplaceSvgRoot:n}),Is("watch",t)})}},KA={icon:function(t){if(t===null)return null;if(mo(t)==="object"&&t.prefix&&t.iconName)return{prefix:t.prefix,iconName:As(t.prefix,t.iconName)||t.iconName};if(Array.isArray(t)&&t.length===2){var n=t[1].indexOf("fa-")===0?t[1].slice(3):t[1],s=Qo(t[0]);return{prefix:s,iconName:As(s,n)||n}}if(typeof t=="string"&&(t.indexOf("".concat(he.cssPrefix,"-"))>-1||t.match(hA))){var r=Xo(t.split(" "),{skipLookups:!0});return{prefix:r.prefix||fs(),iconName:As(r.prefix,r.iconName)||r.iconName}}if(typeof t=="string"){var i=fs();return{prefix:i,iconName:As(i,t)||t}}}},Wt={noAuto:UA,config:he,dom:qA,parse:KA,library:lm,findIconDefinition:Rl,toHtml:vi},YA=function(){var t=arguments.length>0&&arguments[0]!==void 0?arguments[0]:{},n=t.autoReplaceSvgRoot,s=n===void 0?Ge:n;(Object.keys(on.styles).length>0||he.autoFetchSvg)&&Un&&he.autoReplaceSvg&&Wt.dom.i2svg({node:s})};function Jo(e,t){return Object.defineProperty(e,"abstract",{get:t}),Object.defineProperty(e,"html",{get:function(){return e.abstract.map(function(s){return vi(s)})}}),Object.defineProperty(e,"node",{get:function(){if(Un){var s=Ge.createElement("div");return s.innerHTML=e.html,s.children}}}),e}function GA(e){var t=e.children,n=e.main,s=e.mask,r=e.attributes,i=e.styles,o=e.transform;if(Ic(o)&&n.found&&!s.found){var a=n.width,l=n.height,u={x:a/l/2,y:.5};r.style=Go(V(V({},i),{},{"transform-origin":"".concat(u.x+o.x/16,"em ").concat(u.y+o.y/16,"em")}))}return[{tag:"svg",attributes:r,children:t}]}function QA(e){var t=e.prefix,n=e.iconName,s=e.children,r=e.attributes,i=e.symbol,o=i===!0?"".concat(t,"-").concat(he.cssPrefix,"-").concat(n):i;return[{tag:"svg",attributes:{style:"display: none;"},children:[{tag:"symbol",attributes:V(V({},r),{},{id:o}),children:s}]}]}function XA(e){var t=["aria-label","aria-labelledby","title","role"];return t.some(function(n){return n in e})}function Dc(e){var t=e.icons,n=t.main,s=t.mask,r=e.prefix,i=e.iconName,o=e.transform,a=e.symbol,l=e.maskId,u=e.extra,c=e.watchable,f=c===void 0?!1:c,d=s.found?s:n,h=d.width,p=d.height,g=[he.replacementClass,i?"".concat(he.cssPrefix,"-").concat(i):""].filter(function(O){return u.classes.indexOf(O)===-1}).filter(function(O){return O!==""||!!O}).concat(u.classes).join(" "),_={children:[],attributes:V(V({},u.attributes),{},{"data-prefix":r,"data-icon":i,class:g,role:u.attributes.role||"img",viewBox:"0 0 ".concat(h," ").concat(p)})};!XA(u.attributes)&&!u.attributes["aria-hidden"]&&(_.attributes["aria-hidden"]="true"),f&&(_.attributes[ks]="");var b=V(V({},_),{},{prefix:r,iconName:i,main:n,mask:s,maskId:l,transform:o,symbol:a,styles:V({},u.styles)}),y=s.found&&n.found?ds("generateAbstractMask",b)||{children:[],attributes:{}}:ds("generateAbstractIcon",b)||{children:[],attributes:{}},T=y.children,x=y.attributes;return b.children=T,b.attributes=x,a?QA(b):GA(b)}function ed(e){var t=e.content,n=e.width,s=e.height,r=e.transform,i=e.extra,o=e.watchable,a=o===void 0?!1:o,l=V(V({},i.attributes),{},{class:i.classes.join(" ")});a&&(l[ks]="");var u=V({},i.styles);Ic(r)&&(u.transform=AA({transform:r,width:n,height:s}),u["-webkit-transform"]=u.transform);var c=Go(u);c.length>0&&(l.style=c);var f=[];return f.push({tag:"span",attributes:l,children:[t]}),f}function JA(e){var t=e.content,n=e.extra,s=V(V({},n.attributes),{},{class:n.classes.join(" ")}),r=Go(n.styles);r.length>0&&(s.style=r);var i=[];return i.push({tag:"span",attributes:s,children:[t]}),i}var Wa=on.styles;function $l(e){var t=e[0],n=e[1],s=e.slice(4),r=Yo(s,1),i=r[0],o=null;return Array.isArray(i)?o={tag:"g",attributes:{class:"".concat(he.cssPrefix,"-").concat(Ha.GROUP)},children:[{tag:"path",attributes:{class:"".concat(he.cssPrefix,"-").concat(Ha.SECONDARY),fill:"currentColor",d:i[0]}},{tag:"path",attributes:{class:"".concat(he.cssPrefix,"-").concat(Ha.PRIMARY),fill:"currentColor",d:i[1]}}]}:o={tag:"path",attributes:{fill:"currentColor",d:i}},{found:!0,width:t,height:n,icon:o}}var ZA={found:!1,width:512,height:512};function eO(e,t){!Vg&&!he.showMissingIcons&&e&&console.error('Icon with name "'.concat(e,'" and prefix "').concat(t,'" is missing.'))}function Ml(e,t){var n=t;return t==="fa"&&he.styleDefault!==null&&(t=fs()),new Promise(function(s,r){if(n==="fa"){var i=om(e)||{};e=i.iconName||e,t=i.prefix||t}if(e&&t&&Wa[t]&&Wa[t][e]){var o=Wa[t][e];return s($l(o))}eO(e,t),s(V(V({},ZA),{},{icon:he.showMissingIcons&&e?ds("missingIconAbstract")||{}:{}}))})}var td=function(){},Nl=he.measurePerformance&&Fi&&Fi.mark&&Fi.measure?Fi:{mark:td,measure:td},Nr='FA "7.0.0"',tO=function(t){return Nl.mark("".concat(Nr," ").concat(t," begins")),function(){return cm(t)}},cm=function(t){Nl.mark("".concat(Nr," ").concat(t," ends")),Nl.measure("".concat(Nr," ").concat(t),"".concat(Nr," ").concat(t," begins"),"".concat(Nr," ").concat(t," ends"))},Fc={begin:tO,end:cm},Xi=function(){};function nd(e){var t=e.getAttribute?e.getAttribute(ks):null;return typeof t=="string"}function nO(e){var t=e.getAttribute?e.getAttribute(Mc):null,n=e.getAttribute?e.getAttribute(Nc):null;return t&&n}function sO(e){return e&&e.classList&&e.classList.contains&&e.classList.contains(he.replacementClass)}function rO(){if(he.autoReplaceSvg===!0)return Ji.replace;var e=Ji[he.autoReplaceSvg];return e||Ji.replace}function iO(e){return Ge.createElementNS("http://www.w3.org/2000/svg",e)}function oO(e){return Ge.createElement(e)}function um(e){var t=arguments.length>1&&arguments[1]!==void 0?arguments[1]:{},n=t.ceFn,s=n===void 0?e.tag==="svg"?iO:oO:n;if(typeof e=="string")return Ge.createTextNode(e);var r=s(e.tag);Object.keys(e.attributes||[]).forEach(function(o){r.setAttribute(o,e.attributes[o])});var i=e.children||[];return i.forEach(function(o){r.appendChild(um(o,{ceFn:s}))}),r}function aO(e){var t=" ".concat(e.outerHTML," ");return t="".concat(t,"Font Awesome fontawesome.com "),t}var Ji={replace:function(t){var n=t[0];if(n.parentNode)if(t[1].forEach(function(r){n.parentNode.insertBefore(um(r),n)}),n.getAttribute(ks)===null&&he.keepOriginalSource){var s=Ge.createComment(aO(n));n.parentNode.replaceChild(s,n)}else n.remove()},nest:function(t){var n=t[0],s=t[1];if(~kc(n).indexOf(he.replacementClass))return Ji.replace(t);var r=new RegExp("".concat(he.cssPrefix,"-.*"));if(delete s[0].attributes.id,s[0].attributes.class){var i=s[0].attributes.class.split(" ").reduce(function(a,l){return l===he.replacementClass||l.match(r)?a.toSvg.push(l):a.toNode.push(l),a},{toNode:[],toSvg:[]});s[0].attributes.class=i.toSvg.join(" "),i.toNode.length===0?n.removeAttribute("class"):n.setAttribute("class",i.toNode.join(" "))}var o=s.map(function(a){return vi(a)}).join(\`
\`);n.setAttribute(ks,""),n.innerHTML=o}};function sd(e){e()}function fm(e,t){var n=typeof t=="function"?t:Xi;if(e.length===0)n();else{var s=sd;he.mutateApproach===uA&&(s=us.requestAnimationFrame||sd),s(function(){var r=rO(),i=Fc.begin("mutate");e.map(r),i(),n()})}}var zc=!1;function dm(){zc=!0}function kl(){zc=!1}var bo=null;function rd(e){if(Vf&&he.observeMutations){var t=e.treeCallback,n=t===void 0?Xi:t,s=e.nodeCallback,r=s===void 0?Xi:s,i=e.pseudoElementsCallback,o=i===void 0?Xi:i,a=e.observeMutationsRoot,l=a===void 0?Ge:a;bo=new Vf(function(u){if(!zc){var c=fs();Er(u).forEach(function(f){if(f.type==="childList"&&f.addedNodes.length>0&&!nd(f.addedNodes[0])&&(he.searchPseudoElements&&o(f.target),n(f.target)),f.type==="attributes"&&f.target.parentNode&&he.searchPseudoElements&&o([f.target],!0),f.type==="attributes"&&nd(f.target)&&~mA.indexOf(f.attributeName))if(f.attributeName==="class"&&nO(f.target)){var d=Xo(kc(f.target)),h=d.prefix,p=d.iconName;f.target.setAttribute(Mc,h||c),p&&f.target.setAttribute(Nc,p)}else sO(f.target)&&r(f.target)})}}),Un&&bo.observe(l,{childList:!0,attributes:!0,characterData:!0,subtree:!0})}}function lO(){bo&&bo.disconnect()}function cO(e){var t=e.getAttribute("style"),n=[];return t&&(n=t.split(";").reduce(function(s,r){var i=r.split(":"),o=i[0],a=i.slice(1);return o&&a.length>0&&(s[o]=a.join(":").trim()),s},{})),n}function uO(e){var t=e.getAttribute("data-prefix"),n=e.getAttribute("data-icon"),s=e.innerText!==void 0?e.innerText.trim():"",r=Xo(kc(e));return r.prefix||(r.prefix=fs()),t&&n&&(r.prefix=t,r.iconName=n),r.iconName&&r.prefix||(r.prefix&&s.length>0&&(r.iconName=IA(r.prefix,e.innerText)||Lc(r.prefix,Xg(e.innerText))),!r.iconName&&he.autoFetchSvg&&e.firstChild&&e.firstChild.nodeType===Node.TEXT_NODE&&(r.iconName=e.firstChild.data)),r}function fO(e){var t=Er(e.attributes).reduce(function(n,s){return n.name!=="class"&&n.name!=="style"&&(n[s.name]=s.value),n},{});return t}function dO(){return{iconName:null,prefix:null,transform:_n,symbol:!1,mask:{iconName:null,prefix:null,rest:[]},maskId:null,extra:{classes:[],styles:{},attributes:{}}}}function id(e){var t=arguments.length>1&&arguments[1]!==void 0?arguments[1]:{styleParser:!0},n=uO(e),s=n.iconName,r=n.prefix,i=n.rest,o=fO(e),a=Cl("parseNodeAttributes",{},e),l=t.styleParser?cO(e):[];return V({iconName:s,prefix:r,transform:_n,mask:{iconName:null,prefix:null,rest:[]},maskId:null,symbol:!1,extra:{classes:i,styles:l,attributes:o}},a)}var hO=on.styles;function hm(e){var t=he.autoReplaceSvg==="nest"?id(e,{styleParser:!1}):id(e);return~t.extra.classes.indexOf(Ug)?ds("generateLayersText",e,t):ds("generateSvgReplacementMutation",e,t)}function pO(){return[].concat(dn(Lg),dn(Dg))}function od(e){var t=arguments.length>1&&arguments[1]!==void 0?arguments[1]:null;if(!Un)return Promise.resolve();var n=Ge.documentElement.classList,s=function(f){return n.add("".concat(Uf,"-").concat(f))},r=function(f){return n.remove("".concat(Uf,"-").concat(f))},i=he.autoFetchSvg?pO():Eg.concat(Object.keys(hO));i.includes("fa")||i.push("fa");var o=[".".concat(Ug,":not([").concat(ks,"])")].concat(i.map(function(c){return".".concat(c,":not([").concat(ks,"])")})).join(", ");if(o.length===0)return Promise.resolve();var a=[];try{a=Er(e.querySelectorAll(o))}catch{}if(a.length>0)s("pending"),r("complete");else return Promise.resolve();var l=Fc.begin("onTree"),u=a.reduce(function(c,f){try{var d=hm(f);d&&c.push(d)}catch(h){Vg||h.name==="MissingIcon"&&console.error(h)}return c},[]);return new Promise(function(c,f){Promise.all(u).then(function(d){fm(d,function(){s("active"),s("complete"),r("pending"),typeof t=="function"&&t(),l(),c()})}).catch(function(d){l(),f(d)})})}function gO(e){var t=arguments.length>1&&arguments[1]!==void 0?arguments[1]:null;hm(e).then(function(n){n&&fm([n],t)})}function mO(e){return function(t){var n=arguments.length>1&&arguments[1]!==void 0?arguments[1]:{},s=(t||{}).icon?t:Rl(t||{}),r=n.mask;return r&&(r=(r||{}).icon?r:Rl(r||{})),e(s,V(V({},n),{},{mask:r}))}}var vO=function(t){var n=arguments.length>1&&arguments[1]!==void 0?arguments[1]:{},s=n.transform,r=s===void 0?_n:s,i=n.symbol,o=i===void 0?!1:i,a=n.mask,l=a===void 0?null:a,u=n.maskId,c=u===void 0?null:u,f=n.classes,d=f===void 0?[]:f,h=n.attributes,p=h===void 0?{}:h,g=n.styles,_=g===void 0?{}:g;if(t){var b=t.prefix,y=t.iconName,T=t.icon;return Jo(V({type:"icon"},t),function(){return Is("beforeDOMElementCreation",{iconDefinition:t,params:n}),Dc({icons:{main:$l(T),mask:l?$l(l.icon):{found:!1,width:null,height:null,icon:{}}},prefix:b,iconName:y,transform:V(V({},_n),r),symbol:o,maskId:c,extra:{attributes:p,styles:_,classes:d}})})}},bO={mixout:function(){return{icon:mO(vO)}},hooks:function(){return{mutationObserverCallbacks:function(n){return n.treeCallback=od,n.nodeCallback=gO,n}}},provides:function(t){t.i2svg=function(n){var s=n.node,r=s===void 0?Ge:s,i=n.callback,o=i===void 0?function(){}:i;return od(r,o)},t.generateSvgReplacementMutation=function(n,s){var r=s.iconName,i=s.prefix,o=s.transform,a=s.symbol,l=s.mask,u=s.maskId,c=s.extra;return new Promise(function(f,d){Promise.all([Ml(r,i),l.iconName?Ml(l.iconName,l.prefix):Promise.resolve({found:!1,width:512,height:512,icon:{}})]).then(function(h){var p=Yo(h,2),g=p[0],_=p[1];f([n,Dc({icons:{main:g,mask:_},prefix:i,iconName:r,transform:o,symbol:a,maskId:u,extra:c,watchable:!0})])}).catch(d)})},t.generateAbstractIcon=function(n){var s=n.children,r=n.attributes,i=n.main,o=n.transform,a=n.styles,l=Go(a);l.length>0&&(r.style=l);var u;return Ic(o)&&(u=ds("generateAbstractTransformGrouping",{main:i,transform:o,containerWidth:i.width,iconWidth:i.width})),s.push(u||i.icon),{children:s,attributes:r}}}},yO={mixout:function(){return{layer:function(n){var s=arguments.length>1&&arguments[1]!==void 0?arguments[1]:{},r=s.classes,i=r===void 0?[]:r;return Jo({type:"layer"},function(){Is("beforeDOMElementCreation",{assembler:n,params:s});var o=[];return n(function(a){Array.isArray(a)?a.map(function(l){o=o.concat(l.abstract)}):o=o.concat(a.abstract)}),[{tag:"span",attributes:{class:["".concat(he.cssPrefix,"-layers")].concat(dn(i)).join(" ")},children:o}]})}}}},_O={mixout:function(){return{counter:function(n){var s=arguments.length>1&&arguments[1]!==void 0?arguments[1]:{};s.title;var r=s.classes,i=r===void 0?[]:r,o=s.attributes,a=o===void 0?{}:o,l=s.styles,u=l===void 0?{}:l;return Jo({type:"counter",content:n},function(){return Is("beforeDOMElementCreation",{content:n,params:s}),JA({content:n.toString(),extra:{attributes:a,styles:u,classes:["".concat(he.cssPrefix,"-layers-counter")].concat(dn(i))}})})}}}},EO={mixout:function(){return{text:function(n){var s=arguments.length>1&&arguments[1]!==void 0?arguments[1]:{},r=s.transform,i=r===void 0?_n:r,o=s.classes,a=o===void 0?[]:o,l=s.attributes,u=l===void 0?{}:l,c=s.styles,f=c===void 0?{}:c;return Jo({type:"text",content:n},function(){return Is("beforeDOMElementCreation",{content:n,params:s}),ed({content:n,transform:V(V({},_n),i),extra:{attributes:u,styles:f,classes:["".concat(he.cssPrefix,"-layers-text")].concat(dn(a))}})})}}},provides:function(t){t.generateLayersText=function(n,s){var r=s.transform,i=s.extra,o=null,a=null;if(yg){var l=parseInt(getComputedStyle(n).fontSize,10),u=n.getBoundingClientRect();o=u.width/l,a=u.height/l}return Promise.resolve([n,ed({content:n.innerHTML,width:o,height:a,transform:r,extra:i,watchable:!0})])}}},pm=new RegExp('"',"ug"),ad=[1105920,1112319],ld=V(V(V(V({},{FontAwesome:{normal:"fas",400:"fas"}}),cT),lA),bT),Il=Object.keys(ld).reduce(function(e,t){return e[t.toLowerCase()]=ld[t],e},{}),wO=Object.keys(Il).reduce(function(e,t){var n=Il[t];return e[t]=n[900]||dn(Object.entries(n))[0][1],e},{});function SO(e){var t=e.replace(pm,"");return Xg(dn(t)[0]||"")}function xO(e){var t=e.getPropertyValue("font-feature-settings").includes("ss01"),n=e.getPropertyValue("content"),s=n.replace(pm,""),r=s.codePointAt(0),i=r>=ad[0]&&r<=ad[1],o=s.length===2?s[0]===s[1]:!1;return i||o||t}function TO(e,t){var n=e.replace(/^['"]|['"]$/g,"").toLowerCase(),s=parseInt(t),r=isNaN(s)?"normal":s;return(Il[n]||{})[r]||wO[n]}function cd(e,t){var n="".concat(cA).concat(t.replace(":","-"));return new Promise(function(s,r){if(e.getAttribute(n)!==null)return s();var i=Er(e.children),o=i.filter(function($){return $.getAttribute(xl)===t})[0],a=us.getComputedStyle(e,t),l=a.getPropertyValue("font-family"),u=l.match(pA),c=a.getPropertyValue("font-weight"),f=a.getPropertyValue("content");if(o&&!u)return e.removeChild(o),s();if(u&&f!=="none"&&f!==""){var d=a.getPropertyValue("content"),h=TO(l,c),p=SO(d),g=u[0].startsWith("FontAwesome"),_=xO(a),b=Lc(h,p),y=b;if(g){var T=PA(p);T.iconName&&T.prefix&&(b=T.iconName,h=T.prefix)}if(b&&!_&&(!o||o.getAttribute(Mc)!==h||o.getAttribute(Nc)!==y)){e.setAttribute(n,y),o&&e.removeChild(o);var x=dO(),O=x.extra;O.attributes[xl]=t,Ml(b,h).then(function($){var F=Dc(V(V({},x),{},{icons:{main:$,mask:am()},prefix:h,iconName:y,extra:O,watchable:!0})),Q=Ge.createElementNS("http://www.w3.org/2000/svg","svg");t==="::before"?e.insertBefore(Q,e.firstChild):e.appendChild(Q),Q.outerHTML=F.map(function(P){return vi(P)}).join(\`
\`),e.removeAttribute(n),s()}).catch(r)}else s()}else s()})}function AO(e){return Promise.all([cd(e,"::before"),cd(e,"::after")])}function OO(e){return e.parentNode!==document.head&&!~fA.indexOf(e.tagName.toUpperCase())&&!e.getAttribute(xl)&&(!e.parentNode||e.parentNode.tagName!=="svg")}var CO=function(t){return!!t&&Hg.some(function(n){return t.includes(n)})},RO=function(t){if(!t)return[];for(var n=new Set,s=[t],r=[/(?=\\s:)/,/(?<=\\)\\)?[^,]*,)/],i=function(){var h=a[o];s=s.flatMap(function(p){return p.split(h).map(function(g){return g.replace(/,\\s*$/,"").trim()})})},o=0,a=r;o<a.length;o++)i();s=s.flatMap(function(d){return d.includes("(")?d:d.split(",").map(function(h){return h.trim()})});var l=Qi(s),u;try{for(l.s();!(u=l.n()).done;){var c=u.value;if(CO(c)){var f=Hg.reduce(function(d,h){return d.replace(h,"")},c);f!==""&&f!=="*"&&n.add(f)}}}catch(d){l.e(d)}finally{l.f()}return n};function ud(e){var t=arguments.length>1&&arguments[1]!==void 0?arguments[1]:!1;if(Un){var n;if(t)n=e;else if(he.searchPseudoElementsFullScan)n=e.querySelectorAll("*");else{var s=new Set,r=Qi(document.styleSheets),i;try{for(r.s();!(i=r.n()).done;){var o=i.value;try{var a=Qi(o.cssRules),l;try{for(a.s();!(l=a.n()).done;){var u=l.value,c=RO(u.selectorText),f=Qi(c),d;try{for(f.s();!(d=f.n()).done;){var h=d.value;s.add(h)}}catch(g){f.e(g)}finally{f.f()}}}catch(g){a.e(g)}finally{a.f()}}catch(g){he.searchPseudoElementsWarnings&&console.warn("Font Awesome: cannot parse stylesheet: ".concat(o.href," (").concat(g.message,\`)
If it declares any Font Awesome CSS pseudo-elements, they will not be rendered as SVG icons. Add crossorigin="anonymous" to the <link>, enable searchPseudoElementsFullScan for slower but more thorough DOM parsing, or suppress this warning by setting searchPseudoElementsWarnings to false.\`))}}}catch(g){r.e(g)}finally{r.f()}if(!s.size)return;var p=Array.from(s).join(", ");try{n=e.querySelectorAll(p)}catch{}}return new Promise(function(g,_){var b=Er(n).filter(OO).map(AO),y=Fc.begin("searchPseudoElements");dm(),Promise.all(b).then(function(){y(),kl(),g()}).catch(function(){y(),kl(),_()})})}}var $O={hooks:function(){return{mutationObserverCallbacks:function(n){return n.pseudoElementsCallback=ud,n}}},provides:function(t){t.pseudoElements2svg=function(n){var s=n.node,r=s===void 0?Ge:s;he.searchPseudoElements&&ud(r)}}},fd=!1,MO={mixout:function(){return{dom:{unwatch:function(){dm(),fd=!0}}}},hooks:function(){return{bootstrap:function(){rd(Cl("mutationObserverCallbacks",{}))},noAuto:function(){lO()},watch:function(n){var s=n.observeMutationsRoot;fd?kl():rd(Cl("mutationObserverCallbacks",{observeMutationsRoot:s}))}}}},dd=function(t){var n={size:16,x:0,y:0,flipX:!1,flipY:!1,rotate:0};return t.toLowerCase().split(" ").reduce(function(s,r){var i=r.toLowerCase().split("-"),o=i[0],a=i.slice(1).join("-");if(o&&a==="h")return s.flipX=!0,s;if(o&&a==="v")return s.flipY=!0,s;if(a=parseFloat(a),isNaN(a))return s;switch(o){case"grow":s.size=s.size+a;break;case"shrink":s.size=s.size-a;break;case"left":s.x=s.x-a;break;case"right":s.x=s.x+a;break;case"up":s.y=s.y-a;break;case"down":s.y=s.y+a;break;case"rotate":s.rotate=s.rotate+a;break}return s},n)},NO={mixout:function(){return{parse:{transform:function(n){return dd(n)}}}},hooks:function(){return{parseNodeAttributes:function(n,s){var r=s.getAttribute("data-fa-transform");return r&&(n.transform=dd(r)),n}}},provides:function(t){t.generateAbstractTransformGrouping=function(n){var s=n.main,r=n.transform,i=n.containerWidth,o=n.iconWidth,a={transform:"translate(".concat(i/2," 256)")},l="translate(".concat(r.x*32,", ").concat(r.y*32,") "),u="scale(".concat(r.size/16*(r.flipX?-1:1),", ").concat(r.size/16*(r.flipY?-1:1),") "),c="rotate(".concat(r.rotate," 0 0)"),f={transform:"".concat(l," ").concat(u," ").concat(c)},d={transform:"translate(".concat(o/2*-1," -256)")},h={outer:a,inner:f,path:d};return{tag:"g",attributes:V({},h.outer),children:[{tag:"g",attributes:V({},h.inner),children:[{tag:s.icon.tag,children:s.icon.children,attributes:V(V({},s.icon.attributes),h.path)}]}]}}}},Ua={x:0,y:0,width:"100%",height:"100%"};function hd(e){var t=arguments.length>1&&arguments[1]!==void 0?arguments[1]:!0;return e.attributes&&(e.attributes.fill||t)&&(e.attributes.fill="black"),e}function kO(e){return e.tag==="g"?e.children:[e]}var IO={hooks:function(){return{parseNodeAttributes:function(n,s){var r=s.getAttribute("data-fa-mask"),i=r?Xo(r.split(" ").map(function(o){return o.trim()})):am();return i.prefix||(i.prefix=fs()),n.mask=i,n.maskId=s.getAttribute("data-fa-mask-id"),n}}},provides:function(t){t.generateAbstractMask=function(n){var s=n.children,r=n.attributes,i=n.main,o=n.mask,a=n.maskId,l=n.transform,u=i.width,c=i.icon,f=o.width,d=o.icon,h=TA({transform:l,containerWidth:f,iconWidth:u}),p={tag:"rect",attributes:V(V({},Ua),{},{fill:"white"})},g=c.children?{children:c.children.map(hd)}:{},_={tag:"g",attributes:V({},h.inner),children:[hd(V({tag:c.tag,attributes:V(V({},c.attributes),h.path)},g))]},b={tag:"g",attributes:V({},h.outer),children:[_]},y="mask-".concat(a||Kf()),T="clip-".concat(a||Kf()),x={tag:"mask",attributes:V(V({},Ua),{},{id:y,maskUnits:"userSpaceOnUse",maskContentUnits:"userSpaceOnUse"}),children:[p,b]},O={tag:"defs",children:[{tag:"clipPath",attributes:{id:T},children:kO(d)},x]};return s.push(O,{tag:"rect",attributes:V({fill:"currentColor","clip-path":"url(#".concat(T,")"),mask:"url(#".concat(y,")")},Ua)}),{children:s,attributes:r}}}},PO={provides:function(t){var n=!1;us.matchMedia&&(n=us.matchMedia("(prefers-reduced-motion: reduce)").matches),t.missingIconAbstract=function(){var s=[],r={fill:"currentColor"},i={attributeType:"XML",repeatCount:"indefinite",dur:"2s"};s.push({tag:"path",attributes:V(V({},r),{},{d:"M156.5,447.7l-12.6,29.5c-18.7-9.5-35.9-21.2-51.5-34.9l22.7-22.7C127.6,430.5,141.5,440,156.5,447.7z M40.6,272H8.5 c1.4,21.2,5.4,41.7,11.7,61.1L50,321.2C45.1,305.5,41.8,289,40.6,272z M40.6,240c1.4-18.8,5.2-37,11.1-54.1l-29.5-12.6 C14.7,194.3,10,216.7,8.5,240H40.6z M64.3,156.5c7.8-14.9,17.2-28.8,28.1-41.5L69.7,92.3c-13.7,15.6-25.5,32.8-34.9,51.5 L64.3,156.5z M397,419.6c-13.9,12-29.4,22.3-46.1,30.4l11.9,29.8c20.7-9.9,39.8-22.6,56.9-37.6L397,419.6z M115,92.4 c13.9-12,29.4-22.3,46.1-30.4l-11.9-29.8c-20.7,9.9-39.8,22.6-56.8,37.6L115,92.4z M447.7,355.5c-7.8,14.9-17.2,28.8-28.1,41.5 l22.7,22.7c13.7-15.6,25.5-32.9,34.9-51.5L447.7,355.5z M471.4,272c-1.4,18.8-5.2,37-11.1,54.1l29.5,12.6 c7.5-21.1,12.2-43.5,13.6-66.8H471.4z M321.2,462c-15.7,5-32.2,8.2-49.2,9.4v32.1c21.2-1.4,41.7-5.4,61.1-11.7L321.2,462z M240,471.4c-18.8-1.4-37-5.2-54.1-11.1l-12.6,29.5c21.1,7.5,43.5,12.2,66.8,13.6V471.4z M462,190.8c5,15.7,8.2,32.2,9.4,49.2h32.1 c-1.4-21.2-5.4-41.7-11.7-61.1L462,190.8z M92.4,397c-12-13.9-22.3-29.4-30.4-46.1l-29.8,11.9c9.9,20.7,22.6,39.8,37.6,56.9 L92.4,397z M272,40.6c18.8,1.4,36.9,5.2,54.1,11.1l12.6-29.5C317.7,14.7,295.3,10,272,8.5V40.6z M190.8,50 c15.7-5,32.2-8.2,49.2-9.4V8.5c-21.2,1.4-41.7,5.4-61.1,11.7L190.8,50z M442.3,92.3L419.6,115c12,13.9,22.3,29.4,30.5,46.1 l29.8-11.9C470,128.5,457.3,109.4,442.3,92.3z M397,92.4l22.7-22.7c-15.6-13.7-32.8-25.5-51.5-34.9l-12.6,29.5 C370.4,72.1,384.4,81.5,397,92.4z"})});var o=V(V({},i),{},{attributeName:"opacity"}),a={tag:"circle",attributes:V(V({},r),{},{cx:"256",cy:"364",r:"28"}),children:[]};return n||a.children.push({tag:"animate",attributes:V(V({},i),{},{attributeName:"r",values:"28;14;28;28;14;28;"})},{tag:"animate",attributes:V(V({},o),{},{values:"1;0;1;1;0;1;"})}),s.push(a),s.push({tag:"path",attributes:V(V({},r),{},{opacity:"1",d:"M263.7,312h-16c-6.6,0-12-5.4-12-12c0-71,77.4-63.9,77.4-107.8c0-20-17.8-40.2-57.4-40.2c-29.1,0-44.3,9.6-59.2,28.7 c-3.9,5-11.1,6-16.2,2.4l-13.1-9.2c-5.6-3.9-6.9-11.8-2.6-17.2c21.2-27.2,46.4-44.7,91.2-44.7c52.3,0,97.4,29.8,97.4,80.2 c0,67.6-77.4,63.5-77.4,107.8C275.7,306.6,270.3,312,263.7,312z"}),children:n?[]:[{tag:"animate",attributes:V(V({},o),{},{values:"1;0;0;0;0;1;"})}]}),n||s.push({tag:"path",attributes:V(V({},r),{},{opacity:"0",d:"M232.5,134.5l7,168c0.3,6.4,5.6,11.5,12,11.5h9c6.4,0,11.7-5.1,12-11.5l7-168c0.3-6.8-5.2-12.5-12-12.5h-23 C237.7,122,232.2,127.7,232.5,134.5z"}),children:[{tag:"animate",attributes:V(V({},o),{},{values:"0;0;1;1;0;0;"})}]}),{tag:"g",attributes:{class:"missing"},children:s}}}},LO={hooks:function(){return{parseNodeAttributes:function(n,s){var r=s.getAttribute("data-fa-symbol"),i=r===null?!1:r===""?!0:r;return n.symbol=i,n}}}},DO=[CA,bO,yO,_O,EO,$O,MO,NO,IO,PO,LO];WA(DO,{mixoutsTo:Wt});Wt.noAuto;Wt.config;Wt.library;Wt.dom;var Pl=Wt.parse;Wt.findIconDefinition;Wt.toHtml;var FO=Wt.icon;Wt.layer;Wt.text;Wt.counter;function yt(e,t,n){return(t=VO(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function pd(e,t){var n=Object.keys(e);if(Object.getOwnPropertySymbols){var s=Object.getOwnPropertySymbols(e);t&&(s=s.filter(function(r){return Object.getOwnPropertyDescriptor(e,r).enumerable})),n.push.apply(n,s)}return n}function Nn(e){for(var t=1;t<arguments.length;t++){var n=arguments[t]!=null?arguments[t]:{};t%2?pd(Object(n),!0).forEach(function(s){yt(e,s,n[s])}):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(n)):pd(Object(n)).forEach(function(s){Object.defineProperty(e,s,Object.getOwnPropertyDescriptor(n,s))})}return e}function zO(e,t){if(e==null)return{};var n,s,r=jO(e,t);if(Object.getOwnPropertySymbols){var i=Object.getOwnPropertySymbols(e);for(s=0;s<i.length;s++)n=i[s],t.indexOf(n)===-1&&{}.propertyIsEnumerable.call(e,n)&&(r[n]=e[n])}return r}function jO(e,t){if(e==null)return{};var n={};for(var s in e)if({}.hasOwnProperty.call(e,s)){if(t.indexOf(s)!==-1)continue;n[s]=e[s]}return n}function HO(e,t){if(typeof e!="object"||!e)return e;var n=e[Symbol.toPrimitive];if(n!==void 0){var s=n.call(e,t);if(typeof s!="object")return s;throw new TypeError("@@toPrimitive must return a primitive value.")}return(t==="string"?String:Number)(e)}function VO(e){var t=HO(e,"string");return typeof t=="symbol"?t:t+""}function yo(e){"@babel/helpers - typeof";return yo=typeof Symbol=="function"&&typeof Symbol.iterator=="symbol"?function(t){return typeof t}:function(t){return t&&typeof Symbol=="function"&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},yo(e)}function qa(e,t){return Array.isArray(t)&&t.length>0||!Array.isArray(t)&&t?yt({},e,t):{}}function BO(e){var t,n=(t={"fa-spin":e.spin,"fa-pulse":e.pulse,"fa-fw":e.fixedWidth,"fa-border":e.border,"fa-li":e.listItem,"fa-inverse":e.inverse,"fa-flip":e.flip===!0,"fa-flip-horizontal":e.flip==="horizontal"||e.flip==="both","fa-flip-vertical":e.flip==="vertical"||e.flip==="both"},yt(yt(yt(yt(yt(yt(yt(yt(yt(yt(t,"fa-".concat(e.size),e.size!==null),"fa-rotate-".concat(e.rotation),e.rotation!==null),"fa-rotate-by",e.rotateBy),"fa-pull-".concat(e.pull),e.pull!==null),"fa-swap-opacity",e.swapOpacity),"fa-bounce",e.bounce),"fa-shake",e.shake),"fa-beat",e.beat),"fa-fade",e.fade),"fa-beat-fade",e.beatFade),yt(yt(yt(yt(t,"fa-flash",e.flash),"fa-spin-pulse",e.spinPulse),"fa-spin-reverse",e.spinReverse),"fa-width-auto",e.widthAuto));return Object.keys(n).map(function(s){return n[s]?s:null}).filter(function(s){return s})}var WO=typeof globalThis<"u"?globalThis:typeof window<"u"?window:typeof global<"u"?global:typeof self<"u"?self:{},gm={exports:{}};(function(e){(function(t){var n=function(b,y,T){if(!u(y)||f(y)||d(y)||h(y)||l(y))return y;var x,O=0,$=0;if(c(y))for(x=[],$=y.length;O<$;O++)x.push(n(b,y[O],T));else{x={};for(var F in y)Object.prototype.hasOwnProperty.call(y,F)&&(x[b(F,T)]=n(b,y[F],T))}return x},s=function(b,y){y=y||{};var T=y.separator||"_",x=y.split||/(?=[A-Z])/;return b.split(x).join(T)},r=function(b){return p(b)?b:(b=b.replace(/[\\-_\\s]+(.)?/g,function(y,T){return T?T.toUpperCase():""}),b.substr(0,1).toLowerCase()+b.substr(1))},i=function(b){var y=r(b);return y.substr(0,1).toUpperCase()+y.substr(1)},o=function(b,y){return s(b,y).toLowerCase()},a=Object.prototype.toString,l=function(b){return typeof b=="function"},u=function(b){return b===Object(b)},c=function(b){return a.call(b)=="[object Array]"},f=function(b){return a.call(b)=="[object Date]"},d=function(b){return a.call(b)=="[object RegExp]"},h=function(b){return a.call(b)=="[object Boolean]"},p=function(b){return b=b-0,b===b},g=function(b,y){var T=y&&"process"in y?y.process:y;return typeof T!="function"?b:function(x,O){return T(x,b,O)}},_={camelize:r,decamelize:o,pascalize:i,depascalize:o,camelizeKeys:function(b,y){return n(g(r,y),b)},decamelizeKeys:function(b,y){return n(g(o,y),b,y)},pascalizeKeys:function(b,y){return n(g(i,y),b)},depascalizeKeys:function(){return this.decamelizeKeys.apply(this,arguments)}};e.exports?e.exports=_:t.humps=_})(WO)})(gm);var UO=gm.exports,qO=["class","style"];function KO(e){return e.split(";").map(function(t){return t.trim()}).filter(function(t){return t}).reduce(function(t,n){var s=n.indexOf(":"),r=UO.camelize(n.slice(0,s)),i=n.slice(s+1).trim();return t[r]=i,t},{})}function YO(e){return e.split(/\\s+/).reduce(function(t,n){return t[n]=!0,t},{})}function mm(e){var t=arguments.length>1&&arguments[1]!==void 0?arguments[1]:{},n=arguments.length>2&&arguments[2]!==void 0?arguments[2]:{};if(typeof e=="string")return e;var s=(e.children||[]).map(function(l){return mm(l)}),r=Object.keys(e.attributes||{}).reduce(function(l,u){var c=e.attributes[u];switch(u){case"class":l.class=YO(c);break;case"style":l.style=KO(c);break;default:l.attrs[u]=c}return l},{attrs:{},class:{},style:{}});n.class;var i=n.style,o=i===void 0?{}:i,a=zO(n,qO);return Fo(e.tag,Nn(Nn(Nn({},t),{},{class:r.class,style:Nn(Nn({},r.style),o)},r.attrs),a),s)}var vm=!1;try{vm=!0}catch{}function GO(){if(!vm&&console&&typeof console.error=="function"){var e;(e=console).error.apply(e,arguments)}}function gd(e){if(e&&yo(e)==="object"&&e.prefix&&e.iconName&&e.icon)return e;if(Pl.icon)return Pl.icon(e);if(e===null)return null;if(yo(e)==="object"&&e.prefix&&e.iconName)return e;if(Array.isArray(e)&&e.length===2)return{prefix:e[0],iconName:e[1]};if(typeof e=="string")return{prefix:"fas",iconName:e}}var ft=at({name:"FontAwesomeIcon",props:{border:{type:Boolean,default:!1},fixedWidth:{type:Boolean,default:!1},flip:{type:[Boolean,String],default:!1,validator:function(t){return[!0,!1,"horizontal","vertical","both"].indexOf(t)>-1}},icon:{type:[Object,Array,String],required:!0},mask:{type:[Object,Array,String],default:null},maskId:{type:String,default:null},listItem:{type:Boolean,default:!1},pull:{type:String,default:null,validator:function(t){return["right","left"].indexOf(t)>-1}},pulse:{type:Boolean,default:!1},rotation:{type:[String,Number],default:null,validator:function(t){return[90,180,270].indexOf(Number.parseInt(t,10))>-1}},rotateBy:{type:Boolean,default:!1},swapOpacity:{type:Boolean,default:!1},size:{type:String,default:null,validator:function(t){return["2xs","xs","sm","lg","xl","2xl","1x","2x","3x","4x","5x","6x","7x","8x","9x","10x"].indexOf(t)>-1}},spin:{type:Boolean,default:!1},transform:{type:[String,Object],default:null},symbol:{type:[Boolean,String],default:!1},title:{type:String,default:null},titleId:{type:String,default:null},inverse:{type:Boolean,default:!1},bounce:{type:Boolean,default:!1},shake:{type:Boolean,default:!1},beat:{type:Boolean,default:!1},fade:{type:Boolean,default:!1},beatFade:{type:Boolean,default:!1},flash:{type:Boolean,default:!1},spinPulse:{type:Boolean,default:!1},spinReverse:{type:Boolean,default:!1},widthAuto:{type:Boolean,default:!1}},setup:function(t,n){var s=n.attrs,r=xe(function(){return gd(t.icon)}),i=xe(function(){return qa("classes",BO(t))}),o=xe(function(){return qa("transform",typeof t.transform=="string"?Pl.transform(t.transform):t.transform)}),a=xe(function(){return qa("mask",gd(t.mask))}),l=xe(function(){var c=Nn(Nn(Nn(Nn({},i.value),o.value),a.value),{},{symbol:t.symbol,maskId:t.maskId});return c.title=t.title,c.titleId=t.titleId,FO(r.value,c)});Je(l,function(c){if(!c)return GO("Could not find one or more icon(s)",r.value,a.value)},{immediate:!0});var u=xe(function(){return l.value?mm(l.value.abstract[0],{},s):null});return function(){return u.value}}});const QO={xmlns:"http://www.w3.org/2000/svg",fill:"none",viewBox:"0 0 512 512"};function XO(e,t){return H(),oe("svg",QO,[...t[0]||(t[0]=[w("g",{"clip-path":"url(#a)"},[w("path",{stroke:"currentColor","stroke-linejoin":"round","stroke-width":"42",d:"m196.487 458.003-.139.062a10.76 10.76 0 0 1-11.663-1.842l-.037-.033-160-144-.025-.022C22.299 310.083 21 307.183 21 304c0-3.033 1.29-6.028 3.705-8.242l.033-.03 159.855-143.87.021-.018c3.215-2.859 7.819-3.626 11.934-1.816 3.888 1.709 6.452 5.609 6.452 9.976v64c0 11.598 9.402 21 21 21h96c64.598 0 117-52.402 117-117 0-36.638-15.507-59.279-28.22-71.532C432.95 71.608 491 117.293 491 208c0 85.602-69.398 155-155 155H224c-11.598 0-21 9.402-21 21v64c0 4.279-2.591 8.263-6.513 10.003ZM404.991 51.557Z"})],-1),w("defs",null,[w("clipPath",{id:"a"},[w("path",{d:"M512 512H0V0h512z"})])],-1)])])}const JO={render:XO};/*!
 * Font Awesome Free 7.0.1 by @fontawesome - https://fontawesome.com
 * License - https://fontawesome.com/license/free (Icons: CC BY 4.0, Fonts: SIL OFL 1.1, Code: MIT License)
 * Copyright 2025 Fonticons, Inc.
 */var ZO={prefix:"fas",iconName:"filter",icon:[512,512,[],"f0b0","M32 64C19.1 64 7.4 71.8 2.4 83.8S.2 109.5 9.4 118.6L192 301.3 192 416c0 8.5 3.4 16.6 9.4 22.6l64 64c9.2 9.2 22.9 11.9 34.9 6.9S320 492.9 320 480l0-178.7 182.6-182.6c9.2-9.2 11.9-22.9 6.9-34.9S492.9 64 480 64L32 64z"]},eC={prefix:"fas",iconName:"cloud-arrow-up",icon:[576,512,[62338,"cloud-upload","cloud-upload-alt"],"f0ee","M144 480c-79.5 0-144-64.5-144-144 0-63.4 41-117.2 97.9-136.5-1.3-7.7-1.9-15.5-1.9-23.5 0-79.5 64.5-144 144-144 55.4 0 103.5 31.3 127.6 77.1 14.2-8.3 30.8-13.1 48.4-13.1 53 0 96 43 96 96 0 15.7-3.8 30.6-10.5 43.7 44 20.3 74.5 64.7 74.5 116.3 0 70.7-57.3 128-128 128l-304 0zM305 191c-9.4-9.4-24.6-9.4-33.9 0l-72 72c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l31-31 0 102.1c0 13.3 10.7 24 24 24s24-10.7 24-24l0-102.1 31 31c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-72-72z"]},tC=eC,nC={prefix:"fas",iconName:"power-off",icon:[512,512,[9211],"f011","M288 0c0-17.7-14.3-32-32-32S224-17.7 224 0l0 256c0 17.7 14.3 32 32 32s32-14.3 32-32L288 0zM146.3 98.4c14.5-10.1 18-30.1 7.9-44.6s-30.1-18-44.6-7.9C43.4 92.1 0 169 0 256 0 397.4 114.6 512 256 512S512 397.4 512 256c0-87-43.4-163.9-109.7-210.1-14.5-10.1-34.4-6.6-44.6 7.9s-6.6 34.4 7.9 44.6c49.8 34.8 82.3 92.4 82.3 157.6 0 106-86 192-192 192S64 362 64 256c0-65.2 32.5-122.9 82.3-157.6z"]},sC={prefix:"fas",iconName:"magnifying-glass",icon:[512,512,[128269,"search"],"f002","M416 208c0 45.9-14.9 88.3-40 122.7L502.6 457.4c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0L330.7 376C296.3 401.1 253.9 416 208 416 93.1 416 0 322.9 0 208S93.1 0 208 0 416 93.1 416 208zM208 352a144 144 0 1 0 0-288 144 144 0 1 0 0 288z"]},rC=sC,iC={prefix:"fas",iconName:"share",icon:[512,512,["mail-forward"],"f064","M307.8 18.4c-12 5-19.8 16.6-19.8 29.6l0 80-112 0c-97.2 0-176 78.8-176 176 0 113.3 81.5 163.9 100.2 174.1 2.5 1.4 5.3 1.9 8.1 1.9 10.9 0 19.7-8.9 19.7-19.7 0-7.5-4.3-14.4-9.8-19.5-9.4-8.8-22.2-26.4-22.2-56.7 0-53 43-96 96-96l96 0 0 80c0 12.9 7.8 24.6 19.8 29.6s25.7 2.2 34.9-6.9l160-160c12.5-12.5 12.5-32.8 0-45.3l-160-160c-9.2-9.2-22.9-11.9-34.9-6.9z"]},bm={prefix:"fas",iconName:"circle-exclamation",icon:[512,512,["exclamation-circle"],"f06a","M256 512a256 256 0 1 1 0-512 256 256 0 1 1 0 512zm0-192a32 32 0 1 0 0 64 32 32 0 1 0 0-64zm0-192c-18.2 0-32.7 15.5-31.4 33.7l7.4 104c.9 12.6 11.4 22.3 23.9 22.3 12.6 0 23-9.7 23.9-22.3l7.4-104c1.3-18.2-13.1-33.7-31.4-33.7z"]},oC={prefix:"fas",iconName:"gear",icon:[512,512,[9881,"cog"],"f013","M195.1 9.5C198.1-5.3 211.2-16 226.4-16l59.8 0c15.2 0 28.3 10.7 31.3 25.5L332 79.5c14.1 6 27.3 13.7 39.3 22.8l67.8-22.5c14.4-4.8 30.2 1.2 37.8 14.4l29.9 51.8c7.6 13.2 4.9 29.8-6.5 39.9L447 233.3c.9 7.4 1.3 15 1.3 22.7s-.5 15.3-1.3 22.7l53.4 47.5c11.4 10.1 14 26.8 6.5 39.9l-29.9 51.8c-7.6 13.1-23.4 19.2-37.8 14.4l-67.8-22.5c-12.1 9.1-25.3 16.7-39.3 22.8l-14.4 69.9c-3.1 14.9-16.2 25.5-31.3 25.5l-59.8 0c-15.2 0-28.3-10.7-31.3-25.5l-14.4-69.9c-14.1-6-27.2-13.7-39.3-22.8L73.5 432.3c-14.4 4.8-30.2-1.2-37.8-14.4L5.8 366.1c-7.6-13.2-4.9-29.8 6.5-39.9l53.4-47.5c-.9-7.4-1.3-15-1.3-22.7s.5-15.3 1.3-22.7L12.3 185.8c-11.4-10.1-14-26.8-6.5-39.9L35.7 94.1c7.6-13.2 23.4-19.2 37.8-14.4l67.8 22.5c12.1-9.1 25.3-16.7 39.3-22.8L195.1 9.5zM256.3 336a80 80 0 1 0 -.6-160 80 80 0 1 0 .6 160z"]},ym={prefix:"fas",iconName:"trash-can",icon:[448,512,[61460,"trash-alt"],"f2ed","M136.7 5.9C141.1-7.2 153.3-16 167.1-16l113.9 0c13.8 0 26 8.8 30.4 21.9L320 32 416 32c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 96C14.3 96 0 81.7 0 64S14.3 32 32 32l96 0 8.7-26.1zM32 144l384 0 0 304c0 35.3-28.7 64-64 64L96 512c-35.3 0-64-28.7-64-64l0-304zm88 64c-13.3 0-24 10.7-24 24l0 192c0 13.3 10.7 24 24 24s24-10.7 24-24l0-192c0-13.3-10.7-24-24-24zm104 0c-13.3 0-24 10.7-24 24l0 192c0 13.3 10.7 24 24 24s24-10.7 24-24l0-192c0-13.3-10.7-24-24-24zm104 0c-13.3 0-24 10.7-24 24l0 192c0 13.3 10.7 24 24 24s24-10.7 24-24l0-192c0-13.3-10.7-24-24-24z"]},md={prefix:"fas",iconName:"arrow-right",icon:[512,512,[8594],"f061","M502.6 278.6c12.5-12.5 12.5-32.8 0-45.3l-160-160c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L402.7 224 32 224c-17.7 0-32 14.3-32 32s14.3 32 32 32l370.7 0-105.4 105.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l160-160z"]},_m={prefix:"fas",iconName:"circle-check",icon:[512,512,[61533,"check-circle"],"f058","M256 512a256 256 0 1 1 0-512 256 256 0 1 1 0 512zM374 145.7c-10.7-7.8-25.7-5.4-33.5 5.3L221.1 315.2 169 263.1c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l72 72c5 5 11.8 7.5 18.8 7s13.4-4.1 17.5-9.8L379.3 179.2c7.8-10.7 5.4-25.7-5.3-33.5z"]},aC={prefix:"fas",iconName:"arrow-down-1-9",icon:[512,512,["sort-numeric-asc","sort-numeric-down"],"f162","M418.7 38c8.3 6 13.3 15.7 13.3 26l0 96 16 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-96 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l16 0 0-51.6-5.9 2c-16.8 5.6-34.9-3.5-40.5-20.2s3.5-34.9 20.2-40.5l48-16c9.8-3.3 20.5-1.6 28.8 4.4zM365.1 430.6l11.7-18c-32.9-9.9-56.8-40.5-56.8-76.6 0-44.2 35.8-80 80-80s80 35.8 80 80c0 22.9-6.6 45.3-19.1 64.5l-42.1 64.9c-9.6 14.8-29.4 19.1-44.3 9.4s-19.1-29.4-9.4-44.3zM424 336a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM150.6 470.6c-12.5 12.5-32.8 12.5-45.3 0l-96-96c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0L96 370.7 96 64c0-17.7 14.3-32 32-32s32 14.3 32 32l0 306.7 41.4-41.4c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3l-96 96z"]},lC={prefix:"fas",iconName:"arrow-up-1-9",icon:[512,512,["sort-numeric-up"],"f163","M150.6 41.4c-12.5-12.5-32.8-12.5-45.3 0l-96 96c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L96 141.3 96 448c0 17.7 14.3 32 32 32s32-14.3 32-32l0-306.7 41.4 41.4c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-96-96zM418.7 38c-8.3-6-19.1-7.7-28.8-4.4l-48 16c-16.8 5.6-25.8 23.7-20.2 40.5s23.7 25.8 40.5 20.2l5.9-2 0 51.6-16 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l96 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-16 0 0-96c0-10.3-4.9-19.9-13.3-26zM365.1 430.6c-9.6 14.8-5.4 34.6 9.4 44.3s34.6 5.4 44.3-9.4l42.1-64.9c12.4-19.2 19.1-41.6 19.1-64.5 0-44.2-35.8-80-80-80s-80 35.8-80 80c0 36.1 23.9 66.7 56.8 76.6l-11.7 18zM376 336a24 24 0 1 1 48 0 24 24 0 1 1 -48 0z"]},cC={prefix:"fas",iconName:"route",icon:[512,512,[],"f4d7","M512 96c0 50.2-59.1 125.1-84.6 155-3.8 4.4-9.4 6.1-14.5 5L320 256c-17.7 0-32 14.3-32 32s14.3 32 32 32l96 0c53 0 96 43 96 96s-43 96-96 96l-276.4 0c8.7-9.9 19.3-22.6 30-36.8 6.3-8.4 12.8-17.6 19-27.2L416 448c17.7 0 32-14.3 32-32s-14.3-32-32-32l-96 0c-53 0-96-43-96-96s43-96 96-96l39.8 0c-21-31.5-39.8-67.7-39.8-96 0-53 43-96 96-96s96 43 96 96zM117.1 489.1c-3.8 4.3-7.2 8.1-10.1 11.3l-1.8 2-.2-.2c-6 4.6-14.6 4-20-1.8-25.2-27.4-85-97.9-85-148.4 0-53 43-96 96-96s96 43 96 96c0 30-21.1 67-43.5 97.9-10.7 14.7-21.7 28-30.8 38.5l-.6 .7zM128 352a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM416 128a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]},uC={prefix:"fas",iconName:"file-export",icon:[576,512,["arrow-right-from-file"],"f56e","M96.5 0c-35.3 0-64 28.7-64 64l0 384c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-96 78.1 0-31 31c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l72-72c9.4-9.4 9.4-24.6 0-33.9l-72-72c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l31 31-78.1 0 0-133.5c0-17-6.7-33.3-18.7-45.3L291.2 18.7C279.2 6.7 263 0 246 0L96.5 0zM358 176l-93.5 0c-13.3 0-24-10.7-24-24L240.5 58.5 358 176zM224.5 328c0-13.3 10.7-24 24-24l104 0 0 48-104 0c-13.3 0-24-10.7-24-24z"]};const fC={class:"d-flex align-items-center gap-2 flex-nowrap f-caption"},dC={class:"sequence-number p-1 rounded-3 text-center"},hC={class:"grid"},pC={class:"text-ellipsis ms-2 align-self-center"},gC=at({__name:"MessageItem",props:{message:{},onHeightChanged:{type:Function},onClick:{type:Function}},setup(e){const t=e,{message:n}=t,s=re(null);Zp(s,o=>{const a=o[0].contentRect.height;a>0&&t.onHeightChanged(a)});function r(o){if(o){const a=new Date(o);return a.toLocaleTimeString()+"."+a.getMilliseconds()}else return""}const i=xe(()=>{let o=\`\${n.sequenceNumber+1}\`;return n.pairedSequenceNumber>=0&&(o+=" ",o+=n.request?"⇢":"⇠",o+=" ",o+=\`\${n.pairedSequenceNumber+1}\`),o});return(o,a)=>(H(),oe("div",{ref_key:"el",ref:s,class:"message-item text-muted d-flex flex-column gap-2",onClick:a[0]||(a[0]=l=>t.onClick())},[w("div",fC,[w("div",dC,"#"+Fe(i.value),1),w("div",null,Fe(A(n).request?"Request":"Response")+" "+Fe(r(A(n).timestamp)),1)]),w("div",hC,[A(n).request?(H(),qe(A(ft),{key:0,icon:A(iC),class:"request align-self-center"},null,8,["icon"])):Ce("",!0),A(n).request?Ce("",!0):(H(),qe(A(JO),{key:1,class:"response align-self-center"})),w("div",pC,Fe(A(n).infoString),1),(H(!0),oe(Xe,null,Fn(A(n).additionalInfoStrings,l=>(H(),oe("div",{class:"add-info-strings text-ellipsis ms-2 f-caption",key:l}," ⤷ "+Fe(l),1))),128))])],512))}}),qn=(e,t)=>{const n=e.__vccOpts||e;for(const[s,r]of t)n[s]=r;return n},Em=qn(gC,[["__scopeId","data-v-b543c90f"]]),bi=Symbol("settingsSymbol");function wm(){const e=Pa("reverseMessageQueue",!1),t=Pa("hideMessageHeaders",!1),n=Pa("hideMessageDetails",!1);return{reverseMessageQueue:e,hideMessageHeaders:t,hideMessageDetails:n}}const mC={class:"sticky-header p-2 border-bottom d-flex justify-content-between"},vC={type:"button",class:"btn dropdown-toggle test-btn-settings","data-bs-toggle":"dropdown","aria-expanded":"false","data-bs-auto-close":"outside",id:"test-settings-button",title:"Settings"},bC={class:"dropdown-menu p-3"},yC={class:"mb-3"},_C={class:"form-check"},EC={class:"form-check"},wC=at({__name:"SettingsHeader",props:{messageQueue:{},onClickResetMessages:{},onClickQuitProxy:{},noLogo:{type:Boolean,default:!1}},setup(e){const t=e,n=Ne(bi),s=re(null),r=re(null),i=t.messageQueue.reversedMessageQueue;Lt(()=>{s.value&&(r.value=new ln(s.value))});async function o(c){c.preventDefault(),r.value?.hide()}function a(c){c.preventDefault(),r.value?.hide()}function l(c){c.preventDefault(),t.onClickResetMessages(),r.value?.hide()}function u(c){c.preventDefault(),t.onClickQuitProxy(),r.value?.hide()}return(c,f)=>(H(),oe("div",mC,[c.noLogo?Ce("",!0):(H(),oe(Xe,{key:0},[f[3]||(f[3]=w("span",{class:"logo text-nowrap",id:"test-tiger-logo"},"Tiger Proxy",-1)),f[4]||(f[4]=w("div",{class:"p-1 flex-grow-1"},null,-1))],64)),w("button",{type:"button",class:"btn test-btn-sort",onClick:f[0]||(f[0]=()=>A(n).reverseMessageQueue.value=!A(i))},[A(i)?(H(),qe(A(ft),{key:0,icon:A(aC),title:"Sort from oldest to newest"},null,8,["icon"])):(H(),qe(A(ft),{key:1,icon:A(lC),title:"Sort from newest to oldest"},null,8,["icon"]))]),f[13]||(f[13]=w("div",{class:"border-end m-1"},null,-1)),w("div",{ref_key:"dropdownElement",ref:s,class:"dropdown"},[w("button",vC,[Ae(A(ft),{icon:A(oC)},null,8,["icon"])]),w("form",bC,[w("div",yC,[f[7]||(f[7]=w("label",{class:"form-label bold"}," Message Options ",-1)),w("div",_C,[jt(w("input",{"onUpdate:modelValue":f[1]||(f[1]=d=>A(n).hideMessageHeaders.value=d),type:"checkbox",class:"form-check-input test-check-hide-header",id:"hideHeader"},null,512),[[al,A(n).hideMessageHeaders.value]]),f[5]||(f[5]=w("label",{class:"form-check-label",for:"hideHeader"}," Hide Header ",-1))]),w("div",EC,[jt(w("input",{"onUpdate:modelValue":f[2]||(f[2]=d=>A(n).hideMessageDetails.value=d),type:"checkbox",class:"form-check-input test-check-hide-details",id:"hideDetails"},null,512),[[al,A(n).hideMessageDetails.value]]),f[6]||(f[6]=w("label",{class:"form-check-label",for:"hideDetails"}," Hide Details ",-1))])]),c.__IS_ONLINE_MODE__?(H(),oe(Xe,{key:0},[f[12]||(f[12]=w("div",{class:"border-bottom mb-3"},null,-1)),w("button",{"data-bs-toggle":"modal","data-bs-target":"#exportModal",id:"exportModalButton",onClick:o,class:"btn btn-secondary w-100 mb-2 test-btn-export"},[Ae(A(ft),{icon:A(uC)},null,8,["icon"]),f[8]||(f[8]=ze(" Export ",-1))]),w("button",{"data-bs-toggle":"modal","data-bs-target":"#routeModal",id:"routeModalButton",onClick:a,class:"btn btn-secondary w-100 mb-2 test-btn-config-routes"},[Ae(A(ft),{icon:A(cC)},null,8,["icon"]),f[9]||(f[9]=ze(" Configure Routes ",-1))]),w("button",{onClick:l,class:"btn btn-danger w-100 mb-2 test-btn-clear-messages",id:"clearMessages"},[Ae(A(ft),{icon:A(ym)},null,8,["icon"]),f[10]||(f[10]=ze(" Reset Messages ",-1))]),w("button",{onClick:u,class:"btn btn-outline-secondary w-100 test-btn-quit-proxy",id:"test-quit-proxy"},[Ae(A(ft),{icon:A(nC)},null,8,["icon"]),f[11]||(f[11]=ze(" Quit Proxy ",-1))])],64)):Ce("",!0)])],512)]))}}),jc=qn(wC,[["__scopeId","data-v-74fa4e7e"]]),SC={class:"sidebar d-flex flex-row"},xC={class:"vh-100 flex-shrink-1 flex-grow-0 d-flex flex-column"},TC=at({__name:"Sidebar",props:{onClickReverse:{type:Function},onClickResetMessages:{type:Function},onClickQuitProxy:{type:Function}},setup(e){const t=e,n=Ne(pi),s=n.messagesMeta,r=re(10),{list:i,containerProps:o,wrapperProps:a}=fx(s,{itemHeight:()=>r.value});function l(c){r.value!=c&&(r.value=c)}const u=n.reversedMessageQueue;return(c,f)=>(H(),oe("div",SC,[f[0]||(f[0]=w("div",{class:"flex-grow-1"},null,-1)),w("div",xC,[w("div",Po(A(o),{class:"vh-100"}),[Ae(jc,{class:"sticky-top sticky-header","message-queue":A(n),"on-click-reverse":t.onClickReverse,"on-click-reset-messages":t.onClickResetMessages,"on-click-quit-proxy":t.onClickQuitProxy},null,8,["message-queue","on-click-reverse","on-click-reset-messages","on-click-quit-proxy"]),w("div",Od(ic(A(a))),[(H(!0),oe(Xe,null,Fn(A(i),d=>(H(),qe(Em,{class:$t(["sidebar-item p-1 ps-2 pe-4 py-2",[d.data.request?A(u)?"border-bottom":"":A(u)?"":"border-bottom"]]),"on-height-changed":l,key:d.data.uuid,message:d.data,"on-click":()=>A(n).scrollToMessage(d.data.uuid)},null,8,["class","message","on-click"]))),128))],16)],16)])]))}}),AC=qn(TC,[["__scopeId","data-v-9b199225"]]),wr=Symbol("rbelQueryModalSymbol");function Sm(){const e=re(null);return{selectedMessage:e,show:s=>{e.value=s},hide:()=>{e.value=null}}}const Zo=Symbol("rawContentModalSymbol");function xm(){const e=re(null);return{selected:e,show:(s,r)=>{e.value={message:s,rawContent:r}},hide:()=>{e.value=null}}}function OC(e){return e&&e.__esModule&&Object.prototype.hasOwnProperty.call(e,"default")?e.default:e}var Ka,vd;function CC(){if(vd)return Ka;vd=1;function e(E){return E instanceof Map?E.clear=E.delete=E.set=function(){throw new Error("map is read-only")}:E instanceof Set&&(E.add=E.clear=E.delete=function(){throw new Error("set is read-only")}),Object.freeze(E),Object.getOwnPropertyNames(E).forEach(k=>{const J=E[k],Ee=typeof J;(Ee==="object"||Ee==="function")&&!Object.isFrozen(J)&&e(J)}),E}class t{constructor(k){k.data===void 0&&(k.data={}),this.data=k.data,this.isMatchIgnored=!1}ignoreMatch(){this.isMatchIgnored=!0}}function n(E){return E.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/"/g,"&quot;").replace(/'/g,"&#x27;")}function s(E,...k){const J=Object.create(null);for(const Ee in E)J[Ee]=E[Ee];return k.forEach(function(Ee){for(const nt in Ee)J[nt]=Ee[nt]}),J}const r="</span>",i=E=>!!E.scope,o=(E,{prefix:k})=>{if(E.startsWith("language:"))return E.replace("language:","language-");if(E.includes(".")){const J=E.split(".");return[\`\${k}\${J.shift()}\`,...J.map((Ee,nt)=>\`\${Ee}\${"_".repeat(nt+1)}\`)].join(" ")}return\`\${k}\${E}\`};class a{constructor(k,J){this.buffer="",this.classPrefix=J.classPrefix,k.walk(this)}addText(k){this.buffer+=n(k)}openNode(k){if(!i(k))return;const J=o(k.scope,{prefix:this.classPrefix});this.span(J)}closeNode(k){i(k)&&(this.buffer+=r)}value(){return this.buffer}span(k){this.buffer+=\`<span class="\${k}">\`}}const l=(E={})=>{const k={children:[]};return Object.assign(k,E),k};class u{constructor(){this.rootNode=l(),this.stack=[this.rootNode]}get top(){return this.stack[this.stack.length-1]}get root(){return this.rootNode}add(k){this.top.children.push(k)}openNode(k){const J=l({scope:k});this.add(J),this.stack.push(J)}closeNode(){if(this.stack.length>1)return this.stack.pop()}closeAllNodes(){for(;this.closeNode(););}toJSON(){return JSON.stringify(this.rootNode,null,4)}walk(k){return this.constructor._walk(k,this.rootNode)}static _walk(k,J){return typeof J=="string"?k.addText(J):J.children&&(k.openNode(J),J.children.forEach(Ee=>this._walk(k,Ee)),k.closeNode(J)),k}static _collapse(k){typeof k!="string"&&k.children&&(k.children.every(J=>typeof J=="string")?k.children=[k.children.join("")]:k.children.forEach(J=>{u._collapse(J)}))}}class c extends u{constructor(k){super(),this.options=k}addText(k){k!==""&&this.add(k)}startScope(k){this.openNode(k)}endScope(){this.closeNode()}__addSublanguage(k,J){const Ee=k.root;J&&(Ee.scope=\`language:\${J}\`),this.add(Ee)}toHTML(){return new a(this,this.options).value()}finalize(){return this.closeAllNodes(),!0}}function f(E){return E?typeof E=="string"?E:E.source:null}function d(E){return g("(?=",E,")")}function h(E){return g("(?:",E,")*")}function p(E){return g("(?:",E,")?")}function g(...E){return E.map(J=>f(J)).join("")}function _(E){const k=E[E.length-1];return typeof k=="object"&&k.constructor===Object?(E.splice(E.length-1,1),k):{}}function b(...E){return"("+(_(E).capture?"":"?:")+E.map(Ee=>f(Ee)).join("|")+")"}function y(E){return new RegExp(E.toString()+"|").exec("").length-1}function T(E,k){const J=E&&E.exec(k);return J&&J.index===0}const x=/\\[(?:[^\\\\\\]]|\\\\.)*\\]|\\(\\??|\\\\([1-9][0-9]*)|\\\\./;function O(E,{joinWith:k}){let J=0;return E.map(Ee=>{J+=1;const nt=J;let st=f(Ee),ce="";for(;st.length>0;){const ie=x.exec(st);if(!ie){ce+=st;break}ce+=st.substring(0,ie.index),st=st.substring(ie.index+ie[0].length),ie[0][0]==="\\\\"&&ie[1]?ce+="\\\\"+String(Number(ie[1])+nt):(ce+=ie[0],ie[0]==="("&&J++)}return ce}).map(Ee=>\`(\${Ee})\`).join(k)}const $=/\\b\\B/,F="[a-zA-Z]\\\\w*",Q="[a-zA-Z_]\\\\w*",P="\\\\b\\\\d+(\\\\.\\\\d+)?",C="(-?)(\\\\b0[xX][a-fA-F0-9]+|(\\\\b\\\\d+(\\\\.\\\\d*)?|\\\\.\\\\d+)([eE][-+]?\\\\d+)?)",q="\\\\b(0b[01]+)",ne="!|!=|!==|%|%=|&|&&|&=|\\\\*|\\\\*=|\\\\+|\\\\+=|,|-|-=|/=|/|:|;|<<|<<=|<=|<|===|==|=|>>>=|>>=|>=|>>>|>>|>|\\\\?|\\\\[|\\\\{|\\\\(|\\\\^|\\\\^=|\\\\||\\\\|=|\\\\|\\\\||~",W=(E={})=>{const k=/^#![ ]*\\//;return E.binary&&(E.begin=g(k,/.*\\b/,E.binary,/\\b.*/)),s({scope:"meta",begin:k,end:/$/,relevance:0,"on:begin":(J,Ee)=>{J.index!==0&&Ee.ignoreMatch()}},E)},L={begin:"\\\\\\\\[\\\\s\\\\S]",relevance:0},le={scope:"string",begin:"'",end:"'",illegal:"\\\\n",contains:[L]},B={scope:"string",begin:'"',end:'"',illegal:"\\\\n",contains:[L]},ue={begin:/\\b(a|an|the|are|I'm|isn't|don't|doesn't|won't|but|just|should|pretty|simply|enough|gonna|going|wtf|so|such|will|you|your|they|like|more)\\b/},Z=function(E,k,J={}){const Ee=s({scope:"comment",begin:E,end:k,contains:[]},J);Ee.contains.push({scope:"doctag",begin:"[ ]*(?=(TODO|FIXME|NOTE|BUG|OPTIMIZE|HACK|XXX):)",end:/(TODO|FIXME|NOTE|BUG|OPTIMIZE|HACK|XXX):/,excludeBegin:!0,relevance:0});const nt=b("I","a","is","so","us","to","at","if","in","it","on",/[A-Za-z]+['](d|ve|re|ll|t|s|n)/,/[A-Za-z]+[-][a-z]+/,/[A-Za-z][a-z]{2,}/);return Ee.contains.push({begin:g(/[ ]+/,"(",nt,/[.]?[:]?([.][ ]|[ ])/,"){3}")}),Ee},we=Z("//","$"),Ke=Z("/\\\\*","\\\\*/"),rt=Z("#","$"),Ve={scope:"number",begin:P,relevance:0},it={scope:"number",begin:C,relevance:0},ct={scope:"number",begin:q,relevance:0},tt={scope:"regexp",begin:/\\/(?=[^/\\n]*\\/)/,end:/\\/[gimuy]*/,contains:[L,{begin:/\\[/,end:/\\]/,relevance:0,contains:[L]}]},Qe={scope:"title",begin:F,relevance:0},R={scope:"title",begin:Q,relevance:0},G={begin:"\\\\.\\\\s*"+Q,relevance:0};var se=Object.freeze({__proto__:null,APOS_STRING_MODE:le,BACKSLASH_ESCAPE:L,BINARY_NUMBER_MODE:ct,BINARY_NUMBER_RE:q,COMMENT:Z,C_BLOCK_COMMENT_MODE:Ke,C_LINE_COMMENT_MODE:we,C_NUMBER_MODE:it,C_NUMBER_RE:C,END_SAME_AS_BEGIN:function(E){return Object.assign(E,{"on:begin":(k,J)=>{J.data._beginMatch=k[1]},"on:end":(k,J)=>{J.data._beginMatch!==k[1]&&J.ignoreMatch()}})},HASH_COMMENT_MODE:rt,IDENT_RE:F,MATCH_NOTHING_RE:$,METHOD_GUARD:G,NUMBER_MODE:Ve,NUMBER_RE:P,PHRASAL_WORDS_MODE:ue,QUOTE_STRING_MODE:B,REGEXP_MODE:tt,RE_STARTERS_RE:ne,SHEBANG:W,TITLE_MODE:Qe,UNDERSCORE_IDENT_RE:Q,UNDERSCORE_TITLE_MODE:R});function Oe(E,k){E.input[E.index-1]==="."&&k.ignoreMatch()}function m(E,k){E.className!==void 0&&(E.scope=E.className,delete E.className)}function v(E,k){k&&E.beginKeywords&&(E.begin="\\\\b("+E.beginKeywords.split(" ").join("|")+")(?!\\\\.)(?=\\\\b|\\\\s)",E.__beforeBegin=Oe,E.keywords=E.keywords||E.beginKeywords,delete E.beginKeywords,E.relevance===void 0&&(E.relevance=0))}function S(E,k){Array.isArray(E.illegal)&&(E.illegal=b(...E.illegal))}function N(E,k){if(E.match){if(E.begin||E.end)throw new Error("begin & end are not supported with match");E.begin=E.match,delete E.match}}function I(E,k){E.relevance===void 0&&(E.relevance=1)}const M=(E,k)=>{if(!E.beforeMatch)return;if(E.starts)throw new Error("beforeMatch cannot be used with starts");const J=Object.assign({},E);Object.keys(E).forEach(Ee=>{delete E[Ee]}),E.keywords=J.keywords,E.begin=g(J.beforeMatch,d(J.begin)),E.starts={relevance:0,contains:[Object.assign(J,{endsParent:!0})]},E.relevance=0,delete J.beforeMatch},X=["of","and","for","in","not","or","if","then","parent","list","value"],K="keyword";function j(E,k,J=K){const Ee=Object.create(null);return typeof E=="string"?nt(J,E.split(" ")):Array.isArray(E)?nt(J,E):Object.keys(E).forEach(function(st){Object.assign(Ee,j(E[st],k,st))}),Ee;function nt(st,ce){k&&(ce=ce.map(ie=>ie.toLowerCase())),ce.forEach(function(ie){const be=ie.split("|");Ee[be[0]]=[st,z(be[0],be[1])]})}}function z(E,k){return k?Number(k):de(E)?0:1}function de(E){return X.includes(E.toLowerCase())}const ee={},ae=E=>{console.error(E)},me=(E,...k)=>{console.log(\`WARN: \${E}\`,...k)},_e=(E,k)=>{ee[\`\${E}/\${k}\`]||(console.log(\`Deprecated as of \${E}. \${k}\`),ee[\`\${E}/\${k}\`]=!0)},ke=new Error;function Re(E,k,{key:J}){let Ee=0;const nt=E[J],st={},ce={};for(let ie=1;ie<=k.length;ie++)ce[ie+Ee]=nt[ie],st[ie+Ee]=!0,Ee+=y(k[ie-1]);E[J]=ce,E[J]._emit=st,E[J]._multi=!0}function mt(E){if(Array.isArray(E.begin)){if(E.skip||E.excludeBegin||E.returnBegin)throw ae("skip, excludeBegin, returnBegin not compatible with beginScope: {}"),ke;if(typeof E.beginScope!="object"||E.beginScope===null)throw ae("beginScope must be object"),ke;Re(E,E.begin,{key:"beginScope"}),E.begin=O(E.begin,{joinWith:""})}}function vt(E){if(Array.isArray(E.end)){if(E.skip||E.excludeEnd||E.returnEnd)throw ae("skip, excludeEnd, returnEnd not compatible with endScope: {}"),ke;if(typeof E.endScope!="object"||E.endScope===null)throw ae("endScope must be object"),ke;Re(E,E.end,{key:"endScope"}),E.end=O(E.end,{joinWith:""})}}function Ut(E){E.scope&&typeof E.scope=="object"&&E.scope!==null&&(E.beginScope=E.scope,delete E.scope)}function qt(E){Ut(E),typeof E.beginScope=="string"&&(E.beginScope={_wrap:E.beginScope}),typeof E.endScope=="string"&&(E.endScope={_wrap:E.endScope}),mt(E),vt(E)}function ys(E){function k(ce,ie){return new RegExp(f(ce),"m"+(E.case_insensitive?"i":"")+(E.unicodeRegex?"u":"")+(ie?"g":""))}class J{constructor(){this.matchIndexes={},this.regexes=[],this.matchAt=1,this.position=0}addRule(ie,be){be.position=this.position++,this.matchIndexes[this.matchAt]=be,this.regexes.push([be,ie]),this.matchAt+=y(ie)+1}compile(){this.regexes.length===0&&(this.exec=()=>null);const ie=this.regexes.map(be=>be[1]);this.matcherRe=k(O(ie,{joinWith:"|"}),!0),this.lastIndex=0}exec(ie){this.matcherRe.lastIndex=this.lastIndex;const be=this.matcherRe.exec(ie);if(!be)return null;const ut=be.findIndex((Tr,na)=>na>0&&Tr!==void 0),ot=this.matchIndexes[ut];return be.splice(0,ut),Object.assign(be,ot)}}class Ee{constructor(){this.rules=[],this.multiRegexes=[],this.count=0,this.lastIndex=0,this.regexIndex=0}getMatcher(ie){if(this.multiRegexes[ie])return this.multiRegexes[ie];const be=new J;return this.rules.slice(ie).forEach(([ut,ot])=>be.addRule(ut,ot)),be.compile(),this.multiRegexes[ie]=be,be}resumingScanAtSamePosition(){return this.regexIndex!==0}considerAll(){this.regexIndex=0}addRule(ie,be){this.rules.push([ie,be]),be.type==="begin"&&this.count++}exec(ie){const be=this.getMatcher(this.regexIndex);be.lastIndex=this.lastIndex;let ut=be.exec(ie);if(this.resumingScanAtSamePosition()&&!(ut&&ut.index===this.lastIndex)){const ot=this.getMatcher(0);ot.lastIndex=this.lastIndex+1,ut=ot.exec(ie)}return ut&&(this.regexIndex+=ut.position+1,this.regexIndex===this.count&&this.considerAll()),ut}}function nt(ce){const ie=new Ee;return ce.contains.forEach(be=>ie.addRule(be.begin,{rule:be,type:"begin"})),ce.terminatorEnd&&ie.addRule(ce.terminatorEnd,{type:"end"}),ce.illegal&&ie.addRule(ce.illegal,{type:"illegal"}),ie}function st(ce,ie){const be=ce;if(ce.isCompiled)return be;[m,N,qt,M].forEach(ot=>ot(ce,ie)),E.compilerExtensions.forEach(ot=>ot(ce,ie)),ce.__beforeBegin=null,[v,S,I].forEach(ot=>ot(ce,ie)),ce.isCompiled=!0;let ut=null;return typeof ce.keywords=="object"&&ce.keywords.$pattern&&(ce.keywords=Object.assign({},ce.keywords),ut=ce.keywords.$pattern,delete ce.keywords.$pattern),ut=ut||/\\w+/,ce.keywords&&(ce.keywords=j(ce.keywords,E.case_insensitive)),be.keywordPatternRe=k(ut,!0),ie&&(ce.begin||(ce.begin=/\\B|\\b/),be.beginRe=k(be.begin),!ce.end&&!ce.endsWithParent&&(ce.end=/\\B|\\b/),ce.end&&(be.endRe=k(be.end)),be.terminatorEnd=f(be.end)||"",ce.endsWithParent&&ie.terminatorEnd&&(be.terminatorEnd+=(ce.end?"|":"")+ie.terminatorEnd)),ce.illegal&&(be.illegalRe=k(ce.illegal)),ce.contains||(ce.contains=[]),ce.contains=[].concat(...ce.contains.map(function(ot){return Tt(ot==="self"?ce:ot)})),ce.contains.forEach(function(ot){st(ot,be)}),ce.starts&&st(ce.starts,ie),be.matcher=nt(be),be}if(E.compilerExtensions||(E.compilerExtensions=[]),E.contains&&E.contains.includes("self"))throw new Error("ERR: contains \`self\` is not supported at the top-level of a language.  See documentation.");return E.classNameAliases=s(E.classNameAliases||{}),st(E)}function xr(E){return E?E.endsWithParent||xr(E.starts):!1}function Tt(E){return E.variants&&!E.cachedVariants&&(E.cachedVariants=E.variants.map(function(k){return s(E,{variants:null},k)})),E.cachedVariants?E.cachedVariants:xr(E)?s(E,{starts:E.starts?s(E.starts):null}):Object.isFrozen(E)?s(E):E}var Kt="11.11.1";class _i extends Error{constructor(k,J){super(k),this.name="HTMLInjectionError",this.html=J}}const Ds=n,Bc=s,Wc=Symbol("nomatch"),Fm=7,Uc=function(E){const k=Object.create(null),J=Object.create(null),Ee=[];let nt=!0;const st="Could not find the language '{}', did you forget to load/include a language module?",ce={disableAutodetect:!0,name:"Plain text",contains:[]};let ie={ignoreUnescapedHTML:!1,throwUnescapedHTML:!1,noHighlightRe:/^(no-?highlight)$/i,languageDetectRe:/\\blang(?:uage)?-([\\w-]+)\\b/i,classPrefix:"hljs-",cssSelector:"pre code",languages:null,__emitter:c};function be(U){return ie.noHighlightRe.test(U)}function ut(U){let pe=U.className+" ";pe+=U.parentNode?U.parentNode.className:"";const $e=ie.languageDetectRe.exec(pe);if($e){const Be=Kn($e[1]);return Be||(me(st.replace("{}",$e[1])),me("Falling back to no-highlight mode for this block.",U)),Be?$e[1]:"no-highlight"}return pe.split(/\\s+/).find(Be=>be(Be)||Kn(Be))}function ot(U,pe,$e){let Be="",lt="";typeof pe=="object"?(Be=U,$e=pe.ignoreIllegals,lt=pe.language):(_e("10.7.0","highlight(lang, code, ...args) has been deprecated."),_e("10.7.0",\`Please use highlight(code, options) instead.
https://github.com/highlightjs/highlight.js/issues/2277\`),lt=U,Be=pe),$e===void 0&&($e=!0);const sn={code:Be,language:lt};wi("before:highlight",sn);const Yn=sn.result?sn.result:Tr(sn.language,sn.code,$e);return Yn.code=sn.code,wi("after:highlight",Yn),Yn}function Tr(U,pe,$e,Be){const lt=Object.create(null);function sn(te,fe){return te.keywords[fe]}function Yn(){if(!Se.keywords){ht.addText(We);return}let te=0;Se.keywordPatternRe.lastIndex=0;let fe=Se.keywordPatternRe.exec(We),Te="";for(;fe;){Te+=We.substring(te,fe.index);const De=gn.case_insensitive?fe[0].toLowerCase():fe[0],bt=sn(Se,De);if(bt){const[Tn,tv]=bt;if(ht.addText(Te),Te="",lt[De]=(lt[De]||0)+1,lt[De]<=Fm&&(Ti+=tv),Tn.startsWith("_"))Te+=fe[0];else{const nv=gn.classNameAliases[Tn]||Tn;pn(fe[0],nv)}}else Te+=fe[0];te=Se.keywordPatternRe.lastIndex,fe=Se.keywordPatternRe.exec(We)}Te+=We.substring(te),ht.addText(Te)}function Si(){if(We==="")return;let te=null;if(typeof Se.subLanguage=="string"){if(!k[Se.subLanguage]){ht.addText(We);return}te=Tr(Se.subLanguage,We,!0,Zc[Se.subLanguage]),Zc[Se.subLanguage]=te._top}else te=sa(We,Se.subLanguage.length?Se.subLanguage:null);Se.relevance>0&&(Ti+=te.relevance),ht.__addSublanguage(te._emitter,te.language)}function Dt(){Se.subLanguage!=null?Si():Yn(),We=""}function pn(te,fe){te!==""&&(ht.startScope(fe),ht.addText(te),ht.endScope())}function Gc(te,fe){let Te=1;const De=fe.length-1;for(;Te<=De;){if(!te._emit[Te]){Te++;continue}const bt=gn.classNameAliases[te[Te]]||te[Te],Tn=fe[Te];bt?pn(Tn,bt):(We=Tn,Yn(),We=""),Te++}}function Qc(te,fe){return te.scope&&typeof te.scope=="string"&&ht.openNode(gn.classNameAliases[te.scope]||te.scope),te.beginScope&&(te.beginScope._wrap?(pn(We,gn.classNameAliases[te.beginScope._wrap]||te.beginScope._wrap),We=""):te.beginScope._multi&&(Gc(te.beginScope,fe),We="")),Se=Object.create(te,{parent:{value:Se}}),Se}function Xc(te,fe,Te){let De=T(te.endRe,Te);if(De){if(te["on:end"]){const bt=new t(te);te["on:end"](fe,bt),bt.isMatchIgnored&&(De=!1)}if(De){for(;te.endsParent&&te.parent;)te=te.parent;return te}}if(te.endsWithParent)return Xc(te.parent,fe,Te)}function Qm(te){return Se.matcher.regexIndex===0?(We+=te[0],1):(aa=!0,0)}function Xm(te){const fe=te[0],Te=te.rule,De=new t(Te),bt=[Te.__beforeBegin,Te["on:begin"]];for(const Tn of bt)if(Tn&&(Tn(te,De),De.isMatchIgnored))return Qm(fe);return Te.skip?We+=fe:(Te.excludeBegin&&(We+=fe),Dt(),!Te.returnBegin&&!Te.excludeBegin&&(We=fe)),Qc(Te,te),Te.returnBegin?0:fe.length}function Jm(te){const fe=te[0],Te=pe.substring(te.index),De=Xc(Se,te,Te);if(!De)return Wc;const bt=Se;Se.endScope&&Se.endScope._wrap?(Dt(),pn(fe,Se.endScope._wrap)):Se.endScope&&Se.endScope._multi?(Dt(),Gc(Se.endScope,te)):bt.skip?We+=fe:(bt.returnEnd||bt.excludeEnd||(We+=fe),Dt(),bt.excludeEnd&&(We=fe));do Se.scope&&ht.closeNode(),!Se.skip&&!Se.subLanguage&&(Ti+=Se.relevance),Se=Se.parent;while(Se!==De.parent);return De.starts&&Qc(De.starts,te),bt.returnEnd?0:fe.length}function Zm(){const te=[];for(let fe=Se;fe!==gn;fe=fe.parent)fe.scope&&te.unshift(fe.scope);te.forEach(fe=>ht.openNode(fe))}let xi={};function Jc(te,fe){const Te=fe&&fe[0];if(We+=te,Te==null)return Dt(),0;if(xi.type==="begin"&&fe.type==="end"&&xi.index===fe.index&&Te===""){if(We+=pe.slice(fe.index,fe.index+1),!nt){const De=new Error(\`0 width match regex (\${U})\`);throw De.languageName=U,De.badRule=xi.rule,De}return 1}if(xi=fe,fe.type==="begin")return Xm(fe);if(fe.type==="illegal"&&!$e){const De=new Error('Illegal lexeme "'+Te+'" for mode "'+(Se.scope||"<unnamed>")+'"');throw De.mode=Se,De}else if(fe.type==="end"){const De=Jm(fe);if(De!==Wc)return De}if(fe.type==="illegal"&&Te==="")return We+=\`
\`,1;if(oa>1e5&&oa>fe.index*3)throw new Error("potential infinite loop, way more iterations than matches");return We+=Te,Te.length}const gn=Kn(U);if(!gn)throw ae(st.replace("{}",U)),new Error('Unknown language: "'+U+'"');const ev=ys(gn);let ia="",Se=Be||ev;const Zc={},ht=new ie.__emitter(ie);Zm();let We="",Ti=0,_s=0,oa=0,aa=!1;try{if(gn.__emitTokens)gn.__emitTokens(pe,ht);else{for(Se.matcher.considerAll();;){oa++,aa?aa=!1:Se.matcher.considerAll(),Se.matcher.lastIndex=_s;const te=Se.matcher.exec(pe);if(!te)break;const fe=pe.substring(_s,te.index),Te=Jc(fe,te);_s=te.index+Te}Jc(pe.substring(_s))}return ht.finalize(),ia=ht.toHTML(),{language:U,value:ia,relevance:Ti,illegal:!1,_emitter:ht,_top:Se}}catch(te){if(te.message&&te.message.includes("Illegal"))return{language:U,value:Ds(pe),illegal:!0,relevance:0,_illegalBy:{message:te.message,index:_s,context:pe.slice(_s-100,_s+100),mode:te.mode,resultSoFar:ia},_emitter:ht};if(nt)return{language:U,value:Ds(pe),illegal:!1,relevance:0,errorRaised:te,_emitter:ht,_top:Se};throw te}}function na(U){const pe={value:Ds(U),illegal:!1,relevance:0,_top:ce,_emitter:new ie.__emitter(ie)};return pe._emitter.addText(U),pe}function sa(U,pe){pe=pe||ie.languages||Object.keys(k);const $e=na(U),Be=pe.filter(Kn).filter(Yc).map(Dt=>Tr(Dt,U,!1));Be.unshift($e);const lt=Be.sort((Dt,pn)=>{if(Dt.relevance!==pn.relevance)return pn.relevance-Dt.relevance;if(Dt.language&&pn.language){if(Kn(Dt.language).supersetOf===pn.language)return 1;if(Kn(pn.language).supersetOf===Dt.language)return-1}return 0}),[sn,Yn]=lt,Si=sn;return Si.secondBest=Yn,Si}function zm(U,pe,$e){const Be=pe&&J[pe]||$e;U.classList.add("hljs"),U.classList.add(\`language-\${Be}\`)}function ra(U){let pe=null;const $e=ut(U);if(be($e))return;if(wi("before:highlightElement",{el:U,language:$e}),U.dataset.highlighted){console.log("Element previously highlighted. To highlight again, first unset \`dataset.highlighted\`.",U);return}if(U.children.length>0&&(ie.ignoreUnescapedHTML||(console.warn("One of your code blocks includes unescaped HTML. This is a potentially serious security risk."),console.warn("https://github.com/highlightjs/highlight.js/wiki/security"),console.warn("The element with unescaped HTML:"),console.warn(U)),ie.throwUnescapedHTML))throw new _i("One of your code blocks includes unescaped HTML.",U.innerHTML);pe=U;const Be=pe.textContent,lt=$e?ot(Be,{language:$e,ignoreIllegals:!0}):sa(Be);U.innerHTML=lt.value,U.dataset.highlighted="yes",zm(U,$e,lt.language),U.result={language:lt.language,re:lt.relevance,relevance:lt.relevance},lt.secondBest&&(U.secondBest={language:lt.secondBest.language,relevance:lt.secondBest.relevance}),wi("after:highlightElement",{el:U,result:lt,text:Be})}function jm(U){ie=Bc(ie,U)}const Hm=()=>{Ei(),_e("10.6.0","initHighlighting() deprecated.  Use highlightAll() now.")};function Vm(){Ei(),_e("10.6.0","initHighlightingOnLoad() deprecated.  Use highlightAll() now.")}let qc=!1;function Ei(){function U(){Ei()}if(document.readyState==="loading"){qc||window.addEventListener("DOMContentLoaded",U,!1),qc=!0;return}document.querySelectorAll(ie.cssSelector).forEach(ra)}function Bm(U,pe){let $e=null;try{$e=pe(E)}catch(Be){if(ae("Language definition for '{}' could not be registered.".replace("{}",U)),nt)ae(Be);else throw Be;$e=ce}$e.name||($e.name=U),k[U]=$e,$e.rawDefinition=pe.bind(null,E),$e.aliases&&Kc($e.aliases,{languageName:U})}function Wm(U){delete k[U];for(const pe of Object.keys(J))J[pe]===U&&delete J[pe]}function Um(){return Object.keys(k)}function Kn(U){return U=(U||"").toLowerCase(),k[U]||k[J[U]]}function Kc(U,{languageName:pe}){typeof U=="string"&&(U=[U]),U.forEach($e=>{J[$e.toLowerCase()]=pe})}function Yc(U){const pe=Kn(U);return pe&&!pe.disableAutodetect}function qm(U){U["before:highlightBlock"]&&!U["before:highlightElement"]&&(U["before:highlightElement"]=pe=>{U["before:highlightBlock"](Object.assign({block:pe.el},pe))}),U["after:highlightBlock"]&&!U["after:highlightElement"]&&(U["after:highlightElement"]=pe=>{U["after:highlightBlock"](Object.assign({block:pe.el},pe))})}function Km(U){qm(U),Ee.push(U)}function Ym(U){const pe=Ee.indexOf(U);pe!==-1&&Ee.splice(pe,1)}function wi(U,pe){const $e=U;Ee.forEach(function(Be){Be[$e]&&Be[$e](pe)})}function Gm(U){return _e("10.7.0","highlightBlock will be removed entirely in v12.0"),_e("10.7.0","Please use highlightElement now."),ra(U)}Object.assign(E,{highlight:ot,highlightAuto:sa,highlightAll:Ei,highlightElement:ra,highlightBlock:Gm,configure:jm,initHighlighting:Hm,initHighlightingOnLoad:Vm,registerLanguage:Bm,unregisterLanguage:Wm,listLanguages:Um,getLanguage:Kn,registerAliases:Kc,autoDetection:Yc,inherit:Bc,addPlugin:Km,removePlugin:Ym}),E.debugMode=function(){nt=!1},E.safeMode=function(){nt=!0},E.versionString=Kt,E.regex={concat:g,lookahead:d,either:b,optional:p,anyNumberOfTimes:h};for(const U in se)typeof se[U]=="object"&&e(se[U]);return Object.assign(E,se),E},Fs=Uc({});return Fs.newInstance=()=>Uc({}),Ka=Fs,Fs.HighlightJS=Fs,Fs.default=Fs,Ka}var RC=CC();const yi=OC(RC),$C={class:"rbel-message pb-3",id:"test-rbel-section"},MC={key:1,class:"loading"},Tm=at({__name:"Message",props:{message:{},onToggleDetailsOrHeader:{type:Function}},setup(e){const t=e,n=Ne(bi);Ne(wr);const s=Ne(Zo),r=re(null),i=re(null),o=re(null),a=re(null);Je(n.hideMessageDetails,()=>{i.value?.(n.hideMessageDetails.value)}),Je(n.hideMessageHeaders,()=>{o.value?.(n.hideMessageHeaders.value)}),Je([i,o],()=>{un(async()=>{await new Promise(f=>setTimeout(f,1)),i.value?.(n.hideMessageDetails.value),o.value?.(n.hideMessageHeaders.value)})});function l(f,d,h){const p=d.classList;h?(p.add("d-none"),c(f,!1)):(p.remove("d-none"),c(f,!0))}function u(f){return f.classList.contains("fa-toggle-on")}function c(f,d){f.classList.remove("fa-toggle-on","fa-toggle-off"),d?f.classList.add("fa-toggle-on"):f.classList.add("fa-toggle-off")}return Je(r,async()=>{if(r.value&&t.message.type==="loaded"){r.value.innerHTML=t.message.htmlContent,await un();const f=r.value.querySelector(".card-header"),d=r.value.querySelectorAll("div [data-bs-target^='#dialog']"),h=r.value.querySelectorAll("div [role='dialog']");if(d&&h&&d.length===h.length)for(let $=0;$<d.length;$++){const F=d[$],Q=h[$],P=Q.querySelector("pre")?.innerHTML??"";F.setAttribute("data-bs-target","#rawContentModal"),F.addEventListener("click",()=>{s.show(t.message,P)}),Q.remove()}const p=r.value.querySelector(".card-content.msg-content"),g=f?.querySelector(".toggle-icon.msg-toggle");p&&g&&(i.value=$=>{l(g,p,$),t.onToggleDetailsOrHeader()},g.addEventListener("click",()=>{const $=u(g);i.value?.($)}));const _=p?.querySelector(".msg-header-content"),b=p?.querySelector(".header-toggle");_&&b&&(o.value=$=>{l(b,_,$),t.onToggleDetailsOrHeader()},b.addEventListener("click",()=>{const $=u(b);o.value?.($)}));const y=p?.querySelector(".msg-body-content"),T=p?.querySelector(".body-toggle");y&&T&&(a.value=$=>{l(T,y,$),t.onToggleDetailsOrHeader()},T.addEventListener("click",()=>{const $=u(T);a.value?.($)}));const x=r.value.querySelectorAll(".msg-section");for(const $ of x){const F=$.querySelector(".msg-section-toggle"),Q=$.querySelector(".msg-section-content");F&&Q&&F.addEventListener("click",()=>{const P=Q.classList.toggle("d-none");c(F,!P),t.onToggleDetailsOrHeader()})}r.value.querySelectorAll("pre.json").forEach($=>{$.getAttribute("data-hljs-highlighted")!=="true"&&(yi.highlightElement($),$.setAttribute("data-hljs-highlighted","true"))});const O=r.value.querySelector(".full-message-button");O&&O.addEventListener("click",$=>{$.preventDefault();const F=\`/message/\${t.message.uuid}\`;window.open(F)||alert("Popup blocked. Please allow popups for this site.")})}}),(f,d)=>(H(),oe("div",$C,[t.message.type==="loaded"?(H(),oe("div",{key:0,ref_key:"messageElement",ref:r},null,512)):(H(),oe("div",MC,[...d[0]||(d[0]=[w("div",null,"Loading...",-1)])]))]))}}),bs=Symbol("toastSymbol");function Am(e){const t=re(null),n=re("");return Lt(()=>{e.value&&(t.value=new di(e.value,{delay:1e4}))}),{handle:t,message:n,showToast:r=>{n.value=r,t.value?.show()},isShown:()=>t.value?.isShown()??!1}}function NC(){var e=window.navigator.userAgent,t=e.indexOf("MSIE ");if(t>0)return parseInt(e.substring(t+5,e.indexOf(".",t)),10);var n=e.indexOf("Trident/");if(n>0){var s=e.indexOf("rv:");return parseInt(e.substring(s+3,e.indexOf(".",s)),10)}var r=e.indexOf("Edge/");return r>0?parseInt(e.substring(r+5,e.indexOf(".",r)),10):-1}let Zi;function Ll(){Ll.init||(Ll.init=!0,Zi=NC()!==-1)}var ea={name:"ResizeObserver",props:{emitOnMount:{type:Boolean,default:!1},ignoreWidth:{type:Boolean,default:!1},ignoreHeight:{type:Boolean,default:!1}},emits:["notify"],mounted(){Ll(),un(()=>{this._w=this.$el.offsetWidth,this._h=this.$el.offsetHeight,this.emitOnMount&&this.emitSize()});const e=document.createElement("object");this._resizeObject=e,e.setAttribute("aria-hidden","true"),e.setAttribute("tabindex",-1),e.onload=this.addResizeHandlers,e.type="text/html",Zi&&this.$el.appendChild(e),e.data="about:blank",Zi||this.$el.appendChild(e)},beforeUnmount(){this.removeResizeHandlers()},methods:{compareAndNotify(){(!this.ignoreWidth&&this._w!==this.$el.offsetWidth||!this.ignoreHeight&&this._h!==this.$el.offsetHeight)&&(this._w=this.$el.offsetWidth,this._h=this.$el.offsetHeight,this.emitSize())},emitSize(){this.$emit("notify",{width:this._w,height:this._h})},addResizeHandlers(){this._resizeObject.contentDocument.defaultView.addEventListener("resize",this.compareAndNotify),this.compareAndNotify()},removeResizeHandlers(){this._resizeObject&&this._resizeObject.onload&&(!Zi&&this._resizeObject.contentDocument&&this._resizeObject.contentDocument.defaultView.removeEventListener("resize",this.compareAndNotify),this.$el.removeChild(this._resizeObject),this._resizeObject.onload=null,this._resizeObject=null)}}};const kC=tb();Zv("data-v-b329ee4c");const IC={class:"resize-observer",tabindex:"-1"};eb();const PC=kC((e,t,n,s,r,i)=>(H(),qe("div",IC)));ea.render=PC;ea.__scopeId="data-v-b329ee4c";ea.__file="src/components/ResizeObserver.vue";function eo(e){"@babel/helpers - typeof";return typeof Symbol=="function"&&typeof Symbol.iterator=="symbol"?eo=function(t){return typeof t}:eo=function(t){return t&&typeof Symbol=="function"&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},eo(e)}function LC(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}function DC(e,t){for(var n=0;n<t.length;n++){var s=t[n];s.enumerable=s.enumerable||!1,s.configurable=!0,"value"in s&&(s.writable=!0),Object.defineProperty(e,s.key,s)}}function FC(e,t,n){return t&&DC(e.prototype,t),e}function bd(e){return zC(e)||jC(e)||HC(e)||VC()}function zC(e){if(Array.isArray(e))return Dl(e)}function jC(e){if(typeof Symbol<"u"&&Symbol.iterator in Object(e))return Array.from(e)}function HC(e,t){if(e){if(typeof e=="string")return Dl(e,t);var n=Object.prototype.toString.call(e).slice(8,-1);if(n==="Object"&&e.constructor&&(n=e.constructor.name),n==="Map"||n==="Set")return Array.from(e);if(n==="Arguments"||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))return Dl(e,t)}}function Dl(e,t){(t==null||t>e.length)&&(t=e.length);for(var n=0,s=new Array(t);n<t;n++)s[n]=e[n];return s}function VC(){throw new TypeError(\`Invalid attempt to spread non-iterable instance.
In order to be iterable, non-array objects must have a [Symbol.iterator]() method.\`)}function BC(e){var t;return typeof e=="function"?t={callback:e}:t=e,t}function WC(e,t){var n=arguments.length>2&&arguments[2]!==void 0?arguments[2]:{},s,r,i,o=function(l){for(var u=arguments.length,c=new Array(u>1?u-1:0),f=1;f<u;f++)c[f-1]=arguments[f];if(i=c,!(s&&l===r)){var d=n.leading;typeof d=="function"&&(d=d(l,r)),(!s||l!==r)&&d&&e.apply(void 0,[l].concat(bd(i))),r=l,clearTimeout(s),s=setTimeout(function(){e.apply(void 0,[l].concat(bd(i))),s=0},t)}};return o._clear=function(){clearTimeout(s),s=null},o}function Om(e,t){if(e===t)return!0;if(eo(e)==="object"){for(var n in e)if(!Om(e[n],t[n]))return!1;return!0}return!1}var UC=(function(){function e(t,n,s){LC(this,e),this.el=t,this.observer=null,this.frozen=!1,this.createObserver(n,s)}return FC(e,[{key:"createObserver",value:function(n,s){var r=this;if(this.observer&&this.destroyObserver(),!this.frozen){if(this.options=BC(n),this.callback=function(a,l){r.options.callback(a,l),a&&r.options.once&&(r.frozen=!0,r.destroyObserver())},this.callback&&this.options.throttle){var i=this.options.throttleOptions||{},o=i.leading;this.callback=WC(this.callback,this.options.throttle,{leading:function(l){return o==="both"||o==="visible"&&l||o==="hidden"&&!l}})}this.oldResult=void 0,this.observer=new IntersectionObserver(function(a){var l=a[0];if(a.length>1){var u=a.find(function(f){return f.isIntersecting});u&&(l=u)}if(r.callback){var c=l.isIntersecting&&l.intersectionRatio>=r.threshold;if(c===r.oldResult)return;r.oldResult=c,r.callback(c,l)}},this.options.intersection),un(function(){r.observer&&r.observer.observe(r.el)})}}},{key:"destroyObserver",value:function(){this.observer&&(this.observer.disconnect(),this.observer=null),this.callback&&this.callback._clear&&(this.callback._clear(),this.callback=null)}},{key:"threshold",get:function(){return this.options.intersection&&typeof this.options.intersection.threshold=="number"?this.options.intersection.threshold:0}}]),e})();function Cm(e,t,n){var s=t.value;if(s)if(typeof IntersectionObserver>"u")console.warn("[vue-observe-visibility] IntersectionObserver API is not available in your browser. Please install this polyfill: https://github.com/w3c/IntersectionObserver/tree/master/polyfill");else{var r=new UC(e,s,n);e._vue_visibilityState=r}}function qC(e,t,n){var s=t.value,r=t.oldValue;if(!Om(s,r)){var i=e._vue_visibilityState;if(!s){Rm(e);return}i?i.createObserver(s,n):Cm(e,{value:s},n)}}function Rm(e){var t=e._vue_visibilityState;t&&(t.destroyObserver(),delete e._vue_visibilityState)}var KC={beforeMount:Cm,updated:qC,unmounted:Rm};function YC(e){return{all:e=e||new Map,on:function(t,n){var s=e.get(t);s&&s.push(n)||e.set(t,[n])},off:function(t,n){var s=e.get(t);s&&s.splice(s.indexOf(n)>>>0,1)},emit:function(t,n){(e.get(t)||[]).slice().map(function(s){s(n)}),(e.get("*")||[]).slice().map(function(s){s(t,n)})}}}var GC={itemsLimit:1e3},QC=/(auto|scroll)/;function $m(e,t){return e.parentNode===null?t:$m(e.parentNode,t.concat([e]))}var Ya=function(t,n){return getComputedStyle(t,null).getPropertyValue(n)},XC=function(t){return Ya(t,"overflow")+Ya(t,"overflow-y")+Ya(t,"overflow-x")},JC=function(t){return QC.test(XC(t))};function yd(e){if(e instanceof HTMLElement||e instanceof SVGElement){for(var t=$m(e.parentNode,[]),n=0;n<t.length;n+=1)if(JC(t[n]))return t[n];return document.scrollingElement||document.documentElement}}function Fl(e){"@babel/helpers - typeof";return Fl=typeof Symbol=="function"&&typeof Symbol.iterator=="symbol"?function(t){return typeof t}:function(t){return t&&typeof Symbol=="function"&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},Fl(e)}var Mm={items:{type:Array,required:!0},keyField:{type:String,default:"id"},direction:{type:String,default:"vertical",validator:function(t){return["vertical","horizontal"].includes(t)}},listTag:{type:String,default:"div"},itemTag:{type:String,default:"div"}};function Nm(){return this.items.length&&Fl(this.items[0])!=="object"}var zl=!1;if(typeof window<"u"){zl=!1;try{var ZC=Object.defineProperty({},"passive",{get:function(){zl=!0}});window.addEventListener("test",null,ZC)}catch{}}let e2=0;var Hc={name:"RecycleScroller",components:{ResizeObserver:ea},directives:{ObserveVisibility:KC},props:{...Mm,itemSize:{type:Number,default:null},gridItems:{type:Number,default:void 0},itemSecondarySize:{type:Number,default:void 0},minItemSize:{type:[Number,String],default:null},sizeField:{type:String,default:"size"},typeField:{type:String,default:"type"},buffer:{type:Number,default:200},pageMode:{type:Boolean,default:!1},prerender:{type:Number,default:0},emitUpdate:{type:Boolean,default:!1},updateInterval:{type:Number,default:0},skipHover:{type:Boolean,default:!1},listTag:{type:String,default:"div"},itemTag:{type:String,default:"div"},listClass:{type:[String,Object,Array],default:""},itemClass:{type:[String,Object,Array],default:""}},emits:["resize","visible","hidden","update","scroll-start","scroll-end"],data(){return{pool:[],totalSize:0,ready:!1,hoverKey:null}},computed:{sizes(){if(this.itemSize===null){const e={"-1":{accumulator:0}},t=this.items,n=this.sizeField,s=this.minItemSize;let r=1e4,i=0,o;for(let a=0,l=t.length;a<l;a++)o=t[a][n]||s,o<r&&(r=o),i+=o,e[a]={accumulator:i,size:o};return this.$_computedMinItemSize=r,e}return[]},simpleArray:Nm,itemIndexByKey(){const{keyField:e,items:t}=this,n={};for(let s=0,r=t.length;s<r;s++)n[t[s][e]]=s;return n}},watch:{items(){this.updateVisibleItems(!0)},pageMode(){this.applyPageMode(),this.updateVisibleItems(!1)},sizes:{handler(){this.updateVisibleItems(!1)},deep:!0},gridItems(){this.updateVisibleItems(!0)},itemSecondarySize(){this.updateVisibleItems(!0)}},created(){this.$_startIndex=0,this.$_endIndex=0,this.$_views=new Map,this.$_unusedViews=new Map,this.$_scrollDirty=!1,this.$_lastUpdateScrollPosition=0,this.prerender&&(this.$_prerender=!0,this.updateVisibleItems(!1)),this.gridItems&&!this.itemSize&&console.error("[vue-recycle-scroller] You must provide an itemSize when using gridItems")},mounted(){this.applyPageMode(),this.$nextTick(()=>{this.$_prerender=!1,this.updateVisibleItems(!0),this.ready=!0})},activated(){const e=this.$_lastUpdateScrollPosition;typeof e=="number"&&this.$nextTick(()=>{this.scrollToPosition(e)})},beforeUnmount(){this.removeListeners()},methods:{addView(e,t,n,s,r){const i=Qd({id:e2++,index:t,used:!0,key:s,type:r}),o=Kl({item:n,position:0,nr:i});return e.push(o),o},unuseView(e,t=!1){const n=this.$_unusedViews,s=e.nr.type;let r=n.get(s);r||(r=[],n.set(s,r)),r.push(e),t||(e.nr.used=!1,e.position=-999999)},handleResize(){this.$emit("resize"),this.ready&&this.updateVisibleItems(!1)},handleScroll(e){if(!this.$_scrollDirty){if(this.$_scrollDirty=!0,this.$_updateTimeout)return;const t=()=>requestAnimationFrame(()=>{this.$_scrollDirty=!1;const{continuous:n}=this.updateVisibleItems(!1,!0);n||(clearTimeout(this.$_refreshTimout),this.$_refreshTimout=setTimeout(this.handleScroll,this.updateInterval+100))});t(),this.updateInterval&&(this.$_updateTimeout=setTimeout(()=>{this.$_updateTimeout=0,this.$_scrollDirty&&t()},this.updateInterval))}},handleVisibilityChange(e,t){this.ready&&(e||t.boundingClientRect.width!==0||t.boundingClientRect.height!==0?(this.$emit("visible"),requestAnimationFrame(()=>{this.updateVisibleItems(!1)})):this.$emit("hidden"))},updateVisibleItems(e,t=!1){const n=this.itemSize,s=this.gridItems||1,r=this.itemSecondarySize||n,i=this.$_computedMinItemSize,o=this.typeField,a=this.simpleArray?null:this.keyField,l=this.items,u=l.length,c=this.sizes,f=this.$_views,d=this.$_unusedViews,h=this.pool,p=this.itemIndexByKey;let g,_,b,y,T;if(!u)g=_=y=T=b=0;else if(this.$_prerender)g=y=0,_=T=Math.min(this.prerender,l.length),b=null;else{const C=this.getScroll();if(t){let W=C.start-this.$_lastUpdateScrollPosition;if(W<0&&(W=-W),n===null&&W<i||W<n)return{continuous:!0}}this.$_lastUpdateScrollPosition=C.start;const q=this.buffer;C.start-=q,C.end+=q;let ne=0;if(this.$refs.before&&(ne=this.$refs.before.scrollHeight,C.start-=ne),this.$refs.after){const W=this.$refs.after.scrollHeight;C.end+=W}if(n===null){let W,L=0,le=u-1,B=~~(u/2),ue;do ue=B,W=c[B].accumulator,W<C.start?L=B:B<u-1&&c[B+1].accumulator>C.start&&(le=B),B=~~((L+le)/2);while(B!==ue);for(B<0&&(B=0),g=B,b=c[u-1].accumulator,_=B;_<u&&c[_].accumulator<C.end;_++);for(_===-1?_=l.length-1:(_++,_>u&&(_=u)),y=g;y<u&&ne+c[y].accumulator<C.start;y++);for(T=y;T<u&&ne+c[T].accumulator<C.end;T++);}else{g=~~(C.start/n*s);const W=g%s;g-=W,_=Math.ceil(C.end/n*s),y=Math.max(0,Math.floor((C.start-ne)/n*s)),T=Math.floor((C.end-ne)/n*s),g<0&&(g=0),_>u&&(_=u),y<0&&(y=0),T>u&&(T=u),b=Math.ceil(u/s)*n}}_-g>GC.itemsLimit&&this.itemsLimitError(),this.totalSize=b;let x;const O=g<=this.$_endIndex&&_>=this.$_startIndex;if(O)for(let C=0,q=h.length;C<q;C++)x=h[C],x.nr.used&&(e&&(x.nr.index=p[x.item[a]]),(x.nr.index==null||x.nr.index<g||x.nr.index>=_)&&this.unuseView(x));const $=O?null:new Map;let F,Q,P;for(let C=g;C<_;C++){F=l[C];const q=a?F[a]:F;if(q==null)throw new Error(\`Key is \${q} on item (keyField is '\${a}')\`);if(x=f.get(q),!n&&!c[C].size){x&&this.unuseView(x);continue}Q=F[o];let ne=d.get(Q),W=!1;if(!x)O?ne&&ne.length?x=ne.pop():x=this.addView(h,C,F,q,Q):(P=$.get(Q)||0,(!ne||P>=ne.length)&&(x=this.addView(h,C,F,q,Q),this.unuseView(x,!0),ne=d.get(Q)),x=ne[P],$.set(Q,P+1)),f.delete(x.nr.key),x.nr.used=!0,x.nr.index=C,x.nr.key=q,x.nr.type=Q,f.set(q,x),W=!0;else if(!x.nr.used&&(x.nr.used=!0,W=!0,ne)){const L=ne.indexOf(x);L!==-1&&ne.splice(L,1)}x.item=F,W&&(C===l.length-1&&this.$emit("scroll-end"),C===0&&this.$emit("scroll-start")),n===null?(x.position=c[C-1].accumulator,x.offset=0):(x.position=Math.floor(C/s)*n,x.offset=C%s*r)}return this.$_startIndex=g,this.$_endIndex=_,this.emitUpdate&&this.$emit("update",g,_,y,T),clearTimeout(this.$_sortTimer),this.$_sortTimer=setTimeout(this.sortViews,this.updateInterval+300),{continuous:O}},getListenerTarget(){let e=yd(this.$el);return window.document&&(e===window.document.documentElement||e===window.document.body)&&(e=window),e},getScroll(){const{$el:e,direction:t}=this,n=t==="vertical";let s;if(this.pageMode){const r=e.getBoundingClientRect(),i=n?r.height:r.width;let o=-(n?r.top:r.left),a=n?window.innerHeight:window.innerWidth;o<0&&(a+=o,o=0),o+a>i&&(a=i-o),s={start:o,end:o+a}}else n?s={start:e.scrollTop,end:e.scrollTop+e.clientHeight}:s={start:e.scrollLeft,end:e.scrollLeft+e.clientWidth};return s},applyPageMode(){this.pageMode?this.addListeners():this.removeListeners()},addListeners(){this.listenerTarget=this.getListenerTarget(),this.listenerTarget.addEventListener("scroll",this.handleScroll,zl?{passive:!0}:!1),this.listenerTarget.addEventListener("resize",this.handleResize)},removeListeners(){this.listenerTarget&&(this.listenerTarget.removeEventListener("scroll",this.handleScroll),this.listenerTarget.removeEventListener("resize",this.handleResize),this.listenerTarget=null)},scrollToItem(e){let t;const n=this.gridItems||1;this.itemSize===null?t=e>0?this.sizes[e-1].accumulator:0:t=Math.floor(e/n)*this.itemSize,this.scrollToPosition(t)},scrollToPosition(e){const t=this.direction==="vertical"?{scroll:"scrollTop",start:"top"}:{scroll:"scrollLeft",start:"left"};let n,s,r;if(this.pageMode){const i=yd(this.$el),o=i.tagName==="HTML"?0:i[t.scroll],a=i.getBoundingClientRect(),u=this.$el.getBoundingClientRect()[t.start]-a[t.start];n=i,s=t.scroll,r=e+o+u}else n=this.$el,s=t.scroll,r=e;n[s]=r},itemsLimitError(){throw setTimeout(()=>{console.log("It seems the scroller element isn't scrolling, so it tries to render all the items at once.","Scroller:",this.$el),console.log("Make sure the scroller has a fixed height (or width) and 'overflow-y' (or 'overflow-x') set to 'auto' so it can scroll correctly and only render the items visible in the scroll viewport.")}),new Error("Rendered items limit reached")},sortViews(){this.pool.sort((e,t)=>e.nr.index-t.nr.index)}}};const t2={key:0,ref:"before",class:"vue-recycle-scroller__slot"},n2={key:1,ref:"after",class:"vue-recycle-scroller__slot"};function s2(e,t,n,s,r,i){const o=ec("ResizeObserver"),a=gb("observe-visibility");return jt((H(),oe("div",{class:$t(["vue-recycle-scroller",{ready:r.ready,"page-mode":n.pageMode,[\`direction-\${e.direction}\`]:!0}]),onScrollPassive:t[0]||(t[0]=(...l)=>i.handleScroll&&i.handleScroll(...l))},[e.$slots.before?(H(),oe("div",t2,[yn(e.$slots,"before")],512)):Ce("v-if",!0),(H(),qe(au(n.listTag),{ref:"wrapper",style:ri({[e.direction==="vertical"?"minHeight":"minWidth"]:r.totalSize+"px"}),class:$t(["vue-recycle-scroller__item-wrapper",n.listClass])},{default:Qt(()=>[(H(!0),oe(Xe,null,Fn(r.pool,l=>(H(),qe(au(n.itemTag),Po({key:l.nr.id,style:r.ready?{transform:\`translate\${e.direction==="vertical"?"Y":"X"}(\${l.position}px) translate\${e.direction==="vertical"?"X":"Y"}(\${l.offset}px)\`,width:n.gridItems?\`\${e.direction==="vertical"&&n.itemSecondarySize||n.itemSize}px\`:void 0,height:n.gridItems?\`\${e.direction==="horizontal"&&n.itemSecondarySize||n.itemSize}px\`:void 0}:null,class:["vue-recycle-scroller__item-view",[n.itemClass,{hover:!n.skipHover&&r.hoverKey===l.nr.key}]]},mb(n.skipHover?{}:{mouseenter:()=>{r.hoverKey=l.nr.key},mouseleave:()=>{r.hoverKey=null}})),{default:Qt(()=>[yn(e.$slots,"default",{item:l.item,index:l.nr.index,active:l.nr.used})]),_:2},1040,["style","class"]))),128)),yn(e.$slots,"empty")]),_:3},8,["style","class"])),e.$slots.after?(H(),oe("div",n2,[yn(e.$slots,"after")],512)):Ce("v-if",!0),Ae(o,{onNotify:i.handleResize},null,8,["onNotify"])],34)),[[a,i.handleVisibilityChange]])}Hc.render=s2;Hc.__file="src/components/RecycleScroller.vue";var Vc={name:"DynamicScroller",components:{RecycleScroller:Hc},provide(){return typeof ResizeObserver<"u"&&(this.$_resizeObserver=new ResizeObserver(e=>{requestAnimationFrame(()=>{if(Array.isArray(e)){for(const t of e)if(t.target&&t.target.$_vs_onResize){let n,s;if(t.borderBoxSize){const r=t.borderBoxSize[0];n=r.inlineSize,s=r.blockSize}else n=t.contentRect.width,s=t.contentRect.height;t.target.$_vs_onResize(t.target.$_vs_id,n,s)}}})})),{vscrollData:this.vscrollData,vscrollParent:this,vscrollResizeObserver:this.$_resizeObserver}},inheritAttrs:!1,props:{...Mm,minItemSize:{type:[Number,String],required:!0}},emits:["resize","visible"],data(){return{vscrollData:{active:!0,sizes:{},keyField:this.keyField,simpleArray:!1}}},computed:{simpleArray:Nm,itemsWithSize(){const e=[],{items:t,keyField:n,simpleArray:s}=this,r=this.vscrollData.sizes,i=t.length;for(let o=0;o<i;o++){const a=t[o],l=s?o:a[n];let u=r[l];typeof u>"u"&&!this.$_undefinedMap[l]&&(u=0),e.push({item:a,id:l,size:u})}return e}},watch:{items(){this.forceUpdate()},simpleArray:{handler(e){this.vscrollData.simpleArray=e},immediate:!0},direction(e){this.forceUpdate(!0)},itemsWithSize(e,t){const n=this.$el.scrollTop;let s=0,r=0;const i=Math.min(e.length,t.length);for(let a=0;a<i&&!(s>=n);a++)s+=t[a].size||this.minItemSize,r+=e[a].size||this.minItemSize;const o=r-s;o!==0&&(this.$el.scrollTop+=o)}},beforeCreate(){this.$_updates=[],this.$_undefinedSizes=0,this.$_undefinedMap={},this.$_events=YC()},activated(){this.vscrollData.active=!0},deactivated(){this.vscrollData.active=!1},unmounted(){this.$_events.all.clear()},methods:{onScrollerResize(){this.$refs.scroller&&this.forceUpdate(),this.$emit("resize")},onScrollerVisible(){this.$_events.emit("vscroll:update",{force:!1}),this.$emit("visible")},forceUpdate(e=!1){(e||this.simpleArray)&&(this.vscrollData.sizes={}),this.$_events.emit("vscroll:update",{force:!0})},scrollToItem(e){const t=this.$refs.scroller;t&&t.scrollToItem(e)},getItemSize(e,t=void 0){const n=this.simpleArray?t??this.items.indexOf(e):e[this.keyField];return this.vscrollData.sizes[n]||0},scrollToBottom(){if(this.$_scrollingToBottom)return;this.$_scrollingToBottom=!0;const e=this.$el;this.$nextTick(()=>{e.scrollTop=e.scrollHeight+5e3;const t=()=>{e.scrollTop=e.scrollHeight+5e3,requestAnimationFrame(()=>{e.scrollTop=e.scrollHeight+5e3,this.$_undefinedSizes===0?this.$_scrollingToBottom=!1:requestAnimationFrame(t)})};requestAnimationFrame(t)})}}};function r2(e,t,n,s,r,i){const o=ec("RecycleScroller");return H(),qe(o,Po({ref:"scroller",items:i.itemsWithSize,"min-item-size":n.minItemSize,direction:e.direction,"key-field":"id","list-tag":e.listTag,"item-tag":e.itemTag},e.$attrs,{onResize:i.onScrollerResize,onVisible:i.onScrollerVisible}),{default:Qt(({item:a,index:l,active:u})=>[yn(e.$slots,"default",Od(ic({item:a.item,index:l,active:u,itemWithSize:a})))]),before:Qt(()=>[yn(e.$slots,"before")]),after:Qt(()=>[yn(e.$slots,"after")]),empty:Qt(()=>[yn(e.$slots,"empty")]),_:3},16,["items","min-item-size","direction","list-tag","item-tag","onResize","onVisible"])}Vc.render=r2;Vc.__file="src/components/DynamicScroller.vue";var km={name:"DynamicScrollerItem",inject:["vscrollData","vscrollParent","vscrollResizeObserver"],props:{item:{required:!0},watchData:{type:Boolean,default:!1},active:{type:Boolean,required:!0},index:{type:Number,default:void 0},sizeDependencies:{type:[Array,Object],default:null},emitResize:{type:Boolean,default:!1},tag:{type:String,default:"div"}},emits:["resize"],computed:{id(){if(this.vscrollData.simpleArray)return this.index;if(this.vscrollData.keyField in this.item)return this.item[this.vscrollData.keyField];throw new Error(\`keyField '\${this.vscrollData.keyField}' not found in your item. You should set a valid keyField prop on your Scroller\`)},size(){return this.vscrollData.sizes[this.id]||0},finalActive(){return this.active&&this.vscrollData.active}},watch:{watchData:"updateWatchData",id(e,t){if(this.$el.$_vs_id=this.id,this.size||this.onDataUpdate(),this.$_sizeObserved){const n=this.vscrollData.sizes[t],s=this.vscrollData.sizes[e];n!=null&&n!==s&&this.applySize(n)}},finalActive(e){this.size||(e?this.vscrollParent.$_undefinedMap[this.id]||(this.vscrollParent.$_undefinedSizes++,this.vscrollParent.$_undefinedMap[this.id]=!0):this.vscrollParent.$_undefinedMap[this.id]&&(this.vscrollParent.$_undefinedSizes--,this.vscrollParent.$_undefinedMap[this.id]=!1)),this.vscrollResizeObserver?e?this.observeSize():this.unobserveSize():e&&this.$_pendingVScrollUpdate===this.id&&this.updateSize()}},created(){if(!this.$isServer&&(this.$_forceNextVScrollUpdate=null,this.updateWatchData(),!this.vscrollResizeObserver)){for(const e in this.sizeDependencies)this.$watch(()=>this.sizeDependencies[e],this.onDataUpdate);this.vscrollParent.$_events.on("vscroll:update",this.onVscrollUpdate)}},mounted(){this.finalActive&&(this.updateSize(),this.observeSize())},beforeUnmount(){this.vscrollParent.$_events.off("vscroll:update",this.onVscrollUpdate),this.unobserveSize()},methods:{updateSize(){this.finalActive?this.$_pendingSizeUpdate!==this.id&&(this.$_pendingSizeUpdate=this.id,this.$_forceNextVScrollUpdate=null,this.$_pendingVScrollUpdate=null,this.computeSize(this.id)):this.$_forceNextVScrollUpdate=this.id},updateWatchData(){this.watchData&&!this.vscrollResizeObserver?this.$_watchData=this.$watch("item",()=>{this.onDataUpdate()},{deep:!0}):this.$_watchData&&(this.$_watchData(),this.$_watchData=null)},onVscrollUpdate({force:e}){!this.finalActive&&e&&(this.$_pendingVScrollUpdate=this.id),(this.$_forceNextVScrollUpdate===this.id||e||!this.size)&&this.updateSize()},onDataUpdate(){this.updateSize()},computeSize(e){this.$nextTick(()=>{if(this.id===e){const t=this.$el.offsetWidth,n=this.$el.offsetHeight;this.applyWidthHeight(t,n)}this.$_pendingSizeUpdate=null})},applyWidthHeight(e,t){const n=~~(this.vscrollParent.direction==="vertical"?t:e);n&&this.size!==n&&this.applySize(n)},applySize(e){this.vscrollParent.$_undefinedMap[this.id]&&(this.vscrollParent.$_undefinedSizes--,this.vscrollParent.$_undefinedMap[this.id]=void 0),this.vscrollData.sizes[this.id]=e,this.emitResize&&this.$emit("resize",this.id)},observeSize(){this.vscrollResizeObserver&&(this.$_sizeObserved||(this.vscrollResizeObserver.observe(this.$el),this.$el.$_vs_id=this.id,this.$el.$_vs_onResize=this.onResize,this.$_sizeObserved=!0))},unobserveSize(){this.vscrollResizeObserver&&this.$_sizeObserved&&(this.vscrollResizeObserver.unobserve(this.$el),this.$el.$_vs_onResize=void 0,this.$_sizeObserved=!1)},onResize(e,t,n){this.id===e&&this.applyWidthHeight(t,n)}},render(){return Fo(this.tag,this.$slots.default())}};km.__file="src/components/DynamicScrollerItem.vue";const i2={key:1,class:"h-auto"},o2={class:"d-flex flex-column gap-2 align-items-center"},a2={key:1,class:"text-primary spinner-border mb-3",role:"status"},l2={key:1,class:"mt-5 text-center"},c2=at({__name:"MessageList",props:{isEmbedded:{type:Boolean}},setup(e){const t=Ne(pi),n=Ne(bi),s=re(null);Je(s,()=>{t.internal.ref.value=s.value});const r=re();function i(){zv(r)}const o=Ne(bs),a=re(!1),l=vs({onError:h=>{o?.showToast(h)},onLoading:h=>{a.value=h}}),u=re(null),{isOverDropZone:c}=ox(u,{onDrop:async h=>{h&&await l.importRbelLogFile({rbelFileContent:await h[0].text()})},multiple:!1,preventDefaultForUnhandled:!1}),{files:f,open:d}=ux({multiple:!1,accept:"*/*"});return Je(f,async h=>{h&&await l.importRbelLogFile({rbelFileContent:await h[0].text()})}),(h,p)=>A(t).internal.messages.value.length>0?(H(),qe(A(Vc),{key:0,ref_key:"dynamicScrollerRef",ref:s,items:A(t).internal.messages.value,"min-item-size":200,"emit-update":!0,keyField:"uuid",class:"h-100 overflow-y-scroll scroll-container",onUpdate:A(t).internal.update},{default:Qt(({item:g,active:_})=>[Ae(A(km),{item:g,active:_,"size-dependencies":[g,r.value,A(n).hideMessageHeaders,A(n).hideMessageDetails],class:"message"},{default:Qt(()=>[(H(),qe(Tm,{message:g,key:g.uuid+g.type,"on-toggle-details-or-header":i},null,8,["message"]))]),_:2},1032,["item","active","size-dependencies"])]),_:1},8,["items","onUpdate"])):(H(),oe("div",i2,[h.isEmbedded?(H(),oe("div",l2,"Loading...")):(H(),oe("div",{key:0,class:$t(["container","mt-5",a.value?"disabled":""]),ref_key:"dropZoneRef",ref:u},[w("div",{class:$t(["drop-zone border rounded p-4 text-center",{"bg-light":A(c)}])},[w("div",o2,[p[2]||(p[2]=w("h3",{class:"mb-3"},"Feed the Tiger",-1)),a.value?Ce("",!0):(H(),qe(A(ft),{key:0,icon:A(tC),size:"3x",class:"text-primary mb-3"},null,8,["icon"])),a.value?(H(),oe("div",a2,[...p[1]||(p[1]=[w("span",{class:"visually-hidden"},"Loading...",-1)])])):Ce("",!0),p[3]||(p[3]=w("p",null,[ze("Drop a "),w("strong",null,"*.tgr"),ze(" log file here")],-1)),p[4]||(p[4]=w("p",null,"- or -",-1)),w("button",{type:"button",class:"btn btn-outline-primary",onClick:p[0]||(p[0]=()=>A(d)())}," Browse Files ")])],2)],2))]))}}),u2=qn(c2,[["__scopeId","data-v-14d251ff"]]);function f2(e){const{testFilter:t}=vs(e),n=re(!1),s=re(null);let r=new AbortController;async function i(l){try{r.abort(),r=new AbortController,n.value=!0;const u=await t({rbelPath:l,signal:r.signal},{suppressError:!0,propagateError:!0});u&&(s.value=u)}catch(u){u instanceof DOMException&&u.name==="AbortError"||e.onError&&(u instanceof pg?e.onError(u.message,u.response.status):e.onError(u.message,-1))}finally{n.value=!1}}const o=yl(async l=>{a(),await i(l)},300),a=()=>{n.value=!1,s.value=null};return{isLoading:Mt(n),rbelTestResult:Mt(s),testRbel:o,resetTestResult:a}}const Sr=Symbol("rbelFilterSymbol");function d2(){return{rbelPath:re("")}}const h2={class:"modal-dialog"},p2={class:"modal-content",id:""},g2={class:"modal-body"},m2={class:"invalid-feedback"},v2={class:"d-flex flex-row gap-2 mt-2"},b2={class:"dropdown"},y2={class:"dropdown-menu test-select-recipient"},_2=["onClick"],E2={class:"dropdown"},w2={class:"dropdown-menu test-select-sender"},S2=["onClick"],x2={class:"modal-footer"},T2={key:0,class:"pe-2 d-inline-flex align-content-center gap-2"},A2={key:0,class:"text-muted spinner-border spinner-border-sm",role:"status"},O2={key:1,class:"f-caption",id:"filteredMessage"},C2=["disabled"],R2=at({__name:"RbelFilterModal",setup(e){const t=Ne(Sr),n=Ne(pi),s=Ne(bs),r=re(!1),i=f2({onError:p=>{r.value=!0,s.showToast(p)}}),o=Qp(t.rbelPath.value,{onBeforeChange:p=>{p&&i.testRbel(p)}}),a=i.isLoading,l=i.rbelTestResult,u=re(null);Lt(()=>{u.value&&u.value.addEventListener("show.bs.modal",()=>{o.value=t.rbelPath.value,i.testRbel(o.value)})});const c=go(n.messagesMeta,()=>{const p=[],g=[];return n.messagesMeta.value.forEach(_=>{_.recipient&&p.push(_.recipient),_.sender&&g.push(_.sender)}),{recipient:f(p,20).sort((_,b)=>_.localeCompare(b)),sender:f(g,20).sort((_,b)=>_.localeCompare(b))}});function f(p,g){const _=new Map;return p.forEach(b=>_.set(b,(_.get(b)||0)+1)),[..._.entries()].sort((b,y)=>y[1]-b[1]).slice(0,g).map(([b])=>b)}function d(p){o.value+=\`$.sender == "\${p}"\`}function h(p){o.value+=\`$.receiver == "\${p}"\`}return(p,g)=>(H(),oe("div",{ref_key:"modalRef",ref:u,class:"modal fade",id:"filterBackdrop","data-bs-backdrop":"static","data-bs-keyboard":"false",tabindex:"-1","aria-labelledby":"filterBackdropLabel","aria-hidden":"true"},[w("div",h2,[w("div",p2,[g[7]||(g[7]=w("div",{class:"modal-header"},[w("h1",{class:"modal-title fs-5",id:"filterBackdropLabel"},"Filter"),w("button",{type:"button",class:"btn-close","data-bs-dismiss":"modal","aria-label":"Close"})],-1)),w("div",g2,[g[4]||(g[4]=w("label",{for:"rbelFilterExpressionTextArea",class:"form-label"},"JEXL Expression",-1)),jt(w("textarea",{class:$t(["form-control",A(l)?.errorMessage?"is-invalid":""]),"aria-label":"Enter JEXL Expression","onUpdate:modelValue":g[0]||(g[0]=_=>Ze(o)?o.value=_:null),id:"rbelFilterExpressionTextArea"},null,2),[[Rs,A(o)]]),w("div",m2,Fe(A(l)?.errorMessage),1),w("div",v2,[w("div",b2,[g[2]||(g[2]=w("button",{class:"btn btn-outline-dark dropdown-toggle btn-sm",type:"button","data-bs-toggle":"dropdown","aria-expanded":"false"}," Insert Recipient ",-1)),w("ul",y2,[(H(!0),oe(Xe,null,Fn(A(c).recipient,_=>(H(),oe("li",{key:_},[w("a",{class:"dropdown-item",onClick:()=>h(_)},Fe(_),9,_2)]))),128))])]),w("div",E2,[g[3]||(g[3]=w("button",{class:"btn btn-outline-dark dropdown-toggle btn-sm",type:"button","data-bs-toggle":"dropdown","aria-expanded":"false"}," Insert Sender ",-1)),w("ul",w2,[(H(!0),oe(Xe,null,Fn(A(c).sender,_=>(H(),oe("li",{key:_},[w("a",{class:"dropdown-item",onClick:()=>d(_)},Fe(_),9,S2)]))),128))])])]),g[5]||(g[5]=rl('<div class="mt-4 f-caption"><span class="fw-semibold">RBeL-Path Quick Help</span><div><p> RBeL-Path is a powerful expression language inspired by XPath and JSON-Path, designed for quick navigation of captured RBeL-Traffic (RbelElement-tree). For detailed documentation, visit <a href="https://gematik.github.io/app-Tiger/Tiger-User-Manual.html#_understanding_rbelpath" target="_blank">this page</a>. </p><span class="fw-semibold">Examples:</span><ul class="list-group"><li class="list-group-item"><code>$.body</code> <br><small>Accesses the body of the message.</small></li><li class="list-group-item"><code>$..Action</code> <br><small>Finds all nodes named <strong>Action</strong> across the entire tree.</small></li><li class="list-group-item"><code>$.body..Action</code> <br><small>Finds all nodes named <strong>Action</strong> within the body.</small></li><li class="list-group-item"><code>$..[?(content =~ &quot;UTF-.*&quot;)]</code> <br><small>Matches nodes with text starting with <strong>UTF-</strong> using a JEXL-Expression.</small></li></ul></div></div>',1))]),w("div",x2,[A(l)||A(a)?(H(),oe("div",T2,[A(a)?(H(),oe("div",A2,[...g[6]||(g[6]=[w("span",{class:"visually-hidden"},"Loading...",-1)])])):Ce("",!0),A(l)?(H(),oe("span",O2,"Matched "+Fe(A(l).totalFiltered??"?")+" of "+Fe(A(l).total),1)):Ce("",!0)])):Ce("",!0),w("button",{type:"button",class:"btn btn-primary",id:"setFilterCriterionBtn",disabled:A(l)?.errorMessage!=null,"data-bs-dismiss":"modal",onClick:g[1]||(g[1]=()=>A(t).rbelPath.value=A(o))}," Apply Filter ",8,C2)])])])],512))}}),$2=["data-type","data-label"],M2=["contenteditable"],N2={class:"ssh-pre__original"},Im={__name:"simple-syntax-highlighter",props:{language:{type:String,default:""},label:{type:[String,Boolean],default:!1},tab:{type:[Boolean,String],default:"  "},dark:{type:Boolean,default:!1},copyButton:{type:Boolean,default:!1},editable:{type:Boolean,default:!1}},emits:["copied"],setup(e,{emit:t}){const n={quote:/("(?:\\\\"|[^"])*")|('(?:\\\\'|[^'])*')/,comment:/(\\/\\/.*?(?:\\n|$)|\\/\\*.*?(?:\\*\\/|$))/,doctype:/(&lt;!DOCTYPE.*?&gt;)/,htmlTag:/&lt;(?:([a-z][\\w:-]*)((?:[\\w\\- ]+=(?:"[^"]*"|'[^']*'))*|(?:[^&]|&(?:lt|amp|quot|apos|gt);)*?)(\\s*\\/?)|(\\/?)([a-z][\\w:-]*))&gt;/,htmlentity:/(&amp;(?:[a-z]+|#x?\\d+);)/,punctuation:new RegExp("(!==?|(?:[[\\\\](){}.:,+\\\\-?=!])+|(?<!&(?:[a-z]+|#x?\\\\d+));|\\\\|\\\\||&lt;|&gt;|&amp;)"),number:/(-?(?:\\.\\d+|\\d+(?:\\.\\d+)?))/,boolean:/\\b(true|false)\\b/},s={shell:{quote:n.quote,comment:/(#.*?)(?:\\n|$)/,keyword:/\\b(p?npm|yarn|i(?:nstall)?|run|audit|outdated|update|publish|whoami|cd|sudo|chmod|chown|ls|cat|vim?|scp|rm|mv|mkdir|ln|open|cwd|which|clear|curl|ping|systemctl|echo|export|open|bash|exit)\\b/,param:/( --(?:save|save-dev))(?:\\s|$)/},xml:{doctype:n.doctype,quote:n.quote,comment:/(&lt;!--.*?(?:--&gt;|$))/,htmlentity:n.htmlentity,tag:n.htmlTag},html:{doctype:n.doctype,quote:n.quote,comment:/(&lt;!--.*?(?:--&gt;|$))/,htmlentity:n.htmlentity,tag:n.htmlTag},"html-vue":{doctype:n.doctype,quote:n.quote,comment:/(&lt;!--.*?(?:--&gt;|$))/,htmlentity:n.htmlentity,tag:/&lt;(?:([a-z][\\w:-]*)((?:[\\w-]+\\s*=(?:"[^"]*"|'[^']*'))*|(?:[^&]|&(?:lt|amp|quot|apos|gt);)*?)(\\s*\\/?)|(\\/?)([a-z][\\w:-]*))&gt;/},pug:{text:/((?:^|\\n)[ \\t]*|^)\\|([ \\t]*)([^\\n]+(?=\\s*(?:\\n|$)))/,text2:/([ \\t]*)([.#\\w-]+(?:\\([^)]*\\))*)\\.\\n((?:\\n+(?=\\4[ \\t]+)|(?=\\4[ \\t]+).+?(?:\\n|$)*?)*)(?=\\s*(?:\\n|$))/,quote:n.quote,comment:/(^|\\n)([ \\t]*|^)(\\/\\/-[ \\t]*(?:[^\\n]*?(?:\\n\\10[ \\t]+[^\\n]*)+|[^\\n]+(?=\\n|$)))/,tag:/([a-z][\\w:-]*|)([.#][a-z][.\\w-]*|)\\b(?:\\((\\s*(?:[#@:]?[a-z][\\w-.:]+(?:=(?:"[^"]*"|'[^']*'))*\\s*)*)\\))?(\\.?)([ \\t]*)([^\\n]+)?(?=\\n|$)/,"inline-tag":/#\\[([^[\\]]+)\\]/},css:{comment:/(\\/\\*.+?(?:\\*\\/|$))/,quote:/("(?:\\\\"|[^"])*")|('(?:\\\\'|[^'])*')/,pseudo:/(:(?:hover|active|focus|visited|not|before|after|(?:first|last|nth)-child))/,"selector keyword vendor":/(@-(?:moz|o|webkit|ms)-(?=keyframes\\s))/,"selector keyword":/((?:@(?:import|media|font-face|keyframes)|screen|print|and)(?=[\\s({])|keyframes|\\s(?:ul|ol|li|table|div|pre|p|a|img|br|hr|h[1-6]|em|strong|span|html|body|iframe|video|audio|input|button|form|label|fieldset|small|abbr|i|dd|dt)\\b)(?=.*\\{})/,variable:/(--[a-z0-9-]+)/,selector:/((?:[.#-\\w*+ >:,[\\]="~\\n]|&gt;)+)(?=\\s*\\{)/,"attribute keyword vendor":/(-(?:moz|o|webkit|ms)-(?=transform|transition|user-select|tap-highlight-color|animation|background-size|box-shadow))/,"attribute keyword":/\\b(content|float|display|position|top|left|right|bottom|(?:(?:max|min)-)?width|(?:(?:max|min|line)-)?height|font(?:-(?:family|style|size|weight|variant|stretch))?|vertical-align|color|opacity|visibility|z-index|pointer-events|user-select|transform(?:-(?:origin|style|delay|duration|property|timing-function))?|transition(?:-(?:delay|duration))?|animation(?:-(?:name|delay|duration|direction|fill-mode))?|backface-visibility|backdrop-filter|background(?:-(?:color|position|image|repeat|size|attachment|origin|clip|blend-mode))?|(?:padding|margin|border)(?:-(?:top|left|right|bottom))?|border(?:-(?:radius|color|width|style|spacing))|white-space|text-(?:align|transform|decoration|shadow|indent)|overflow(?:-(?:x|y))?|(?:letter|word)-spacing|word-break|box-(?:sizing|shadow)|stroke(?:-(?:width|opacity|dasharray|dashoffset|linecap|linejoin))?|fill|speak|outline|user-select|cursor|flex(?:-(?:direction|flow|grow|shrink|basis|wrap))?|(?:justify|align)-(?:content|self|items))(?=\\s*:)/,"value keyword vendor":/(-(?:moz|o|webkit|ms)-(?=linear-gradient))/,"value keyword":/\\b(inherit|initial|normal|none|unset|auto|inline(?:-(?:block|flex))?|block|flex|absolute|relative|static|fixed|sticky|hidden|visible|top|left|right|bottom|center|middle|baseline|solid|dotted|dashed|line-through|(?:over|under)line|wavy|double|(?:pre-|no)?wrap|pre|break-word|(?:upper|lower)case|capitalize|italic|bold|attr\\(.*?\\)|linear|ease(?:-in)?(?:-out)?|all|infinite|cubic-bezier|(?:translate|rotate)(?:[X-Z]|3d)?|skew[XY]?|scale|(?:no-)?repeat|repeat(?:-x|-y)|contain|cover|url|(?:repeating-)?(?:linear|radial)-gradient|inset|pointer|(?:flex-)?(?:start|end)|space-(?:between|evenly|around)|stretch|revert|row(?:-reverse)?|column(?:-reverse)?)(?=\\s*[,;}(]|\\s+[\\da-z!])/,"value keyword important":/( ?!important)/,number:n.number,color:/(transparent|#(?:[\\da-f]{8}|[\\da-f]{6}|[\\da-f]{3})|rgba?\\([\\d., ]*\\))/,htmlentity:n.htmlentity,punctuation:/([:,;{}@#()!]+)/,attribute:/([a-z-]+)(?=\\s*:)/,unit:/(px|pt|cm|%|r?em|m?s|deg|vh|vw|vmin|vmax)(?=(?:\\s*[;,{}})]|\\s+[-\\da-z#]))/,error:/([:,;{}@#()!]+|&lt;|&gt;|&amp;)/},json:{quote:/("(?:\\\\"|[^"])*")/,number:n.number,boolean:n.boolean,punctuation:/([[\\](){}:,]+)/,error:/(&(:?lt|gt|amp);|(?!\\s).)/},js:{quote:n.quote,comment:n.comment,number:/\\b(\\d+(?:\\.\\d+)?|null)\\b/,boolean:n.boolean,this:/\\b(this)(?=\\W)/,keyword:/\\b(new|getElementsBy(?:Tag|Class|)Name|getElementById|querySelector|querySelectorAll|arguments|if|else|do|return|case|default|(?:f|F)unction|typeof|instanceof|undefined|document(?:Element)?|window|console|while|for|forEach|switch|in|break|continue|delete|length|var|let|const|export|import|as|require|from|Class|constructor|Number|Boolean|String|Array|Object|RegExp|Integer|Date|Promise|Proxy|WeakMap|WeakSet|Symbol|SyncManager|File(?:Reader)?|DataTransfer|DocumentFragment|async|await|(?:clear|set)(?:Timeout|Interval)|parse(?:Int|Float)|Math(?=\\.)|isNaN|atob|btoa|getComputedStyle)(?=\\W)/,htmlentity:n.htmlentity,punctuation:/(!==?|[[\\]!(){}:;,+\\-%*/?=]+|\\.+(?![a-z])|\\|\\||&lt;|&gt;|&amp;)/,variable:/(\\.?[a-z_]\\w*)/,"external-var":/(\\$|jQuery|JSON)(?=\\W|$)/},php:{quote:n.quote,comment:n.comment,special:/(&lt;\\?(?:php)?|\\?&gt;|__(?:DIR|FILE|LINE|CLASS|METHOD|FUNCTION|NAMESPACE|TRAIT)__)/,punctuation:n.punctuation,number:n.number,boolean:n.boolean,variable:/(\\$\\w+)/,keyword:/\\b(define|echo|die|exit|print_r|var_dump|if|else|elseif|do|return|case|default|function|\\$this|while|foreach|for|switch|in|break|continue|empty|isset|unset|parse_ini_file|session_(?:start|destroy|id)|header|json_(?:encode|decode)|error_log|(require|include)(:?_once)?|try|throw|new|Exception|catch|finally|preg_(?:match|replace)|list|strlen|substr|str_replace|array_(?:keys|values))(?=\\W|$)/},sql:{quote:n.quote,comment:/((?:--|#)\\s.*?(?:\\n|$)|\\/\\*.*?\\*\\/)/,punctuation:n.punctuation,number:/\\b(\\d+(?:\\.\\d+)?|null)\\b/,boolean:n.boolean,keyword:/\\b(\\*|DECLARE|BEGIN|END|RETURNS|FUNCTION|CREATE|DATABASE|TABLE|VIEW|COLUMN|INDEX|GRANT|REVOKE|ALL|PRIVILEGES|IDENTIFIED|FLUSH|ALTER|MODIFY|DROP|TRUNCATE|CONSTRAINT|ADD|CHECK|(?:(?:PRIMARY|FOREIGN|UNIQUE) )?KEY|REFERENCES|AUTO_INCREMENT|COMMENT|DEFAULT|UNSIGNED|CHARSET|COLLATE|CHARACTER|ENGINE|SQL_MODE|USE|IF|THEN|NULL|EXISTS|UNIQUE|SELECT|UPDATE|DELETE|(?:INSERT|REPLACE)(?: INTO)?|VALUES|SET|FROM|WHERE|(?:ORDER|GROUP) BY|LIMIT|(?:(?:LEFT|RIGHT|INNER|OUTER|CROSS) |)JOIN|AS|ON|COUNT|AVG|SUM|MIN|MAX|CASE|TO|WHEN|BETWEEN|AND|OR|NOT|IN|LIKE|IS|CONCAT|SUBSTRING|CURRENT_(?:DATE|TIMESTAMP)|USING|HAVING?)(?=\\W|$)/,"var-type":/\\b((?:var)?char|(?:tiny|small|medium|big)?int|decimal|float|double|real|bit|boolean|date(?:time)?|time(?:stamp)?|year|(?:tiny|medium|long)?(?:text|blob)|enum)\\b/}},r={xml:/(\\s*)([a-z\\d\\-:]+)(?:=("|')(.*?)\\3)?/g,html:/(\\s*)([a-z-]+)(?:=("|')(.*?)\\3)?/gs,"html-vue":/(\\s*)([@:#]?[a-z\\d-]+)(?:(?:=("|')(.*?)\\3)|)/gs,pug:/(\\s*|,)([@:#]?[a-z\\d-]+)(?:(?:=("|')(.*?)\\3)|)/g},i={shell:{quote:2},xml:{quote:2,tag:5},html:{quote:2,tag:5},"html-vue":{quote:2,tag:5},pug:{text:3,text2:3,quote:2,comment:3,tag:6},json:{},php:{quote:2},sql:{quote:2},css:{quote:2},js:{quote:2}},o=e,a=t,l=re(Object.keys(s)),u=re(null),c=bb(),f=P=>P.map(C=>{if(!C.children||typeof C.children=="string")return C.children||"";if(Array.isArray(C.children))return f(C.children);if(C.children.default)return f(C.children.default())}).join(""),d=P=>P.replace(/[<>]/g,C=>({"<":"&lt;",">":"&gt;"})[C]),h=P=>{if(P==="transparent")return{dark:!1,alpha:0};const C=Z=>Z<=.03928?Z/12.92:Math.pow((Z+.055)/1.055,2.4);let q=0,ne=0,W=0,L=1;const le=P.match(/rgba?\\((\\d+),\\s*(\\d+),\\s*(\\d+)(?:,\\s*([\\d.]+))?\\)/),B=P.match(/^#([\\da-f]{3,8})$/i);if(le)q=parseInt(le[1])/255,ne=parseInt(le[2])/255,W=parseInt(le[3])/255,le[4]&&(L=parseFloat(le[4]));else if(B){const Z=B[1],we=Z.length===3||Z.length===4;q=parseInt(we?Z[0]+Z[0]:Z.substring(0,2),16)/255,ne=parseInt(we?Z[1]+Z[1]:Z.substring(2,4),16)/255,W=parseInt(we?Z[2]+Z[2]:Z.substring(4,6),16)/255,(Z.length===4||Z.length===8)&&(L=parseInt(we?Z[3]+Z[3]:Z.substring(6,8),16)/255)}const ue=.2126*C(q)+.7152*C(ne)+.0722*C(W);return{dark:L*ue+(1-L)*1<=.45,alpha:L}},p=()=>{let P="";const C=[];for(const q in s[o.language]){const ne=i[o.language][q]||1;for(let W=0;W<ne;W++)C.push(q);P+=(P?"|":"")+s[o.language][q].source}return[P,C]},g=P=>{const C=(q,ne,W,L,le)=>\`\${ne}<span class="attribute">\${W}</span>\`+(L||le?'<span class="punctuation">=</span>':"")+(L||le?\`<span class="quote">\${L||""}\${le||""}\${L||""}</span>\`:"");if(o.language==="pug"){let[q,ne="",W="",L="",le="",B=""]=P;return ne=ne.replace(/#[\\w-]+/g,ue=>\`<span class="id">\${ue}</span>\`).replace(/\\.[\\w-]+/g,ue=>\`<span class="class">\${ue}</span>\`),W&&(W=W.replace(r.pug,C),W='<span class="punctuation">(</span>'+W+'<span class="punctuation">)</span>'),B&&(B=_(B)),\`<span class="tag-name">\${q}</span>\${ne}\${W}\`+(L?'<span class="punctuation">.</span>':"")+(le||"")+(B?\`<span class="text">\${B}</span>\`:"")}else{const[q,ne="",W="",L="",le]=P,B=ne.replace(r[o.language],C);return\`<span class="punctuation">&lt;\${L}</span><span class="tag-name">\${q||le}</span>\`+B+\`<span class="punctuation">\${W}&gt;</span>\`}},_=P=>P.replace(new RegExp(s.pug["inline-tag"],"gsi"),(C,q)=>'<span class="inline-tag">#[</span>'+q.replace(new RegExp(s.pug.tag,"si"),(ne,...W)=>(W=W.slice(0,W.length-2),g(W)))+'<span class="inline-tag">]</span>'),b=()=>{if(l.value.includes(o.language)){const P=y();u.value.innerHTML=$(u.value.innerText),T(u.value.childNodes,P)}},y=()=>{const P=window.getSelection();P.collapseToEnd();const C=new Range;return C.setStart(u.value,0),C.setEnd(P.extentNode,P.extentOffset),C.toString().length},T=(P,C)=>{var q,ne;let W=0;for(const L of P){const le=((q=L.innerText)==null?void 0:q.length)||L.length;if(W+le>=C){L.childNodes.length>1?T(L.childNodes,C-W):document.getSelection().setPosition(((ne=L.childNodes)==null?void 0:ne[0])||L,C-W);break}W+=le}},x=P=>{switch(P.which){case 9:O(o.tab),P.preventDefault();break;case 13:O(\`
\`),P.preventDefault();break}},O=P=>{const C=window.getSelection(),q=C.getRangeAt(0),ne=document.createTextNode(P);q.insertNode(ne),C.collapseToEnd()},$=P=>{if(!l.value.includes(o.language))return P;const[C,q]=p();return d(P.replace(/&/g,"&amp;")).replace(new RegExp(C,"gsi"),(ne,...W)=>{W=W.slice(0,W.length-2);let L;const le=o.language==="pug";let B=W.find((Z,we)=>Z&&(L=q[we])&&Z);if(["punctuation","quote","htmlentity"].includes(L))B=d(B);else if(L==="comment")if(le){const[Z,we,Ke]=W.slice(q.indexOf("comment"));B=\`\${Z}\${we}\${d(Ke)}\`}else B=d(B);else if(L==="text"&&le){let[Z,we,Ke]=W;return Ke=_(Ke),\`\${Z}<span class="punctuation">|</span>\${we}<span class="text">\${Ke}</span>\`}else if(L==="text2"&&le){const[,,,Z,we,Ke]=W,rt=$(we);return\`\${Z}\${rt}<span class="punctuation">.</span>
<span class="text">\${Ke}</span>\`}else{if(L==="tag"&&["xml","html","html-vue","pug"].includes(o.language))return g(W.slice(q.indexOf("tag")));if(L==="variable"&&B[0]==="."&&o.language==="js")return\`<span class="punctuation">.</span><span class="obj-attr">\${B.substr(1)}</span>\`}let ue="";if(L==="color"&&o.language==="css"){const{dark:Z,alpha:we}=h(B);L+=\` color--\${Z?"dark":"light"}\${we<.4||B==="transparent"?" color--transparent":""}\`,ue=\` style="background-color: \${B}"\`}return L&&\`<span class="\${L}"\${ue}>\${B}</span>\`||""})},F=()=>c.default&&f(c.default())||"",Q=P=>{P.target.insertAdjacentHTML("afterend",\`<textarea id="clipboard-textarea">\${u.value.innerText}</textarea>\`);const C=document.getElementById("clipboard-textarea");C.select(),C.setSelectionRange(0,99999),document.execCommand("copy"),C.remove(),a("copied",u.value.innerText)};return Lt(()=>{const P=F();u.value.innerText=P,u.value.innerHTML=$(u.value.innerText)}),oh(()=>{u.value&&(u.value.innerHTML=$(F()))}),(P,C)=>(H(),oe("div",{class:$t(["ssh-pre",{"ssh-pre--dark":e.dark}]),"data-type":e.language,"data-label":e.label||null},[e.copyButton?(H(),oe("button",{key:0,class:"ssh-pre__copy",onClick:Q},[yn(P.$slots,"copy-button",{},()=>[C[1]||(C[1]=ze("Copy"))])])):Ce("",!0),C[2]||(C[2]=ze()),w("pre",{ref_key:"codeEl",ref:u,class:"ssh-pre__content",contenteditable:e.editable?"true":"false",onKeydown:C[0]||(C[0]=q=>e.editable&&x(q)),onInput:b},"    ",40,M2),C[3]||(C[3]=ze()),w("div",N2,[yn(P.$slots,"default")])],10,$2))}},k2={class:"modal modal-lg fade",id:"rawContentModal","data-bs-backdrop":"static","data-bs-keyboard":"false",tabindex:"-1","aria-labelledby":"rawContentModalLabel","aria-hidden":"true"},I2={class:"modal-dialog modal-dialog-scrollable"},P2={class:"modal-content"},L2={class:"modal-header"},D2={class:"modal-title fs-5 me-3",id:"rawContentModalLabel"},F2={class:"modal-body"},z2={class:"position-relative"},j2={key:0,class:"check-icon ms-1"},H2=at({__name:"RawContentModal",setup(e){const t=Ne(Zo),n=xe(()=>t.selected.value??{message:{},rawContent:""}),{copy:s,copied:r}=ex();return(i,o)=>(H(),oe("div",k2,[w("div",I2,[w("div",P2,[w("div",L2,[w("h1",D2," Raw Content #"+Fe(n.value.message.sequenceNumber+1),1),o[1]||(o[1]=w("button",{type:"button",class:"btn-close","data-bs-dismiss":"modal","aria-label":"Close"},null,-1))]),w("div",F2,[w("div",z2,[Ae(A(Im),null,{default:Qt(()=>[ze(Fe(n.value.rawContent),1)]),_:1}),w("button",{class:"btn btn-sm btn-primary position-absolute top-0 end-0 m-2",onClick:o[0]||(o[0]=()=>{r.value=!0,A(s)(n.value.rawContent)}),title:"Copy to clipboard"},[o[2]||(o[2]=w("i",{class:"fas fa-copy"},null,-1)),A(r)?(H(),oe("span",j2,"Copied!")):Ce("",!0)])])])])])]))}}),Pm=qn(H2,[["__scopeId","data-v-eb641b8b"]]),V2={class:"modal fade",id:"searchModal",tabindex:"-1","aria-hidden":"true"},B2={class:"modal-dialog"},W2={class:"modal-content border-0 shadow-lg"},U2={class:"modal-body"},q2={class:"invalid-feedback"},K2={key:0,class:"mt-1 text-muted mb-2"},Y2={class:"d-flex gap-2 align-items-center"},G2={key:0,class:"text-muted spinner-border spinner-border-sm",role:"status"},Q2={class:"list-group"},X2=at({__name:"SearchModal",setup(e){const t=Ne(pi);Ne(Sr),Ne(bs);let n;n={isLoading:re(!1),resetSearch(){},search(){},searchResult:re(null)};const s=n.searchResult,r=re(null),i=re(null),o=Qp("",{onBeforeChange:h=>{if(h.startsWith("#")){n.resetSearch();const p=parseInt(h.slice(1));p>0&&t.messagesMeta.value.findIndex(g=>g.sequenceNumber+1===p)>=0?(i.value=p,r.value=null):(i.value=null,r.value=\`\${h} not found\`)}else h.length>0?(r.value=null,i.value=null,n.search(h)):(n.resetSearch(),r.value=null,i.value=null)}}),a=go([s,r],()=>s.value?.errorMessage?s.value.errorMessage:r.value?r.value:null),l=go([s,i],()=>{if(s.value)return s.value.messages??[];if(i.value){const h=t.messagesMeta.value.find(p=>p.sequenceNumber+1===i.value);return h?[h]:[]}return[]}),u=re(null);function c(){const h=l.value[0]?.uuid;h&&f(h)}function f(h){h&&(t.scrollToMessage(h),u.value?.hide())}Lt(()=>{u.value=new ls("#searchModal")});const d=xe(()=>s.value?.totalFiltered??l.value?.length);return(h,p)=>(H(),oe("div",V2,[w("div",B2,[w("div",W2,[w("div",U2,[jt(w("input",{type:"search",placeholder:"Type to search...",class:$t(["form-control","form-control-lg",A(a)?"is-invalid":""]),"aria-label":"Enter Rbel Path","onUpdate:modelValue":p[0]||(p[0]=g=>Ze(o)?o.value=g:null),onKeyup:p[1]||(p[1]=ac(()=>c(),["enter"]))},null,34),[[Rs,A(o)]]),w("div",q2,Fe(A(a)),1),A(a)?Ce("",!0):(H(),oe("div",K2,[p[2]||(p[2]=ze(" Search for messages by sequence number (e.g. ",-1)),p[3]||(p[3]=w("code",null,"#123",-1)),ze(")"+Fe(h.__IS_ONLINE_MODE__?" or JEXL Expression":"")+". Press ",1),p[4]||(p[4]=w("kbd",null,"Enter ⏎",-1)),p[5]||(p[5]=ze(" to jump to the first result. ",-1))])),w("div",Y2,[w("div",null,Fe(d.value)+" "+Fe(Number(d.value)==0||Number(d.value)>1||typeof d.value=="string"?"matches":"match"),1),A(n).isLoading.value?(H(),oe("div",G2,[...p[6]||(p[6]=[w("span",{class:"visually-hidden"},"Loading...",-1)])])):Ce("",!0)]),w("div",Q2,[(H(!0),oe(Xe,null,Fn(A(l),g=>(H(),oe("a",{class:"list-group-item list-group-item-action",key:g.uuid},[Ae(Em,{message:g,"on-height-changed":()=>{},"on-click":()=>f(g.uuid)},null,8,["message","on-click"])]))),128))])])])])]))}}),J2={class:"p-2 border-bottom d-flex gap-2 text-nowrap"},Z2={key:0,class:"filter input-group"},eR={class:"input-group-text"},tR=["disabled"],nR={type:"button",class:"btn btn-outline-primary test-btn-search","data-bs-toggle":"modal","data-bs-target":"#searchModal"},sR=at({__name:"StatusHeader",setup(e){const t=Ne(Sr);return(n,s)=>(H(),oe("div",J2,[n.__IS_ONLINE_MODE__?(H(),oe("div",Z2,[w("span",eR,[Ae(A(ft),{icon:A(ZO)},null,8,["icon"])]),jt(w("input",{readonly:"",id:"test-rbel-path-input","data-bs-toggle":"modal","data-bs-target":"#filterBackdrop","aria-expanded":"false","onUpdate:modelValue":s[0]||(s[0]=r=>A(t).rbelPath.value=r),type:"text",class:"form-control no-focus test-input-filter",placeholder:"Rbel Path..."},null,512),[[Rs,A(t).rbelPath.value]]),w("button",{class:"btn btn-outline-secondary test-btn-reset-filter",id:"test-reset-filter-button",type:"button",onClick:s[1]||(s[1]=()=>A(t).rbelPath.value=""),disabled:!A(t).rbelPath.value}," Reset Filter ",8,tR)])):Ce("",!0),w("button",nR,[Ae(A(ft),{icon:A(rC)},null,8,["icon"]),s[2]||(s[2]=ze(" Search ",-1))])]))}}),rR=qn(sR,[["__scopeId","data-v-3ffe8330"]]);function iR(e,t,n){const{testRbelJexlQuery:s}=vs(n),r=re(!1),i=re(null);async function o(u){try{r.value=!0,await u()}finally{r.value=!1}}const a=()=>{r.value=!1,i.value=null},l=()=>{o(async()=>{t.value=t.value.trim();const u=await s({messageUuid:e.value.uuid,query:t.value});u&&(i.value=u)})};return{isLoading:Mt(r),rbelPathTestResult:Mt(i),testRbelPathQuery:l,resetTestResult:a}}function oR(e,t,n){const{testRbelTreeQuery:s}=vs(n),r=re(!1),i=re(null);async function o(u){try{r.value=!0,await u()}finally{r.value=!1}}const a=()=>{r.value=!1,i.value=null},l=()=>{o(async()=>{t.value=t.value.trim();const u=await s({messageUuid:e.value.uuid,query:t.value});u&&(i.value=u)})};return{isLoading:Mt(r),rbelPathTestResult:Mt(i),testRbelPathQuery:l,resetTestResult:a}}const aR={class:"invalid-feedback"},lR={class:"d-flex flex-row align-items-end justify-content-end gap-2 mt-4"},cR={key:0,class:"card mt-3 test-expression-success"},uR={class:"d-flex flex-row align-items-center gap-2 border-start border-success border-4 rounded p-2 py-3"},fR={key:1,class:"card mt-3 test-expression-failure"},dR={class:"d-flex flex-row align-items-center gap-2 border-start border-warning border-4 rounded p-2 py-3"},hR={key:2,class:"d-flex flex-column"},pR={class:"ssh-pre"},gR=["innerHTML"],_d="$.body",mR=at({__name:"RbelTreeContent",setup(e,{expose:t}){const n=Ne(wr),s=Ne(bs),r=re(_d),i=xe(()=>n.selectedMessage.value??{}),o=oR(i,r,{onError:c=>{s.showToast(c)}}),a=o.rbelPathTestResult;t({reset:()=>{o.resetTestResult(),r.value=_d}});const l=re([]);function u(c){let f=c.textContent??"",d=c.previousElementSibling,h=d.textContent;function p(_){return _.match("\\\\W")!=null}for(p(f)&&(f="['"+f+"']");d;){if(d.classList&&d.classList.contains("jexlResponseLink")){const _=d.previousElementSibling;_&&_.classList.contains("text-danger")&&(_.textContent?.length??0)<(h?.length??0)&&(p(d.textContent??"")?f="['"+d.textContent+"']."+f:f=d.textContent+"."+f,h=_.textContent)}d=d.previousElementSibling}const g=f.startsWith(".")?"$":"$.";r.value=g+f}return Je(l.value,async()=>{l.value.length>0&&(await un(),l.value.forEach(c=>{const f=c.getElementsByClassName("jexlResponseLink");for(const d of f)d.addEventListener("click",()=>u(d))}))}),(c,f)=>(H(),oe("div",null,[f[7]||(f[7]=w("label",{for:"rbelTreeExpressionTextArea",class:"form-label"},"Expression",-1)),jt(w("textarea",{class:$t(["form-control",A(a)?.errorMessage?"is-invalid":""]),"aria-label":"Enter Rbel Path","onUpdate:modelValue":f[0]||(f[0]=d=>r.value=d),id:"rbelTreeExpressionTextArea",placeholder:"e.g. $.body",onKeydown:f[1]||(f[1]=ac(Ph((...d)=>A(o).testRbelPathQuery&&A(o).testRbelPathQuery(...d),["prevent"]),["enter"]))},null,34),[[Rs,r.value]]),w("div",aR,Fe(A(a)?.errorMessage),1),w("div",lR,[w("button",{class:"btn btn-primary test-expression-button",type:"button",onClick:f[2]||(f[2]=(...d)=>A(o).testRbelPathQuery&&A(o).testRbelPathQuery(...d))}," Test Expression ")]),A(a)?.elementsWithTree&&A(a)?.elementsWithTree.length>0?(H(),oe("div",cR,[w("div",uR,[Ae(A(ft),{icon:A(_m),class:"text-success fs-5"},null,8,["icon"]),w("div",null,[f[3]||(f[3]=ze(" Matching elements for the expression ",-1)),w("code",null,"'"+Fe(A(a)?.query)+"'",1),f[4]||(f[4]=ze(". ",-1))])])])):Ce("",!0),A(a)&&(!A(a)?.elementsWithTree||A(a)?.elementsWithTree?.length===0)?(H(),oe("div",fR,[w("div",dR,[Ae(A(ft),{icon:A(bm),class:"text-warning fs-5"},null,8,["icon"]),w("div",null,[f[5]||(f[5]=ze(" No matching elements for the expression ",-1)),w("code",null,"'"+Fe(A(a)?.query)+"'",1),f[6]||(f[6]=ze(". ",-1))])])])):Ce("",!0),A(a)?.elementsWithTree?(H(),oe("div",hR,[(H(!0),oe(Xe,null,Fn(A(a).elementsWithTree,d=>(H(),oe("div",{key:Object.keys(d)[0]},[w("div",pR,[w("pre",{class:"ssh-pre__content",ref_for:!0,ref_key:"pathElements",ref:l,innerHTML:Object.values(d)[0]},null,8,gR)])]))),128))])):Ce("",!0)]))}}),vR={class:"invalid-feedback"},bR={class:"d-flex flex-row align-items-end justify-content-end gap-2 mt-4"},yR=["disabled"],_R={key:0,class:"card mt-3 test-expression-success"},ER={class:"d-flex flex-row align-items-center gap-2 border-start border-success border-4 rounded p-2 py-3"},wR={key:1,class:"card mt-3 test-expression-failure"},SR={class:"d-flex flex-row align-items-center gap-2 border-start border-warning border-4 rounded p-2 py-3"},xR={key:2},Ed='"RbelHttpMessageFacet" =~facets',TR=at({__name:"RbelJexlContent",setup(e,{expose:t}){const n=Ne(Sr),s=Ne(wr),r=Ne(bs),i=re(Ed),o=xe(()=>s.selectedMessage.value??{}),a=iR(o,i,{onError:u=>{r.showToast(u)}}),l=a.rbelPathTestResult;return t({reset:()=>{a.resetTestResult(),i.value=Ed}}),(u,c)=>(H(),oe("div",null,[c[8]||(c[8]=w("label",{for:"rbelJexlExpressionTextArea",class:"form-label"},"Expression",-1)),jt(w("textarea",{class:$t(["form-control",A(l)?.errorMessage?"is-invalid":""]),"aria-label":"Enter Rbel Path","onUpdate:modelValue":c[0]||(c[0]=f=>i.value=f),id:"rbelJexlExpressionTextArea",placeholder:'e.g. "RbelHttpMessageFacet" =~facets',onKeydown:c[1]||(c[1]=ac(Ph((...f)=>A(a).testRbelPathQuery&&A(a).testRbelPathQuery(...f),["prevent"]),["enter"]))},null,34),[[Rs,i.value]]),w("div",vR,Fe(A(l)?.errorMessage),1),w("div",bR,[w("button",{class:"btn btn-primary test-expression-button",type:"button",onClick:c[2]||(c[2]=(...f)=>A(a).testRbelPathQuery&&A(a).testRbelPathQuery(...f))}," Test Expression "),w("button",{class:"btn btn-outline-primary apply-as-filter-button",type:"button",disabled:!(A(l)?.matchSuccessful===!0&&A(l)?.query===i.value),onClick:c[3]||(c[3]=()=>A(n).rbelPath.value=i.value)}," Apply as Filter ",8,yR)]),A(l)?.matchSuccessful===!0?(H(),oe("div",_R,[w("div",ER,[Ae(A(ft),{icon:A(_m),class:"text-success fs-5"},null,8,["icon"]),w("div",null,[c[4]||(c[4]=ze(" Expression ",-1)),w("code",null,"'"+Fe(A(l)?.query)+"'",1),c[5]||(c[5]=ze(" matches! Below is the entire message context. ",-1))])])])):Ce("",!0),A(l)?.matchSuccessful===!1?(H(),oe("div",wR,[w("div",SR,[Ae(A(ft),{icon:A(bm),class:"text-warning fs-5"},null,8,["icon"]),w("div",null,[c[6]||(c[6]=ze(" Expression ",-1)),w("code",null,"'"+Fe(A(l)?.query)+"'",1),c[7]||(c[7]=ze(" doesn't match anything in the message. Below is the entire message context. ",-1))])])])):Ce("",!0),A(l)?.messageContext?(H(),oe("div",xR,[(H(!0),oe(Xe,null,Fn(Object.entries(A(l)?.messageContext),([f,d])=>(H(),qe(A(Im),{key:f,language:"json"},{default:Qt(()=>[ze(Fe(JSON.stringify({[f]:d},void 0,2).trim()),1)]),_:2},1024))),128))])):Ce("",!0)]))}}),AR={class:"modal-dialog modal-dialog-scrollable"},OR={class:"modal-content"},CR={class:"modal-header"},RR={class:"modal-title fs-5 me-5",id:"jexlQueryModalLabel"},$R={class:"btn-group",role:"group","aria-label":"Select tab to inspect"},MR={class:"modal-body d-flex flex-row"},NR={class:"pe-3 flex-5"},kR={class:"sticky-top ps-3 border-1 border-start flex-2 f-caption"},IR={key:0},PR={key:1},ji="RbelTreeTab",Ga="RbelJexlTab",LR=at({__name:"RbelQueryModal",setup(e){const t=Ne(wr),n=xe(()=>t.selectedMessage.value??{}),s=re(ji),r=re(null),i=re(null),o=re(null);return Lt(()=>{o.value&&o.value.addEventListener("show.bs.modal",()=>{r.value?.reset(),i.value?.reset()})}),(a,l)=>(H(),oe("div",{ref_key:"modalRef",ref:o,class:"modal modal-xl fade",id:"jexlQueryModal","data-bs-backdrop":"static","data-bs-keyboard":"false",tabindex:"-1","aria-labelledby":"jexlQueryModalLabel","aria-hidden":"true"},[w("div",AR,[w("div",OR,[w("div",CR,[w("h1",RR," Inspect #"+Fe(n.value.sequenceNumber+1),1),w("div",$R,[jt(w("input",{"onUpdate:modelValue":l[0]||(l[0]=u=>s.value=u),value:ji,type:"radio",class:"btn-check",name:"btnradio",id:"btnradioRbelTree",autocomplete:"off",checked:""},null,512),[[Nu,s.value]]),l[2]||(l[2]=w("label",{class:"btn btn-outline-primary",for:"btnradioRbelTree"},"RBel Tree",-1)),jt(w("input",{"onUpdate:modelValue":l[1]||(l[1]=u=>s.value=u),value:Ga,type:"radio",class:"btn-check",name:"btnradio",id:"btnradioJexlExpression",autocomplete:"off"},null,512),[[Nu,s.value]]),l[3]||(l[3]=w("label",{class:"btn btn-outline-primary",for:"btnradioJexlExpression"},"JEXL Expression",-1))]),l[4]||(l[4]=w("button",{type:"button",class:"btn-close","data-bs-dismiss":"modal","aria-label":"Close"},null,-1))]),w("div",MR,[w("div",NR,[s.value===ji?(H(),qe(mR,{key:0,ref_key:"treeContentRef",ref:r},null,512)):Ce("",!0),s.value===Ga?(H(),qe(TR,{key:1,ref_key:"jexlContentRef",ref:i},null,512)):Ce("",!0)]),w("div",kR,[s.value===ji?(H(),oe("div",IR,[...l[5]||(l[5]=[rl('<span class="fw-semibold" data-v-4e00a315>RBeL-Path Quick Help</span><div data-v-4e00a315><p data-v-4e00a315> RBeL-Path is an expression language inspired by XPath and JSON-Path, enabling quick traversal of captured RBeL-Traffic (RbelElement-tree). For detailed documentation, visit <a href="https://gematik.github.io/app-Tiger/Tiger-User-Manual.html#_rbel_path_details" target="_blank" data-v-4e00a315>this page</a>. </p><span class="fw-semibold" data-v-4e00a315>Examples:</span><ul class="list-group" data-v-4e00a315><li class="list-group-item" data-v-4e00a315><code data-v-4e00a315>$.body</code> <br data-v-4e00a315><small data-v-4e00a315>Accesses the body of the message.</small></li><li class="list-group-item" data-v-4e00a315><code data-v-4e00a315>$..Action</code> <br data-v-4e00a315><small data-v-4e00a315>Finds all nodes named <strong data-v-4e00a315>Action</strong> across the entire tree.</small></li><li class="list-group-item" data-v-4e00a315><code data-v-4e00a315>$.body..Action</code> <br data-v-4e00a315><small data-v-4e00a315>Finds all nodes named <strong data-v-4e00a315>Action</strong> within the body.</small></li><li class="list-group-item" data-v-4e00a315><code data-v-4e00a315>$..[?(content =~ &quot;UTF-.*&quot;)]</code> <br data-v-4e00a315><small data-v-4e00a315>Matches nodes with text starting with <strong data-v-4e00a315>UTF-</strong> using a JEXL-Expression.</small></li></ul></div>',2)])])):Ce("",!0),s.value===Ga?(H(),oe("div",PR,[...l[6]||(l[6]=[rl('<span class="fw-semibold" data-v-4e00a315>JEXL Quick Help</span><p data-v-4e00a315> JEXL syntax is a powerful expression language used for evaluating conditions and extracting data. For detailed documentation, visit <a href="https://commons.apache.org/proper/commons-jexl/reference/syntax.html" target="_blank" data-v-4e00a315>this page</a>. In addition, you can use <strong data-v-4e00a315>RbelPath</strong> expressions, which are described <a href="https://gematik.github.io/app-Tiger/Tiger-User-Manual.html#_rbel_path_details" target="_blank" data-v-4e00a315>here</a>. </p><span class="fw-semibold" data-v-4e00a315>Examples:</span><ul class="list-group" data-v-4e00a315><li class="list-group-item" data-v-4e00a315><code data-v-4e00a315>&quot;RbelHttpMessageFacet&quot; =~ facets</code> <br data-v-4e00a315><small data-v-4e00a315>Checks if the message has the <strong data-v-4e00a315>RbelHttpMessageFacet</strong> facet. <code data-v-4e00a315>facets</code> is an array containing all recognized facets.</small></li><li class="list-group-item" data-v-4e00a315><code data-v-4e00a315>isRequest</code> <br data-v-4e00a315><small data-v-4e00a315>Checks if the message is a request.</small></li><li class="list-group-item" data-v-4e00a315><code data-v-4e00a315>$.body.recordId == &quot;X12349035&quot;</code> <br data-v-4e00a315><small data-v-4e00a315>Checks for the <strong data-v-4e00a315>recordId</strong> in a decrypted EPA-VAU message.</small></li><li class="list-group-item" data-v-4e00a315><code data-v-4e00a315>$.header.Content-Type == &quot;application/json&quot;</code> <br data-v-4e00a315><small data-v-4e00a315>Checks if the message is a JSON message.</small></li><li class="list-group-item" data-v-4e00a315><code data-v-4e00a315>charset =~ &quot;UTF-.*&quot;</code> <br data-v-4e00a315><small data-v-4e00a315>Checks the <strong data-v-4e00a315>charset</strong> using a regex pattern.</small></li><li class="list-group-item" data-v-4e00a315><code data-v-4e00a315>$.body.recordId == &quot;Y243631459&quot; &amp;&amp; charset == &quot;UTF-8&quot;</code> <br data-v-4e00a315><small data-v-4e00a315>Combines multiple conditions to check both <strong data-v-4e00a315>recordId</strong> and <strong data-v-4e00a315>charset</strong>.</small></li></ul>',4)])])):Ce("",!0)])])])])],512))}}),Lm=qn(LR,[["__scopeId","data-v-4e00a315"]]);function DR(e){const{getProxyRoutes:t,deleteProxyRoute:n,addProxyRoute:s}=vs(e),r=re(!1),i=re([]),o=async()=>{const u=await t();u&&(i.value=u)},a=async u=>{try{r.value=!0,await n({id:u}),await o()}finally{r.value=!1}},l=async(u,c)=>{try{r.value=!0,await s({route:{id:null,from:u,to:c}}),await o()}finally{r.value=!1}};return Lt(async()=>{try{r.value=!0,await o()}finally{r.value=!1}}),{isLoading:Mt(r),routes:Mt(i),loadRoutes:o,deleteRoute:a,addRoute:l}}const FR={class:"modal modal-lg fade",id:"routeModal","data-bs-backdrop":"static","data-bs-keyboard":"false",tabindex:"-1","aria-labelledby":"routeModalLabel","aria-hidden":"true"},zR={class:"modal-dialog modal-dialog-scrollable"},jR={class:"modal-content"},HR={class:"modal-body"},VR={class:"list-group list-group"},BR={class:"d-flex align-items-center gap-2"},WR=["onClick"],UR={class:"flex mt-4"},qR={class:"input-group"},KR={class:"input-group-text",id:"basic-addon1"},YR={class:"modal-footer"},GR=["disabled"],QR={key:0,class:"spinner-border spinner-border-sm",role:"status","aria-hidden":"true"},XR=at({__name:"RouteModal",setup(e){const t=Ne(bs),{isLoading:n,routes:s,deleteRoute:r,addRoute:i}=DR({onError:d=>{t.showToast(d)}}),o=re(""),a=re(""),l=re(null),u=re(null);function c(){if(o.value.length===0||a.value.length===0)return!1;try{new URL(o.value),new URL(a.value)}catch{return!1}return!0}function f(){c()&&(i(o.value,a.value),o.value="",a.value="")}return(d,h)=>(H(),oe("div",FR,[w("div",zR,[w("div",jR,[h[7]||(h[7]=w("div",{class:"modal-header"},[w("h1",{class:"modal-title fs-5 me-3",id:"rawContentModalLabel"},"Route Management"),w("button",{type:"button",class:"btn-close","data-bs-dismiss":"modal","aria-label":"Close"})],-1)),w("div",HR,[h[5]||(h[5]=w("label",{class:"form-label"},"Routes:",-1)),w("ol",VR,[(H(!0),oe(Xe,null,Fn(A(s),p=>(H(),oe("li",{key:p.id??"",class:"list-group-item d-flex justify-content-between align-items-start"},[w("div",BR,[w("button",{class:"btn btn-danger me-2",type:"button",onClick:g=>p.id?A(r)(p.id):null},[Ae(A(ft),{icon:A(ym)},null,8,["icon"])],8,WR),w("span",null,Fe(p.from),1),Ae(A(ft),{icon:A(md)},null,8,["icon"]),w("span",null,Fe(p.to),1)])]))),128))]),w("div",UR,[h[4]||(h[4]=w("label",{class:"form-label"},"New Route:",-1)),w("div",qR,[h[3]||(h[3]=w("span",{class:"input-group-text",id:"basic-addon1"},"from",-1)),jt(w("input",{ref_key:"fromInputRef",ref:l,type:"text",class:"form-control",placeholder:"scheme://host:port","onUpdate:modelValue":h[0]||(h[0]=p=>o.value=p)},null,512),[[Rs,o.value]]),w("span",KR,[Ae(A(ft),{icon:A(md),class:"me-3"},null,8,["icon"]),h[2]||(h[2]=ze("to",-1))]),jt(w("input",{ref_key:"toInputRef",ref:u,type:"text",class:"form-control",placeholder:"scheme://host:port","onUpdate:modelValue":h[1]||(h[1]=p=>a.value=p)},null,512),[[Rs,a.value]])])])]),w("div",YR,[w("button",{type:"button",class:"btn btn-primary",disabled:o.value.length===0&&a.value.length===0,onClick:f},[A(n)?(H(),oe("span",QR)):Ce("",!0),h[6]||(h[6]=ze(" Add new Route ",-1))],8,GR)])])])]))}});function JR(e,t){return{isLoading:re(!1),download:async(r,i,o)=>{}}}const ZR={class:"modal modal-sm fade",id:"exportModal","data-bs-backdrop":"static","data-bs-keyboard":"false",tabindex:"-1","aria-labelledby":"exportModalLabel","aria-hidden":"true"},e$={class:"modal-dialog modal-dialog-scrollable"},t$={class:"modal-content"},n$={class:"modal-body"},s$={class:"form-check"},r$={class:"modal-footer"},i$={class:"btn-group",role:"group"},o$=["disabled"],a$={key:0,class:"spinner-border spinner-border-sm",role:"status","aria-hidden":"true"},l$=["disabled"],c$={key:0,class:"spinner-border spinner-border-sm",role:"status","aria-hidden":"true"},u$=at({__name:"ExportModal",setup(e){const t=Ne(Sr),{isLoading:n,download:s}=JR(t.rbelPath),r=re(null),i=re(!1);function o(l){const u=String(l.getFullYear()).slice(-2),c=String(l.getMonth()+1).padStart(2,"0"),f=String(l.getDate()).padStart(2,"0"),d=String(l.getHours()).padStart(2,"0"),h=String(l.getMinutes()).padStart(2,"0"),p=String(l.getSeconds()).padStart(2,"0");return\`\${u}\${c}\${f}-\${d}\${h}\${p}\`}async function a(l){const c=\`tiger-report-\${o(new Date)}\`;await s(c,i.value,l),r.value?.hide()}return Lt(()=>{r.value=new ls("#exportModal")}),(l,u)=>(H(),oe("div",ZR,[w("div",e$,[w("div",t$,[u[7]||(u[7]=w("div",{class:"modal-header"},[w("h1",{class:"modal-title fs-5 me-3",id:"rawContentModalLabel"},"Export Proxy Log"),w("button",{type:"button",class:"btn-close",id:"saveModalButtonClose","data-bs-dismiss":"modal","aria-label":"Close"})],-1)),w("div",n$,[w("div",s$,[jt(w("input",{class:"form-check-input",type:"checkbox","onUpdate:modelValue":u[0]||(u[0]=c=>i.value=c),id:"switchExportWithFilter"},null,512),[[al,i.value]]),u[3]||(u[3]=w("label",{class:"form-check-label",for:"switchExportWithFilter"},"Apply filters for export",-1))])]),w("div",r$,[u[6]||(u[6]=w("span",null,"Download",-1)),w("div",i$,[w("button",{type:"button",class:"btn btn-outline-primary",title:"Download as Tiger Rbel Log",id:"saveTrafficBtn",onClick:u[1]||(u[1]=c=>a("tgr")),disabled:A(n)},[A(n)?(H(),oe("span",a$)):Ce("",!0),u[4]||(u[4]=ze(" *.tgr ",-1))],8,o$),w("button",{type:"button",class:"btn btn-outline-primary",id:"saveHtmlBtn",title:"Download as HTML",onClick:u[2]||(u[2]=c=>a("html")),disabled:A(n)},[A(n)?(H(),oe("span",c$)):Ce("",!0),u[5]||(u[5]=ze(" *.html ",-1))],8,l$)])])])])]))}}),f$={class:"position-fixed top-0 end-0 p-3",style:{"z-index":"2000"}},d$={class:"d-flex"},h$={class:"toast-body"},p$={class:"d-flex"},g$={class:"d-flex flex-column flex-grow-2 vh-100"},m$={class:"d-flex flex-row"},v$=at({__name:"App",setup(e){const t=wm();It(bi,t);const n=Sm();It(wr,n);const s=xm();It(Zo,s);const r=d2();It(Sr,r);const i=re(null),o=Am(i);It(bs,o);const a=Nx(t.reverseMessageQueue,r.rbelPath,{onError:d=>{o.isShown()||o.showToast(d)}});It(pi,a);const l=vs({onError:d=>{o.showToast(d)}});Lt(()=>{function d(h,p){a.scrollToMessage(h,p)}window.scrollToMessage=d}),ah(()=>{delete window.scrollToMessage});const c=new URLSearchParams(window.location.search).has("embedded"),f=re(window.location.hash);return Sh(()=>{window.addEventListener("hashchange",()=>{f.value=window.location.hash,a.scrollToMessage(f.value.slice(1))})}),(d,h)=>(H(),oe("div",null,[w("div",f$,[w("div",{ref_key:"toastElement",ref:i,class:"toast align-items-center text-white bg-danger border-0",role:"alert","aria-live":"assertive","aria-atomic":"true"},[w("div",d$,[w("div",h$,Fe(A(o).message),1),h[0]||(h[0]=w("button",{type:"button",class:"btn-close btn-close-white me-2 m-auto","data-bs-dismiss":"toast","aria-label":"Close"},null,-1))])],512)]),d.__IS_ONLINE_MODE__?(H(),qe(R2,{key:0})):Ce("",!0),d.__IS_ONLINE_MODE__?(H(),qe(Lm,{key:1})):Ce("",!0),Ae(Pm),Ae(X2),d.__IS_ONLINE_MODE__?(H(),qe(XR,{key:2})):Ce("",!0),d.__IS_ONLINE_MODE__?(H(),qe(u$,{key:3})):Ce("",!0),w("div",p$,[A(c)?Ce("",!0):(H(),qe(AC,{key:0,class:"flex-grow-1","on-click-reverse":p=>A(t).reverseMessageQueue.value=p,"on-click-quit-proxy":A(l).quitProxy,"on-click-reset-messages":A(l).resetMessageQueue},null,8,["on-click-reverse","on-click-quit-proxy","on-click-reset-messages"])),w("div",g$,[w("div",m$,[A(c)?(H(),qe(jc,{key:0,"no-logo":!0,class:$t([A(c)?"pe-3":"pe-5"]),"message-queue":A(a),"on-click-reset-messages":A(l).resetMessageQueue,"on-click-quit-proxy":A(l).quitProxy},null,8,["class","message-queue","on-click-reset-messages","on-click-quit-proxy"])):Ce("",!0),Ae(rR,{class:"flex-grow-1"})]),Ae(u2,{class:"flex-grow-1 flex-shrink-1","is-embedded":A(c)},null,8,["is-embedded"])])])]))}}),b$=qn(v$,[["__scopeId","data-v-96bd5fad"]]),y$={class:"single-message-page"},_$={class:"position-fixed top-0 end-0 p-3",style:{"z-index":"2000"}},E$={class:"d-flex"},w$={class:"toast-body"},S$={class:"container-fluid p-4"},x$={class:"row"},T$={class:"col-12"},A$={class:"d-flex align-items-center mb-3"},O$={key:0,class:"d-flex justify-content-center align-items-center",style:{"min-height":"200px"}},C$={key:1,class:"message-container"},R$={key:2,class:"alert alert-warning"},$$=at({__name:"SingleMessagePage",setup(e){const t=DS(),n=LS(),s=wm();It(bi,s);const r=xm();It(Zo,r);const i=Sm();It(wr,i);const o=re(null),a=Am(o);It(bs,a);const l=vs({onError:b=>{a.showToast(b)}}),u=re(null),c=re(!1),f=!1;function d(){return{reversedMessageQueue:Mt(re(!1)),messagesMeta:xe(()=>[]),total:xe(()=>u.value?1:0),scrollToMessage:()=>{},reset:()=>{},internal:{update:()=>{},messages:re([]),ref:re(null)}}}const h=d();async function p(b){c.value=!0;try{const y=await l.getFullyRenderedMessage({uuid:b});y?u.value={type:"loaded",htmlContent:y.content,index:0,uuid:y.uuid,sequenceNumber:y.sequenceNumber}:a.showToast("Failed to load message content")}catch(y){a.showToast(\`Error loading message: \${y}\`)}finally{c.value=!1}}function g(b){try{n.push(\`/message/\${b}\`)}catch(y){a.showToast(\`Navigation error: \${y}\`)}}function _(){window.scrollToMessage=b=>{g(b)}}return Lt(()=>{_();const b=t.params.uuid;b?p(b):a.showToast("No message UUID provided")}),Je(()=>t.params.uuid,(b,y)=>{b&&b!==y&&p(b)}),(b,y)=>(H(),oe("div",y$,[Ae(jc,{"message-queue":A(h),"on-click-reset-messages":A(l).resetMessageQueue,"on-click-quit-proxy":A(l).quitProxy,"no-logo":!1},null,8,["message-queue","on-click-reset-messages","on-click-quit-proxy"]),w("div",_$,[w("div",{ref_key:"toastElement",ref:o,class:"toast align-items-center text-white bg-danger border-0",role:"alert","aria-live":"assertive","aria-atomic":"true"},[w("div",E$,[w("div",w$,Fe(A(a).message),1),y[1]||(y[1]=w("button",{type:"button",class:"btn-close btn-close-white me-2 m-auto","data-bs-dismiss":"toast","aria-label":"Close"},null,-1))])],512)]),Ae(Pm),A(f)?(H(),qe(Lm,{key:0})):Ce("",!0),w("div",S$,[w("div",x$,[w("div",T$,[w("div",A$,[w("button",{class:"btn btn-outline-primary me-3",onClick:y[0]||(y[0]=T=>b.$router.go(-1)),title:"Go back"},[...y[2]||(y[2]=[w("i",{class:"fas fa-arrow-left"},null,-1),ze(" Back ",-1)])]),y[3]||(y[3]=w("h2",{class:"mb-0"},"Single Message View",-1))]),c.value?(H(),oe("div",O$,[...y[4]||(y[4]=[w("div",{class:"text-center"},[w("div",{class:"spinner-border text-primary mb-3",role:"status"},[w("span",{class:"visually-hidden"},"Loading...")]),w("p",{class:"text-muted"},"Loading message...")],-1)])])):u.value?(H(),oe("div",C$,[Ae(Tm,{message:u.value,"on-toggle-details-or-header":()=>{}},null,8,["message"])])):(H(),oe("div",R$,[...y[5]||(y[5]=[w("h4",null,"Message not found",-1),w("p",null," The requested message could not be loaded. Please check the message ID and try again. ",-1)])]))])])])]))}}),M$=qn($$,[["__scopeId","data-v-1e3919ae"]]),N$=[{path:"/",component:b$},{path:"/message/:uuid",component:M$}],k$=IS({history:cS(),routes:N$});function I$(e){const t={className:"attr",begin:/"(\\\\.|[^\\\\"\\r\\n])*"(?=\\s*:)/,relevance:1.01},n={match:/[{}[\\],:]/,className:"punctuation",relevance:0},s=["true","false","null"],r={scope:"literal",beginKeywords:s.join(" ")};return{name:"JSON",aliases:["jsonc"],keywords:{literal:s},contains:[t,n,e.QUOTE_STRING_MODE,r,e.C_NUMBER_MODE,e.C_LINE_COMMENT_MODE,e.C_BLOCK_COMMENT_MODE],illegal:"\\\\S"}}function Dm(e){const t=e.regex,n=t.concat(/[\\p{L}_]/u,t.optional(/[\\p{L}0-9_.-]*:/u),/[\\p{L}0-9_.-]*/u),s=/[\\p{L}0-9._:-]+/u,r={className:"symbol",begin:/&[a-z]+;|&#[0-9]+;|&#x[a-f0-9]+;/},i={begin:/\\s/,contains:[{className:"keyword",begin:/#?[a-z_][a-z1-9_-]+/,illegal:/\\n/}]},o=e.inherit(i,{begin:/\\(/,end:/\\)/}),a=e.inherit(e.APOS_STRING_MODE,{className:"string"}),l=e.inherit(e.QUOTE_STRING_MODE,{className:"string"}),u={endsWithParent:!0,illegal:/</,relevance:0,contains:[{className:"attr",begin:s,relevance:0},{begin:/=\\s*/,relevance:0,contains:[{className:"string",endsParent:!0,variants:[{begin:/"/,end:/"/,contains:[r]},{begin:/'/,end:/'/,contains:[r]},{begin:/[^\\s"'=<>\`]+/}]}]}]};return{name:"HTML, XML",aliases:["html","xhtml","rss","atom","xjb","xsd","xsl","plist","wsf","svg"],case_insensitive:!0,unicodeRegex:!0,contains:[{className:"meta",begin:/<![a-z]/,end:/>/,relevance:10,contains:[i,l,a,o,{begin:/\\[/,end:/\\]/,contains:[{className:"meta",begin:/<![a-z]/,end:/>/,contains:[i,o,l,a]}]}]},e.COMMENT(/\\x3C!--/,/-->/,{relevance:10}),{begin:/<!\\[CDATA\\[/,end:/\\]\\]>/,relevance:10},r,{className:"meta",end:/\\?>/,variants:[{begin:/<\\?xml/,relevance:10,contains:[l]},{begin:/<\\?[a-z][a-z0-9]+/}]},{className:"tag",begin:/<style(?=\\s|>)/,end:/>/,keywords:{name:"style"},contains:[u],starts:{end:/<\\/style>/,returnEnd:!0,subLanguage:["css","xml"]}},{className:"tag",begin:/<script(?=\\s|>)/,end:/>/,keywords:{name:"script"},contains:[u],starts:{end:/<\\/script>/,returnEnd:!0,subLanguage:["javascript","handlebars","xml"]}},{className:"tag",begin:/<>|<\\/>/},{className:"tag",begin:t.concat(/</,t.lookahead(t.concat(n,t.either(/\\/>/,/>/,/\\s/)))),end:/\\/?>/,contains:[{className:"name",begin:n,relevance:0,starts:u}]},{className:"tag",begin:t.concat(/<\\//,t.lookahead(t.concat(n,/>/))),contains:[{className:"name",begin:n,relevance:0},{begin:/>/,relevance:0,endsParent:!0}]}]}}function P$(e){return{name:"Plain text",aliases:["text","txt"],disableAutodetect:!0}}iv(()=>Promise.resolve().then(()=>L$),void 0,import.meta.url);yi.registerLanguage("json",I$);yi.registerLanguage("xml",Dm);yi.registerLanguage("html",Dm);yi.registerLanguage("plaintext",P$);const ta=$y(ky);ta.config.globalProperties.__IS_DETACHED_MODE__=!0;ta.config.globalProperties.__IS_ONLINE_MODE__=!1;ta.use(k$);ta.mount("#app");const L$=Object.freeze(Object.defineProperty({__proto__:null},Symbol.toStringTag,{value:"Module"}));
//# sourceMappingURL=index-CamWUFsX.js.map<\/script>
    <style rel="stylesheet" crossorigin>@import"https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free@6.6.0/css/solid.min.css";@import"https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free@6.6.0/css/fontawesome.min.css";/*!
 * Bootstrap  v5.3.8 (https://getbootstrap.com/)
 * Copyright 2011-2025 The Bootstrap Authors
 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)
 */:root,[data-bs-theme=light]{--bs-blue: #0d6efd;--bs-indigo: #6610f2;--bs-purple: #6f42c1;--bs-pink: #d63384;--bs-red: #dc3545;--bs-orange: #fd7e14;--bs-yellow: #ffc107;--bs-green: #198754;--bs-teal: #20c997;--bs-cyan: #0dcaf0;--bs-black: #000;--bs-white: #fff;--bs-gray: #6c757d;--bs-gray-dark: #343a40;--bs-gray-100: #f8f9fa;--bs-gray-200: #e9ecef;--bs-gray-300: #dee2e6;--bs-gray-400: #ced4da;--bs-gray-500: #adb5bd;--bs-gray-600: #6c757d;--bs-gray-700: #495057;--bs-gray-800: #343a40;--bs-gray-900: #212529;--bs-primary: #0d6efd;--bs-secondary: #6c757d;--bs-success: #198754;--bs-info: #0dcaf0;--bs-warning: #ffc107;--bs-danger: #dc3545;--bs-light: #f8f9fa;--bs-dark: #212529;--bs-primary-rgb: 13, 110, 253;--bs-secondary-rgb: 108, 117, 125;--bs-success-rgb: 25, 135, 84;--bs-info-rgb: 13, 202, 240;--bs-warning-rgb: 255, 193, 7;--bs-danger-rgb: 220, 53, 69;--bs-light-rgb: 248, 249, 250;--bs-dark-rgb: 33, 37, 41;--bs-primary-text-emphasis: rgb(5.2, 44, 101.2);--bs-secondary-text-emphasis: rgb(43.2, 46.8, 50);--bs-success-text-emphasis: rgb(10, 54, 33.6);--bs-info-text-emphasis: rgb(5.2, 80.8, 96);--bs-warning-text-emphasis: rgb(102, 77.2, 2.8);--bs-danger-text-emphasis: rgb(88, 21.2, 27.6);--bs-light-text-emphasis: #495057;--bs-dark-text-emphasis: #495057;--bs-primary-bg-subtle: rgb(206.6, 226, 254.6);--bs-secondary-bg-subtle: rgb(225.6, 227.4, 229);--bs-success-bg-subtle: rgb(209, 231, 220.8);--bs-info-bg-subtle: rgb(206.6, 244.4, 252);--bs-warning-bg-subtle: rgb(255, 242.6, 205.4);--bs-danger-bg-subtle: rgb(248, 214.6, 217.8);--bs-light-bg-subtle: rgb(251.5, 252, 252.5);--bs-dark-bg-subtle: #ced4da;--bs-primary-border-subtle: rgb(158.2, 197, 254.2);--bs-secondary-border-subtle: rgb(196.2, 199.8, 203);--bs-success-border-subtle: rgb(163, 207, 186.6);--bs-info-border-subtle: rgb(158.2, 233.8, 249);--bs-warning-border-subtle: rgb(255, 230.2, 155.8);--bs-danger-border-subtle: rgb(241, 174.2, 180.6);--bs-light-border-subtle: #e9ecef;--bs-dark-border-subtle: #adb5bd;--bs-white-rgb: 255, 255, 255;--bs-black-rgb: 0, 0, 0;--bs-font-sans-serif: system-ui, -apple-system, "Segoe UI", Roboto, "Helvetica Neue", "Noto Sans", "Liberation Sans", Arial, sans-serif, "Apple Color Emoji", "Segoe UI Emoji", "Segoe UI Symbol", "Noto Color Emoji";--bs-font-monospace: SFMono-Regular, Menlo, Monaco, Consolas, "Liberation Mono", "Courier New", monospace;--bs-gradient: linear-gradient(180deg, rgba(255, 255, 255, .15), rgba(255, 255, 255, 0));--bs-body-font-family: var(--bs-font-sans-serif);--bs-body-font-size: 1rem;--bs-body-font-weight: 400;--bs-body-line-height: 1.5;--bs-body-color: #212529;--bs-body-color-rgb: 33, 37, 41;--bs-body-bg: #fff;--bs-body-bg-rgb: 255, 255, 255;--bs-emphasis-color: #000;--bs-emphasis-color-rgb: 0, 0, 0;--bs-secondary-color: rgba(33, 37, 41, .75);--bs-secondary-color-rgb: 33, 37, 41;--bs-secondary-bg: #e9ecef;--bs-secondary-bg-rgb: 233, 236, 239;--bs-tertiary-color: rgba(33, 37, 41, .5);--bs-tertiary-color-rgb: 33, 37, 41;--bs-tertiary-bg: #f8f9fa;--bs-tertiary-bg-rgb: 248, 249, 250;--bs-heading-color: inherit;--bs-link-color: #0d6efd;--bs-link-color-rgb: 13, 110, 253;--bs-link-decoration: underline;--bs-link-hover-color: rgb(10.4, 88, 202.4);--bs-link-hover-color-rgb: 10, 88, 202;--bs-code-color: #d63384;--bs-highlight-color: #212529;--bs-highlight-bg: rgb(255, 242.6, 205.4);--bs-border-width: 1px;--bs-border-style: solid;--bs-border-color: #dee2e6;--bs-border-color-translucent: rgba(0, 0, 0, .175);--bs-border-radius: .375rem;--bs-border-radius-sm: .25rem;--bs-border-radius-lg: .5rem;--bs-border-radius-xl: 1rem;--bs-border-radius-xxl: 2rem;--bs-border-radius-2xl: var(--bs-border-radius-xxl);--bs-border-radius-pill: 50rem;--bs-box-shadow: 0 .5rem 1rem rgba(0, 0, 0, .15);--bs-box-shadow-sm: 0 .125rem .25rem rgba(0, 0, 0, .075);--bs-box-shadow-lg: 0 1rem 3rem rgba(0, 0, 0, .175);--bs-box-shadow-inset: inset 0 1px 2px rgba(0, 0, 0, .075);--bs-focus-ring-width: .25rem;--bs-focus-ring-opacity: .25;--bs-focus-ring-color: rgba(13, 110, 253, .25);--bs-form-valid-color: #198754;--bs-form-valid-border-color: #198754;--bs-form-invalid-color: #dc3545;--bs-form-invalid-border-color: #dc3545}[data-bs-theme=dark]{color-scheme:dark;--bs-body-color: #dee2e6;--bs-body-color-rgb: 222, 226, 230;--bs-body-bg: #212529;--bs-body-bg-rgb: 33, 37, 41;--bs-emphasis-color: #fff;--bs-emphasis-color-rgb: 255, 255, 255;--bs-secondary-color: rgba(222, 226, 230, .75);--bs-secondary-color-rgb: 222, 226, 230;--bs-secondary-bg: #343a40;--bs-secondary-bg-rgb: 52, 58, 64;--bs-tertiary-color: rgba(222, 226, 230, .5);--bs-tertiary-color-rgb: 222, 226, 230;--bs-tertiary-bg: rgb(42.5, 47.5, 52.5);--bs-tertiary-bg-rgb: 43, 48, 53;--bs-primary-text-emphasis: rgb(109.8, 168, 253.8);--bs-secondary-text-emphasis: rgb(166.8, 172.2, 177);--bs-success-text-emphasis: rgb(117, 183, 152.4);--bs-info-text-emphasis: rgb(109.8, 223.2, 246);--bs-warning-text-emphasis: rgb(255, 217.8, 106.2);--bs-danger-text-emphasis: rgb(234, 133.8, 143.4);--bs-light-text-emphasis: #f8f9fa;--bs-dark-text-emphasis: #dee2e6;--bs-primary-bg-subtle: rgb(2.6, 22, 50.6);--bs-secondary-bg-subtle: rgb(21.6, 23.4, 25);--bs-success-bg-subtle: rgb(5, 27, 16.8);--bs-info-bg-subtle: rgb(2.6, 40.4, 48);--bs-warning-bg-subtle: rgb(51, 38.6, 1.4);--bs-danger-bg-subtle: rgb(44, 10.6, 13.8);--bs-light-bg-subtle: #343a40;--bs-dark-bg-subtle: #1a1d20;--bs-primary-border-subtle: rgb(7.8, 66, 151.8);--bs-secondary-border-subtle: rgb(64.8, 70.2, 75);--bs-success-border-subtle: rgb(15, 81, 50.4);--bs-info-border-subtle: rgb(7.8, 121.2, 144);--bs-warning-border-subtle: rgb(153, 115.8, 4.2);--bs-danger-border-subtle: rgb(132, 31.8, 41.4);--bs-light-border-subtle: #495057;--bs-dark-border-subtle: #343a40;--bs-heading-color: inherit;--bs-link-color: rgb(109.8, 168, 253.8);--bs-link-hover-color: rgb(138.84, 185.4, 254.04);--bs-link-color-rgb: 110, 168, 254;--bs-link-hover-color-rgb: 139, 185, 254;--bs-code-color: rgb(230.4, 132.6, 181.2);--bs-highlight-color: #dee2e6;--bs-highlight-bg: rgb(102, 77.2, 2.8);--bs-border-color: #495057;--bs-border-color-translucent: rgba(255, 255, 255, .15);--bs-form-valid-color: rgb(117, 183, 152.4);--bs-form-valid-border-color: rgb(117, 183, 152.4);--bs-form-invalid-color: rgb(234, 133.8, 143.4);--bs-form-invalid-border-color: rgb(234, 133.8, 143.4)}*,*:before,*:after{box-sizing:border-box}@media (prefers-reduced-motion: no-preference){:root{scroll-behavior:smooth}}body{margin:0;font-family:var(--bs-body-font-family);font-size:var(--bs-body-font-size);font-weight:var(--bs-body-font-weight);line-height:var(--bs-body-line-height);color:var(--bs-body-color);text-align:var(--bs-body-text-align);background-color:var(--bs-body-bg);-webkit-text-size-adjust:100%;-webkit-tap-highlight-color:rgba(0,0,0,0)}hr{margin:1rem 0;color:inherit;border:0;border-top:var(--bs-border-width) solid;opacity:.25}h6,.h6,h5,.h5,h4,.h4,h3,.h3,h2,.h2,h1,.h1{margin-top:0;margin-bottom:.5rem;font-weight:500;line-height:1.2;color:var(--bs-heading-color)}h1,.h1{font-size:calc(1.375rem + 1.5vw)}@media (min-width: 1200px){h1,.h1{font-size:2.5rem}}h2,.h2{font-size:calc(1.325rem + .9vw)}@media (min-width: 1200px){h2,.h2{font-size:2rem}}h3,.h3{font-size:calc(1.3rem + .6vw)}@media (min-width: 1200px){h3,.h3{font-size:1.75rem}}h4,.h4{font-size:calc(1.275rem + .3vw)}@media (min-width: 1200px){h4,.h4{font-size:1.5rem}}h5,.h5{font-size:1.25rem}h6,.h6{font-size:1rem}p{margin-top:0;margin-bottom:1rem}abbr[title]{text-decoration:underline dotted;cursor:help;text-decoration-skip-ink:none}address{margin-bottom:1rem;font-style:normal;line-height:inherit}ol,ul{padding-left:2rem}ol,ul,dl{margin-top:0;margin-bottom:1rem}ol ol,ul ul,ol ul,ul ol{margin-bottom:0}dt{font-weight:700}dd{margin-bottom:.5rem;margin-left:0}blockquote{margin:0 0 1rem}b,strong{font-weight:bolder}small,.small{font-size:.875em}mark,.mark{padding:.1875em;color:var(--bs-highlight-color);background-color:var(--bs-highlight-bg)}sub,sup{position:relative;font-size:.75em;line-height:0;vertical-align:baseline}sub{bottom:-.25em}sup{top:-.5em}a{color:rgba(var(--bs-link-color-rgb),var(--bs-link-opacity, 1));text-decoration:underline}a:hover{--bs-link-color-rgb: var(--bs-link-hover-color-rgb)}a:not([href]):not([class]),a:not([href]):not([class]):hover{color:inherit;text-decoration:none}pre,code,kbd,samp{font-family:var(--bs-font-monospace);font-size:1em}pre{display:block;margin-top:0;margin-bottom:1rem;overflow:auto;font-size:.875em}pre code{font-size:inherit;color:inherit;word-break:normal}code{font-size:.875em;color:var(--bs-code-color);word-wrap:break-word}a>code{color:inherit}kbd{padding:.1875rem .375rem;font-size:.875em;color:var(--bs-body-bg);background-color:var(--bs-body-color);border-radius:.25rem}kbd kbd{padding:0;font-size:1em}figure{margin:0 0 1rem}img,svg{vertical-align:middle}table{caption-side:bottom;border-collapse:collapse}caption{padding-top:.5rem;padding-bottom:.5rem;color:var(--bs-secondary-color);text-align:left}th{text-align:inherit;text-align:-webkit-match-parent}thead,tbody,tfoot,tr,td,th{border-color:inherit;border-style:solid;border-width:0}label{display:inline-block}button{border-radius:0}button:focus:not(:focus-visible){outline:0}input,button,select,optgroup,textarea{margin:0;font-family:inherit;font-size:inherit;line-height:inherit}button,select{text-transform:none}[role=button]{cursor:pointer}select{word-wrap:normal}select:disabled{opacity:1}[list]:not([type=date]):not([type=datetime-local]):not([type=month]):not([type=week]):not([type=time])::-webkit-calendar-picker-indicator{display:none!important}button,[type=button],[type=reset],[type=submit]{-webkit-appearance:button}button:not(:disabled),[type=button]:not(:disabled),[type=reset]:not(:disabled),[type=submit]:not(:disabled){cursor:pointer}::-moz-focus-inner{padding:0;border-style:none}textarea{resize:vertical}fieldset{min-width:0;padding:0;margin:0;border:0}legend{float:left;width:100%;padding:0;margin-bottom:.5rem;line-height:inherit;font-size:calc(1.275rem + .3vw)}@media (min-width: 1200px){legend{font-size:1.5rem}}legend+*{clear:left}::-webkit-datetime-edit-fields-wrapper,::-webkit-datetime-edit-text,::-webkit-datetime-edit-minute,::-webkit-datetime-edit-hour-field,::-webkit-datetime-edit-day-field,::-webkit-datetime-edit-month-field,::-webkit-datetime-edit-year-field{padding:0}::-webkit-inner-spin-button{height:auto}[type=search]{-webkit-appearance:textfield;outline-offset:-2px}[type=search]::-webkit-search-cancel-button{cursor:pointer;filter:grayscale(1)}::-webkit-search-decoration{-webkit-appearance:none}::-webkit-color-swatch-wrapper{padding:0}::file-selector-button{font:inherit;-webkit-appearance:button}output{display:inline-block}iframe{border:0}summary{display:list-item;cursor:pointer}progress{vertical-align:baseline}[hidden]{display:none!important}.lead{font-size:1.25rem;font-weight:300}.display-1{font-weight:300;line-height:1.2;font-size:calc(1.625rem + 4.5vw)}@media (min-width: 1200px){.display-1{font-size:5rem}}.display-2{font-weight:300;line-height:1.2;font-size:calc(1.575rem + 3.9vw)}@media (min-width: 1200px){.display-2{font-size:4.5rem}}.display-3{font-weight:300;line-height:1.2;font-size:calc(1.525rem + 3.3vw)}@media (min-width: 1200px){.display-3{font-size:4rem}}.display-4{font-weight:300;line-height:1.2;font-size:calc(1.475rem + 2.7vw)}@media (min-width: 1200px){.display-4{font-size:3.5rem}}.display-5{font-weight:300;line-height:1.2;font-size:calc(1.425rem + 2.1vw)}@media (min-width: 1200px){.display-5{font-size:3rem}}.display-6{font-weight:300;line-height:1.2;font-size:calc(1.375rem + 1.5vw)}@media (min-width: 1200px){.display-6{font-size:2.5rem}}.list-unstyled,.list-inline{padding-left:0;list-style:none}.list-inline-item{display:inline-block}.list-inline-item:not(:last-child){margin-right:.5rem}.initialism{font-size:.875em;text-transform:uppercase}.blockquote{margin-bottom:1rem;font-size:1.25rem}.blockquote>:last-child{margin-bottom:0}.blockquote-footer{margin-top:-1rem;margin-bottom:1rem;font-size:.875em;color:#6c757d}.blockquote-footer:before{content:"— "}.img-fluid{max-width:100%;height:auto}.img-thumbnail{padding:.25rem;background-color:var(--bs-body-bg);border:var(--bs-border-width) solid var(--bs-border-color);border-radius:var(--bs-border-radius);max-width:100%;height:auto}.figure{display:inline-block}.figure-img{margin-bottom:.5rem;line-height:1}.figure-caption{font-size:.875em;color:var(--bs-secondary-color)}.container,.container-fluid,.container-xxl,.container-xl,.container-lg,.container-md,.container-sm{--bs-gutter-x: 1.5rem;--bs-gutter-y: 0;width:100%;padding-right:calc(var(--bs-gutter-x) * .5);padding-left:calc(var(--bs-gutter-x) * .5);margin-right:auto;margin-left:auto}@media (min-width: 576px){.container-sm,.container{max-width:540px}}@media (min-width: 768px){.container-md,.container-sm,.container{max-width:720px}}@media (min-width: 992px){.container-lg,.container-md,.container-sm,.container{max-width:960px}}@media (min-width: 1200px){.container-xl,.container-lg,.container-md,.container-sm,.container{max-width:1140px}}@media (min-width: 1400px){.container-xxl,.container-xl,.container-lg,.container-md,.container-sm,.container{max-width:1320px}}:root{--bs-breakpoint-xs: 0;--bs-breakpoint-sm: 576px;--bs-breakpoint-md: 768px;--bs-breakpoint-lg: 992px;--bs-breakpoint-xl: 1200px;--bs-breakpoint-xxl: 1400px}.row{--bs-gutter-x: 1.5rem;--bs-gutter-y: 0;display:flex;flex-wrap:wrap;margin-top:calc(-1 * var(--bs-gutter-y));margin-right:calc(-.5 * var(--bs-gutter-x));margin-left:calc(-.5 * var(--bs-gutter-x))}.row>*{flex-shrink:0;width:100%;max-width:100%;padding-right:calc(var(--bs-gutter-x) * .5);padding-left:calc(var(--bs-gutter-x) * .5);margin-top:var(--bs-gutter-y)}.col{flex:1 0 0}.row-cols-auto>*{flex:0 0 auto;width:auto}.row-cols-1>*{flex:0 0 auto;width:100%}.row-cols-2>*{flex:0 0 auto;width:50%}.row-cols-3>*{flex:0 0 auto;width:33.33333333%}.row-cols-4>*{flex:0 0 auto;width:25%}.row-cols-5>*{flex:0 0 auto;width:20%}.row-cols-6>*{flex:0 0 auto;width:16.66666667%}.col-auto{flex:0 0 auto;width:auto}.col-1{flex:0 0 auto;width:8.33333333%}.col-2{flex:0 0 auto;width:16.66666667%}.col-3{flex:0 0 auto;width:25%}.col-4{flex:0 0 auto;width:33.33333333%}.col-5{flex:0 0 auto;width:41.66666667%}.col-6{flex:0 0 auto;width:50%}.col-7{flex:0 0 auto;width:58.33333333%}.col-8{flex:0 0 auto;width:66.66666667%}.col-9{flex:0 0 auto;width:75%}.col-10{flex:0 0 auto;width:83.33333333%}.col-11{flex:0 0 auto;width:91.66666667%}.col-12{flex:0 0 auto;width:100%}.offset-1{margin-left:8.33333333%}.offset-2{margin-left:16.66666667%}.offset-3{margin-left:25%}.offset-4{margin-left:33.33333333%}.offset-5{margin-left:41.66666667%}.offset-6{margin-left:50%}.offset-7{margin-left:58.33333333%}.offset-8{margin-left:66.66666667%}.offset-9{margin-left:75%}.offset-10{margin-left:83.33333333%}.offset-11{margin-left:91.66666667%}.g-0,.gx-0{--bs-gutter-x: 0}.g-0,.gy-0{--bs-gutter-y: 0}.g-1,.gx-1{--bs-gutter-x: .25rem}.g-1,.gy-1{--bs-gutter-y: .25rem}.g-2,.gx-2{--bs-gutter-x: .5rem}.g-2,.gy-2{--bs-gutter-y: .5rem}.g-3,.gx-3{--bs-gutter-x: 1rem}.g-3,.gy-3{--bs-gutter-y: 1rem}.g-4,.gx-4{--bs-gutter-x: 1.5rem}.g-4,.gy-4{--bs-gutter-y: 1.5rem}.g-5,.gx-5{--bs-gutter-x: 3rem}.g-5,.gy-5{--bs-gutter-y: 3rem}@media (min-width: 576px){.col-sm{flex:1 0 0}.row-cols-sm-auto>*{flex:0 0 auto;width:auto}.row-cols-sm-1>*{flex:0 0 auto;width:100%}.row-cols-sm-2>*{flex:0 0 auto;width:50%}.row-cols-sm-3>*{flex:0 0 auto;width:33.33333333%}.row-cols-sm-4>*{flex:0 0 auto;width:25%}.row-cols-sm-5>*{flex:0 0 auto;width:20%}.row-cols-sm-6>*{flex:0 0 auto;width:16.66666667%}.col-sm-auto{flex:0 0 auto;width:auto}.col-sm-1{flex:0 0 auto;width:8.33333333%}.col-sm-2{flex:0 0 auto;width:16.66666667%}.col-sm-3{flex:0 0 auto;width:25%}.col-sm-4{flex:0 0 auto;width:33.33333333%}.col-sm-5{flex:0 0 auto;width:41.66666667%}.col-sm-6{flex:0 0 auto;width:50%}.col-sm-7{flex:0 0 auto;width:58.33333333%}.col-sm-8{flex:0 0 auto;width:66.66666667%}.col-sm-9{flex:0 0 auto;width:75%}.col-sm-10{flex:0 0 auto;width:83.33333333%}.col-sm-11{flex:0 0 auto;width:91.66666667%}.col-sm-12{flex:0 0 auto;width:100%}.offset-sm-0{margin-left:0}.offset-sm-1{margin-left:8.33333333%}.offset-sm-2{margin-left:16.66666667%}.offset-sm-3{margin-left:25%}.offset-sm-4{margin-left:33.33333333%}.offset-sm-5{margin-left:41.66666667%}.offset-sm-6{margin-left:50%}.offset-sm-7{margin-left:58.33333333%}.offset-sm-8{margin-left:66.66666667%}.offset-sm-9{margin-left:75%}.offset-sm-10{margin-left:83.33333333%}.offset-sm-11{margin-left:91.66666667%}.g-sm-0,.gx-sm-0{--bs-gutter-x: 0}.g-sm-0,.gy-sm-0{--bs-gutter-y: 0}.g-sm-1,.gx-sm-1{--bs-gutter-x: .25rem}.g-sm-1,.gy-sm-1{--bs-gutter-y: .25rem}.g-sm-2,.gx-sm-2{--bs-gutter-x: .5rem}.g-sm-2,.gy-sm-2{--bs-gutter-y: .5rem}.g-sm-3,.gx-sm-3{--bs-gutter-x: 1rem}.g-sm-3,.gy-sm-3{--bs-gutter-y: 1rem}.g-sm-4,.gx-sm-4{--bs-gutter-x: 1.5rem}.g-sm-4,.gy-sm-4{--bs-gutter-y: 1.5rem}.g-sm-5,.gx-sm-5{--bs-gutter-x: 3rem}.g-sm-5,.gy-sm-5{--bs-gutter-y: 3rem}}@media (min-width: 768px){.col-md{flex:1 0 0}.row-cols-md-auto>*{flex:0 0 auto;width:auto}.row-cols-md-1>*{flex:0 0 auto;width:100%}.row-cols-md-2>*{flex:0 0 auto;width:50%}.row-cols-md-3>*{flex:0 0 auto;width:33.33333333%}.row-cols-md-4>*{flex:0 0 auto;width:25%}.row-cols-md-5>*{flex:0 0 auto;width:20%}.row-cols-md-6>*{flex:0 0 auto;width:16.66666667%}.col-md-auto{flex:0 0 auto;width:auto}.col-md-1{flex:0 0 auto;width:8.33333333%}.col-md-2{flex:0 0 auto;width:16.66666667%}.col-md-3{flex:0 0 auto;width:25%}.col-md-4{flex:0 0 auto;width:33.33333333%}.col-md-5{flex:0 0 auto;width:41.66666667%}.col-md-6{flex:0 0 auto;width:50%}.col-md-7{flex:0 0 auto;width:58.33333333%}.col-md-8{flex:0 0 auto;width:66.66666667%}.col-md-9{flex:0 0 auto;width:75%}.col-md-10{flex:0 0 auto;width:83.33333333%}.col-md-11{flex:0 0 auto;width:91.66666667%}.col-md-12{flex:0 0 auto;width:100%}.offset-md-0{margin-left:0}.offset-md-1{margin-left:8.33333333%}.offset-md-2{margin-left:16.66666667%}.offset-md-3{margin-left:25%}.offset-md-4{margin-left:33.33333333%}.offset-md-5{margin-left:41.66666667%}.offset-md-6{margin-left:50%}.offset-md-7{margin-left:58.33333333%}.offset-md-8{margin-left:66.66666667%}.offset-md-9{margin-left:75%}.offset-md-10{margin-left:83.33333333%}.offset-md-11{margin-left:91.66666667%}.g-md-0,.gx-md-0{--bs-gutter-x: 0}.g-md-0,.gy-md-0{--bs-gutter-y: 0}.g-md-1,.gx-md-1{--bs-gutter-x: .25rem}.g-md-1,.gy-md-1{--bs-gutter-y: .25rem}.g-md-2,.gx-md-2{--bs-gutter-x: .5rem}.g-md-2,.gy-md-2{--bs-gutter-y: .5rem}.g-md-3,.gx-md-3{--bs-gutter-x: 1rem}.g-md-3,.gy-md-3{--bs-gutter-y: 1rem}.g-md-4,.gx-md-4{--bs-gutter-x: 1.5rem}.g-md-4,.gy-md-4{--bs-gutter-y: 1.5rem}.g-md-5,.gx-md-5{--bs-gutter-x: 3rem}.g-md-5,.gy-md-5{--bs-gutter-y: 3rem}}@media (min-width: 992px){.col-lg{flex:1 0 0}.row-cols-lg-auto>*{flex:0 0 auto;width:auto}.row-cols-lg-1>*{flex:0 0 auto;width:100%}.row-cols-lg-2>*{flex:0 0 auto;width:50%}.row-cols-lg-3>*{flex:0 0 auto;width:33.33333333%}.row-cols-lg-4>*{flex:0 0 auto;width:25%}.row-cols-lg-5>*{flex:0 0 auto;width:20%}.row-cols-lg-6>*{flex:0 0 auto;width:16.66666667%}.col-lg-auto{flex:0 0 auto;width:auto}.col-lg-1{flex:0 0 auto;width:8.33333333%}.col-lg-2{flex:0 0 auto;width:16.66666667%}.col-lg-3{flex:0 0 auto;width:25%}.col-lg-4{flex:0 0 auto;width:33.33333333%}.col-lg-5{flex:0 0 auto;width:41.66666667%}.col-lg-6{flex:0 0 auto;width:50%}.col-lg-7{flex:0 0 auto;width:58.33333333%}.col-lg-8{flex:0 0 auto;width:66.66666667%}.col-lg-9{flex:0 0 auto;width:75%}.col-lg-10{flex:0 0 auto;width:83.33333333%}.col-lg-11{flex:0 0 auto;width:91.66666667%}.col-lg-12{flex:0 0 auto;width:100%}.offset-lg-0{margin-left:0}.offset-lg-1{margin-left:8.33333333%}.offset-lg-2{margin-left:16.66666667%}.offset-lg-3{margin-left:25%}.offset-lg-4{margin-left:33.33333333%}.offset-lg-5{margin-left:41.66666667%}.offset-lg-6{margin-left:50%}.offset-lg-7{margin-left:58.33333333%}.offset-lg-8{margin-left:66.66666667%}.offset-lg-9{margin-left:75%}.offset-lg-10{margin-left:83.33333333%}.offset-lg-11{margin-left:91.66666667%}.g-lg-0,.gx-lg-0{--bs-gutter-x: 0}.g-lg-0,.gy-lg-0{--bs-gutter-y: 0}.g-lg-1,.gx-lg-1{--bs-gutter-x: .25rem}.g-lg-1,.gy-lg-1{--bs-gutter-y: .25rem}.g-lg-2,.gx-lg-2{--bs-gutter-x: .5rem}.g-lg-2,.gy-lg-2{--bs-gutter-y: .5rem}.g-lg-3,.gx-lg-3{--bs-gutter-x: 1rem}.g-lg-3,.gy-lg-3{--bs-gutter-y: 1rem}.g-lg-4,.gx-lg-4{--bs-gutter-x: 1.5rem}.g-lg-4,.gy-lg-4{--bs-gutter-y: 1.5rem}.g-lg-5,.gx-lg-5{--bs-gutter-x: 3rem}.g-lg-5,.gy-lg-5{--bs-gutter-y: 3rem}}@media (min-width: 1200px){.col-xl{flex:1 0 0}.row-cols-xl-auto>*{flex:0 0 auto;width:auto}.row-cols-xl-1>*{flex:0 0 auto;width:100%}.row-cols-xl-2>*{flex:0 0 auto;width:50%}.row-cols-xl-3>*{flex:0 0 auto;width:33.33333333%}.row-cols-xl-4>*{flex:0 0 auto;width:25%}.row-cols-xl-5>*{flex:0 0 auto;width:20%}.row-cols-xl-6>*{flex:0 0 auto;width:16.66666667%}.col-xl-auto{flex:0 0 auto;width:auto}.col-xl-1{flex:0 0 auto;width:8.33333333%}.col-xl-2{flex:0 0 auto;width:16.66666667%}.col-xl-3{flex:0 0 auto;width:25%}.col-xl-4{flex:0 0 auto;width:33.33333333%}.col-xl-5{flex:0 0 auto;width:41.66666667%}.col-xl-6{flex:0 0 auto;width:50%}.col-xl-7{flex:0 0 auto;width:58.33333333%}.col-xl-8{flex:0 0 auto;width:66.66666667%}.col-xl-9{flex:0 0 auto;width:75%}.col-xl-10{flex:0 0 auto;width:83.33333333%}.col-xl-11{flex:0 0 auto;width:91.66666667%}.col-xl-12{flex:0 0 auto;width:100%}.offset-xl-0{margin-left:0}.offset-xl-1{margin-left:8.33333333%}.offset-xl-2{margin-left:16.66666667%}.offset-xl-3{margin-left:25%}.offset-xl-4{margin-left:33.33333333%}.offset-xl-5{margin-left:41.66666667%}.offset-xl-6{margin-left:50%}.offset-xl-7{margin-left:58.33333333%}.offset-xl-8{margin-left:66.66666667%}.offset-xl-9{margin-left:75%}.offset-xl-10{margin-left:83.33333333%}.offset-xl-11{margin-left:91.66666667%}.g-xl-0,.gx-xl-0{--bs-gutter-x: 0}.g-xl-0,.gy-xl-0{--bs-gutter-y: 0}.g-xl-1,.gx-xl-1{--bs-gutter-x: .25rem}.g-xl-1,.gy-xl-1{--bs-gutter-y: .25rem}.g-xl-2,.gx-xl-2{--bs-gutter-x: .5rem}.g-xl-2,.gy-xl-2{--bs-gutter-y: .5rem}.g-xl-3,.gx-xl-3{--bs-gutter-x: 1rem}.g-xl-3,.gy-xl-3{--bs-gutter-y: 1rem}.g-xl-4,.gx-xl-4{--bs-gutter-x: 1.5rem}.g-xl-4,.gy-xl-4{--bs-gutter-y: 1.5rem}.g-xl-5,.gx-xl-5{--bs-gutter-x: 3rem}.g-xl-5,.gy-xl-5{--bs-gutter-y: 3rem}}@media (min-width: 1400px){.col-xxl{flex:1 0 0}.row-cols-xxl-auto>*{flex:0 0 auto;width:auto}.row-cols-xxl-1>*{flex:0 0 auto;width:100%}.row-cols-xxl-2>*{flex:0 0 auto;width:50%}.row-cols-xxl-3>*{flex:0 0 auto;width:33.33333333%}.row-cols-xxl-4>*{flex:0 0 auto;width:25%}.row-cols-xxl-5>*{flex:0 0 auto;width:20%}.row-cols-xxl-6>*{flex:0 0 auto;width:16.66666667%}.col-xxl-auto{flex:0 0 auto;width:auto}.col-xxl-1{flex:0 0 auto;width:8.33333333%}.col-xxl-2{flex:0 0 auto;width:16.66666667%}.col-xxl-3{flex:0 0 auto;width:25%}.col-xxl-4{flex:0 0 auto;width:33.33333333%}.col-xxl-5{flex:0 0 auto;width:41.66666667%}.col-xxl-6{flex:0 0 auto;width:50%}.col-xxl-7{flex:0 0 auto;width:58.33333333%}.col-xxl-8{flex:0 0 auto;width:66.66666667%}.col-xxl-9{flex:0 0 auto;width:75%}.col-xxl-10{flex:0 0 auto;width:83.33333333%}.col-xxl-11{flex:0 0 auto;width:91.66666667%}.col-xxl-12{flex:0 0 auto;width:100%}.offset-xxl-0{margin-left:0}.offset-xxl-1{margin-left:8.33333333%}.offset-xxl-2{margin-left:16.66666667%}.offset-xxl-3{margin-left:25%}.offset-xxl-4{margin-left:33.33333333%}.offset-xxl-5{margin-left:41.66666667%}.offset-xxl-6{margin-left:50%}.offset-xxl-7{margin-left:58.33333333%}.offset-xxl-8{margin-left:66.66666667%}.offset-xxl-9{margin-left:75%}.offset-xxl-10{margin-left:83.33333333%}.offset-xxl-11{margin-left:91.66666667%}.g-xxl-0,.gx-xxl-0{--bs-gutter-x: 0}.g-xxl-0,.gy-xxl-0{--bs-gutter-y: 0}.g-xxl-1,.gx-xxl-1{--bs-gutter-x: .25rem}.g-xxl-1,.gy-xxl-1{--bs-gutter-y: .25rem}.g-xxl-2,.gx-xxl-2{--bs-gutter-x: .5rem}.g-xxl-2,.gy-xxl-2{--bs-gutter-y: .5rem}.g-xxl-3,.gx-xxl-3{--bs-gutter-x: 1rem}.g-xxl-3,.gy-xxl-3{--bs-gutter-y: 1rem}.g-xxl-4,.gx-xxl-4{--bs-gutter-x: 1.5rem}.g-xxl-4,.gy-xxl-4{--bs-gutter-y: 1.5rem}.g-xxl-5,.gx-xxl-5{--bs-gutter-x: 3rem}.g-xxl-5,.gy-xxl-5{--bs-gutter-y: 3rem}}.table{--bs-table-color-type: initial;--bs-table-bg-type: initial;--bs-table-color-state: initial;--bs-table-bg-state: initial;--bs-table-color: var(--bs-emphasis-color);--bs-table-bg: var(--bs-body-bg);--bs-table-border-color: var(--bs-border-color);--bs-table-accent-bg: transparent;--bs-table-striped-color: var(--bs-emphasis-color);--bs-table-striped-bg: rgba(var(--bs-emphasis-color-rgb), .05);--bs-table-active-color: var(--bs-emphasis-color);--bs-table-active-bg: rgba(var(--bs-emphasis-color-rgb), .1);--bs-table-hover-color: var(--bs-emphasis-color);--bs-table-hover-bg: rgba(var(--bs-emphasis-color-rgb), .075);width:100%;margin-bottom:1rem;vertical-align:top;border-color:var(--bs-table-border-color)}.table>:not(caption)>*>*{padding:.5rem;color:var(--bs-table-color-state, var(--bs-table-color-type, var(--bs-table-color)));background-color:var(--bs-table-bg);border-bottom-width:var(--bs-border-width);box-shadow:inset 0 0 0 9999px var(--bs-table-bg-state, var(--bs-table-bg-type, var(--bs-table-accent-bg)))}.table>tbody{vertical-align:inherit}.table>thead{vertical-align:bottom}.table-group-divider{border-top:calc(var(--bs-border-width) * 2) solid currentcolor}.caption-top{caption-side:top}.table-sm>:not(caption)>*>*{padding:.25rem}.table-bordered>:not(caption)>*{border-width:var(--bs-border-width) 0}.table-bordered>:not(caption)>*>*{border-width:0 var(--bs-border-width)}.table-borderless>:not(caption)>*>*{border-bottom-width:0}.table-borderless>:not(:first-child){border-top-width:0}.table-striped>tbody>tr:nth-of-type(odd)>*{--bs-table-color-type: var(--bs-table-striped-color);--bs-table-bg-type: var(--bs-table-striped-bg)}.table-striped-columns>:not(caption)>tr>:nth-child(2n){--bs-table-color-type: var(--bs-table-striped-color);--bs-table-bg-type: var(--bs-table-striped-bg)}.table-active{--bs-table-color-state: var(--bs-table-active-color);--bs-table-bg-state: var(--bs-table-active-bg)}.table-hover>tbody>tr:hover>*{--bs-table-color-state: var(--bs-table-hover-color);--bs-table-bg-state: var(--bs-table-hover-bg)}.table-primary{--bs-table-color: #000;--bs-table-bg: rgb(206.6, 226, 254.6);--bs-table-border-color: rgb(165.28, 180.8, 203.68);--bs-table-striped-bg: rgb(196.27, 214.7, 241.87);--bs-table-striped-color: #000;--bs-table-active-bg: rgb(185.94, 203.4, 229.14);--bs-table-active-color: #000;--bs-table-hover-bg: rgb(191.105, 209.05, 235.505);--bs-table-hover-color: #000;color:var(--bs-table-color);border-color:var(--bs-table-border-color)}.table-secondary{--bs-table-color: #000;--bs-table-bg: rgb(225.6, 227.4, 229);--bs-table-border-color: rgb(180.48, 181.92, 183.2);--bs-table-striped-bg: rgb(214.32, 216.03, 217.55);--bs-table-striped-color: #000;--bs-table-active-bg: rgb(203.04, 204.66, 206.1);--bs-table-active-color: #000;--bs-table-hover-bg: rgb(208.68, 210.345, 211.825);--bs-table-hover-color: #000;color:var(--bs-table-color);border-color:var(--bs-table-border-color)}.table-success{--bs-table-color: #000;--bs-table-bg: rgb(209, 231, 220.8);--bs-table-border-color: rgb(167.2, 184.8, 176.64);--bs-table-striped-bg: rgb(198.55, 219.45, 209.76);--bs-table-striped-color: #000;--bs-table-active-bg: rgb(188.1, 207.9, 198.72);--bs-table-active-color: #000;--bs-table-hover-bg: rgb(193.325, 213.675, 204.24);--bs-table-hover-color: #000;color:var(--bs-table-color);border-color:var(--bs-table-border-color)}.table-info{--bs-table-color: #000;--bs-table-bg: rgb(206.6, 244.4, 252);--bs-table-border-color: rgb(165.28, 195.52, 201.6);--bs-table-striped-bg: rgb(196.27, 232.18, 239.4);--bs-table-striped-color: #000;--bs-table-active-bg: rgb(185.94, 219.96, 226.8);--bs-table-active-color: #000;--bs-table-hover-bg: rgb(191.105, 226.07, 233.1);--bs-table-hover-color: #000;color:var(--bs-table-color);border-color:var(--bs-table-border-color)}.table-warning{--bs-table-color: #000;--bs-table-bg: rgb(255, 242.6, 205.4);--bs-table-border-color: rgb(204, 194.08, 164.32);--bs-table-striped-bg: rgb(242.25, 230.47, 195.13);--bs-table-striped-color: #000;--bs-table-active-bg: rgb(229.5, 218.34, 184.86);--bs-table-active-color: #000;--bs-table-hover-bg: rgb(235.875, 224.405, 189.995);--bs-table-hover-color: #000;color:var(--bs-table-color);border-color:var(--bs-table-border-color)}.table-danger{--bs-table-color: #000;--bs-table-bg: rgb(248, 214.6, 217.8);--bs-table-border-color: rgb(198.4, 171.68, 174.24);--bs-table-striped-bg: rgb(235.6, 203.87, 206.91);--bs-table-striped-color: #000;--bs-table-active-bg: rgb(223.2, 193.14, 196.02);--bs-table-active-color: #000;--bs-table-hover-bg: rgb(229.4, 198.505, 201.465);--bs-table-hover-color: #000;color:var(--bs-table-color);border-color:var(--bs-table-border-color)}.table-light{--bs-table-color: #000;--bs-table-bg: #f8f9fa;--bs-table-border-color: rgb(198.4, 199.2, 200);--bs-table-striped-bg: rgb(235.6, 236.55, 237.5);--bs-table-striped-color: #000;--bs-table-active-bg: rgb(223.2, 224.1, 225);--bs-table-active-color: #000;--bs-table-hover-bg: rgb(229.4, 230.325, 231.25);--bs-table-hover-color: #000;color:var(--bs-table-color);border-color:var(--bs-table-border-color)}.table-dark{--bs-table-color: #fff;--bs-table-bg: #212529;--bs-table-border-color: rgb(77.4, 80.6, 83.8);--bs-table-striped-bg: rgb(44.1, 47.9, 51.7);--bs-table-striped-color: #fff;--bs-table-active-bg: rgb(55.2, 58.8, 62.4);--bs-table-active-color: #fff;--bs-table-hover-bg: rgb(49.65, 53.35, 57.05);--bs-table-hover-color: #fff;color:var(--bs-table-color);border-color:var(--bs-table-border-color)}.table-responsive{overflow-x:auto;-webkit-overflow-scrolling:touch}@media (max-width: 575.98px){.table-responsive-sm{overflow-x:auto;-webkit-overflow-scrolling:touch}}@media (max-width: 767.98px){.table-responsive-md{overflow-x:auto;-webkit-overflow-scrolling:touch}}@media (max-width: 991.98px){.table-responsive-lg{overflow-x:auto;-webkit-overflow-scrolling:touch}}@media (max-width: 1199.98px){.table-responsive-xl{overflow-x:auto;-webkit-overflow-scrolling:touch}}@media (max-width: 1399.98px){.table-responsive-xxl{overflow-x:auto;-webkit-overflow-scrolling:touch}}.form-label{margin-bottom:.5rem}.col-form-label{padding-top:calc(.375rem + var(--bs-border-width));padding-bottom:calc(.375rem + var(--bs-border-width));margin-bottom:0;font-size:inherit;line-height:1.5}.col-form-label-lg{padding-top:calc(.5rem + var(--bs-border-width));padding-bottom:calc(.5rem + var(--bs-border-width));font-size:1.25rem}.col-form-label-sm{padding-top:calc(.25rem + var(--bs-border-width));padding-bottom:calc(.25rem + var(--bs-border-width));font-size:.875rem}.form-text{margin-top:.25rem;font-size:.875em;color:var(--bs-secondary-color)}.form-control{display:block;width:100%;padding:.375rem .75rem;font-size:1rem;font-weight:400;line-height:1.5;color:var(--bs-body-color);appearance:none;background-color:var(--bs-body-bg);background-clip:padding-box;border:var(--bs-border-width) solid var(--bs-border-color);border-radius:var(--bs-border-radius);transition:border-color .15s ease-in-out,box-shadow .15s ease-in-out}@media (prefers-reduced-motion: reduce){.form-control{transition:none}}.form-control[type=file]{overflow:hidden}.form-control[type=file]:not(:disabled):not([readonly]){cursor:pointer}.form-control:focus{color:var(--bs-body-color);background-color:var(--bs-body-bg);border-color:#86b7fe;outline:0;box-shadow:0 0 0 .25rem #0d6efd40}.form-control::-webkit-date-and-time-value{min-width:85px;height:1.5em;margin:0}.form-control::-webkit-datetime-edit{display:block;padding:0}.form-control::placeholder{color:var(--bs-secondary-color);opacity:1}.form-control:disabled{background-color:var(--bs-secondary-bg);opacity:1}.form-control::file-selector-button{padding:.375rem .75rem;margin:-.375rem -.75rem;margin-inline-end:.75rem;color:var(--bs-body-color);background-color:var(--bs-tertiary-bg);pointer-events:none;border-color:inherit;border-style:solid;border-width:0;border-inline-end-width:var(--bs-border-width);border-radius:0;transition:color .15s ease-in-out,background-color .15s ease-in-out,border-color .15s ease-in-out,box-shadow .15s ease-in-out}@media (prefers-reduced-motion: reduce){.form-control::file-selector-button{transition:none}}.form-control:hover:not(:disabled):not([readonly])::file-selector-button{background-color:var(--bs-secondary-bg)}.form-control-plaintext{display:block;width:100%;padding:.375rem 0;margin-bottom:0;line-height:1.5;color:var(--bs-body-color);background-color:transparent;border:solid transparent;border-width:var(--bs-border-width) 0}.form-control-plaintext:focus{outline:0}.form-control-plaintext.form-control-sm,.form-control-plaintext.form-control-lg{padding-right:0;padding-left:0}.form-control-sm{min-height:calc(1.5em + .5rem + calc(var(--bs-border-width) * 2));padding:.25rem .5rem;font-size:.875rem;border-radius:var(--bs-border-radius-sm)}.form-control-sm::file-selector-button{padding:.25rem .5rem;margin:-.25rem -.5rem;margin-inline-end:.5rem}.form-control-lg{min-height:calc(1.5em + 1rem + calc(var(--bs-border-width) * 2));padding:.5rem 1rem;font-size:1.25rem;border-radius:var(--bs-border-radius-lg)}.form-control-lg::file-selector-button{padding:.5rem 1rem;margin:-.5rem -1rem;margin-inline-end:1rem}textarea.form-control{min-height:calc(1.5em + .75rem + calc(var(--bs-border-width) * 2))}textarea.form-control-sm{min-height:calc(1.5em + .5rem + calc(var(--bs-border-width) * 2))}textarea.form-control-lg{min-height:calc(1.5em + 1rem + calc(var(--bs-border-width) * 2))}.form-control-color{width:3rem;height:calc(1.5em + .75rem + calc(var(--bs-border-width) * 2));padding:.375rem}.form-control-color:not(:disabled):not([readonly]){cursor:pointer}.form-control-color::-moz-color-swatch{border:0!important;border-radius:var(--bs-border-radius)}.form-control-color::-webkit-color-swatch{border:0!important;border-radius:var(--bs-border-radius)}.form-control-color.form-control-sm{height:calc(1.5em + .5rem + calc(var(--bs-border-width) * 2))}.form-control-color.form-control-lg{height:calc(1.5em + 1rem + calc(var(--bs-border-width) * 2))}.form-select{--bs-form-select-bg-img: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16'%3e%3cpath fill='none' stroke='%23343a40' stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='m2 5 6 6 6-6'/%3e%3c/svg%3e");display:block;width:100%;padding:.375rem 2.25rem .375rem .75rem;font-size:1rem;font-weight:400;line-height:1.5;color:var(--bs-body-color);appearance:none;background-color:var(--bs-body-bg);background-image:var(--bs-form-select-bg-img),var(--bs-form-select-bg-icon, none);background-repeat:no-repeat;background-position:right .75rem center;background-size:16px 12px;border:var(--bs-border-width) solid var(--bs-border-color);border-radius:var(--bs-border-radius);transition:border-color .15s ease-in-out,box-shadow .15s ease-in-out}@media (prefers-reduced-motion: reduce){.form-select{transition:none}}.form-select:focus{border-color:#86b7fe;outline:0;box-shadow:0 0 0 .25rem #0d6efd40}.form-select[multiple],.form-select[size]:not([size="1"]){padding-right:.75rem;background-image:none}.form-select:disabled{background-color:var(--bs-secondary-bg)}.form-select:-moz-focusring{color:transparent;text-shadow:0 0 0 var(--bs-body-color)}.form-select-sm{padding-top:.25rem;padding-bottom:.25rem;padding-left:.5rem;font-size:.875rem;border-radius:var(--bs-border-radius-sm)}.form-select-lg{padding-top:.5rem;padding-bottom:.5rem;padding-left:1rem;font-size:1.25rem;border-radius:var(--bs-border-radius-lg)}[data-bs-theme=dark] .form-select{--bs-form-select-bg-img: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16'%3e%3cpath fill='none' stroke='%23dee2e6' stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='m2 5 6 6 6-6'/%3e%3c/svg%3e")}.form-check{display:block;min-height:1.5rem;padding-left:1.5em;margin-bottom:.125rem}.form-check .form-check-input{float:left;margin-left:-1.5em}.form-check-reverse{padding-right:1.5em;padding-left:0;text-align:right}.form-check-reverse .form-check-input{float:right;margin-right:-1.5em;margin-left:0}.form-check-input{--bs-form-check-bg: var(--bs-body-bg);flex-shrink:0;width:1em;height:1em;margin-top:.25em;vertical-align:top;appearance:none;background-color:var(--bs-form-check-bg);background-image:var(--bs-form-check-bg-image);background-repeat:no-repeat;background-position:center;background-size:contain;border:var(--bs-border-width) solid var(--bs-border-color);print-color-adjust:exact}.form-check-input[type=checkbox]{border-radius:.25em}.form-check-input[type=radio]{border-radius:50%}.form-check-input:active{filter:brightness(90%)}.form-check-input:focus{border-color:#86b7fe;outline:0;box-shadow:0 0 0 .25rem #0d6efd40}.form-check-input:checked{background-color:#0d6efd;border-color:#0d6efd}.form-check-input:checked[type=checkbox]{--bs-form-check-bg-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 20 20'%3e%3cpath fill='none' stroke='%23fff' stroke-linecap='round' stroke-linejoin='round' stroke-width='3' d='m6 10 3 3 6-6'/%3e%3c/svg%3e")}.form-check-input:checked[type=radio]{--bs-form-check-bg-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='-4 -4 8 8'%3e%3ccircle r='2' fill='%23fff'/%3e%3c/svg%3e")}.form-check-input[type=checkbox]:indeterminate{background-color:#0d6efd;border-color:#0d6efd;--bs-form-check-bg-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 20 20'%3e%3cpath fill='none' stroke='%23fff' stroke-linecap='round' stroke-linejoin='round' stroke-width='3' d='M6 10h8'/%3e%3c/svg%3e")}.form-check-input:disabled{pointer-events:none;filter:none;opacity:.5}.form-check-input[disabled]~.form-check-label,.form-check-input:disabled~.form-check-label{cursor:default;opacity:.5}.form-switch{padding-left:2.5em}.form-switch .form-check-input{--bs-form-switch-bg: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='-4 -4 8 8'%3e%3ccircle r='3' fill='rgba%280, 0, 0, 0.25%29'/%3e%3c/svg%3e");width:2em;margin-left:-2.5em;background-image:var(--bs-form-switch-bg);background-position:left center;border-radius:2em;transition:background-position .15s ease-in-out}@media (prefers-reduced-motion: reduce){.form-switch .form-check-input{transition:none}}.form-switch .form-check-input:focus{--bs-form-switch-bg: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='-4 -4 8 8'%3e%3ccircle r='3' fill='rgb%28134, 182.5, 254%29'/%3e%3c/svg%3e")}.form-switch .form-check-input:checked{background-position:right center;--bs-form-switch-bg: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='-4 -4 8 8'%3e%3ccircle r='3' fill='%23fff'/%3e%3c/svg%3e")}.form-switch.form-check-reverse{padding-right:2.5em;padding-left:0}.form-switch.form-check-reverse .form-check-input{margin-right:-2.5em;margin-left:0}.form-check-inline{display:inline-block;margin-right:1rem}.btn-check{position:absolute;clip:rect(0,0,0,0);pointer-events:none}.btn-check[disabled]+.btn,.btn-check:disabled+.btn{pointer-events:none;filter:none;opacity:.65}[data-bs-theme=dark] .form-switch .form-check-input:not(:checked):not(:focus){--bs-form-switch-bg: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='-4 -4 8 8'%3e%3ccircle r='3' fill='rgba%28255, 255, 255, 0.25%29'/%3e%3c/svg%3e")}.form-range{width:100%;height:1.5rem;padding:0;appearance:none;background-color:transparent}.form-range:focus{outline:0}.form-range:focus::-webkit-slider-thumb{box-shadow:0 0 0 1px #fff,0 0 0 .25rem #0d6efd40}.form-range:focus::-moz-range-thumb{box-shadow:0 0 0 1px #fff,0 0 0 .25rem #0d6efd40}.form-range::-moz-focus-outer{border:0}.form-range::-webkit-slider-thumb{width:1rem;height:1rem;margin-top:-.25rem;appearance:none;background-color:#0d6efd;border:0;border-radius:1rem;transition:background-color .15s ease-in-out,border-color .15s ease-in-out,box-shadow .15s ease-in-out}@media (prefers-reduced-motion: reduce){.form-range::-webkit-slider-thumb{transition:none}}.form-range::-webkit-slider-thumb:active{background-color:#b6d4fe}.form-range::-webkit-slider-runnable-track{width:100%;height:.5rem;color:transparent;cursor:pointer;background-color:var(--bs-secondary-bg);border-color:transparent;border-radius:1rem}.form-range::-moz-range-thumb{width:1rem;height:1rem;appearance:none;background-color:#0d6efd;border:0;border-radius:1rem;transition:background-color .15s ease-in-out,border-color .15s ease-in-out,box-shadow .15s ease-in-out}@media (prefers-reduced-motion: reduce){.form-range::-moz-range-thumb{transition:none}}.form-range::-moz-range-thumb:active{background-color:#b6d4fe}.form-range::-moz-range-track{width:100%;height:.5rem;color:transparent;cursor:pointer;background-color:var(--bs-secondary-bg);border-color:transparent;border-radius:1rem}.form-range:disabled{pointer-events:none}.form-range:disabled::-webkit-slider-thumb{background-color:var(--bs-secondary-color)}.form-range:disabled::-moz-range-thumb{background-color:var(--bs-secondary-color)}.form-floating{position:relative}.form-floating>.form-control,.form-floating>.form-control-plaintext,.form-floating>.form-select{height:calc(3.5rem + calc(var(--bs-border-width) * 2));min-height:calc(3.5rem + calc(var(--bs-border-width) * 2));line-height:1.25}.form-floating>label{position:absolute;top:0;left:0;z-index:2;max-width:100%;height:100%;padding:1rem .75rem;overflow:hidden;color:rgba(var(--bs-body-color-rgb),.65);text-align:start;text-overflow:ellipsis;white-space:nowrap;pointer-events:none;border:var(--bs-border-width) solid transparent;transform-origin:0 0;transition:opacity .1s ease-in-out,transform .1s ease-in-out}@media (prefers-reduced-motion: reduce){.form-floating>label{transition:none}}.form-floating>.form-control,.form-floating>.form-control-plaintext{padding:1rem .75rem}.form-floating>.form-control::placeholder,.form-floating>.form-control-plaintext::placeholder{color:transparent}.form-floating>.form-control:focus,.form-floating>.form-control:not(:placeholder-shown),.form-floating>.form-control-plaintext:focus,.form-floating>.form-control-plaintext:not(:placeholder-shown){padding-top:1.625rem;padding-bottom:.625rem}.form-floating>.form-control:-webkit-autofill,.form-floating>.form-control-plaintext:-webkit-autofill{padding-top:1.625rem;padding-bottom:.625rem}.form-floating>.form-select{padding-top:1.625rem;padding-bottom:.625rem;padding-left:.75rem}.form-floating>.form-control:focus~label,.form-floating>.form-control:not(:placeholder-shown)~label,.form-floating>.form-control-plaintext~label,.form-floating>.form-select~label{transform:scale(.85) translateY(-.5rem) translate(.15rem)}.form-floating>.form-control:-webkit-autofill~label{transform:scale(.85) translateY(-.5rem) translate(.15rem)}.form-floating>textarea:focus~label:after,.form-floating>textarea:not(:placeholder-shown)~label:after{position:absolute;inset:1rem .375rem;z-index:-1;height:1.5em;content:"";background-color:var(--bs-body-bg);border-radius:var(--bs-border-radius)}.form-floating>textarea:disabled~label:after{background-color:var(--bs-secondary-bg)}.form-floating>.form-control-plaintext~label{border-width:var(--bs-border-width) 0}.form-floating>:disabled~label,.form-floating>.form-control:disabled~label{color:#6c757d}.input-group{position:relative;display:flex;flex-wrap:wrap;align-items:stretch;width:100%}.input-group>.form-control,.input-group>.form-select,.input-group>.form-floating{position:relative;flex:1 1 auto;width:1%;min-width:0}.input-group>.form-control:focus,.input-group>.form-select:focus,.input-group>.form-floating:focus-within{z-index:5}.input-group .btn{position:relative;z-index:2}.input-group .btn:focus{z-index:5}.input-group-text{display:flex;align-items:center;padding:.375rem .75rem;font-size:1rem;font-weight:400;line-height:1.5;color:var(--bs-body-color);text-align:center;white-space:nowrap;background-color:var(--bs-tertiary-bg);border:var(--bs-border-width) solid var(--bs-border-color);border-radius:var(--bs-border-radius)}.input-group-lg>.form-control,.input-group-lg>.form-select,.input-group-lg>.input-group-text,.input-group-lg>.btn{padding:.5rem 1rem;font-size:1.25rem;border-radius:var(--bs-border-radius-lg)}.input-group-sm>.form-control,.input-group-sm>.form-select,.input-group-sm>.input-group-text,.input-group-sm>.btn{padding:.25rem .5rem;font-size:.875rem;border-radius:var(--bs-border-radius-sm)}.input-group-lg>.form-select,.input-group-sm>.form-select{padding-right:3rem}.input-group:not(.has-validation)>:not(:last-child):not(.dropdown-toggle):not(.dropdown-menu):not(.form-floating),.input-group:not(.has-validation)>.dropdown-toggle:nth-last-child(n+3),.input-group:not(.has-validation)>.form-floating:not(:last-child)>.form-control,.input-group:not(.has-validation)>.form-floating:not(:last-child)>.form-select{border-top-right-radius:0;border-bottom-right-radius:0}.input-group.has-validation>:nth-last-child(n+3):not(.dropdown-toggle):not(.dropdown-menu):not(.form-floating),.input-group.has-validation>.dropdown-toggle:nth-last-child(n+4),.input-group.has-validation>.form-floating:nth-last-child(n+3)>.form-control,.input-group.has-validation>.form-floating:nth-last-child(n+3)>.form-select{border-top-right-radius:0;border-bottom-right-radius:0}.input-group>:not(:first-child):not(.dropdown-menu):not(.valid-tooltip):not(.valid-feedback):not(.invalid-tooltip):not(.invalid-feedback){margin-left:calc(-1 * var(--bs-border-width));border-top-left-radius:0;border-bottom-left-radius:0}.input-group>.form-floating:not(:first-child)>.form-control,.input-group>.form-floating:not(:first-child)>.form-select{border-top-left-radius:0;border-bottom-left-radius:0}.valid-feedback{display:none;width:100%;margin-top:.25rem;font-size:.875em;color:var(--bs-form-valid-color)}.valid-tooltip{position:absolute;top:100%;z-index:5;display:none;max-width:100%;padding:.25rem .5rem;margin-top:.1rem;font-size:.875rem;color:#fff;background-color:var(--bs-success);border-radius:var(--bs-border-radius)}.was-validated :valid~.valid-feedback,.was-validated :valid~.valid-tooltip,.is-valid~.valid-feedback,.is-valid~.valid-tooltip{display:block}.was-validated .form-control:valid,.form-control.is-valid{border-color:var(--bs-form-valid-border-color);padding-right:calc(1.5em + .75rem);background-image:url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 8 8'%3e%3cpath fill='%23198754' d='M2.3 6.73.6 4.53c-.4-1.04.46-1.4 1.1-.8l1.1 1.4 3.4-3.8c.6-.63 1.6-.27 1.2.7l-4 4.6c-.43.5-.8.4-1.1.1'/%3e%3c/svg%3e");background-repeat:no-repeat;background-position:right calc(.375em + .1875rem) center;background-size:calc(.75em + .375rem) calc(.75em + .375rem)}.was-validated .form-control:valid:focus,.form-control.is-valid:focus{border-color:var(--bs-form-valid-border-color);box-shadow:0 0 0 .25rem rgba(var(--bs-success-rgb),.25)}.was-validated textarea.form-control:valid,textarea.form-control.is-valid{padding-right:calc(1.5em + .75rem);background-position:top calc(.375em + .1875rem) right calc(.375em + .1875rem)}.was-validated .form-select:valid,.form-select.is-valid{border-color:var(--bs-form-valid-border-color)}.was-validated .form-select:valid:not([multiple]):not([size]),.was-validated .form-select:valid:not([multiple])[size="1"],.form-select.is-valid:not([multiple]):not([size]),.form-select.is-valid:not([multiple])[size="1"]{--bs-form-select-bg-icon: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 8 8'%3e%3cpath fill='%23198754' d='M2.3 6.73.6 4.53c-.4-1.04.46-1.4 1.1-.8l1.1 1.4 3.4-3.8c.6-.63 1.6-.27 1.2.7l-4 4.6c-.43.5-.8.4-1.1.1'/%3e%3c/svg%3e");padding-right:4.125rem;background-position:right .75rem center,center right 2.25rem;background-size:16px 12px,calc(.75em + .375rem) calc(.75em + .375rem)}.was-validated .form-select:valid:focus,.form-select.is-valid:focus{border-color:var(--bs-form-valid-border-color);box-shadow:0 0 0 .25rem rgba(var(--bs-success-rgb),.25)}.was-validated .form-control-color:valid,.form-control-color.is-valid{width:calc(3.75rem + 1.5em)}.was-validated .form-check-input:valid,.form-check-input.is-valid{border-color:var(--bs-form-valid-border-color)}.was-validated .form-check-input:valid:checked,.form-check-input.is-valid:checked{background-color:var(--bs-form-valid-color)}.was-validated .form-check-input:valid:focus,.form-check-input.is-valid:focus{box-shadow:0 0 0 .25rem rgba(var(--bs-success-rgb),.25)}.was-validated .form-check-input:valid~.form-check-label,.form-check-input.is-valid~.form-check-label{color:var(--bs-form-valid-color)}.form-check-inline .form-check-input~.valid-feedback{margin-left:.5em}.was-validated .input-group>.form-control:not(:focus):valid,.input-group>.form-control:not(:focus).is-valid,.was-validated .input-group>.form-select:not(:focus):valid,.input-group>.form-select:not(:focus).is-valid,.was-validated .input-group>.form-floating:not(:focus-within):valid,.input-group>.form-floating:not(:focus-within).is-valid{z-index:3}.invalid-feedback{display:none;width:100%;margin-top:.25rem;font-size:.875em;color:var(--bs-form-invalid-color)}.invalid-tooltip{position:absolute;top:100%;z-index:5;display:none;max-width:100%;padding:.25rem .5rem;margin-top:.1rem;font-size:.875rem;color:#fff;background-color:var(--bs-danger);border-radius:var(--bs-border-radius)}.was-validated :invalid~.invalid-feedback,.was-validated :invalid~.invalid-tooltip,.is-invalid~.invalid-feedback,.is-invalid~.invalid-tooltip{display:block}.was-validated .form-control:invalid,.form-control.is-invalid{border-color:var(--bs-form-invalid-border-color);padding-right:calc(1.5em + .75rem);background-image:url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 12 12' width='12' height='12' fill='none' stroke='%23dc3545'%3e%3ccircle cx='6' cy='6' r='4.5'/%3e%3cpath stroke-linejoin='round' d='M5.8 3.6h.4L6 6.5z'/%3e%3ccircle cx='6' cy='8.2' r='.6' fill='%23dc3545' stroke='none'/%3e%3c/svg%3e");background-repeat:no-repeat;background-position:right calc(.375em + .1875rem) center;background-size:calc(.75em + .375rem) calc(.75em + .375rem)}.was-validated .form-control:invalid:focus,.form-control.is-invalid:focus{border-color:var(--bs-form-invalid-border-color);box-shadow:0 0 0 .25rem rgba(var(--bs-danger-rgb),.25)}.was-validated textarea.form-control:invalid,textarea.form-control.is-invalid{padding-right:calc(1.5em + .75rem);background-position:top calc(.375em + .1875rem) right calc(.375em + .1875rem)}.was-validated .form-select:invalid,.form-select.is-invalid{border-color:var(--bs-form-invalid-border-color)}.was-validated .form-select:invalid:not([multiple]):not([size]),.was-validated .form-select:invalid:not([multiple])[size="1"],.form-select.is-invalid:not([multiple]):not([size]),.form-select.is-invalid:not([multiple])[size="1"]{--bs-form-select-bg-icon: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 12 12' width='12' height='12' fill='none' stroke='%23dc3545'%3e%3ccircle cx='6' cy='6' r='4.5'/%3e%3cpath stroke-linejoin='round' d='M5.8 3.6h.4L6 6.5z'/%3e%3ccircle cx='6' cy='8.2' r='.6' fill='%23dc3545' stroke='none'/%3e%3c/svg%3e");padding-right:4.125rem;background-position:right .75rem center,center right 2.25rem;background-size:16px 12px,calc(.75em + .375rem) calc(.75em + .375rem)}.was-validated .form-select:invalid:focus,.form-select.is-invalid:focus{border-color:var(--bs-form-invalid-border-color);box-shadow:0 0 0 .25rem rgba(var(--bs-danger-rgb),.25)}.was-validated .form-control-color:invalid,.form-control-color.is-invalid{width:calc(3.75rem + 1.5em)}.was-validated .form-check-input:invalid,.form-check-input.is-invalid{border-color:var(--bs-form-invalid-border-color)}.was-validated .form-check-input:invalid:checked,.form-check-input.is-invalid:checked{background-color:var(--bs-form-invalid-color)}.was-validated .form-check-input:invalid:focus,.form-check-input.is-invalid:focus{box-shadow:0 0 0 .25rem rgba(var(--bs-danger-rgb),.25)}.was-validated .form-check-input:invalid~.form-check-label,.form-check-input.is-invalid~.form-check-label{color:var(--bs-form-invalid-color)}.form-check-inline .form-check-input~.invalid-feedback{margin-left:.5em}.was-validated .input-group>.form-control:not(:focus):invalid,.input-group>.form-control:not(:focus).is-invalid,.was-validated .input-group>.form-select:not(:focus):invalid,.input-group>.form-select:not(:focus).is-invalid,.was-validated .input-group>.form-floating:not(:focus-within):invalid,.input-group>.form-floating:not(:focus-within).is-invalid{z-index:4}.btn{--bs-btn-padding-x: .75rem;--bs-btn-padding-y: .375rem;--bs-btn-font-family: ;--bs-btn-font-size: 1rem;--bs-btn-font-weight: 400;--bs-btn-line-height: 1.5;--bs-btn-color: var(--bs-body-color);--bs-btn-bg: transparent;--bs-btn-border-width: var(--bs-border-width);--bs-btn-border-color: transparent;--bs-btn-border-radius: var(--bs-border-radius);--bs-btn-hover-border-color: transparent;--bs-btn-box-shadow: inset 0 1px 0 rgba(255, 255, 255, .15), 0 1px 1px rgba(0, 0, 0, .075);--bs-btn-disabled-opacity: .65;--bs-btn-focus-box-shadow: 0 0 0 .25rem rgba(var(--bs-btn-focus-shadow-rgb), .5);display:inline-block;padding:var(--bs-btn-padding-y) var(--bs-btn-padding-x);font-family:var(--bs-btn-font-family);font-size:var(--bs-btn-font-size);font-weight:var(--bs-btn-font-weight);line-height:var(--bs-btn-line-height);color:var(--bs-btn-color);text-align:center;text-decoration:none;vertical-align:middle;cursor:pointer;user-select:none;border:var(--bs-btn-border-width) solid var(--bs-btn-border-color);border-radius:var(--bs-btn-border-radius);background-color:var(--bs-btn-bg);transition:color .15s ease-in-out,background-color .15s ease-in-out,border-color .15s ease-in-out,box-shadow .15s ease-in-out}@media (prefers-reduced-motion: reduce){.btn{transition:none}}.btn:hover{color:var(--bs-btn-hover-color);background-color:var(--bs-btn-hover-bg);border-color:var(--bs-btn-hover-border-color)}.btn-check+.btn:hover{color:var(--bs-btn-color);background-color:var(--bs-btn-bg);border-color:var(--bs-btn-border-color)}.btn:focus-visible{color:var(--bs-btn-hover-color);background-color:var(--bs-btn-hover-bg);border-color:var(--bs-btn-hover-border-color);outline:0;box-shadow:var(--bs-btn-focus-box-shadow)}.btn-check:focus-visible+.btn{border-color:var(--bs-btn-hover-border-color);outline:0;box-shadow:var(--bs-btn-focus-box-shadow)}.btn-check:checked+.btn,:not(.btn-check)+.btn:active,.btn:first-child:active,.btn.active,.btn.show{color:var(--bs-btn-active-color);background-color:var(--bs-btn-active-bg);border-color:var(--bs-btn-active-border-color)}.btn-check:checked+.btn:focus-visible,:not(.btn-check)+.btn:active:focus-visible,.btn:first-child:active:focus-visible,.btn.active:focus-visible,.btn.show:focus-visible{box-shadow:var(--bs-btn-focus-box-shadow)}.btn-check:checked:focus-visible+.btn{box-shadow:var(--bs-btn-focus-box-shadow)}.btn:disabled,.btn.disabled,fieldset:disabled .btn{color:var(--bs-btn-disabled-color);pointer-events:none;background-color:var(--bs-btn-disabled-bg);border-color:var(--bs-btn-disabled-border-color);opacity:var(--bs-btn-disabled-opacity)}.btn-primary{--bs-btn-color: #fff;--bs-btn-bg: #0d6efd;--bs-btn-border-color: #0d6efd;--bs-btn-hover-color: #fff;--bs-btn-hover-bg: rgb(11.05, 93.5, 215.05);--bs-btn-hover-border-color: rgb(10.4, 88, 202.4);--bs-btn-focus-shadow-rgb: 49, 132, 253;--bs-btn-active-color: #fff;--bs-btn-active-bg: rgb(10.4, 88, 202.4);--bs-btn-active-border-color: rgb(9.75, 82.5, 189.75);--bs-btn-active-shadow: inset 0 3px 5px rgba(0, 0, 0, .125);--bs-btn-disabled-color: #fff;--bs-btn-disabled-bg: #0d6efd;--bs-btn-disabled-border-color: #0d6efd}.btn-secondary{--bs-btn-color: #fff;--bs-btn-bg: #6c757d;--bs-btn-border-color: #6c757d;--bs-btn-hover-color: #fff;--bs-btn-hover-bg: rgb(91.8, 99.45, 106.25);--bs-btn-hover-border-color: rgb(86.4, 93.6, 100);--bs-btn-focus-shadow-rgb: 130, 138, 145;--bs-btn-active-color: #fff;--bs-btn-active-bg: rgb(86.4, 93.6, 100);--bs-btn-active-border-color: rgb(81, 87.75, 93.75);--bs-btn-active-shadow: inset 0 3px 5px rgba(0, 0, 0, .125);--bs-btn-disabled-color: #fff;--bs-btn-disabled-bg: #6c757d;--bs-btn-disabled-border-color: #6c757d}.btn-success{--bs-btn-color: #fff;--bs-btn-bg: #198754;--bs-btn-border-color: #198754;--bs-btn-hover-color: #fff;--bs-btn-hover-bg: rgb(21.25, 114.75, 71.4);--bs-btn-hover-border-color: rgb(20, 108, 67.2);--bs-btn-focus-shadow-rgb: 60, 153, 110;--bs-btn-active-color: #fff;--bs-btn-active-bg: rgb(20, 108, 67.2);--bs-btn-active-border-color: rgb(18.75, 101.25, 63);--bs-btn-active-shadow: inset 0 3px 5px rgba(0, 0, 0, .125);--bs-btn-disabled-color: #fff;--bs-btn-disabled-bg: #198754;--bs-btn-disabled-border-color: #198754}.btn-info{--bs-btn-color: #000;--bs-btn-bg: #0dcaf0;--bs-btn-border-color: #0dcaf0;--bs-btn-hover-color: #000;--bs-btn-hover-bg: rgb(49.3, 209.95, 242.25);--bs-btn-hover-border-color: rgb(37.2, 207.3, 241.5);--bs-btn-focus-shadow-rgb: 11, 172, 204;--bs-btn-active-color: #000;--bs-btn-active-bg: rgb(61.4, 212.6, 243);--bs-btn-active-border-color: rgb(37.2, 207.3, 241.5);--bs-btn-active-shadow: inset 0 3px 5px rgba(0, 0, 0, .125);--bs-btn-disabled-color: #000;--bs-btn-disabled-bg: #0dcaf0;--bs-btn-disabled-border-color: #0dcaf0}.btn-warning{--bs-btn-color: #000;--bs-btn-bg: #ffc107;--bs-btn-border-color: #ffc107;--bs-btn-hover-color: #000;--bs-btn-hover-bg: rgb(255, 202.3, 44.2);--bs-btn-hover-border-color: rgb(255, 199.2, 31.8);--bs-btn-focus-shadow-rgb: 217, 164, 6;--bs-btn-active-color: #000;--bs-btn-active-bg: rgb(255, 205.4, 56.6);--bs-btn-active-border-color: rgb(255, 199.2, 31.8);--bs-btn-active-shadow: inset 0 3px 5px rgba(0, 0, 0, .125);--bs-btn-disabled-color: #000;--bs-btn-disabled-bg: #ffc107;--bs-btn-disabled-border-color: #ffc107}.btn-danger{--bs-btn-color: #fff;--bs-btn-bg: #dc3545;--bs-btn-border-color: #dc3545;--bs-btn-hover-color: #fff;--bs-btn-hover-bg: rgb(187, 45.05, 58.65);--bs-btn-hover-border-color: rgb(176, 42.4, 55.2);--bs-btn-focus-shadow-rgb: 225, 83, 97;--bs-btn-active-color: #fff;--bs-btn-active-bg: rgb(176, 42.4, 55.2);--bs-btn-active-border-color: rgb(165, 39.75, 51.75);--bs-btn-active-shadow: inset 0 3px 5px rgba(0, 0, 0, .125);--bs-btn-disabled-color: #fff;--bs-btn-disabled-bg: #dc3545;--bs-btn-disabled-border-color: #dc3545}.btn-light{--bs-btn-color: #000;--bs-btn-bg: #f8f9fa;--bs-btn-border-color: #f8f9fa;--bs-btn-hover-color: #000;--bs-btn-hover-bg: rgb(210.8, 211.65, 212.5);--bs-btn-hover-border-color: rgb(198.4, 199.2, 200);--bs-btn-focus-shadow-rgb: 211, 212, 213;--bs-btn-active-color: #000;--bs-btn-active-bg: rgb(198.4, 199.2, 200);--bs-btn-active-border-color: rgb(186, 186.75, 187.5);--bs-btn-active-shadow: inset 0 3px 5px rgba(0, 0, 0, .125);--bs-btn-disabled-color: #000;--bs-btn-disabled-bg: #f8f9fa;--bs-btn-disabled-border-color: #f8f9fa}.btn-dark{--bs-btn-color: #fff;--bs-btn-bg: #212529;--bs-btn-border-color: #212529;--bs-btn-hover-color: #fff;--bs-btn-hover-bg: rgb(66.3, 69.7, 73.1);--bs-btn-hover-border-color: rgb(55.2, 58.8, 62.4);--bs-btn-focus-shadow-rgb: 66, 70, 73;--bs-btn-active-color: #fff;--bs-btn-active-bg: rgb(77.4, 80.6, 83.8);--bs-btn-active-border-color: rgb(55.2, 58.8, 62.4);--bs-btn-active-shadow: inset 0 3px 5px rgba(0, 0, 0, .125);--bs-btn-disabled-color: #fff;--bs-btn-disabled-bg: #212529;--bs-btn-disabled-border-color: #212529}.btn-outline-primary{--bs-btn-color: #0d6efd;--bs-btn-border-color: #0d6efd;--bs-btn-hover-color: #fff;--bs-btn-hover-bg: #0d6efd;--bs-btn-hover-border-color: #0d6efd;--bs-btn-focus-shadow-rgb: 13, 110, 253;--bs-btn-active-color: #fff;--bs-btn-active-bg: #0d6efd;--bs-btn-active-border-color: #0d6efd;--bs-btn-active-shadow: inset 0 3px 5px rgba(0, 0, 0, .125);--bs-btn-disabled-color: #0d6efd;--bs-btn-disabled-bg: transparent;--bs-btn-disabled-border-color: #0d6efd;--bs-gradient: none}.btn-outline-secondary{--bs-btn-color: #6c757d;--bs-btn-border-color: #6c757d;--bs-btn-hover-color: #fff;--bs-btn-hover-bg: #6c757d;--bs-btn-hover-border-color: #6c757d;--bs-btn-focus-shadow-rgb: 108, 117, 125;--bs-btn-active-color: #fff;--bs-btn-active-bg: #6c757d;--bs-btn-active-border-color: #6c757d;--bs-btn-active-shadow: inset 0 3px 5px rgba(0, 0, 0, .125);--bs-btn-disabled-color: #6c757d;--bs-btn-disabled-bg: transparent;--bs-btn-disabled-border-color: #6c757d;--bs-gradient: none}.btn-outline-success{--bs-btn-color: #198754;--bs-btn-border-color: #198754;--bs-btn-hover-color: #fff;--bs-btn-hover-bg: #198754;--bs-btn-hover-border-color: #198754;--bs-btn-focus-shadow-rgb: 25, 135, 84;--bs-btn-active-color: #fff;--bs-btn-active-bg: #198754;--bs-btn-active-border-color: #198754;--bs-btn-active-shadow: inset 0 3px 5px rgba(0, 0, 0, .125);--bs-btn-disabled-color: #198754;--bs-btn-disabled-bg: transparent;--bs-btn-disabled-border-color: #198754;--bs-gradient: none}.btn-outline-info{--bs-btn-color: #0dcaf0;--bs-btn-border-color: #0dcaf0;--bs-btn-hover-color: #000;--bs-btn-hover-bg: #0dcaf0;--bs-btn-hover-border-color: #0dcaf0;--bs-btn-focus-shadow-rgb: 13, 202, 240;--bs-btn-active-color: #000;--bs-btn-active-bg: #0dcaf0;--bs-btn-active-border-color: #0dcaf0;--bs-btn-active-shadow: inset 0 3px 5px rgba(0, 0, 0, .125);--bs-btn-disabled-color: #0dcaf0;--bs-btn-disabled-bg: transparent;--bs-btn-disabled-border-color: #0dcaf0;--bs-gradient: none}.btn-outline-warning{--bs-btn-color: #ffc107;--bs-btn-border-color: #ffc107;--bs-btn-hover-color: #000;--bs-btn-hover-bg: #ffc107;--bs-btn-hover-border-color: #ffc107;--bs-btn-focus-shadow-rgb: 255, 193, 7;--bs-btn-active-color: #000;--bs-btn-active-bg: #ffc107;--bs-btn-active-border-color: #ffc107;--bs-btn-active-shadow: inset 0 3px 5px rgba(0, 0, 0, .125);--bs-btn-disabled-color: #ffc107;--bs-btn-disabled-bg: transparent;--bs-btn-disabled-border-color: #ffc107;--bs-gradient: none}.btn-outline-danger{--bs-btn-color: #dc3545;--bs-btn-border-color: #dc3545;--bs-btn-hover-color: #fff;--bs-btn-hover-bg: #dc3545;--bs-btn-hover-border-color: #dc3545;--bs-btn-focus-shadow-rgb: 220, 53, 69;--bs-btn-active-color: #fff;--bs-btn-active-bg: #dc3545;--bs-btn-active-border-color: #dc3545;--bs-btn-active-shadow: inset 0 3px 5px rgba(0, 0, 0, .125);--bs-btn-disabled-color: #dc3545;--bs-btn-disabled-bg: transparent;--bs-btn-disabled-border-color: #dc3545;--bs-gradient: none}.btn-outline-light{--bs-btn-color: #f8f9fa;--bs-btn-border-color: #f8f9fa;--bs-btn-hover-color: #000;--bs-btn-hover-bg: #f8f9fa;--bs-btn-hover-border-color: #f8f9fa;--bs-btn-focus-shadow-rgb: 248, 249, 250;--bs-btn-active-color: #000;--bs-btn-active-bg: #f8f9fa;--bs-btn-active-border-color: #f8f9fa;--bs-btn-active-shadow: inset 0 3px 5px rgba(0, 0, 0, .125);--bs-btn-disabled-color: #f8f9fa;--bs-btn-disabled-bg: transparent;--bs-btn-disabled-border-color: #f8f9fa;--bs-gradient: none}.btn-outline-dark{--bs-btn-color: #212529;--bs-btn-border-color: #212529;--bs-btn-hover-color: #fff;--bs-btn-hover-bg: #212529;--bs-btn-hover-border-color: #212529;--bs-btn-focus-shadow-rgb: 33, 37, 41;--bs-btn-active-color: #fff;--bs-btn-active-bg: #212529;--bs-btn-active-border-color: #212529;--bs-btn-active-shadow: inset 0 3px 5px rgba(0, 0, 0, .125);--bs-btn-disabled-color: #212529;--bs-btn-disabled-bg: transparent;--bs-btn-disabled-border-color: #212529;--bs-gradient: none}.btn-link{--bs-btn-font-weight: 400;--bs-btn-color: var(--bs-link-color);--bs-btn-bg: transparent;--bs-btn-border-color: transparent;--bs-btn-hover-color: var(--bs-link-hover-color);--bs-btn-hover-border-color: transparent;--bs-btn-active-color: var(--bs-link-hover-color);--bs-btn-active-border-color: transparent;--bs-btn-disabled-color: #6c757d;--bs-btn-disabled-border-color: transparent;--bs-btn-box-shadow: 0 0 0 #000;--bs-btn-focus-shadow-rgb: 49, 132, 253;text-decoration:underline}.btn-link:focus-visible{color:var(--bs-btn-color)}.btn-link:hover{color:var(--bs-btn-hover-color)}.btn-lg,.btn-group-lg>.btn{--bs-btn-padding-y: .5rem;--bs-btn-padding-x: 1rem;--bs-btn-font-size: 1.25rem;--bs-btn-border-radius: var(--bs-border-radius-lg)}.btn-sm,.btn-group-sm>.btn{--bs-btn-padding-y: .25rem;--bs-btn-padding-x: .5rem;--bs-btn-font-size: .875rem;--bs-btn-border-radius: var(--bs-border-radius-sm)}.fade{transition:opacity .15s linear}@media (prefers-reduced-motion: reduce){.fade{transition:none}}.fade:not(.show){opacity:0}.collapse:not(.show){display:none}.collapsing{height:0;overflow:hidden;transition:height .35s ease}@media (prefers-reduced-motion: reduce){.collapsing{transition:none}}.collapsing.collapse-horizontal{width:0;height:auto;transition:width .35s ease}@media (prefers-reduced-motion: reduce){.collapsing.collapse-horizontal{transition:none}}.dropup,.dropend,.dropdown,.dropstart,.dropup-center,.dropdown-center{position:relative}.dropdown-toggle{white-space:nowrap}.dropdown-toggle:after{display:inline-block;margin-left:.255em;vertical-align:.255em;content:"";border-top:.3em solid;border-right:.3em solid transparent;border-bottom:0;border-left:.3em solid transparent}.dropdown-toggle:empty:after{margin-left:0}.dropdown-menu{--bs-dropdown-zindex: 1000;--bs-dropdown-min-width: 10rem;--bs-dropdown-padding-x: 0;--bs-dropdown-padding-y: .5rem;--bs-dropdown-spacer: .125rem;--bs-dropdown-font-size: 1rem;--bs-dropdown-color: var(--bs-body-color);--bs-dropdown-bg: var(--bs-body-bg);--bs-dropdown-border-color: var(--bs-border-color-translucent);--bs-dropdown-border-radius: var(--bs-border-radius);--bs-dropdown-border-width: var(--bs-border-width);--bs-dropdown-inner-border-radius: calc(var(--bs-border-radius) - var(--bs-border-width));--bs-dropdown-divider-bg: var(--bs-border-color-translucent);--bs-dropdown-divider-margin-y: .5rem;--bs-dropdown-box-shadow: var(--bs-box-shadow);--bs-dropdown-link-color: var(--bs-body-color);--bs-dropdown-link-hover-color: var(--bs-body-color);--bs-dropdown-link-hover-bg: var(--bs-tertiary-bg);--bs-dropdown-link-active-color: #fff;--bs-dropdown-link-active-bg: #0d6efd;--bs-dropdown-link-disabled-color: var(--bs-tertiary-color);--bs-dropdown-item-padding-x: 1rem;--bs-dropdown-item-padding-y: .25rem;--bs-dropdown-header-color: #6c757d;--bs-dropdown-header-padding-x: 1rem;--bs-dropdown-header-padding-y: .5rem;position:absolute;z-index:var(--bs-dropdown-zindex);display:none;min-width:var(--bs-dropdown-min-width);padding:var(--bs-dropdown-padding-y) var(--bs-dropdown-padding-x);margin:0;font-size:var(--bs-dropdown-font-size);color:var(--bs-dropdown-color);text-align:left;list-style:none;background-color:var(--bs-dropdown-bg);background-clip:padding-box;border:var(--bs-dropdown-border-width) solid var(--bs-dropdown-border-color);border-radius:var(--bs-dropdown-border-radius)}.dropdown-menu[data-bs-popper]{top:100%;left:0;margin-top:var(--bs-dropdown-spacer)}.dropdown-menu-start{--bs-position: start}.dropdown-menu-start[data-bs-popper]{right:auto;left:0}.dropdown-menu-end{--bs-position: end}.dropdown-menu-end[data-bs-popper]{right:0;left:auto}@media (min-width: 576px){.dropdown-menu-sm-start{--bs-position: start}.dropdown-menu-sm-start[data-bs-popper]{right:auto;left:0}.dropdown-menu-sm-end{--bs-position: end}.dropdown-menu-sm-end[data-bs-popper]{right:0;left:auto}}@media (min-width: 768px){.dropdown-menu-md-start{--bs-position: start}.dropdown-menu-md-start[data-bs-popper]{right:auto;left:0}.dropdown-menu-md-end{--bs-position: end}.dropdown-menu-md-end[data-bs-popper]{right:0;left:auto}}@media (min-width: 992px){.dropdown-menu-lg-start{--bs-position: start}.dropdown-menu-lg-start[data-bs-popper]{right:auto;left:0}.dropdown-menu-lg-end{--bs-position: end}.dropdown-menu-lg-end[data-bs-popper]{right:0;left:auto}}@media (min-width: 1200px){.dropdown-menu-xl-start{--bs-position: start}.dropdown-menu-xl-start[data-bs-popper]{right:auto;left:0}.dropdown-menu-xl-end{--bs-position: end}.dropdown-menu-xl-end[data-bs-popper]{right:0;left:auto}}@media (min-width: 1400px){.dropdown-menu-xxl-start{--bs-position: start}.dropdown-menu-xxl-start[data-bs-popper]{right:auto;left:0}.dropdown-menu-xxl-end{--bs-position: end}.dropdown-menu-xxl-end[data-bs-popper]{right:0;left:auto}}.dropup .dropdown-menu[data-bs-popper]{top:auto;bottom:100%;margin-top:0;margin-bottom:var(--bs-dropdown-spacer)}.dropup .dropdown-toggle:after{display:inline-block;margin-left:.255em;vertical-align:.255em;content:"";border-top:0;border-right:.3em solid transparent;border-bottom:.3em solid;border-left:.3em solid transparent}.dropup .dropdown-toggle:empty:after{margin-left:0}.dropend .dropdown-menu[data-bs-popper]{top:0;right:auto;left:100%;margin-top:0;margin-left:var(--bs-dropdown-spacer)}.dropend .dropdown-toggle:after{display:inline-block;margin-left:.255em;vertical-align:.255em;content:"";border-top:.3em solid transparent;border-right:0;border-bottom:.3em solid transparent;border-left:.3em solid}.dropend .dropdown-toggle:empty:after{margin-left:0}.dropend .dropdown-toggle:after{vertical-align:0}.dropstart .dropdown-menu[data-bs-popper]{top:0;right:100%;left:auto;margin-top:0;margin-right:var(--bs-dropdown-spacer)}.dropstart .dropdown-toggle:after{display:inline-block;margin-left:.255em;vertical-align:.255em;content:""}.dropstart .dropdown-toggle:after{display:none}.dropstart .dropdown-toggle:before{display:inline-block;margin-right:.255em;vertical-align:.255em;content:"";border-top:.3em solid transparent;border-right:.3em solid;border-bottom:.3em solid transparent}.dropstart .dropdown-toggle:empty:after{margin-left:0}.dropstart .dropdown-toggle:before{vertical-align:0}.dropdown-divider{height:0;margin:var(--bs-dropdown-divider-margin-y) 0;overflow:hidden;border-top:1px solid var(--bs-dropdown-divider-bg);opacity:1}.dropdown-item{display:block;width:100%;padding:var(--bs-dropdown-item-padding-y) var(--bs-dropdown-item-padding-x);clear:both;font-weight:400;color:var(--bs-dropdown-link-color);text-align:inherit;text-decoration:none;white-space:nowrap;background-color:transparent;border:0;border-radius:var(--bs-dropdown-item-border-radius, 0)}.dropdown-item:hover,.dropdown-item:focus{color:var(--bs-dropdown-link-hover-color);background-color:var(--bs-dropdown-link-hover-bg)}.dropdown-item.active,.dropdown-item:active{color:var(--bs-dropdown-link-active-color);text-decoration:none;background-color:var(--bs-dropdown-link-active-bg)}.dropdown-item.disabled,.dropdown-item:disabled{color:var(--bs-dropdown-link-disabled-color);pointer-events:none;background-color:transparent}.dropdown-menu.show{display:block}.dropdown-header{display:block;padding:var(--bs-dropdown-header-padding-y) var(--bs-dropdown-header-padding-x);margin-bottom:0;font-size:.875rem;color:var(--bs-dropdown-header-color);white-space:nowrap}.dropdown-item-text{display:block;padding:var(--bs-dropdown-item-padding-y) var(--bs-dropdown-item-padding-x);color:var(--bs-dropdown-link-color)}.dropdown-menu-dark{--bs-dropdown-color: #dee2e6;--bs-dropdown-bg: #343a40;--bs-dropdown-border-color: var(--bs-border-color-translucent);--bs-dropdown-box-shadow: ;--bs-dropdown-link-color: #dee2e6;--bs-dropdown-link-hover-color: #fff;--bs-dropdown-divider-bg: var(--bs-border-color-translucent);--bs-dropdown-link-hover-bg: rgba(255, 255, 255, .15);--bs-dropdown-link-active-color: #fff;--bs-dropdown-link-active-bg: #0d6efd;--bs-dropdown-link-disabled-color: #adb5bd;--bs-dropdown-header-color: #adb5bd}.btn-group,.btn-group-vertical{position:relative;display:inline-flex;vertical-align:middle}.btn-group>.btn,.btn-group-vertical>.btn{position:relative;flex:1 1 auto}.btn-group>.btn-check:checked+.btn,.btn-group>.btn-check:focus+.btn,.btn-group>.btn:hover,.btn-group>.btn:focus,.btn-group>.btn:active,.btn-group>.btn.active,.btn-group-vertical>.btn-check:checked+.btn,.btn-group-vertical>.btn-check:focus+.btn,.btn-group-vertical>.btn:hover,.btn-group-vertical>.btn:focus,.btn-group-vertical>.btn:active,.btn-group-vertical>.btn.active{z-index:1}.btn-toolbar{display:flex;flex-wrap:wrap;justify-content:flex-start}.btn-toolbar .input-group{width:auto}.btn-group{border-radius:var(--bs-border-radius)}.btn-group>:not(.btn-check:first-child)+.btn,.btn-group>.btn-group:not(:first-child){margin-left:calc(-1 * var(--bs-border-width))}.btn-group>.btn:not(:last-child):not(.dropdown-toggle),.btn-group>.btn.dropdown-toggle-split:first-child,.btn-group>.btn-group:not(:last-child)>.btn{border-top-right-radius:0;border-bottom-right-radius:0}.btn-group>.btn:nth-child(n+3),.btn-group>:not(.btn-check)+.btn,.btn-group>.btn-group:not(:first-child)>.btn{border-top-left-radius:0;border-bottom-left-radius:0}.dropdown-toggle-split{padding-right:.5625rem;padding-left:.5625rem}.dropdown-toggle-split:after,.dropup .dropdown-toggle-split:after,.dropend .dropdown-toggle-split:after{margin-left:0}.dropstart .dropdown-toggle-split:before{margin-right:0}.btn-sm+.dropdown-toggle-split,.btn-group-sm>.btn+.dropdown-toggle-split{padding-right:.375rem;padding-left:.375rem}.btn-lg+.dropdown-toggle-split,.btn-group-lg>.btn+.dropdown-toggle-split{padding-right:.75rem;padding-left:.75rem}.btn-group-vertical{flex-direction:column;align-items:flex-start;justify-content:center}.btn-group-vertical>.btn,.btn-group-vertical>.btn-group{width:100%}.btn-group-vertical>.btn:not(:first-child),.btn-group-vertical>.btn-group:not(:first-child){margin-top:calc(-1 * var(--bs-border-width))}.btn-group-vertical>.btn:not(:last-child):not(.dropdown-toggle),.btn-group-vertical>.btn-group:not(:last-child)>.btn{border-bottom-right-radius:0;border-bottom-left-radius:0}.btn-group-vertical>.btn:nth-child(n+3),.btn-group-vertical>:not(.btn-check)+.btn,.btn-group-vertical>.btn-group:not(:first-child)>.btn{border-top-left-radius:0;border-top-right-radius:0}.nav{--bs-nav-link-padding-x: 1rem;--bs-nav-link-padding-y: .5rem;--bs-nav-link-font-weight: ;--bs-nav-link-color: var(--bs-link-color);--bs-nav-link-hover-color: var(--bs-link-hover-color);--bs-nav-link-disabled-color: var(--bs-secondary-color);display:flex;flex-wrap:wrap;padding-left:0;margin-bottom:0;list-style:none}.nav-link{display:block;padding:var(--bs-nav-link-padding-y) var(--bs-nav-link-padding-x);font-size:var(--bs-nav-link-font-size);font-weight:var(--bs-nav-link-font-weight);color:var(--bs-nav-link-color);text-decoration:none;background:none;border:0;transition:color .15s ease-in-out,background-color .15s ease-in-out,border-color .15s ease-in-out}@media (prefers-reduced-motion: reduce){.nav-link{transition:none}}.nav-link:hover,.nav-link:focus{color:var(--bs-nav-link-hover-color)}.nav-link:focus-visible{outline:0;box-shadow:0 0 0 .25rem #0d6efd40}.nav-link.disabled,.nav-link:disabled{color:var(--bs-nav-link-disabled-color);pointer-events:none;cursor:default}.nav-tabs{--bs-nav-tabs-border-width: var(--bs-border-width);--bs-nav-tabs-border-color: var(--bs-border-color);--bs-nav-tabs-border-radius: var(--bs-border-radius);--bs-nav-tabs-link-hover-border-color: var(--bs-secondary-bg) var(--bs-secondary-bg) var(--bs-border-color);--bs-nav-tabs-link-active-color: var(--bs-emphasis-color);--bs-nav-tabs-link-active-bg: var(--bs-body-bg);--bs-nav-tabs-link-active-border-color: var(--bs-border-color) var(--bs-border-color) var(--bs-body-bg);border-bottom:var(--bs-nav-tabs-border-width) solid var(--bs-nav-tabs-border-color)}.nav-tabs .nav-link{margin-bottom:calc(-1 * var(--bs-nav-tabs-border-width));border:var(--bs-nav-tabs-border-width) solid transparent;border-top-left-radius:var(--bs-nav-tabs-border-radius);border-top-right-radius:var(--bs-nav-tabs-border-radius)}.nav-tabs .nav-link:hover,.nav-tabs .nav-link:focus{isolation:isolate;border-color:var(--bs-nav-tabs-link-hover-border-color)}.nav-tabs .nav-link.active,.nav-tabs .nav-item.show .nav-link{color:var(--bs-nav-tabs-link-active-color);background-color:var(--bs-nav-tabs-link-active-bg);border-color:var(--bs-nav-tabs-link-active-border-color)}.nav-tabs .dropdown-menu{margin-top:calc(-1 * var(--bs-nav-tabs-border-width));border-top-left-radius:0;border-top-right-radius:0}.nav-pills{--bs-nav-pills-border-radius: var(--bs-border-radius);--bs-nav-pills-link-active-color: #fff;--bs-nav-pills-link-active-bg: #0d6efd}.nav-pills .nav-link{border-radius:var(--bs-nav-pills-border-radius)}.nav-pills .nav-link.active,.nav-pills .show>.nav-link{color:var(--bs-nav-pills-link-active-color);background-color:var(--bs-nav-pills-link-active-bg)}.nav-underline{--bs-nav-underline-gap: 1rem;--bs-nav-underline-border-width: .125rem;--bs-nav-underline-link-active-color: var(--bs-emphasis-color);gap:var(--bs-nav-underline-gap)}.nav-underline .nav-link{padding-right:0;padding-left:0;border-bottom:var(--bs-nav-underline-border-width) solid transparent}.nav-underline .nav-link:hover,.nav-underline .nav-link:focus{border-bottom-color:currentcolor}.nav-underline .nav-link.active,.nav-underline .show>.nav-link{font-weight:700;color:var(--bs-nav-underline-link-active-color);border-bottom-color:currentcolor}.nav-fill>.nav-link,.nav-fill .nav-item{flex:1 1 auto;text-align:center}.nav-justified>.nav-link,.nav-justified .nav-item{flex-grow:1;flex-basis:0;text-align:center}.nav-fill .nav-item .nav-link,.nav-justified .nav-item .nav-link{width:100%}.tab-content>.tab-pane{display:none}.tab-content>.active{display:block}.navbar{--bs-navbar-padding-x: 0;--bs-navbar-padding-y: .5rem;--bs-navbar-color: rgba(var(--bs-emphasis-color-rgb), .65);--bs-navbar-hover-color: rgba(var(--bs-emphasis-color-rgb), .8);--bs-navbar-disabled-color: rgba(var(--bs-emphasis-color-rgb), .3);--bs-navbar-active-color: rgba(var(--bs-emphasis-color-rgb), 1);--bs-navbar-brand-padding-y: .3125rem;--bs-navbar-brand-margin-end: 1rem;--bs-navbar-brand-font-size: 1.25rem;--bs-navbar-brand-color: rgba(var(--bs-emphasis-color-rgb), 1);--bs-navbar-brand-hover-color: rgba(var(--bs-emphasis-color-rgb), 1);--bs-navbar-nav-link-padding-x: .5rem;--bs-navbar-toggler-padding-y: .25rem;--bs-navbar-toggler-padding-x: .75rem;--bs-navbar-toggler-font-size: 1.25rem;--bs-navbar-toggler-icon-bg: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 30 30'%3e%3cpath stroke='rgba%2833, 37, 41, 0.75%29' stroke-linecap='round' stroke-miterlimit='10' stroke-width='2' d='M4 7h22M4 15h22M4 23h22'/%3e%3c/svg%3e");--bs-navbar-toggler-border-color: rgba(var(--bs-emphasis-color-rgb), .15);--bs-navbar-toggler-border-radius: var(--bs-border-radius);--bs-navbar-toggler-focus-width: .25rem;--bs-navbar-toggler-transition: box-shadow .15s ease-in-out;position:relative;display:flex;flex-wrap:wrap;align-items:center;justify-content:space-between;padding:var(--bs-navbar-padding-y) var(--bs-navbar-padding-x)}.navbar>.container,.navbar>.container-fluid,.navbar>.container-sm,.navbar>.container-md,.navbar>.container-lg,.navbar>.container-xl,.navbar>.container-xxl{display:flex;flex-wrap:inherit;align-items:center;justify-content:space-between}.navbar-brand{padding-top:var(--bs-navbar-brand-padding-y);padding-bottom:var(--bs-navbar-brand-padding-y);margin-right:var(--bs-navbar-brand-margin-end);font-size:var(--bs-navbar-brand-font-size);color:var(--bs-navbar-brand-color);text-decoration:none;white-space:nowrap}.navbar-brand:hover,.navbar-brand:focus{color:var(--bs-navbar-brand-hover-color)}.navbar-nav{--bs-nav-link-padding-x: 0;--bs-nav-link-padding-y: .5rem;--bs-nav-link-font-weight: ;--bs-nav-link-color: var(--bs-navbar-color);--bs-nav-link-hover-color: var(--bs-navbar-hover-color);--bs-nav-link-disabled-color: var(--bs-navbar-disabled-color);display:flex;flex-direction:column;padding-left:0;margin-bottom:0;list-style:none}.navbar-nav .nav-link.active,.navbar-nav .nav-link.show{color:var(--bs-navbar-active-color)}.navbar-nav .dropdown-menu{position:static}.navbar-text{padding-top:.5rem;padding-bottom:.5rem;color:var(--bs-navbar-color)}.navbar-text a,.navbar-text a:hover,.navbar-text a:focus{color:var(--bs-navbar-active-color)}.navbar-collapse{flex-grow:1;flex-basis:100%;align-items:center}.navbar-toggler{padding:var(--bs-navbar-toggler-padding-y) var(--bs-navbar-toggler-padding-x);font-size:var(--bs-navbar-toggler-font-size);line-height:1;color:var(--bs-navbar-color);background-color:transparent;border:var(--bs-border-width) solid var(--bs-navbar-toggler-border-color);border-radius:var(--bs-navbar-toggler-border-radius);transition:var(--bs-navbar-toggler-transition)}@media (prefers-reduced-motion: reduce){.navbar-toggler{transition:none}}.navbar-toggler:hover{text-decoration:none}.navbar-toggler:focus{text-decoration:none;outline:0;box-shadow:0 0 0 var(--bs-navbar-toggler-focus-width)}.navbar-toggler-icon{display:inline-block;width:1.5em;height:1.5em;vertical-align:middle;background-image:var(--bs-navbar-toggler-icon-bg);background-repeat:no-repeat;background-position:center;background-size:100%}.navbar-nav-scroll{max-height:var(--bs-scroll-height, 75vh);overflow-y:auto}@media (min-width: 576px){.navbar-expand-sm{flex-wrap:nowrap;justify-content:flex-start}.navbar-expand-sm .navbar-nav{flex-direction:row}.navbar-expand-sm .navbar-nav .dropdown-menu{position:absolute}.navbar-expand-sm .navbar-nav .nav-link{padding-right:var(--bs-navbar-nav-link-padding-x);padding-left:var(--bs-navbar-nav-link-padding-x)}.navbar-expand-sm .navbar-nav-scroll{overflow:visible}.navbar-expand-sm .navbar-collapse{display:flex!important;flex-basis:auto}.navbar-expand-sm .navbar-toggler{display:none}.navbar-expand-sm .offcanvas{position:static;z-index:auto;flex-grow:1;width:auto!important;height:auto!important;visibility:visible!important;background-color:transparent!important;border:0!important;transform:none!important;transition:none}.navbar-expand-sm .offcanvas .offcanvas-header{display:none}.navbar-expand-sm .offcanvas .offcanvas-body{display:flex;flex-grow:0;padding:0;overflow-y:visible}}@media (min-width: 768px){.navbar-expand-md{flex-wrap:nowrap;justify-content:flex-start}.navbar-expand-md .navbar-nav{flex-direction:row}.navbar-expand-md .navbar-nav .dropdown-menu{position:absolute}.navbar-expand-md .navbar-nav .nav-link{padding-right:var(--bs-navbar-nav-link-padding-x);padding-left:var(--bs-navbar-nav-link-padding-x)}.navbar-expand-md .navbar-nav-scroll{overflow:visible}.navbar-expand-md .navbar-collapse{display:flex!important;flex-basis:auto}.navbar-expand-md .navbar-toggler{display:none}.navbar-expand-md .offcanvas{position:static;z-index:auto;flex-grow:1;width:auto!important;height:auto!important;visibility:visible!important;background-color:transparent!important;border:0!important;transform:none!important;transition:none}.navbar-expand-md .offcanvas .offcanvas-header{display:none}.navbar-expand-md .offcanvas .offcanvas-body{display:flex;flex-grow:0;padding:0;overflow-y:visible}}@media (min-width: 992px){.navbar-expand-lg{flex-wrap:nowrap;justify-content:flex-start}.navbar-expand-lg .navbar-nav{flex-direction:row}.navbar-expand-lg .navbar-nav .dropdown-menu{position:absolute}.navbar-expand-lg .navbar-nav .nav-link{padding-right:var(--bs-navbar-nav-link-padding-x);padding-left:var(--bs-navbar-nav-link-padding-x)}.navbar-expand-lg .navbar-nav-scroll{overflow:visible}.navbar-expand-lg .navbar-collapse{display:flex!important;flex-basis:auto}.navbar-expand-lg .navbar-toggler{display:none}.navbar-expand-lg .offcanvas{position:static;z-index:auto;flex-grow:1;width:auto!important;height:auto!important;visibility:visible!important;background-color:transparent!important;border:0!important;transform:none!important;transition:none}.navbar-expand-lg .offcanvas .offcanvas-header{display:none}.navbar-expand-lg .offcanvas .offcanvas-body{display:flex;flex-grow:0;padding:0;overflow-y:visible}}@media (min-width: 1200px){.navbar-expand-xl{flex-wrap:nowrap;justify-content:flex-start}.navbar-expand-xl .navbar-nav{flex-direction:row}.navbar-expand-xl .navbar-nav .dropdown-menu{position:absolute}.navbar-expand-xl .navbar-nav .nav-link{padding-right:var(--bs-navbar-nav-link-padding-x);padding-left:var(--bs-navbar-nav-link-padding-x)}.navbar-expand-xl .navbar-nav-scroll{overflow:visible}.navbar-expand-xl .navbar-collapse{display:flex!important;flex-basis:auto}.navbar-expand-xl .navbar-toggler{display:none}.navbar-expand-xl .offcanvas{position:static;z-index:auto;flex-grow:1;width:auto!important;height:auto!important;visibility:visible!important;background-color:transparent!important;border:0!important;transform:none!important;transition:none}.navbar-expand-xl .offcanvas .offcanvas-header{display:none}.navbar-expand-xl .offcanvas .offcanvas-body{display:flex;flex-grow:0;padding:0;overflow-y:visible}}@media (min-width: 1400px){.navbar-expand-xxl{flex-wrap:nowrap;justify-content:flex-start}.navbar-expand-xxl .navbar-nav{flex-direction:row}.navbar-expand-xxl .navbar-nav .dropdown-menu{position:absolute}.navbar-expand-xxl .navbar-nav .nav-link{padding-right:var(--bs-navbar-nav-link-padding-x);padding-left:var(--bs-navbar-nav-link-padding-x)}.navbar-expand-xxl .navbar-nav-scroll{overflow:visible}.navbar-expand-xxl .navbar-collapse{display:flex!important;flex-basis:auto}.navbar-expand-xxl .navbar-toggler{display:none}.navbar-expand-xxl .offcanvas{position:static;z-index:auto;flex-grow:1;width:auto!important;height:auto!important;visibility:visible!important;background-color:transparent!important;border:0!important;transform:none!important;transition:none}.navbar-expand-xxl .offcanvas .offcanvas-header{display:none}.navbar-expand-xxl .offcanvas .offcanvas-body{display:flex;flex-grow:0;padding:0;overflow-y:visible}}.navbar-expand{flex-wrap:nowrap;justify-content:flex-start}.navbar-expand .navbar-nav{flex-direction:row}.navbar-expand .navbar-nav .dropdown-menu{position:absolute}.navbar-expand .navbar-nav .nav-link{padding-right:var(--bs-navbar-nav-link-padding-x);padding-left:var(--bs-navbar-nav-link-padding-x)}.navbar-expand .navbar-nav-scroll{overflow:visible}.navbar-expand .navbar-collapse{display:flex!important;flex-basis:auto}.navbar-expand .navbar-toggler{display:none}.navbar-expand .offcanvas{position:static;z-index:auto;flex-grow:1;width:auto!important;height:auto!important;visibility:visible!important;background-color:transparent!important;border:0!important;transform:none!important;transition:none}.navbar-expand .offcanvas .offcanvas-header{display:none}.navbar-expand .offcanvas .offcanvas-body{display:flex;flex-grow:0;padding:0;overflow-y:visible}.navbar-dark,.navbar[data-bs-theme=dark]{--bs-navbar-color: rgba(255, 255, 255, .55);--bs-navbar-hover-color: rgba(255, 255, 255, .75);--bs-navbar-disabled-color: rgba(255, 255, 255, .25);--bs-navbar-active-color: #fff;--bs-navbar-brand-color: #fff;--bs-navbar-brand-hover-color: #fff;--bs-navbar-toggler-border-color: rgba(255, 255, 255, .1);--bs-navbar-toggler-icon-bg: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 30 30'%3e%3cpath stroke='rgba%28255, 255, 255, 0.55%29' stroke-linecap='round' stroke-miterlimit='10' stroke-width='2' d='M4 7h22M4 15h22M4 23h22'/%3e%3c/svg%3e")}[data-bs-theme=dark] .navbar-toggler-icon{--bs-navbar-toggler-icon-bg: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 30 30'%3e%3cpath stroke='rgba%28255, 255, 255, 0.55%29' stroke-linecap='round' stroke-miterlimit='10' stroke-width='2' d='M4 7h22M4 15h22M4 23h22'/%3e%3c/svg%3e")}.card{--bs-card-spacer-y: 1rem;--bs-card-spacer-x: 1rem;--bs-card-title-spacer-y: .5rem;--bs-card-title-color: ;--bs-card-subtitle-color: ;--bs-card-border-width: var(--bs-border-width);--bs-card-border-color: var(--bs-border-color-translucent);--bs-card-border-radius: var(--bs-border-radius);--bs-card-box-shadow: ;--bs-card-inner-border-radius: calc(var(--bs-border-radius) - (var(--bs-border-width)));--bs-card-cap-padding-y: .5rem;--bs-card-cap-padding-x: 1rem;--bs-card-cap-bg: rgba(var(--bs-body-color-rgb), .03);--bs-card-cap-color: ;--bs-card-height: ;--bs-card-color: ;--bs-card-bg: var(--bs-body-bg);--bs-card-img-overlay-padding: 1rem;--bs-card-group-margin: .75rem;position:relative;display:flex;flex-direction:column;min-width:0;height:var(--bs-card-height);color:var(--bs-body-color);word-wrap:break-word;background-color:var(--bs-card-bg);background-clip:border-box;border:var(--bs-card-border-width) solid var(--bs-card-border-color);border-radius:var(--bs-card-border-radius)}.card>hr{margin-right:0;margin-left:0}.card>.list-group{border-top:inherit;border-bottom:inherit}.card>.list-group:first-child{border-top-width:0;border-top-left-radius:var(--bs-card-inner-border-radius);border-top-right-radius:var(--bs-card-inner-border-radius)}.card>.list-group:last-child{border-bottom-width:0;border-bottom-right-radius:var(--bs-card-inner-border-radius);border-bottom-left-radius:var(--bs-card-inner-border-radius)}.card>.card-header+.list-group,.card>.list-group+.card-footer{border-top:0}.card-body{flex:1 1 auto;padding:var(--bs-card-spacer-y) var(--bs-card-spacer-x);color:var(--bs-card-color)}.card-title{margin-bottom:var(--bs-card-title-spacer-y);color:var(--bs-card-title-color)}.card-subtitle{margin-top:calc(-.5 * var(--bs-card-title-spacer-y));margin-bottom:0;color:var(--bs-card-subtitle-color)}.card-text:last-child{margin-bottom:0}.card-link+.card-link{margin-left:var(--bs-card-spacer-x)}.card-header{padding:var(--bs-card-cap-padding-y) var(--bs-card-cap-padding-x);margin-bottom:0;color:var(--bs-card-cap-color);background-color:var(--bs-card-cap-bg);border-bottom:var(--bs-card-border-width) solid var(--bs-card-border-color)}.card-header:first-child{border-radius:var(--bs-card-inner-border-radius) var(--bs-card-inner-border-radius) 0 0}.card-footer{padding:var(--bs-card-cap-padding-y) var(--bs-card-cap-padding-x);color:var(--bs-card-cap-color);background-color:var(--bs-card-cap-bg);border-top:var(--bs-card-border-width) solid var(--bs-card-border-color)}.card-footer:last-child{border-radius:0 0 var(--bs-card-inner-border-radius) var(--bs-card-inner-border-radius)}.card-header-tabs{margin-right:calc(-.5 * var(--bs-card-cap-padding-x));margin-bottom:calc(-1 * var(--bs-card-cap-padding-y));margin-left:calc(-.5 * var(--bs-card-cap-padding-x));border-bottom:0}.card-header-tabs .nav-link.active{background-color:var(--bs-card-bg);border-bottom-color:var(--bs-card-bg)}.card-header-pills{margin-right:calc(-.5 * var(--bs-card-cap-padding-x));margin-left:calc(-.5 * var(--bs-card-cap-padding-x))}.card-img-overlay{position:absolute;inset:0;padding:var(--bs-card-img-overlay-padding);border-radius:var(--bs-card-inner-border-radius)}.card-img,.card-img-top,.card-img-bottom{width:100%}.card-img,.card-img-top{border-top-left-radius:var(--bs-card-inner-border-radius);border-top-right-radius:var(--bs-card-inner-border-radius)}.card-img,.card-img-bottom{border-bottom-right-radius:var(--bs-card-inner-border-radius);border-bottom-left-radius:var(--bs-card-inner-border-radius)}.card-group>.card{margin-bottom:var(--bs-card-group-margin)}@media (min-width: 576px){.card-group{display:flex;flex-flow:row wrap}.card-group>.card{flex:1 0 0;margin-bottom:0}.card-group>.card+.card{margin-left:0;border-left:0}.card-group>.card:not(:last-child){border-top-right-radius:0;border-bottom-right-radius:0}.card-group>.card:not(:last-child)>.card-img-top,.card-group>.card:not(:last-child)>.card-header{border-top-right-radius:0}.card-group>.card:not(:last-child)>.card-img-bottom,.card-group>.card:not(:last-child)>.card-footer{border-bottom-right-radius:0}.card-group>.card:not(:first-child){border-top-left-radius:0;border-bottom-left-radius:0}.card-group>.card:not(:first-child)>.card-img-top,.card-group>.card:not(:first-child)>.card-header{border-top-left-radius:0}.card-group>.card:not(:first-child)>.card-img-bottom,.card-group>.card:not(:first-child)>.card-footer{border-bottom-left-radius:0}}.accordion{--bs-accordion-color: var(--bs-body-color);--bs-accordion-bg: var(--bs-body-bg);--bs-accordion-transition: color .15s ease-in-out, background-color .15s ease-in-out, border-color .15s ease-in-out, box-shadow .15s ease-in-out, border-radius .15s ease;--bs-accordion-border-color: var(--bs-border-color);--bs-accordion-border-width: var(--bs-border-width);--bs-accordion-border-radius: var(--bs-border-radius);--bs-accordion-inner-border-radius: calc(var(--bs-border-radius) - (var(--bs-border-width)));--bs-accordion-btn-padding-x: 1.25rem;--bs-accordion-btn-padding-y: 1rem;--bs-accordion-btn-color: var(--bs-body-color);--bs-accordion-btn-bg: var(--bs-accordion-bg);--bs-accordion-btn-icon: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16' fill='none' stroke='%23212529' stroke-linecap='round' stroke-linejoin='round'%3e%3cpath d='m2 5 6 6 6-6'/%3e%3c/svg%3e");--bs-accordion-btn-icon-width: 1.25rem;--bs-accordion-btn-icon-transform: rotate(-180deg);--bs-accordion-btn-icon-transition: transform .2s ease-in-out;--bs-accordion-btn-active-icon: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16' fill='none' stroke='rgb%285.2, 44, 101.2%29' stroke-linecap='round' stroke-linejoin='round'%3e%3cpath d='m2 5 6 6 6-6'/%3e%3c/svg%3e");--bs-accordion-btn-focus-box-shadow: 0 0 0 .25rem rgba(13, 110, 253, .25);--bs-accordion-body-padding-x: 1.25rem;--bs-accordion-body-padding-y: 1rem;--bs-accordion-active-color: var(--bs-primary-text-emphasis);--bs-accordion-active-bg: var(--bs-primary-bg-subtle)}.accordion-button{position:relative;display:flex;align-items:center;width:100%;padding:var(--bs-accordion-btn-padding-y) var(--bs-accordion-btn-padding-x);font-size:1rem;color:var(--bs-accordion-btn-color);text-align:left;background-color:var(--bs-accordion-btn-bg);border:0;border-radius:0;overflow-anchor:none;transition:var(--bs-accordion-transition)}@media (prefers-reduced-motion: reduce){.accordion-button{transition:none}}.accordion-button:not(.collapsed){color:var(--bs-accordion-active-color);background-color:var(--bs-accordion-active-bg);box-shadow:inset 0 calc(-1 * var(--bs-accordion-border-width)) 0 var(--bs-accordion-border-color)}.accordion-button:not(.collapsed):after{background-image:var(--bs-accordion-btn-active-icon);transform:var(--bs-accordion-btn-icon-transform)}.accordion-button:after{flex-shrink:0;width:var(--bs-accordion-btn-icon-width);height:var(--bs-accordion-btn-icon-width);margin-left:auto;content:"";background-image:var(--bs-accordion-btn-icon);background-repeat:no-repeat;background-size:var(--bs-accordion-btn-icon-width);transition:var(--bs-accordion-btn-icon-transition)}@media (prefers-reduced-motion: reduce){.accordion-button:after{transition:none}}.accordion-button:hover{z-index:2}.accordion-button:focus{z-index:3;outline:0;box-shadow:var(--bs-accordion-btn-focus-box-shadow)}.accordion-header{margin-bottom:0}.accordion-item{color:var(--bs-accordion-color);background-color:var(--bs-accordion-bg);border:var(--bs-accordion-border-width) solid var(--bs-accordion-border-color)}.accordion-item:first-of-type{border-top-left-radius:var(--bs-accordion-border-radius);border-top-right-radius:var(--bs-accordion-border-radius)}.accordion-item:first-of-type>.accordion-header .accordion-button{border-top-left-radius:var(--bs-accordion-inner-border-radius);border-top-right-radius:var(--bs-accordion-inner-border-radius)}.accordion-item:not(:first-of-type){border-top:0}.accordion-item:last-of-type{border-bottom-right-radius:var(--bs-accordion-border-radius);border-bottom-left-radius:var(--bs-accordion-border-radius)}.accordion-item:last-of-type>.accordion-header .accordion-button.collapsed{border-bottom-right-radius:var(--bs-accordion-inner-border-radius);border-bottom-left-radius:var(--bs-accordion-inner-border-radius)}.accordion-item:last-of-type>.accordion-collapse{border-bottom-right-radius:var(--bs-accordion-border-radius);border-bottom-left-radius:var(--bs-accordion-border-radius)}.accordion-body{padding:var(--bs-accordion-body-padding-y) var(--bs-accordion-body-padding-x)}.accordion-flush>.accordion-item{border-right:0;border-left:0;border-radius:0}.accordion-flush>.accordion-item:first-child{border-top:0}.accordion-flush>.accordion-item:last-child{border-bottom:0}.accordion-flush>.accordion-item>.accordion-collapse,.accordion-flush>.accordion-item>.accordion-header .accordion-button,.accordion-flush>.accordion-item>.accordion-header .accordion-button.collapsed{border-radius:0}[data-bs-theme=dark] .accordion-button:after{--bs-accordion-btn-icon: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16' fill='rgb%28109.8, 168, 253.8%29'%3e%3cpath fill-rule='evenodd' d='M1.646 4.646a.5.5 0 0 1 .708 0L8 10.293l5.646-5.647a.5.5 0 0 1 .708.708l-6 6a.5.5 0 0 1-.708 0l-6-6a.5.5 0 0 1 0-.708'/%3e%3c/svg%3e");--bs-accordion-btn-active-icon: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16' fill='rgb%28109.8, 168, 253.8%29'%3e%3cpath fill-rule='evenodd' d='M1.646 4.646a.5.5 0 0 1 .708 0L8 10.293l5.646-5.647a.5.5 0 0 1 .708.708l-6 6a.5.5 0 0 1-.708 0l-6-6a.5.5 0 0 1 0-.708'/%3e%3c/svg%3e")}.breadcrumb{--bs-breadcrumb-padding-x: 0;--bs-breadcrumb-padding-y: 0;--bs-breadcrumb-margin-bottom: 1rem;--bs-breadcrumb-bg: ;--bs-breadcrumb-border-radius: ;--bs-breadcrumb-divider-color: var(--bs-secondary-color);--bs-breadcrumb-item-padding-x: .5rem;--bs-breadcrumb-item-active-color: var(--bs-secondary-color);display:flex;flex-wrap:wrap;padding:var(--bs-breadcrumb-padding-y) var(--bs-breadcrumb-padding-x);margin-bottom:var(--bs-breadcrumb-margin-bottom);font-size:var(--bs-breadcrumb-font-size);list-style:none;background-color:var(--bs-breadcrumb-bg);border-radius:var(--bs-breadcrumb-border-radius)}.breadcrumb-item+.breadcrumb-item{padding-left:var(--bs-breadcrumb-item-padding-x)}.breadcrumb-item+.breadcrumb-item:before{float:left;padding-right:var(--bs-breadcrumb-item-padding-x);color:var(--bs-breadcrumb-divider-color);content:var(--bs-breadcrumb-divider, "/")}.breadcrumb-item.active{color:var(--bs-breadcrumb-item-active-color)}.pagination{--bs-pagination-padding-x: .75rem;--bs-pagination-padding-y: .375rem;--bs-pagination-font-size: 1rem;--bs-pagination-color: var(--bs-link-color);--bs-pagination-bg: var(--bs-body-bg);--bs-pagination-border-width: var(--bs-border-width);--bs-pagination-border-color: var(--bs-border-color);--bs-pagination-border-radius: var(--bs-border-radius);--bs-pagination-hover-color: var(--bs-link-hover-color);--bs-pagination-hover-bg: var(--bs-tertiary-bg);--bs-pagination-hover-border-color: var(--bs-border-color);--bs-pagination-focus-color: var(--bs-link-hover-color);--bs-pagination-focus-bg: var(--bs-secondary-bg);--bs-pagination-focus-box-shadow: 0 0 0 .25rem rgba(13, 110, 253, .25);--bs-pagination-active-color: #fff;--bs-pagination-active-bg: #0d6efd;--bs-pagination-active-border-color: #0d6efd;--bs-pagination-disabled-color: var(--bs-secondary-color);--bs-pagination-disabled-bg: var(--bs-secondary-bg);--bs-pagination-disabled-border-color: var(--bs-border-color);display:flex;padding-left:0;list-style:none}.page-link{position:relative;display:block;padding:var(--bs-pagination-padding-y) var(--bs-pagination-padding-x);font-size:var(--bs-pagination-font-size);color:var(--bs-pagination-color);text-decoration:none;background-color:var(--bs-pagination-bg);border:var(--bs-pagination-border-width) solid var(--bs-pagination-border-color);transition:color .15s ease-in-out,background-color .15s ease-in-out,border-color .15s ease-in-out,box-shadow .15s ease-in-out}@media (prefers-reduced-motion: reduce){.page-link{transition:none}}.page-link:hover{z-index:2;color:var(--bs-pagination-hover-color);background-color:var(--bs-pagination-hover-bg);border-color:var(--bs-pagination-hover-border-color)}.page-link:focus{z-index:3;color:var(--bs-pagination-focus-color);background-color:var(--bs-pagination-focus-bg);outline:0;box-shadow:var(--bs-pagination-focus-box-shadow)}.page-link.active,.active>.page-link{z-index:3;color:var(--bs-pagination-active-color);background-color:var(--bs-pagination-active-bg);border-color:var(--bs-pagination-active-border-color)}.page-link.disabled,.disabled>.page-link{color:var(--bs-pagination-disabled-color);pointer-events:none;background-color:var(--bs-pagination-disabled-bg);border-color:var(--bs-pagination-disabled-border-color)}.page-item:not(:first-child) .page-link{margin-left:calc(-1 * var(--bs-border-width))}.page-item:first-child .page-link{border-top-left-radius:var(--bs-pagination-border-radius);border-bottom-left-radius:var(--bs-pagination-border-radius)}.page-item:last-child .page-link{border-top-right-radius:var(--bs-pagination-border-radius);border-bottom-right-radius:var(--bs-pagination-border-radius)}.pagination-lg{--bs-pagination-padding-x: 1.5rem;--bs-pagination-padding-y: .75rem;--bs-pagination-font-size: 1.25rem;--bs-pagination-border-radius: var(--bs-border-radius-lg)}.pagination-sm{--bs-pagination-padding-x: .5rem;--bs-pagination-padding-y: .25rem;--bs-pagination-font-size: .875rem;--bs-pagination-border-radius: var(--bs-border-radius-sm)}.badge{--bs-badge-padding-x: .65em;--bs-badge-padding-y: .35em;--bs-badge-font-size: .75em;--bs-badge-font-weight: 700;--bs-badge-color: #fff;--bs-badge-border-radius: var(--bs-border-radius);display:inline-block;padding:var(--bs-badge-padding-y) var(--bs-badge-padding-x);font-size:var(--bs-badge-font-size);font-weight:var(--bs-badge-font-weight);line-height:1;color:var(--bs-badge-color);text-align:center;white-space:nowrap;vertical-align:baseline;border-radius:var(--bs-badge-border-radius)}.badge:empty{display:none}.btn .badge{position:relative;top:-1px}.alert{--bs-alert-bg: transparent;--bs-alert-padding-x: 1rem;--bs-alert-padding-y: 1rem;--bs-alert-margin-bottom: 1rem;--bs-alert-color: inherit;--bs-alert-border-color: transparent;--bs-alert-border: var(--bs-border-width) solid var(--bs-alert-border-color);--bs-alert-border-radius: var(--bs-border-radius);--bs-alert-link-color: inherit;position:relative;padding:var(--bs-alert-padding-y) var(--bs-alert-padding-x);margin-bottom:var(--bs-alert-margin-bottom);color:var(--bs-alert-color);background-color:var(--bs-alert-bg);border:var(--bs-alert-border);border-radius:var(--bs-alert-border-radius)}.alert-heading{color:inherit}.alert-link{font-weight:700;color:var(--bs-alert-link-color)}.alert-dismissible{padding-right:3rem}.alert-dismissible .btn-close{position:absolute;top:0;right:0;z-index:2;padding:1.25rem 1rem}.alert-primary{--bs-alert-color: var(--bs-primary-text-emphasis);--bs-alert-bg: var(--bs-primary-bg-subtle);--bs-alert-border-color: var(--bs-primary-border-subtle);--bs-alert-link-color: var(--bs-primary-text-emphasis)}.alert-secondary{--bs-alert-color: var(--bs-secondary-text-emphasis);--bs-alert-bg: var(--bs-secondary-bg-subtle);--bs-alert-border-color: var(--bs-secondary-border-subtle);--bs-alert-link-color: var(--bs-secondary-text-emphasis)}.alert-success{--bs-alert-color: var(--bs-success-text-emphasis);--bs-alert-bg: var(--bs-success-bg-subtle);--bs-alert-border-color: var(--bs-success-border-subtle);--bs-alert-link-color: var(--bs-success-text-emphasis)}.alert-info{--bs-alert-color: var(--bs-info-text-emphasis);--bs-alert-bg: var(--bs-info-bg-subtle);--bs-alert-border-color: var(--bs-info-border-subtle);--bs-alert-link-color: var(--bs-info-text-emphasis)}.alert-warning{--bs-alert-color: var(--bs-warning-text-emphasis);--bs-alert-bg: var(--bs-warning-bg-subtle);--bs-alert-border-color: var(--bs-warning-border-subtle);--bs-alert-link-color: var(--bs-warning-text-emphasis)}.alert-danger{--bs-alert-color: var(--bs-danger-text-emphasis);--bs-alert-bg: var(--bs-danger-bg-subtle);--bs-alert-border-color: var(--bs-danger-border-subtle);--bs-alert-link-color: var(--bs-danger-text-emphasis)}.alert-light{--bs-alert-color: var(--bs-light-text-emphasis);--bs-alert-bg: var(--bs-light-bg-subtle);--bs-alert-border-color: var(--bs-light-border-subtle);--bs-alert-link-color: var(--bs-light-text-emphasis)}.alert-dark{--bs-alert-color: var(--bs-dark-text-emphasis);--bs-alert-bg: var(--bs-dark-bg-subtle);--bs-alert-border-color: var(--bs-dark-border-subtle);--bs-alert-link-color: var(--bs-dark-text-emphasis)}@keyframes progress-bar-stripes{0%{background-position-x:var(--bs-progress-height)}}.progress,.progress-stacked{--bs-progress-height: 1rem;--bs-progress-font-size: .75rem;--bs-progress-bg: var(--bs-secondary-bg);--bs-progress-border-radius: var(--bs-border-radius);--bs-progress-box-shadow: var(--bs-box-shadow-inset);--bs-progress-bar-color: #fff;--bs-progress-bar-bg: #0d6efd;--bs-progress-bar-transition: width .6s ease;display:flex;height:var(--bs-progress-height);overflow:hidden;font-size:var(--bs-progress-font-size);background-color:var(--bs-progress-bg);border-radius:var(--bs-progress-border-radius)}.progress-bar{display:flex;flex-direction:column;justify-content:center;overflow:hidden;color:var(--bs-progress-bar-color);text-align:center;white-space:nowrap;background-color:var(--bs-progress-bar-bg);transition:var(--bs-progress-bar-transition)}@media (prefers-reduced-motion: reduce){.progress-bar{transition:none}}.progress-bar-striped{background-image:linear-gradient(45deg,rgba(255,255,255,.15) 25%,transparent 25%,transparent 50%,rgba(255,255,255,.15) 50%,rgba(255,255,255,.15) 75%,transparent 75%,transparent);background-size:var(--bs-progress-height) var(--bs-progress-height)}.progress-stacked>.progress{overflow:visible}.progress-stacked>.progress>.progress-bar{width:100%}.progress-bar-animated{animation:1s linear infinite progress-bar-stripes}@media (prefers-reduced-motion: reduce){.progress-bar-animated{animation:none}}.list-group{--bs-list-group-color: var(--bs-body-color);--bs-list-group-bg: var(--bs-body-bg);--bs-list-group-border-color: var(--bs-border-color);--bs-list-group-border-width: var(--bs-border-width);--bs-list-group-border-radius: var(--bs-border-radius);--bs-list-group-item-padding-x: 1rem;--bs-list-group-item-padding-y: .5rem;--bs-list-group-action-color: var(--bs-secondary-color);--bs-list-group-action-hover-color: var(--bs-emphasis-color);--bs-list-group-action-hover-bg: var(--bs-tertiary-bg);--bs-list-group-action-active-color: var(--bs-body-color);--bs-list-group-action-active-bg: var(--bs-secondary-bg);--bs-list-group-disabled-color: var(--bs-secondary-color);--bs-list-group-disabled-bg: var(--bs-body-bg);--bs-list-group-active-color: #fff;--bs-list-group-active-bg: #0d6efd;--bs-list-group-active-border-color: #0d6efd;display:flex;flex-direction:column;padding-left:0;margin-bottom:0;border-radius:var(--bs-list-group-border-radius)}.list-group-numbered{list-style-type:none;counter-reset:section}.list-group-numbered>.list-group-item:before{content:counters(section,".") ". ";counter-increment:section}.list-group-item{position:relative;display:block;padding:var(--bs-list-group-item-padding-y) var(--bs-list-group-item-padding-x);color:var(--bs-list-group-color);text-decoration:none;background-color:var(--bs-list-group-bg);border:var(--bs-list-group-border-width) solid var(--bs-list-group-border-color)}.list-group-item:first-child{border-top-left-radius:inherit;border-top-right-radius:inherit}.list-group-item:last-child{border-bottom-right-radius:inherit;border-bottom-left-radius:inherit}.list-group-item.disabled,.list-group-item:disabled{color:var(--bs-list-group-disabled-color);pointer-events:none;background-color:var(--bs-list-group-disabled-bg)}.list-group-item.active{z-index:2;color:var(--bs-list-group-active-color);background-color:var(--bs-list-group-active-bg);border-color:var(--bs-list-group-active-border-color)}.list-group-item+.list-group-item{border-top-width:0}.list-group-item+.list-group-item.active{margin-top:calc(-1 * var(--bs-list-group-border-width));border-top-width:var(--bs-list-group-border-width)}.list-group-item-action{width:100%;color:var(--bs-list-group-action-color);text-align:inherit}.list-group-item-action:not(.active):hover,.list-group-item-action:not(.active):focus{z-index:1;color:var(--bs-list-group-action-hover-color);text-decoration:none;background-color:var(--bs-list-group-action-hover-bg)}.list-group-item-action:not(.active):active{color:var(--bs-list-group-action-active-color);background-color:var(--bs-list-group-action-active-bg)}.list-group-horizontal{flex-direction:row}.list-group-horizontal>.list-group-item:first-child:not(:last-child){border-bottom-left-radius:var(--bs-list-group-border-radius);border-top-right-radius:0}.list-group-horizontal>.list-group-item:last-child:not(:first-child){border-top-right-radius:var(--bs-list-group-border-radius);border-bottom-left-radius:0}.list-group-horizontal>.list-group-item.active{margin-top:0}.list-group-horizontal>.list-group-item+.list-group-item{border-top-width:var(--bs-list-group-border-width);border-left-width:0}.list-group-horizontal>.list-group-item+.list-group-item.active{margin-left:calc(-1 * var(--bs-list-group-border-width));border-left-width:var(--bs-list-group-border-width)}@media (min-width: 576px){.list-group-horizontal-sm{flex-direction:row}.list-group-horizontal-sm>.list-group-item:first-child:not(:last-child){border-bottom-left-radius:var(--bs-list-group-border-radius);border-top-right-radius:0}.list-group-horizontal-sm>.list-group-item:last-child:not(:first-child){border-top-right-radius:var(--bs-list-group-border-radius);border-bottom-left-radius:0}.list-group-horizontal-sm>.list-group-item.active{margin-top:0}.list-group-horizontal-sm>.list-group-item+.list-group-item{border-top-width:var(--bs-list-group-border-width);border-left-width:0}.list-group-horizontal-sm>.list-group-item+.list-group-item.active{margin-left:calc(-1 * var(--bs-list-group-border-width));border-left-width:var(--bs-list-group-border-width)}}@media (min-width: 768px){.list-group-horizontal-md{flex-direction:row}.list-group-horizontal-md>.list-group-item:first-child:not(:last-child){border-bottom-left-radius:var(--bs-list-group-border-radius);border-top-right-radius:0}.list-group-horizontal-md>.list-group-item:last-child:not(:first-child){border-top-right-radius:var(--bs-list-group-border-radius);border-bottom-left-radius:0}.list-group-horizontal-md>.list-group-item.active{margin-top:0}.list-group-horizontal-md>.list-group-item+.list-group-item{border-top-width:var(--bs-list-group-border-width);border-left-width:0}.list-group-horizontal-md>.list-group-item+.list-group-item.active{margin-left:calc(-1 * var(--bs-list-group-border-width));border-left-width:var(--bs-list-group-border-width)}}@media (min-width: 992px){.list-group-horizontal-lg{flex-direction:row}.list-group-horizontal-lg>.list-group-item:first-child:not(:last-child){border-bottom-left-radius:var(--bs-list-group-border-radius);border-top-right-radius:0}.list-group-horizontal-lg>.list-group-item:last-child:not(:first-child){border-top-right-radius:var(--bs-list-group-border-radius);border-bottom-left-radius:0}.list-group-horizontal-lg>.list-group-item.active{margin-top:0}.list-group-horizontal-lg>.list-group-item+.list-group-item{border-top-width:var(--bs-list-group-border-width);border-left-width:0}.list-group-horizontal-lg>.list-group-item+.list-group-item.active{margin-left:calc(-1 * var(--bs-list-group-border-width));border-left-width:var(--bs-list-group-border-width)}}@media (min-width: 1200px){.list-group-horizontal-xl{flex-direction:row}.list-group-horizontal-xl>.list-group-item:first-child:not(:last-child){border-bottom-left-radius:var(--bs-list-group-border-radius);border-top-right-radius:0}.list-group-horizontal-xl>.list-group-item:last-child:not(:first-child){border-top-right-radius:var(--bs-list-group-border-radius);border-bottom-left-radius:0}.list-group-horizontal-xl>.list-group-item.active{margin-top:0}.list-group-horizontal-xl>.list-group-item+.list-group-item{border-top-width:var(--bs-list-group-border-width);border-left-width:0}.list-group-horizontal-xl>.list-group-item+.list-group-item.active{margin-left:calc(-1 * var(--bs-list-group-border-width));border-left-width:var(--bs-list-group-border-width)}}@media (min-width: 1400px){.list-group-horizontal-xxl{flex-direction:row}.list-group-horizontal-xxl>.list-group-item:first-child:not(:last-child){border-bottom-left-radius:var(--bs-list-group-border-radius);border-top-right-radius:0}.list-group-horizontal-xxl>.list-group-item:last-child:not(:first-child){border-top-right-radius:var(--bs-list-group-border-radius);border-bottom-left-radius:0}.list-group-horizontal-xxl>.list-group-item.active{margin-top:0}.list-group-horizontal-xxl>.list-group-item+.list-group-item{border-top-width:var(--bs-list-group-border-width);border-left-width:0}.list-group-horizontal-xxl>.list-group-item+.list-group-item.active{margin-left:calc(-1 * var(--bs-list-group-border-width));border-left-width:var(--bs-list-group-border-width)}}.list-group-flush{border-radius:0}.list-group-flush>.list-group-item{border-width:0 0 var(--bs-list-group-border-width)}.list-group-flush>.list-group-item:last-child{border-bottom-width:0}.list-group-item-primary{--bs-list-group-color: var(--bs-primary-text-emphasis);--bs-list-group-bg: var(--bs-primary-bg-subtle);--bs-list-group-border-color: var(--bs-primary-border-subtle);--bs-list-group-action-hover-color: var(--bs-emphasis-color);--bs-list-group-action-hover-bg: var(--bs-primary-border-subtle);--bs-list-group-action-active-color: var(--bs-emphasis-color);--bs-list-group-action-active-bg: var(--bs-primary-border-subtle);--bs-list-group-active-color: var(--bs-primary-bg-subtle);--bs-list-group-active-bg: var(--bs-primary-text-emphasis);--bs-list-group-active-border-color: var(--bs-primary-text-emphasis)}.list-group-item-secondary{--bs-list-group-color: var(--bs-secondary-text-emphasis);--bs-list-group-bg: var(--bs-secondary-bg-subtle);--bs-list-group-border-color: var(--bs-secondary-border-subtle);--bs-list-group-action-hover-color: var(--bs-emphasis-color);--bs-list-group-action-hover-bg: var(--bs-secondary-border-subtle);--bs-list-group-action-active-color: var(--bs-emphasis-color);--bs-list-group-action-active-bg: var(--bs-secondary-border-subtle);--bs-list-group-active-color: var(--bs-secondary-bg-subtle);--bs-list-group-active-bg: var(--bs-secondary-text-emphasis);--bs-list-group-active-border-color: var(--bs-secondary-text-emphasis)}.list-group-item-success{--bs-list-group-color: var(--bs-success-text-emphasis);--bs-list-group-bg: var(--bs-success-bg-subtle);--bs-list-group-border-color: var(--bs-success-border-subtle);--bs-list-group-action-hover-color: var(--bs-emphasis-color);--bs-list-group-action-hover-bg: var(--bs-success-border-subtle);--bs-list-group-action-active-color: var(--bs-emphasis-color);--bs-list-group-action-active-bg: var(--bs-success-border-subtle);--bs-list-group-active-color: var(--bs-success-bg-subtle);--bs-list-group-active-bg: var(--bs-success-text-emphasis);--bs-list-group-active-border-color: var(--bs-success-text-emphasis)}.list-group-item-info{--bs-list-group-color: var(--bs-info-text-emphasis);--bs-list-group-bg: var(--bs-info-bg-subtle);--bs-list-group-border-color: var(--bs-info-border-subtle);--bs-list-group-action-hover-color: var(--bs-emphasis-color);--bs-list-group-action-hover-bg: var(--bs-info-border-subtle);--bs-list-group-action-active-color: var(--bs-emphasis-color);--bs-list-group-action-active-bg: var(--bs-info-border-subtle);--bs-list-group-active-color: var(--bs-info-bg-subtle);--bs-list-group-active-bg: var(--bs-info-text-emphasis);--bs-list-group-active-border-color: var(--bs-info-text-emphasis)}.list-group-item-warning{--bs-list-group-color: var(--bs-warning-text-emphasis);--bs-list-group-bg: var(--bs-warning-bg-subtle);--bs-list-group-border-color: var(--bs-warning-border-subtle);--bs-list-group-action-hover-color: var(--bs-emphasis-color);--bs-list-group-action-hover-bg: var(--bs-warning-border-subtle);--bs-list-group-action-active-color: var(--bs-emphasis-color);--bs-list-group-action-active-bg: var(--bs-warning-border-subtle);--bs-list-group-active-color: var(--bs-warning-bg-subtle);--bs-list-group-active-bg: var(--bs-warning-text-emphasis);--bs-list-group-active-border-color: var(--bs-warning-text-emphasis)}.list-group-item-danger{--bs-list-group-color: var(--bs-danger-text-emphasis);--bs-list-group-bg: var(--bs-danger-bg-subtle);--bs-list-group-border-color: var(--bs-danger-border-subtle);--bs-list-group-action-hover-color: var(--bs-emphasis-color);--bs-list-group-action-hover-bg: var(--bs-danger-border-subtle);--bs-list-group-action-active-color: var(--bs-emphasis-color);--bs-list-group-action-active-bg: var(--bs-danger-border-subtle);--bs-list-group-active-color: var(--bs-danger-bg-subtle);--bs-list-group-active-bg: var(--bs-danger-text-emphasis);--bs-list-group-active-border-color: var(--bs-danger-text-emphasis)}.list-group-item-light{--bs-list-group-color: var(--bs-light-text-emphasis);--bs-list-group-bg: var(--bs-light-bg-subtle);--bs-list-group-border-color: var(--bs-light-border-subtle);--bs-list-group-action-hover-color: var(--bs-emphasis-color);--bs-list-group-action-hover-bg: var(--bs-light-border-subtle);--bs-list-group-action-active-color: var(--bs-emphasis-color);--bs-list-group-action-active-bg: var(--bs-light-border-subtle);--bs-list-group-active-color: var(--bs-light-bg-subtle);--bs-list-group-active-bg: var(--bs-light-text-emphasis);--bs-list-group-active-border-color: var(--bs-light-text-emphasis)}.list-group-item-dark{--bs-list-group-color: var(--bs-dark-text-emphasis);--bs-list-group-bg: var(--bs-dark-bg-subtle);--bs-list-group-border-color: var(--bs-dark-border-subtle);--bs-list-group-action-hover-color: var(--bs-emphasis-color);--bs-list-group-action-hover-bg: var(--bs-dark-border-subtle);--bs-list-group-action-active-color: var(--bs-emphasis-color);--bs-list-group-action-active-bg: var(--bs-dark-border-subtle);--bs-list-group-active-color: var(--bs-dark-bg-subtle);--bs-list-group-active-bg: var(--bs-dark-text-emphasis);--bs-list-group-active-border-color: var(--bs-dark-text-emphasis)}.btn-close{--bs-btn-close-color: #000;--bs-btn-close-bg: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16' fill='%23000'%3e%3cpath d='M.293.293a1 1 0 0 1 1.414 0L8 6.586 14.293.293a1 1 0 1 1 1.414 1.414L9.414 8l6.293 6.293a1 1 0 0 1-1.414 1.414L8 9.414l-6.293 6.293a1 1 0 0 1-1.414-1.414L6.586 8 .293 1.707a1 1 0 0 1 0-1.414'/%3e%3c/svg%3e");--bs-btn-close-opacity: .5;--bs-btn-close-hover-opacity: .75;--bs-btn-close-focus-shadow: 0 0 0 .25rem rgba(13, 110, 253, .25);--bs-btn-close-focus-opacity: 1;--bs-btn-close-disabled-opacity: .25;box-sizing:content-box;width:1em;height:1em;padding:.25em;color:var(--bs-btn-close-color);background:transparent var(--bs-btn-close-bg) center/1em auto no-repeat;filter:var(--bs-btn-close-filter);border:0;border-radius:.375rem;opacity:var(--bs-btn-close-opacity)}.btn-close:hover{color:var(--bs-btn-close-color);text-decoration:none;opacity:var(--bs-btn-close-hover-opacity)}.btn-close:focus{outline:0;box-shadow:var(--bs-btn-close-focus-shadow);opacity:var(--bs-btn-close-focus-opacity)}.btn-close:disabled,.btn-close.disabled{pointer-events:none;user-select:none;opacity:var(--bs-btn-close-disabled-opacity)}.btn-close-white{--bs-btn-close-filter: invert(1) grayscale(100%) brightness(200%)}:root,[data-bs-theme=light]{--bs-btn-close-filter: }[data-bs-theme=dark]{--bs-btn-close-filter: invert(1) grayscale(100%) brightness(200%)}.toast{--bs-toast-zindex: 1090;--bs-toast-padding-x: .75rem;--bs-toast-padding-y: .5rem;--bs-toast-spacing: 1.5rem;--bs-toast-max-width: 350px;--bs-toast-font-size: .875rem;--bs-toast-color: ;--bs-toast-bg: rgba(var(--bs-body-bg-rgb), .85);--bs-toast-border-width: var(--bs-border-width);--bs-toast-border-color: var(--bs-border-color-translucent);--bs-toast-border-radius: var(--bs-border-radius);--bs-toast-box-shadow: var(--bs-box-shadow);--bs-toast-header-color: var(--bs-secondary-color);--bs-toast-header-bg: rgba(var(--bs-body-bg-rgb), .85);--bs-toast-header-border-color: var(--bs-border-color-translucent);width:var(--bs-toast-max-width);max-width:100%;font-size:var(--bs-toast-font-size);color:var(--bs-toast-color);pointer-events:auto;background-color:var(--bs-toast-bg);background-clip:padding-box;border:var(--bs-toast-border-width) solid var(--bs-toast-border-color);box-shadow:var(--bs-toast-box-shadow);border-radius:var(--bs-toast-border-radius)}.toast.showing{opacity:0}.toast:not(.show){display:none}.toast-container{--bs-toast-zindex: 1090;position:absolute;z-index:var(--bs-toast-zindex);width:max-content;max-width:100%;pointer-events:none}.toast-container>:not(:last-child){margin-bottom:var(--bs-toast-spacing)}.toast-header{display:flex;align-items:center;padding:var(--bs-toast-padding-y) var(--bs-toast-padding-x);color:var(--bs-toast-header-color);background-color:var(--bs-toast-header-bg);background-clip:padding-box;border-bottom:var(--bs-toast-border-width) solid var(--bs-toast-header-border-color);border-top-left-radius:calc(var(--bs-toast-border-radius) - var(--bs-toast-border-width));border-top-right-radius:calc(var(--bs-toast-border-radius) - var(--bs-toast-border-width))}.toast-header .btn-close{margin-right:calc(-.5 * var(--bs-toast-padding-x));margin-left:var(--bs-toast-padding-x)}.toast-body{padding:var(--bs-toast-padding-x);word-wrap:break-word}.modal{--bs-modal-zindex: 1055;--bs-modal-width: 500px;--bs-modal-padding: 1rem;--bs-modal-margin: .5rem;--bs-modal-color: var(--bs-body-color);--bs-modal-bg: var(--bs-body-bg);--bs-modal-border-color: var(--bs-border-color-translucent);--bs-modal-border-width: var(--bs-border-width);--bs-modal-border-radius: var(--bs-border-radius-lg);--bs-modal-box-shadow: var(--bs-box-shadow-sm);--bs-modal-inner-border-radius: calc(var(--bs-border-radius-lg) - (var(--bs-border-width)));--bs-modal-header-padding-x: 1rem;--bs-modal-header-padding-y: 1rem;--bs-modal-header-padding: 1rem 1rem;--bs-modal-header-border-color: var(--bs-border-color);--bs-modal-header-border-width: var(--bs-border-width);--bs-modal-title-line-height: 1.5;--bs-modal-footer-gap: .5rem;--bs-modal-footer-bg: ;--bs-modal-footer-border-color: var(--bs-border-color);--bs-modal-footer-border-width: var(--bs-border-width);position:fixed;top:0;left:0;z-index:var(--bs-modal-zindex);display:none;width:100%;height:100%;overflow-x:hidden;overflow-y:auto;outline:0}.modal-dialog{position:relative;width:auto;margin:var(--bs-modal-margin);pointer-events:none}.modal.fade .modal-dialog{transform:translateY(-50px);transition:transform .3s ease-out}@media (prefers-reduced-motion: reduce){.modal.fade .modal-dialog{transition:none}}.modal.show .modal-dialog{transform:none}.modal.modal-static .modal-dialog{transform:scale(1.02)}.modal-dialog-scrollable{height:calc(100% - var(--bs-modal-margin) * 2)}.modal-dialog-scrollable .modal-content{max-height:100%;overflow:hidden}.modal-dialog-scrollable .modal-body{overflow-y:auto}.modal-dialog-centered{display:flex;align-items:center;min-height:calc(100% - var(--bs-modal-margin) * 2)}.modal-content{position:relative;display:flex;flex-direction:column;width:100%;color:var(--bs-modal-color);pointer-events:auto;background-color:var(--bs-modal-bg);background-clip:padding-box;border:var(--bs-modal-border-width) solid var(--bs-modal-border-color);border-radius:var(--bs-modal-border-radius);outline:0}.modal-backdrop{--bs-backdrop-zindex: 1050;--bs-backdrop-bg: #000;--bs-backdrop-opacity: .5;position:fixed;top:0;left:0;z-index:var(--bs-backdrop-zindex);width:100vw;height:100vh;background-color:var(--bs-backdrop-bg)}.modal-backdrop.fade{opacity:0}.modal-backdrop.show{opacity:var(--bs-backdrop-opacity)}.modal-header{display:flex;flex-shrink:0;align-items:center;padding:var(--bs-modal-header-padding);border-bottom:var(--bs-modal-header-border-width) solid var(--bs-modal-header-border-color);border-top-left-radius:var(--bs-modal-inner-border-radius);border-top-right-radius:var(--bs-modal-inner-border-radius)}.modal-header .btn-close{padding:calc(var(--bs-modal-header-padding-y) * .5) calc(var(--bs-modal-header-padding-x) * .5);margin-top:calc(-.5 * var(--bs-modal-header-padding-y));margin-right:calc(-.5 * var(--bs-modal-header-padding-x));margin-bottom:calc(-.5 * var(--bs-modal-header-padding-y));margin-left:auto}.modal-title{margin-bottom:0;line-height:var(--bs-modal-title-line-height)}.modal-body{position:relative;flex:1 1 auto;padding:var(--bs-modal-padding)}.modal-footer{display:flex;flex-shrink:0;flex-wrap:wrap;align-items:center;justify-content:flex-end;padding:calc(var(--bs-modal-padding) - var(--bs-modal-footer-gap) * .5);background-color:var(--bs-modal-footer-bg);border-top:var(--bs-modal-footer-border-width) solid var(--bs-modal-footer-border-color);border-bottom-right-radius:var(--bs-modal-inner-border-radius);border-bottom-left-radius:var(--bs-modal-inner-border-radius)}.modal-footer>*{margin:calc(var(--bs-modal-footer-gap) * .5)}@media (min-width: 576px){.modal{--bs-modal-margin: 1.75rem;--bs-modal-box-shadow: var(--bs-box-shadow)}.modal-dialog{max-width:var(--bs-modal-width);margin-right:auto;margin-left:auto}.modal-sm{--bs-modal-width: 300px}}@media (min-width: 992px){.modal-lg,.modal-xl{--bs-modal-width: 800px}}@media (min-width: 1200px){.modal-xl{--bs-modal-width: 1140px}}.modal-fullscreen{width:100vw;max-width:none;height:100%;margin:0}.modal-fullscreen .modal-content{height:100%;border:0;border-radius:0}.modal-fullscreen .modal-header,.modal-fullscreen .modal-footer{border-radius:0}.modal-fullscreen .modal-body{overflow-y:auto}@media (max-width: 575.98px){.modal-fullscreen-sm-down{width:100vw;max-width:none;height:100%;margin:0}.modal-fullscreen-sm-down .modal-content{height:100%;border:0;border-radius:0}.modal-fullscreen-sm-down .modal-header,.modal-fullscreen-sm-down .modal-footer{border-radius:0}.modal-fullscreen-sm-down .modal-body{overflow-y:auto}}@media (max-width: 767.98px){.modal-fullscreen-md-down{width:100vw;max-width:none;height:100%;margin:0}.modal-fullscreen-md-down .modal-content{height:100%;border:0;border-radius:0}.modal-fullscreen-md-down .modal-header,.modal-fullscreen-md-down .modal-footer{border-radius:0}.modal-fullscreen-md-down .modal-body{overflow-y:auto}}@media (max-width: 991.98px){.modal-fullscreen-lg-down{width:100vw;max-width:none;height:100%;margin:0}.modal-fullscreen-lg-down .modal-content{height:100%;border:0;border-radius:0}.modal-fullscreen-lg-down .modal-header,.modal-fullscreen-lg-down .modal-footer{border-radius:0}.modal-fullscreen-lg-down .modal-body{overflow-y:auto}}@media (max-width: 1199.98px){.modal-fullscreen-xl-down{width:100vw;max-width:none;height:100%;margin:0}.modal-fullscreen-xl-down .modal-content{height:100%;border:0;border-radius:0}.modal-fullscreen-xl-down .modal-header,.modal-fullscreen-xl-down .modal-footer{border-radius:0}.modal-fullscreen-xl-down .modal-body{overflow-y:auto}}@media (max-width: 1399.98px){.modal-fullscreen-xxl-down{width:100vw;max-width:none;height:100%;margin:0}.modal-fullscreen-xxl-down .modal-content{height:100%;border:0;border-radius:0}.modal-fullscreen-xxl-down .modal-header,.modal-fullscreen-xxl-down .modal-footer{border-radius:0}.modal-fullscreen-xxl-down .modal-body{overflow-y:auto}}.tooltip{--bs-tooltip-zindex: 1080;--bs-tooltip-max-width: 200px;--bs-tooltip-padding-x: .5rem;--bs-tooltip-padding-y: .25rem;--bs-tooltip-margin: ;--bs-tooltip-font-size: .875rem;--bs-tooltip-color: var(--bs-body-bg);--bs-tooltip-bg: var(--bs-emphasis-color);--bs-tooltip-border-radius: var(--bs-border-radius);--bs-tooltip-opacity: .9;--bs-tooltip-arrow-width: .8rem;--bs-tooltip-arrow-height: .4rem;z-index:var(--bs-tooltip-zindex);display:block;margin:var(--bs-tooltip-margin);font-family:var(--bs-font-sans-serif);font-style:normal;font-weight:400;line-height:1.5;text-align:left;text-align:start;text-decoration:none;text-shadow:none;text-transform:none;letter-spacing:normal;word-break:normal;white-space:normal;word-spacing:normal;line-break:auto;font-size:var(--bs-tooltip-font-size);word-wrap:break-word;opacity:0}.tooltip.show{opacity:var(--bs-tooltip-opacity)}.tooltip .tooltip-arrow{display:block;width:var(--bs-tooltip-arrow-width);height:var(--bs-tooltip-arrow-height)}.tooltip .tooltip-arrow:before{position:absolute;content:"";border-color:transparent;border-style:solid}.bs-tooltip-top .tooltip-arrow,.bs-tooltip-auto[data-popper-placement^=top] .tooltip-arrow{bottom:calc(-1 * var(--bs-tooltip-arrow-height))}.bs-tooltip-top .tooltip-arrow:before,.bs-tooltip-auto[data-popper-placement^=top] .tooltip-arrow:before{top:-1px;border-width:var(--bs-tooltip-arrow-height) calc(var(--bs-tooltip-arrow-width) * .5) 0;border-top-color:var(--bs-tooltip-bg)}.bs-tooltip-end .tooltip-arrow,.bs-tooltip-auto[data-popper-placement^=right] .tooltip-arrow{left:calc(-1 * var(--bs-tooltip-arrow-height));width:var(--bs-tooltip-arrow-height);height:var(--bs-tooltip-arrow-width)}.bs-tooltip-end .tooltip-arrow:before,.bs-tooltip-auto[data-popper-placement^=right] .tooltip-arrow:before{right:-1px;border-width:calc(var(--bs-tooltip-arrow-width) * .5) var(--bs-tooltip-arrow-height) calc(var(--bs-tooltip-arrow-width) * .5) 0;border-right-color:var(--bs-tooltip-bg)}.bs-tooltip-bottom .tooltip-arrow,.bs-tooltip-auto[data-popper-placement^=bottom] .tooltip-arrow{top:calc(-1 * var(--bs-tooltip-arrow-height))}.bs-tooltip-bottom .tooltip-arrow:before,.bs-tooltip-auto[data-popper-placement^=bottom] .tooltip-arrow:before{bottom:-1px;border-width:0 calc(var(--bs-tooltip-arrow-width) * .5) var(--bs-tooltip-arrow-height);border-bottom-color:var(--bs-tooltip-bg)}.bs-tooltip-start .tooltip-arrow,.bs-tooltip-auto[data-popper-placement^=left] .tooltip-arrow{right:calc(-1 * var(--bs-tooltip-arrow-height));width:var(--bs-tooltip-arrow-height);height:var(--bs-tooltip-arrow-width)}.bs-tooltip-start .tooltip-arrow:before,.bs-tooltip-auto[data-popper-placement^=left] .tooltip-arrow:before{left:-1px;border-width:calc(var(--bs-tooltip-arrow-width) * .5) 0 calc(var(--bs-tooltip-arrow-width) * .5) var(--bs-tooltip-arrow-height);border-left-color:var(--bs-tooltip-bg)}.tooltip-inner{max-width:var(--bs-tooltip-max-width);padding:var(--bs-tooltip-padding-y) var(--bs-tooltip-padding-x);color:var(--bs-tooltip-color);text-align:center;background-color:var(--bs-tooltip-bg);border-radius:var(--bs-tooltip-border-radius)}.popover{--bs-popover-zindex: 1070;--bs-popover-max-width: 276px;--bs-popover-font-size: .875rem;--bs-popover-bg: var(--bs-body-bg);--bs-popover-border-width: var(--bs-border-width);--bs-popover-border-color: var(--bs-border-color-translucent);--bs-popover-border-radius: var(--bs-border-radius-lg);--bs-popover-inner-border-radius: calc(var(--bs-border-radius-lg) - var(--bs-border-width));--bs-popover-box-shadow: var(--bs-box-shadow);--bs-popover-header-padding-x: 1rem;--bs-popover-header-padding-y: .5rem;--bs-popover-header-font-size: 1rem;--bs-popover-header-color: inherit;--bs-popover-header-bg: var(--bs-secondary-bg);--bs-popover-body-padding-x: 1rem;--bs-popover-body-padding-y: 1rem;--bs-popover-body-color: var(--bs-body-color);--bs-popover-arrow-width: 1rem;--bs-popover-arrow-height: .5rem;--bs-popover-arrow-border: var(--bs-popover-border-color);z-index:var(--bs-popover-zindex);display:block;max-width:var(--bs-popover-max-width);font-family:var(--bs-font-sans-serif);font-style:normal;font-weight:400;line-height:1.5;text-align:left;text-align:start;text-decoration:none;text-shadow:none;text-transform:none;letter-spacing:normal;word-break:normal;white-space:normal;word-spacing:normal;line-break:auto;font-size:var(--bs-popover-font-size);word-wrap:break-word;background-color:var(--bs-popover-bg);background-clip:padding-box;border:var(--bs-popover-border-width) solid var(--bs-popover-border-color);border-radius:var(--bs-popover-border-radius)}.popover .popover-arrow{display:block;width:var(--bs-popover-arrow-width);height:var(--bs-popover-arrow-height)}.popover .popover-arrow:before,.popover .popover-arrow:after{position:absolute;display:block;content:"";border-color:transparent;border-style:solid;border-width:0}.bs-popover-top>.popover-arrow,.bs-popover-auto[data-popper-placement^=top]>.popover-arrow{bottom:calc(-1 * (var(--bs-popover-arrow-height)) - var(--bs-popover-border-width))}.bs-popover-top>.popover-arrow:before,.bs-popover-auto[data-popper-placement^=top]>.popover-arrow:before,.bs-popover-top>.popover-arrow:after,.bs-popover-auto[data-popper-placement^=top]>.popover-arrow:after{border-width:var(--bs-popover-arrow-height) calc(var(--bs-popover-arrow-width) * .5) 0}.bs-popover-top>.popover-arrow:before,.bs-popover-auto[data-popper-placement^=top]>.popover-arrow:before{bottom:0;border-top-color:var(--bs-popover-arrow-border)}.bs-popover-top>.popover-arrow:after,.bs-popover-auto[data-popper-placement^=top]>.popover-arrow:after{bottom:var(--bs-popover-border-width);border-top-color:var(--bs-popover-bg)}.bs-popover-end>.popover-arrow,.bs-popover-auto[data-popper-placement^=right]>.popover-arrow{left:calc(-1 * (var(--bs-popover-arrow-height)) - var(--bs-popover-border-width));width:var(--bs-popover-arrow-height);height:var(--bs-popover-arrow-width)}.bs-popover-end>.popover-arrow:before,.bs-popover-auto[data-popper-placement^=right]>.popover-arrow:before,.bs-popover-end>.popover-arrow:after,.bs-popover-auto[data-popper-placement^=right]>.popover-arrow:after{border-width:calc(var(--bs-popover-arrow-width) * .5) var(--bs-popover-arrow-height) calc(var(--bs-popover-arrow-width) * .5) 0}.bs-popover-end>.popover-arrow:before,.bs-popover-auto[data-popper-placement^=right]>.popover-arrow:before{left:0;border-right-color:var(--bs-popover-arrow-border)}.bs-popover-end>.popover-arrow:after,.bs-popover-auto[data-popper-placement^=right]>.popover-arrow:after{left:var(--bs-popover-border-width);border-right-color:var(--bs-popover-bg)}.bs-popover-bottom>.popover-arrow,.bs-popover-auto[data-popper-placement^=bottom]>.popover-arrow{top:calc(-1 * (var(--bs-popover-arrow-height)) - var(--bs-popover-border-width))}.bs-popover-bottom>.popover-arrow:before,.bs-popover-auto[data-popper-placement^=bottom]>.popover-arrow:before,.bs-popover-bottom>.popover-arrow:after,.bs-popover-auto[data-popper-placement^=bottom]>.popover-arrow:after{border-width:0 calc(var(--bs-popover-arrow-width) * .5) var(--bs-popover-arrow-height)}.bs-popover-bottom>.popover-arrow:before,.bs-popover-auto[data-popper-placement^=bottom]>.popover-arrow:before{top:0;border-bottom-color:var(--bs-popover-arrow-border)}.bs-popover-bottom>.popover-arrow:after,.bs-popover-auto[data-popper-placement^=bottom]>.popover-arrow:after{top:var(--bs-popover-border-width);border-bottom-color:var(--bs-popover-bg)}.bs-popover-bottom .popover-header:before,.bs-popover-auto[data-popper-placement^=bottom] .popover-header:before{position:absolute;top:0;left:50%;display:block;width:var(--bs-popover-arrow-width);margin-left:calc(-.5 * var(--bs-popover-arrow-width));content:"";border-bottom:var(--bs-popover-border-width) solid var(--bs-popover-header-bg)}.bs-popover-start>.popover-arrow,.bs-popover-auto[data-popper-placement^=left]>.popover-arrow{right:calc(-1 * (var(--bs-popover-arrow-height)) - var(--bs-popover-border-width));width:var(--bs-popover-arrow-height);height:var(--bs-popover-arrow-width)}.bs-popover-start>.popover-arrow:before,.bs-popover-auto[data-popper-placement^=left]>.popover-arrow:before,.bs-popover-start>.popover-arrow:after,.bs-popover-auto[data-popper-placement^=left]>.popover-arrow:after{border-width:calc(var(--bs-popover-arrow-width) * .5) 0 calc(var(--bs-popover-arrow-width) * .5) var(--bs-popover-arrow-height)}.bs-popover-start>.popover-arrow:before,.bs-popover-auto[data-popper-placement^=left]>.popover-arrow:before{right:0;border-left-color:var(--bs-popover-arrow-border)}.bs-popover-start>.popover-arrow:after,.bs-popover-auto[data-popper-placement^=left]>.popover-arrow:after{right:var(--bs-popover-border-width);border-left-color:var(--bs-popover-bg)}.popover-header{padding:var(--bs-popover-header-padding-y) var(--bs-popover-header-padding-x);margin-bottom:0;font-size:var(--bs-popover-header-font-size);color:var(--bs-popover-header-color);background-color:var(--bs-popover-header-bg);border-bottom:var(--bs-popover-border-width) solid var(--bs-popover-border-color);border-top-left-radius:var(--bs-popover-inner-border-radius);border-top-right-radius:var(--bs-popover-inner-border-radius)}.popover-header:empty{display:none}.popover-body{padding:var(--bs-popover-body-padding-y) var(--bs-popover-body-padding-x);color:var(--bs-popover-body-color)}.carousel{position:relative}.carousel.pointer-event{touch-action:pan-y}.carousel-inner{position:relative;width:100%;overflow:hidden}.carousel-inner:after{display:block;clear:both;content:""}.carousel-item{position:relative;display:none;float:left;width:100%;margin-right:-100%;backface-visibility:hidden;transition:transform .6s ease-in-out}@media (prefers-reduced-motion: reduce){.carousel-item{transition:none}}.carousel-item.active,.carousel-item-next,.carousel-item-prev{display:block}.carousel-item-next:not(.carousel-item-start),.active.carousel-item-end{transform:translate(100%)}.carousel-item-prev:not(.carousel-item-end),.active.carousel-item-start{transform:translate(-100%)}.carousel-fade .carousel-item{opacity:0;transition-property:opacity;transform:none}.carousel-fade .carousel-item.active,.carousel-fade .carousel-item-next.carousel-item-start,.carousel-fade .carousel-item-prev.carousel-item-end{z-index:1;opacity:1}.carousel-fade .active.carousel-item-start,.carousel-fade .active.carousel-item-end{z-index:0;opacity:0;transition:opacity 0s .6s}@media (prefers-reduced-motion: reduce){.carousel-fade .active.carousel-item-start,.carousel-fade .active.carousel-item-end{transition:none}}.carousel-control-prev,.carousel-control-next{position:absolute;top:0;bottom:0;z-index:1;display:flex;align-items:center;justify-content:center;width:15%;padding:0;color:#fff;text-align:center;background:none;filter:var(--bs-carousel-control-icon-filter);border:0;opacity:.5;transition:opacity .15s ease}@media (prefers-reduced-motion: reduce){.carousel-control-prev,.carousel-control-next{transition:none}}.carousel-control-prev:hover,.carousel-control-prev:focus,.carousel-control-next:hover,.carousel-control-next:focus{color:#fff;text-decoration:none;outline:0;opacity:.9}.carousel-control-prev{left:0}.carousel-control-next{right:0}.carousel-control-prev-icon,.carousel-control-next-icon{display:inline-block;width:2rem;height:2rem;background-repeat:no-repeat;background-position:50%;background-size:100% 100%}.carousel-control-prev-icon{background-image:url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16' fill='%23fff'%3e%3cpath d='M11.354 1.646a.5.5 0 0 1 0 .708L5.707 8l5.647 5.646a.5.5 0 0 1-.708.708l-6-6a.5.5 0 0 1 0-.708l6-6a.5.5 0 0 1 .708 0'/%3e%3c/svg%3e")}.carousel-control-next-icon{background-image:url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16' fill='%23fff'%3e%3cpath d='M4.646 1.646a.5.5 0 0 1 .708 0l6 6a.5.5 0 0 1 0 .708l-6 6a.5.5 0 0 1-.708-.708L10.293 8 4.646 2.354a.5.5 0 0 1 0-.708'/%3e%3c/svg%3e")}.carousel-indicators{position:absolute;right:0;bottom:0;left:0;z-index:2;display:flex;justify-content:center;padding:0;margin-right:15%;margin-bottom:1rem;margin-left:15%}.carousel-indicators [data-bs-target]{box-sizing:content-box;flex:0 1 auto;width:30px;height:3px;padding:0;margin-right:3px;margin-left:3px;text-indent:-999px;cursor:pointer;background-color:var(--bs-carousel-indicator-active-bg);background-clip:padding-box;border:0;border-top:10px solid transparent;border-bottom:10px solid transparent;opacity:.5;transition:opacity .6s ease}@media (prefers-reduced-motion: reduce){.carousel-indicators [data-bs-target]{transition:none}}.carousel-indicators .active{opacity:1}.carousel-caption{position:absolute;right:15%;bottom:1.25rem;left:15%;padding-top:1.25rem;padding-bottom:1.25rem;color:var(--bs-carousel-caption-color);text-align:center}.carousel-dark{--bs-carousel-indicator-active-bg: #000;--bs-carousel-caption-color: #000;--bs-carousel-control-icon-filter: invert(1) grayscale(100)}:root,[data-bs-theme=light]{--bs-carousel-indicator-active-bg: #fff;--bs-carousel-caption-color: #fff;--bs-carousel-control-icon-filter: }[data-bs-theme=dark]{--bs-carousel-indicator-active-bg: #000;--bs-carousel-caption-color: #000;--bs-carousel-control-icon-filter: invert(1) grayscale(100)}.spinner-grow,.spinner-border{display:inline-block;flex-shrink:0;width:var(--bs-spinner-width);height:var(--bs-spinner-height);vertical-align:var(--bs-spinner-vertical-align);border-radius:50%;animation:var(--bs-spinner-animation-speed) linear infinite var(--bs-spinner-animation-name)}@keyframes spinner-border{to{transform:rotate(360deg)}}.spinner-border{--bs-spinner-width: 2rem;--bs-spinner-height: 2rem;--bs-spinner-vertical-align: -.125em;--bs-spinner-border-width: .25em;--bs-spinner-animation-speed: .75s;--bs-spinner-animation-name: spinner-border;border:var(--bs-spinner-border-width) solid currentcolor;border-right-color:transparent}.spinner-border-sm{--bs-spinner-width: 1rem;--bs-spinner-height: 1rem;--bs-spinner-border-width: .2em}@keyframes spinner-grow{0%{transform:scale(0)}50%{opacity:1;transform:none}}.spinner-grow{--bs-spinner-width: 2rem;--bs-spinner-height: 2rem;--bs-spinner-vertical-align: -.125em;--bs-spinner-animation-speed: .75s;--bs-spinner-animation-name: spinner-grow;background-color:currentcolor;opacity:0}.spinner-grow-sm{--bs-spinner-width: 1rem;--bs-spinner-height: 1rem}@media (prefers-reduced-motion: reduce){.spinner-border,.spinner-grow{--bs-spinner-animation-speed: 1.5s}}.offcanvas,.offcanvas-xxl,.offcanvas-xl,.offcanvas-lg,.offcanvas-md,.offcanvas-sm{--bs-offcanvas-zindex: 1045;--bs-offcanvas-width: 400px;--bs-offcanvas-height: 30vh;--bs-offcanvas-padding-x: 1rem;--bs-offcanvas-padding-y: 1rem;--bs-offcanvas-color: var(--bs-body-color);--bs-offcanvas-bg: var(--bs-body-bg);--bs-offcanvas-border-width: var(--bs-border-width);--bs-offcanvas-border-color: var(--bs-border-color-translucent);--bs-offcanvas-box-shadow: var(--bs-box-shadow-sm);--bs-offcanvas-transition: transform .3s ease-in-out;--bs-offcanvas-title-line-height: 1.5}@media (max-width: 575.98px){.offcanvas-sm{position:fixed;bottom:0;z-index:var(--bs-offcanvas-zindex);display:flex;flex-direction:column;max-width:100%;color:var(--bs-offcanvas-color);visibility:hidden;background-color:var(--bs-offcanvas-bg);background-clip:padding-box;outline:0;transition:var(--bs-offcanvas-transition)}}@media (max-width: 575.98px) and (prefers-reduced-motion: reduce){.offcanvas-sm{transition:none}}@media (max-width: 575.98px){.offcanvas-sm.offcanvas-start{top:0;left:0;width:var(--bs-offcanvas-width);border-right:var(--bs-offcanvas-border-width) solid var(--bs-offcanvas-border-color);transform:translate(-100%)}.offcanvas-sm.offcanvas-end{top:0;right:0;width:var(--bs-offcanvas-width);border-left:var(--bs-offcanvas-border-width) solid var(--bs-offcanvas-border-color);transform:translate(100%)}.offcanvas-sm.offcanvas-top{top:0;right:0;left:0;height:var(--bs-offcanvas-height);max-height:100%;border-bottom:var(--bs-offcanvas-border-width) solid var(--bs-offcanvas-border-color);transform:translateY(-100%)}.offcanvas-sm.offcanvas-bottom{right:0;left:0;height:var(--bs-offcanvas-height);max-height:100%;border-top:var(--bs-offcanvas-border-width) solid var(--bs-offcanvas-border-color);transform:translateY(100%)}.offcanvas-sm.showing,.offcanvas-sm.show:not(.hiding){transform:none}.offcanvas-sm.showing,.offcanvas-sm.hiding,.offcanvas-sm.show{visibility:visible}}@media (min-width: 576px){.offcanvas-sm{--bs-offcanvas-height: auto;--bs-offcanvas-border-width: 0;background-color:transparent!important}.offcanvas-sm .offcanvas-header{display:none}.offcanvas-sm .offcanvas-body{display:flex;flex-grow:0;padding:0;overflow-y:visible;background-color:transparent!important}}@media (max-width: 767.98px){.offcanvas-md{position:fixed;bottom:0;z-index:var(--bs-offcanvas-zindex);display:flex;flex-direction:column;max-width:100%;color:var(--bs-offcanvas-color);visibility:hidden;background-color:var(--bs-offcanvas-bg);background-clip:padding-box;outline:0;transition:var(--bs-offcanvas-transition)}}@media (max-width: 767.98px) and (prefers-reduced-motion: reduce){.offcanvas-md{transition:none}}@media (max-width: 767.98px){.offcanvas-md.offcanvas-start{top:0;left:0;width:var(--bs-offcanvas-width);border-right:var(--bs-offcanvas-border-width) solid var(--bs-offcanvas-border-color);transform:translate(-100%)}.offcanvas-md.offcanvas-end{top:0;right:0;width:var(--bs-offcanvas-width);border-left:var(--bs-offcanvas-border-width) solid var(--bs-offcanvas-border-color);transform:translate(100%)}.offcanvas-md.offcanvas-top{top:0;right:0;left:0;height:var(--bs-offcanvas-height);max-height:100%;border-bottom:var(--bs-offcanvas-border-width) solid var(--bs-offcanvas-border-color);transform:translateY(-100%)}.offcanvas-md.offcanvas-bottom{right:0;left:0;height:var(--bs-offcanvas-height);max-height:100%;border-top:var(--bs-offcanvas-border-width) solid var(--bs-offcanvas-border-color);transform:translateY(100%)}.offcanvas-md.showing,.offcanvas-md.show:not(.hiding){transform:none}.offcanvas-md.showing,.offcanvas-md.hiding,.offcanvas-md.show{visibility:visible}}@media (min-width: 768px){.offcanvas-md{--bs-offcanvas-height: auto;--bs-offcanvas-border-width: 0;background-color:transparent!important}.offcanvas-md .offcanvas-header{display:none}.offcanvas-md .offcanvas-body{display:flex;flex-grow:0;padding:0;overflow-y:visible;background-color:transparent!important}}@media (max-width: 991.98px){.offcanvas-lg{position:fixed;bottom:0;z-index:var(--bs-offcanvas-zindex);display:flex;flex-direction:column;max-width:100%;color:var(--bs-offcanvas-color);visibility:hidden;background-color:var(--bs-offcanvas-bg);background-clip:padding-box;outline:0;transition:var(--bs-offcanvas-transition)}}@media (max-width: 991.98px) and (prefers-reduced-motion: reduce){.offcanvas-lg{transition:none}}@media (max-width: 991.98px){.offcanvas-lg.offcanvas-start{top:0;left:0;width:var(--bs-offcanvas-width);border-right:var(--bs-offcanvas-border-width) solid var(--bs-offcanvas-border-color);transform:translate(-100%)}.offcanvas-lg.offcanvas-end{top:0;right:0;width:var(--bs-offcanvas-width);border-left:var(--bs-offcanvas-border-width) solid var(--bs-offcanvas-border-color);transform:translate(100%)}.offcanvas-lg.offcanvas-top{top:0;right:0;left:0;height:var(--bs-offcanvas-height);max-height:100%;border-bottom:var(--bs-offcanvas-border-width) solid var(--bs-offcanvas-border-color);transform:translateY(-100%)}.offcanvas-lg.offcanvas-bottom{right:0;left:0;height:var(--bs-offcanvas-height);max-height:100%;border-top:var(--bs-offcanvas-border-width) solid var(--bs-offcanvas-border-color);transform:translateY(100%)}.offcanvas-lg.showing,.offcanvas-lg.show:not(.hiding){transform:none}.offcanvas-lg.showing,.offcanvas-lg.hiding,.offcanvas-lg.show{visibility:visible}}@media (min-width: 992px){.offcanvas-lg{--bs-offcanvas-height: auto;--bs-offcanvas-border-width: 0;background-color:transparent!important}.offcanvas-lg .offcanvas-header{display:none}.offcanvas-lg .offcanvas-body{display:flex;flex-grow:0;padding:0;overflow-y:visible;background-color:transparent!important}}@media (max-width: 1199.98px){.offcanvas-xl{position:fixed;bottom:0;z-index:var(--bs-offcanvas-zindex);display:flex;flex-direction:column;max-width:100%;color:var(--bs-offcanvas-color);visibility:hidden;background-color:var(--bs-offcanvas-bg);background-clip:padding-box;outline:0;transition:var(--bs-offcanvas-transition)}}@media (max-width: 1199.98px) and (prefers-reduced-motion: reduce){.offcanvas-xl{transition:none}}@media (max-width: 1199.98px){.offcanvas-xl.offcanvas-start{top:0;left:0;width:var(--bs-offcanvas-width);border-right:var(--bs-offcanvas-border-width) solid var(--bs-offcanvas-border-color);transform:translate(-100%)}.offcanvas-xl.offcanvas-end{top:0;right:0;width:var(--bs-offcanvas-width);border-left:var(--bs-offcanvas-border-width) solid var(--bs-offcanvas-border-color);transform:translate(100%)}.offcanvas-xl.offcanvas-top{top:0;right:0;left:0;height:var(--bs-offcanvas-height);max-height:100%;border-bottom:var(--bs-offcanvas-border-width) solid var(--bs-offcanvas-border-color);transform:translateY(-100%)}.offcanvas-xl.offcanvas-bottom{right:0;left:0;height:var(--bs-offcanvas-height);max-height:100%;border-top:var(--bs-offcanvas-border-width) solid var(--bs-offcanvas-border-color);transform:translateY(100%)}.offcanvas-xl.showing,.offcanvas-xl.show:not(.hiding){transform:none}.offcanvas-xl.showing,.offcanvas-xl.hiding,.offcanvas-xl.show{visibility:visible}}@media (min-width: 1200px){.offcanvas-xl{--bs-offcanvas-height: auto;--bs-offcanvas-border-width: 0;background-color:transparent!important}.offcanvas-xl .offcanvas-header{display:none}.offcanvas-xl .offcanvas-body{display:flex;flex-grow:0;padding:0;overflow-y:visible;background-color:transparent!important}}@media (max-width: 1399.98px){.offcanvas-xxl{position:fixed;bottom:0;z-index:var(--bs-offcanvas-zindex);display:flex;flex-direction:column;max-width:100%;color:var(--bs-offcanvas-color);visibility:hidden;background-color:var(--bs-offcanvas-bg);background-clip:padding-box;outline:0;transition:var(--bs-offcanvas-transition)}}@media (max-width: 1399.98px) and (prefers-reduced-motion: reduce){.offcanvas-xxl{transition:none}}@media (max-width: 1399.98px){.offcanvas-xxl.offcanvas-start{top:0;left:0;width:var(--bs-offcanvas-width);border-right:var(--bs-offcanvas-border-width) solid var(--bs-offcanvas-border-color);transform:translate(-100%)}.offcanvas-xxl.offcanvas-end{top:0;right:0;width:var(--bs-offcanvas-width);border-left:var(--bs-offcanvas-border-width) solid var(--bs-offcanvas-border-color);transform:translate(100%)}.offcanvas-xxl.offcanvas-top{top:0;right:0;left:0;height:var(--bs-offcanvas-height);max-height:100%;border-bottom:var(--bs-offcanvas-border-width) solid var(--bs-offcanvas-border-color);transform:translateY(-100%)}.offcanvas-xxl.offcanvas-bottom{right:0;left:0;height:var(--bs-offcanvas-height);max-height:100%;border-top:var(--bs-offcanvas-border-width) solid var(--bs-offcanvas-border-color);transform:translateY(100%)}.offcanvas-xxl.showing,.offcanvas-xxl.show:not(.hiding){transform:none}.offcanvas-xxl.showing,.offcanvas-xxl.hiding,.offcanvas-xxl.show{visibility:visible}}@media (min-width: 1400px){.offcanvas-xxl{--bs-offcanvas-height: auto;--bs-offcanvas-border-width: 0;background-color:transparent!important}.offcanvas-xxl .offcanvas-header{display:none}.offcanvas-xxl .offcanvas-body{display:flex;flex-grow:0;padding:0;overflow-y:visible;background-color:transparent!important}}.offcanvas{position:fixed;bottom:0;z-index:var(--bs-offcanvas-zindex);display:flex;flex-direction:column;max-width:100%;color:var(--bs-offcanvas-color);visibility:hidden;background-color:var(--bs-offcanvas-bg);background-clip:padding-box;outline:0;transition:var(--bs-offcanvas-transition)}@media (prefers-reduced-motion: reduce){.offcanvas{transition:none}}.offcanvas.offcanvas-start{top:0;left:0;width:var(--bs-offcanvas-width);border-right:var(--bs-offcanvas-border-width) solid var(--bs-offcanvas-border-color);transform:translate(-100%)}.offcanvas.offcanvas-end{top:0;right:0;width:var(--bs-offcanvas-width);border-left:var(--bs-offcanvas-border-width) solid var(--bs-offcanvas-border-color);transform:translate(100%)}.offcanvas.offcanvas-top{top:0;right:0;left:0;height:var(--bs-offcanvas-height);max-height:100%;border-bottom:var(--bs-offcanvas-border-width) solid var(--bs-offcanvas-border-color);transform:translateY(-100%)}.offcanvas.offcanvas-bottom{right:0;left:0;height:var(--bs-offcanvas-height);max-height:100%;border-top:var(--bs-offcanvas-border-width) solid var(--bs-offcanvas-border-color);transform:translateY(100%)}.offcanvas.showing,.offcanvas.show:not(.hiding){transform:none}.offcanvas.showing,.offcanvas.hiding,.offcanvas.show{visibility:visible}.offcanvas-backdrop{position:fixed;top:0;left:0;z-index:1040;width:100vw;height:100vh;background-color:#000}.offcanvas-backdrop.fade{opacity:0}.offcanvas-backdrop.show{opacity:.5}.offcanvas-header{display:flex;align-items:center;padding:var(--bs-offcanvas-padding-y) var(--bs-offcanvas-padding-x)}.offcanvas-header .btn-close{padding:calc(var(--bs-offcanvas-padding-y) * .5) calc(var(--bs-offcanvas-padding-x) * .5);margin-top:calc(-.5 * var(--bs-offcanvas-padding-y));margin-right:calc(-.5 * var(--bs-offcanvas-padding-x));margin-bottom:calc(-.5 * var(--bs-offcanvas-padding-y));margin-left:auto}.offcanvas-title{margin-bottom:0;line-height:var(--bs-offcanvas-title-line-height)}.offcanvas-body{flex-grow:1;padding:var(--bs-offcanvas-padding-y) var(--bs-offcanvas-padding-x);overflow-y:auto}.placeholder{display:inline-block;min-height:1em;vertical-align:middle;cursor:wait;background-color:currentcolor;opacity:.5}.placeholder.btn:before{display:inline-block;content:""}.placeholder-xs{min-height:.6em}.placeholder-sm{min-height:.8em}.placeholder-lg{min-height:1.2em}.placeholder-glow .placeholder{animation:placeholder-glow 2s ease-in-out infinite}@keyframes placeholder-glow{50%{opacity:.2}}.placeholder-wave{mask-image:linear-gradient(130deg,#000 55%,#000c,#000 95%);mask-size:200% 100%;animation:placeholder-wave 2s linear infinite}@keyframes placeholder-wave{to{mask-position:-200% 0%}}.clearfix:after{display:block;clear:both;content:""}.text-bg-primary{color:#fff!important;background-color:RGBA(var(--bs-primary-rgb),var(--bs-bg-opacity, 1))!important}.text-bg-secondary{color:#fff!important;background-color:RGBA(var(--bs-secondary-rgb),var(--bs-bg-opacity, 1))!important}.text-bg-success{color:#fff!important;background-color:RGBA(var(--bs-success-rgb),var(--bs-bg-opacity, 1))!important}.text-bg-info{color:#000!important;background-color:RGBA(var(--bs-info-rgb),var(--bs-bg-opacity, 1))!important}.text-bg-warning{color:#000!important;background-color:RGBA(var(--bs-warning-rgb),var(--bs-bg-opacity, 1))!important}.text-bg-danger{color:#fff!important;background-color:RGBA(var(--bs-danger-rgb),var(--bs-bg-opacity, 1))!important}.text-bg-light{color:#000!important;background-color:RGBA(var(--bs-light-rgb),var(--bs-bg-opacity, 1))!important}.text-bg-dark{color:#fff!important;background-color:RGBA(var(--bs-dark-rgb),var(--bs-bg-opacity, 1))!important}.link-primary{color:RGBA(var(--bs-primary-rgb),var(--bs-link-opacity, 1))!important;text-decoration-color:RGBA(var(--bs-primary-rgb),var(--bs-link-underline-opacity, 1))!important}.link-primary:hover,.link-primary:focus{color:RGBA(10,88,202,var(--bs-link-opacity, 1))!important;text-decoration-color:RGBA(10,88,202,var(--bs-link-underline-opacity, 1))!important}.link-secondary{color:RGBA(var(--bs-secondary-rgb),var(--bs-link-opacity, 1))!important;text-decoration-color:RGBA(var(--bs-secondary-rgb),var(--bs-link-underline-opacity, 1))!important}.link-secondary:hover,.link-secondary:focus{color:RGBA(86,94,100,var(--bs-link-opacity, 1))!important;text-decoration-color:RGBA(86,94,100,var(--bs-link-underline-opacity, 1))!important}.link-success{color:RGBA(var(--bs-success-rgb),var(--bs-link-opacity, 1))!important;text-decoration-color:RGBA(var(--bs-success-rgb),var(--bs-link-underline-opacity, 1))!important}.link-success:hover,.link-success:focus{color:RGBA(20,108,67,var(--bs-link-opacity, 1))!important;text-decoration-color:RGBA(20,108,67,var(--bs-link-underline-opacity, 1))!important}.link-info{color:RGBA(var(--bs-info-rgb),var(--bs-link-opacity, 1))!important;text-decoration-color:RGBA(var(--bs-info-rgb),var(--bs-link-underline-opacity, 1))!important}.link-info:hover,.link-info:focus{color:RGBA(61,213,243,var(--bs-link-opacity, 1))!important;text-decoration-color:RGBA(61,213,243,var(--bs-link-underline-opacity, 1))!important}.link-warning{color:RGBA(var(--bs-warning-rgb),var(--bs-link-opacity, 1))!important;text-decoration-color:RGBA(var(--bs-warning-rgb),var(--bs-link-underline-opacity, 1))!important}.link-warning:hover,.link-warning:focus{color:RGBA(255,205,57,var(--bs-link-opacity, 1))!important;text-decoration-color:RGBA(255,205,57,var(--bs-link-underline-opacity, 1))!important}.link-danger{color:RGBA(var(--bs-danger-rgb),var(--bs-link-opacity, 1))!important;text-decoration-color:RGBA(var(--bs-danger-rgb),var(--bs-link-underline-opacity, 1))!important}.link-danger:hover,.link-danger:focus{color:RGBA(176,42,55,var(--bs-link-opacity, 1))!important;text-decoration-color:RGBA(176,42,55,var(--bs-link-underline-opacity, 1))!important}.link-light{color:RGBA(var(--bs-light-rgb),var(--bs-link-opacity, 1))!important;text-decoration-color:RGBA(var(--bs-light-rgb),var(--bs-link-underline-opacity, 1))!important}.link-light:hover,.link-light:focus{color:RGBA(249,250,251,var(--bs-link-opacity, 1))!important;text-decoration-color:RGBA(249,250,251,var(--bs-link-underline-opacity, 1))!important}.link-dark{color:RGBA(var(--bs-dark-rgb),var(--bs-link-opacity, 1))!important;text-decoration-color:RGBA(var(--bs-dark-rgb),var(--bs-link-underline-opacity, 1))!important}.link-dark:hover,.link-dark:focus{color:RGBA(26,30,33,var(--bs-link-opacity, 1))!important;text-decoration-color:RGBA(26,30,33,var(--bs-link-underline-opacity, 1))!important}.link-body-emphasis{color:RGBA(var(--bs-emphasis-color-rgb),var(--bs-link-opacity, 1))!important;text-decoration-color:RGBA(var(--bs-emphasis-color-rgb),var(--bs-link-underline-opacity, 1))!important}.link-body-emphasis:hover,.link-body-emphasis:focus{color:RGBA(var(--bs-emphasis-color-rgb),var(--bs-link-opacity, .75))!important;text-decoration-color:RGBA(var(--bs-emphasis-color-rgb),var(--bs-link-underline-opacity, .75))!important}.focus-ring:focus{outline:0;box-shadow:var(--bs-focus-ring-x, 0) var(--bs-focus-ring-y, 0) var(--bs-focus-ring-blur, 0) var(--bs-focus-ring-width) var(--bs-focus-ring-color)}.icon-link{display:inline-flex;gap:.375rem;align-items:center;text-decoration-color:rgba(var(--bs-link-color-rgb),var(--bs-link-opacity, .5));text-underline-offset:.25em;backface-visibility:hidden}.icon-link>.bi{flex-shrink:0;width:1em;height:1em;fill:currentcolor;transition:.2s ease-in-out transform}@media (prefers-reduced-motion: reduce){.icon-link>.bi{transition:none}}.icon-link-hover:hover>.bi,.icon-link-hover:focus-visible>.bi{transform:var(--bs-icon-link-transform, translate3d(.25em, 0, 0))}.ratio{position:relative;width:100%}.ratio:before{display:block;padding-top:var(--bs-aspect-ratio);content:""}.ratio>*{position:absolute;top:0;left:0;width:100%;height:100%}.ratio-1x1{--bs-aspect-ratio: 100%}.ratio-4x3{--bs-aspect-ratio: 75%}.ratio-16x9{--bs-aspect-ratio: 56.25%}.ratio-21x9{--bs-aspect-ratio: 42.8571428571%}.fixed-top{position:fixed;top:0;right:0;left:0;z-index:1030}.fixed-bottom{position:fixed;right:0;bottom:0;left:0;z-index:1030}.sticky-top{position:sticky;top:0;z-index:1020}.sticky-bottom{position:sticky;bottom:0;z-index:1020}@media (min-width: 576px){.sticky-sm-top{position:sticky;top:0;z-index:1020}.sticky-sm-bottom{position:sticky;bottom:0;z-index:1020}}@media (min-width: 768px){.sticky-md-top{position:sticky;top:0;z-index:1020}.sticky-md-bottom{position:sticky;bottom:0;z-index:1020}}@media (min-width: 992px){.sticky-lg-top{position:sticky;top:0;z-index:1020}.sticky-lg-bottom{position:sticky;bottom:0;z-index:1020}}@media (min-width: 1200px){.sticky-xl-top{position:sticky;top:0;z-index:1020}.sticky-xl-bottom{position:sticky;bottom:0;z-index:1020}}@media (min-width: 1400px){.sticky-xxl-top{position:sticky;top:0;z-index:1020}.sticky-xxl-bottom{position:sticky;bottom:0;z-index:1020}}.hstack{display:flex;flex-direction:row;align-items:center;align-self:stretch}.vstack{display:flex;flex:1 1 auto;flex-direction:column;align-self:stretch}.visually-hidden,.visually-hidden-focusable:not(:focus):not(:focus-within){width:1px!important;height:1px!important;padding:0!important;margin:-1px!important;overflow:hidden!important;clip:rect(0,0,0,0)!important;white-space:nowrap!important;border:0!important}.visually-hidden:not(caption),.visually-hidden-focusable:not(:focus):not(:focus-within):not(caption){position:absolute!important}.visually-hidden *,.visually-hidden-focusable:not(:focus):not(:focus-within) *{overflow:hidden!important}.stretched-link:after{position:absolute;inset:0;z-index:1;content:""}.text-truncate{overflow:hidden;text-overflow:ellipsis;white-space:nowrap}.vr{display:inline-block;align-self:stretch;width:var(--bs-border-width);min-height:1em;background-color:currentcolor;opacity:.25}.align-baseline{vertical-align:baseline!important}.align-top{vertical-align:top!important}.align-middle{vertical-align:middle!important}.align-bottom{vertical-align:bottom!important}.align-text-bottom{vertical-align:text-bottom!important}.align-text-top{vertical-align:text-top!important}.float-start{float:left!important}.float-end{float:right!important}.float-none{float:none!important}.object-fit-contain{object-fit:contain!important}.object-fit-cover{object-fit:cover!important}.object-fit-fill{object-fit:fill!important}.object-fit-scale{object-fit:scale-down!important}.object-fit-none{object-fit:none!important}.opacity-0{opacity:0!important}.opacity-25{opacity:.25!important}.opacity-50{opacity:.5!important}.opacity-75{opacity:.75!important}.opacity-100{opacity:1!important}.overflow-auto{overflow:auto!important}.overflow-hidden{overflow:hidden!important}.overflow-visible{overflow:visible!important}.overflow-scroll{overflow:scroll!important}.overflow-x-auto{overflow-x:auto!important}.overflow-x-hidden{overflow-x:hidden!important}.overflow-x-visible{overflow-x:visible!important}.overflow-x-scroll{overflow-x:scroll!important}.overflow-y-auto{overflow-y:auto!important}.overflow-y-hidden{overflow-y:hidden!important}.overflow-y-visible{overflow-y:visible!important}.overflow-y-scroll{overflow-y:scroll!important}.d-inline{display:inline!important}.d-inline-block{display:inline-block!important}.d-block{display:block!important}.d-grid{display:grid!important}.d-inline-grid{display:inline-grid!important}.d-table{display:table!important}.d-table-row{display:table-row!important}.d-table-cell{display:table-cell!important}.d-flex{display:flex!important}.d-inline-flex{display:inline-flex!important}.d-none{display:none!important}.shadow{box-shadow:var(--bs-box-shadow)!important}.shadow-sm{box-shadow:var(--bs-box-shadow-sm)!important}.shadow-lg{box-shadow:var(--bs-box-shadow-lg)!important}.shadow-none{box-shadow:none!important}.focus-ring-primary{--bs-focus-ring-color: rgba(var(--bs-primary-rgb), var(--bs-focus-ring-opacity))}.focus-ring-secondary{--bs-focus-ring-color: rgba(var(--bs-secondary-rgb), var(--bs-focus-ring-opacity))}.focus-ring-success{--bs-focus-ring-color: rgba(var(--bs-success-rgb), var(--bs-focus-ring-opacity))}.focus-ring-info{--bs-focus-ring-color: rgba(var(--bs-info-rgb), var(--bs-focus-ring-opacity))}.focus-ring-warning{--bs-focus-ring-color: rgba(var(--bs-warning-rgb), var(--bs-focus-ring-opacity))}.focus-ring-danger{--bs-focus-ring-color: rgba(var(--bs-danger-rgb), var(--bs-focus-ring-opacity))}.focus-ring-light{--bs-focus-ring-color: rgba(var(--bs-light-rgb), var(--bs-focus-ring-opacity))}.focus-ring-dark{--bs-focus-ring-color: rgba(var(--bs-dark-rgb), var(--bs-focus-ring-opacity))}.position-static{position:static!important}.position-relative{position:relative!important}.position-absolute{position:absolute!important}.position-fixed{position:fixed!important}.position-sticky{position:sticky!important}.top-0{top:0!important}.top-50{top:50%!important}.top-100{top:100%!important}.bottom-0{bottom:0!important}.bottom-50{bottom:50%!important}.bottom-100{bottom:100%!important}.start-0{left:0!important}.start-50{left:50%!important}.start-100{left:100%!important}.end-0{right:0!important}.end-50{right:50%!important}.end-100{right:100%!important}.translate-middle{transform:translate(-50%,-50%)!important}.translate-middle-x{transform:translate(-50%)!important}.translate-middle-y{transform:translateY(-50%)!important}.border{border:var(--bs-border-width) var(--bs-border-style) var(--bs-border-color)!important}.border-0{border:0!important}.border-top{border-top:var(--bs-border-width) var(--bs-border-style) var(--bs-border-color)!important}.border-top-0{border-top:0!important}.border-end{border-right:var(--bs-border-width) var(--bs-border-style) var(--bs-border-color)!important}.border-end-0{border-right:0!important}.border-bottom{border-bottom:var(--bs-border-width) var(--bs-border-style) var(--bs-border-color)!important}.border-bottom-0{border-bottom:0!important}.border-start{border-left:var(--bs-border-width) var(--bs-border-style) var(--bs-border-color)!important}.border-start-0{border-left:0!important}.border-primary{--bs-border-opacity: 1;border-color:rgba(var(--bs-primary-rgb),var(--bs-border-opacity))!important}.border-secondary{--bs-border-opacity: 1;border-color:rgba(var(--bs-secondary-rgb),var(--bs-border-opacity))!important}.border-success{--bs-border-opacity: 1;border-color:rgba(var(--bs-success-rgb),var(--bs-border-opacity))!important}.border-info{--bs-border-opacity: 1;border-color:rgba(var(--bs-info-rgb),var(--bs-border-opacity))!important}.border-warning{--bs-border-opacity: 1;border-color:rgba(var(--bs-warning-rgb),var(--bs-border-opacity))!important}.border-danger{--bs-border-opacity: 1;border-color:rgba(var(--bs-danger-rgb),var(--bs-border-opacity))!important}.border-light{--bs-border-opacity: 1;border-color:rgba(var(--bs-light-rgb),var(--bs-border-opacity))!important}.border-dark{--bs-border-opacity: 1;border-color:rgba(var(--bs-dark-rgb),var(--bs-border-opacity))!important}.border-black{--bs-border-opacity: 1;border-color:rgba(var(--bs-black-rgb),var(--bs-border-opacity))!important}.border-white{--bs-border-opacity: 1;border-color:rgba(var(--bs-white-rgb),var(--bs-border-opacity))!important}.border-primary-subtle{border-color:var(--bs-primary-border-subtle)!important}.border-secondary-subtle{border-color:var(--bs-secondary-border-subtle)!important}.border-success-subtle{border-color:var(--bs-success-border-subtle)!important}.border-info-subtle{border-color:var(--bs-info-border-subtle)!important}.border-warning-subtle{border-color:var(--bs-warning-border-subtle)!important}.border-danger-subtle{border-color:var(--bs-danger-border-subtle)!important}.border-light-subtle{border-color:var(--bs-light-border-subtle)!important}.border-dark-subtle{border-color:var(--bs-dark-border-subtle)!important}.border-1{border-width:1px!important}.border-2{border-width:2px!important}.border-3{border-width:3px!important}.border-4{border-width:4px!important}.border-5{border-width:5px!important}.border-opacity-10{--bs-border-opacity: .1}.border-opacity-25{--bs-border-opacity: .25}.border-opacity-50{--bs-border-opacity: .5}.border-opacity-75{--bs-border-opacity: .75}.border-opacity-100{--bs-border-opacity: 1}.w-25{width:25%!important}.w-50{width:50%!important}.w-75{width:75%!important}.w-100{width:100%!important}.w-auto{width:auto!important}.mw-100{max-width:100%!important}.vw-100{width:100vw!important}.min-vw-100{min-width:100vw!important}.h-25{height:25%!important}.h-50{height:50%!important}.h-75{height:75%!important}.h-100{height:100%!important}.h-auto{height:auto!important}.mh-100{max-height:100%!important}.vh-100{height:100vh!important}.min-vh-100{min-height:100vh!important}.flex-fill{flex:1 1 auto!important}.flex-row{flex-direction:row!important}.flex-column{flex-direction:column!important}.flex-row-reverse{flex-direction:row-reverse!important}.flex-column-reverse{flex-direction:column-reverse!important}.flex-grow-0{flex-grow:0!important}.flex-grow-1{flex-grow:1!important}.flex-shrink-0{flex-shrink:0!important}.flex-shrink-1{flex-shrink:1!important}.flex-wrap{flex-wrap:wrap!important}.flex-nowrap{flex-wrap:nowrap!important}.flex-wrap-reverse{flex-wrap:wrap-reverse!important}.justify-content-start{justify-content:flex-start!important}.justify-content-end{justify-content:flex-end!important}.justify-content-center{justify-content:center!important}.justify-content-between{justify-content:space-between!important}.justify-content-around{justify-content:space-around!important}.justify-content-evenly{justify-content:space-evenly!important}.align-items-start{align-items:flex-start!important}.align-items-end{align-items:flex-end!important}.align-items-center{align-items:center!important}.align-items-baseline{align-items:baseline!important}.align-items-stretch{align-items:stretch!important}.align-content-start{align-content:flex-start!important}.align-content-end{align-content:flex-end!important}.align-content-center{align-content:center!important}.align-content-between{align-content:space-between!important}.align-content-around{align-content:space-around!important}.align-content-stretch{align-content:stretch!important}.align-self-auto{align-self:auto!important}.align-self-start{align-self:flex-start!important}.align-self-end{align-self:flex-end!important}.align-self-center{align-self:center!important}.align-self-baseline{align-self:baseline!important}.align-self-stretch{align-self:stretch!important}.order-first{order:-1!important}.order-0{order:0!important}.order-1{order:1!important}.order-2{order:2!important}.order-3{order:3!important}.order-4{order:4!important}.order-5{order:5!important}.order-last{order:6!important}.m-0{margin:0!important}.m-1{margin:.25rem!important}.m-2{margin:.5rem!important}.m-3{margin:1rem!important}.m-4{margin:1.5rem!important}.m-5{margin:3rem!important}.m-auto{margin:auto!important}.mx-0{margin-right:0!important;margin-left:0!important}.mx-1{margin-right:.25rem!important;margin-left:.25rem!important}.mx-2{margin-right:.5rem!important;margin-left:.5rem!important}.mx-3{margin-right:1rem!important;margin-left:1rem!important}.mx-4{margin-right:1.5rem!important;margin-left:1.5rem!important}.mx-5{margin-right:3rem!important;margin-left:3rem!important}.mx-auto{margin-right:auto!important;margin-left:auto!important}.my-0{margin-top:0!important;margin-bottom:0!important}.my-1{margin-top:.25rem!important;margin-bottom:.25rem!important}.my-2{margin-top:.5rem!important;margin-bottom:.5rem!important}.my-3{margin-top:1rem!important;margin-bottom:1rem!important}.my-4{margin-top:1.5rem!important;margin-bottom:1.5rem!important}.my-5{margin-top:3rem!important;margin-bottom:3rem!important}.my-auto{margin-top:auto!important;margin-bottom:auto!important}.mt-0{margin-top:0!important}.mt-1{margin-top:.25rem!important}.mt-2{margin-top:.5rem!important}.mt-3{margin-top:1rem!important}.mt-4{margin-top:1.5rem!important}.mt-5{margin-top:3rem!important}.mt-auto{margin-top:auto!important}.me-0{margin-right:0!important}.me-1{margin-right:.25rem!important}.me-2{margin-right:.5rem!important}.me-3{margin-right:1rem!important}.me-4{margin-right:1.5rem!important}.me-5{margin-right:3rem!important}.me-auto{margin-right:auto!important}.mb-0{margin-bottom:0!important}.mb-1{margin-bottom:.25rem!important}.mb-2{margin-bottom:.5rem!important}.mb-3{margin-bottom:1rem!important}.mb-4{margin-bottom:1.5rem!important}.mb-5{margin-bottom:3rem!important}.mb-auto{margin-bottom:auto!important}.ms-0{margin-left:0!important}.ms-1{margin-left:.25rem!important}.ms-2{margin-left:.5rem!important}.ms-3{margin-left:1rem!important}.ms-4{margin-left:1.5rem!important}.ms-5{margin-left:3rem!important}.ms-auto{margin-left:auto!important}.p-0{padding:0!important}.p-1{padding:.25rem!important}.p-2{padding:.5rem!important}.p-3{padding:1rem!important}.p-4{padding:1.5rem!important}.p-5{padding:3rem!important}.px-0{padding-right:0!important;padding-left:0!important}.px-1{padding-right:.25rem!important;padding-left:.25rem!important}.px-2{padding-right:.5rem!important;padding-left:.5rem!important}.px-3{padding-right:1rem!important;padding-left:1rem!important}.px-4{padding-right:1.5rem!important;padding-left:1.5rem!important}.px-5{padding-right:3rem!important;padding-left:3rem!important}.py-0{padding-top:0!important;padding-bottom:0!important}.py-1{padding-top:.25rem!important;padding-bottom:.25rem!important}.py-2{padding-top:.5rem!important;padding-bottom:.5rem!important}.py-3{padding-top:1rem!important;padding-bottom:1rem!important}.py-4{padding-top:1.5rem!important;padding-bottom:1.5rem!important}.py-5{padding-top:3rem!important;padding-bottom:3rem!important}.pt-0{padding-top:0!important}.pt-1{padding-top:.25rem!important}.pt-2{padding-top:.5rem!important}.pt-3{padding-top:1rem!important}.pt-4{padding-top:1.5rem!important}.pt-5{padding-top:3rem!important}.pe-0{padding-right:0!important}.pe-1{padding-right:.25rem!important}.pe-2{padding-right:.5rem!important}.pe-3{padding-right:1rem!important}.pe-4{padding-right:1.5rem!important}.pe-5{padding-right:3rem!important}.pb-0{padding-bottom:0!important}.pb-1{padding-bottom:.25rem!important}.pb-2{padding-bottom:.5rem!important}.pb-3{padding-bottom:1rem!important}.pb-4{padding-bottom:1.5rem!important}.pb-5{padding-bottom:3rem!important}.ps-0{padding-left:0!important}.ps-1{padding-left:.25rem!important}.ps-2{padding-left:.5rem!important}.ps-3{padding-left:1rem!important}.ps-4{padding-left:1.5rem!important}.ps-5{padding-left:3rem!important}.gap-0{gap:0!important}.gap-1{gap:.25rem!important}.gap-2{gap:.5rem!important}.gap-3{gap:1rem!important}.gap-4{gap:1.5rem!important}.gap-5{gap:3rem!important}.row-gap-0{row-gap:0!important}.row-gap-1{row-gap:.25rem!important}.row-gap-2{row-gap:.5rem!important}.row-gap-3{row-gap:1rem!important}.row-gap-4{row-gap:1.5rem!important}.row-gap-5{row-gap:3rem!important}.column-gap-0{column-gap:0!important}.column-gap-1{column-gap:.25rem!important}.column-gap-2{column-gap:.5rem!important}.column-gap-3{column-gap:1rem!important}.column-gap-4{column-gap:1.5rem!important}.column-gap-5{column-gap:3rem!important}.font-monospace{font-family:var(--bs-font-monospace)!important}.fs-1{font-size:calc(1.375rem + 1.5vw)!important}.fs-2{font-size:calc(1.325rem + .9vw)!important}.fs-3{font-size:calc(1.3rem + .6vw)!important}.fs-4{font-size:calc(1.275rem + .3vw)!important}.fs-5{font-size:1.25rem!important}.fs-6{font-size:1rem!important}.fst-italic{font-style:italic!important}.fst-normal{font-style:normal!important}.fw-lighter{font-weight:lighter!important}.fw-light{font-weight:300!important}.fw-normal{font-weight:400!important}.fw-medium{font-weight:500!important}.fw-semibold{font-weight:600!important}.fw-bold{font-weight:700!important}.fw-bolder{font-weight:bolder!important}.lh-1{line-height:1!important}.lh-sm{line-height:1.25!important}.lh-base{line-height:1.5!important}.lh-lg{line-height:2!important}.text-start{text-align:left!important}.text-end{text-align:right!important}.text-center{text-align:center!important}.text-decoration-none{text-decoration:none!important}.text-decoration-underline{text-decoration:underline!important}.text-decoration-line-through{text-decoration:line-through!important}.text-lowercase{text-transform:lowercase!important}.text-uppercase{text-transform:uppercase!important}.text-capitalize{text-transform:capitalize!important}.text-wrap{white-space:normal!important}.text-nowrap{white-space:nowrap!important}.text-break{word-wrap:break-word!important;word-break:break-word!important}.text-primary{--bs-text-opacity: 1;color:rgba(var(--bs-primary-rgb),var(--bs-text-opacity))!important}.text-secondary{--bs-text-opacity: 1;color:rgba(var(--bs-secondary-rgb),var(--bs-text-opacity))!important}.text-success{--bs-text-opacity: 1;color:rgba(var(--bs-success-rgb),var(--bs-text-opacity))!important}.text-info{--bs-text-opacity: 1;color:rgba(var(--bs-info-rgb),var(--bs-text-opacity))!important}.text-warning{--bs-text-opacity: 1;color:rgba(var(--bs-warning-rgb),var(--bs-text-opacity))!important}.text-danger{--bs-text-opacity: 1;color:rgba(var(--bs-danger-rgb),var(--bs-text-opacity))!important}.text-light{--bs-text-opacity: 1;color:rgba(var(--bs-light-rgb),var(--bs-text-opacity))!important}.text-dark{--bs-text-opacity: 1;color:rgba(var(--bs-dark-rgb),var(--bs-text-opacity))!important}.text-black{--bs-text-opacity: 1;color:rgba(var(--bs-black-rgb),var(--bs-text-opacity))!important}.text-white{--bs-text-opacity: 1;color:rgba(var(--bs-white-rgb),var(--bs-text-opacity))!important}.text-body{--bs-text-opacity: 1;color:rgba(var(--bs-body-color-rgb),var(--bs-text-opacity))!important}.text-muted{--bs-text-opacity: 1;color:var(--bs-secondary-color)!important}.text-black-50{--bs-text-opacity: 1;color:#00000080!important}.text-white-50{--bs-text-opacity: 1;color:#ffffff80!important}.text-body-secondary{--bs-text-opacity: 1;color:var(--bs-secondary-color)!important}.text-body-tertiary{--bs-text-opacity: 1;color:var(--bs-tertiary-color)!important}.text-body-emphasis{--bs-text-opacity: 1;color:var(--bs-emphasis-color)!important}.text-reset{--bs-text-opacity: 1;color:inherit!important}.text-opacity-25{--bs-text-opacity: .25}.text-opacity-50{--bs-text-opacity: .5}.text-opacity-75{--bs-text-opacity: .75}.text-opacity-100{--bs-text-opacity: 1}.text-primary-emphasis{color:var(--bs-primary-text-emphasis)!important}.text-secondary-emphasis{color:var(--bs-secondary-text-emphasis)!important}.text-success-emphasis{color:var(--bs-success-text-emphasis)!important}.text-info-emphasis{color:var(--bs-info-text-emphasis)!important}.text-warning-emphasis{color:var(--bs-warning-text-emphasis)!important}.text-danger-emphasis{color:var(--bs-danger-text-emphasis)!important}.text-light-emphasis{color:var(--bs-light-text-emphasis)!important}.text-dark-emphasis{color:var(--bs-dark-text-emphasis)!important}.link-opacity-10,.link-opacity-10-hover:hover{--bs-link-opacity: .1}.link-opacity-25,.link-opacity-25-hover:hover{--bs-link-opacity: .25}.link-opacity-50,.link-opacity-50-hover:hover{--bs-link-opacity: .5}.link-opacity-75,.link-opacity-75-hover:hover{--bs-link-opacity: .75}.link-opacity-100,.link-opacity-100-hover:hover{--bs-link-opacity: 1}.link-offset-1,.link-offset-1-hover:hover{text-underline-offset:.125em!important}.link-offset-2,.link-offset-2-hover:hover{text-underline-offset:.25em!important}.link-offset-3,.link-offset-3-hover:hover{text-underline-offset:.375em!important}.link-underline-primary{--bs-link-underline-opacity: 1;text-decoration-color:rgba(var(--bs-primary-rgb),var(--bs-link-underline-opacity))!important}.link-underline-secondary{--bs-link-underline-opacity: 1;text-decoration-color:rgba(var(--bs-secondary-rgb),var(--bs-link-underline-opacity))!important}.link-underline-success{--bs-link-underline-opacity: 1;text-decoration-color:rgba(var(--bs-success-rgb),var(--bs-link-underline-opacity))!important}.link-underline-info{--bs-link-underline-opacity: 1;text-decoration-color:rgba(var(--bs-info-rgb),var(--bs-link-underline-opacity))!important}.link-underline-warning{--bs-link-underline-opacity: 1;text-decoration-color:rgba(var(--bs-warning-rgb),var(--bs-link-underline-opacity))!important}.link-underline-danger{--bs-link-underline-opacity: 1;text-decoration-color:rgba(var(--bs-danger-rgb),var(--bs-link-underline-opacity))!important}.link-underline-light{--bs-link-underline-opacity: 1;text-decoration-color:rgba(var(--bs-light-rgb),var(--bs-link-underline-opacity))!important}.link-underline-dark{--bs-link-underline-opacity: 1;text-decoration-color:rgba(var(--bs-dark-rgb),var(--bs-link-underline-opacity))!important}.link-underline{--bs-link-underline-opacity: 1;text-decoration-color:rgba(var(--bs-link-color-rgb),var(--bs-link-underline-opacity, 1))!important}.link-underline-opacity-0,.link-underline-opacity-0-hover:hover{--bs-link-underline-opacity: 0}.link-underline-opacity-10,.link-underline-opacity-10-hover:hover{--bs-link-underline-opacity: .1}.link-underline-opacity-25,.link-underline-opacity-25-hover:hover{--bs-link-underline-opacity: .25}.link-underline-opacity-50,.link-underline-opacity-50-hover:hover{--bs-link-underline-opacity: .5}.link-underline-opacity-75,.link-underline-opacity-75-hover:hover{--bs-link-underline-opacity: .75}.link-underline-opacity-100,.link-underline-opacity-100-hover:hover{--bs-link-underline-opacity: 1}.bg-primary{--bs-bg-opacity: 1;background-color:rgba(var(--bs-primary-rgb),var(--bs-bg-opacity))!important}.bg-secondary{--bs-bg-opacity: 1;background-color:rgba(var(--bs-secondary-rgb),var(--bs-bg-opacity))!important}.bg-success{--bs-bg-opacity: 1;background-color:rgba(var(--bs-success-rgb),var(--bs-bg-opacity))!important}.bg-info{--bs-bg-opacity: 1;background-color:rgba(var(--bs-info-rgb),var(--bs-bg-opacity))!important}.bg-warning{--bs-bg-opacity: 1;background-color:rgba(var(--bs-warning-rgb),var(--bs-bg-opacity))!important}.bg-danger{--bs-bg-opacity: 1;background-color:rgba(var(--bs-danger-rgb),var(--bs-bg-opacity))!important}.bg-light{--bs-bg-opacity: 1;background-color:rgba(var(--bs-light-rgb),var(--bs-bg-opacity))!important}.bg-dark{--bs-bg-opacity: 1;background-color:rgba(var(--bs-dark-rgb),var(--bs-bg-opacity))!important}.bg-black{--bs-bg-opacity: 1;background-color:rgba(var(--bs-black-rgb),var(--bs-bg-opacity))!important}.bg-white{--bs-bg-opacity: 1;background-color:rgba(var(--bs-white-rgb),var(--bs-bg-opacity))!important}.bg-body{--bs-bg-opacity: 1;background-color:rgba(var(--bs-body-bg-rgb),var(--bs-bg-opacity))!important}.bg-transparent{--bs-bg-opacity: 1;background-color:transparent!important}.bg-body-secondary{--bs-bg-opacity: 1;background-color:rgba(var(--bs-secondary-bg-rgb),var(--bs-bg-opacity))!important}.bg-body-tertiary{--bs-bg-opacity: 1;background-color:rgba(var(--bs-tertiary-bg-rgb),var(--bs-bg-opacity))!important}.bg-opacity-10{--bs-bg-opacity: .1}.bg-opacity-25{--bs-bg-opacity: .25}.bg-opacity-50{--bs-bg-opacity: .5}.bg-opacity-75{--bs-bg-opacity: .75}.bg-opacity-100{--bs-bg-opacity: 1}.bg-primary-subtle{background-color:var(--bs-primary-bg-subtle)!important}.bg-secondary-subtle{background-color:var(--bs-secondary-bg-subtle)!important}.bg-success-subtle{background-color:var(--bs-success-bg-subtle)!important}.bg-info-subtle{background-color:var(--bs-info-bg-subtle)!important}.bg-warning-subtle{background-color:var(--bs-warning-bg-subtle)!important}.bg-danger-subtle{background-color:var(--bs-danger-bg-subtle)!important}.bg-light-subtle{background-color:var(--bs-light-bg-subtle)!important}.bg-dark-subtle{background-color:var(--bs-dark-bg-subtle)!important}.bg-gradient{background-image:var(--bs-gradient)!important}.user-select-all{user-select:all!important}.user-select-auto{user-select:auto!important}.user-select-none{user-select:none!important}.pe-none{pointer-events:none!important}.pe-auto{pointer-events:auto!important}.rounded{border-radius:var(--bs-border-radius)!important}.rounded-0{border-radius:0!important}.rounded-1{border-radius:var(--bs-border-radius-sm)!important}.rounded-2{border-radius:var(--bs-border-radius)!important}.rounded-3{border-radius:var(--bs-border-radius-lg)!important}.rounded-4{border-radius:var(--bs-border-radius-xl)!important}.rounded-5{border-radius:var(--bs-border-radius-xxl)!important}.rounded-circle{border-radius:50%!important}.rounded-pill{border-radius:var(--bs-border-radius-pill)!important}.rounded-top{border-top-left-radius:var(--bs-border-radius)!important;border-top-right-radius:var(--bs-border-radius)!important}.rounded-top-0{border-top-left-radius:0!important;border-top-right-radius:0!important}.rounded-top-1{border-top-left-radius:var(--bs-border-radius-sm)!important;border-top-right-radius:var(--bs-border-radius-sm)!important}.rounded-top-2{border-top-left-radius:var(--bs-border-radius)!important;border-top-right-radius:var(--bs-border-radius)!important}.rounded-top-3{border-top-left-radius:var(--bs-border-radius-lg)!important;border-top-right-radius:var(--bs-border-radius-lg)!important}.rounded-top-4{border-top-left-radius:var(--bs-border-radius-xl)!important;border-top-right-radius:var(--bs-border-radius-xl)!important}.rounded-top-5{border-top-left-radius:var(--bs-border-radius-xxl)!important;border-top-right-radius:var(--bs-border-radius-xxl)!important}.rounded-top-circle{border-top-left-radius:50%!important;border-top-right-radius:50%!important}.rounded-top-pill{border-top-left-radius:var(--bs-border-radius-pill)!important;border-top-right-radius:var(--bs-border-radius-pill)!important}.rounded-end{border-top-right-radius:var(--bs-border-radius)!important;border-bottom-right-radius:var(--bs-border-radius)!important}.rounded-end-0{border-top-right-radius:0!important;border-bottom-right-radius:0!important}.rounded-end-1{border-top-right-radius:var(--bs-border-radius-sm)!important;border-bottom-right-radius:var(--bs-border-radius-sm)!important}.rounded-end-2{border-top-right-radius:var(--bs-border-radius)!important;border-bottom-right-radius:var(--bs-border-radius)!important}.rounded-end-3{border-top-right-radius:var(--bs-border-radius-lg)!important;border-bottom-right-radius:var(--bs-border-radius-lg)!important}.rounded-end-4{border-top-right-radius:var(--bs-border-radius-xl)!important;border-bottom-right-radius:var(--bs-border-radius-xl)!important}.rounded-end-5{border-top-right-radius:var(--bs-border-radius-xxl)!important;border-bottom-right-radius:var(--bs-border-radius-xxl)!important}.rounded-end-circle{border-top-right-radius:50%!important;border-bottom-right-radius:50%!important}.rounded-end-pill{border-top-right-radius:var(--bs-border-radius-pill)!important;border-bottom-right-radius:var(--bs-border-radius-pill)!important}.rounded-bottom{border-bottom-right-radius:var(--bs-border-radius)!important;border-bottom-left-radius:var(--bs-border-radius)!important}.rounded-bottom-0{border-bottom-right-radius:0!important;border-bottom-left-radius:0!important}.rounded-bottom-1{border-bottom-right-radius:var(--bs-border-radius-sm)!important;border-bottom-left-radius:var(--bs-border-radius-sm)!important}.rounded-bottom-2{border-bottom-right-radius:var(--bs-border-radius)!important;border-bottom-left-radius:var(--bs-border-radius)!important}.rounded-bottom-3{border-bottom-right-radius:var(--bs-border-radius-lg)!important;border-bottom-left-radius:var(--bs-border-radius-lg)!important}.rounded-bottom-4{border-bottom-right-radius:var(--bs-border-radius-xl)!important;border-bottom-left-radius:var(--bs-border-radius-xl)!important}.rounded-bottom-5{border-bottom-right-radius:var(--bs-border-radius-xxl)!important;border-bottom-left-radius:var(--bs-border-radius-xxl)!important}.rounded-bottom-circle{border-bottom-right-radius:50%!important;border-bottom-left-radius:50%!important}.rounded-bottom-pill{border-bottom-right-radius:var(--bs-border-radius-pill)!important;border-bottom-left-radius:var(--bs-border-radius-pill)!important}.rounded-start{border-bottom-left-radius:var(--bs-border-radius)!important;border-top-left-radius:var(--bs-border-radius)!important}.rounded-start-0{border-bottom-left-radius:0!important;border-top-left-radius:0!important}.rounded-start-1{border-bottom-left-radius:var(--bs-border-radius-sm)!important;border-top-left-radius:var(--bs-border-radius-sm)!important}.rounded-start-2{border-bottom-left-radius:var(--bs-border-radius)!important;border-top-left-radius:var(--bs-border-radius)!important}.rounded-start-3{border-bottom-left-radius:var(--bs-border-radius-lg)!important;border-top-left-radius:var(--bs-border-radius-lg)!important}.rounded-start-4{border-bottom-left-radius:var(--bs-border-radius-xl)!important;border-top-left-radius:var(--bs-border-radius-xl)!important}.rounded-start-5{border-bottom-left-radius:var(--bs-border-radius-xxl)!important;border-top-left-radius:var(--bs-border-radius-xxl)!important}.rounded-start-circle{border-bottom-left-radius:50%!important;border-top-left-radius:50%!important}.rounded-start-pill{border-bottom-left-radius:var(--bs-border-radius-pill)!important;border-top-left-radius:var(--bs-border-radius-pill)!important}.visible{visibility:visible!important}.invisible{visibility:hidden!important}.z-n1{z-index:-1!important}.z-0{z-index:0!important}.z-1{z-index:1!important}.z-2{z-index:2!important}.z-3{z-index:3!important}@media (min-width: 576px){.float-sm-start{float:left!important}.float-sm-end{float:right!important}.float-sm-none{float:none!important}.object-fit-sm-contain{object-fit:contain!important}.object-fit-sm-cover{object-fit:cover!important}.object-fit-sm-fill{object-fit:fill!important}.object-fit-sm-scale{object-fit:scale-down!important}.object-fit-sm-none{object-fit:none!important}.d-sm-inline{display:inline!important}.d-sm-inline-block{display:inline-block!important}.d-sm-block{display:block!important}.d-sm-grid{display:grid!important}.d-sm-inline-grid{display:inline-grid!important}.d-sm-table{display:table!important}.d-sm-table-row{display:table-row!important}.d-sm-table-cell{display:table-cell!important}.d-sm-flex{display:flex!important}.d-sm-inline-flex{display:inline-flex!important}.d-sm-none{display:none!important}.flex-sm-fill{flex:1 1 auto!important}.flex-sm-row{flex-direction:row!important}.flex-sm-column{flex-direction:column!important}.flex-sm-row-reverse{flex-direction:row-reverse!important}.flex-sm-column-reverse{flex-direction:column-reverse!important}.flex-sm-grow-0{flex-grow:0!important}.flex-sm-grow-1{flex-grow:1!important}.flex-sm-shrink-0{flex-shrink:0!important}.flex-sm-shrink-1{flex-shrink:1!important}.flex-sm-wrap{flex-wrap:wrap!important}.flex-sm-nowrap{flex-wrap:nowrap!important}.flex-sm-wrap-reverse{flex-wrap:wrap-reverse!important}.justify-content-sm-start{justify-content:flex-start!important}.justify-content-sm-end{justify-content:flex-end!important}.justify-content-sm-center{justify-content:center!important}.justify-content-sm-between{justify-content:space-between!important}.justify-content-sm-around{justify-content:space-around!important}.justify-content-sm-evenly{justify-content:space-evenly!important}.align-items-sm-start{align-items:flex-start!important}.align-items-sm-end{align-items:flex-end!important}.align-items-sm-center{align-items:center!important}.align-items-sm-baseline{align-items:baseline!important}.align-items-sm-stretch{align-items:stretch!important}.align-content-sm-start{align-content:flex-start!important}.align-content-sm-end{align-content:flex-end!important}.align-content-sm-center{align-content:center!important}.align-content-sm-between{align-content:space-between!important}.align-content-sm-around{align-content:space-around!important}.align-content-sm-stretch{align-content:stretch!important}.align-self-sm-auto{align-self:auto!important}.align-self-sm-start{align-self:flex-start!important}.align-self-sm-end{align-self:flex-end!important}.align-self-sm-center{align-self:center!important}.align-self-sm-baseline{align-self:baseline!important}.align-self-sm-stretch{align-self:stretch!important}.order-sm-first{order:-1!important}.order-sm-0{order:0!important}.order-sm-1{order:1!important}.order-sm-2{order:2!important}.order-sm-3{order:3!important}.order-sm-4{order:4!important}.order-sm-5{order:5!important}.order-sm-last{order:6!important}.m-sm-0{margin:0!important}.m-sm-1{margin:.25rem!important}.m-sm-2{margin:.5rem!important}.m-sm-3{margin:1rem!important}.m-sm-4{margin:1.5rem!important}.m-sm-5{margin:3rem!important}.m-sm-auto{margin:auto!important}.mx-sm-0{margin-right:0!important;margin-left:0!important}.mx-sm-1{margin-right:.25rem!important;margin-left:.25rem!important}.mx-sm-2{margin-right:.5rem!important;margin-left:.5rem!important}.mx-sm-3{margin-right:1rem!important;margin-left:1rem!important}.mx-sm-4{margin-right:1.5rem!important;margin-left:1.5rem!important}.mx-sm-5{margin-right:3rem!important;margin-left:3rem!important}.mx-sm-auto{margin-right:auto!important;margin-left:auto!important}.my-sm-0{margin-top:0!important;margin-bottom:0!important}.my-sm-1{margin-top:.25rem!important;margin-bottom:.25rem!important}.my-sm-2{margin-top:.5rem!important;margin-bottom:.5rem!important}.my-sm-3{margin-top:1rem!important;margin-bottom:1rem!important}.my-sm-4{margin-top:1.5rem!important;margin-bottom:1.5rem!important}.my-sm-5{margin-top:3rem!important;margin-bottom:3rem!important}.my-sm-auto{margin-top:auto!important;margin-bottom:auto!important}.mt-sm-0{margin-top:0!important}.mt-sm-1{margin-top:.25rem!important}.mt-sm-2{margin-top:.5rem!important}.mt-sm-3{margin-top:1rem!important}.mt-sm-4{margin-top:1.5rem!important}.mt-sm-5{margin-top:3rem!important}.mt-sm-auto{margin-top:auto!important}.me-sm-0{margin-right:0!important}.me-sm-1{margin-right:.25rem!important}.me-sm-2{margin-right:.5rem!important}.me-sm-3{margin-right:1rem!important}.me-sm-4{margin-right:1.5rem!important}.me-sm-5{margin-right:3rem!important}.me-sm-auto{margin-right:auto!important}.mb-sm-0{margin-bottom:0!important}.mb-sm-1{margin-bottom:.25rem!important}.mb-sm-2{margin-bottom:.5rem!important}.mb-sm-3{margin-bottom:1rem!important}.mb-sm-4{margin-bottom:1.5rem!important}.mb-sm-5{margin-bottom:3rem!important}.mb-sm-auto{margin-bottom:auto!important}.ms-sm-0{margin-left:0!important}.ms-sm-1{margin-left:.25rem!important}.ms-sm-2{margin-left:.5rem!important}.ms-sm-3{margin-left:1rem!important}.ms-sm-4{margin-left:1.5rem!important}.ms-sm-5{margin-left:3rem!important}.ms-sm-auto{margin-left:auto!important}.p-sm-0{padding:0!important}.p-sm-1{padding:.25rem!important}.p-sm-2{padding:.5rem!important}.p-sm-3{padding:1rem!important}.p-sm-4{padding:1.5rem!important}.p-sm-5{padding:3rem!important}.px-sm-0{padding-right:0!important;padding-left:0!important}.px-sm-1{padding-right:.25rem!important;padding-left:.25rem!important}.px-sm-2{padding-right:.5rem!important;padding-left:.5rem!important}.px-sm-3{padding-right:1rem!important;padding-left:1rem!important}.px-sm-4{padding-right:1.5rem!important;padding-left:1.5rem!important}.px-sm-5{padding-right:3rem!important;padding-left:3rem!important}.py-sm-0{padding-top:0!important;padding-bottom:0!important}.py-sm-1{padding-top:.25rem!important;padding-bottom:.25rem!important}.py-sm-2{padding-top:.5rem!important;padding-bottom:.5rem!important}.py-sm-3{padding-top:1rem!important;padding-bottom:1rem!important}.py-sm-4{padding-top:1.5rem!important;padding-bottom:1.5rem!important}.py-sm-5{padding-top:3rem!important;padding-bottom:3rem!important}.pt-sm-0{padding-top:0!important}.pt-sm-1{padding-top:.25rem!important}.pt-sm-2{padding-top:.5rem!important}.pt-sm-3{padding-top:1rem!important}.pt-sm-4{padding-top:1.5rem!important}.pt-sm-5{padding-top:3rem!important}.pe-sm-0{padding-right:0!important}.pe-sm-1{padding-right:.25rem!important}.pe-sm-2{padding-right:.5rem!important}.pe-sm-3{padding-right:1rem!important}.pe-sm-4{padding-right:1.5rem!important}.pe-sm-5{padding-right:3rem!important}.pb-sm-0{padding-bottom:0!important}.pb-sm-1{padding-bottom:.25rem!important}.pb-sm-2{padding-bottom:.5rem!important}.pb-sm-3{padding-bottom:1rem!important}.pb-sm-4{padding-bottom:1.5rem!important}.pb-sm-5{padding-bottom:3rem!important}.ps-sm-0{padding-left:0!important}.ps-sm-1{padding-left:.25rem!important}.ps-sm-2{padding-left:.5rem!important}.ps-sm-3{padding-left:1rem!important}.ps-sm-4{padding-left:1.5rem!important}.ps-sm-5{padding-left:3rem!important}.gap-sm-0{gap:0!important}.gap-sm-1{gap:.25rem!important}.gap-sm-2{gap:.5rem!important}.gap-sm-3{gap:1rem!important}.gap-sm-4{gap:1.5rem!important}.gap-sm-5{gap:3rem!important}.row-gap-sm-0{row-gap:0!important}.row-gap-sm-1{row-gap:.25rem!important}.row-gap-sm-2{row-gap:.5rem!important}.row-gap-sm-3{row-gap:1rem!important}.row-gap-sm-4{row-gap:1.5rem!important}.row-gap-sm-5{row-gap:3rem!important}.column-gap-sm-0{column-gap:0!important}.column-gap-sm-1{column-gap:.25rem!important}.column-gap-sm-2{column-gap:.5rem!important}.column-gap-sm-3{column-gap:1rem!important}.column-gap-sm-4{column-gap:1.5rem!important}.column-gap-sm-5{column-gap:3rem!important}.text-sm-start{text-align:left!important}.text-sm-end{text-align:right!important}.text-sm-center{text-align:center!important}}@media (min-width: 768px){.float-md-start{float:left!important}.float-md-end{float:right!important}.float-md-none{float:none!important}.object-fit-md-contain{object-fit:contain!important}.object-fit-md-cover{object-fit:cover!important}.object-fit-md-fill{object-fit:fill!important}.object-fit-md-scale{object-fit:scale-down!important}.object-fit-md-none{object-fit:none!important}.d-md-inline{display:inline!important}.d-md-inline-block{display:inline-block!important}.d-md-block{display:block!important}.d-md-grid{display:grid!important}.d-md-inline-grid{display:inline-grid!important}.d-md-table{display:table!important}.d-md-table-row{display:table-row!important}.d-md-table-cell{display:table-cell!important}.d-md-flex{display:flex!important}.d-md-inline-flex{display:inline-flex!important}.d-md-none{display:none!important}.flex-md-fill{flex:1 1 auto!important}.flex-md-row{flex-direction:row!important}.flex-md-column{flex-direction:column!important}.flex-md-row-reverse{flex-direction:row-reverse!important}.flex-md-column-reverse{flex-direction:column-reverse!important}.flex-md-grow-0{flex-grow:0!important}.flex-md-grow-1{flex-grow:1!important}.flex-md-shrink-0{flex-shrink:0!important}.flex-md-shrink-1{flex-shrink:1!important}.flex-md-wrap{flex-wrap:wrap!important}.flex-md-nowrap{flex-wrap:nowrap!important}.flex-md-wrap-reverse{flex-wrap:wrap-reverse!important}.justify-content-md-start{justify-content:flex-start!important}.justify-content-md-end{justify-content:flex-end!important}.justify-content-md-center{justify-content:center!important}.justify-content-md-between{justify-content:space-between!important}.justify-content-md-around{justify-content:space-around!important}.justify-content-md-evenly{justify-content:space-evenly!important}.align-items-md-start{align-items:flex-start!important}.align-items-md-end{align-items:flex-end!important}.align-items-md-center{align-items:center!important}.align-items-md-baseline{align-items:baseline!important}.align-items-md-stretch{align-items:stretch!important}.align-content-md-start{align-content:flex-start!important}.align-content-md-end{align-content:flex-end!important}.align-content-md-center{align-content:center!important}.align-content-md-between{align-content:space-between!important}.align-content-md-around{align-content:space-around!important}.align-content-md-stretch{align-content:stretch!important}.align-self-md-auto{align-self:auto!important}.align-self-md-start{align-self:flex-start!important}.align-self-md-end{align-self:flex-end!important}.align-self-md-center{align-self:center!important}.align-self-md-baseline{align-self:baseline!important}.align-self-md-stretch{align-self:stretch!important}.order-md-first{order:-1!important}.order-md-0{order:0!important}.order-md-1{order:1!important}.order-md-2{order:2!important}.order-md-3{order:3!important}.order-md-4{order:4!important}.order-md-5{order:5!important}.order-md-last{order:6!important}.m-md-0{margin:0!important}.m-md-1{margin:.25rem!important}.m-md-2{margin:.5rem!important}.m-md-3{margin:1rem!important}.m-md-4{margin:1.5rem!important}.m-md-5{margin:3rem!important}.m-md-auto{margin:auto!important}.mx-md-0{margin-right:0!important;margin-left:0!important}.mx-md-1{margin-right:.25rem!important;margin-left:.25rem!important}.mx-md-2{margin-right:.5rem!important;margin-left:.5rem!important}.mx-md-3{margin-right:1rem!important;margin-left:1rem!important}.mx-md-4{margin-right:1.5rem!important;margin-left:1.5rem!important}.mx-md-5{margin-right:3rem!important;margin-left:3rem!important}.mx-md-auto{margin-right:auto!important;margin-left:auto!important}.my-md-0{margin-top:0!important;margin-bottom:0!important}.my-md-1{margin-top:.25rem!important;margin-bottom:.25rem!important}.my-md-2{margin-top:.5rem!important;margin-bottom:.5rem!important}.my-md-3{margin-top:1rem!important;margin-bottom:1rem!important}.my-md-4{margin-top:1.5rem!important;margin-bottom:1.5rem!important}.my-md-5{margin-top:3rem!important;margin-bottom:3rem!important}.my-md-auto{margin-top:auto!important;margin-bottom:auto!important}.mt-md-0{margin-top:0!important}.mt-md-1{margin-top:.25rem!important}.mt-md-2{margin-top:.5rem!important}.mt-md-3{margin-top:1rem!important}.mt-md-4{margin-top:1.5rem!important}.mt-md-5{margin-top:3rem!important}.mt-md-auto{margin-top:auto!important}.me-md-0{margin-right:0!important}.me-md-1{margin-right:.25rem!important}.me-md-2{margin-right:.5rem!important}.me-md-3{margin-right:1rem!important}.me-md-4{margin-right:1.5rem!important}.me-md-5{margin-right:3rem!important}.me-md-auto{margin-right:auto!important}.mb-md-0{margin-bottom:0!important}.mb-md-1{margin-bottom:.25rem!important}.mb-md-2{margin-bottom:.5rem!important}.mb-md-3{margin-bottom:1rem!important}.mb-md-4{margin-bottom:1.5rem!important}.mb-md-5{margin-bottom:3rem!important}.mb-md-auto{margin-bottom:auto!important}.ms-md-0{margin-left:0!important}.ms-md-1{margin-left:.25rem!important}.ms-md-2{margin-left:.5rem!important}.ms-md-3{margin-left:1rem!important}.ms-md-4{margin-left:1.5rem!important}.ms-md-5{margin-left:3rem!important}.ms-md-auto{margin-left:auto!important}.p-md-0{padding:0!important}.p-md-1{padding:.25rem!important}.p-md-2{padding:.5rem!important}.p-md-3{padding:1rem!important}.p-md-4{padding:1.5rem!important}.p-md-5{padding:3rem!important}.px-md-0{padding-right:0!important;padding-left:0!important}.px-md-1{padding-right:.25rem!important;padding-left:.25rem!important}.px-md-2{padding-right:.5rem!important;padding-left:.5rem!important}.px-md-3{padding-right:1rem!important;padding-left:1rem!important}.px-md-4{padding-right:1.5rem!important;padding-left:1.5rem!important}.px-md-5{padding-right:3rem!important;padding-left:3rem!important}.py-md-0{padding-top:0!important;padding-bottom:0!important}.py-md-1{padding-top:.25rem!important;padding-bottom:.25rem!important}.py-md-2{padding-top:.5rem!important;padding-bottom:.5rem!important}.py-md-3{padding-top:1rem!important;padding-bottom:1rem!important}.py-md-4{padding-top:1.5rem!important;padding-bottom:1.5rem!important}.py-md-5{padding-top:3rem!important;padding-bottom:3rem!important}.pt-md-0{padding-top:0!important}.pt-md-1{padding-top:.25rem!important}.pt-md-2{padding-top:.5rem!important}.pt-md-3{padding-top:1rem!important}.pt-md-4{padding-top:1.5rem!important}.pt-md-5{padding-top:3rem!important}.pe-md-0{padding-right:0!important}.pe-md-1{padding-right:.25rem!important}.pe-md-2{padding-right:.5rem!important}.pe-md-3{padding-right:1rem!important}.pe-md-4{padding-right:1.5rem!important}.pe-md-5{padding-right:3rem!important}.pb-md-0{padding-bottom:0!important}.pb-md-1{padding-bottom:.25rem!important}.pb-md-2{padding-bottom:.5rem!important}.pb-md-3{padding-bottom:1rem!important}.pb-md-4{padding-bottom:1.5rem!important}.pb-md-5{padding-bottom:3rem!important}.ps-md-0{padding-left:0!important}.ps-md-1{padding-left:.25rem!important}.ps-md-2{padding-left:.5rem!important}.ps-md-3{padding-left:1rem!important}.ps-md-4{padding-left:1.5rem!important}.ps-md-5{padding-left:3rem!important}.gap-md-0{gap:0!important}.gap-md-1{gap:.25rem!important}.gap-md-2{gap:.5rem!important}.gap-md-3{gap:1rem!important}.gap-md-4{gap:1.5rem!important}.gap-md-5{gap:3rem!important}.row-gap-md-0{row-gap:0!important}.row-gap-md-1{row-gap:.25rem!important}.row-gap-md-2{row-gap:.5rem!important}.row-gap-md-3{row-gap:1rem!important}.row-gap-md-4{row-gap:1.5rem!important}.row-gap-md-5{row-gap:3rem!important}.column-gap-md-0{column-gap:0!important}.column-gap-md-1{column-gap:.25rem!important}.column-gap-md-2{column-gap:.5rem!important}.column-gap-md-3{column-gap:1rem!important}.column-gap-md-4{column-gap:1.5rem!important}.column-gap-md-5{column-gap:3rem!important}.text-md-start{text-align:left!important}.text-md-end{text-align:right!important}.text-md-center{text-align:center!important}}@media (min-width: 992px){.float-lg-start{float:left!important}.float-lg-end{float:right!important}.float-lg-none{float:none!important}.object-fit-lg-contain{object-fit:contain!important}.object-fit-lg-cover{object-fit:cover!important}.object-fit-lg-fill{object-fit:fill!important}.object-fit-lg-scale{object-fit:scale-down!important}.object-fit-lg-none{object-fit:none!important}.d-lg-inline{display:inline!important}.d-lg-inline-block{display:inline-block!important}.d-lg-block{display:block!important}.d-lg-grid{display:grid!important}.d-lg-inline-grid{display:inline-grid!important}.d-lg-table{display:table!important}.d-lg-table-row{display:table-row!important}.d-lg-table-cell{display:table-cell!important}.d-lg-flex{display:flex!important}.d-lg-inline-flex{display:inline-flex!important}.d-lg-none{display:none!important}.flex-lg-fill{flex:1 1 auto!important}.flex-lg-row{flex-direction:row!important}.flex-lg-column{flex-direction:column!important}.flex-lg-row-reverse{flex-direction:row-reverse!important}.flex-lg-column-reverse{flex-direction:column-reverse!important}.flex-lg-grow-0{flex-grow:0!important}.flex-lg-grow-1{flex-grow:1!important}.flex-lg-shrink-0{flex-shrink:0!important}.flex-lg-shrink-1{flex-shrink:1!important}.flex-lg-wrap{flex-wrap:wrap!important}.flex-lg-nowrap{flex-wrap:nowrap!important}.flex-lg-wrap-reverse{flex-wrap:wrap-reverse!important}.justify-content-lg-start{justify-content:flex-start!important}.justify-content-lg-end{justify-content:flex-end!important}.justify-content-lg-center{justify-content:center!important}.justify-content-lg-between{justify-content:space-between!important}.justify-content-lg-around{justify-content:space-around!important}.justify-content-lg-evenly{justify-content:space-evenly!important}.align-items-lg-start{align-items:flex-start!important}.align-items-lg-end{align-items:flex-end!important}.align-items-lg-center{align-items:center!important}.align-items-lg-baseline{align-items:baseline!important}.align-items-lg-stretch{align-items:stretch!important}.align-content-lg-start{align-content:flex-start!important}.align-content-lg-end{align-content:flex-end!important}.align-content-lg-center{align-content:center!important}.align-content-lg-between{align-content:space-between!important}.align-content-lg-around{align-content:space-around!important}.align-content-lg-stretch{align-content:stretch!important}.align-self-lg-auto{align-self:auto!important}.align-self-lg-start{align-self:flex-start!important}.align-self-lg-end{align-self:flex-end!important}.align-self-lg-center{align-self:center!important}.align-self-lg-baseline{align-self:baseline!important}.align-self-lg-stretch{align-self:stretch!important}.order-lg-first{order:-1!important}.order-lg-0{order:0!important}.order-lg-1{order:1!important}.order-lg-2{order:2!important}.order-lg-3{order:3!important}.order-lg-4{order:4!important}.order-lg-5{order:5!important}.order-lg-last{order:6!important}.m-lg-0{margin:0!important}.m-lg-1{margin:.25rem!important}.m-lg-2{margin:.5rem!important}.m-lg-3{margin:1rem!important}.m-lg-4{margin:1.5rem!important}.m-lg-5{margin:3rem!important}.m-lg-auto{margin:auto!important}.mx-lg-0{margin-right:0!important;margin-left:0!important}.mx-lg-1{margin-right:.25rem!important;margin-left:.25rem!important}.mx-lg-2{margin-right:.5rem!important;margin-left:.5rem!important}.mx-lg-3{margin-right:1rem!important;margin-left:1rem!important}.mx-lg-4{margin-right:1.5rem!important;margin-left:1.5rem!important}.mx-lg-5{margin-right:3rem!important;margin-left:3rem!important}.mx-lg-auto{margin-right:auto!important;margin-left:auto!important}.my-lg-0{margin-top:0!important;margin-bottom:0!important}.my-lg-1{margin-top:.25rem!important;margin-bottom:.25rem!important}.my-lg-2{margin-top:.5rem!important;margin-bottom:.5rem!important}.my-lg-3{margin-top:1rem!important;margin-bottom:1rem!important}.my-lg-4{margin-top:1.5rem!important;margin-bottom:1.5rem!important}.my-lg-5{margin-top:3rem!important;margin-bottom:3rem!important}.my-lg-auto{margin-top:auto!important;margin-bottom:auto!important}.mt-lg-0{margin-top:0!important}.mt-lg-1{margin-top:.25rem!important}.mt-lg-2{margin-top:.5rem!important}.mt-lg-3{margin-top:1rem!important}.mt-lg-4{margin-top:1.5rem!important}.mt-lg-5{margin-top:3rem!important}.mt-lg-auto{margin-top:auto!important}.me-lg-0{margin-right:0!important}.me-lg-1{margin-right:.25rem!important}.me-lg-2{margin-right:.5rem!important}.me-lg-3{margin-right:1rem!important}.me-lg-4{margin-right:1.5rem!important}.me-lg-5{margin-right:3rem!important}.me-lg-auto{margin-right:auto!important}.mb-lg-0{margin-bottom:0!important}.mb-lg-1{margin-bottom:.25rem!important}.mb-lg-2{margin-bottom:.5rem!important}.mb-lg-3{margin-bottom:1rem!important}.mb-lg-4{margin-bottom:1.5rem!important}.mb-lg-5{margin-bottom:3rem!important}.mb-lg-auto{margin-bottom:auto!important}.ms-lg-0{margin-left:0!important}.ms-lg-1{margin-left:.25rem!important}.ms-lg-2{margin-left:.5rem!important}.ms-lg-3{margin-left:1rem!important}.ms-lg-4{margin-left:1.5rem!important}.ms-lg-5{margin-left:3rem!important}.ms-lg-auto{margin-left:auto!important}.p-lg-0{padding:0!important}.p-lg-1{padding:.25rem!important}.p-lg-2{padding:.5rem!important}.p-lg-3{padding:1rem!important}.p-lg-4{padding:1.5rem!important}.p-lg-5{padding:3rem!important}.px-lg-0{padding-right:0!important;padding-left:0!important}.px-lg-1{padding-right:.25rem!important;padding-left:.25rem!important}.px-lg-2{padding-right:.5rem!important;padding-left:.5rem!important}.px-lg-3{padding-right:1rem!important;padding-left:1rem!important}.px-lg-4{padding-right:1.5rem!important;padding-left:1.5rem!important}.px-lg-5{padding-right:3rem!important;padding-left:3rem!important}.py-lg-0{padding-top:0!important;padding-bottom:0!important}.py-lg-1{padding-top:.25rem!important;padding-bottom:.25rem!important}.py-lg-2{padding-top:.5rem!important;padding-bottom:.5rem!important}.py-lg-3{padding-top:1rem!important;padding-bottom:1rem!important}.py-lg-4{padding-top:1.5rem!important;padding-bottom:1.5rem!important}.py-lg-5{padding-top:3rem!important;padding-bottom:3rem!important}.pt-lg-0{padding-top:0!important}.pt-lg-1{padding-top:.25rem!important}.pt-lg-2{padding-top:.5rem!important}.pt-lg-3{padding-top:1rem!important}.pt-lg-4{padding-top:1.5rem!important}.pt-lg-5{padding-top:3rem!important}.pe-lg-0{padding-right:0!important}.pe-lg-1{padding-right:.25rem!important}.pe-lg-2{padding-right:.5rem!important}.pe-lg-3{padding-right:1rem!important}.pe-lg-4{padding-right:1.5rem!important}.pe-lg-5{padding-right:3rem!important}.pb-lg-0{padding-bottom:0!important}.pb-lg-1{padding-bottom:.25rem!important}.pb-lg-2{padding-bottom:.5rem!important}.pb-lg-3{padding-bottom:1rem!important}.pb-lg-4{padding-bottom:1.5rem!important}.pb-lg-5{padding-bottom:3rem!important}.ps-lg-0{padding-left:0!important}.ps-lg-1{padding-left:.25rem!important}.ps-lg-2{padding-left:.5rem!important}.ps-lg-3{padding-left:1rem!important}.ps-lg-4{padding-left:1.5rem!important}.ps-lg-5{padding-left:3rem!important}.gap-lg-0{gap:0!important}.gap-lg-1{gap:.25rem!important}.gap-lg-2{gap:.5rem!important}.gap-lg-3{gap:1rem!important}.gap-lg-4{gap:1.5rem!important}.gap-lg-5{gap:3rem!important}.row-gap-lg-0{row-gap:0!important}.row-gap-lg-1{row-gap:.25rem!important}.row-gap-lg-2{row-gap:.5rem!important}.row-gap-lg-3{row-gap:1rem!important}.row-gap-lg-4{row-gap:1.5rem!important}.row-gap-lg-5{row-gap:3rem!important}.column-gap-lg-0{column-gap:0!important}.column-gap-lg-1{column-gap:.25rem!important}.column-gap-lg-2{column-gap:.5rem!important}.column-gap-lg-3{column-gap:1rem!important}.column-gap-lg-4{column-gap:1.5rem!important}.column-gap-lg-5{column-gap:3rem!important}.text-lg-start{text-align:left!important}.text-lg-end{text-align:right!important}.text-lg-center{text-align:center!important}}@media (min-width: 1200px){.float-xl-start{float:left!important}.float-xl-end{float:right!important}.float-xl-none{float:none!important}.object-fit-xl-contain{object-fit:contain!important}.object-fit-xl-cover{object-fit:cover!important}.object-fit-xl-fill{object-fit:fill!important}.object-fit-xl-scale{object-fit:scale-down!important}.object-fit-xl-none{object-fit:none!important}.d-xl-inline{display:inline!important}.d-xl-inline-block{display:inline-block!important}.d-xl-block{display:block!important}.d-xl-grid{display:grid!important}.d-xl-inline-grid{display:inline-grid!important}.d-xl-table{display:table!important}.d-xl-table-row{display:table-row!important}.d-xl-table-cell{display:table-cell!important}.d-xl-flex{display:flex!important}.d-xl-inline-flex{display:inline-flex!important}.d-xl-none{display:none!important}.flex-xl-fill{flex:1 1 auto!important}.flex-xl-row{flex-direction:row!important}.flex-xl-column{flex-direction:column!important}.flex-xl-row-reverse{flex-direction:row-reverse!important}.flex-xl-column-reverse{flex-direction:column-reverse!important}.flex-xl-grow-0{flex-grow:0!important}.flex-xl-grow-1{flex-grow:1!important}.flex-xl-shrink-0{flex-shrink:0!important}.flex-xl-shrink-1{flex-shrink:1!important}.flex-xl-wrap{flex-wrap:wrap!important}.flex-xl-nowrap{flex-wrap:nowrap!important}.flex-xl-wrap-reverse{flex-wrap:wrap-reverse!important}.justify-content-xl-start{justify-content:flex-start!important}.justify-content-xl-end{justify-content:flex-end!important}.justify-content-xl-center{justify-content:center!important}.justify-content-xl-between{justify-content:space-between!important}.justify-content-xl-around{justify-content:space-around!important}.justify-content-xl-evenly{justify-content:space-evenly!important}.align-items-xl-start{align-items:flex-start!important}.align-items-xl-end{align-items:flex-end!important}.align-items-xl-center{align-items:center!important}.align-items-xl-baseline{align-items:baseline!important}.align-items-xl-stretch{align-items:stretch!important}.align-content-xl-start{align-content:flex-start!important}.align-content-xl-end{align-content:flex-end!important}.align-content-xl-center{align-content:center!important}.align-content-xl-between{align-content:space-between!important}.align-content-xl-around{align-content:space-around!important}.align-content-xl-stretch{align-content:stretch!important}.align-self-xl-auto{align-self:auto!important}.align-self-xl-start{align-self:flex-start!important}.align-self-xl-end{align-self:flex-end!important}.align-self-xl-center{align-self:center!important}.align-self-xl-baseline{align-self:baseline!important}.align-self-xl-stretch{align-self:stretch!important}.order-xl-first{order:-1!important}.order-xl-0{order:0!important}.order-xl-1{order:1!important}.order-xl-2{order:2!important}.order-xl-3{order:3!important}.order-xl-4{order:4!important}.order-xl-5{order:5!important}.order-xl-last{order:6!important}.m-xl-0{margin:0!important}.m-xl-1{margin:.25rem!important}.m-xl-2{margin:.5rem!important}.m-xl-3{margin:1rem!important}.m-xl-4{margin:1.5rem!important}.m-xl-5{margin:3rem!important}.m-xl-auto{margin:auto!important}.mx-xl-0{margin-right:0!important;margin-left:0!important}.mx-xl-1{margin-right:.25rem!important;margin-left:.25rem!important}.mx-xl-2{margin-right:.5rem!important;margin-left:.5rem!important}.mx-xl-3{margin-right:1rem!important;margin-left:1rem!important}.mx-xl-4{margin-right:1.5rem!important;margin-left:1.5rem!important}.mx-xl-5{margin-right:3rem!important;margin-left:3rem!important}.mx-xl-auto{margin-right:auto!important;margin-left:auto!important}.my-xl-0{margin-top:0!important;margin-bottom:0!important}.my-xl-1{margin-top:.25rem!important;margin-bottom:.25rem!important}.my-xl-2{margin-top:.5rem!important;margin-bottom:.5rem!important}.my-xl-3{margin-top:1rem!important;margin-bottom:1rem!important}.my-xl-4{margin-top:1.5rem!important;margin-bottom:1.5rem!important}.my-xl-5{margin-top:3rem!important;margin-bottom:3rem!important}.my-xl-auto{margin-top:auto!important;margin-bottom:auto!important}.mt-xl-0{margin-top:0!important}.mt-xl-1{margin-top:.25rem!important}.mt-xl-2{margin-top:.5rem!important}.mt-xl-3{margin-top:1rem!important}.mt-xl-4{margin-top:1.5rem!important}.mt-xl-5{margin-top:3rem!important}.mt-xl-auto{margin-top:auto!important}.me-xl-0{margin-right:0!important}.me-xl-1{margin-right:.25rem!important}.me-xl-2{margin-right:.5rem!important}.me-xl-3{margin-right:1rem!important}.me-xl-4{margin-right:1.5rem!important}.me-xl-5{margin-right:3rem!important}.me-xl-auto{margin-right:auto!important}.mb-xl-0{margin-bottom:0!important}.mb-xl-1{margin-bottom:.25rem!important}.mb-xl-2{margin-bottom:.5rem!important}.mb-xl-3{margin-bottom:1rem!important}.mb-xl-4{margin-bottom:1.5rem!important}.mb-xl-5{margin-bottom:3rem!important}.mb-xl-auto{margin-bottom:auto!important}.ms-xl-0{margin-left:0!important}.ms-xl-1{margin-left:.25rem!important}.ms-xl-2{margin-left:.5rem!important}.ms-xl-3{margin-left:1rem!important}.ms-xl-4{margin-left:1.5rem!important}.ms-xl-5{margin-left:3rem!important}.ms-xl-auto{margin-left:auto!important}.p-xl-0{padding:0!important}.p-xl-1{padding:.25rem!important}.p-xl-2{padding:.5rem!important}.p-xl-3{padding:1rem!important}.p-xl-4{padding:1.5rem!important}.p-xl-5{padding:3rem!important}.px-xl-0{padding-right:0!important;padding-left:0!important}.px-xl-1{padding-right:.25rem!important;padding-left:.25rem!important}.px-xl-2{padding-right:.5rem!important;padding-left:.5rem!important}.px-xl-3{padding-right:1rem!important;padding-left:1rem!important}.px-xl-4{padding-right:1.5rem!important;padding-left:1.5rem!important}.px-xl-5{padding-right:3rem!important;padding-left:3rem!important}.py-xl-0{padding-top:0!important;padding-bottom:0!important}.py-xl-1{padding-top:.25rem!important;padding-bottom:.25rem!important}.py-xl-2{padding-top:.5rem!important;padding-bottom:.5rem!important}.py-xl-3{padding-top:1rem!important;padding-bottom:1rem!important}.py-xl-4{padding-top:1.5rem!important;padding-bottom:1.5rem!important}.py-xl-5{padding-top:3rem!important;padding-bottom:3rem!important}.pt-xl-0{padding-top:0!important}.pt-xl-1{padding-top:.25rem!important}.pt-xl-2{padding-top:.5rem!important}.pt-xl-3{padding-top:1rem!important}.pt-xl-4{padding-top:1.5rem!important}.pt-xl-5{padding-top:3rem!important}.pe-xl-0{padding-right:0!important}.pe-xl-1{padding-right:.25rem!important}.pe-xl-2{padding-right:.5rem!important}.pe-xl-3{padding-right:1rem!important}.pe-xl-4{padding-right:1.5rem!important}.pe-xl-5{padding-right:3rem!important}.pb-xl-0{padding-bottom:0!important}.pb-xl-1{padding-bottom:.25rem!important}.pb-xl-2{padding-bottom:.5rem!important}.pb-xl-3{padding-bottom:1rem!important}.pb-xl-4{padding-bottom:1.5rem!important}.pb-xl-5{padding-bottom:3rem!important}.ps-xl-0{padding-left:0!important}.ps-xl-1{padding-left:.25rem!important}.ps-xl-2{padding-left:.5rem!important}.ps-xl-3{padding-left:1rem!important}.ps-xl-4{padding-left:1.5rem!important}.ps-xl-5{padding-left:3rem!important}.gap-xl-0{gap:0!important}.gap-xl-1{gap:.25rem!important}.gap-xl-2{gap:.5rem!important}.gap-xl-3{gap:1rem!important}.gap-xl-4{gap:1.5rem!important}.gap-xl-5{gap:3rem!important}.row-gap-xl-0{row-gap:0!important}.row-gap-xl-1{row-gap:.25rem!important}.row-gap-xl-2{row-gap:.5rem!important}.row-gap-xl-3{row-gap:1rem!important}.row-gap-xl-4{row-gap:1.5rem!important}.row-gap-xl-5{row-gap:3rem!important}.column-gap-xl-0{column-gap:0!important}.column-gap-xl-1{column-gap:.25rem!important}.column-gap-xl-2{column-gap:.5rem!important}.column-gap-xl-3{column-gap:1rem!important}.column-gap-xl-4{column-gap:1.5rem!important}.column-gap-xl-5{column-gap:3rem!important}.text-xl-start{text-align:left!important}.text-xl-end{text-align:right!important}.text-xl-center{text-align:center!important}}@media (min-width: 1400px){.float-xxl-start{float:left!important}.float-xxl-end{float:right!important}.float-xxl-none{float:none!important}.object-fit-xxl-contain{object-fit:contain!important}.object-fit-xxl-cover{object-fit:cover!important}.object-fit-xxl-fill{object-fit:fill!important}.object-fit-xxl-scale{object-fit:scale-down!important}.object-fit-xxl-none{object-fit:none!important}.d-xxl-inline{display:inline!important}.d-xxl-inline-block{display:inline-block!important}.d-xxl-block{display:block!important}.d-xxl-grid{display:grid!important}.d-xxl-inline-grid{display:inline-grid!important}.d-xxl-table{display:table!important}.d-xxl-table-row{display:table-row!important}.d-xxl-table-cell{display:table-cell!important}.d-xxl-flex{display:flex!important}.d-xxl-inline-flex{display:inline-flex!important}.d-xxl-none{display:none!important}.flex-xxl-fill{flex:1 1 auto!important}.flex-xxl-row{flex-direction:row!important}.flex-xxl-column{flex-direction:column!important}.flex-xxl-row-reverse{flex-direction:row-reverse!important}.flex-xxl-column-reverse{flex-direction:column-reverse!important}.flex-xxl-grow-0{flex-grow:0!important}.flex-xxl-grow-1{flex-grow:1!important}.flex-xxl-shrink-0{flex-shrink:0!important}.flex-xxl-shrink-1{flex-shrink:1!important}.flex-xxl-wrap{flex-wrap:wrap!important}.flex-xxl-nowrap{flex-wrap:nowrap!important}.flex-xxl-wrap-reverse{flex-wrap:wrap-reverse!important}.justify-content-xxl-start{justify-content:flex-start!important}.justify-content-xxl-end{justify-content:flex-end!important}.justify-content-xxl-center{justify-content:center!important}.justify-content-xxl-between{justify-content:space-between!important}.justify-content-xxl-around{justify-content:space-around!important}.justify-content-xxl-evenly{justify-content:space-evenly!important}.align-items-xxl-start{align-items:flex-start!important}.align-items-xxl-end{align-items:flex-end!important}.align-items-xxl-center{align-items:center!important}.align-items-xxl-baseline{align-items:baseline!important}.align-items-xxl-stretch{align-items:stretch!important}.align-content-xxl-start{align-content:flex-start!important}.align-content-xxl-end{align-content:flex-end!important}.align-content-xxl-center{align-content:center!important}.align-content-xxl-between{align-content:space-between!important}.align-content-xxl-around{align-content:space-around!important}.align-content-xxl-stretch{align-content:stretch!important}.align-self-xxl-auto{align-self:auto!important}.align-self-xxl-start{align-self:flex-start!important}.align-self-xxl-end{align-self:flex-end!important}.align-self-xxl-center{align-self:center!important}.align-self-xxl-baseline{align-self:baseline!important}.align-self-xxl-stretch{align-self:stretch!important}.order-xxl-first{order:-1!important}.order-xxl-0{order:0!important}.order-xxl-1{order:1!important}.order-xxl-2{order:2!important}.order-xxl-3{order:3!important}.order-xxl-4{order:4!important}.order-xxl-5{order:5!important}.order-xxl-last{order:6!important}.m-xxl-0{margin:0!important}.m-xxl-1{margin:.25rem!important}.m-xxl-2{margin:.5rem!important}.m-xxl-3{margin:1rem!important}.m-xxl-4{margin:1.5rem!important}.m-xxl-5{margin:3rem!important}.m-xxl-auto{margin:auto!important}.mx-xxl-0{margin-right:0!important;margin-left:0!important}.mx-xxl-1{margin-right:.25rem!important;margin-left:.25rem!important}.mx-xxl-2{margin-right:.5rem!important;margin-left:.5rem!important}.mx-xxl-3{margin-right:1rem!important;margin-left:1rem!important}.mx-xxl-4{margin-right:1.5rem!important;margin-left:1.5rem!important}.mx-xxl-5{margin-right:3rem!important;margin-left:3rem!important}.mx-xxl-auto{margin-right:auto!important;margin-left:auto!important}.my-xxl-0{margin-top:0!important;margin-bottom:0!important}.my-xxl-1{margin-top:.25rem!important;margin-bottom:.25rem!important}.my-xxl-2{margin-top:.5rem!important;margin-bottom:.5rem!important}.my-xxl-3{margin-top:1rem!important;margin-bottom:1rem!important}.my-xxl-4{margin-top:1.5rem!important;margin-bottom:1.5rem!important}.my-xxl-5{margin-top:3rem!important;margin-bottom:3rem!important}.my-xxl-auto{margin-top:auto!important;margin-bottom:auto!important}.mt-xxl-0{margin-top:0!important}.mt-xxl-1{margin-top:.25rem!important}.mt-xxl-2{margin-top:.5rem!important}.mt-xxl-3{margin-top:1rem!important}.mt-xxl-4{margin-top:1.5rem!important}.mt-xxl-5{margin-top:3rem!important}.mt-xxl-auto{margin-top:auto!important}.me-xxl-0{margin-right:0!important}.me-xxl-1{margin-right:.25rem!important}.me-xxl-2{margin-right:.5rem!important}.me-xxl-3{margin-right:1rem!important}.me-xxl-4{margin-right:1.5rem!important}.me-xxl-5{margin-right:3rem!important}.me-xxl-auto{margin-right:auto!important}.mb-xxl-0{margin-bottom:0!important}.mb-xxl-1{margin-bottom:.25rem!important}.mb-xxl-2{margin-bottom:.5rem!important}.mb-xxl-3{margin-bottom:1rem!important}.mb-xxl-4{margin-bottom:1.5rem!important}.mb-xxl-5{margin-bottom:3rem!important}.mb-xxl-auto{margin-bottom:auto!important}.ms-xxl-0{margin-left:0!important}.ms-xxl-1{margin-left:.25rem!important}.ms-xxl-2{margin-left:.5rem!important}.ms-xxl-3{margin-left:1rem!important}.ms-xxl-4{margin-left:1.5rem!important}.ms-xxl-5{margin-left:3rem!important}.ms-xxl-auto{margin-left:auto!important}.p-xxl-0{padding:0!important}.p-xxl-1{padding:.25rem!important}.p-xxl-2{padding:.5rem!important}.p-xxl-3{padding:1rem!important}.p-xxl-4{padding:1.5rem!important}.p-xxl-5{padding:3rem!important}.px-xxl-0{padding-right:0!important;padding-left:0!important}.px-xxl-1{padding-right:.25rem!important;padding-left:.25rem!important}.px-xxl-2{padding-right:.5rem!important;padding-left:.5rem!important}.px-xxl-3{padding-right:1rem!important;padding-left:1rem!important}.px-xxl-4{padding-right:1.5rem!important;padding-left:1.5rem!important}.px-xxl-5{padding-right:3rem!important;padding-left:3rem!important}.py-xxl-0{padding-top:0!important;padding-bottom:0!important}.py-xxl-1{padding-top:.25rem!important;padding-bottom:.25rem!important}.py-xxl-2{padding-top:.5rem!important;padding-bottom:.5rem!important}.py-xxl-3{padding-top:1rem!important;padding-bottom:1rem!important}.py-xxl-4{padding-top:1.5rem!important;padding-bottom:1.5rem!important}.py-xxl-5{padding-top:3rem!important;padding-bottom:3rem!important}.pt-xxl-0{padding-top:0!important}.pt-xxl-1{padding-top:.25rem!important}.pt-xxl-2{padding-top:.5rem!important}.pt-xxl-3{padding-top:1rem!important}.pt-xxl-4{padding-top:1.5rem!important}.pt-xxl-5{padding-top:3rem!important}.pe-xxl-0{padding-right:0!important}.pe-xxl-1{padding-right:.25rem!important}.pe-xxl-2{padding-right:.5rem!important}.pe-xxl-3{padding-right:1rem!important}.pe-xxl-4{padding-right:1.5rem!important}.pe-xxl-5{padding-right:3rem!important}.pb-xxl-0{padding-bottom:0!important}.pb-xxl-1{padding-bottom:.25rem!important}.pb-xxl-2{padding-bottom:.5rem!important}.pb-xxl-3{padding-bottom:1rem!important}.pb-xxl-4{padding-bottom:1.5rem!important}.pb-xxl-5{padding-bottom:3rem!important}.ps-xxl-0{padding-left:0!important}.ps-xxl-1{padding-left:.25rem!important}.ps-xxl-2{padding-left:.5rem!important}.ps-xxl-3{padding-left:1rem!important}.ps-xxl-4{padding-left:1.5rem!important}.ps-xxl-5{padding-left:3rem!important}.gap-xxl-0{gap:0!important}.gap-xxl-1{gap:.25rem!important}.gap-xxl-2{gap:.5rem!important}.gap-xxl-3{gap:1rem!important}.gap-xxl-4{gap:1.5rem!important}.gap-xxl-5{gap:3rem!important}.row-gap-xxl-0{row-gap:0!important}.row-gap-xxl-1{row-gap:.25rem!important}.row-gap-xxl-2{row-gap:.5rem!important}.row-gap-xxl-3{row-gap:1rem!important}.row-gap-xxl-4{row-gap:1.5rem!important}.row-gap-xxl-5{row-gap:3rem!important}.column-gap-xxl-0{column-gap:0!important}.column-gap-xxl-1{column-gap:.25rem!important}.column-gap-xxl-2{column-gap:.5rem!important}.column-gap-xxl-3{column-gap:1rem!important}.column-gap-xxl-4{column-gap:1.5rem!important}.column-gap-xxl-5{column-gap:3rem!important}.text-xxl-start{text-align:left!important}.text-xxl-end{text-align:right!important}.text-xxl-center{text-align:center!important}}@media (min-width: 1200px){.fs-1{font-size:2.5rem!important}.fs-2{font-size:2rem!important}.fs-3{font-size:1.75rem!important}.fs-4{font-size:1.5rem!important}}@media print{.d-print-inline{display:inline!important}.d-print-inline-block{display:inline-block!important}.d-print-block{display:block!important}.d-print-grid{display:grid!important}.d-print-inline-grid{display:inline-grid!important}.d-print-table{display:table!important}.d-print-table-row{display:table-row!important}.d-print-table-cell{display:table-cell!important}.d-print-flex{display:flex!important}.d-print-inline-flex{display:inline-flex!important}.d-print-none{display:none!important}}:root{--gem-neutral-025: #fcfcfd;--gem-neutral-050: #f9fafb;--gem-neutral-100: #f2f4f7;--gem-neutral-200: #e4e7ec;--gem-neutral-300: #d0d5dd;--gem-neutral-400: #98a2b3;--gem-neutral-500: #667085;--gem-neutral-600: #475467;--gem-neutral-700: #344054;--gem-neutral-800: #1d2939;--gem-neutral-900: #101828;--gem-primary-025: #fcfcfd;--gem-primary-050: #f8f9fc;--gem-primary-100: #eaecf5;--gem-primary-200: #c8cce5;--gem-primary-300: #9ea5d1;--gem-primary-400: #717bbc;--gem-primary-500: #4e5ba6;--gem-primary-600: #3e4784;--gem-primary-700: #363f72;--gem-primary-800: #293056;--gem-primary-900: #101323;--gem-error-025: #fffbfa;--gem-error-050: #fef3f2;--gem-error-100: #fee4e2;--gem-error-200: #fecdca;--gem-error-300: #fda29b;--gem-error-400: #f97066;--gem-error-500: #f04438;--gem-error-600: #d92d20;--gem-error-700: #b42318;--gem-error-800: #912018;--gem-error-900: #7a271a;--gem-warning-025: #fffcf5;--gem-warning-050: #fffaeb;--gem-warning-100: #fef0c7;--gem-warning-200: #fedf89;--gem-warning-300: #fec84b;--gem-warning-400: #fdb022;--gem-warning-500: #f79009;--gem-warning-600: #dc6803;--gem-warning-700: #b54708;--gem-warning-800: #93370d;--gem-warning-900: #7a2e0e;--gem-success-025: #f6fef9;--gem-success-050: #ecfdf3;--gem-success-100: #d1fadf;--gem-success-200: #a6f4c5;--gem-success-300: #6ce9a6;--gem-success-400: #32d583;--gem-success-500: #12b76a;--gem-success-600: #039855;--gem-success-700: #027a48;--gem-success-800: #05603a;--gem-success-900: #054f31}body{display:block;width:100%;height:100%}.text-ellipsis{overflow-x:hidden;white-space:nowrap;text-overflow:ellipsis}.f-caption{font-size:.78rem}.message-item[data-v-b543c90f]{cursor:pointer}.message-item .grid[data-v-b543c90f]{display:grid;grid-template-columns:auto 1fr;grid-template-rows:auto}.message-item .grid .request[data-v-b543c90f]{color:#0298cf!important}.message-item .grid .response[data-v-b543c90f]{color:#408509!important;height:1em;width:1em}.message-item .grid .add-info-strings[data-v-b543c90f]{grid-column:2}.sequence-number[data-v-b543c90f]{background:var(--gem-primary-100)}.logo[data-v-74fa4e7e]{font-family:noto-sans,sans-serif;font-weight:600;font-size:22px;line-height:1.5em;color:var(--gem-primary-700)}.logo[data-v-74fa4e7e]:before{content:"";display:inline-block;background:url("data:image/svg+xml,%3csvg%20width='60'%20height='60'%20viewBox='0%200%2060%2060'%20fill='none'%20xmlns='http://www.w3.org/2000/svg'%3e%3cg%20clip-path='url(%23clip0_8_2)'%3e%3crect%20width='60'%20height='60'%20fill='%23010E52'/%3e%3cpath%20d='M20.0587%2034.838L23.1484%2034.1954L28.3146%2032.2069L27.2924%2034.2586L26.8709%2035.3939L25.0863%2033.4794L24.6426%2034.3803L24.8101%2036.3286L24.5866%2036.5168L22.2121%2034.7531L22.7353%2036.9875C22.4172%2036.9642%2022.3901%2036.2231%2021.9394%2036.8065L20.0587%2034.838Z'%20fill='%23010E52'/%3e%3cpath%20d='M20.673%2041.7451L22.9394%2040.5547L25.2541%2040.6248L29.7691%2042.4485L29.2276%2041.6189L28.9031%2038.2276L28.1735%2038.1461L26.6692%2040.666L25.3341%2040.121L25.6877%2038.2347L25.0497%2037.7168L23.0285%2040.0395L22.4442%2038.3636L21.3657%2039.1715L20.4457%2040.7802L20.673%2041.7451Z'%20fill='%23010E52'/%3e%3cpath%20d='M58.0972%2027.9009L56.6115%2026.5907C55.1482%2025.2805%2052.8296%2023.5622%2050.8937%2022.3594L49.8807%2021.7151L49.8582%2019.6961C49.8356%2017.4409%2049.498%2016.4099%2048.1473%2014.6272C47.4045%2013.6392%2043.3074%2010.7396%2043.0373%2011.0189C42.9698%2011.0833%2042.9022%2011.7921%2042.8797%2012.5653C42.8572%2014.885%2041.8442%2016.2596%2039.4581%2017.1617C39.1204%2017.2905%2037.1394%2017.4624%2035.0234%2017.5483C32.9299%2017.6557%2030.8363%2017.849%2030.4086%2017.9993C29.3056%2018.3645%2027.3246%2019.5887%2026.2441%2020.5338C24.7133%2021.9084%2023.3852%2022.6816%2020.8189%2023.6911C16.902%2025.2375%2015.799%2026.0322%2015.1236%2027.729C14.8085%2028.4808%2015.1236%2029.7695%2015.7539%2030.3064C15.9791%2030.5212%2016.2492%2031.0367%2016.3392%2031.4663C16.6544%2033.2275%2018.3427%2035.1606%2019.5583%2035.1606C19.7834%2035.1606%2020.4588%2035.6975%2021.044%2036.3419C22.7099%2038.2105%2024.2631%2038.7045%2023.2051%2037.0507C22.9575%2036.6641%2022.7549%2036.0841%2022.7549%2035.762C22.7549%2035.2035%2022.7774%2035.2035%2023.8804%2036.256L25.0285%2037.3514L24.128%2038.2749L23.2276%2039.22L22.935%2038.6401C22.4397%2037.6521%2022.012%2037.8239%2020.8189%2039.4992C19.7159%2041.0671%2019.7159%2041.0671%2019.7384%2042.7854C19.7609%2044.203%2019.9185%2044.8688%2020.6163%2046.6515C21.0891%2047.8328%2021.6518%2049.1645%2021.8995%2049.6155C22.3497%2050.4747%2022.7549%2050.5391%2022.5973%2049.7229C22.5523%2049.4437%2022.7099%2048.9067%2022.98%2048.5201C23.7904%2047.2529%2025.141%2047.1026%2027.8424%2047.9402C29.8458%2048.5631%2031.6918%2048.6275%2032.7048%2048.1335C34.5957%2047.1885%2038.8052%2048.6705%2039.8633%2050.625C40.426%2051.6775%2041.3715%2054.5556%2041.6641%2056.102C41.7992%2056.8108%2041.9568%2057.6055%2042.0243%2057.8847L42.1144%2058.3572C42.2999%2059.2366%2042.5%2060%2042.5%2060H60V29.5C60%2029.5%2059.6155%2029.2397%2058.0972%2027.9009ZM46.0988%2014.2406C47.2244%2015.3575%2048.6426%2017.7845%2048.6426%2018.6222C48.6426%2018.837%2048.3949%2019.7606%2048.1023%2020.6626C47.5845%2022.2091%2047.5845%2022.295%2047.9447%2022.7675C48.1698%2023.0253%2048.4625%2023.8844%2048.575%2024.6576C48.8226%2026.0537%2050.4209%2030.2635%2051.0287%2031.0152C51.524%2031.6811%2051.6365%2031.1441%2051.2763%2029.8124C51.0062%2028.803%2050.9837%2028.3734%2051.1863%2027.8794C51.4114%2027.2995%2051.3664%2027.1706%2050.9162%2026.6981C50.3534%2026.1396%2049.9032%2024.4428%2050.2183%2024.1421C50.466%2023.8844%2052.7846%2025.3235%2053.2573%2025.9893C53.8201%2026.8269%2053.9101%2027.9223%2053.5049%2029.6191C53.1223%2031.2945%2052.4244%2032.7335%2051.8166%2033.1631C51.5015%2033.3779%2051.5465%2033.5067%2052.2893%2034.237C53.4149%2035.3324%2054.0452%2036.7285%2054.0452%2038.1246C54.0452%2039.3059%2053.5725%2040.745%2053.1673%2040.745C52.6945%2040.745%2052.9197%2041.1745%2053.5725%2041.4752C54.4504%2041.9263%2055.8011%2043.7734%2056.5664%2045.5776C57.1067%2046.9307%2057.1742%2047.3603%2057.1968%2049.7229V52.3433L56.0487%2051.1405C54.1803%2049.1645%2052.6495%2048.0261%2052.3794%2048.4342C52.3119%2048.5416%2052.627%2048.9927%2053.0547%2049.4652C54.1578%2050.6035%2054.9682%2051.9996%2055.1933%2053.095C55.3508%2053.9542%2055.3058%2054.169%2054.5855%2055.2858C54.1578%2055.9731%2053.4599%2056.9397%2053.0097%2057.4551C52.2443%2058.3358%2052.1543%2058.3787%2051.1638%2058.3143L50.1058%2058.2499L50.1733%2057.3907C50.2859%2056.0161%2050.646%2055.1784%2051.7041%2053.9327C52.2443%2053.3098%2052.6945%2052.7084%2052.6945%2052.644C52.6945%2052.4507%2052.2893%2052.1715%2050.2183%2050.7754C49.2954%2050.1525%2048.4625%2049.5941%2048.3499%2049.5296C48.1698%2049.4007%2048.4174%2047.4677%2048.8001%2045.9427C48.8677%2045.685%2048.8226%2045.4702%2048.6651%2045.4702C48.53%2045.4702%2047.8997%2046.5012%2047.2469%2047.7684C46.6166%2049.0571%2046.0538%2050.1525%2046.0088%2050.2169C45.9637%2050.2814%2046.6166%2050.8398%2047.4495%2051.4842C48.3049%2052.1285%2049.0703%2052.7084%2049.1603%2052.7729C49.2504%2052.8588%2049.1378%2053.2454%2048.8902%2053.6535C48.3724%2054.5126%2047.517%2057.1115%2047.517%2057.8418C47.517%2058.2928%2047.4045%2058.3572%2046.7516%2058.3572C46.0763%2058.3572%2045.9863%2058.2713%2045.8512%2057.6914C45.5585%2056.2309%2045.8512%2054.0186%2046.459%2053.2454C46.5715%2053.095%2046.6166%2052.9232%2046.5265%2052.8373C46.3239%2052.644%2044.1854%2054.663%2043.7577%2055.4577L43.3975%2056.102L43.2174%2055.5221C43.1274%2055.1999%2042.9248%2054.0616%2042.7672%2052.9876C42.5421%2051.2694%2042.5421%2050.8828%2042.9022%2049.6585C43.42%2047.8113%2044.343%2046.4582%2045.4685%2045.8998C45.9863%2045.6635%2046.3915%2045.3628%2046.3915%2045.2554C46.3915%2044.9547%2046.1213%2044.9762%2044.6581%2045.5132C43.7126%2045.8353%2042.9923%2046.3079%2042.0693%2047.2314C41.349%2047.9187%2040.7637%2048.6275%2040.7637%2048.7994C40.7637%2049.2504%2040.5836%2049.2074%2039.7282%2048.4772C38.6702%2047.5966%2037.4096%2047.0166%2036.2165%2046.8448C34.6182%2046.63%2034.6182%2046.63%2035.2485%2045.7494C35.7437%2045.0406%2035.9914%2044.1815%2035.6987%2044.1815C35.6537%2044.1815%2035.1585%2044.6325%2034.6407%2045.1695C33.6052%2046.2434%2031.8944%2047.1885%2030.9714%2047.1885C30.6788%2047.1885%2029.4857%2046.8878%2028.3376%2046.5226C25.6363%2045.6635%2024.128%2045.7065%2022.6648%2046.6945C21.4267%2047.5321%2021.3817%2047.4677%2021.2241%2044.4607L21.1116%2042.2914L22.1021%2041.6685C22.9125%2041.153%2023.2951%2041.0671%2024.5332%2041.0671C25.8389%2041.0671%2026.3116%2041.196%2028.3151%2042.0766C30.9489%2043.2579%2031.9619%2043.3653%2032.7498%2042.5921C33.2675%2042.1196%2033.29%2041.9907%2033.2225%2039.0052C33.155%2035.3324%2032.8173%2034.3229%2031.1065%2032.712C29.3956%2031.1012%2027.7973%2031.0797%2025.141%2032.6046C24.2406%2033.1201%2022.8899%2033.6571%2021.7644%2033.9148L19.9185%2034.3873L19.0856%2033.8933C18.2977%2033.4208%2017.3522%2032.1536%2017.0371%2031.1441C16.902%2030.7575%2016.9921%2030.6716%2017.5323%2030.5427C18.3202%2030.3924%2020.0536%2029.0392%2020.0536%2028.5667C20.0536%2028.309%2019.9185%2028.3304%2019.2882%2028.6956C18.8154%2028.9963%2018.1626%2029.1466%2017.4648%2029.1466H16.4068L16.5643%2028.3519C16.7669%2027.235%2017.2172%2026.4833%2017.8475%2026.2041C18.1176%2026.0537%2019.3332%2025.6456%2020.5038%2025.2805C23.1601%2024.4428%2023.8129%2024.0777%2027.0095%2021.6507C30.1385%2019.2666%2030.5662%2019.1806%2032.6597%2020.5982C33.7853%2021.35%2034.213%2021.5003%2035.361%2021.5862C36.239%2021.6507%2036.8243%2021.5862%2037.0494%2021.4144C37.4996%2021.0707%2037.2745%2020.77%2036.5766%2020.77C35.8788%2020.77%2034.9333%2020.319%2034.3706%2019.7176L33.9429%2019.2666H35.0684C36.1264%2019.2666%2036.2615%2019.331%2037.207%2020.2975C37.7697%2020.8774%2038.4901%2021.7151%2038.8052%2022.1876C39.5031%2023.2401%2040.9438%2024.5502%2041.6191%2024.7435C42.2494%2024.9154%2042.2494%2024.6147%2041.6416%2024.0777C40.9663%2023.5193%2040.3135%2022.1017%2040.3135%2021.1781C40.3135%2020.5982%2040.1334%2020.2546%2039.5256%2019.6961C38.6026%2018.837%2038.5576%2018.6222%2039.278%2018.6222C39.5706%2018.6222%2040.426%2018.3215%2041.1914%2017.9349C42.3845%2017.355%2042.6546%2017.0972%2043.1724%2016.0878C43.51%2015.4434%2043.8252%2014.391%2043.8702%2013.7681C43.9603%2012.6727%2043.9828%2012.6297%2044.4555%2012.866C44.7031%2012.9949%2045.446%2013.6177%2046.0988%2014.2406ZM56.7015%2028.4378C57.1067%2028.9104%2057.2193%2029.2111%2057.1067%2029.7695C57.0167%2030.3924%2057.0392%2030.4568%2057.4219%2030.3709C57.8271%2030.2635%2057.8721%2030.3709%2057.8721%2031.2515C57.8496%2032.1321%2057.8271%2032.218%2057.5569%2031.8744C57.3993%2031.6811%2057.1517%2031.5092%2057.0392%2031.5092C56.8591%2031.5092%2055.8461%2035.2465%2055.8461%2035.8479C55.8461%2036.256%2056.4539%2035.9553%2056.9041%2035.3324L57.3993%2034.6451L57.6245%2035.225C57.782%2035.6331%2057.782%2036.6641%2057.6019%2038.5756L57.3543%2041.3463L56.4764%2040.6805C55.621%2039.9932%2055.621%2039.9932%2055.756%2038.7904C55.8911%2037.5661%2055.4184%2035.676%2054.6305%2034.3229C54.3604%2033.8504%2054.4054%2033.5926%2054.9456%2032.0247C55.3058%2031.0367%2055.666%2029.7051%2055.7335%2029.0392C55.8236%2028.3949%2055.9586%2027.8579%2056.0262%2027.8579C56.1162%2027.8579%2056.4089%2028.1157%2056.7015%2028.4378ZM27.3471%2032.9913C27.5272%2033.249%2026.9419%2034.7954%2026.6268%2034.9028C26.4692%2034.9458%2026.3566%2034.8384%2026.3566%2034.6666C26.3566%2034.4947%2026.2891%2034.0652%2026.2216%2033.7C26.109%2033.1846%2026.1766%2033.0342%2026.4917%2032.9483C27.167%2032.7765%2027.2346%2032.7979%2027.3471%2032.9913ZM29.3056%2033.7645C31.084%2034.9458%2032.5922%2037.4158%2032.3221%2038.6615C32.097%2039.6925%2031.3541%2040.702%2030.5887%2041.0886C29.7333%2041.5182%2029.5982%2041.3463%2029.4181%2039.6925C29.058%2036.8359%2028.7878%2036.6641%2027.6623%2038.5971C27.2571%2039.3059%2026.7618%2039.8858%2026.5592%2039.8858C25.974%2039.8858%2025.7038%2039.4348%2025.8389%2038.683C25.9064%2038.2964%2025.8839%2037.8024%2025.7939%2037.5876C25.6813%2037.3728%2025.5913%2037.0936%2025.5913%2036.9862C25.5688%2036.8574%2025.4337%2036.4063%2025.2536%2035.9553C24.9835%2035.182%2025.051%2034.0866%2025.4112%2034.0866C25.5012%2034.0866%2025.9064%2034.6666%2026.3116%2035.3968C27.167%2036.8788%2027.6173%2036.9433%2027.5272%2035.5901C27.4597%2034.5377%2027.8424%2033.2275%2028.2251%2033.2275C28.3601%2033.2275%2028.8329%2033.4638%2029.3056%2033.7645ZM24.5107%2035.0532C24.4882%2036.213%2024.083%2036.3204%2023.6778%2035.268C23.3627%2034.4303%2023.4752%2034.0866%2024.1055%2034.0866C24.4432%2034.0866%2024.5107%2034.2585%2024.5107%2035.0532ZM22.057%2035.3968C22.2821%2036.0412%2022.2371%2036.4493%2021.8995%2036.4493C21.6518%2036.4493%2021.0215%2035.2894%2021.1341%2034.9887C21.2917%2034.4947%2021.8094%2034.731%2022.057%2035.3968ZM25.3436%2038.4038C25.4337%2038.5112%2025.4337%2038.8549%2025.3662%2039.1556C25.2536%2039.5207%2025.0735%2039.671%2024.6683%2039.671C24.0155%2039.671%2023.948%2039.3274%2024.4657%2038.6401C24.8484%2038.1246%2025.1185%2038.0387%2025.3436%2038.4038ZM28.7878%2039.8429C28.8329%2040.6805%2028.7653%2041.1745%2028.6077%2041.1745C28.4952%2041.1745%2028.3826%2041.0886%2028.3826%2041.0027C28.3826%2040.8953%2028.135%2040.702%2027.8424%2040.5302L27.3021%2040.2509L27.7748%2039.3274C28.045%2038.7904%2028.3601%2038.4038%2028.4952%2038.4468C28.6077%2038.4897%2028.7428%2039.1126%2028.7878%2039.8429ZM22.6198%2039.177C22.8224%2039.6496%2021.8094%2040.6376%2021.3142%2040.4657C20.999%2040.3369%2021.0215%2040.2295%2021.4267%2039.5636C21.9445%2038.7475%2022.3947%2038.5971%2022.6198%2039.177Z'%20fill='white'/%3e%3cpath%20d='M44.7932%2014.5843C44.7932%2014.6272%2044.7481%2014.9709%2044.6806%2015.379C44.5681%2016.3025%2043.7577%2017.5912%2042.5421%2018.8155C41.484%2019.8894%2041.5291%2020.5123%2042.6546%2020.3834C43.2174%2020.319%2043.2624%2020.3405%2043.0373%2020.7486C42.6771%2021.3929%2042.7222%2021.5003%2043.5776%2021.9299C44.3655%2022.338%2044.388%2022.338%2044.7031%2021.9299C45.4235%2021.0278%2046.0088%2019.1592%2046.0313%2017.6557C46.0538%2016.0018%2045.6261%2014.5413%2045.1308%2014.5413C44.9507%2014.5413%2044.8157%2014.5628%2044.7932%2014.5843Z'%20fill='white'/%3e%3cpath%20d='M41.3265%2021.8225C41.0113%2022.338%2042.497%2023.777%2044.1854%2024.5288C44.9057%2024.8724%2044.9958%2025.0228%2045.1308%2025.9249C45.4235%2028.0727%2047.7646%2031.7025%2049.3404%2032.4972C50.3084%2032.9698%2050.3309%2032.8624%2049.498%2031.8744C47.8097%2029.9413%2046.7516%2026.9343%2046.8867%2024.5502L46.9542%2023.2401L45.4685%2023.0897C44.0053%2022.9179%2042.8797%2022.5527%2041.9568%2021.9299C41.6416%2021.7151%2041.439%2021.6721%2041.3265%2021.8225Z'%20fill='white'/%3e%3cpath%20d='M29.058%2021.9943C28.0225%2022.4024%2025.4337%2024.314%2025.7038%2024.4858C25.7488%2024.5073%2027.167%2024.4858%2028.8329%2024.4214C31.3316%2024.314%2032.0744%2024.2066%2032.9974%2023.7985C33.6277%2023.5408%2034.5281%2023.2401%2035.0009%2023.1756C36.6217%2022.8964%2036.1714%2022.5742%2033.7403%2022.2735C30.6788%2021.9084%2029.4632%2021.8225%2029.058%2021.9943ZM31.6467%2022.832L32.7723%2022.9823L32.0969%2023.2615C31.3766%2023.5622%2028.6077%2023.6696%2028.6077%2023.3904C28.6077%2023.1327%2029.8233%2022.4883%2030.1835%2022.5957C30.3636%2022.6387%2031.0389%2022.7461%2031.6467%2022.832Z'%20fill='white'/%3e%3cpath%20d='M35.9238%2024.0777C34.7307%2024.9583%2033.4926%2025.2805%2031.3091%2025.2805C29.1705%2025.2805%2028.6303%2025.5597%2030.251%2025.8389C31.9394%2026.1182%2033.6952%2025.9678%2035.1585%2025.4094C36.1714%2025.0228%2036.6667%2024.9369%2036.9593%2025.0872C37.7022%2025.4523%2040.0884%2025.1302%2040.0884%2024.6362C40.0884%2024.5502%2039.5031%2024.3355%2038.8052%2024.1422C38.0849%2023.9703%2037.297%2023.7555%2037.0494%2023.6911C36.7567%2023.6267%2036.3515%2023.7555%2035.9238%2024.0777Z'%20fill='white'/%3e%3cpath%20d='M23.4527%2024.9369C22.8224%2025.5812%2022.935%2025.796%2024.3532%2026.4833C25.2761%2026.9129%2025.7488%2026.9988%2026.9644%2026.9558C28.6528%2026.8914%2029.103%2026.4833%2027.7748%2026.2685C26.5817%2026.0537%2024.5783%2025.1516%2024.4207%2024.7435C24.2406%2024.2925%2024.038%2024.3355%2023.4527%2024.9369Z'%20fill='white'/%3e%3cpath%20d='M40.5386%2026.0537C40.5386%2026.1182%2040.8537%2026.4189%2041.2589%2026.741C42.317%2027.6002%2043.5776%2029.5762%2044.5005%2031.8958C44.9508%2033.0557%2045.536%2034.3444%2045.7611%2034.774C46.2339%2035.6975%2046.1213%2035.7405%2044.7031%2035.268C44.2079%2035.0961%2043.7802%2034.9458%2043.7577%2034.9458C43.6676%2034.9458%2045.1533%2038.4253%2045.6261%2039.3274C45.9412%2039.8858%2046.1663%2040.3798%2046.1213%2040.4228C46.0763%2040.4657%2045.3109%2040.5946%2044.433%2040.7235C41.1689%2041.196%2039.0979%2042.2914%2037.7247%2044.2245C37.297%2044.8473%2036.9368%2045.4272%2036.9368%2045.5132C36.9368%2045.8568%2037.3645%2045.6635%2038.0624%2045.0406C38.4676%2044.697%2039.4581%2044.0956%2040.291%2043.709C41.6416%2043.0861%2041.9793%2043.0217%2043.9152%2043.0002C46.7516%2043.0002%2047.517%2043.172%2048.8452%2044.1815C49.453%2044.6325%2049.9932%2044.9762%2050.0608%2044.9118C50.1508%2044.8044%2049.9707%2044.0526%2049.3179%2041.9907C49.0027%2040.9812%2048.0798%2039.0696%2047.6071%2038.4468C47.2469%2037.9528%2047.2469%2037.9528%2047.9897%2038.0816C48.4174%2038.1675%2049.3854%2038.4682%2050.1733%2038.7475C50.9612%2039.0482%2051.659%2039.2415%2051.7041%2039.177C51.7716%2039.1126%2051.2989%2038.4468%2050.6686%2037.695C49.5205%2036.3634%2048.575%2035.0102%2046.2114%2031.4663C44.7932%2029.3399%2042.8122%2027.1491%2041.6416%2026.4403C40.7412%2025.9034%2040.5386%2025.8389%2040.5386%2026.0537Z'%20fill='white'/%3e%3cpath%20d='M23.1826%2027.5572C23.025%2027.7505%2022.1021%2028.4808%2021.1341%2029.1896C20.1661%2029.8984%2019.3782%2030.5642%2019.3782%2030.6716C19.3782%2030.779%2019.5583%2031.0582%2019.7609%2031.2945C20.2111%2031.7885%2020.7064%2031.7025%2022.3947%2030.8864C24.5783%2029.8124%2025.9064%2028.8674%2025.6363%2028.5882C25.5688%2028.5452%2024.3982%2029.0392%2023.0025%2029.7051C21.5843%2030.3494%2020.4137%2030.8434%2020.3462%2030.8004C20.3012%2030.736%2020.7289%2030.3279%2021.3142%2029.8769C22.8674%2028.6741%2023.8804%2027.729%2023.8804%2027.4498C23.8804%2027.1062%2023.5428%2027.1706%2023.1826%2027.5572Z'%20fill='white'/%3e%3cpath%20d='M29.5082%2027.4713C29.5307%2028.3949%2031.8493%2031.2515%2033.3351%2032.1751L34.3931%2032.8194L34.2805%2033.9363C34.213%2034.8384%2034.303%2035.2465%2034.7758%2036.0841C35.4286%2037.2225%2035.4511%2036.9862%2034.3255%2040.208C33.7628%2041.7759%2034.0104%2041.9477%2034.7533%2040.5516C35.1584%2039.7999%2035.9914%2038.6615%2036.6442%2038.0387L37.8148%2036.9003L37.0044%2036.4278C35.5862%2035.5901%2035.1584%2033.786%2036.1714%2032.7765L36.7567%2032.1965L35.8788%2031.9388C33.6277%2031.23%2031.174%2029.5118%2030.3861%2028.0512C29.9584%2027.235%2029.5082%2026.9343%2029.5082%2027.4713Z'%20fill='white'/%3e%3cpath%20d='M32.4346%2027.5143C32.4346%2027.6861%2032.9299%2028.3519%2033.5377%2028.9748C34.6857%2030.1776%2036.6892%2031.2945%2037.6797%2031.2945C38.2425%2031.2945%2038.2425%2031.2945%2037.9048%2032.1751C37.4096%2033.5926%2037.8373%2034.8813%2039.368%2036.4922C39.8182%2036.9862%2040.1109%2037.4158%2039.9758%2037.4588C38.4%2037.9742%2034.6857%2042.0981%2034.6857%2043.3438C34.6857%2043.4727%2035.1359%2043.1935%2035.6987%2042.6995C37.4096%2041.196%2040.6286%2039.3274%2043.0823%2038.4038C43.42%2038.2749%2043.6901%2038.1031%2043.6901%2037.9957C43.6901%2037.9098%2043.0373%2037.3728%2042.2494%2036.8144C40.4035%2035.5257%2039.5031%2034.5377%2039.1654%2033.4423C38.9178%2032.6691%2038.9403%2032.4328%2039.3455%2031.4878C39.6156%2030.9078%2039.7507%2030.3924%2039.6832%2030.3494C39.5931%2030.3065%2039.1204%2030.1991%2038.6251%2030.1131C36.6892%2029.8124%2034.168%2028.6526%2033.2225%2027.6217C32.7498%2027.1276%2032.4346%2027.0847%2032.4346%2027.5143Z'%20fill='white'/%3e%3cpath%20d='M35.6987%2027.4069C35.6312%2027.5357%2035.7437%2027.6431%2035.9914%2027.6431C37.0494%2027.6431%2040.0208%2029.2111%2040.6286%2030.1131C40.8988%2030.5212%2040.9213%2030.8434%2040.7412%2031.9388C40.6286%2032.6906%2040.5611%2033.3349%2040.6286%2033.3779C40.8087%2033.5497%2042.3395%2030.8434%2042.3395%2030.3494C42.3395%2029.7051%2041.0338%2028.5882%2039.5481%2027.9653C38.1974%2027.4069%2035.9238%2027.0847%2035.6987%2027.4069Z'%20fill='white'/%3e%3cpath%20d='M25.006%2030.6501C24.3306%2030.9938%2022.935%2031.4878%2021.8995%2031.7455C20.8189%2032.0247%2020.0761%2032.3254%2020.1211%2032.4543C20.2561%2032.7765%2022.2146%2032.6691%2023.3627%2032.2825C24.6008%2031.8744%2026.5817%2030.6286%2026.5817%2030.285C26.5817%2029.8984%2026.4242%2029.9413%2025.006%2030.6501Z'%20fill='white'/%3e%3cpath%20d='M49.7681%2040.1865C49.7681%2040.3583%2050.1283%2040.702%2050.556%2040.9597C51.5915%2041.5826%2052.1768%2042.3988%2052.9422%2044.3318C53.9101%2046.8019%2055.621%2048.9067%2056.4314%2048.606C56.769%2048.4772%2056.7465%2048.3913%2056.2063%2047.8543C55.8686%2047.5321%2055.3058%2046.5012%2054.9456%2045.5776C54.1353%2043.5371%2053.4374%2042.5277%2051.7041%2041.0457C50.3534%2039.8858%2049.7681%2039.6281%2049.7681%2040.1865Z'%20fill='white'/%3e%3c/g%3e%3cdefs%3e%3cclipPath%20id='clip0_8_2'%3e%3crect%20width='60'%20height='60'%20fill='white'/%3e%3c/clipPath%3e%3c/defs%3e%3c/svg%3e") no-repeat center center;background-size:contain;width:1.7em;height:1.7em;vertical-align:middle;margin-right:12px;border-radius:4px}.dropdown-menu[data-v-74fa4e7e]{min-width:300px}.sticky-header[data-v-9b199225],.sidebar[data-v-9b199225]{background:var(--gem-neutral-050)}.sidebar-item[data-v-9b199225]{max-width:360px;min-width:360px}.sidebar-item[data-v-9b199225]:hover{background:var(--gem-neutral-200)}.sidebar-item:hover .sequence-number[data-v-9b199225]{background:var(--gem-neutral-050)}pre code.hljs{display:block;overflow-x:auto;padding:1em}code.hljs{padding:3px 5px}/*!
  Theme: StackOverflow Dark
  Description: Dark theme as used on stackoverflow.com
  Author: stackoverflow.com
  Maintainer: @Hirse
  Website: https://github.com/StackExchange/Stacks
  License: MIT
  Updated: 2021-05-15

  Updated for @stackoverflow/stacks v0.64.0
  Code Blocks: /blob/v0.64.0/lib/css/components/_stacks-code-blocks.less
  Colors: /blob/v0.64.0/lib/css/exports/_stacks-constants-colors.less
*/.hljs{color:#fff;background:#1c1b1b}.hljs-subst{color:#fff}.hljs-comment{color:#999}.hljs-keyword,.hljs-selector-tag,.hljs-meta .hljs-keyword,.hljs-doctag,.hljs-section,.hljs-attr{color:#88aece}.hljs-attribute{color:#c59bc1}.hljs-name,.hljs-type,.hljs-number,.hljs-selector-id,.hljs-quote,.hljs-template-tag{color:#f08d49}.hljs-selector-class{color:#88aece}.hljs-string,.hljs-regexp,.hljs-symbol,.hljs-variable,.hljs-template-variable,.hljs-link,.hljs-selector-attr{color:#b5bd68}.hljs-meta,.hljs-selector-pseudo{color:#88aece}.hljs-built_in,.hljs-title,.hljs-literal{color:#f08d49}.hljs-bullet,.hljs-code{color:#ccc}.hljs-meta .hljs-string{color:#b5bd68}.hljs-deletion{color:#de7176}.hljs-addition{color:#76c490}.hljs-emphasis{font-style:italic}.hljs-strong{font-weight:700}.rbel-message .full-width{width:100%}.rbel-message .hidden{display:none!important}.rbel-message .logo{vertical-align:middle;margin:1rem;margin-bottom:0}.rbel-message .logo img{max-width:100%;max-height:250px}.rbel-message .navbar-title{color:#029acf}.rbel-message .navbar-version{line-height:4rem}.rbel-message .header{border-bottom:3px solid #ddd;margin-bottom:2rem;padding-bottom:1rem;padding-top:1rem;background:#eee}.rbel-message .table,.rbel-message .card{max-width:100%}.rbel-message .card{background:#ddd}.rbel-message .json-note{position:relative;border-radius:.4em;border:1px solid #6b999f;color:#8aecf7;padding:.3rem;display:inline-block;margin-left:.5rem}.rbel-message h1.title{font-size:1.5rem}.rbel-message h2.title{font-size:1.25rem;color:currentColor;font-weight:700}.rbel-message .title{font-size:1.25rem;margin-bottom:.5rem;color:#373a3c}.rbel-message div.message-header{padding:.4rem}.rbel-message .notification .tile .message-body{padding:.25rem}.rbel-message .is-size-4{font-size:1.3rem!important}.rbel-message td{padding:.3rem!important;border-style:unset}.rbel-message .card-content{padding:.5rem}.rbel-message pre{color:#fa4!important;background-color:#444!important;white-space:pre-wrap;word-wrap:break-word;padding:.5rem;font-size:.7em;margin-bottom:0}.rbel-message prekey{color:#ff4500!important;background-color:#444!important;white-space:pre-wrap;word-wrap:break-word;padding:.2rem}.rbel-message pre.json{color:#adff2f!important}.rbel-message pre.binary{max-width:800px}.rbel-message pre.value,.rbel-message pre.json,.rbel-message pre.value div,.rbel-message pre.json div{word-break:break-all;white-space:break-spaces}.rbel-message pre.json{word-break:break-all;white-space:break-spaces;color:#adff2f!important;margin-top:.75rem}.rbel-message .text-ellipsis{overflow-x:hidden;white-space:nowrap;text-overflow:ellipsis}.rbel-message .card-header-title{padding:.5rem 1rem}@media print{.rbel-message .column.menu{position:static!important;display:block;overflow-x:hidden;overflow-y:auto;vertical-align:top;width:100%;height:auto;margin-left:5rem;column-count:3}.rbel-message .columns.is-fullheight{display:block!important}.rbel-message pre,.rbel-message pre.json,.rbel-message pre.value{color:#8b0000!important;background-color:#fff!important}.rbel-message .card{background:#fff}.rbel-message .page-break{break-before:page}.rbel-message div pre.json,.rbel-message div pre.value{break-inside:avoid-page}.rbel-message i.fa-angle-double-up,.rbel-message i.fa-angle-double-down,.rbel-message i.fa-toggle-on,.rbel-message i.fa-toggle-off{display:none}}@page{.rbel-message{size:594mm 420mm}}.rbel-message .radio-item{display:inline-block;position:relative;padding:0 10px}.rbel-message .radio-item input[type=radio]{display:none}.rbel-message .radio-item label{color:#aaa;font-weight:400}.rbel-message .radio-item label:before{content:" ";display:inline-block;position:relative;top:5px;margin:0 5px 0 0;width:20px;height:20px;border-radius:11px;border:2px solid #666;background-color:transparent}.rbel-message .radio-item input[type=radio]:checked+label:after{border-radius:11px;border:2px solid #469408;width:12px;height:12px;position:absolute;top:9px;left:14px;color:#469408;content:" ";display:block;background:#469408}.rbel-message .led{width:10px;height:10px;background:#666;margin-right:.5rem;margin-top:.5rem}.rbel-message .led-active{background:#469408}.rbel-message .led-error{background:#c04608}.rbel-message .modal-background{background-color:#0a0a0a5c}.rbel-message .box.routeentry{padding:1rem}.rbel-message .routeListDiv button{height:100%;width:100%}.rbel-message #sidebar-menu,.rbel-message .menu+div{padding-bottom:10rem}.rbel-message #scrollLockBtn,.rbel-message #collapsibleMessageHeaderBtn,.rbel-message #collapsibleMessageDetailsBtn,.rbel-message .dropdown-toggle{color:#aaa}.rbel-message #scrollLockBtn,.rbel-message #collapsibleMessageHeaderBtn,.rbel-message #collapsibleMessageDetailsBtn{display:inline-flex}@media screen and (max-width: 1023px){.rbel-message .navbar-menu{display:flex}}.rbel-message .navbar{margin-top:-.75rem}.rbel-message .navbar-item,.rbel-message .navbar-link{display:inline-flex;flex-direction:row;flex-wrap:nowrap;padding-bottom:1rem;line-height:1.5;padding:.5rem .75rem;color:#ffffffb3}.rbel-message .navbar-end .navbar-item{align-items:center}.rbel-message .msglist{max-width:80%}.rbel-message .msglist.embeddedlist{max-width:100%!important}.rbel-message .nested.dropdown>.dropdown-menu{display:none}.rbel-message .nested.dropdown:hover>.dropdown-menu{display:block}.rbel-message .nested.dropdown .dropdown-menu{top:-15px;margin-left:100%}.rbel-message .nested.dropdown .dropdown-trigger button:after{content:"  ⦠";margin-left:.5rem}.rbel-message .nested.dropdown .dropdown-trigger button{padding:0;border:0px;font-size:14px;font-weight:400;height:2em}.rbel-message .dropdown-content-black{background-color:#373a3c}.rbel-message .copyToClipboard-button{filter:invert(100%);margin-left:2em;margin-top:.5em}.rbel-message .dropdown-content{max-height:100vh;overflow:auto}.rbel-message .box{background-color:#fff;border-radius:6px;box-shadow:0 0 0 1px #ddd;color:#444;padding:1.25rem;margin-bottom:1.5rem}.rbel-message #contextParent{padding-left:.8rem;padding-right:.8rem}.rbel-message .col.is-one-fifth{flex:none;width:20%}.rbel-message .is-size-1{font-size:3rem!important}.rbel-message .is-size-2{font-size:2.5rem!important}.rbel-message .is-size-3{font-size:2rem!important}.rbel-message .is-size-5{font-size:1.25rem!important}.rbel-message .is-size-6{font-size:1rem!important}.rbel-message .is-size-7{font-size:.75rem!important}.rbel-message a.has-text-link:focus,.rbel-message a.has-text-link:hover{color:#205bbc!important}.rbel-message .has-text-dark{color:#373a3c!important}.rbel-message a.has-text-dark:focus,.rbel-message a.has-text-dark:hover{color:#1f2021!important}.rbel-message .has-text-weight-bold{font-weight:700!important}.rbel-message .has-text-weight-light{font-weight:300!important}.rbel-message .has-text-warning{color:#9b479f!important}.rbel-message a.mt-3.is-block{text-decoration:none}.rbel-message .has-background-dark{background-color:#373a3c!important}.rbel-message .has-text-danger{color:#d9831f!important}.rbel-message .has-text-success{color:#469408!important;text-decoration:none}.rbel-message .has-text-link{color:#029acf!important}.rbel-message .button .icon:last-child:not(:first-child){margin-left:.25em;margin-right:calc(-.5em - 1px)}.rbel-message .tile.is-ancestor:last-child{margin-bottom:-.75rem}.rbel-message .tile.is-ancestor{margin-left:-.75rem;margin-right:-.75rem;margin-top:-.75rem}.rbel-message .tile{align-items:stretch;display:block;flex-basis:0;flex-grow:1;flex-shrink:1;min-height:-webkit-min-content;min-height:-moz-min-content;min-height:min-content}.rbel-message .tile.is-child{margin:0!important}.rbel-message .tile.is-vertical>.tile.is-child{margin-top:1.5rem!important}.rbel-message .tile.is-vertical{flex-direction:column}.rbel-message .tile.is-parent{padding-left:1rem;padding-top:0rem;padding-bottom:.75rem}.rbel-message .card-header{padding:0rem}.rbel-message .notification{background-color:#f5f5f5;border-radius:4px;padding:1rem;position:relative}.rbel-message .notification.is-primary{background-color:#fef6f5;color:#d9230f;border:1px solid #f7958a}.rbel-message .notification.is-info{background-color:#f5fdfe;color:#0fc5d9;border:1px solid #8aecf7}.rbel-message .notification.is-success{background-color:#f9fef5;color:#469408;border:1px solid #90f540}.rbel-message .notification .title{color:currentColor}.rbel-message .modal-button{background-color:#fff;padding:.2rem}.rbel-message .tag:not(body).is-info.is-light{background-color:#ecfcfe;color:#0a8694}.rbel-message .tag:not(body){align-items:center;background-color:#f5f5f5;border-radius:4px;color:#444;display:inline-flex;font-size:.75rem;height:2em;justify-content:center;line-height:1.5;padding-left:.75em;padding-right:.75em;white-space:nowrap}.rbel-message .msg-sequence{height:2.5rem!important}.rbel-message .icon{align-items:center;display:inline-flex;justify-content:center;height:1.5rem;width:1.5rem}.rbel-message .btn-dark{border:1px solid #27292b;background-image:linear-gradient(180deg,#3e4244,#373a3c 60%,#303234);-webkit-filter:none;filter:none}.rbel-message article.message{margin:.5rem!important}.rbel-message .message{margin:.5rem!important}.rbel-message .message-body{color:#444;padding:.25rem}.rbel-message .filteredMessage{margin-top:15px;margin-left:1.5em;margin-bottom:1em}.rbel-message #jexlModal,.rbel-message #filterModal{max-width:75%}.rbel-message .tab{text-decoration:none;font-size:1.5rem;margin-right:1rem}.rbel-message .tabs{align-items:stretch;display:flex;font-size:1.5rem;justify-content:center;overflow:hidden;overflow-x:auto;white-space:nowrap}.rbel-message .tabs>.icon{margin-right:.5rem}.rbel-message .field{display:flex}.rbel-message .field-label{margin-right:1.5rem;text-align:right}.rbel-message .buttons.is-right{justify-content:flex-end;display:flex}.rbel-message #executeJexlQuery{margin-right:.5rem}.rbel-message .jexlstyle{display:flex;list-style-type:none;justify-content:center}.rbel-message .btn-success{color:#fff;background-color:#469408!important;border-color:#469408!important}.rbel-message .btn-outline-success{border-color:#469408!important;color:#469408}.rbel-message .btn-outline-success:hover{background-color:#469408;border-color:#469408;color:#fff}.rbel-message .text-success{color:#469408!important}.rbel-message .notification.is-warning{background-color:#fcf8fc;color:#9b479f;border:1px solid #d6a7d8}.rbel-message .message.is-warning .message-header{background-color:#9b479f;color:#fff;display:flex;justify-content:space-between}.rbel-message .container.page-break{padding-left:0;padding-right:0}.rbel-message p{margin:0;padding:0}.rbel-message .bg-success{background-color:#469408!important}.loading{display:flex;align-content:center;min-height:500px}div:has(>.table){max-width:100%;overflow-x:auto;display:block}div:has(>.table) table td pre{overflow:hidden}.container{max-width:1400px!important}.vue-recycle-scroller{position:relative}.vue-recycle-scroller.direction-vertical:not(.page-mode){overflow-y:auto}.vue-recycle-scroller.direction-horizontal:not(.page-mode){overflow-x:auto}.vue-recycle-scroller.direction-horizontal{display:flex}.vue-recycle-scroller__slot{flex:auto 0 0}.vue-recycle-scroller__item-wrapper{flex:1;box-sizing:border-box;overflow:hidden;position:relative}.vue-recycle-scroller.ready .vue-recycle-scroller__item-view{position:absolute;top:0;left:0;will-change:transform}.vue-recycle-scroller.direction-vertical .vue-recycle-scroller__item-wrapper{width:100%}.vue-recycle-scroller.direction-horizontal .vue-recycle-scroller__item-wrapper{height:100%}.vue-recycle-scroller.ready.direction-vertical .vue-recycle-scroller__item-view{width:100%}.vue-recycle-scroller.ready.direction-horizontal .vue-recycle-scroller__item-view{height:100%}.resize-observer[data-v-b329ee4c]{position:absolute;top:0;left:0;z-index:-1;width:100%;height:100%;border:none;background-color:transparent;pointer-events:none;display:block;overflow:hidden;opacity:0}.resize-observer[data-v-b329ee4c] object{display:block;position:absolute;top:0;left:0;height:100%;width:100%;overflow:hidden;pointer-events:none;z-index:-1}.container[data-v-14d251ff]{height:100%}.scroll-container[data-v-14d251ff]{transform:translateZ(0);will-change:transform}.disabled[data-v-14d251ff]{pointer-events:none}.disabled p[data-v-14d251ff],.disabled h3[data-v-14d251ff],.disabled button[data-v-14d251ff]{opacity:.1}.vue-recycle-scroller__item-wrapper[data-v-14d251ff]{overflow-y:auto}.ssh-pre{position:relative;margin-top:1em;padding:.5em;border:1px solid rgba(0,0,0,.06);background-color:#00000006;border-radius:4px;display:block}.ssh-pre--dark{background-color:#262626;color:#ffffffd9}.ssh-pre__original{display:none}.ssh-pre__content{white-space:pre-wrap;word-break:break-word}.ssh-pre__copy{position:absolute;top:3px;right:3px;border:none;background:none;color:inherit;cursor:pointer}.ssh-pre #clipboard-textarea{position:absolute;z-index:-100;opacity:0}.ssh-pre[data-label]{margin-top:2.5em}.ssh-pre[data-label]:before{content:attr(data-label);position:absolute;bottom:100%;right:1em;padding:.1em .7em 0;background-color:inherit;border:1px solid rgba(0,0,0,.06);border-bottom:1px solid #f9f9f9;border-radius:3px 3px 0 0;font-size:11px}.ssh-pre--dark[data-label]:before{border-bottom-color:#262626}.ssh-pre .txt{color:#333}.ssh-pre .comment{font-style:italic;color:#999}.ssh-pre .comment *{color:inherit!important}.ssh-pre .quote{color:#c11}.ssh-pre .quote *{color:inherit!important}.ssh-pre .htmlentity{color:#3a76ad;font-weight:700}.ssh-pre .number,.ssh-pre .boolean{color:#c11}.ssh-pre .keyword{color:#33c;font-weight:700}.ssh-pre .this{color:#c6d;font-weight:700}.ssh-pre .punctuation{color:#99f}.ssh-pre .external-var,.ssh-pre .special{color:#f63}.ssh-pre .variable{color:#29e}.ssh-pre .obj-attr{color:#0bc}.ssh-pre[data-type=shell] .keyword{color:#ff5252}.ssh-pre[data-type=shell] .param{color:#f63}.ssh-pre[data-type=html] .doctype{color:#02027e}.ssh-pre[data-type=html] .tag-name{color:#11c}.ssh-pre[data-type=html] .attribute{color:#f63}.ssh-pre[data-type=html-vue] .doctype{color:#02027e}.ssh-pre[data-type=html-vue] .tag-name{color:#42b983}.ssh-pre[data-type=html-vue] .punctuation{color:#128953}.ssh-pre[data-type=html-vue] .attribute{color:#ff5252}.ssh-pre[data-type=pug] .inline-tag{color:#9a2de6;font-weight:700;white-space:nowrap}.ssh-pre[data-type=pug] .tag-name{color:#11c;font-weight:700}.ssh-pre[data-type=pug] .punctuation{color:#999}.ssh-pre[data-type=pug] .id{color:#e3f}.ssh-pre[data-type=pug] .class{color:#09e}.ssh-pre[data-type=pug] .attribute{color:#f63}.ssh-pre[data-type=pug] .text{color:#495a70}.ssh-pre[data-type=xml] .doctype{color:#02027e}.ssh-pre[data-type=xml] .tag-name{color:#11c}.ssh-pre[data-type=xml] .attribute{color:#f93}.ssh-pre[data-type=css] .comment{color:#40b923}.ssh-pre[data-type=css] .variable{color:#29e;font-weight:700}.ssh-pre[data-type=css] .selector,.ssh-pre[data-type=css] .selector.class-id{color:#f0d}.ssh-pre[data-type=css] .pseudo{color:#f35}.ssh-pre[data-type=css] .selector.keyword{color:#f5f}.ssh-pre[data-type=css] .selector.keyword.vendor{color:#0c8}.ssh-pre[data-type=css] .keyword{color:#c06}.ssh-pre[data-type=css] .attribute{color:#70d}.ssh-pre[data-type=css] .keyword{color:#e28}.ssh-pre[data-type=css] .value{color:#c11}.ssh-pre[data-type=css] .vendor{color:#0c8}.ssh-pre[data-type=css] .color{background:#eee;padding:0 3px;border:1px solid rgba(0,0,0,.1);border-radius:3px;color:#000}.ssh-pre[data-type=css] .color--dark{color:#fff}.ssh-pre[data-type=css] .unit{color:#0bc}.ssh-pre[data-type=css] .important{color:red;font-weight:700}.ssh-pre[data-type=sql] .var-type{color:#f63;font-weight:700}.ssh-pre[data-type=json] .quote{color:#9d1515}.ssh-pre[data-type=json] .error{color:red}.ssh-pre--dark .txt{color:#ccc}.ssh-pre--dark .comment{font-style:italic;color:#7c6}.ssh-pre--dark .quote{color:#da8e72}.ssh-pre--dark .htmlentity{color:#7ba3c9;font-weight:700}.ssh-pre--dark .boolean,.ssh-pre--dark .number{color:#adcfa4}.ssh-pre--dark .keyword{color:#e67ad2}.ssh-pre--dark .this{color:#329ddb}.ssh-pre--dark .punctuation{color:#aac}.ssh-pre--dark .external-var,.ssh-pre--dark .special{color:#7bcced}.ssh-pre--dark .variable{color:#84deff}.ssh-pre--dark .obj-attr{color:#0dc}.ssh-pre--dark[data-type=shell] .keyword{color:#ff5252}.ssh-pre--dark[data-type=shell] .param{color:#7bcced}.ssh-pre--dark[data-type=html] .doctype{color:#7ec1e7}.ssh-pre--dark[data-type=html] .tag-name{color:#339cda}.ssh-pre--dark[data-type=html] .attribute{color:#7bcced}.ssh-pre--dark[data-type=html-vue] .doctype{color:#7ec1e7}.ssh-pre--dark[data-type=html-vue] .tag-name{color:#339cda}.ssh-pre--dark[data-type=html-vue] .punctuation{color:#99c}.ssh-pre--dark[data-type=html-vue] .attribute{color:#7bcced}.ssh-pre--dark[data-type=pug] .inline-tag{color:#dac933;font-weight:700}.ssh-pre--dark[data-type=pug] .tag-name{color:#339cda;font-weight:700}.ssh-pre--dark[data-type=pug] .punctuation{color:#999}.ssh-pre--dark[data-type=pug] .id{color:#ed9bfd}.ssh-pre--dark[data-type=pug] .class{color:#0ba7b3}.ssh-pre--dark[data-type=pug] .attribute{color:#8adeff}.ssh-pre--dark[data-type=pug] .text{color:#c4d8f3}.ssh-pre--dark[data-type=xml] .doctype{color:#7ec1e7}.ssh-pre--dark[data-type=xml] .tag-name{color:#339cda}.ssh-pre--dark[data-type=xml] .attribute{color:#f93}.ssh-pre--dark[data-type=css] .selector,.ssh-pre--dark[data-type=css] .class-id{color:#ff9a57}.ssh-pre--dark[data-type=css] .pseudo{color:#ff516e}.ssh-pre--dark[data-type=css] .keyword{color:#ff73ff}.ssh-pre--dark[data-type=css] .keyword{color:#c06}.ssh-pre--dark[data-type=css] .attribute{color:#70d}.ssh-pre--dark[data-type=css] .keyword{color:#ee499b}.ssh-pre--dark[data-type=css] .value{color:#cf3838}.ssh-pre--dark[data-type=css] .vendor{color:#0c8}.ssh-pre--dark[data-type=css] .color{background:#111;border-color:#ffffff40}.ssh-pre--dark[data-type=css] .color--light.color--transparent{color:#fff}.ssh-pre--dark[data-type=css] .unit{color:#0bc}.ssh-pre--dark[data-type=css] .important{color:#fe4848}.ssh-pre--dark[data-type=sql] .var-type{color:#7bcced;font-weight:700}.ssh-pre--dark[data-type=json] .quote{color:#da8e72}.ssh-pre--dark[data-type=json] .error{color:#ff4242}.ssh-pre[data-v-eb641b8b]{margin-top:0!important}.sticky-header[data-v-3ffe8330]{background:var(--gem-neutral-050)}.logo[data-v-3ffe8330]{font-family:noto-sans,sans-serif;font-weight:600;font-size:22px;line-height:1.5em;color:var(--gem-primary-700)}.logo[data-v-3ffe8330]:before{content:"";display:inline-block;background:url("data:image/svg+xml,%3csvg%20width='60'%20height='60'%20viewBox='0%200%2060%2060'%20fill='none'%20xmlns='http://www.w3.org/2000/svg'%3e%3cg%20clip-path='url(%23clip0_8_2)'%3e%3crect%20width='60'%20height='60'%20fill='%23010E52'/%3e%3cpath%20d='M20.0587%2034.838L23.1484%2034.1954L28.3146%2032.2069L27.2924%2034.2586L26.8709%2035.3939L25.0863%2033.4794L24.6426%2034.3803L24.8101%2036.3286L24.5866%2036.5168L22.2121%2034.7531L22.7353%2036.9875C22.4172%2036.9642%2022.3901%2036.2231%2021.9394%2036.8065L20.0587%2034.838Z'%20fill='%23010E52'/%3e%3cpath%20d='M20.673%2041.7451L22.9394%2040.5547L25.2541%2040.6248L29.7691%2042.4485L29.2276%2041.6189L28.9031%2038.2276L28.1735%2038.1461L26.6692%2040.666L25.3341%2040.121L25.6877%2038.2347L25.0497%2037.7168L23.0285%2040.0395L22.4442%2038.3636L21.3657%2039.1715L20.4457%2040.7802L20.673%2041.7451Z'%20fill='%23010E52'/%3e%3cpath%20d='M58.0972%2027.9009L56.6115%2026.5907C55.1482%2025.2805%2052.8296%2023.5622%2050.8937%2022.3594L49.8807%2021.7151L49.8582%2019.6961C49.8356%2017.4409%2049.498%2016.4099%2048.1473%2014.6272C47.4045%2013.6392%2043.3074%2010.7396%2043.0373%2011.0189C42.9698%2011.0833%2042.9022%2011.7921%2042.8797%2012.5653C42.8572%2014.885%2041.8442%2016.2596%2039.4581%2017.1617C39.1204%2017.2905%2037.1394%2017.4624%2035.0234%2017.5483C32.9299%2017.6557%2030.8363%2017.849%2030.4086%2017.9993C29.3056%2018.3645%2027.3246%2019.5887%2026.2441%2020.5338C24.7133%2021.9084%2023.3852%2022.6816%2020.8189%2023.6911C16.902%2025.2375%2015.799%2026.0322%2015.1236%2027.729C14.8085%2028.4808%2015.1236%2029.7695%2015.7539%2030.3064C15.9791%2030.5212%2016.2492%2031.0367%2016.3392%2031.4663C16.6544%2033.2275%2018.3427%2035.1606%2019.5583%2035.1606C19.7834%2035.1606%2020.4588%2035.6975%2021.044%2036.3419C22.7099%2038.2105%2024.2631%2038.7045%2023.2051%2037.0507C22.9575%2036.6641%2022.7549%2036.0841%2022.7549%2035.762C22.7549%2035.2035%2022.7774%2035.2035%2023.8804%2036.256L25.0285%2037.3514L24.128%2038.2749L23.2276%2039.22L22.935%2038.6401C22.4397%2037.6521%2022.012%2037.8239%2020.8189%2039.4992C19.7159%2041.0671%2019.7159%2041.0671%2019.7384%2042.7854C19.7609%2044.203%2019.9185%2044.8688%2020.6163%2046.6515C21.0891%2047.8328%2021.6518%2049.1645%2021.8995%2049.6155C22.3497%2050.4747%2022.7549%2050.5391%2022.5973%2049.7229C22.5523%2049.4437%2022.7099%2048.9067%2022.98%2048.5201C23.7904%2047.2529%2025.141%2047.1026%2027.8424%2047.9402C29.8458%2048.5631%2031.6918%2048.6275%2032.7048%2048.1335C34.5957%2047.1885%2038.8052%2048.6705%2039.8633%2050.625C40.426%2051.6775%2041.3715%2054.5556%2041.6641%2056.102C41.7992%2056.8108%2041.9568%2057.6055%2042.0243%2057.8847L42.1144%2058.3572C42.2999%2059.2366%2042.5%2060%2042.5%2060H60V29.5C60%2029.5%2059.6155%2029.2397%2058.0972%2027.9009ZM46.0988%2014.2406C47.2244%2015.3575%2048.6426%2017.7845%2048.6426%2018.6222C48.6426%2018.837%2048.3949%2019.7606%2048.1023%2020.6626C47.5845%2022.2091%2047.5845%2022.295%2047.9447%2022.7675C48.1698%2023.0253%2048.4625%2023.8844%2048.575%2024.6576C48.8226%2026.0537%2050.4209%2030.2635%2051.0287%2031.0152C51.524%2031.6811%2051.6365%2031.1441%2051.2763%2029.8124C51.0062%2028.803%2050.9837%2028.3734%2051.1863%2027.8794C51.4114%2027.2995%2051.3664%2027.1706%2050.9162%2026.6981C50.3534%2026.1396%2049.9032%2024.4428%2050.2183%2024.1421C50.466%2023.8844%2052.7846%2025.3235%2053.2573%2025.9893C53.8201%2026.8269%2053.9101%2027.9223%2053.5049%2029.6191C53.1223%2031.2945%2052.4244%2032.7335%2051.8166%2033.1631C51.5015%2033.3779%2051.5465%2033.5067%2052.2893%2034.237C53.4149%2035.3324%2054.0452%2036.7285%2054.0452%2038.1246C54.0452%2039.3059%2053.5725%2040.745%2053.1673%2040.745C52.6945%2040.745%2052.9197%2041.1745%2053.5725%2041.4752C54.4504%2041.9263%2055.8011%2043.7734%2056.5664%2045.5776C57.1067%2046.9307%2057.1742%2047.3603%2057.1968%2049.7229V52.3433L56.0487%2051.1405C54.1803%2049.1645%2052.6495%2048.0261%2052.3794%2048.4342C52.3119%2048.5416%2052.627%2048.9927%2053.0547%2049.4652C54.1578%2050.6035%2054.9682%2051.9996%2055.1933%2053.095C55.3508%2053.9542%2055.3058%2054.169%2054.5855%2055.2858C54.1578%2055.9731%2053.4599%2056.9397%2053.0097%2057.4551C52.2443%2058.3358%2052.1543%2058.3787%2051.1638%2058.3143L50.1058%2058.2499L50.1733%2057.3907C50.2859%2056.0161%2050.646%2055.1784%2051.7041%2053.9327C52.2443%2053.3098%2052.6945%2052.7084%2052.6945%2052.644C52.6945%2052.4507%2052.2893%2052.1715%2050.2183%2050.7754C49.2954%2050.1525%2048.4625%2049.5941%2048.3499%2049.5296C48.1698%2049.4007%2048.4174%2047.4677%2048.8001%2045.9427C48.8677%2045.685%2048.8226%2045.4702%2048.6651%2045.4702C48.53%2045.4702%2047.8997%2046.5012%2047.2469%2047.7684C46.6166%2049.0571%2046.0538%2050.1525%2046.0088%2050.2169C45.9637%2050.2814%2046.6166%2050.8398%2047.4495%2051.4842C48.3049%2052.1285%2049.0703%2052.7084%2049.1603%2052.7729C49.2504%2052.8588%2049.1378%2053.2454%2048.8902%2053.6535C48.3724%2054.5126%2047.517%2057.1115%2047.517%2057.8418C47.517%2058.2928%2047.4045%2058.3572%2046.7516%2058.3572C46.0763%2058.3572%2045.9863%2058.2713%2045.8512%2057.6914C45.5585%2056.2309%2045.8512%2054.0186%2046.459%2053.2454C46.5715%2053.095%2046.6166%2052.9232%2046.5265%2052.8373C46.3239%2052.644%2044.1854%2054.663%2043.7577%2055.4577L43.3975%2056.102L43.2174%2055.5221C43.1274%2055.1999%2042.9248%2054.0616%2042.7672%2052.9876C42.5421%2051.2694%2042.5421%2050.8828%2042.9022%2049.6585C43.42%2047.8113%2044.343%2046.4582%2045.4685%2045.8998C45.9863%2045.6635%2046.3915%2045.3628%2046.3915%2045.2554C46.3915%2044.9547%2046.1213%2044.9762%2044.6581%2045.5132C43.7126%2045.8353%2042.9923%2046.3079%2042.0693%2047.2314C41.349%2047.9187%2040.7637%2048.6275%2040.7637%2048.7994C40.7637%2049.2504%2040.5836%2049.2074%2039.7282%2048.4772C38.6702%2047.5966%2037.4096%2047.0166%2036.2165%2046.8448C34.6182%2046.63%2034.6182%2046.63%2035.2485%2045.7494C35.7437%2045.0406%2035.9914%2044.1815%2035.6987%2044.1815C35.6537%2044.1815%2035.1585%2044.6325%2034.6407%2045.1695C33.6052%2046.2434%2031.8944%2047.1885%2030.9714%2047.1885C30.6788%2047.1885%2029.4857%2046.8878%2028.3376%2046.5226C25.6363%2045.6635%2024.128%2045.7065%2022.6648%2046.6945C21.4267%2047.5321%2021.3817%2047.4677%2021.2241%2044.4607L21.1116%2042.2914L22.1021%2041.6685C22.9125%2041.153%2023.2951%2041.0671%2024.5332%2041.0671C25.8389%2041.0671%2026.3116%2041.196%2028.3151%2042.0766C30.9489%2043.2579%2031.9619%2043.3653%2032.7498%2042.5921C33.2675%2042.1196%2033.29%2041.9907%2033.2225%2039.0052C33.155%2035.3324%2032.8173%2034.3229%2031.1065%2032.712C29.3956%2031.1012%2027.7973%2031.0797%2025.141%2032.6046C24.2406%2033.1201%2022.8899%2033.6571%2021.7644%2033.9148L19.9185%2034.3873L19.0856%2033.8933C18.2977%2033.4208%2017.3522%2032.1536%2017.0371%2031.1441C16.902%2030.7575%2016.9921%2030.6716%2017.5323%2030.5427C18.3202%2030.3924%2020.0536%2029.0392%2020.0536%2028.5667C20.0536%2028.309%2019.9185%2028.3304%2019.2882%2028.6956C18.8154%2028.9963%2018.1626%2029.1466%2017.4648%2029.1466H16.4068L16.5643%2028.3519C16.7669%2027.235%2017.2172%2026.4833%2017.8475%2026.2041C18.1176%2026.0537%2019.3332%2025.6456%2020.5038%2025.2805C23.1601%2024.4428%2023.8129%2024.0777%2027.0095%2021.6507C30.1385%2019.2666%2030.5662%2019.1806%2032.6597%2020.5982C33.7853%2021.35%2034.213%2021.5003%2035.361%2021.5862C36.239%2021.6507%2036.8243%2021.5862%2037.0494%2021.4144C37.4996%2021.0707%2037.2745%2020.77%2036.5766%2020.77C35.8788%2020.77%2034.9333%2020.319%2034.3706%2019.7176L33.9429%2019.2666H35.0684C36.1264%2019.2666%2036.2615%2019.331%2037.207%2020.2975C37.7697%2020.8774%2038.4901%2021.7151%2038.8052%2022.1876C39.5031%2023.2401%2040.9438%2024.5502%2041.6191%2024.7435C42.2494%2024.9154%2042.2494%2024.6147%2041.6416%2024.0777C40.9663%2023.5193%2040.3135%2022.1017%2040.3135%2021.1781C40.3135%2020.5982%2040.1334%2020.2546%2039.5256%2019.6961C38.6026%2018.837%2038.5576%2018.6222%2039.278%2018.6222C39.5706%2018.6222%2040.426%2018.3215%2041.1914%2017.9349C42.3845%2017.355%2042.6546%2017.0972%2043.1724%2016.0878C43.51%2015.4434%2043.8252%2014.391%2043.8702%2013.7681C43.9603%2012.6727%2043.9828%2012.6297%2044.4555%2012.866C44.7031%2012.9949%2045.446%2013.6177%2046.0988%2014.2406ZM56.7015%2028.4378C57.1067%2028.9104%2057.2193%2029.2111%2057.1067%2029.7695C57.0167%2030.3924%2057.0392%2030.4568%2057.4219%2030.3709C57.8271%2030.2635%2057.8721%2030.3709%2057.8721%2031.2515C57.8496%2032.1321%2057.8271%2032.218%2057.5569%2031.8744C57.3993%2031.6811%2057.1517%2031.5092%2057.0392%2031.5092C56.8591%2031.5092%2055.8461%2035.2465%2055.8461%2035.8479C55.8461%2036.256%2056.4539%2035.9553%2056.9041%2035.3324L57.3993%2034.6451L57.6245%2035.225C57.782%2035.6331%2057.782%2036.6641%2057.6019%2038.5756L57.3543%2041.3463L56.4764%2040.6805C55.621%2039.9932%2055.621%2039.9932%2055.756%2038.7904C55.8911%2037.5661%2055.4184%2035.676%2054.6305%2034.3229C54.3604%2033.8504%2054.4054%2033.5926%2054.9456%2032.0247C55.3058%2031.0367%2055.666%2029.7051%2055.7335%2029.0392C55.8236%2028.3949%2055.9586%2027.8579%2056.0262%2027.8579C56.1162%2027.8579%2056.4089%2028.1157%2056.7015%2028.4378ZM27.3471%2032.9913C27.5272%2033.249%2026.9419%2034.7954%2026.6268%2034.9028C26.4692%2034.9458%2026.3566%2034.8384%2026.3566%2034.6666C26.3566%2034.4947%2026.2891%2034.0652%2026.2216%2033.7C26.109%2033.1846%2026.1766%2033.0342%2026.4917%2032.9483C27.167%2032.7765%2027.2346%2032.7979%2027.3471%2032.9913ZM29.3056%2033.7645C31.084%2034.9458%2032.5922%2037.4158%2032.3221%2038.6615C32.097%2039.6925%2031.3541%2040.702%2030.5887%2041.0886C29.7333%2041.5182%2029.5982%2041.3463%2029.4181%2039.6925C29.058%2036.8359%2028.7878%2036.6641%2027.6623%2038.5971C27.2571%2039.3059%2026.7618%2039.8858%2026.5592%2039.8858C25.974%2039.8858%2025.7038%2039.4348%2025.8389%2038.683C25.9064%2038.2964%2025.8839%2037.8024%2025.7939%2037.5876C25.6813%2037.3728%2025.5913%2037.0936%2025.5913%2036.9862C25.5688%2036.8574%2025.4337%2036.4063%2025.2536%2035.9553C24.9835%2035.182%2025.051%2034.0866%2025.4112%2034.0866C25.5012%2034.0866%2025.9064%2034.6666%2026.3116%2035.3968C27.167%2036.8788%2027.6173%2036.9433%2027.5272%2035.5901C27.4597%2034.5377%2027.8424%2033.2275%2028.2251%2033.2275C28.3601%2033.2275%2028.8329%2033.4638%2029.3056%2033.7645ZM24.5107%2035.0532C24.4882%2036.213%2024.083%2036.3204%2023.6778%2035.268C23.3627%2034.4303%2023.4752%2034.0866%2024.1055%2034.0866C24.4432%2034.0866%2024.5107%2034.2585%2024.5107%2035.0532ZM22.057%2035.3968C22.2821%2036.0412%2022.2371%2036.4493%2021.8995%2036.4493C21.6518%2036.4493%2021.0215%2035.2894%2021.1341%2034.9887C21.2917%2034.4947%2021.8094%2034.731%2022.057%2035.3968ZM25.3436%2038.4038C25.4337%2038.5112%2025.4337%2038.8549%2025.3662%2039.1556C25.2536%2039.5207%2025.0735%2039.671%2024.6683%2039.671C24.0155%2039.671%2023.948%2039.3274%2024.4657%2038.6401C24.8484%2038.1246%2025.1185%2038.0387%2025.3436%2038.4038ZM28.7878%2039.8429C28.8329%2040.6805%2028.7653%2041.1745%2028.6077%2041.1745C28.4952%2041.1745%2028.3826%2041.0886%2028.3826%2041.0027C28.3826%2040.8953%2028.135%2040.702%2027.8424%2040.5302L27.3021%2040.2509L27.7748%2039.3274C28.045%2038.7904%2028.3601%2038.4038%2028.4952%2038.4468C28.6077%2038.4897%2028.7428%2039.1126%2028.7878%2039.8429ZM22.6198%2039.177C22.8224%2039.6496%2021.8094%2040.6376%2021.3142%2040.4657C20.999%2040.3369%2021.0215%2040.2295%2021.4267%2039.5636C21.9445%2038.7475%2022.3947%2038.5971%2022.6198%2039.177Z'%20fill='white'/%3e%3cpath%20d='M44.7932%2014.5843C44.7932%2014.6272%2044.7481%2014.9709%2044.6806%2015.379C44.5681%2016.3025%2043.7577%2017.5912%2042.5421%2018.8155C41.484%2019.8894%2041.5291%2020.5123%2042.6546%2020.3834C43.2174%2020.319%2043.2624%2020.3405%2043.0373%2020.7486C42.6771%2021.3929%2042.7222%2021.5003%2043.5776%2021.9299C44.3655%2022.338%2044.388%2022.338%2044.7031%2021.9299C45.4235%2021.0278%2046.0088%2019.1592%2046.0313%2017.6557C46.0538%2016.0018%2045.6261%2014.5413%2045.1308%2014.5413C44.9507%2014.5413%2044.8157%2014.5628%2044.7932%2014.5843Z'%20fill='white'/%3e%3cpath%20d='M41.3265%2021.8225C41.0113%2022.338%2042.497%2023.777%2044.1854%2024.5288C44.9057%2024.8724%2044.9958%2025.0228%2045.1308%2025.9249C45.4235%2028.0727%2047.7646%2031.7025%2049.3404%2032.4972C50.3084%2032.9698%2050.3309%2032.8624%2049.498%2031.8744C47.8097%2029.9413%2046.7516%2026.9343%2046.8867%2024.5502L46.9542%2023.2401L45.4685%2023.0897C44.0053%2022.9179%2042.8797%2022.5527%2041.9568%2021.9299C41.6416%2021.7151%2041.439%2021.6721%2041.3265%2021.8225Z'%20fill='white'/%3e%3cpath%20d='M29.058%2021.9943C28.0225%2022.4024%2025.4337%2024.314%2025.7038%2024.4858C25.7488%2024.5073%2027.167%2024.4858%2028.8329%2024.4214C31.3316%2024.314%2032.0744%2024.2066%2032.9974%2023.7985C33.6277%2023.5408%2034.5281%2023.2401%2035.0009%2023.1756C36.6217%2022.8964%2036.1714%2022.5742%2033.7403%2022.2735C30.6788%2021.9084%2029.4632%2021.8225%2029.058%2021.9943ZM31.6467%2022.832L32.7723%2022.9823L32.0969%2023.2615C31.3766%2023.5622%2028.6077%2023.6696%2028.6077%2023.3904C28.6077%2023.1327%2029.8233%2022.4883%2030.1835%2022.5957C30.3636%2022.6387%2031.0389%2022.7461%2031.6467%2022.832Z'%20fill='white'/%3e%3cpath%20d='M35.9238%2024.0777C34.7307%2024.9583%2033.4926%2025.2805%2031.3091%2025.2805C29.1705%2025.2805%2028.6303%2025.5597%2030.251%2025.8389C31.9394%2026.1182%2033.6952%2025.9678%2035.1585%2025.4094C36.1714%2025.0228%2036.6667%2024.9369%2036.9593%2025.0872C37.7022%2025.4523%2040.0884%2025.1302%2040.0884%2024.6362C40.0884%2024.5502%2039.5031%2024.3355%2038.8052%2024.1422C38.0849%2023.9703%2037.297%2023.7555%2037.0494%2023.6911C36.7567%2023.6267%2036.3515%2023.7555%2035.9238%2024.0777Z'%20fill='white'/%3e%3cpath%20d='M23.4527%2024.9369C22.8224%2025.5812%2022.935%2025.796%2024.3532%2026.4833C25.2761%2026.9129%2025.7488%2026.9988%2026.9644%2026.9558C28.6528%2026.8914%2029.103%2026.4833%2027.7748%2026.2685C26.5817%2026.0537%2024.5783%2025.1516%2024.4207%2024.7435C24.2406%2024.2925%2024.038%2024.3355%2023.4527%2024.9369Z'%20fill='white'/%3e%3cpath%20d='M40.5386%2026.0537C40.5386%2026.1182%2040.8537%2026.4189%2041.2589%2026.741C42.317%2027.6002%2043.5776%2029.5762%2044.5005%2031.8958C44.9508%2033.0557%2045.536%2034.3444%2045.7611%2034.774C46.2339%2035.6975%2046.1213%2035.7405%2044.7031%2035.268C44.2079%2035.0961%2043.7802%2034.9458%2043.7577%2034.9458C43.6676%2034.9458%2045.1533%2038.4253%2045.6261%2039.3274C45.9412%2039.8858%2046.1663%2040.3798%2046.1213%2040.4228C46.0763%2040.4657%2045.3109%2040.5946%2044.433%2040.7235C41.1689%2041.196%2039.0979%2042.2914%2037.7247%2044.2245C37.297%2044.8473%2036.9368%2045.4272%2036.9368%2045.5132C36.9368%2045.8568%2037.3645%2045.6635%2038.0624%2045.0406C38.4676%2044.697%2039.4581%2044.0956%2040.291%2043.709C41.6416%2043.0861%2041.9793%2043.0217%2043.9152%2043.0002C46.7516%2043.0002%2047.517%2043.172%2048.8452%2044.1815C49.453%2044.6325%2049.9932%2044.9762%2050.0608%2044.9118C50.1508%2044.8044%2049.9707%2044.0526%2049.3179%2041.9907C49.0027%2040.9812%2048.0798%2039.0696%2047.6071%2038.4468C47.2469%2037.9528%2047.2469%2037.9528%2047.9897%2038.0816C48.4174%2038.1675%2049.3854%2038.4682%2050.1733%2038.7475C50.9612%2039.0482%2051.659%2039.2415%2051.7041%2039.177C51.7716%2039.1126%2051.2989%2038.4468%2050.6686%2037.695C49.5205%2036.3634%2048.575%2035.0102%2046.2114%2031.4663C44.7932%2029.3399%2042.8122%2027.1491%2041.6416%2026.4403C40.7412%2025.9034%2040.5386%2025.8389%2040.5386%2026.0537Z'%20fill='white'/%3e%3cpath%20d='M23.1826%2027.5572C23.025%2027.7505%2022.1021%2028.4808%2021.1341%2029.1896C20.1661%2029.8984%2019.3782%2030.5642%2019.3782%2030.6716C19.3782%2030.779%2019.5583%2031.0582%2019.7609%2031.2945C20.2111%2031.7885%2020.7064%2031.7025%2022.3947%2030.8864C24.5783%2029.8124%2025.9064%2028.8674%2025.6363%2028.5882C25.5688%2028.5452%2024.3982%2029.0392%2023.0025%2029.7051C21.5843%2030.3494%2020.4137%2030.8434%2020.3462%2030.8004C20.3012%2030.736%2020.7289%2030.3279%2021.3142%2029.8769C22.8674%2028.6741%2023.8804%2027.729%2023.8804%2027.4498C23.8804%2027.1062%2023.5428%2027.1706%2023.1826%2027.5572Z'%20fill='white'/%3e%3cpath%20d='M29.5082%2027.4713C29.5307%2028.3949%2031.8493%2031.2515%2033.3351%2032.1751L34.3931%2032.8194L34.2805%2033.9363C34.213%2034.8384%2034.303%2035.2465%2034.7758%2036.0841C35.4286%2037.2225%2035.4511%2036.9862%2034.3255%2040.208C33.7628%2041.7759%2034.0104%2041.9477%2034.7533%2040.5516C35.1584%2039.7999%2035.9914%2038.6615%2036.6442%2038.0387L37.8148%2036.9003L37.0044%2036.4278C35.5862%2035.5901%2035.1584%2033.786%2036.1714%2032.7765L36.7567%2032.1965L35.8788%2031.9388C33.6277%2031.23%2031.174%2029.5118%2030.3861%2028.0512C29.9584%2027.235%2029.5082%2026.9343%2029.5082%2027.4713Z'%20fill='white'/%3e%3cpath%20d='M32.4346%2027.5143C32.4346%2027.6861%2032.9299%2028.3519%2033.5377%2028.9748C34.6857%2030.1776%2036.6892%2031.2945%2037.6797%2031.2945C38.2425%2031.2945%2038.2425%2031.2945%2037.9048%2032.1751C37.4096%2033.5926%2037.8373%2034.8813%2039.368%2036.4922C39.8182%2036.9862%2040.1109%2037.4158%2039.9758%2037.4588C38.4%2037.9742%2034.6857%2042.0981%2034.6857%2043.3438C34.6857%2043.4727%2035.1359%2043.1935%2035.6987%2042.6995C37.4096%2041.196%2040.6286%2039.3274%2043.0823%2038.4038C43.42%2038.2749%2043.6901%2038.1031%2043.6901%2037.9957C43.6901%2037.9098%2043.0373%2037.3728%2042.2494%2036.8144C40.4035%2035.5257%2039.5031%2034.5377%2039.1654%2033.4423C38.9178%2032.6691%2038.9403%2032.4328%2039.3455%2031.4878C39.6156%2030.9078%2039.7507%2030.3924%2039.6832%2030.3494C39.5931%2030.3065%2039.1204%2030.1991%2038.6251%2030.1131C36.6892%2029.8124%2034.168%2028.6526%2033.2225%2027.6217C32.7498%2027.1276%2032.4346%2027.0847%2032.4346%2027.5143Z'%20fill='white'/%3e%3cpath%20d='M35.6987%2027.4069C35.6312%2027.5357%2035.7437%2027.6431%2035.9914%2027.6431C37.0494%2027.6431%2040.0208%2029.2111%2040.6286%2030.1131C40.8988%2030.5212%2040.9213%2030.8434%2040.7412%2031.9388C40.6286%2032.6906%2040.5611%2033.3349%2040.6286%2033.3779C40.8087%2033.5497%2042.3395%2030.8434%2042.3395%2030.3494C42.3395%2029.7051%2041.0338%2028.5882%2039.5481%2027.9653C38.1974%2027.4069%2035.9238%2027.0847%2035.6987%2027.4069Z'%20fill='white'/%3e%3cpath%20d='M25.006%2030.6501C24.3306%2030.9938%2022.935%2031.4878%2021.8995%2031.7455C20.8189%2032.0247%2020.0761%2032.3254%2020.1211%2032.4543C20.2561%2032.7765%2022.2146%2032.6691%2023.3627%2032.2825C24.6008%2031.8744%2026.5817%2030.6286%2026.5817%2030.285C26.5817%2029.8984%2026.4242%2029.9413%2025.006%2030.6501Z'%20fill='white'/%3e%3cpath%20d='M49.7681%2040.1865C49.7681%2040.3583%2050.1283%2040.702%2050.556%2040.9597C51.5915%2041.5826%2052.1768%2042.3988%2052.9422%2044.3318C53.9101%2046.8019%2055.621%2048.9067%2056.4314%2048.606C56.769%2048.4772%2056.7465%2048.3913%2056.2063%2047.8543C55.8686%2047.5321%2055.3058%2046.5012%2054.9456%2045.5776C54.1353%2043.5371%2053.4374%2042.5277%2051.7041%2041.0457C50.3534%2039.8858%2049.7681%2039.6281%2049.7681%2040.1865Z'%20fill='white'/%3e%3c/g%3e%3cdefs%3e%3cclipPath%20id='clip0_8_2'%3e%3crect%20width='60'%20height='60'%20fill='white'/%3e%3c/clipPath%3e%3c/defs%3e%3c/svg%3e") no-repeat center center;background-size:contain;width:1.7em;height:1.7em;vertical-align:middle;margin-right:12px;border-radius:4px}.filter[data-v-3ffe8330]{min-width:300px;width:100%;max-width:500px;text-overflow:ellipsis}.no-focus[data-v-3ffe8330]:focus{outline:none!important;box-shadow:none!important;border-color:inherit!important}.jexlResponseLink{cursor:pointer;border-radius:4px;padding:1px 2px}.jexlResponseLink:hover{background:var(--gem-neutral-600)}.flex-2[data-v-4e00a315]{flex:2}.flex-3[data-v-4e00a315]{flex:3}.flex-4[data-v-4e00a315]{flex:4}.flex-5[data-v-4e00a315]{flex:5}.flex-grow-2[data-v-96bd5fad]{flex-grow:2}.single-message-page[data-v-1e3919ae]{min-height:100vh;background-color:#f8f9fa}.message-container[data-v-1e3919ae]{background-color:#fff;border-radius:8px;box-shadow:0 2px 4px #0000001a;overflow:hidden}</style>
  </head>
  <body>
    <div id="app"></div>
  </body>
</html>
`;export{e as default};
//# sourceMappingURL=index-C8uB39J8.js.map
