/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.util;

import de.gematik.rbellogger.util.RbelContent;
import de.gematik.test.tiger.common.util.TcpIpConnectionIdentifier;
import de.gematik.test.tiger.proxy.data.TcpConnectionEntry;
import de.gematik.test.tiger.util.AsyncByteQueue;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;

public class AsyncByteQueue {
    private final AtomicReference<Node> head = new AtomicReference<Object>(null);
    private final AtomicReference<Node> tail = new AtomicReference<Object>(null);
    private final TcpIpConnectionIdentifier primaryDirection;
    private final AtomicReference<String> lastBufferedUuid = new AtomicReference<Object>(null);

    public TcpConnectionEntry write(TcpConnectionEntry value) {
        Node newNode = new Node(this, value);
        Node prevTail = this.tail.getAndSet(newNode);
        if (prevTail == null) {
            this.head.set(newNode);
        } else {
            prevTail.next = newNode;
            newNode.previous = prevTail;
        }
        String previousUuid = this.lastBufferedUuid.getAndSet(value.getUuid());
        if (value.getPreviousUuid() != null) {
            previousUuid = value.getPreviousUuid();
        }
        return value.toBuilder().previousUuid(previousUuid).build();
    }

    public synchronized TcpConnectionEntry peek() {
        Node headNode = (Node)this.head.get();
        if (headNode == null) {
            return TcpConnectionEntry.empty();
        }
        LinkedList<RbelContent> data = new LinkedList<RbelContent>();
        boolean initialDirection = headNode.isPrimaryDirection;
        int initialReadPos = headNode.readPos;
        ArrayList<String> sourceUuids = new ArrayList<String>();
        Node current = headNode;
        while (current != null) {
            int availableBytes;
            if (current.isPrimaryDirection == initialDirection && (availableBytes = current.availableBytes()) > 0) {
                RbelContent snapshot = current.readPos > 0 ? current.data.subArray(current.readPos, current.readPos + availableBytes) : current.data;
                data.add(snapshot);
                sourceUuids.add(current.uuid);
            }
            current = current.next;
        }
        TcpIpConnectionIdentifier direction = initialDirection ? this.primaryDirection : this.primaryDirection.reverse();
        return TcpConnectionEntry.builder().uuid(headNode.uuid).data(RbelContent.of(data)).connectionIdentifier(direction).messagePreProcessor(headNode.preProcessingMessageManipulator).positionInBaseNode(Integer.valueOf(initialReadPos)).messageKind(headNode.messageKind).build().addAdditionalData(headNode.additionalData).addSourceUuids(sourceUuids);
    }

    public synchronized void consume(long count) {
        Node headNode;
        Node currentNode = headNode = (Node)this.head.get();
        while (count > 0L && currentNode != null) {
            if (currentNode.isPrimaryDirection == headNode.isPrimaryDirection) {
                int available = currentNode.availableBytes();
                if (count >= (long)available) {
                    count -= (long)available;
                    this.removeNode(currentNode);
                } else {
                    currentNode.readPos += (int)count;
                    count = 0L;
                }
            }
            currentNode = currentNode.next;
        }
    }

    private synchronized void removeNode(Node node) {
        if (node.previous == null) {
            this.head.set(node.next);
            if (node.next != null) {
                node.next.previous = null;
            } else {
                this.tail.set(null);
            }
        } else {
            node.previous.next = node.next;
            if (node.next != null) {
                node.next.previous = node.previous;
            } else {
                this.tail.set(node.previous);
            }
        }
    }

    public synchronized boolean isEmpty() {
        return this.head.get() == null || this.availableBytes() == 0;
    }

    public synchronized int availableBytes() {
        Node headNode;
        int total = 0;
        Node current = headNode = (Node)this.head.get();
        while (current != null) {
            if (current.isPrimaryDirection == headNode.isPrimaryDirection) {
                total += current.availableBytes();
            }
            current = current.next;
        }
        return total;
    }

    @ConstructorProperties(value={"primaryDirection"})
    @Generated
    public AsyncByteQueue(TcpIpConnectionIdentifier primaryDirection) {
        this.primaryDirection = primaryDirection;
    }
}

