/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.tracing;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelMessageMetadata;
import de.gematik.rbellogger.data.core.ProxyTransmissionHistory;
import de.gematik.rbellogger.data.core.RbelRequestFacet;
import de.gematik.rbellogger.data.core.RbelResponseFacet;
import de.gematik.rbellogger.data.core.RbelTcpIpMessageFacet;
import de.gematik.rbellogger.util.RbelContent;
import de.gematik.rbellogger.util.RbelSocketAddress;
import de.gematik.test.tiger.proxy.TigerProxy;
import de.gematik.test.tiger.proxy.client.TigerExceptionDto;
import de.gematik.test.tiger.proxy.client.TigerTracingDto;
import de.gematik.test.tiger.proxy.client.TracingMessagePart;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.simp.SimpMessagingTemplate;

public class TracingPushService {
    public static final int MAX_MESSAGE_SIZE = 524288;
    private final SimpMessagingTemplate template;
    private final TigerProxy tigerProxy;
    private Logger log = LoggerFactory.getLogger(TracingPushService.class);

    public void addWebSocketListener() {
        this.tigerProxy.addRbelMessageListener(arg_0 -> this.propagateRbelMessageSafe(arg_0));
        this.tigerProxy.addNewExceptionConsumer(arg_0 -> this.propagateExceptionSafe(arg_0));
        this.log = LoggerFactory.getLogger((String)(TracingPushService.class.getName() + "(" + this.tigerProxy.proxyName() + ")"));
    }

    private void propagateExceptionSafe(Throwable exc) {
        try {
            this.log.atTrace().addArgument(exc::getMessage).log("Transmitting Exception: {}");
            this.propagateException(exc);
        }
        catch (RuntimeException e) {
            this.log.error("Error while propagating Exception", (Throwable)e);
            throw e;
        }
    }

    private void propagateRbelMessageSafe(RbelElement msg) {
        try {
            if (!msg.hasFacet(RbelTcpIpMessageFacet.class)) {
                this.log.atTrace().addArgument(() -> ((RbelElement)msg).getUuid()).log("Skipping propagation, not a TCP/IP message {}");
                return;
            }
            this.waitForPreviousMessageFullyProcessed(msg);
            this.propagateRbelMessage(msg);
        }
        catch (RuntimeException e) {
            this.log.error("Error while propagating new Rbel-Message", (Throwable)e);
            throw e;
        }
    }

    private synchronized void propagateRbelMessage(RbelElement msg) {
        this.log.atTrace().addArgument(() -> RbelTcpIpMessageFacet.getSequenceNumber((RbelElement)msg)).addArgument(() -> Optional.ofNullable(msg.getRawStringContent()).map(String::lines).flatMap(Stream::findFirst).orElse("<>")).addArgument(() -> msg.getFacet(RbelMessageMetadata.class).map(RbelMessageMetadata::toMap)).log("Transmitting message #{}: {}\nwith metadata: {}");
        this.sendMessageToRemotes(msg, msg.getFacet(RbelMessageMetadata.class).orElse(new RbelMessageMetadata()));
    }

    private void sendMessageToRemotes(RbelElement msg, RbelMessageMetadata metadata) {
        try {
            RbelTcpIpMessageFacet rbelTcpIpMessageFacet = (RbelTcpIpMessageFacet)msg.getFacetOrFail(RbelTcpIpMessageFacet.class);
            RbelSocketAddress sender = Optional.ofNullable(rbelTcpIpMessageFacet.getSender()).map(RbelElement::getRawStringContent).flatMap(RbelSocketAddress::fromString).orElse(null);
            RbelSocketAddress receiver = Optional.ofNullable(rbelTcpIpMessageFacet.getReceiver()).map(RbelElement::getRawStringContent).flatMap(RbelSocketAddress::fromString).orElse(null);
            this.log.atTrace().addArgument(() -> ((RbelElement)msg).getUuid()).log("Propagating message via mesh... (ID: {})");
            TigerTracingDto tracingDto = TigerTracingDto.builder().receiver(receiver).sender(sender).messageUuid(msg.getUuid()).additionalInformation(this.gatherAdditionalInformation(metadata)).sequenceNumber(rbelTcpIpMessageFacet.getSequenceNumber()).proxyTransmissionHistory(new ProxyTransmissionHistory(this.tigerProxy.getTigerProxyConfiguration().getName(), List.of(rbelTcpIpMessageFacet.getSequenceNumber()), (ProxyTransmissionHistory)msg.getFacet(ProxyTransmissionHistory.class).orElse(null))).request(msg.hasFacet(RbelRequestFacet.class) || !msg.hasFacet(RbelResponseFacet.class)).build();
            this.template.convertAndSend((Object)"/topic/traces", (Object)tracingDto);
            this.mapRbelMessageAndSent(msg);
            this.log.trace("completed sending message {}", (Object)msg.getUuid());
        }
        catch (RuntimeException e) {
            this.log.error("Error while sending message: {}", (Object)e.getMessage());
            throw e;
        }
    }

    private Map<String, Object> gatherAdditionalInformation(RbelMessageMetadata metadata) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        metadata.forEach(result::put);
        return result;
    }

    private void propagateException(Throwable exception) {
        this.template.convertAndSend((Object)"/topic/errors", (Object)TigerExceptionDto.builder().className(exception.getClass().getName()).message(exception.getMessage()).stacktrace(ExceptionUtils.getStackTrace((Throwable)exception)).build());
    }

    private void mapRbelMessageAndSent(RbelElement rbelMessage) {
        if (rbelMessage == null) {
            return;
        }
        RbelContent content = rbelMessage.getContent();
        if (content.isNull()) {
            return;
        }
        int size = content.size();
        int chunkSize = content.getChunkSize();
        int numberOfParts = (size + chunkSize - 1) / chunkSize;
        int i = 0;
        int nextPartIndex = 0;
        while (nextPartIndex < size) {
            byte[] partContent = content.toByteArray(nextPartIndex, Math.min(nextPartIndex + chunkSize, size));
            this.log.atTrace().addArgument((Object)(i + 1)).addArgument((Object)numberOfParts).addArgument((Object)rbelMessage.getUuid()).log("sending part {} of {} for UUID {}...");
            this.template.convertAndSend((Object)"/topic/data", (Object)TracingMessagePart.builder().data(partContent).index(i).uuid(rbelMessage.getUuid()).numberOfMessages(numberOfParts).build());
            nextPartIndex += partContent.length;
            ++i;
        }
    }

    private void waitForPreviousMessageFullyProcessed(RbelElement msg) {
        this.tigerProxy.getRbelLogger().getRbelConverter().waitForAllElementsBeforeGivenToBeParsed(msg);
    }

    @ConstructorProperties(value={"template", "tigerProxy"})
    @Generated
    public TracingPushService(SimpMessagingTemplate template, TigerProxy tigerProxy) {
        this.template = template;
        this.tigerProxy = tigerProxy;
    }
}

