/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.tracing;

import de.gematik.test.tiger.common.data.config.tigerproxy.TigerProxyConfiguration;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextStoppedEvent;
import org.springframework.messaging.simp.config.ChannelRegistration;
import org.springframework.messaging.simp.config.MessageBrokerRegistry;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ExecutorConfigurationSupport;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.web.socket.config.annotation.EnableWebSocketMessageBroker;
import org.springframework.web.socket.config.annotation.StompEndpointRegistry;
import org.springframework.web.socket.config.annotation.WebSocketMessageBrokerConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketTransportRegistration;
import org.springframework.web.socket.server.HandshakeHandler;
import org.springframework.web.socket.server.RequestUpgradeStrategy;
import org.springframework.web.socket.server.standard.TomcatRequestUpgradeStrategy;
import org.springframework.web.socket.server.support.DefaultHandshakeHandler;

/*
 * Exception performing whole class analysis ignored.
 */
@Configuration
@EnableWebSocketMessageBroker
public class TracingEndpointConfiguration
implements WebSocketMessageBrokerConfigurer,
ApplicationListener<ContextStoppedEvent> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TracingEndpointConfiguration.class);
    private final TigerProxyConfiguration tigerProxyConfiguration;
    private final List<ThreadPoolTaskExecutor> taskExecutors = new ArrayList();
    private final List<ThreadPoolTaskScheduler> schedulers = new ArrayList();

    private static ThreadPoolTaskExecutor getThreadPoolTaskExecutor() {
        ThreadPoolTaskExecutor threadPoolTaskExecutor = new ThreadPoolTaskExecutor();
        threadPoolTaskExecutor.setWaitForTasksToCompleteOnShutdown(true);
        threadPoolTaskExecutor.setAwaitTerminationSeconds(2);
        threadPoolTaskExecutor.setCorePoolSize(4);
        threadPoolTaskExecutor.setMaxPoolSize(10);
        threadPoolTaskExecutor.initialize();
        return threadPoolTaskExecutor;
    }

    private static ThreadPoolTaskScheduler getThreadPoolTaskScheduler() {
        ThreadPoolTaskScheduler scheduler = new ThreadPoolTaskScheduler();
        scheduler.setThreadNamePrefix("TGR_scheduler-");
        scheduler.setWaitForTasksToCompleteOnShutdown(true);
        scheduler.setAwaitTerminationSeconds(2);
        scheduler.setPoolSize(4);
        scheduler.initialize();
        return scheduler;
    }

    public void configureMessageBroker(MessageBrokerRegistry config) {
        config.enableSimpleBroker(new String[]{"/topic"});
        config.setApplicationDestinationPrefixes(new String[]{this.tigerProxyConfiguration.getTrafficEndpointConfiguration().getStompTopic()});
        config.configureBrokerChannel().taskExecutor(TracingEndpointConfiguration.getThreadPoolTaskExecutor());
    }

    public void registerStompEndpoints(StompEndpointRegistry registry) {
        registry.addEndpoint(new String[]{this.tigerProxyConfiguration.getTrafficEndpointConfiguration().getWsEndpoint()}).withSockJS().setTaskScheduler((TaskScheduler)TracingEndpointConfiguration.getThreadPoolTaskScheduler());
        registry.addEndpoint(new String[]{this.tigerProxyConfiguration.getTrafficEndpointConfiguration().getWsEndpoint()}).setHandshakeHandler((HandshakeHandler)new DefaultHandshakeHandler((RequestUpgradeStrategy)new TomcatRequestUpgradeStrategy())).setAllowedOrigins(new String[]{"*"}).withSockJS().setTaskScheduler((TaskScheduler)TracingEndpointConfiguration.getThreadPoolTaskScheduler());
        registry.addEndpoint(new String[]{"/newMessages"}).setHandshakeHandler((HandshakeHandler)new DefaultHandshakeHandler((RequestUpgradeStrategy)new TomcatRequestUpgradeStrategy())).withSockJS().setTaskScheduler((TaskScheduler)TracingEndpointConfiguration.getThreadPoolTaskScheduler());
    }

    public void configureClientOutboundChannel(ChannelRegistration registration) {
        registration.taskExecutor(TracingEndpointConfiguration.getThreadPoolTaskExecutor());
    }

    public void configureClientInboundChannel(ChannelRegistration registration) {
        registration.taskExecutor(TracingEndpointConfiguration.getThreadPoolTaskExecutor());
    }

    public void onApplicationEvent(ContextStoppedEvent event) {
        this.taskExecutors.forEach(ExecutorConfigurationSupport::shutdown);
        this.schedulers.forEach(ExecutorConfigurationSupport::shutdown);
    }

    public void configureWebSocketTransport(WebSocketTransportRegistration registration) {
        log.info("Configuring WebSocket transport with buffer size limit: {} MB", (Object)this.tigerProxyConfiguration.getStompClientBufferSizeInMb());
        registration.setSendBufferSizeLimit(this.tigerProxyConfiguration.getStompClientBufferSizeInMb() * 0x100000);
    }

    @ConstructorProperties(value={"tigerProxyConfiguration"})
    @Generated
    public TracingEndpointConfiguration(TigerProxyConfiguration tigerProxyConfiguration) {
        this.tigerProxyConfiguration = tigerProxyConfiguration;
    }
}

