/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.tls.vau;

import com.fasterxml.jackson.databind.JsonNode;
import de.gematik.rbellogger.RbelConversionExecutor;
import de.gematik.rbellogger.RbelConversionPhase;
import de.gematik.rbellogger.RbelConverterPlugin;
import de.gematik.rbellogger.converter.ConverterInfo;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.core.RbelFacet;
import de.gematik.rbellogger.data.core.RbelRootFacet;
import de.gematik.rbellogger.data.core.TracingMessagePairFacet;
import de.gematik.rbellogger.facets.http.RbelHttpMessageFacet;
import de.gematik.rbellogger.facets.http.RbelHttpRequestFacet;
import de.gematik.rbellogger.facets.http.RbelHttpResponseFacet;
import de.gematik.rbellogger.facets.jackson.RbelJsonFacet;
import de.gematik.rbellogger.facets.vau.vau.RbelVauEpaFacet;
import de.gematik.test.tiger.proxy.tls.vau.VauSessionFacet;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConverterInfo(onlyActivateFor={"epa-vau"})
public class RbelVauSessionListener
extends RbelConverterPlugin {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelVauSessionListener.class);
    private static final String RECORD_ID_KVNR_RBEL_PATH = "$.Data.content.decoded.AuthorizationAssertion.content.decoded.Assertion.AttributeStatement.Attribute.AttributeValue.RecordIdentifier.InsurantId.extension";
    private final Map<String, VauSessionFacet> clientHelloHashToSessionMap = new HashMap();
    private final Map<String, VauSessionFacet> keyIdToSessionMap = new HashMap();

    public RbelConversionPhase getPhase() {
        return RbelConversionPhase.CONTENT_ENRICHMENT;
    }

    public void consumeElement(RbelElement rbelElement, RbelConversionExecutor converter) {
        if (rbelElement.hasFacet(VauSessionFacet.class)) {
            return;
        }
        this.safeExecute(() -> this.tagVauClientHello(rbelElement));
        this.safeExecute(() -> this.tagVauServerHello(rbelElement));
        this.safeExecute(() -> this.tagVauClientSigFin(rbelElement));
        this.safeExecute(() -> this.tagVauServerFin(rbelElement));
        this.safeExecute(() -> this.tagDocvMessageByKeyId(rbelElement));
    }

    private void tagVauClientHello(RbelElement rbelElement) {
        this.findVauHandshakeMessageWithCommandAndHttpType(rbelElement, "VAUClientHello", RbelHttpRequestFacet.class).ifPresent(jsonRoot -> jsonRoot.findElement(RECORD_ID_KVNR_RBEL_PATH).map(RbelElement::getRawStringContent).ifPresent(insurantId -> jsonRoot.addFacet((RbelFacet)VauSessionFacet.builder().recordId(RbelElement.wrap((RbelElement)jsonRoot, (Object)insurantId)).build())));
    }

    private void tagVauServerHello(RbelElement rbelElement) {
        this.findVauHandshakeMessageWithCommandAndHttpType(rbelElement, "VAUServerHello", RbelHttpResponseFacet.class).ifPresent(jsonRoot -> rbelElement.getFacet(TracingMessagePairFacet.class).map(TracingMessagePairFacet::getRequest).flatMap(req -> req.getFacet(RbelHttpMessageFacet.class).map(RbelHttpMessageFacet::getBody).flatMap(body -> body.getFacet(VauSessionFacet.class))).ifPresent(vauSessionFacet -> {
            VauSessionFacet.buildFromOtherInstanceForRoot((VauSessionFacet)vauSessionFacet, (RbelElement)jsonRoot);
            jsonRoot.findElement("$.Data.content.decoded.VAUClientHelloDataHash").map(RbelElement::getRawStringContent).ifPresent(hash -> this.clientHelloHashToSessionMap.put(hash, vauSessionFacet));
        }));
    }

    private void tagVauClientSigFin(RbelElement rbelElement) {
        this.findVauHandshakeMessageWithCommandAndHttpType(rbelElement, "VAUClientSigFin", RbelHttpRequestFacet.class).ifPresent(jsonRoot -> jsonRoot.findElement("$.VAUClientHelloDataHash").map(RbelElement::getRawStringContent).map(this.clientHelloHashToSessionMap::get).ifPresent(vauSessionFacet -> {
            VauSessionFacet.buildFromOtherInstanceForRoot((VauSessionFacet)vauSessionFacet, (RbelElement)jsonRoot);
            jsonRoot.findElement("$.FinishedData.content.keyId").map(RbelElement::getRawStringContent).ifPresent(hash -> this.keyIdToSessionMap.put(hash, vauSessionFacet));
        }));
    }

    private void tagVauServerFin(RbelElement rbelElement) {
        this.findVauHandshakeMessageWithCommandAndHttpType(rbelElement, "VAUServerFin", RbelHttpResponseFacet.class).ifPresent(jsonRoot -> jsonRoot.getParentNode().getFacet(TracingMessagePairFacet.class).map(TracingMessagePairFacet::getRequest).flatMap(req -> req.getFacet(RbelHttpMessageFacet.class).map(RbelHttpMessageFacet::getBody).flatMap(body -> body.getFacet(VauSessionFacet.class))).ifPresent(vauSessionFacet -> VauSessionFacet.buildFromOtherInstanceForRoot((VauSessionFacet)vauSessionFacet, (RbelElement)jsonRoot)));
    }

    private void tagDocvMessageByKeyId(RbelElement rbelElement) {
        Optional.ofNullable(rbelElement).flatMap(el -> el.getFacet(RbelHttpMessageFacet.class)).map(RbelHttpMessageFacet::getBody).filter(el -> el.getFacet(RbelRootFacet.class).map(RbelRootFacet::getRootFacet).filter(RbelVauEpaFacet.class::isInstance).isPresent()).ifPresent(vauRoot -> vauRoot.findElement("$.keyId").map(RbelElement::getRawStringContent).map(this.keyIdToSessionMap::get).ifPresent(vauSessionFacet -> VauSessionFacet.buildFromOtherInstanceForRoot((VauSessionFacet)vauSessionFacet, (RbelElement)vauRoot)));
    }

    private void safeExecute(Runnable function) {
        try {
            function.run();
        }
        catch (RuntimeException e) {
            log.atTrace().addArgument(RbelVauSessionListener.class::getSimpleName).addArgument((Object)e).log("Swallowed exception during safe execution in {}: {}");
        }
    }

    private Optional<RbelElement> findVauHandshakeMessageWithCommandAndHttpType(RbelElement rbelElement, String command, Class<? extends RbelFacet> httpType) {
        Optional<RbelElement> jsonRootElement = Optional.ofNullable(rbelElement).filter(el -> el.hasFacet(httpType)).flatMap(el -> el.getFacet(RbelHttpMessageFacet.class)).map(RbelHttpMessageFacet::getBody).filter(el -> el.getFacet(RbelRootFacet.class).map(RbelRootFacet::getRootFacet).filter(RbelJsonFacet.class::isInstance).isPresent());
        if (!jsonRootElement.flatMap(el -> el.getFacet(RbelJsonFacet.class)).map(RbelJsonFacet::getJsonElement).map(json -> json.get("MessageType")).map(JsonNode::textValue).orElse("").equals(command)) {
            return Optional.empty();
        }
        return jsonRootElement;
    }
}

