/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.tls;

import de.gematik.test.tiger.common.pki.TigerPkiIdentity;
import de.gematik.test.tiger.common.util.TigerSecurityProviderInitialiser;
import de.gematik.test.tiger.mockserver.socket.tls.KeyAlgorithmPreference;
import de.gematik.test.tiger.mockserver.socket.tls.KeyAndCertificateFactory;
import de.gematik.test.tiger.proxy.exceptions.TigerProxySslException;
import de.gematik.test.tiger.proxy.tls.StaticKeyAndCertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.security.auth.x500.X500Principal;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class StaticKeyAndCertificateFactory
implements KeyAndCertificateFactory {
    private final List<TigerPkiIdentity> availableIdentities = new ArrayList();

    public StaticKeyAndCertificateFactory(List<TigerPkiIdentity> availableIdentities) {
        if (CollectionUtils.isEmpty(availableIdentities)) {
            throw new TigerProxySslException("No available identities provided in StaticKeyAndCertificateFactory");
        }
        this.availableIdentities.addAll(availableIdentities);
    }

    public Optional<TigerPkiIdentity> findExactIdentityForHostname(String hostname, KeyAlgorithmPreference keyAlgorithmPreference) {
        return this.availableIdentities.stream().filter(id -> this.matchesHostname(id.getCertificate(), hostname)).filter(id -> keyAlgorithmPreference.matches(id)).findAny();
    }

    public TigerPkiIdentity resolveIdentityForHostname(String hostname, KeyAlgorithmPreference algorithmPreference) {
        return this.findExactIdentityForHostname(hostname, algorithmPreference).orElseGet(() -> (TigerPkiIdentity)this.availableIdentities.get(0));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean matchesHostname(X509Certificate certificate, String hostname) {
        try {
            if (StringUtils.isEmpty((CharSequence)hostname)) {
                return true;
            }
            if (this.subjectMatches(certificate.getSubjectX500Principal(), hostname)) {
                return true;
            }
            Collection<List<?>> alternativeNames = certificate.getSubjectAlternativeNames();
            if (alternativeNames == null) return false;
            if (!alternativeNames.stream().flatMap(Collection::stream).map(Object::toString).anyMatch(hostname::equalsIgnoreCase)) return false;
            return true;
        }
        catch (CertificateParsingException e) {
            return false;
        }
    }

    private boolean subjectMatches(X500Principal subjectX500Principal, String hostname) {
        String dn = subjectX500Principal.getName();
        for (String part : dn.split(",")) {
            if (!part.startsWith("CN=")) continue;
            return part.substring(3).equalsIgnoreCase(hostname);
        }
        return false;
    }

    @Generated
    public static StaticKeyAndCertificateFactoryBuilder builder() {
        return new StaticKeyAndCertificateFactoryBuilder();
    }

    static {
        TigerSecurityProviderInitialiser.initialize();
    }
}

