/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.tls;

import de.gematik.test.tiger.common.pki.TigerConfigurationPkiIdentity;
import java.security.cert.X509Certificate;
import java.util.Date;
import lombok.Generated;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.BasicOCSPRespBuilder;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.CertificateStatus;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.OCSPRespBuilder;
import org.bouncycastle.cert.ocsp.RespID;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OcspUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OcspUtils.class);

    public static byte[] buildOcspResponse(X509Certificate certificate, TigerConfigurationPkiIdentity ocspSignerIdentity) {
        log.info("Building OCSP response...");
        CertificateID certID = new CertificateID(new BcDigestCalculatorProvider().get(CertificateID.HASH_SHA1), (X509CertificateHolder)new JcaX509CertificateHolder(certificate), certificate.getSerialNumber());
        String signerDigestAlgorithm = ocspSignerIdentity.getCertificate().getSigAlgName();
        ContentSigner contentSigner = new JcaContentSignerBuilder(signerDigestAlgorithm).setProvider("BC").build(ocspSignerIdentity.getPrivateKey());
        BasicOCSPRespBuilder basicRespGen = new BasicOCSPRespBuilder(SubjectPublicKeyInfo.getInstance((Object)ocspSignerIdentity.getCertificate().getPublicKey().getEncoded()), new JcaDigestCalculatorProviderBuilder().setProvider("BC").build().get(RespID.HASH_SHA1));
        basicRespGen.addResponse(certID, CertificateStatus.GOOD);
        BasicOCSPResp basicOcspResp = basicRespGen.build(contentSigner, new X509CertificateHolder[]{new X509CertificateHolder(ocspSignerIdentity.getCertificate().getEncoded())}, new Date());
        OCSPRespBuilder ocspResponseGenerator = new OCSPRespBuilder();
        OCSPResp ocspResponse = ocspResponseGenerator.build(0, (Object)basicOcspResp);
        return ocspResponse.getEncoded();
    }

    @Generated
    private OcspUtils() {
    }
}

