/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.handler;

import de.gematik.rbellogger.RbelConversionPhase;
import de.gematik.rbellogger.RbelConverter;
import de.gematik.rbellogger.RbelConverterPlugin;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelMessageMetadata;
import de.gematik.rbellogger.data.core.RbelFacet;
import de.gematik.rbellogger.data.core.RbelHostnameFacet;
import de.gematik.rbellogger.data.core.RbelTcpIpMessageFacet;
import de.gematik.rbellogger.data.core.UnparsedChunkFacet;
import de.gematik.rbellogger.file.BundledServerNameWriterAndReader;
import de.gematik.rbellogger.util.GlobalServerMap;
import de.gematik.rbellogger.util.RbelContent;
import de.gematik.rbellogger.util.RbelSocketAddress;
import de.gematik.test.tiger.common.util.TcpIpConnectionIdentifier;
import de.gematik.test.tiger.proxy.AbstractTigerProxy;
import de.gematik.test.tiger.proxy.data.TcpConnectionEntry;
import de.gematik.test.tiger.proxy.handler.BinaryExchangeHandler;
import de.gematik.test.tiger.proxy.handler.BundledServerNamesAdder;
import de.gematik.test.tiger.proxy.handler.SingleConnectionParser;
import de.gematik.test.tiger.util.AsyncByteQueue;
import de.gematik.test.tiger.util.DeterministicUuidGenerator;
import io.micrometer.common.util.StringUtils;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class SingleConnectionParser {
    public static final RbelMessageMetadata.RbelMetadataValue<Boolean> IS_PROPAGATED_CHUNK_FROM_UPSTREAM_TIGER_PROXY = new RbelMessageMetadata.RbelMetadataValue("propagatedMessageChunk", Boolean.class);
    private final BundledServerNamesAdder bundledServerNamesAdder = new BundledServerNamesAdder();
    private final ExecutorService executor;
    private final BinaryExchangeHandler binaryExchangeHandler;
    private final RbelConverter rbelConverter;
    private final String proxyName;
    private final AsyncByteQueue bufferedParts;
    private final Logger log;
    private String lastMessageUuid = null;

    public SingleConnectionParser(TcpIpConnectionIdentifier connectionIdentifier, AbstractTigerProxy tigerProxy, BinaryExchangeHandler binaryExchangeHandler) {
        this.binaryExchangeHandler = binaryExchangeHandler;
        this.rbelConverter = tigerProxy.getRbelLogger().getRbelConverter();
        this.bufferedParts = new AsyncByteQueue(connectionIdentifier);
        this.executor = tigerProxy.getExecutor();
        this.proxyName = tigerProxy.proxyName();
        this.log = LoggerFactory.getLogger((String)(tigerProxy.getName().orElse("TigerProxy") + "-ConnectionParser"));
        this.setMessageRemovalCallbacks(tigerProxy);
    }

    private void setMessageRemovalCallbacks(AbstractTigerProxy tigerProxy) {
        this.rbelConverter.addClearHistoryCallback(() -> {
            this.lastMessageUuid = null;
        });
        this.rbelConverter.addMessageRemovedFromHistoryCallback(element -> {
            if (element.getUuid().equals(this.lastMessageUuid)) {
                this.lastMessageUuid = null;
            }
        });
        tigerProxy.addRemovedMessageUuidsHandler(uuids -> {
            if (this.lastMessageUuid != null && uuids.contains(this.lastMessageUuid)) {
                this.lastMessageUuid = null;
            }
        });
    }

    public SingleConnectionParser(TcpIpConnectionIdentifier connectionIdentifier, ExecutorService executor, RbelConverter rbelConverter, BinaryExchangeHandler binaryExchangeHandler) {
        this.binaryExchangeHandler = binaryExchangeHandler;
        this.rbelConverter = rbelConverter;
        this.executor = executor;
        this.bufferedParts = new AsyncByteQueue(connectionIdentifier);
        this.proxyName = null;
        this.log = LoggerFactory.getLogger(this.getClass());
        this.setMessageRemovalCallbacks((AbstractTigerProxy)binaryExchangeHandler.getTigerProxy());
    }

    private List<RbelElement> handleException(Throwable throwable, TcpIpConnectionIdentifier connectionId, TcpConnectionEntry entry) {
        this.log.warn("Exception while parsing buffered content for message {}", (Object)entry.getUuid(), (Object)throwable);
        this.binaryExchangeHandler.propagateExceptionMessageSafe(throwable, connectionId.sender(), connectionId.receiver());
        return List.of();
    }

    public CompletableFuture<List<RbelElement>> bufferNewPart(TcpConnectionEntry entry) {
        TcpConnectionEntry bufferedEntry = this.bufferedParts.write(entry);
        CompletableFuture.runAsync(() -> this.propagateNewChunk(bufferedEntry), this.executor).exceptionally(e -> {
            this.log.warn("Exception while propagating new chunk for message {}: {}", new Object[]{bufferedEntry.getUuid(), e.getMessage(), e});
            return null;
        });
        return CompletableFuture.supplyAsync(() -> this.parseAllAvailableMessages(), this.executor).exceptionally(e -> this.handleException(e, bufferedEntry.getConnectionIdentifier(), entry));
    }

    private void propagateNewChunk(TcpConnectionEntry entry) {
        if (entry.getAdditionalData().getOrDefault(IS_PROPAGATED_CHUNK_FROM_UPSTREAM_TIGER_PROXY.getKey(), false) == Boolean.FALSE) {
            this.log.atTrace().addArgument(() -> ((TcpConnectionEntry)entry).getUuid()).log("Skipping propagation of local message chunk {}");
            return;
        }
        RbelElement messageElement = RbelElement.builder().uuid(entry.getUuid()).content(entry.getData()).build();
        RbelMessageMetadata messageMetadata = SingleConnectionParser.readMetadataFromBufferedContent((TcpConnectionEntry)entry);
        IS_PROPAGATED_CHUNK_FROM_UPSTREAM_TIGER_PROXY.putValue(messageMetadata, (Object)true);
        messageElement.addFacet((RbelFacet)messageMetadata);
        RbelMessageMetadata.PREVIOUS_MESSAGE_UUID.putValue(messageMetadata, (Object)entry.getPreviousUuid());
        messageElement.addFacet((RbelFacet)RbelTcpIpMessageFacet.builder().receiver(RbelMessageMetadata.MESSAGE_RECEIVER.getValue(messageMetadata).map(h -> RbelHostnameFacet.buildRbelHostnameFacet((RbelElement)messageElement, (RbelSocketAddress)h)).orElse(RbelHostnameFacet.buildRbelHostnameFacet((RbelElement)messageElement, null))).sender(RbelMessageMetadata.MESSAGE_SENDER.getValue(messageMetadata).map(h -> RbelHostnameFacet.buildRbelHostnameFacet((RbelElement)messageElement, (RbelSocketAddress)h)).orElse(RbelHostnameFacet.buildRbelHostnameFacet((RbelElement)messageElement, null))).sequenceNumber(Long.valueOf(this.rbelConverter.addMessageToHistoryWithNextSequenceNumber(messageElement))).build());
        this.log.atTrace().addArgument(() -> ((RbelContent)messageElement.getContent()).size()).addArgument(() -> ((RbelElement)messageElement).getUuid()).addArgument(() -> ((RbelElement)messageElement).getRawStringContent()).log("Propagating chunk with {} bytes and uuid {}: {}");
        this.rbelConverter.transmitElement(messageElement);
    }

    private void setBundledServerName(TcpConnectionEntry entry) {
        if (!StringUtils.isBlank((String)this.proxyName) && !this.proxyName.equals("local_tiger_proxy")) {
            SingleConnectionParser.getDynamicConnectionEndpoint((TcpConnectionEntry)entry).ifPresent(adr -> GlobalServerMap.addServerNameForPort((int)adr.getPort(), (String)this.proxyName));
        }
    }

    private static Optional<RbelSocketAddress> getDynamicConnectionEndpoint(TcpConnectionEntry entry) {
        TcpIpConnectionIdentifier connectionId = entry.getConnectionIdentifier();
        if (entry.getMessageKind().isRequest()) {
            if (entry.getAdditionalData().containsKey(BundledServerNameWriterAndReader.BUNDLED_HOSTNAME_SENDER.getKey())) {
                return Optional.empty();
            }
            return Optional.ofNullable(connectionId.sender());
        }
        if (entry.getAdditionalData().containsKey(BundledServerNameWriterAndReader.BUNDLED_HOSTNAME_RECEIVER.getKey())) {
            return Optional.empty();
        }
        return Optional.ofNullable(connectionId.receiver());
    }

    private synchronized List<RbelElement> parseAllAvailableMessages() {
        Optional message;
        ArrayList<RbelElement> result = new ArrayList<RbelElement>();
        this.log.atTrace().addArgument(() -> ((AsyncByteQueue)this.bufferedParts).availableBytes()).log("Starting to parse all available messages for connection parser, buffered parts: {}");
        while (!this.bufferedParts.isEmpty() && (message = this.tryToConvertMessage()).isPresent()) {
            this.lastMessageUuid = ((RbelElement)message.get()).getUuid();
            this.bufferedParts.consume(((RbelElement)message.get()).getSize());
            result.add((RbelElement)message.get());
        }
        return result;
    }

    private Optional<RbelElement> tryToConvertMessage() {
        if (this.bufferedParts.isEmpty()) {
            return Optional.empty();
        }
        TcpConnectionEntry bufferedContent = this.bufferedParts.peek();
        this.setBundledServerName(bufferedContent);
        int originalSize = bufferedContent.getData().size();
        RbelElement messageElement = RbelElement.builder().uuid(this.getOrGenerateUuid(bufferedContent)).content(bufferedContent.getData()).build();
        this.log.atTrace().addArgument(() -> ((TcpConnectionEntry)bufferedContent).getUuid()).addArgument(() -> ((RbelElement)messageElement).getUuid()).addArgument(() -> ((TcpIpConnectionIdentifier)bufferedContent.getConnectionIdentifier()).sender()).addArgument(() -> ((TcpIpConnectionIdentifier)bufferedContent.getConnectionIdentifier()).receiver()).addArgument(() -> ((RbelContent)bufferedContent.getData()).size()).log("Trying to convert message with base-uuid {} and given uuid {} from {} to {} with {} bytes");
        Optional.ofNullable(bufferedContent.getMessagePreProcessor()).ifPresent(manipulator -> manipulator.accept(messageElement));
        RbelMessageMetadata messageMetadata = SingleConnectionParser.readMetadataFromBufferedContent((TcpConnectionEntry)bufferedContent);
        if (this.lastMessageUuid != null) {
            RbelMessageMetadata.PREVIOUS_MESSAGE_UUID.putValue(messageMetadata, (Object)this.lastMessageUuid);
            this.log.atTrace().addArgument(() -> ((RbelElement)messageElement).getUuid()).addArgument((Object)this.lastMessageUuid).log("Setting previous message uuid of {} to {}");
        }
        messageElement.addFacet((RbelFacet)new SingleConnectionParserMarkerFacet(bufferedContent.getSourceUuids()));
        this.log.atTrace().addArgument(() -> ((RbelContent)messageElement.getContent()).size()).addArgument(() -> ((RbelElement)messageElement).getUuid()).log("Trying to parse message with {} bytes and uuid {}");
        RbelElement result = this.triggerActualMessageParsing(messageElement, messageMetadata);
        messageElement.removeFacetsOfType(SingleConnectionParserMarkerFacet.class);
        if (result.getConversionPhase() == RbelConversionPhase.DELETED) {
            this.log.atTrace().addArgument(() -> bufferedContent.getData().size()).addArgument(() -> ((TcpIpConnectionIdentifier)bufferedContent.getConnectionIdentifier()).printDirectionSymbol()).log("Tried parsing for buffered content with {} bytes, FAILED with direction {}");
            return Optional.empty();
        }
        this.log.atTrace().addArgument(() -> bufferedContent.getData().size()).addArgument(() -> ((TcpIpConnectionIdentifier)bufferedContent.getConnectionIdentifier()).printDirectionSymbol()).addArgument(() -> ((RbelElement)result).getUuid()).addArgument(() -> RbelConverterPlugin.messageIsCompleteOrParsingDeactivated((RbelElement)result)).log("Tried parsing for buffered content with {} bytes, SUCCESS with direction {} and UUID {}. Is complete: {}");
        this.bundledServerNamesAdder.addBundledServerNameToHostnameFacet(result);
        if (!this.rbelConverter.isActivateRbelParsing()) {
            result.addOrReplaceFacet((RbelFacet)new UnparsedChunkFacet());
        }
        this.log.atTrace().addArgument((Object)originalSize).addArgument(() -> ((RbelElement)result).getSize()).log("parsed one message with {} bytes and {} used");
        return Optional.of(result).filter(RbelConverterPlugin::messageIsCompleteOrParsingDeactivated);
    }

    public RbelElement triggerActualMessageParsing(RbelElement messageElement, RbelMessageMetadata messageMetadata) {
        return this.rbelConverter.parseMessage(messageElement, messageMetadata);
    }

    private String getOrGenerateUuid(TcpConnectionEntry bufferedContent) {
        if (bufferedContent.getPositionInBaseNode() > 0 || Boolean.TRUE.equals(bufferedContent.getAdditionalData().getOrDefault(IS_PROPAGATED_CHUNK_FROM_UPSTREAM_TIGER_PROXY.getKey(), false))) {
            return DeterministicUuidGenerator.generateUuid((String)bufferedContent.getUuid(), (Integer)bufferedContent.getPositionInBaseNode());
        }
        return bufferedContent.getUuid();
    }

    private static RbelMessageMetadata readMetadataFromBufferedContent(TcpConnectionEntry bufferedContent) {
        RbelMessageMetadata metadata = new RbelMessageMetadata().withSender(bufferedContent.getConnectionIdentifier().sender()).withReceiver(bufferedContent.getConnectionIdentifier().receiver());
        bufferedContent.getAdditionalData().forEach((arg_0, arg_1) -> ((RbelMessageMetadata)metadata).addMetadata(arg_0, arg_1));
        return metadata;
    }

    @ConstructorProperties(value={"executor", "binaryExchangeHandler", "rbelConverter", "proxyName", "bufferedParts", "log"})
    @Generated
    public SingleConnectionParser(ExecutorService executor, BinaryExchangeHandler binaryExchangeHandler, RbelConverter rbelConverter, String proxyName, AsyncByteQueue bufferedParts, Logger log) {
        this.executor = executor;
        this.binaryExchangeHandler = binaryExchangeHandler;
        this.rbelConverter = rbelConverter;
        this.proxyName = proxyName;
        this.bufferedParts = bufferedParts;
        this.log = log;
    }
}

