/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.handler;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelMessageKind;
import de.gematik.rbellogger.data.RbelMessageMetadata;
import de.gematik.rbellogger.util.RbelContent;
import de.gematik.rbellogger.util.RbelSocketAddress;
import de.gematik.test.tiger.common.util.TcpIpConnectionIdentifier;
import de.gematik.test.tiger.proxy.AbstractTigerProxy;
import de.gematik.test.tiger.proxy.data.TcpConnectionEntry;
import de.gematik.test.tiger.proxy.handler.BinaryExchangeHandler;
import de.gematik.test.tiger.proxy.handler.SingleConnectionParser;
import java.beans.ConstructorProperties;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipleBinaryConnectionParser {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MultipleBinaryConnectionParser.class);
    private final Map<TcpIpConnectionIdentifier, SingleConnectionParser> connectionParsers = new ConcurrentHashMap();
    private final Function<TcpIpConnectionIdentifier, SingleConnectionParser> createSingleConnectionParser;
    private final List<CompletableFuture<List<RbelElement>>> currentParsingTasks = Collections.synchronizedList(new ArrayList());

    public MultipleBinaryConnectionParser(AbstractTigerProxy tigerProxy, BinaryExchangeHandler binaryExchangeHandler) {
        this.createSingleConnectionParser = conId -> new SingleConnectionParser(conId, tigerProxy, binaryExchangeHandler);
    }

    public CompletableFuture<List<RbelElement>> addToBuffer(RbelSocketAddress senderAddress, RbelSocketAddress receiverAddress, byte[] part, ZonedDateTime timestamp, RbelMessageKind messageKind) {
        return this.addToBuffer(UUID.randomUUID().toString(), senderAddress, receiverAddress, part, Map.of(RbelMessageMetadata.MESSAGE_TRANSMISSION_TIME.getKey(), timestamp), messageKind, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<List<RbelElement>> addToBuffer(String uuid, RbelSocketAddress senderAddress, RbelSocketAddress receiverAddress, byte[] part, Map<String, Object> additionalData, RbelMessageKind messageKind, Consumer<RbelElement> messagePreProcessor, String previousMessageUuid) {
        TcpIpConnectionIdentifier connectionId = new TcpIpConnectionIdentifier(senderAddress, receiverAddress);
        SingleConnectionParser connectionParser = (SingleConnectionParser)this.connectionParsers.computeIfAbsent(connectionId, this.createSingleConnectionParser);
        CompletableFuture future = connectionParser.bufferNewPart(TcpConnectionEntry.builder().uuid(uuid).data(RbelContent.of((byte[])part)).connectionIdentifier(connectionId).messagePreProcessor(messagePreProcessor).previousUuid(previousMessageUuid).messageKind(messageKind).build().addAdditionalData(additionalData));
        List list = this.currentParsingTasks;
        synchronized (list) {
            this.currentParsingTasks.add(future);
        }
        future.whenComplete((message, throwable) -> {
            List list = this.currentParsingTasks;
            synchronized (list) {
                this.currentParsingTasks.remove(future);
            }
        });
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForAllParsingTasksToBeFinished() {
        ArrayList tasks;
        List list = this.currentParsingTasks;
        synchronized (list) {
            tasks = new ArrayList(this.currentParsingTasks);
        }
        if (!tasks.isEmpty()) {
            log.trace("Waiting for all parsing tasks to finish, found {} tasks", (Object)tasks.size());
            CompletableFuture<Void> currentParsingTasksFuture = CompletableFuture.allOf(tasks.toArray(new CompletableFuture[0]));
            currentParsingTasksFuture.join();
            log.trace("All {} parsing tasks finished", (Object)tasks.size());
        }
    }

    @ConstructorProperties(value={"createSingleConnectionParser"})
    @Generated
    public MultipleBinaryConnectionParser(Function<TcpIpConnectionIdentifier, SingleConnectionParser> createSingleConnectionParser) {
        this.createSingleConnectionParser = createSingleConnectionParser;
    }
}

