/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.handler;

import de.gematik.test.tiger.mockserver.model.Header;
import de.gematik.test.tiger.mockserver.model.HttpRequest;
import de.gematik.test.tiger.proxy.TigerProxy;
import de.gematik.test.tiger.proxy.data.TigerProxyRoute;
import de.gematik.test.tiger.proxy.handler.AbstractRouteProxyCallback;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForwardProxyCallback
extends AbstractRouteProxyCallback {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ForwardProxyCallback.class);

    public ForwardProxyCallback(TigerProxy tigerProxy, TigerProxyRoute tigerRoute) {
        super(tigerProxy, tigerRoute);
        tigerProxy.addAlternativeName(this.getSourceUri().getHost());
    }

    public HttpRequest handleRequest(HttpRequest req) {
        this.applyModifications(req);
        req.replaceHeader(Header.header((String)"Host", (String[])new String[]{this.getTargetUrl().getHost() + ":" + this.getPort()}));
        if (this.getTigerRoute().getAuthentication() != null) {
            this.getTigerRoute().getAuthentication().toAuthorizationHeaderValue().ifPresent(auth -> req.replaceHeader(Header.header((String)"Authorization", (String[])new String[]{auth})));
        }
        String path = this.patchPath(req.getPath());
        return this.cloneRequest(req).setPath(path).setSecure(Boolean.valueOf(this.getTigerRoute().getTo().startsWith("https://"))).setQueryStringParameters(req.getQueryStringParameters());
    }

    protected String extractProtocolAndHostForRequest(HttpRequest request) {
        return this.getSourceUri().getScheme() + "://" + this.getSourceUri().getHost();
    }

    protected String printTrafficTarget(HttpRequest req) {
        return this.getTigerRoute().getTo();
    }
}

