/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.handler;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelMessageKind;
import de.gematik.rbellogger.data.RbelMessageMetadata;
import de.gematik.rbellogger.data.core.RbelFacet;
import de.gematik.rbellogger.util.RbelSocketAddress;
import de.gematik.test.tiger.mockserver.model.BinaryMessage;
import de.gematik.test.tiger.proxy.AbstractTigerProxy;
import de.gematik.test.tiger.proxy.TigerProxy;
import de.gematik.test.tiger.proxy.exceptions.TigerProxyRoutingException;
import de.gematik.test.tiger.proxy.exceptions.TigerRoutingErrorFacet;
import de.gematik.test.tiger.proxy.handler.MultipleBinaryConnectionParser;
import java.net.SocketAddress;
import java.time.ZoneId;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryExchangeHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BinaryExchangeHandler.class);
    private final TigerProxy tigerProxy;
    private final MultipleBinaryConnectionParser connectionParser;

    public BinaryExchangeHandler(TigerProxy tigerProxy) {
        this.tigerProxy = tigerProxy;
        this.connectionParser = new MultipleBinaryConnectionParser((AbstractTigerProxy)tigerProxy, this);
    }

    public void onProxy(BinaryMessage binaryMessage, SocketAddress serverAddress, SocketAddress clientAddress, RbelMessageKind messageKind) {
        this.connectionParser.addToBuffer(RbelSocketAddress.create((SocketAddress)clientAddress), RbelSocketAddress.create((SocketAddress)serverAddress), binaryMessage.getBytes(), binaryMessage.getTimestamp().atZone(ZoneId.systemDefault()), messageKind);
    }

    public void propagateExceptionMessageSafe(Throwable exception, RbelSocketAddress senderAddress, RbelSocketAddress receiverAddress) {
        try {
            log.warn("Exception during Direct-Proxy handling:", exception);
            this.tigerProxy.propagateException(exception);
            TigerProxyRoutingException routingException = new TigerProxyRoutingException("Exception during handling of HTTP request: " + exception.getMessage(), senderAddress, receiverAddress, exception);
            log.info(routingException.getMessage(), (Throwable)routingException);
            RbelElement message = new RbelElement(new byte[0], null);
            message.addFacet((RbelFacet)new TigerRoutingErrorFacet(routingException));
            this.tigerProxy.getRbelLogger().getRbelConverter().parseMessage(message, new RbelMessageMetadata().withSender(senderAddress).withReceiver(receiverAddress).withTransmissionTime(routingException.getTimestamp()));
        }
        catch (Exception handlingException) {
            log.warn("While propagating an exception another error occured (ignoring):", (Throwable)handlingException);
        }
    }

    public void waitForAllParsingTasksToBeFinished() {
        this.connectionParser.waitForAllParsingTasksToBeFinished();
    }

    @Generated
    public TigerProxy getTigerProxy() {
        return this.tigerProxy;
    }

    @Generated
    public MultipleBinaryConnectionParser getConnectionParser() {
        return this.connectionParser;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BinaryExchangeHandler)) {
            return false;
        }
        BinaryExchangeHandler other = (BinaryExchangeHandler)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        TigerProxy this$tigerProxy = this.getTigerProxy();
        TigerProxy other$tigerProxy = other.getTigerProxy();
        if (this$tigerProxy == null ? other$tigerProxy != null : !this$tigerProxy.equals(other$tigerProxy)) {
            return false;
        }
        MultipleBinaryConnectionParser this$connectionParser = this.getConnectionParser();
        MultipleBinaryConnectionParser other$connectionParser = other.getConnectionParser();
        return !(this$connectionParser == null ? other$connectionParser != null : !this$connectionParser.equals(other$connectionParser));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BinaryExchangeHandler;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TigerProxy $tigerProxy = this.getTigerProxy();
        result = result * 59 + ($tigerProxy == null ? 43 : $tigerProxy.hashCode());
        MultipleBinaryConnectionParser $connectionParser = this.getConnectionParser();
        result = result * 59 + ($connectionParser == null ? 43 : $connectionParser.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BinaryExchangeHandler(tigerProxy=" + String.valueOf(this.getTigerProxy()) + ", connectionParser=" + String.valueOf(this.getConnectionParser()) + ")";
    }
}

