/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.handler;

import de.gematik.rbellogger.RbelConversionPhase;
import de.gematik.rbellogger.RbelConverter;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.facets.uri.RbelUriFacet;
import de.gematik.rbellogger.facets.uri.RbelUriParameterFacet;
import de.gematik.rbellogger.util.GlobalServerMap;
import de.gematik.rbellogger.util.RbelSocketAddress;
import de.gematik.test.tiger.common.jexl.TigerJexlExecutor;
import de.gematik.test.tiger.mockserver.mock.action.ExpectationCallback;
import de.gematik.test.tiger.mockserver.model.Action;
import de.gematik.test.tiger.mockserver.model.CloseChannel;
import de.gematik.test.tiger.mockserver.model.Header;
import de.gematik.test.tiger.mockserver.model.HttpOverrideForwardedRequest;
import de.gematik.test.tiger.mockserver.model.HttpRequest;
import de.gematik.test.tiger.mockserver.model.HttpResponse;
import de.gematik.test.tiger.mockserver.model.Parameters;
import de.gematik.test.tiger.mockserver.model.SocketAddress;
import de.gematik.test.tiger.proxy.TigerProxy;
import de.gematik.test.tiger.proxy.data.TigerProxyRoute;
import de.gematik.test.tiger.proxy.exceptions.TigerProxyModificationException;
import de.gematik.test.tiger.proxy.exceptions.TigerProxyParsingException;
import de.gematik.test.tiger.proxy.exceptions.TigerProxyRoutingException;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class AbstractTigerRouteCallback
implements ExpectationCallback {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractTigerRouteCallback.class);
    public static final String LOCATION_HEADER_KEY = "Location";
    private final TigerProxy tigerProxy;
    private final TigerProxyRoute tigerRoute;
    private AtomicReference<String> previousMessageUuid = new AtomicReference<Object>(null);

    protected AbstractTigerRouteCallback(TigerProxy tigerProxy, TigerProxyRoute tigerRoute) {
        this.tigerProxy = tigerProxy;
        this.tigerRoute = tigerRoute;
        tigerProxy.addRemovedMessageUuidsHandler(arg_0 -> this.handleRemoveUuids(arg_0));
        RbelConverter converter = tigerProxy.getRbelLogger().getRbelConverter();
        converter.addClearHistoryCallback(() -> this.handleClearHistory());
        converter.addMessageRemovedFromHistoryCallback(arg_0 -> this.handleRemoveElementFromHistory(arg_0));
    }

    private void handleClearHistory() {
        this.previousMessageUuid.set(null);
    }

    private void handleRemoveElementFromHistory(RbelElement rbelElement) {
        this.handleRemoveUuids(List.of(rbelElement.getUuid()));
    }

    private void handleRemoveUuids(List<String> uuids) {
        String previous = (String)this.previousMessageUuid.get();
        if (previous != null && uuids.contains(previous)) {
            this.previousMessageUuid.compareAndExchange(previous, null);
        }
    }

    public void applyModifications(HttpRequest request) {
        if (!this.tigerProxy.getModifications().isEmpty()) {
            this.parseMessageAndApplyModifications(request);
        }
    }

    public void parseMessageAndApplyModifications(HttpRequest request) {
        RbelElement requestElement = this.tigerProxy.getRbelLogger().getRbelConverter().convertElement(this.tigerProxy.getMockServerToRbelConverter().requestToRbelMessage(request));
        RbelElement modifiedRequest = this.tigerProxy.getRbelLogger().getRbelModifier().applyModifications(requestElement);
        if (modifiedRequest == requestElement) {
            return;
        }
        request.withBody(this.extractSafe(modifiedRequest, "$.body").getRawContent());
        for (RbelElement modifiedHeader : modifiedRequest.findRbelPathMembers("$.header.*")) {
            request = request.replaceHeader(Header.header((String)((String)modifiedHeader.getKey().orElseThrow()), (String[])new String[]{modifiedHeader.getRawStringContent()}));
        }
        RbelUriFacet uriFacet = (RbelUriFacet)this.extractSafe(modifiedRequest, "$.path").getFacetOrFail(RbelUriFacet.class);
        request.setPath(uriFacet.getBasicPathString());
        this.clearExistingQueryParameters(request);
        this.addAllQueryParametersFromRbelMessage(request, uriFacet);
        request.setMethod(this.extractSafe(modifiedRequest, "$.method").getRawStringContent());
    }

    private RbelElement extractSafe(RbelElement targetElement, String rbelPath) {
        return (RbelElement)targetElement.findElement(rbelPath).orElseThrow(() -> new TigerProxyModificationException("Unexpected structure: Could not find '" + rbelPath + "'!"));
    }

    private void addAllQueryParametersFromRbelMessage(HttpRequest request, RbelUriFacet uriFacet) {
        for (RbelElement queryElement : uriFacet.getQueryParameters()) {
            RbelUriParameterFacet parameterFacet = (RbelUriParameterFacet)queryElement.getFacetOrFail(RbelUriParameterFacet.class);
            request.withQueryStringParameter(parameterFacet.getKeyAsString(), new String[]{parameterFacet.getValue().getRawStringContent()});
        }
    }

    private void clearExistingQueryParameters(HttpRequest request) {
        Parameters queryStringParameters = request.getQueryStringParameters();
        if (queryStringParameters == null) {
            return;
        }
        queryStringParameters.getEntries().forEach(parameter -> queryStringParameters.remove(parameter.getName()));
    }

    public void applyModifications(HttpRequest request, HttpResponse response) {
        if (!this.tigerProxy.getModifications().isEmpty()) {
            this.parseMessageAndApplyModifications(request, response);
        }
    }

    public void parseMessageAndApplyModifications(HttpRequest request, HttpResponse response) {
        RbelElement responseElement = this.tigerProxy.getRbelLogger().getRbelConverter().convertElement(this.tigerProxy.getMockServerToRbelConverter().responseToRbelMessage(response, request));
        RbelElement modifiedResponse = this.tigerProxy.getRbelLogger().getRbelModifier().applyModifications(responseElement);
        if (modifiedResponse != responseElement) {
            this.modifyOriginalResponse(response, modifiedResponse);
        }
    }

    private void modifyOriginalResponse(HttpResponse response, RbelElement modifiedResponse) {
        response.withBody(this.extractSafe(modifiedResponse, "$.body").getRawContent());
        response.getHeaderMultimap().clear();
        for (RbelElement modifiedHeader : modifiedResponse.findRbelPathMembers("$.header.*")) {
            response = response.withHeader(Header.header((String)((String)modifiedHeader.getKey().orElseThrow()), (String[])new String[]{modifiedHeader.getRawStringContent()}));
        }
        response.withStatusCode(Integer.valueOf(Integer.parseInt(this.extractSafe(modifiedResponse, "$.responseCode").getRawStringContent())));
        String reasonPhrase = this.extractSafe(modifiedResponse, "$.reasonPhrase").getRawStringContent();
        if (!StringUtils.isEmpty((CharSequence)reasonPhrase)) {
            response.withReasonPhrase(reasonPhrase);
        } else {
            response.withReasonPhrase(" ");
        }
    }

    public final HttpRequest handle(HttpRequest req) {
        try {
            this.doIncomingRequestLogging(req);
            HttpRequest modifiedRequest = this.handleRequest(req);
            if (this.shouldLogTraffic()) {
                this.parseMessage(req);
            }
            return modifiedRequest;
        }
        catch (RuntimeException e) {
            log.warn("Uncaught exception during handling of request", (Throwable)e);
            this.propagateExceptionMessageSafe((Exception)e);
            throw e;
        }
    }

    public void propagateExceptionMessageSafe(Exception exception) {
        try {
            this.tigerProxy.propagateException((Throwable)exception);
        }
        catch (Exception handlingException) {
            log.warn("While propagating an exception another error occurred (ignoring):", (Throwable)handlingException);
        }
    }

    protected abstract HttpRequest handleRequest(HttpRequest var1);

    public final HttpResponse handle(HttpRequest req, HttpResponse resp, HttpRequest originalRequest) {
        try {
            this.doOutgoingResponseLogging(resp, originalRequest);
            return this.handleResponse(req, resp, originalRequest);
        }
        catch (RuntimeException e) {
            log.warn("Uncaught exception during handling of response", (Throwable)e);
            this.propagateExceptionMessageSafe((Exception)e);
            throw e;
        }
    }

    private HttpResponse handleResponse(HttpRequest req, HttpResponse resp, HttpRequest originalRequest) {
        this.rewriteLocationHeaderIfApplicable(resp);
        this.applyModifications(originalRequest, resp);
        if (this.shouldLogTraffic()) {
            this.parseMessages(req, resp);
        }
        return resp.withBody(resp.getBody());
    }

    private void rewriteLocationHeaderIfApplicable(HttpResponse resp) {
        if (this.tigerProxy.getTigerProxyConfiguration().isRewriteLocationHeader() && resp.getStatusCode() / 100 == 3 && !resp.getHeader("Location").isEmpty()) {
            List locations = resp.getHeader("Location");
            resp.removeHeader("Location");
            locations.stream().map(arg_0 -> this.rewriteConcreteLocation(arg_0)).map(l -> new Header("Location", new String[]{l})).forEach(arg_0 -> ((HttpResponse)resp).withHeader(arg_0));
            log.info("Rewriting from {} to {}", (Object)locations, (Object)resp.getHeader("Location"));
        }
    }

    protected String rewriteConcreteLocation(String originalLocation) {
        return originalLocation;
    }

    public void parseMessage(HttpRequest mockServerRequest) {
        CompletableFuture messageParsingCompleteFuture = this.executeHttpRequestParsing(mockServerRequest);
        this.waitForMessageToBeParsedIfConfigured(messageParsingCompleteFuture);
    }

    private void parseMessages(HttpRequest req, HttpResponse resp) {
        CompletableFuture messageParsingCompleteFuture = this.executeHttpTrafficPairParsing(req, resp);
        this.waitForMessageToBeParsedIfConfigured(messageParsingCompleteFuture);
    }

    private void waitForMessageToBeParsedIfConfigured(CompletableFuture messageParsingCompleteFuture) {
        block5: {
            if (!this.tigerProxy.getTigerProxyConfiguration().isParsingShouldBlockCommunication()) break block5;
            try {
                messageParsingCompleteFuture.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new TigerProxyParsingException("Interruption while parsing traffic", (Exception)e);
            }
            catch (ExecutionException e) {
                throw new TigerProxyParsingException("Error while parsing traffic", (Exception)e);
            }
        }
    }

    public CompletableFuture<RbelElement> executeHttpRequestParsing(HttpRequest request) {
        if (this.isHealthEndpointRequest(request)) {
            return CompletableFuture.completedFuture(null);
        }
        this.addServerNameForSender(request);
        return this.getTigerProxy().getMockServerToRbelConverter().convertRequest(request, this.extractProtocolAndHostForRequest(request), Optional.of(ZonedDateTime.now()), this.previousMessageUuid).exceptionally(e -> {
            log.error("Error while parsing request", e);
            return null;
        });
    }

    private CompletableFuture<RbelElement> executeHttpTrafficPairParsing(HttpRequest request, HttpResponse response) {
        if (this.isHealthEndpointRequest(request)) {
            return CompletableFuture.completedFuture(null);
        }
        this.addServerNameForSender(request);
        return this.getTigerProxy().getMockServerToRbelConverter().convertResponse(request, response, this.extractProtocolAndHostForRequest(request), request.getSenderAddress(), Optional.of(ZonedDateTime.now()), this.previousMessageUuid).exceptionally(e -> {
            log.error("Error while parsing response", e);
            this.getTigerProxy().propagateException(e);
            return null;
        });
    }

    private boolean isHealthEndpointRequest(HttpRequest request) {
        return request.getQueryStringParameters() != null && request.getQueryStringParameters().containsEntry("healthEndPointUuid", this.getTigerProxy().getHealthEndpointRequestUuid().toString());
    }

    boolean shouldLogTraffic() {
        return !this.getTigerRoute().isDisableRbelLogging();
    }

    protected abstract String extractProtocolAndHostForRequest(HttpRequest var1);

    HttpRequest cloneRequest(HttpRequest req) {
        HttpOverrideForwardedRequest clonedRequest = HttpOverrideForwardedRequest.forwardOverriddenRequest((HttpRequest)req);
        if (req.getBody() != null) {
            return clonedRequest.getRequestOverride().withBody(req.getBody());
        }
        return clonedRequest.getRequestOverride();
    }

    public void doOutgoingResponseLogging(HttpResponse resp, HttpRequest req) {
        if (log.isInfoEnabled() && this.tigerProxy.getTigerProxyConfiguration().isActivateTrafficLogging() && !this.isHealthEndpointRequest(req)) {
            log.info("Returning HTTP " + resp.getStatusCode() + " Response-Length: " + AbstractTigerRouteCallback.getMessageSize((byte[])resp.getBody()));
        }
    }

    private static String getMessageSize(byte[] body) {
        return FileUtils.byteCountToDisplaySize((long)body.length);
    }

    public void doIncomingRequestLogging(HttpRequest req) {
        if (log.isInfoEnabled() && this.tigerProxy.getTigerProxyConfiguration().isActivateTrafficLogging() && !this.isHealthEndpointRequest(req)) {
            log.info("Received " + req.printLogLineDescription() + " => " + this.printTrafficTarget(req));
        }
    }

    protected abstract String printTrafficTarget(HttpRequest var1);

    public boolean matches(HttpRequest request) {
        if (this.tigerRoute == null || this.tigerRoute.getCriterions() == null || this.tigerRoute.getCriterions().isEmpty()) {
            return true;
        }
        RbelElement convertedRequest = this.getConvertedRequest(request);
        return this.tigerRoute.getCriterions().stream().allMatch(criterion -> {
            boolean matches = TigerJexlExecutor.matchesAsJexlExpression((Object)convertedRequest, (String)criterion);
            log.atTrace().addArgument(criterion).addArgument(() -> ((RbelElement)convertedRequest).printHttpDescription()).addArgument(() -> matches).log("Matching {} for {}: {}");
            return matches;
        });
    }

    private RbelElement getConvertedRequest(HttpRequest request) {
        RbelElement convertedRequest = request.getCorrespondingRbelMessage();
        if (convertedRequest == null) {
            RbelElement rbelMessage = this.getTigerProxy().getMockServerToRbelConverter().requestToRbelMessage(request);
            convertedRequest = this.getTigerProxy().getRbelLogger().getRbelConverter().convertElement(rbelMessage, List.of(RbelConversionPhase.PREPARATION, RbelConversionPhase.PROTOCOL_PARSING, RbelConversionPhase.CONTENT_PARSING));
            request.setCorrespondingRbelMessage(convertedRequest);
        }
        return convertedRequest;
    }

    public Action handleException(Throwable exception, HttpRequest request) {
        TigerProxyRoutingException routingException = new TigerProxyRoutingException("Exception during handling of HTTP request: " + exception.getMessage(), (RbelSocketAddress)Optional.ofNullable(request.getReceiverAddress()).map(SocketAddress::toRbelHostname).orElse(null), (RbelSocketAddress)RbelSocketAddress.fromString((String)request.getSenderAddress()).orElse(null), exception);
        routingException.setRoutedMessage(request.getParsedMessageFuture());
        log.info(routingException.getMessage(), (Throwable)routingException);
        this.addServerNameForSender(request);
        this.tigerProxy.getMockServerToRbelConverter().convertErrorResponse(request, this.extractProtocolAndHostForRequest(request), routingException, this.previousMessageUuid);
        return new CloseChannel();
    }

    private void addServerNameForSender(HttpRequest request) {
        this.tigerProxy.getName().filter(name -> !name.equals("local_tiger_proxy")).ifPresent(serverName -> RbelSocketAddress.fromString((String)request.getSenderAddress()).ifPresent(sender -> GlobalServerMap.addServerNameForPort((int)sender.getPort(), (String)serverName)));
    }

    @Generated
    public TigerProxy getTigerProxy() {
        return this.tigerProxy;
    }

    @Generated
    public TigerProxyRoute getTigerRoute() {
        return this.tigerRoute;
    }

    @Generated
    public AtomicReference<String> getPreviousMessageUuid() {
        return this.previousMessageUuid;
    }

    @Generated
    public void setPreviousMessageUuid(AtomicReference<String> previousMessageUuid) {
        this.previousMessageUuid = previousMessageUuid;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractTigerRouteCallback)) {
            return false;
        }
        AbstractTigerRouteCallback other = (AbstractTigerRouteCallback)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        TigerProxy this$tigerProxy = this.getTigerProxy();
        TigerProxy other$tigerProxy = other.getTigerProxy();
        if (this$tigerProxy == null ? other$tigerProxy != null : !this$tigerProxy.equals(other$tigerProxy)) {
            return false;
        }
        TigerProxyRoute this$tigerRoute = this.getTigerRoute();
        TigerProxyRoute other$tigerRoute = other.getTigerRoute();
        if (this$tigerRoute == null ? other$tigerRoute != null : !this$tigerRoute.equals(other$tigerRoute)) {
            return false;
        }
        AtomicReference this$previousMessageUuid = this.getPreviousMessageUuid();
        AtomicReference other$previousMessageUuid = other.getPreviousMessageUuid();
        return !(this$previousMessageUuid == null ? other$previousMessageUuid != null : !this$previousMessageUuid.equals(other$previousMessageUuid));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractTigerRouteCallback;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TigerProxy $tigerProxy = this.getTigerProxy();
        result = result * 59 + ($tigerProxy == null ? 43 : $tigerProxy.hashCode());
        TigerProxyRoute $tigerRoute = this.getTigerRoute();
        result = result * 59 + ($tigerRoute == null ? 43 : $tigerRoute.hashCode());
        AtomicReference $previousMessageUuid = this.getPreviousMessageUuid();
        result = result * 59 + ($previousMessageUuid == null ? 43 : $previousMessageUuid.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AbstractTigerRouteCallback(tigerProxy=" + String.valueOf(this.getTigerProxy()) + ", tigerRoute=" + String.valueOf(this.getTigerRoute()) + ", previousMessageUuid=" + String.valueOf(this.getPreviousMessageUuid()) + ")";
    }
}

