/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.data;

import com.fasterxml.jackson.annotation.JsonInclude;
import de.gematik.test.tiger.common.data.config.tigerproxy.ForwardProxyInfo;
import de.gematik.test.tiger.common.data.config.tigerproxy.TigerConfigurationRoute;
import de.gematik.test.tiger.common.data.config.tigerproxy.TigerRouteAuthenticationConfiguration;
import de.gematik.test.tiger.proxy.TigerRouteSelector;
import de.gematik.test.tiger.proxy.data.TigerProxyRoute;
import de.gematik.test.tiger.proxy.exceptions.TigerProxyStartupException;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

/*
 * Exception performing whole class analysis ignored.
 */
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class TigerProxyRoute
implements Serializable {
    private String id;
    private String from;
    private String to;
    private boolean internalRoute;
    private boolean disableRbelLogging;
    private TigerRouteAuthenticationConfiguration authentication;
    private List<String> criterions;
    private List<String> hosts;
    private boolean matchForProxyType;

    public static TigerProxyRoute convertFromTigerConfigurationRoute(TigerConfigurationRoute tigerRoute, ForwardProxyInfo forwardProxyInfo) {
        return TigerProxyRoute.builder().from(tigerRoute.getFrom()).to(new TigerRouteSelector(tigerRoute.getTo(), forwardProxyInfo).selectFirstReachableDestination()).authentication(tigerRoute.getAuthentication()).hosts(tigerRoute.getHosts()).criterions(tigerRoute.getCriterions()).disableRbelLogging(tigerRoute.isDisableRbelLogging()).matchForProxyType(tigerRoute.isMatchForProxyType()).build();
    }

    public String createShortDescription() {
        StringBuilder resultBuilder = new StringBuilder();
        resultBuilder.append("{from='");
        resultBuilder.append(this.from);
        resultBuilder.append('\'');
        resultBuilder.append(", to='");
        resultBuilder.append(this.to);
        resultBuilder.append('\'');
        if (this.criterions != null && !this.criterions.isEmpty()) {
            resultBuilder.append(", criterions=");
            resultBuilder.append(this.criterions);
        }
        if (this.hosts != null && !this.hosts.isEmpty()) {
            resultBuilder.append(", hosts=");
            resultBuilder.append(this.hosts);
        }
        resultBuilder.append('}');
        return resultBuilder.toString();
    }

    public URL retrieveFromUrl() {
        try {
            return new URL(this.getFrom());
        }
        catch (MalformedURLException e) {
            throw new TigerProxyStartupException("Error while building route", (Throwable)e);
        }
    }

    @Generated
    private static boolean $default$internalRoute() {
        return false;
    }

    @Generated
    private static List<String> $default$hosts() {
        return new ArrayList<String>();
    }

    @Generated
    private static boolean $default$matchForProxyType() {
        return true;
    }

    @Generated
    public static TigerProxyRouteBuilder builder() {
        return new TigerProxyRouteBuilder();
    }

    @Generated
    public TigerProxyRouteBuilder toBuilder() {
        return new TigerProxyRouteBuilder().id(this.id).from(this.from).to(this.to).internalRoute(this.internalRoute).disableRbelLogging(this.disableRbelLogging).authentication(this.authentication).criterions(this.criterions).hosts(this.hosts).matchForProxyType(this.matchForProxyType);
    }

    @Generated
    public TigerProxyRoute() {
        this.internalRoute = TigerProxyRoute.$default$internalRoute();
        this.hosts = TigerProxyRoute.$default$hosts();
        this.matchForProxyType = TigerProxyRoute.$default$matchForProxyType();
    }

    @ConstructorProperties(value={"id", "from", "to", "internalRoute", "disableRbelLogging", "authentication", "criterions", "hosts", "matchForProxyType"})
    @Generated
    public TigerProxyRoute(String id, String from, String to, boolean internalRoute, boolean disableRbelLogging, TigerRouteAuthenticationConfiguration authentication, List<String> criterions, List<String> hosts, boolean matchForProxyType) {
        this.id = id;
        this.from = from;
        this.to = to;
        this.internalRoute = internalRoute;
        this.disableRbelLogging = disableRbelLogging;
        this.authentication = authentication;
        this.criterions = criterions;
        this.hosts = hosts;
        this.matchForProxyType = matchForProxyType;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getFrom() {
        return this.from;
    }

    @Generated
    public String getTo() {
        return this.to;
    }

    @Generated
    public boolean isInternalRoute() {
        return this.internalRoute;
    }

    @Generated
    public boolean isDisableRbelLogging() {
        return this.disableRbelLogging;
    }

    @Generated
    public TigerRouteAuthenticationConfiguration getAuthentication() {
        return this.authentication;
    }

    @Generated
    public List<String> getCriterions() {
        return this.criterions;
    }

    @Generated
    public List<String> getHosts() {
        return this.hosts;
    }

    @Generated
    public boolean isMatchForProxyType() {
        return this.matchForProxyType;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setFrom(String from) {
        this.from = from;
    }

    @Generated
    public void setTo(String to) {
        this.to = to;
    }

    @Generated
    public void setInternalRoute(boolean internalRoute) {
        this.internalRoute = internalRoute;
    }

    @Generated
    public void setDisableRbelLogging(boolean disableRbelLogging) {
        this.disableRbelLogging = disableRbelLogging;
    }

    @Generated
    public void setAuthentication(TigerRouteAuthenticationConfiguration authentication) {
        this.authentication = authentication;
    }

    @Generated
    public void setCriterions(List<String> criterions) {
        this.criterions = criterions;
    }

    @Generated
    public void setHosts(List<String> hosts) {
        this.hosts = hosts;
    }

    @Generated
    public void setMatchForProxyType(boolean matchForProxyType) {
        this.matchForProxyType = matchForProxyType;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TigerProxyRoute)) {
            return false;
        }
        TigerProxyRoute other = (TigerProxyRoute)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isInternalRoute() != other.isInternalRoute()) {
            return false;
        }
        if (this.isDisableRbelLogging() != other.isDisableRbelLogging()) {
            return false;
        }
        if (this.isMatchForProxyType() != other.isMatchForProxyType()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$from = this.getFrom();
        String other$from = other.getFrom();
        if (this$from == null ? other$from != null : !this$from.equals(other$from)) {
            return false;
        }
        String this$to = this.getTo();
        String other$to = other.getTo();
        if (this$to == null ? other$to != null : !this$to.equals(other$to)) {
            return false;
        }
        TigerRouteAuthenticationConfiguration this$authentication = this.getAuthentication();
        TigerRouteAuthenticationConfiguration other$authentication = other.getAuthentication();
        if (this$authentication == null ? other$authentication != null : !this$authentication.equals(other$authentication)) {
            return false;
        }
        List this$criterions = this.getCriterions();
        List other$criterions = other.getCriterions();
        if (this$criterions == null ? other$criterions != null : !((Object)this$criterions).equals(other$criterions)) {
            return false;
        }
        List this$hosts = this.getHosts();
        List other$hosts = other.getHosts();
        return !(this$hosts == null ? other$hosts != null : !((Object)this$hosts).equals(other$hosts));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TigerProxyRoute;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isInternalRoute() ? 79 : 97);
        result = result * 59 + (this.isDisableRbelLogging() ? 79 : 97);
        result = result * 59 + (this.isMatchForProxyType() ? 79 : 97);
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : $from.hashCode());
        String $to = this.getTo();
        result = result * 59 + ($to == null ? 43 : $to.hashCode());
        TigerRouteAuthenticationConfiguration $authentication = this.getAuthentication();
        result = result * 59 + ($authentication == null ? 43 : $authentication.hashCode());
        List $criterions = this.getCriterions();
        result = result * 59 + ($criterions == null ? 43 : ((Object)$criterions).hashCode());
        List $hosts = this.getHosts();
        result = result * 59 + ($hosts == null ? 43 : ((Object)$hosts).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TigerProxyRoute(id=" + this.getId() + ", from=" + this.getFrom() + ", to=" + this.getTo() + ", internalRoute=" + this.isInternalRoute() + ", disableRbelLogging=" + this.isDisableRbelLogging() + ", authentication=" + String.valueOf(this.getAuthentication()) + ", criterions=" + String.valueOf(this.getCriterions()) + ", hosts=" + String.valueOf(this.getHosts()) + ", matchForProxyType=" + this.isMatchForProxyType() + ")";
    }

    @Generated
    public TigerProxyRoute withId(String id) {
        return this.id == id ? this : new TigerProxyRoute(id, this.from, this.to, this.internalRoute, this.disableRbelLogging, this.authentication, this.criterions, this.hosts, this.matchForProxyType);
    }
}

