/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.controller;

import de.gematik.rbellogger.data.RbelMessageMetadata;
import de.gematik.rbellogger.util.RbelSocketAddress;
import de.gematik.test.tiger.proxy.TigerProxy;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class TrafficPushController {
    public static final String SENDER_REQUEST_HEADER = "tgr-sender";
    public static final String RECEIVER_REQUEST_HEADER = "tgr-receiver";
    public static final String TIMESTAMP_REQUEST_HEADER = "tgr-timestamp";
    private final TigerProxy tigerProxy;

    @PostMapping(value={"/traffic"})
    public void postNewMessage(InputStream dataStream, @RequestHeader(value="tgr-sender") Optional<String> sender, @RequestHeader(value="tgr-receiver") Optional<String> receiver, @RequestHeader(value="tgr-timestamp") Optional<String> timestamp) throws IOException {
        this.tigerProxy.getRbelLogger().getRbelConverter().parseMessage(IOUtils.toByteArray((InputStream)dataStream), new RbelMessageMetadata().withSender((RbelSocketAddress)sender.flatMap(RbelSocketAddress::fromString).orElse(null)).withReceiver((RbelSocketAddress)receiver.flatMap(RbelSocketAddress::fromString).orElse(null)).withTransmissionTime((ZonedDateTime)timestamp.map(ZonedDateTime::parse).orElse(null)));
    }

    @ConstructorProperties(value={"tigerProxy"})
    @Generated
    public TrafficPushController(TigerProxy tigerProxy) {
        this.tigerProxy = tigerProxy;
    }
}

