/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.controller;

import de.gematik.test.tiger.proxy.TigerProxy;
import de.gematik.test.tiger.proxy.data.TigerProxyRoute;
import de.gematik.test.tiger.proxy.data.TigerRouteDto;
import java.beans.ConstructorProperties;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
public class TigerConfigurationController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerConfigurationController.class);
    private final TigerProxy tigerProxy;

    @PutMapping(value={"/route"}, consumes={"application/json"})
    public TigerRouteDto addRoute(@RequestBody TigerRouteDto addRouteDto) {
        log.info("Adding route from '{}' to '{}'", (Object)addRouteDto.getFrom(), (Object)addRouteDto.getTo());
        TigerProxyRoute tigerRoute = this.tigerProxy.addRoute(TigerProxyRoute.builder().from(addRouteDto.getFrom()).to(addRouteDto.getTo()).build());
        return TigerRouteDto.create((TigerProxyRoute)tigerRoute);
    }

    @GetMapping(value={"/route"}, produces={"application/json"})
    public List<TigerRouteDto> getRoutes() {
        return this.tigerProxy.getRoutes().stream().map(TigerRouteDto::create).toList();
    }

    @DeleteMapping(value={"/route/{id}"})
    public void deleteRoute(@PathVariable(value="id") String id) {
        this.tigerProxy.removeRoute(id);
    }

    @Generated
    public TigerProxy getTigerProxy() {
        return this.tigerProxy;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TigerConfigurationController)) {
            return false;
        }
        TigerConfigurationController other = (TigerConfigurationController)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        TigerProxy this$tigerProxy = this.getTigerProxy();
        TigerProxy other$tigerProxy = other.getTigerProxy();
        return !(this$tigerProxy == null ? other$tigerProxy != null : !this$tigerProxy.equals(other$tigerProxy));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TigerConfigurationController;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TigerProxy $tigerProxy = this.getTigerProxy();
        result = result * 59 + ($tigerProxy == null ? 43 : $tigerProxy.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TigerConfigurationController(tigerProxy=" + String.valueOf(this.getTigerProxy()) + ")";
    }

    @ConstructorProperties(value={"tigerProxy"})
    @Generated
    public TigerConfigurationController(TigerProxy tigerProxy) {
        this.tigerProxy = tigerProxy;
    }
}

