/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import de.gematik.test.tiger.proxy.client.PartialTracingMessage;
import de.gematik.test.tiger.proxy.client.TigerRemoteProxyClient;
import de.gematik.test.tiger.proxy.client.TigerTracingDto;
import de.gematik.test.tiger.proxy.client.TracingMessageFrame;
import de.gematik.test.tiger.proxy.exceptions.TigerProxyRoutingException;
import java.beans.ConstructorProperties;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.simp.stomp.StompFrameHandler;
import org.springframework.messaging.simp.stomp.StompHeaders;

class TracingStompHandler
implements StompFrameHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TracingStompHandler.class);
    private final TigerRemoteProxyClient remoteProxyClient;

    public Type getPayloadType(@Nullable StompHeaders stompHeaders) {
        return TigerTracingDto.class;
    }

    public void handleFrame(@Nullable StompHeaders stompHeaders, Object frameContent) {
        log.atTrace().addArgument(() -> Optional.ofNullable(frameContent).map(Object::getClass).map(Class::getSimpleName).orElse("<>")).addArgument((Object)this.remoteProxyClient.getName().orElse("<>")).addArgument(() -> {
            try {
                return new ObjectMapper().registerModule((Module)new JavaTimeModule()).writerWithDefaultPrettyPrinter().writeValueAsString(frameContent);
            }
            catch (JsonProcessingException e) {
                return "<>";
            }
        }).log("Received new frame of type {} in proxy {} with content: {}");
        if (frameContent instanceof TigerTracingDto) {
            TigerTracingDto tigerTracingDto = (TigerTracingDto)frameContent;
            CompletableFuture.runAsync(() -> this.registerNewMessage(tigerTracingDto), this.remoteProxyClient.getMeshHandlerPool()).exceptionally(e -> {
                this.remoteProxyClient.propagateException((RuntimeException)new TigerProxyRoutingException("Error while handling message: " + e.getMessage(), tigerTracingDto.getSender(), tigerTracingDto.getReceiver(), e));
                return null;
            });
        }
    }

    private void registerNewMessage(TigerTracingDto tigerTracingDto) {
        TracingMessageFrame messageFrame = new TracingMessageFrame(this.remoteProxyClient);
        messageFrame.setMessage(PartialTracingMessage.builder().tracingDto(tigerTracingDto).receiver(tigerTracingDto.getReceiver()).sender(tigerTracingDto.getSender()).messageFrame(messageFrame).additionalInformation(tigerTracingDto.getAdditionalInformation()).build());
        this.remoteProxyClient.initOrUpdateMessagePart(tigerTracingDto.getMessageUuid(), messageFrame.getMessage());
        this.remoteProxyClient.triggerPartialMessageCleanup();
    }

    @ConstructorProperties(value={"remoteProxyClient"})
    @Generated
    public TracingStompHandler(TigerRemoteProxyClient remoteProxyClient) {
        this.remoteProxyClient = remoteProxyClient;
    }
}

