/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.client;

import de.gematik.rbellogger.data.RbelMessageMetadata;
import de.gematik.rbellogger.data.core.RbelFacet;
import de.gematik.test.tiger.proxy.client.PartialTracingMessage;
import de.gematik.test.tiger.proxy.client.TigerRemoteProxyClient;
import de.gematik.test.tiger.proxy.client.TigerTracingDto;
import de.gematik.test.tiger.proxy.client.TracingMessageFrame;
import java.beans.ConstructorProperties;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TracingMessageFrame {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TracingMessageFrame.class);
    private PartialTracingMessage message;
    private AtomicBoolean addedToBuffer = new AtomicBoolean(false);
    private final TigerRemoteProxyClient remoteProxyClient;

    public void checkForCompletePairAndPropagateIfComplete() {
        if (this.message != null && this.message.isComplete()) {
            this.queueParsingTask();
        }
    }

    private void queueParsingTask() {
        String previousMessageUuid = (String)this.message.getAdditionalInformation().get(RbelMessageMetadata.PREVIOUS_MESSAGE_UUID.getKey());
        if (previousMessageUuid != null) {
            log.atTrace().addArgument(() -> ((TigerTracingDto)this.message.getTracingDto()).getMessageUuid()).addArgument(() -> previousMessageUuid).log("Queueing {} behind {}");
            this.remoteProxyClient.scheduleAfterMessage(previousMessageUuid, () -> this.parseThisMessage(), this.message.getTracingDto().getMessageUuid());
        } else {
            log.atTrace().addArgument(() -> ((TigerTracingDto)this.message.getTracingDto()).getMessageUuid()).log("No previous message UUID found, parsing message {} immediately");
            this.parseThisMessage();
        }
    }

    private synchronized void parseThisMessage() {
        if (this.addedToBuffer.get()) {
            log.info("NOTAUSGANG f\u00fcr {}", (Object)this.message.getTracingDto().getMessageUuid());
            return;
        }
        log.atTrace().addArgument(() -> this.message.getTracingDto().getMessageUuid()).log("Parsing tracing message {}");
        this.remoteProxyClient.tryParseMessages(this.message, el -> el.addFacet((RbelFacet)new MeshMessagePostProcessingFacet(this.message, this.remoteProxyClient)));
        this.addedToBuffer.set(true);
    }

    @ConstructorProperties(value={"remoteProxyClient"})
    @Generated
    public TracingMessageFrame(TigerRemoteProxyClient remoteProxyClient) {
        this.remoteProxyClient = remoteProxyClient;
    }

    @Generated
    public PartialTracingMessage getMessage() {
        return this.message;
    }

    @Generated
    public AtomicBoolean getAddedToBuffer() {
        return this.addedToBuffer;
    }

    @Generated
    public TigerRemoteProxyClient getRemoteProxyClient() {
        return this.remoteProxyClient;
    }

    @Generated
    public void setMessage(PartialTracingMessage message) {
        this.message = message;
    }

    @Generated
    public void setAddedToBuffer(AtomicBoolean addedToBuffer) {
        this.addedToBuffer = addedToBuffer;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TracingMessageFrame)) {
            return false;
        }
        TracingMessageFrame other = (TracingMessageFrame)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        PartialTracingMessage this$message = this.getMessage();
        PartialTracingMessage other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        AtomicBoolean this$addedToBuffer = this.getAddedToBuffer();
        AtomicBoolean other$addedToBuffer = other.getAddedToBuffer();
        if (this$addedToBuffer == null ? other$addedToBuffer != null : !this$addedToBuffer.equals(other$addedToBuffer)) {
            return false;
        }
        TigerRemoteProxyClient this$remoteProxyClient = this.getRemoteProxyClient();
        TigerRemoteProxyClient other$remoteProxyClient = other.getRemoteProxyClient();
        return !(this$remoteProxyClient == null ? other$remoteProxyClient != null : !this$remoteProxyClient.equals(other$remoteProxyClient));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TracingMessageFrame;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PartialTracingMessage $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        AtomicBoolean $addedToBuffer = this.getAddedToBuffer();
        result = result * 59 + ($addedToBuffer == null ? 43 : $addedToBuffer.hashCode());
        TigerRemoteProxyClient $remoteProxyClient = this.getRemoteProxyClient();
        result = result * 59 + ($remoteProxyClient == null ? 43 : $remoteProxyClient.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TracingMessageFrame(message=" + String.valueOf(this.getMessage()) + ", addedToBuffer=" + String.valueOf(this.getAddedToBuffer()) + ")";
    }
}

