/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.client;

import de.gematik.rbellogger.RbelLogger;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.core.RbelFacet;
import de.gematik.rbellogger.data.core.RbelTcpIpMessageFacet;
import de.gematik.rbellogger.util.RbelContent;
import de.gematik.test.tiger.proxy.client.TigerRemoteProxyClient;
import de.gematik.test.tiger.proxy.client.TigerRemoteProxyClientException;
import de.gematik.test.tiger.proxy.client.TigerRemoteTrafficDownloader;
import de.gematik.test.tiger.proxy.data.TigerDownloadedMessageFacet;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kong.unirest.core.GetRequest;
import kong.unirest.core.HttpResponse;
import kong.unirest.core.RawResponse;
import kong.unirest.core.Unirest;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class TigerRemoteTrafficDownloader {
    private final TigerRemoteProxyClient tigerRemoteProxyClient;
    private Logger log = LoggerFactory.getLogger(TigerRemoteTrafficDownloader.class);

    public void execute() {
        this.log = LoggerFactory.getLogger((String)(TigerRemoteTrafficDownloader.class.getName() + "(" + this.tigerRemoteProxyClient.proxyName() + ")"));
        this.downloadAllTrafficFromRemote();
        this.log.info("Successfully downloaded & parsed missed traffic from '{}'. Now {} message(s) in local history ({} actual messages)", new Object[]{this.getRemoteProxyUrl(), this.getRbelLogger().getMessageHistory().size(), this.getRbelLogger().getMessageList().size()});
    }

    private void parseTrafficChunk(String rawTraffic) {
        List convertedMessages = this.tigerRemoteProxyClient.getRbelFileWriter().convertRbelFileEntries(rawTraffic.lines(), Optional.empty(), arg_0 -> this.downloadMessageContent(arg_0));
        long expectedNumberOfMessages = rawTraffic.lines().count();
        this.doMessageBatchPostProcessing(convertedMessages, expectedNumberOfMessages);
    }

    private RbelContent downloadMessageContent(String uuid) {
        String downloadUrl = this.getRemoteProxyUrl() + "/webui/messageContent/" + uuid;
        this.log.trace("Downloading content of message from '{}' with uuid '{}'", (Object)downloadUrl, (Object)uuid);
        try {
            HttpResponse response = Unirest.get((String)downloadUrl).asObject(RawResponse::getContent);
            this.log.trace("Downloaded traffic from remote '{}', status: {}", (Object)downloadUrl, (Object)response.getStatus());
            if (response.getStatus() != 200) {
                throw new TigerRemoteProxyClientException("Error while downloading message from remote '" + downloadUrl);
            }
            return RbelContent.from((InputStream)((InputStream)response.getBody()));
        }
        catch (OutOfMemoryError error) {
            this.log.error("OutOfMemoryError while downloading traffic from remote '{}'. Please increase the heap size of the Tiger Proxy.", (Object)downloadUrl, (Object)error);
            throw error;
        }
        catch (IOException e) {
            this.log.error("IOException while downloading traffic from remote '{}'", (Object)this.getRemoteProxyUrl(), (Object)e);
            throw e;
        }
    }

    private void doMessageBatchPostProcessing(List<RbelElement> convertedMessages, long count) {
        convertedMessages.forEach(msg -> {
            msg.addFacet((RbelFacet)new TigerDownloadedMessageFacet());
            this.addRemoteUrlToTcpIpFacet(msg);
        });
        if (this.log.isTraceEnabled()) {
            this.log.trace("Just parsed another traffic batch of {} lines, got {} messages, expected {} (rest was filtered). Now standing at {} messages overall", new Object[]{count, convertedMessages.size(), (count + 2L) / 3L, this.getRbelLogger().getMessageHistory().size()});
        }
        if (!convertedMessages.isEmpty()) {
            this.tigerRemoteProxyClient.getLastMessageUuid().set(convertedMessages.get(convertedMessages.size() - 1).getUuid());
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Parsed traffic, ending with {}", (Object)convertedMessages.stream().map(RbelElement::getRawStringContent).flatMap(content -> Stream.of(content.split(" ")).skip(1L).limit(1L)).filter(httpHeaderString -> httpHeaderString.startsWith("/")).collect(Collectors.joining(", ")));
        }
    }

    private void addRemoteUrlToTcpIpFacet(RbelElement element) {
        element.getFacet(RbelTcpIpMessageFacet.class).map(f -> f.toBuilder().receivedFromRemoteWithUrl(this.getRemoteProxyUrl()).build()).ifPresent(arg_0 -> ((RbelElement)element).addOrReplaceFacet(arg_0));
    }

    private void downloadAllTrafficFromRemote() {
        PaginationInfo paginationInfo;
        int pageNumber = 0;
        Optional<String> currentLastUuid = Optional.ofNullable((String)this.tigerRemoteProxyClient.getLastMessageUuid().get());
        int pageSize = this.tigerRemoteProxyClient.getTigerProxyConfiguration().getTrafficDownloadPageSize();
        do {
            paginationInfo = this.downloadTrafficPageFromRemoteAndAddToQueue(pageSize, currentLastUuid);
            currentLastUuid = Optional.ofNullable(paginationInfo.getLastUuid()).filter(StringUtils::isNotEmpty);
            if (++pageNumber <= 100) continue;
            this.log.warn("Interrupting traffic-download: Reached 100 downloads! (Maybe the influx of traffic on the upstream proxy is greater then our downstream-sped?)");
            return;
        } while (paginationInfo.getAvailableMessages() > pageSize);
    }

    private PaginationInfo downloadTrafficPageFromRemoteAndAddToQueue(int pageSize, Optional<String> currentLastUuid) {
        String downloadUrl = this.getRemoteProxyUrl() + "/webui/trafficLog.tgr";
        this.log.atDebug().addArgument((Object)downloadUrl).addArgument(() -> currentLastUuid.orElse("")).addArgument((Object)pageSize).addArgument(() -> this.getRbelLogger().getMessageHistory().size()).log("Downloading missed traffic from '{}', starting after {}. page-size {} (currently cached {} messages)");
        HashMap<String, Integer> parameters = new HashMap<String, Integer>();
        parameters.put("pageSize", pageSize);
        currentLastUuid.ifPresent(uuid -> parameters.put("lastMsgUuid", (Integer)uuid));
        try {
            HttpResponse response = ((GetRequest)Unirest.get((String)downloadUrl).queryString(parameters)).asString();
            this.log.atTrace().addArgument((Object)downloadUrl).addArgument(() -> ((HttpResponse)response).getStatus()).addArgument(() -> ((String)response.getBody()).length()).log("Downloaded traffic from remote '{}', status: {}, size: {}");
            if (response.getStatus() != 200) {
                throw new TigerRemoteProxyClientException("Error while downloading message from remote '" + downloadUrl + "': " + (String)response.getBody());
            }
            this.parseTrafficChunk((String)response.getBody());
            return PaginationInfo.of((HttpResponse)response);
        }
        catch (OutOfMemoryError error) {
            this.log.error("OutOfMemoryError while downloading traffic from remote '{}'. Please increase the heap size of the Tiger Proxy.", (Object)this.getRemoteProxyUrl(), (Object)error);
            throw error;
        }
    }

    private RbelLogger getRbelLogger() {
        return this.tigerRemoteProxyClient.getRbelLogger();
    }

    private String getRemoteProxyUrl() {
        return this.tigerRemoteProxyClient.getRemoteProxyUrl();
    }

    @ConstructorProperties(value={"tigerRemoteProxyClient"})
    @Generated
    public TigerRemoteTrafficDownloader(TigerRemoteProxyClient tigerRemoteProxyClient) {
        this.tigerRemoteProxyClient = tigerRemoteProxyClient;
    }
}

