/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.client;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import de.gematik.rbellogger.RbelConversionPhase;
import de.gematik.rbellogger.RbelConverter;
import de.gematik.rbellogger.RbelConverterPlugin;
import de.gematik.rbellogger.RbelLogger;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelMessageKind;
import de.gematik.rbellogger.data.RbelMessageMetadata;
import de.gematik.rbellogger.data.core.RbelFacet;
import de.gematik.rbellogger.util.IRbelMessageListener;
import de.gematik.test.tiger.common.RingBufferHashMap;
import de.gematik.test.tiger.common.RingBufferHashSet;
import de.gematik.test.tiger.common.config.RbelModificationDescription;
import de.gematik.test.tiger.common.data.config.tigerproxy.TigerProxyConfiguration;
import de.gematik.test.tiger.common.jexl.TigerJexlExecutor;
import de.gematik.test.tiger.proxy.AbstractTigerProxy;
import de.gematik.test.tiger.proxy.TigerProxy;
import de.gematik.test.tiger.proxy.TigerProxyMessageDeletedPlugin;
import de.gematik.test.tiger.proxy.TigerProxyRemoteTransmissionConversionPlugin;
import de.gematik.test.tiger.proxy.client.PartialTracingMessage;
import de.gematik.test.tiger.proxy.client.TigerExceptionDto;
import de.gematik.test.tiger.proxy.client.TigerRemoteProxyClient;
import de.gematik.test.tiger.proxy.client.TigerRemoteProxyClientException;
import de.gematik.test.tiger.proxy.client.TigerRemoteTrafficDownloader;
import de.gematik.test.tiger.proxy.client.TigerStompSessionHandler;
import de.gematik.test.tiger.proxy.client.TracingMessagePart;
import de.gematik.test.tiger.proxy.data.TigerProxyRoute;
import de.gematik.test.tiger.proxy.exceptions.TigerProxyStartupException;
import de.gematik.test.tiger.proxy.handler.MultipleBinaryConnectionParser;
import de.gematik.test.tiger.proxy.handler.SingleConnectionParser;
import jakarta.websocket.ContainerProvider;
import jakarta.websocket.WebSocketContainer;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import kong.unirest.core.GenericType;
import kong.unirest.core.Unirest;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.messaging.converter.MappingJackson2MessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.simp.stomp.StompSession;
import org.springframework.messaging.simp.stomp.StompSessionHandler;
import org.springframework.util.Assert;
import org.springframework.web.socket.client.WebSocketClient;
import org.springframework.web.socket.client.standard.StandardWebSocketClient;
import org.springframework.web.socket.messaging.WebSocketStompClient;
import org.springframework.web.socket.sockjs.client.SockJsClient;
import org.springframework.web.socket.sockjs.client.WebSocketTransport;

public class TigerRemoteProxyClient
extends AbstractTigerProxy
implements AutoCloseable {
    public static final String WS_TRACING = "/topic/traces";
    public static final String WS_DATA = "/topic/data";
    public static final String WS_ERRORS = "/topic/errors";
    private final String remoteProxyUrl;
    private final WebSocketStompClient tigerProxyStompClient;
    private final List<TigerExceptionDto> receivedRemoteExceptions = new ArrayList();
    private final Map<String, PartialTracingMessage> partiallyReceivedMessageMap = new LinkedHashMap();
    private final MultipleBinaryConnectionParser binaryChunksBuffer;
    private final TigerStompSessionHandler tigerStompSessionHandler;
    @Nullable
    private final TigerProxy masterTigerProxy;
    private Duration maximumPartialMessageAge;
    private final AtomicReference<StompSession> stompSession = new AtomicReference();
    private final AtomicReference<String> lastMessageUuid = new AtomicReference();
    private final SockJsClient webSocketClient;
    private final int connectionTimeoutInSeconds;
    private final ScheduledExecutorService meshHandlerPool = Executors.newScheduledThreadPool(0, r -> {
        Thread t = Executors.defaultThreadFactory().newThread(r);
        t.setName("TigerProxyClient" + this.getName().map(n -> "-" + n).orElse("") + "-" + t.getId());
        return t;
    });
    private final RingBufferHashMap<String, List<Runnable>> parsingTasksWaitingForUuid = new RingBufferHashMap(10000);
    private final RingBufferHashSet<String> removedMessageUuids = new RingBufferHashSet(10000);

    public TigerRemoteProxyClient(String remoteProxyUrl) {
        this(remoteProxyUrl, new TigerProxyConfiguration(), null);
    }

    public TigerRemoteProxyClient(String remoteProxyUrl, TigerProxyConfiguration configuration) {
        this(remoteProxyUrl, configuration, null);
    }

    public TigerRemoteProxyClient(String remoteProxyUrl, TigerProxyConfiguration configuration, @Nullable TigerProxy masterTigerProxy) {
        super(configuration, masterTigerProxy == null ? null : masterTigerProxy.getRbelLogger());
        this.remoteProxyUrl = remoteProxyUrl;
        this.masterTigerProxy = masterTigerProxy;
        this.binaryChunksBuffer = new MultipleBinaryConnectionParser((AbstractTigerProxy)(masterTigerProxy == null ? this : masterTigerProxy), null);
        WebSocketContainer container = ContainerProvider.getWebSocketContainer();
        int perMessageBufferSize = configuration.getPerMessageBufferSizeInMb() * 0x100000;
        container.setDefaultMaxBinaryMessageBufferSize(perMessageBufferSize);
        container.setDefaultMaxTextMessageBufferSize(perMessageBufferSize);
        MappingJackson2MessageConverter messageConverter = new MappingJackson2MessageConverter();
        messageConverter.getObjectMapper().registerModule((Module)new JavaTimeModule());
        StandardWebSocketClient wsClient = new StandardWebSocketClient(container);
        this.webSocketClient = new SockJsClient(List.of(new WebSocketTransport((WebSocketClient)wsClient)));
        this.tigerProxyStompClient = new WebSocketStompClient((WebSocketClient)this.webSocketClient);
        this.tigerProxyStompClient.setMessageConverter((MessageConverter)messageConverter);
        this.tigerProxyStompClient.setInboundMessageSizeLimit(configuration.getStompClientBufferSizeInMb() * 0x100000);
        this.tigerStompSessionHandler = new TigerStompSessionHandler(this);
        this.maximumPartialMessageAge = Duration.ofSeconds(configuration.getMaximumPartialMessageAgeInSeconds());
        this.connectionTimeoutInSeconds = configuration.getConnectionTimeoutInSeconds();
        this.addRbelMessageListener(arg_0 -> this.signalNewCompletedMessage(arg_0));
        RbelConverter converter = this.getRbelLogger().getRbelConverter();
        converter.addConverter((RbelConverterPlugin)new TigerProxyMessageDeletedPlugin(this));
        converter.addClearHistoryCallback(() -> this.discardDelayedParsingTasks());
        converter.addMessageRemovedFromHistoryCallback(arg_0 -> this.handleMessageRemovalFromHistory(arg_0));
    }

    public void connect() {
        try {
            this.connectToRemoteUrl(this.tigerStompSessionHandler, this.connectionTimeoutInSeconds, this.getTigerProxyConfiguration().isDownloadInitialTrafficFromEndpoints());
        }
        catch (TigerProxyStartupException e) {
            if (this.getTigerProxyConfiguration().isFailOnOfflineTrafficEndpoints()) {
                this.log.warn("Ignoring offline traffic endpoint {}", (Object)this.remoteProxyUrl);
            }
            throw e;
        }
    }

    private String getTracingWebSocketUrl(String remoteProxyUrl) {
        return remoteProxyUrl.replaceFirst("http", "ws") + "/tracing";
    }

    private void downloadTrafficFromRemoteProxy() {
        new TigerRemoteTrafficDownloader(this).execute();
    }

    void connectToRemoteUrl(TigerStompSessionHandler tigerStompSessionHandler, int connectionTimeoutInSeconds, boolean downloadTraffic) {
        if (this.isShuttingDown()) {
            return;
        }
        this.waitForRemoteTigerProxyToBeOnline(this.remoteProxyUrl);
        if (this.isShuttingDown()) {
            return;
        }
        this.log.info("remote proxy at {} is online, now connecting...", (Object)this.remoteProxyUrl);
        String tracingWebSocketUrl = this.getTracingWebSocketUrl(this.remoteProxyUrl);
        ((CompletableFuture)((CompletableFuture)this.tigerProxyStompClient.connectAsync(tracingWebSocketUrl, (StompSessionHandler)tigerStompSessionHandler, new Object[0]).orTimeout(connectionTimeoutInSeconds, TimeUnit.SECONDS).thenApply(stompSessionInCallback -> {
            this.log.info("Successfully opened stomp session {} to url {}", (Object)stompSessionInCallback.getSessionId(), (Object)tracingWebSocketUrl);
            tigerStompSessionHandler.setOnConnectedCallback(() -> {
                this.log.info("Connected to remote proxy at {}, now downloading traffic...", (Object)this.remoteProxyUrl);
                if (downloadTraffic) {
                    this.downloadTrafficFromRemoteProxy();
                }
                this.log.info("Successfully downloaded traffic from remote proxy at {}", (Object)this.remoteProxyUrl);
            });
            return stompSessionInCallback;
        })).thenAccept(this.stompSession::set)).exceptionally(throwable -> {
            throw new TigerRemoteProxyClientException("Exception while opening tracing-connection to " + tracingWebSocketUrl, throwable);
        });
    }

    public TigerProxyRoute addRoute(TigerProxyRoute tigerRoute) {
        return (TigerProxyRoute)Unirest.put((String)(this.remoteProxyUrl + "/route")).body((Object)tigerRoute).contentType("application/json").asObject(TigerProxyRoute.class).ifFailure(response -> {
            throw new TigerRemoteProxyClientException("Unable to add route. Got " + response.getStatus() + ": " + (String)response.mapError(String.class));
        }).getBody();
    }

    public void removeRoute(String routeId) {
        Assert.hasText((String)routeId, () -> "No route ID given!");
        Optional<Boolean> isInternalOptional = ((List)Unirest.get((String)(this.remoteProxyUrl + "/route")).asObject((GenericType)new /* Unavailable Anonymous Inner Class!! */).getBody()).stream().filter(route -> StringUtils.equals((CharSequence)route.getId(), (CharSequence)routeId)).findFirst().map(TigerProxyRoute::isInternalRoute);
        if (isInternalOptional.isEmpty()) {
            return;
        }
        if (isInternalOptional.get().booleanValue()) {
            throw new TigerRemoteProxyClientException("Could not delete route with id '" + routeId + "': Is internal route!");
        }
        Unirest.delete((String)(this.remoteProxyUrl + "/route/" + routeId)).asString().ifFailure(httpResponse -> {
            throw new TigerRemoteProxyClientException("Unable to remove route. Got " + (String)httpResponse.getBody());
        });
    }

    public void clearAllRoutes() {
        ((List)Unirest.get((String)(this.remoteProxyUrl + "/route")).asObject((GenericType)new /* Unavailable Anonymous Inner Class!! */).getBody()).stream().filter(route -> !route.isInternalRoute()).map(TigerProxyRoute::getId).forEach(arg_0 -> this.removeRoute(arg_0));
    }

    public String getBaseUrl() {
        return this.remoteProxyUrl;
    }

    public int getProxyPort() {
        return 0;
    }

    public List<TigerProxyRoute> getRoutes() {
        return (List)Unirest.get((String)(this.remoteProxyUrl + "/route")).asObject((GenericType)new /* Unavailable Anonymous Inner Class!! */).ifFailure(response -> {
            throw new TigerRemoteProxyClientException("Unable to get routes. Got " + response.getStatus() + ": " + (String)response.mapError(String.class));
        }).getBody();
    }

    public RbelModificationDescription addModificaton(RbelModificationDescription modification) {
        return (RbelModificationDescription)Unirest.put((String)(this.remoteProxyUrl + "/modification")).body((Object)modification).contentType("application/json").asObject(RbelModificationDescription.class).ifFailure(response -> {
            throw new TigerRemoteProxyClientException("Unable to add modification. Got " + response.getStatus() + ": " + (String)response.mapError(String.class));
        }).getBody();
    }

    public List<RbelModificationDescription> getModifications() {
        return (List)Unirest.get((String)(this.remoteProxyUrl + "/modification")).asObject((GenericType)new /* Unavailable Anonymous Inner Class!! */).ifFailure(response -> {
            throw new TigerRemoteProxyClientException("Unable to get modifications. Got " + response.getStatus() + ": " + (String)response.mapError(String.class));
        }).getBody();
    }

    public void removeModification(String modificationName) {
        Assert.hasText((String)modificationName, () -> "No modification name given!");
        Unirest.delete((String)(this.remoteProxyUrl + "/modification/" + modificationName)).asEmpty().ifFailure(httpResponse -> {
            throw new TigerRemoteProxyClientException("Unable to remove modification. Got " + String.valueOf(httpResponse));
        });
    }

    void tryParseMessages(PartialTracingMessage message, Consumer<RbelElement> messagePreProcessor) {
        String messageUuid = message.getTracingDto().getMessageUuid();
        this.log.trace("Trying to parse message with UUID {}", (Object)messageUuid);
        if (this.getRbelLogger().getRbelConverter().getKnownMessageUuids().add(messageUuid)) {
            this.getBinaryChunksBuffer().addToBuffer(messageUuid, message.getSender(), message.getReceiver(), message.buildCompleteContent().toByteArray(), message.getAdditionalInformation(), message.getTracingDto().isRequest() ? RbelMessageKind.REQUEST : RbelMessageKind.RESPONSE, messagePreProcessor, (String)Optional.ofNullable(message.getAdditionalInformation().get(RbelMessageMetadata.PREVIOUS_MESSAGE_UUID.getKey())).map(Object::toString).orElse(null));
        }
    }

    protected boolean isTigerProxyMatching(TigerProxyRemoteTransmissionConversionPlugin plugin) {
        return plugin.getTigerProxy().getRbelLogger() == this.getRbelLogger();
    }

    public RbelLogger getRbelLogger() {
        if (this.masterTigerProxy != null) {
            return this.masterTigerProxy.getRbelLogger();
        }
        return super.getRbelLogger();
    }

    void removeMessage(RbelElement rbelMessage) {
        this.getRbelLogger().getRbelConverter().removeMessage(rbelMessage);
    }

    public boolean messageMatchesFilterCriterion(RbelElement rbelMessage) {
        if (StringUtils.isEmpty((CharSequence)this.getTigerProxyConfiguration().getTrafficEndpointFilterString())) {
            return true;
        }
        return TigerJexlExecutor.matchesAsJexlExpression((Object)rbelMessage, (String)this.getTigerProxyConfiguration().getTrafficEndpointFilterString(), Optional.empty());
    }

    @Override
    public void close() {
        this.log.debug("Stopping websocket client with remote URL '{}'", (Object)this.remoteProxyUrl);
        if (this.stompSession.get() != null && ((StompSession)this.stompSession.get()).isConnected()) {
            ((StompSession)this.stompSession.get()).disconnect();
        }
        this.tigerProxyStompClient.stop();
        this.webSocketClient.stop();
        this.meshHandlerPool.shutdownNow();
    }

    void receiveNewMessagePart(TracingMessagePart tracingMessagePart) {
        PartialTracingMessage tracingMessage = this.retrieveOrInitializePartialMessage(tracingMessagePart.getUuid(), PartialTracingMessage.builder().build());
        tracingMessage.addMessagePart(tracingMessagePart);
        this.checkForCompletion(tracingMessage, tracingMessagePart.getUuid());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PartialTracingMessage retrieveOrInitializePartialMessage(String uuid, PartialTracingMessage message) {
        Map map = this.partiallyReceivedMessageMap;
        synchronized (map) {
            if (this.partiallyReceivedMessageMap.containsKey(uuid)) {
                return (PartialTracingMessage)this.partiallyReceivedMessageMap.get(uuid);
            }
            this.partiallyReceivedMessageMap.put(uuid, message);
            return message;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initOrUpdateMessagePart(String uuid, PartialTracingMessage partialTracingMessage) {
        PartialTracingMessage oldMessage = null;
        Map map = this.partiallyReceivedMessageMap;
        synchronized (map) {
            if (this.partiallyReceivedMessageMap.containsKey(uuid)) {
                oldMessage = (PartialTracingMessage)this.partiallyReceivedMessageMap.get(uuid);
            }
            this.partiallyReceivedMessageMap.put(uuid, partialTracingMessage);
        }
        if (oldMessage != null) {
            partialTracingMessage.addMessageParts(oldMessage);
        }
        this.checkForCompletion(partialTracingMessage, uuid);
    }

    private void checkForCompletion(PartialTracingMessage tracingMessage, String messageUuid) {
        if (tracingMessage.isComplete()) {
            tracingMessage.getMessageFrame().checkForCompletePairAndPropagateIfComplete();
            this.partiallyReceivedMessageMap.remove(messageUuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerPartialMessageCleanup() {
        ZonedDateTime cutoff = ZonedDateTime.now().minus(this.maximumPartialMessageAge);
        Map map = this.partiallyReceivedMessageMap;
        synchronized (map) {
            Iterator entryIterator = this.partiallyReceivedMessageMap.values().iterator();
            while (entryIterator.hasNext()) {
                PartialTracingMessage next = (PartialTracingMessage)entryIterator.next();
                this.log.trace("Trying to remove {}, cutoff is {}", (Object)next.getReceivedTime(), (Object)cutoff);
                if (!cutoff.isAfter(next.getReceivedTime())) break;
                entryIterator.remove();
            }
        }
    }

    public boolean isConnected() {
        return Optional.ofNullable(this.stompSession).map(AtomicReference::get).map(StompSession::isConnected).orElse(false);
    }

    public void triggerListener(RbelElement element, RbelMessageMetadata metadata) {
        if (this.masterTigerProxy != null) {
            this.masterTigerProxy.triggerListener(element, metadata);
        } else {
            super.triggerListener(element, metadata);
        }
    }

    public void addRbelMessageListener(IRbelMessageListener listener) {
        if (this.masterTigerProxy != null) {
            this.masterTigerProxy.addRbelMessageListener(listener);
        } else {
            super.addRbelMessageListener(listener);
        }
    }

    public void propagateException(RuntimeException e) {
        if (this.masterTigerProxy != null) {
            this.masterTigerProxy.propagateException((Throwable)e);
        } else {
            this.log.atWarn().addArgument(() -> ((TigerRemoteProxyClient)this).proxyName()).log("Exception thrown (isolated TigerRemoteProxyClient instance {})", (Object)e);
        }
    }

    private void handleMessageRemovalFromHistory(RbelElement element) {
        if (!element.hasFacet(NextMessageParsedFacet.class)) {
            this.removedMessageUuids.add((Object)element.getUuid());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discardDelayedParsingTasks() {
        RingBufferHashMap ringBufferHashMap = this.parsingTasksWaitingForUuid;
        synchronized (ringBufferHashMap) {
            this.parsingTasksWaitingForUuid.clear();
            this.removedMessageUuids.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleAfterMessage(String previousMessageUuid, Runnable parseMessageTask, String thisMessageUuid) {
        RingBufferHashMap ringBufferHashMap = this.parsingTasksWaitingForUuid;
        synchronized (ringBufferHashMap) {
            if (this.removedMessageUuids.contains((Object)previousMessageUuid)) {
                this.log.trace("parsing {} immediately, prev {} is already finished and removed", (Object)thisMessageUuid, (Object)previousMessageUuid);
                this.meshHandlerPool.submit(parseMessageTask);
                this.removedMessageUuids.remove((Object)previousMessageUuid);
                return;
            }
            Optional previousMessage = this.getRbelLogger().getRbelConverter().findMessageByUuid(previousMessageUuid);
            Optional<RbelConversionPhase> previousMessageConversionPhase = previousMessage.map(RbelElement::getConversionPhase);
            if (previousMessageConversionPhase.map(RbelConversionPhase::isFinished).orElse(false).booleanValue()) {
                this.log.trace("parsing {} immediately, prev {} has status {}", new Object[]{thisMessageUuid, previousMessageUuid, previousMessageConversionPhase});
                previousMessage.ifPresent(msg -> msg.addFacet((RbelFacet)new NextMessageParsedFacet()));
                this.meshHandlerPool.submit(parseMessageTask);
            } else {
                this.log.atTrace().addArgument((Object)thisMessageUuid).addArgument((Object)previousMessageUuid).addArgument(previousMessageConversionPhase).addArgument(() -> ((RingBufferHashMap)this.parsingTasksWaitingForUuid).size()).addArgument(() -> this.parsingTasksWaitingForUuid.entries().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((List)e.getValue()).size()))).log("Queueing {} behind {} ({}), currently {} messages waiting ({})");
                ((List)this.parsingTasksWaitingForUuid.getOrPutDefault((Object)previousMessageUuid, LinkedList::new)).add(parseMessageTask);
                this.scheduleDirectParsingIfPreviousMessageHasNotEvenPartiallyArrived(thisMessageUuid, previousMessageUuid, parseMessageTask);
            }
        }
    }

    private void scheduleDirectParsingIfPreviousMessageHasNotEvenPartiallyArrived(String messageUuid, String previousMessageUuid, Runnable task) {
        float parsingTimeoutInSeconds = this.getTigerProxyConfiguration().getWaitForPreviousMessageBeforeParsingInSeconds();
        this.meshHandlerPool.schedule(() -> {
            boolean schedule = false;
            RingBufferHashMap ringBufferHashMap = this.parsingTasksWaitingForUuid;
            synchronized (ringBufferHashMap) {
                List waitingTasks = this.parsingTasksWaitingForUuid.get((Object)previousMessageUuid).orElse(null);
                if (waitingTasks != null && waitingTasks.contains(task) && !this.partiallyReceivedMessageMap.containsKey(previousMessageUuid)) {
                    this.removeFromWaitingTasks(previousMessageUuid, task, waitingTasks);
                    schedule = true;
                }
            }
            if (schedule) {
                this.meshHandlerPool.submit(task);
                this.log.warn("Parsing task for message {} triggered by timeout after {} seconds. Previous message {} did not even arrive partially.", new Object[]{messageUuid, Float.valueOf(parsingTimeoutInSeconds), previousMessageUuid});
            }
        }, (long)((int)(parsingTimeoutInSeconds * 1000.0f)), TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromWaitingTasks(String messageUuid, Runnable task, List<Runnable> tasks) {
        RingBufferHashMap ringBufferHashMap = this.parsingTasksWaitingForUuid;
        synchronized (ringBufferHashMap) {
            tasks.remove(task);
            if (tasks.isEmpty()) {
                this.parsingTasksWaitingForUuid.remove((Object)messageUuid);
            }
        }
    }

    public void signalNewCompletedMessage(RbelElement msg) {
        this.signalNewCompletedMessage(msg.getUuid());
        msg.getFacet(SingleConnectionParser.SingleConnectionParserMarkerFacet.class).map(SingleConnectionParser.SingleConnectionParserMarkerFacet::getSourceUuids).stream().flatMap(Collection::stream).distinct().filter(uuid -> !uuid.equals(msg.getUuid())).forEach(arg_0 -> this.signalNewCompletedMessage(arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signalNewCompletedMessage(String uuid) {
        ArrayList parsingTasks = new ArrayList();
        this.log.atDebug().addArgument((Object)uuid).addArgument(() -> this.getRbelLogger().getRbelConverter().findMessageByUuid(uuid).map(RbelElement::getConversionPhase)).log("Signal new completed message {} (Status is {})");
        RingBufferHashMap ringBufferHashMap = this.parsingTasksWaitingForUuid;
        synchronized (ringBufferHashMap) {
            this.parsingTasksWaitingForUuid.get((Object)uuid).ifPresent(waitingParsingTasks -> {
                if (this.removedMessageUuids.contains((Object)uuid)) {
                    this.removedMessageUuids.remove((Object)uuid);
                } else {
                    this.getRbelLogger().getRbelConverter().findMessageByUuid(uuid).ifPresent(e -> e.addFacet((RbelFacet)new NextMessageParsedFacet()));
                }
                this.parsingTasksWaitingForUuid.remove((Object)uuid);
                parsingTasks.addAll(waitingParsingTasks);
            });
        }
        this.log.trace("Submitting {} parsing tasks after completing {}", (Object)parsingTasks.size(), (Object)uuid);
        parsingTasks.forEach(this.meshHandlerPool::submit);
    }

    public void waitForAllParsingTasksToBeFinished() {
        this.binaryChunksBuffer.waitForAllParsingTasksToBeFinished();
    }

    @Generated
    public String getRemoteProxyUrl() {
        return this.remoteProxyUrl;
    }

    @Generated
    public List<TigerExceptionDto> getReceivedRemoteExceptions() {
        return this.receivedRemoteExceptions;
    }

    @Generated
    public Map<String, PartialTracingMessage> getPartiallyReceivedMessageMap() {
        return this.partiallyReceivedMessageMap;
    }

    @Generated
    public MultipleBinaryConnectionParser getBinaryChunksBuffer() {
        return this.binaryChunksBuffer;
    }

    @Generated
    public TigerStompSessionHandler getTigerStompSessionHandler() {
        return this.tigerStompSessionHandler;
    }

    @Generated
    public Duration getMaximumPartialMessageAge() {
        return this.maximumPartialMessageAge;
    }

    @Generated
    public void setMaximumPartialMessageAge(Duration maximumPartialMessageAge) {
        this.maximumPartialMessageAge = maximumPartialMessageAge;
    }

    @Generated
    public AtomicReference<String> getLastMessageUuid() {
        return this.lastMessageUuid;
    }

    @Generated
    public ScheduledExecutorService getMeshHandlerPool() {
        return this.meshHandlerPool;
    }
}

