/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.client;

import de.gematik.rbellogger.util.RbelContent;
import de.gematik.rbellogger.util.RbelSocketAddress;
import de.gematik.test.tiger.proxy.client.PartialTracingMessage;
import de.gematik.test.tiger.proxy.client.TigerTracingDto;
import de.gematik.test.tiger.proxy.client.TracingMessageFrame;
import de.gematik.test.tiger.proxy.client.TracingMessagePart;
import java.beans.ConstructorProperties;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartialTracingMessage {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PartialTracingMessage.class);
    private final TigerTracingDto tracingDto;
    private final RbelSocketAddress sender;
    private final RbelSocketAddress receiver;
    private final TracingMessageFrame messageFrame;
    private final ZonedDateTime receivedTime = ZonedDateTime.now();
    private final ArrayList<TracingMessagePart> messageParts = new ArrayList();
    private final Map<String, Object> additionalInformation;
    private int filledMessageParts;
    private int expectedMessageParts;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessagePart(TracingMessagePart part) {
        ArrayList arrayList = this.messageParts;
        synchronized (arrayList) {
            for (int i = this.messageParts.size(); i <= part.getIndex(); ++i) {
                this.messageParts.add(null);
            }
            if (this.messageParts.set(part.getIndex(), part) == null) {
                ++this.filledMessageParts;
            }
            this.expectedMessageParts = part.getNumberOfMessages();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageParts(PartialTracingMessage other) {
        ArrayList arrayList = other.messageParts;
        synchronized (arrayList) {
            ArrayList arrayList2 = this.messageParts;
            synchronized (arrayList2) {
                other.messageParts.stream().filter(Objects::nonNull).forEach(arg_0 -> this.addMessagePart(arg_0));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isComplete() {
        boolean isComplete;
        boolean bl = isComplete = this.filledMessageParts > 0 && this.expectedMessageParts == this.filledMessageParts && this.tracingDto != null;
        if (!isComplete && log.isTraceEnabled()) {
            ArrayList arrayList = this.messageParts;
            synchronized (arrayList) {
                if (this.filledMessageParts > 0 && this.messageParts.size() == this.expectedMessageParts) {
                    TracingMessagePart lastPart = (TracingMessagePart)this.messageParts.get(this.messageParts.size() - 1);
                    if (this.filledMessageParts < this.expectedMessageParts) {
                        log.atTrace().addArgument(() -> ((TracingMessagePart)lastPart).getUuid()).addArgument(() -> this.findMissingParts()).log("Received last part for message with UUID {}. Message still incomplete, missing parts: {}");
                    } else if (this.tracingDto == null) {
                        log.atTrace().addArgument(() -> ((TracingMessagePart)lastPart).getUuid()).log("Received complete data for message with UUID {}. Still waiting for metadata");
                    }
                }
            }
        }
        return isComplete;
    }

    private List<Integer> findMissingParts() {
        LinkedList<Integer> missingParts = new LinkedList<Integer>();
        int numberOfMissingParts = this.messageParts.size() - this.filledMessageParts;
        for (int i = 0; i < this.messageParts.size() && missingParts.size() < numberOfMissingParts; ++i) {
            if (this.messageParts.get(i) != null) continue;
            missingParts.add(i + 1);
        }
        return missingParts;
    }

    public RbelContent buildCompleteContent() {
        int chunkSize = this.messageParts.stream().mapToInt(part -> part.getData().length).max().orElse(1024);
        List<byte[]> chunks = this.messageParts.stream().map(TracingMessagePart::getData).toList();
        return RbelContent.builder().chunkSize(Integer.valueOf(chunkSize)).content(chunks).build();
    }

    @Generated
    private static Map<String, Object> $default$additionalInformation() {
        return Map.of();
    }

    @ConstructorProperties(value={"tracingDto", "sender", "receiver", "messageFrame", "additionalInformation", "filledMessageParts", "expectedMessageParts"})
    @Generated
    PartialTracingMessage(TigerTracingDto tracingDto, RbelSocketAddress sender, RbelSocketAddress receiver, TracingMessageFrame messageFrame, Map<String, Object> additionalInformation, int filledMessageParts, int expectedMessageParts) {
        this.tracingDto = tracingDto;
        this.sender = sender;
        this.receiver = receiver;
        this.messageFrame = messageFrame;
        this.additionalInformation = additionalInformation;
        this.filledMessageParts = filledMessageParts;
        this.expectedMessageParts = expectedMessageParts;
    }

    @Generated
    public static PartialTracingMessageBuilder builder() {
        return new PartialTracingMessageBuilder();
    }

    @Generated
    public PartialTracingMessageBuilder toBuilder() {
        return new PartialTracingMessageBuilder().tracingDto(this.tracingDto).sender(this.sender).receiver(this.receiver).messageFrame(this.messageFrame).additionalInformation(this.additionalInformation).filledMessageParts(this.filledMessageParts).expectedMessageParts(this.expectedMessageParts);
    }

    @Generated
    public TigerTracingDto getTracingDto() {
        return this.tracingDto;
    }

    @Generated
    public RbelSocketAddress getSender() {
        return this.sender;
    }

    @Generated
    public RbelSocketAddress getReceiver() {
        return this.receiver;
    }

    @Generated
    public TracingMessageFrame getMessageFrame() {
        return this.messageFrame;
    }

    @Generated
    public ZonedDateTime getReceivedTime() {
        return this.receivedTime;
    }

    @Generated
    public Map<String, Object> getAdditionalInformation() {
        return this.additionalInformation;
    }

    @Generated
    public int getFilledMessageParts() {
        return this.filledMessageParts;
    }

    @Generated
    public int getExpectedMessageParts() {
        return this.expectedMessageParts;
    }

    @Generated
    public void setFilledMessageParts(int filledMessageParts) {
        this.filledMessageParts = filledMessageParts;
    }

    @Generated
    public void setExpectedMessageParts(int expectedMessageParts) {
        this.expectedMessageParts = expectedMessageParts;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PartialTracingMessage)) {
            return false;
        }
        PartialTracingMessage other = (PartialTracingMessage)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getFilledMessageParts() != other.getFilledMessageParts()) {
            return false;
        }
        if (this.getExpectedMessageParts() != other.getExpectedMessageParts()) {
            return false;
        }
        TigerTracingDto this$tracingDto = this.getTracingDto();
        TigerTracingDto other$tracingDto = other.getTracingDto();
        if (this$tracingDto == null ? other$tracingDto != null : !this$tracingDto.equals(other$tracingDto)) {
            return false;
        }
        RbelSocketAddress this$sender = this.getSender();
        RbelSocketAddress other$sender = other.getSender();
        if (this$sender == null ? other$sender != null : !this$sender.equals(other$sender)) {
            return false;
        }
        RbelSocketAddress this$receiver = this.getReceiver();
        RbelSocketAddress other$receiver = other.getReceiver();
        if (this$receiver == null ? other$receiver != null : !this$receiver.equals(other$receiver)) {
            return false;
        }
        TracingMessageFrame this$messageFrame = this.getMessageFrame();
        TracingMessageFrame other$messageFrame = other.getMessageFrame();
        if (this$messageFrame == null ? other$messageFrame != null : !this$messageFrame.equals(other$messageFrame)) {
            return false;
        }
        ZonedDateTime this$receivedTime = this.getReceivedTime();
        ZonedDateTime other$receivedTime = other.getReceivedTime();
        if (this$receivedTime == null ? other$receivedTime != null : !((Object)this$receivedTime).equals(other$receivedTime)) {
            return false;
        }
        ArrayList this$messageParts = this.getMessageParts();
        ArrayList other$messageParts = other.getMessageParts();
        if (this$messageParts == null ? other$messageParts != null : !((Object)this$messageParts).equals(other$messageParts)) {
            return false;
        }
        Map this$additionalInformation = this.getAdditionalInformation();
        Map other$additionalInformation = other.getAdditionalInformation();
        return !(this$additionalInformation == null ? other$additionalInformation != null : !((Object)this$additionalInformation).equals(other$additionalInformation));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PartialTracingMessage;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getFilledMessageParts();
        result = result * 59 + this.getExpectedMessageParts();
        TigerTracingDto $tracingDto = this.getTracingDto();
        result = result * 59 + ($tracingDto == null ? 43 : $tracingDto.hashCode());
        RbelSocketAddress $sender = this.getSender();
        result = result * 59 + ($sender == null ? 43 : $sender.hashCode());
        RbelSocketAddress $receiver = this.getReceiver();
        result = result * 59 + ($receiver == null ? 43 : $receiver.hashCode());
        TracingMessageFrame $messageFrame = this.getMessageFrame();
        result = result * 59 + ($messageFrame == null ? 43 : $messageFrame.hashCode());
        ZonedDateTime $receivedTime = this.getReceivedTime();
        result = result * 59 + ($receivedTime == null ? 43 : ((Object)$receivedTime).hashCode());
        ArrayList $messageParts = this.getMessageParts();
        result = result * 59 + ($messageParts == null ? 43 : ((Object)$messageParts).hashCode());
        Map $additionalInformation = this.getAdditionalInformation();
        result = result * 59 + ($additionalInformation == null ? 43 : ((Object)$additionalInformation).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PartialTracingMessage(sender=" + String.valueOf(this.getSender()) + ", receiver=" + String.valueOf(this.getReceiver()) + ", receivedTime=" + String.valueOf(this.getReceivedTime()) + ", messageParts=" + String.valueOf(this.getMessageParts()) + ", additionalInformation=" + String.valueOf(this.getAdditionalInformation()) + ", filledMessageParts=" + this.getFilledMessageParts() + ", expectedMessageParts=" + this.getExpectedMessageParts() + ")";
    }

    @Generated
    private ArrayList<TracingMessagePart> getMessageParts() {
        return this.messageParts;
    }
}

