/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.client;

import de.gematik.test.tiger.proxy.client.TigerRemoteProxyClient;
import de.gematik.test.tiger.proxy.client.TracingMessagePart;
import de.gematik.test.tiger.proxy.exceptions.TigerProxyException;
import java.beans.ConstructorProperties;
import java.lang.reflect.Type;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.simp.stomp.StompFrameHandler;
import org.springframework.messaging.simp.stomp.StompHeaders;

class DataStompHandler
implements StompFrameHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataStompHandler.class);
    private final TigerRemoteProxyClient remoteProxyClient;

    public Type getPayloadType(StompHeaders stompHeaders) {
        return TracingMessagePart.class;
    }

    public void handleFrame(StompHeaders stompHeaders, Object frameContent) {
        if (frameContent instanceof TracingMessagePart) {
            TracingMessagePart tracingMessagePart = (TracingMessagePart)frameContent;
            CompletableFuture.runAsync(() -> {
                log.atTrace().addArgument(() -> tracingMessagePart.getIndex() + 1).addArgument(() -> ((TracingMessagePart)tracingMessagePart).getNumberOfMessages()).addArgument(() -> ((TracingMessagePart)tracingMessagePart).getUuid()).addArgument(() -> ((TigerRemoteProxyClient)this.remoteProxyClient).getName()).log("Received part {} of {} for UUID {} at {}");
                this.remoteProxyClient.receiveNewMessagePart(tracingMessagePart);
            }, this.remoteProxyClient.getMeshHandlerPool()).exceptionally(e -> {
                this.remoteProxyClient.propagateException((RuntimeException)new TigerProxyException("Error while handling message '" + tracingMessagePart.getUuid() + "': " + e.getMessage(), e));
                return null;
            });
        }
    }

    @ConstructorProperties(value={"remoteProxyClient"})
    @Generated
    public DataStompHandler(TigerRemoteProxyClient remoteProxyClient) {
        this.remoteProxyClient = remoteProxyClient;
    }
}

