/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.certificate;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelMessageMetadata;
import de.gematik.rbellogger.data.RbelMultiMap;
import de.gematik.rbellogger.data.core.RbelFacet;
import java.util.Base64;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;

public final class TlsFacet
implements RbelFacet {
    private static final RbelMessageMetadata.RbelMetadataValue<String> TLS_VERSION = new RbelMessageMetadata.RbelMetadataValue("tlsVersion", String.class);
    private static final RbelMessageMetadata.RbelMetadataValue<String> CIPHER_SUITE = new RbelMessageMetadata.RbelMetadataValue("cipherSuite", String.class);
    private static final RbelMessageMetadata.RbelMetadataValue<String[]> CLIENT_TLS_CERTIFICATE_CHAIN = new RbelMessageMetadata.RbelMetadataValue("clientTlsCertificateChain", String[].class);
    private final RbelElement tlsVersion;
    private final RbelElement cipherSuite;
    private final RbelElement clientCertificateChain;
    private final RbelMultiMap<RbelElement> childElements;

    public TlsFacet(RbelElement tlsVersion, RbelElement cipherSuite, RbelElement clientCertificateChain) {
        this.tlsVersion = tlsVersion;
        this.cipherSuite = cipherSuite;
        this.clientCertificateChain = clientCertificateChain;
        this.childElements = new RbelMultiMap().with(TLS_VERSION.getKey(), (Object)tlsVersion).with(CIPHER_SUITE.getKey(), (Object)cipherSuite).withSkipIfNull(CLIENT_TLS_CERTIFICATE_CHAIN.getKey(), (Object)clientCertificateChain);
    }

    private static String[] packageClientCertificateChain(TlsFacet tlsFacet) {
        return (String[])Optional.of(tlsFacet).map(TlsFacet::getClientCertificateChain).map(RbelElement::getChildNodes).stream().flatMap(Collection::stream).map(RbelElement::getRawContent).map(Base64.getEncoder()::encodeToString).toArray(String[]::new);
    }

    private static Stream<byte[]> unpackageClientCertificateChain(String[] certificates) {
        return Stream.of(certificates).map(Base64.getDecoder()::decode);
    }

    @Generated
    public RbelElement getTlsVersion() {
        return this.tlsVersion;
    }

    @Generated
    public RbelElement getCipherSuite() {
        return this.cipherSuite;
    }

    @Generated
    public RbelElement getClientCertificateChain() {
        return this.clientCertificateChain;
    }

    @Generated
    public RbelMultiMap<RbelElement> getChildElements() {
        return this.childElements;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TlsFacet)) {
            return false;
        }
        TlsFacet other = (TlsFacet)o;
        RbelElement this$tlsVersion = this.getTlsVersion();
        RbelElement other$tlsVersion = other.getTlsVersion();
        if (this$tlsVersion == null ? other$tlsVersion != null : !this$tlsVersion.equals(other$tlsVersion)) {
            return false;
        }
        RbelElement this$cipherSuite = this.getCipherSuite();
        RbelElement other$cipherSuite = other.getCipherSuite();
        if (this$cipherSuite == null ? other$cipherSuite != null : !this$cipherSuite.equals(other$cipherSuite)) {
            return false;
        }
        RbelElement this$clientCertificateChain = this.getClientCertificateChain();
        RbelElement other$clientCertificateChain = other.getClientCertificateChain();
        if (this$clientCertificateChain == null ? other$clientCertificateChain != null : !this$clientCertificateChain.equals(other$clientCertificateChain)) {
            return false;
        }
        RbelMultiMap this$childElements = this.getChildElements();
        RbelMultiMap other$childElements = other.getChildElements();
        return !(this$childElements == null ? other$childElements != null : !this$childElements.equals(other$childElements));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RbelElement $tlsVersion = this.getTlsVersion();
        result = result * 59 + ($tlsVersion == null ? 43 : $tlsVersion.hashCode());
        RbelElement $cipherSuite = this.getCipherSuite();
        result = result * 59 + ($cipherSuite == null ? 43 : $cipherSuite.hashCode());
        RbelElement $clientCertificateChain = this.getClientCertificateChain();
        result = result * 59 + ($clientCertificateChain == null ? 43 : $clientCertificateChain.hashCode());
        RbelMultiMap $childElements = this.getChildElements();
        result = result * 59 + ($childElements == null ? 43 : $childElements.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TlsFacet(tlsVersion=" + String.valueOf(this.getTlsVersion()) + ", cipherSuite=" + String.valueOf(this.getCipherSuite()) + ", clientCertificateChain=" + String.valueOf(this.getClientCertificateChain()) + ", childElements=" + String.valueOf(this.getChildElements()) + ")";
    }
}

