/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy;

import de.gematik.test.tiger.common.data.config.tigerproxy.ForwardProxyInfo;
import de.gematik.test.tiger.common.web.InsecureTrustAllManager;
import de.gematik.test.tiger.util.NoProxyUtils;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TigerRouteSelector {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerRouteSelector.class);
    private final List<String> routeDestinations;
    private final ForwardProxyInfo forwardProxyInfo;

    public String selectFirstReachableDestination() {
        if (this.routeDestinations.isEmpty()) {
            throw new IllegalStateException("No route destinations provided");
        }
        if (this.routeDestinations.size() == 1) {
            return (String)this.routeDestinations.get(0);
        }
        return this.routeDestinations.parallelStream().filter(arg_0 -> this.isReachable(arg_0)).findAny().orElseThrow(() -> new IllegalStateException("No reachable destination found among " + String.valueOf(this.routeDestinations)));
    }

    private boolean isReachable(String destination) {
        try {
            log.debug("Checking if destination '{}' is reachable", (Object)destination);
            HttpURLConnection connection = this.openConnection(URI.create(destination).toURL());
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            connection.setInstanceFollowRedirects(false);
            connection.setRequestMethod("HEAD");
            InsecureTrustAllManager.allowAllSsl((URLConnection)connection);
            connection.connect();
            int responseCode = connection.getResponseCode();
            log.debug("Got response code {} for destination '{}'", (Object)responseCode, (Object)destination);
            return responseCode != -1;
        }
        catch (IOException e) {
            log.warn("Destination '{}' is not reachable:", (Object)destination, (Object)e);
            return false;
        }
    }

    private HttpURLConnection openConnection(URL destination) throws IOException {
        HttpURLConnection connection;
        if (this.forwardProxyInfo != null) {
            InetAddress targetHost = InetAddress.getByName(this.forwardProxyInfo.getHostname());
            if (NoProxyUtils.shouldUseProxyForHost((InetAddress)targetHost, (List)this.forwardProxyInfo.getNoProxyHosts())) {
                InetSocketAddress inetSocketAddress = new InetSocketAddress(targetHost, (int)this.forwardProxyInfo.getPort());
                log.debug("Using forward proxy for host '{}': {}:{}", new Object[]{targetHost, inetSocketAddress.getHostName(), inetSocketAddress.getPort()});
                connection = (HttpURLConnection)destination.openConnection(new Proxy(Proxy.Type.HTTP, inetSocketAddress));
            } else {
                log.debug("No forward proxy configured for host '{}', using direct connection", (Object)targetHost);
                connection = (HttpURLConnection)destination.openConnection(Proxy.NO_PROXY);
            }
        } else {
            log.debug("No forward proxy configured, using direct connection for {}", (Object)destination);
            connection = (HttpURLConnection)destination.openConnection(Proxy.NO_PROXY);
        }
        return connection;
    }

    @ConstructorProperties(value={"routeDestinations", "forwardProxyInfo"})
    @Generated
    public TigerRouteSelector(List<String> routeDestinations, ForwardProxyInfo forwardProxyInfo) {
        this.routeDestinations = routeDestinations;
        this.forwardProxyInfo = forwardProxyInfo;
    }
}

