/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy;

import de.gematik.rbellogger.RbelConversionExecutor;
import de.gematik.rbellogger.RbelConverterPlugin;
import de.gematik.rbellogger.converter.ConverterInfo;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.core.RbelFacet;
import de.gematik.rbellogger.data.core.RbelListFacet;
import de.gematik.rbellogger.data.core.RbelNoteFacet;
import de.gematik.rbellogger.data.core.TracingMessagePairFacet;
import de.gematik.rbellogger.facets.http.RbelHttpRequestFacet;
import de.gematik.rbellogger.facets.http.RbelHttpResponseFacet;
import de.gematik.test.tiger.mockserver.model.HttpRequest;
import de.gematik.test.tiger.mockserver.model.MockserverX509CertificateWrapper;
import de.gematik.test.tiger.proxy.MockServerRequestFacet;
import de.gematik.test.tiger.proxy.MockServerResponseFacet;
import de.gematik.test.tiger.proxy.certificate.TlsFacet;
import de.gematik.test.tiger.proxy.handler.BundledServerNamesAdder;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@ConverterInfo(addAutomatically=false)
public class TigerProxyPairingConverter
extends RbelConverterPlugin {
    private final BundledServerNamesAdder bundledServerNamesAdder = new BundledServerNamesAdder();

    public synchronized void consumeElement(RbelElement rbelElement, RbelConversionExecutor converter) {
        Optional requestFacet = rbelElement.getFacet(MockServerRequestFacet.class);
        Optional responseFacet = rbelElement.getFacet(MockServerResponseFacet.class);
        if (rbelElement.hasFacet(RbelHttpRequestFacet.class) && requestFacet.isPresent()) {
            this.parseCertificateChainIfPresent(((MockServerRequestFacet)requestFacet.get()).getHttpRequest(), rbelElement, converter);
            rbelElement.removeFacetsOfType(MockServerRequestFacet.class);
            this.addHostnames(rbelElement);
        } else if (rbelElement.hasFacet(RbelHttpResponseFacet.class) && responseFacet.isPresent()) {
            this.parseCertificateChainIfPresent(((MockServerResponseFacet)responseFacet.get()).getHttpRequest(), rbelElement, converter);
            this.addPairingFacet(rbelElement, ((MockServerResponseFacet)responseFacet.get()).getHttpRequest().getCorrespondingRbelMessage());
            rbelElement.removeFacetsOfType(MockServerRequestFacet.class);
            this.addHostnames(rbelElement);
        }
    }

    private void addPairingFacet(RbelElement response, RbelElement request) {
        response.addOrReplaceFacet((RbelFacet)new TracingMessagePairFacet(response, request));
        request.addOrReplaceFacet((RbelFacet)new TracingMessagePairFacet(response, request));
    }

    private void parseCertificateChainIfPresent(HttpRequest httpRequest, RbelElement message, RbelConversionExecutor rbelConverter) {
        if (StringUtils.isBlank((CharSequence)httpRequest.getTlsVersion())) {
            return;
        }
        RbelElement certificateChainElement = null;
        if (httpRequest.getClientCertificateChain() != null && !httpRequest.getClientCertificateChain().isEmpty()) {
            certificateChainElement = this.parseCertificateChain(httpRequest, message, rbelConverter);
        }
        message.addFacet((RbelFacet)new TlsFacet(RbelElement.wrap((RbelElement)message, (Object)httpRequest.getTlsVersion()), RbelElement.wrap((RbelElement)message, (Object)httpRequest.getCipherSuite()), certificateChainElement));
    }

    private RbelElement parseCertificateChain(HttpRequest httpRequest, RbelElement message, RbelConversionExecutor rbelConverter) {
        RbelElement chain = new RbelElement(null, message);
        chain.addFacet((RbelFacet)RbelListFacet.builder().childNodes(httpRequest.getClientCertificateChain().stream().map(MockserverX509CertificateWrapper::certificate).map(cert -> TigerProxyPairingConverter.mapToRbelElement((Certificate)cert, (RbelElement)chain, (RbelConversionExecutor)rbelConverter)).toList()).build());
        return chain;
    }

    private void addHostnames(RbelElement element) {
        this.bundledServerNamesAdder.addBundledServerNameToHostnameFacet(element);
    }

    public static RbelElement mapToRbelElement(Certificate certificate, RbelElement parentNode, RbelConversionExecutor converter) {
        try {
            RbelElement certificateNode = new RbelElement(certificate.getEncoded(), parentNode);
            converter.convertElement(certificateNode);
            return certificateNode;
        }
        catch (CertificateEncodingException e) {
            RbelElement rbelElement = new RbelElement(null, parentNode);
            rbelElement.addFacet((RbelFacet)RbelNoteFacet.builder().style(RbelNoteFacet.NoteStyling.ERROR).value("Error while trying to get binary representation for certificate: " + e.getMessage()).build());
            return rbelElement;
        }
    }

    @Generated
    public TigerProxyPairingConverter() {
    }
}

