/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy;

import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.renderer.RbelHtmlRenderer;
import de.gematik.test.tiger.common.data.config.tigerproxy.TigerProxyConfiguration;
import de.gematik.test.tiger.server.TigerBuildPropertiesService;
import jakarta.servlet.ServletContextListener;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.Banner;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.annotation.Bean;

@SpringBootApplication(scanBasePackageClasses={TigerBuildPropertiesService.class, TigerProxyApplication.class})
public class TigerProxyApplication
implements ServletContextListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerProxyApplication.class);
    private final TigerProxyConfiguration proxyConfiguration;

    public static void main(String[] args) {
        System.setProperty("java.util.logging.config.file", "SKIP_MOCKSERVER_LOG_INIT!");
        new SpringApplicationBuilder(new Class[0]).bannerMode(Banner.Mode.OFF).sources(new Class[]{TigerProxyApplication.class}).initializers(new ApplicationContextInitializer[0]).run(args);
    }

    @Bean
    public SimpleModule rbelElementDeserializer() {
        SimpleModule module = new SimpleModule();
        module.addSerializer(RbelElement.class, (JsonSerializer)new /* Unavailable Anonymous Inner Class!! */);
        return module;
    }

    @Bean
    public RbelHtmlRenderer rbelHtmlRenderer() {
        RbelHtmlRenderer renderer = new RbelHtmlRenderer();
        renderer.setMaximumEntitySizeInBytes((long)this.proxyConfiguration.getSkipDisplayWhenMessageLargerThanKb() * 1024L);
        renderer.setMaximumDefaultExpandedMessageDepth((long)this.proxyConfiguration.getMaximumDefaultExpandedMessageDepth());
        return renderer;
    }

    @ConstructorProperties(value={"proxyConfiguration"})
    @Generated
    public TigerProxyApplication(TigerProxyConfiguration proxyConfiguration) {
        this.proxyConfiguration = proxyConfiguration;
    }

    @Generated
    public TigerProxyConfiguration getProxyConfiguration() {
        return this.proxyConfiguration;
    }
}

