/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy;

import de.gematik.rbellogger.RbelConverterPlugin;
import de.gematik.rbellogger.facets.http.RbelHttpPairingInBinaryChannelConverter;
import de.gematik.rbellogger.util.RbelMessagesSupplier;
import de.gematik.test.tiger.common.config.RbelModificationDescription;
import de.gematik.test.tiger.common.config.TigerConfigurationException;
import de.gematik.test.tiger.common.data.config.tigerproxy.ForwardProxyInfo;
import de.gematik.test.tiger.common.data.config.tigerproxy.TigerConfigurationRoute;
import de.gematik.test.tiger.common.data.config.tigerproxy.TigerProxyConfiguration;
import de.gematik.test.tiger.common.data.config.tigerproxy.TigerTlsConfiguration;
import de.gematik.test.tiger.common.pki.TigerPkiIdentity;
import de.gematik.test.tiger.mockserver.configuration.MockServerConfiguration;
import de.gematik.test.tiger.mockserver.mock.Expectation;
import de.gematik.test.tiger.mockserver.mock.action.ExpectationCallback;
import de.gematik.test.tiger.mockserver.model.HttpRequest;
import de.gematik.test.tiger.mockserver.netty.MockServer;
import de.gematik.test.tiger.mockserver.proxyconfiguration.ProxyConfiguration;
import de.gematik.test.tiger.mockserver.socket.tls.KeyAndCertificateFactory;
import de.gematik.test.tiger.proxy.AbstractTigerProxy;
import de.gematik.test.tiger.proxy.MockServerToRbelConverter;
import de.gematik.test.tiger.proxy.TigerProxy;
import de.gematik.test.tiger.proxy.TigerProxyPairingConverter;
import de.gematik.test.tiger.proxy.client.TigerRemoteProxyClient;
import de.gematik.test.tiger.proxy.configuration.ProxyConfigurationConverter;
import de.gematik.test.tiger.proxy.data.TigerConnectionStatus;
import de.gematik.test.tiger.proxy.data.TigerProxyRoute;
import de.gematik.test.tiger.proxy.exceptions.TigerProxyStartupException;
import de.gematik.test.tiger.proxy.handler.BinaryExchangeHandler;
import de.gematik.test.tiger.proxy.handler.ForwardAllCallback;
import de.gematik.test.tiger.proxy.handler.RbelBinaryModifierPlugin;
import de.gematik.test.tiger.proxy.tls.DynamicKeyAndCertificateFactory;
import de.gematik.test.tiger.proxy.tls.MockServerTlsConfigurator;
import jakarta.annotation.PreDestroy;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.tomcat.util.buf.UriUtil;
import org.bouncycastle.jsse.provider.BouncyCastleJsseProvider;

public class TigerProxy
extends AbstractTigerProxy
implements AutoCloseable,
RbelMessagesSupplier {
    private static final String CA_CERT_ALIAS = "caCert";
    private final List<KeyAndCertificateFactory> tlsFactories = new ArrayList();
    private final List<Consumer<Throwable>> exceptionListeners = new ArrayList();
    private final MockServerToRbelConverter mockServerToRbelConverter;
    private final Map<String, TigerProxyRoute> tigerRouteMap = new HashMap();
    private final List<TigerRemoteProxyClient> remoteProxyClients = new ArrayList();
    private final UUID healthEndpointRequestUuid = UUID.randomUUID();
    private MockServer mockServer;
    private TigerPkiIdentity serverRootCa;
    private final TigerProxyPairingConverter pairingConverter = new TigerProxyPairingConverter();

    public TigerProxy(TigerProxyConfiguration configuration) {
        super(configuration);
        this.getRbelLogger().getRbelConverter().addConverter((RbelConverterPlugin)this.pairingConverter);
        this.mockServerToRbelConverter = new MockServerToRbelConverter(this.getRbelLogger().getRbelConverter());
        this.bootMockServer();
        if (configuration.getModifications() != null) {
            int counter = 0;
            for (RbelModificationDescription modification : configuration.getModifications()) {
                if (modification.getName() == null) {
                    modification.setName("TigerModification #" + counter++);
                }
                this.getRbelLogger().getRbelModifier().addModification(modification);
            }
        }
    }

    public void restartMockserver() {
        if (this.getTigerProxyConfiguration().getProxyPort() == null) {
            this.getTigerProxyConfiguration().setProxyPort(Integer.valueOf(this.mockServer.getLocalPort()));
        }
        HashMap originalRoutes = new HashMap(this.tigerRouteMap);
        this.mockServer.stop();
        this.tigerRouteMap.clear();
        this.bootMockServer();
        originalRoutes.values().stream().filter(r -> !r.isInternalRoute()).forEach(r -> {
            try {
                this.log.atDebug().addArgument(() -> ((TigerProxyRoute)r).getFrom()).addArgument(() -> ((TigerProxyRoute)r).getTo()).log("Adding route from {} to {}");
                this.addRoute(r);
            }
            catch (RuntimeException e) {
                this.log.trace("Ignored exception during re-adding of routes", (Throwable)e);
            }
        });
        this.log.info("Restarted and added all routes");
    }

    private void bootMockServer() {
        this.createNewMockServer();
        if (this.getTigerProxyConfiguration().isActivateForwardAllLogging()) {
            this.mockServer.addRoute(Expectation.builder().requestPattern(HttpRequest.request().setPath("/").setForwardProxyRequest(Boolean.valueOf(true))).priority(Integer.MIN_VALUE).hostRegexes(List.of()).expectationCallback((ExpectationCallback)new ForwardAllCallback(this)).build());
        }
        this.addRoutesToTigerProxy();
    }

    private void createNewMockServer() {
        MockServerConfiguration mockServerConfiguration = MockServerConfiguration.configuration();
        mockServerConfiguration.mockServerName(this.getName().orElse("MockServer"));
        mockServerConfiguration.rbelConverter(this.getRbelLogger().getRbelConverter());
        MockServerTlsConfigurator tlsConfigurator = MockServerTlsConfigurator.builder().tigerProxyConfiguration(this.getTigerProxyConfiguration()).mockServerConfiguration(mockServerConfiguration).tigerProxyName(this.getName()).serverRootCa(this.serverRootCa).build();
        tlsConfigurator.execute();
        this.serverRootCa = tlsConfigurator.getServerRootCa();
        mockServerConfiguration.enableTlsTermination(this.getTigerProxyConfiguration().isActivateTlsTermination());
        Optional proxyConfiguration = ProxyConfigurationConverter.convertForwardProxyConfigurationToMockServerConfiguration((TigerProxyConfiguration)this.getTigerProxyConfiguration());
        this.outputForwardProxyConfigLogs(proxyConfiguration);
        proxyConfiguration.ifPresent(arg_0 -> ((MockServerConfiguration)mockServerConfiguration).proxyConfiguration(arg_0));
        mockServerConfiguration.exceptionHandlingCallback(this.getMockServerToRbelConverter().exceptionCallback());
        this.mockServer = this.getTigerProxyConfiguration().getDirectReverseProxy() == null ? new MockServer(mockServerConfiguration, this.getTigerProxyConfiguration().getPortAsArray()) : this.spawnDirectInverseTigerProxy(mockServerConfiguration);
        String proxyName = this.getName().orElse("?");
        this.log.info("Proxy '{}' started on port {}", (Object)proxyName, (Object)this.mockServer.getLocalPort());
    }

    private void addRoutesToTigerProxy() {
        if (this.getTigerProxyConfiguration().getProxyRoutes() != null) {
            for (TigerConfigurationRoute tigerRoute : this.getTigerProxyConfiguration().getProxyRoutes()) {
                this.addRoute(tigerRoute);
            }
        }
    }

    private MockServer spawnDirectInverseTigerProxy(MockServerConfiguration mockServerConfiguration) {
        mockServerConfiguration.binaryProxyListener(new BinaryExchangeHandler(this));
        if (mockServerConfiguration.proxyConfiguration() != null) {
            throw new TigerProxyStartupException("DirectForwardProxy configured with additional forwardProxy: Not possible! (forwardProxy is always HTTP!)");
        }
        mockServerConfiguration.directForwarding(InetSocketAddress.createUnresolved(this.getTigerProxyConfiguration().getDirectReverseProxy().getHostname(), this.getTigerProxyConfiguration().getDirectReverseProxy().getPort()));
        if (this.getTigerProxyConfiguration().getDirectReverseProxy().getModifierPlugins() != null) {
            mockServerConfiguration.binaryModifierPlugins(this.getTigerProxyConfiguration().getDirectReverseProxy().getModifierPlugins().stream().map(RbelBinaryModifierPlugin::instantiateModifierPlugin).toList());
        }
        MockServer newMockServer = new MockServer(mockServerConfiguration, this.getTigerProxyConfiguration().getPortAsArray());
        this.addReverseProxyRouteIfNotPresent();
        this.getRbelLogger().getRbelConverter().addConverter((RbelConverterPlugin)new RbelHttpPairingInBinaryChannelConverter());
        return newMockServer;
    }

    private void addReverseProxyRouteIfNotPresent() {
        if (this.getTigerProxyConfiguration().getProxyRoutes() == null) {
            this.getTigerProxyConfiguration().setProxyRoutes(new ArrayList());
        }
        this.getTigerProxyConfiguration().getProxyRoutes().add(TigerConfigurationRoute.builder().from("/").to(List.of("http://" + this.getTigerProxyConfiguration().getDirectReverseProxy().getHostname() + ":" + this.getTigerProxyConfiguration().getDirectReverseProxy().getPort())).build());
    }

    public void subscribeToTrafficEndpoints() {
        Optional.of(this.getTigerProxyConfiguration()).map(TigerProxyConfiguration::getTrafficEndpoints).ifPresent(arg_0 -> this.subscribeToTrafficEndpoints(arg_0));
    }

    public void subscribeToTrafficEndpoints(List<String> trafficEndpointUrls) {
        if (this.log.isInfoEnabled()) {
            this.log.info("Subscribing to traffic endpoints for Tiger Proxy '{}'. Found {} endpoints", (Object)this.getName().orElse("?"), (Object)trafficEndpointUrls.size());
        }
        ((Stream)Optional.of(trafficEndpointUrls).stream().flatMap(Collection::stream).parallel()).map(url -> new TigerRemoteProxyClient(url, TigerProxyConfiguration.builder().downloadInitialTrafficFromEndpoints(this.getTigerProxyConfiguration().isDownloadInitialTrafficFromEndpoints()).trafficEndpointFilterString(this.getTigerProxyConfiguration().getTrafficEndpointFilterString()).name(this.getTigerProxyConfiguration().getName()).failOnOfflineTrafficEndpoints(this.getTigerProxyConfiguration().isFailOnOfflineTrafficEndpoints()).connectionTimeoutInSeconds(this.getTigerProxyConfiguration().getConnectionTimeoutInSeconds()).requireHealthyTrafficEndpoints(this.getTigerProxyConfiguration().isRequireHealthyTrafficEndpoints()).build(), this)).forEach(this.remoteProxyClients::add);
        this.remoteProxyClients.parallelStream().forEach(TigerRemoteProxyClient::connect);
    }

    public String getBaseUrl() {
        return "http://localhost:" + this.mockServer.getLocalPort();
    }

    public int getProxyPort() {
        return this.mockServer.getLocalPort();
    }

    public int getAdminPort() {
        return this.getTigerProxyConfiguration().getAdminPort();
    }

    public List<TigerProxyRoute> getRoutes() {
        return this.tigerRouteMap.values().stream().toList();
    }

    public RbelModificationDescription addModificaton(RbelModificationDescription modification) {
        this.getRbelLogger().getRbelModifier().addModification(modification);
        return modification;
    }

    public List<RbelModificationDescription> getModifications() {
        return this.getRbelLogger().getRbelModifier().getModifications();
    }

    public void removeModification(String modificationId) {
        this.getRbelLogger().getRbelModifier().deleteModification(modificationId);
    }

    public TigerProxyRoute addRoute(TigerConfigurationRoute tigerRoute) {
        return this.addRoute(TigerProxyRoute.convertFromTigerConfigurationRoute((TigerConfigurationRoute)tigerRoute, (ForwardProxyInfo)this.getTigerProxyConfiguration().getForwardToProxy()));
    }

    public synchronized TigerProxyRoute addRoute(TigerProxyRoute tigerRoute) {
        if (!this.isAllowedRoute(tigerRoute.getTo())) {
            throw new TigerConfigurationException("Route '" + tigerRoute.getTo() + "' is not permitted!");
        }
        this.log.info("Adding route {} -> {}", (Object)tigerRoute.getFrom(), (Object)tigerRoute.getTo());
        Expectation expectation = this.buildRouteAndReturnExpectation(tigerRoute);
        expectation.setTigerRoute(tigerRoute);
        TigerProxyRoute createdTigerRoute = tigerRoute.withId(expectation.getId());
        this.tigerRouteMap.put(expectation.getId(), createdTigerRoute);
        this.log.debug("Created route from {} to {}", (Object)tigerRoute.getFrom(), (Object)tigerRoute.getTo());
        return createdTigerRoute;
    }

    private boolean isAllowedRoute(String route) {
        try {
            URI uri = new URI(route);
            if (uri.getHost() == null || uri.getHost().isEmpty()) {
                return false;
            }
            uri.toURL();
            return true;
        }
        catch (RuntimeException | MalformedURLException | URISyntaxException e) {
            return false;
        }
    }

    private Expectation buildRouteAndReturnExpectation(TigerProxyRoute tigerRoute) {
        if (UriUtil.hasScheme((CharSequence)tigerRoute.getFrom())) {
            return this.mockServer.addRoute(Expectation.buildForwardProxyRoute((TigerProxyRoute)tigerRoute, (TigerProxy)this));
        }
        return this.mockServer.addRoute(Expectation.buildReverseProxyRoute((TigerProxyRoute)tigerRoute, (TigerProxy)this));
    }

    public void addAlternativeName(String host) {
        if (StringUtils.isBlank((CharSequence)host)) {
            return;
        }
        ArrayList<String> newAlternativeNames = new ArrayList<String>();
        if (this.getTigerProxyConfiguration().getTls() != null && this.getTigerProxyConfiguration().getTls().getAlternativeNames() != null) {
            newAlternativeNames.addAll(this.getTigerProxyConfiguration().getTls().getAlternativeNames());
        }
        newAlternativeNames.add(host);
        Objects.requireNonNull(this.getTigerProxyConfiguration().getTls()).setAlternativeNames(newAlternativeNames);
        for (KeyAndCertificateFactory tlsFactory : this.tlsFactories) {
            if (!(tlsFactory instanceof DynamicKeyAndCertificateFactory)) continue;
            DynamicKeyAndCertificateFactory dynamicKeyAndCertificateFactory = (DynamicKeyAndCertificateFactory)tlsFactory;
            dynamicKeyAndCertificateFactory.addAlternativeName(host);
        }
    }

    public void removeRoute(String routeId) {
        if (!this.mockServer.isRunning()) {
            return;
        }
        TigerProxyRoute candidate = (TigerProxyRoute)this.tigerRouteMap.get(routeId);
        if (candidate != null && candidate.isInternalRoute()) {
            throw new TigerConfigurationException("Could not delete route with id '" + routeId + "': route is internal route!");
        }
        this.mockServer.removeExpectation(routeId);
        TigerProxyRoute route = (TigerProxyRoute)this.tigerRouteMap.remove(routeId);
        this.log.info("Deleted route {} (id {}). Current # expectations {}", new Object[]{route, routeId, this.mockServer.retrieveActiveExpectations().size()});
    }

    public SSLContext getConfiguredTigerProxySslContext() {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{this.buildTrustManagerForTigerProxy()}, null);
            SSLContext.setDefault(sslContext);
            return sslContext;
        }
        catch (Exception e) {
            throw new TigerProxyTrustManagerBuildingException("Error while configuring SSL Context for Tiger Proxy", e);
        }
    }

    public X509TrustManager buildTrustManagerForTigerProxy() {
        try {
            X509TrustManager defaultTrustManager = this.extractTrustManager(null);
            X509TrustManager customTrustManager = this.extractTrustManager(this.buildTruststore());
            return new /* Unavailable Anonymous Inner Class!! */;
        }
        catch (Exception e) {
            throw new TigerProxyTrustManagerBuildingException("Error while building TrustManager for Tiger Proxy", e);
        }
    }

    private X509TrustManager extractTrustManager(KeyStore keystore) throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keystore);
        return (X509TrustManager)Arrays.stream(trustManagerFactory.getTrustManagers()).filter(X509TrustManager.class::isInstance).findAny().orElseThrow(() -> new TigerProxyTrustManagerBuildingException("Error while configuring TrustManager for Tiger Proxy"));
    }

    public KeyStore buildTruststore() {
        try {
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(null);
            AtomicInteger certCounter = new AtomicInteger(0);
            this.storeCertificate(ks, this.serverRootCa, certCounter.getAndIncrement());
            Optional<TigerTlsConfiguration> tlsConfiguration = Optional.ofNullable(this.getTigerProxyConfiguration().getTls());
            if (tlsConfiguration.map(TigerTlsConfiguration::getServerIdentity).isPresent()) {
                this.storeCertificate(ks, (TigerPkiIdentity)tlsConfiguration.get().getServerIdentity(), certCounter.getAndIncrement());
            } else if (tlsConfiguration.map(TigerTlsConfiguration::getServerIdentities).isPresent()) {
                tlsConfiguration.map(TigerTlsConfiguration::getServerIdentities).stream().flatMap(Collection::stream).forEach(id -> this.storeCertificate(ks, (TigerPkiIdentity)id, certCounter.getAndIncrement()));
            }
            if (tlsConfiguration.map(TigerTlsConfiguration::getOcspSignerIdentity).isPresent()) {
                ks.setCertificateEntry("ocspSignerCert", tlsConfiguration.get().getOcspSignerIdentity().getCertificate());
            }
            return ks;
        }
        catch (Exception e) {
            throw new TigerProxyTrustManagerBuildingException("Error while building SSL-Context for Tiger Proxy", e);
        }
    }

    private void storeCertificate(KeyStore ks, TigerPkiIdentity identity, int counter) {
        ks.setCertificateEntry("caCert_" + counter, identity.getCertificate());
        int chainCertCtr = 0;
        for (X509Certificate chainCert : identity.getCertificateChain()) {
            ks.setCertificateEntry("chainCert_" + counter + "_" + chainCertCtr++, chainCert);
        }
    }

    public SSLContext buildSslContext() {
        try {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(this.buildTruststore());
            TrustManager[] trustManagers = tmf.getTrustManagers();
            SSLContext sslContext = SSLContext.getInstance("TLS", (Provider)new BouncyCastleJsseProvider());
            sslContext.init(null, trustManagers, null);
            return sslContext;
        }
        catch (RuntimeException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new TigerProxyTrustManagerBuildingException("Error while building SSL-Context for Tiger Proxy", e);
        }
    }

    private void outputForwardProxyConfigLogs(Optional<ProxyConfiguration> forwardProxyConfig) {
        if (forwardProxyConfig.isEmpty()) {
            this.log.info("Tigerproxy has NO forward proxy configured!");
        } else {
            ProxyConfiguration configNotEmpty = forwardProxyConfig.get();
            if (configNotEmpty.getUsername() == null) {
                this.log.atInfo().addArgument(() -> configNotEmpty.getType().toString().toLowerCase()).addArgument(() -> configNotEmpty.getProxyAddress().getAddress()).addArgument(() -> configNotEmpty.getProxyAddress().getPort()).log("Forward proxy is set to {}://{}:{}");
            } else {
                this.log.atInfo().addArgument(() -> configNotEmpty.getType().toString().toLowerCase()).addArgument(() -> configNotEmpty.getProxyAddress().getAddress()).addArgument(() -> configNotEmpty.getProxyAddress().getPort()).addArgument(() -> ((ProxyConfiguration)configNotEmpty).getUsername()).addArgument(() -> ((ProxyConfiguration)configNotEmpty).getPassword()).log("Forward proxy is set to {}://{}:{}@{}:{}");
            }
        }
    }

    public void propagateException(Throwable exception) {
        this.exceptionListeners.forEach(consumer -> consumer.accept(exception));
    }

    public void addNewExceptionConsumer(Consumer<Throwable> newConsumer) {
        this.exceptionListeners.add(newConsumer);
    }

    @Override
    @PreDestroy
    public void close() {
        String tigerProxyName = this.getName().orElse("");
        this.log.info("Shutting down Tiger-Proxy {}", (Object)tigerProxyName);
        this.remoteProxyClients.forEach(TigerRemoteProxyClient::close);
        this.mockServer.stop();
    }

    public Map<SocketAddress, TigerConnectionStatus> getOpenConnections() {
        return this.getOpenConnections(TigerConnectionStatus.OPEN_TCP);
    }

    public Map<SocketAddress, TigerConnectionStatus> getOpenConnections(TigerConnectionStatus status) {
        return this.mockServer.getOpenConnections().entrySet().stream().filter(entry -> ((TigerConnectionStatus)entry.getValue()).getValue() >= status.getValue()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public void waitForAllCurrentMessagesToBeParsed() {
        this.remoteProxyClients.forEach(TigerRemoteProxyClient::waitForAllParsingTasksToBeFinished);
        this.mockServer.waitForAllParsingTasksToBeFinished();
        if (!this.getRbelLogger().getMessageHistory().isEmpty()) {
            this.getRbelLogger().getRbelConverter().waitForAllCurrentMessagesToBeParsed();
        }
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TigerProxy)) {
            return false;
        }
        TigerProxy other = (TigerProxy)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List this$tlsFactories = this.tlsFactories;
        List other$tlsFactories = other.tlsFactories;
        if (this$tlsFactories == null ? other$tlsFactories != null : !((Object)this$tlsFactories).equals(other$tlsFactories)) {
            return false;
        }
        List this$exceptionListeners = this.exceptionListeners;
        List other$exceptionListeners = other.exceptionListeners;
        if (this$exceptionListeners == null ? other$exceptionListeners != null : !((Object)this$exceptionListeners).equals(other$exceptionListeners)) {
            return false;
        }
        MockServerToRbelConverter this$mockServerToRbelConverter = this.getMockServerToRbelConverter();
        MockServerToRbelConverter other$mockServerToRbelConverter = other.getMockServerToRbelConverter();
        if (this$mockServerToRbelConverter == null ? other$mockServerToRbelConverter != null : !this$mockServerToRbelConverter.equals(other$mockServerToRbelConverter)) {
            return false;
        }
        Map this$tigerRouteMap = this.tigerRouteMap;
        Map other$tigerRouteMap = other.tigerRouteMap;
        if (this$tigerRouteMap == null ? other$tigerRouteMap != null : !((Object)this$tigerRouteMap).equals(other$tigerRouteMap)) {
            return false;
        }
        List this$remoteProxyClients = this.remoteProxyClients;
        List other$remoteProxyClients = other.remoteProxyClients;
        if (this$remoteProxyClients == null ? other$remoteProxyClients != null : !((Object)this$remoteProxyClients).equals(other$remoteProxyClients)) {
            return false;
        }
        UUID this$healthEndpointRequestUuid = this.getHealthEndpointRequestUuid();
        UUID other$healthEndpointRequestUuid = other.getHealthEndpointRequestUuid();
        if (this$healthEndpointRequestUuid == null ? other$healthEndpointRequestUuid != null : !((Object)this$healthEndpointRequestUuid).equals(other$healthEndpointRequestUuid)) {
            return false;
        }
        MockServer this$mockServer = this.mockServer;
        MockServer other$mockServer = other.mockServer;
        if (this$mockServer == null ? other$mockServer != null : !this$mockServer.equals(other$mockServer)) {
            return false;
        }
        TigerPkiIdentity this$serverRootCa = this.serverRootCa;
        TigerPkiIdentity other$serverRootCa = other.serverRootCa;
        if (this$serverRootCa == null ? other$serverRootCa != null : !this$serverRootCa.equals(other$serverRootCa)) {
            return false;
        }
        TigerProxyPairingConverter this$pairingConverter = this.getPairingConverter();
        TigerProxyPairingConverter other$pairingConverter = other.getPairingConverter();
        return !(this$pairingConverter == null ? other$pairingConverter != null : !this$pairingConverter.equals(other$pairingConverter));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TigerProxy;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List $tlsFactories = this.tlsFactories;
        result = result * 59 + ($tlsFactories == null ? 43 : ((Object)$tlsFactories).hashCode());
        List $exceptionListeners = this.exceptionListeners;
        result = result * 59 + ($exceptionListeners == null ? 43 : ((Object)$exceptionListeners).hashCode());
        MockServerToRbelConverter $mockServerToRbelConverter = this.getMockServerToRbelConverter();
        result = result * 59 + ($mockServerToRbelConverter == null ? 43 : $mockServerToRbelConverter.hashCode());
        Map $tigerRouteMap = this.tigerRouteMap;
        result = result * 59 + ($tigerRouteMap == null ? 43 : ((Object)$tigerRouteMap).hashCode());
        List $remoteProxyClients = this.remoteProxyClients;
        result = result * 59 + ($remoteProxyClients == null ? 43 : ((Object)$remoteProxyClients).hashCode());
        UUID $healthEndpointRequestUuid = this.getHealthEndpointRequestUuid();
        result = result * 59 + ($healthEndpointRequestUuid == null ? 43 : ((Object)$healthEndpointRequestUuid).hashCode());
        MockServer $mockServer = this.mockServer;
        result = result * 59 + ($mockServer == null ? 43 : $mockServer.hashCode());
        TigerPkiIdentity $serverRootCa = this.serverRootCa;
        result = result * 59 + ($serverRootCa == null ? 43 : $serverRootCa.hashCode());
        TigerProxyPairingConverter $pairingConverter = this.getPairingConverter();
        result = result * 59 + ($pairingConverter == null ? 43 : $pairingConverter.hashCode());
        return result;
    }

    @Generated
    public MockServerToRbelConverter getMockServerToRbelConverter() {
        return this.mockServerToRbelConverter;
    }

    @Generated
    public UUID getHealthEndpointRequestUuid() {
        return this.healthEndpointRequestUuid;
    }

    @Generated
    public TigerProxyPairingConverter getPairingConverter() {
        return this.pairingConverter;
    }
}

