/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy;

import de.gematik.rbellogger.RbelConverter;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelMessageMetadata;
import de.gematik.rbellogger.data.core.RbelFacet;
import de.gematik.rbellogger.util.RbelSocketAddress;
import de.gematik.test.tiger.mockserver.model.Header;
import de.gematik.test.tiger.mockserver.model.HttpRequest;
import de.gematik.test.tiger.mockserver.model.HttpResponse;
import de.gematik.test.tiger.mockserver.model.SocketAddress;
import de.gematik.test.tiger.proxy.MockServerRequestFacet;
import de.gematik.test.tiger.proxy.MockServerResponseFacet;
import de.gematik.test.tiger.proxy.exceptions.TigerProxyParsingException;
import de.gematik.test.tiger.proxy.exceptions.TigerProxyRoutingException;
import de.gematik.test.tiger.proxy.exceptions.TigerRoutingErrorFacet;
import io.netty.channel.ChannelHandlerContext;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockServerToRbelConverter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MockServerToRbelConverter.class);
    private final RbelConverter rbelConverter;

    public CompletableFuture<RbelElement> convertResponse(HttpRequest request, HttpResponse response, String senderUrl, String receiverUrl, Optional<ZonedDateTime> timestamp, AtomicReference<String> previousMessageReference) {
        log.atTrace().addArgument((Object)response).addArgument((Object)response.getHeaders()).addArgument(() -> new String(response.getBody())).log("Converting response {}, headers {}, body {}");
        RbelElement responseRbelMessage = this.responseToRbelMessage(response, request);
        RbelMessageMetadata conversionMetadata = new RbelMessageMetadata().withSender(this.convertUri(senderUrl)).withReceiver((RbelSocketAddress)RbelSocketAddress.fromString((String)receiverUrl).orElse(null)).withPreviousMessage(request.getCorrespondingRbelMessage().getUuid()).withPairedMessage(request.getCorrespondingRbelMessage().getUuid()).withTransmissionTime((ZonedDateTime)timestamp.orElse(null)).withPreviousMessage(previousMessageReference.getAndSet(responseRbelMessage.getUuid()));
        return this.rbelConverter.parseMessageAsync(responseRbelMessage, conversionMetadata);
    }

    public CompletableFuture<RbelElement> convertRequest(HttpRequest request, String protocolAndHost, Optional<ZonedDateTime> timestamp, AtomicReference<String> previousMessageReference) {
        if (request.getCorrespondingRbelMessage() != null) {
            return CompletableFuture.completedFuture(request.getCorrespondingRbelMessage());
        }
        log.atTrace().addArgument(() -> ((HttpRequest)request).printLogLineDescription()).log("Converting request {}");
        RbelElement unparsedRbelMessage = this.requestToRbelMessage(request);
        RbelMessageMetadata conversionMetadata = new RbelMessageMetadata().withSender((RbelSocketAddress)RbelSocketAddress.fromString((String)request.getSenderAddress()).orElse(null)).withReceiver(this.convertUri(protocolAndHost)).withTransmissionTime((ZonedDateTime)timestamp.orElse(null)).withPreviousMessage(previousMessageReference.getAndSet(unparsedRbelMessage.getUuid()));
        CompletableFuture parseMessageFuture = this.rbelConverter.parseMessageAsync(unparsedRbelMessage, conversionMetadata);
        request.setParsedMessageFuture(parseMessageFuture);
        request.setCorrespondingRbelMessage(unparsedRbelMessage);
        return parseMessageFuture;
    }

    public RbelElement convertErrorResponse(HttpRequest request, String protocolAndHost, TigerProxyRoutingException routingException, AtomicReference<String> previousMessageReference) {
        RbelElement message = new RbelElement(new byte[0], null);
        message.addFacet((RbelFacet)new TigerRoutingErrorFacet(routingException));
        RbelMessageMetadata metaData = new RbelMessageMetadata().withSender(this.convertUri(protocolAndHost)).withReceiver((RbelSocketAddress)Optional.ofNullable(request).map(HttpRequest::getReceiverAddress).map(SocketAddress::toRbelHostname).orElse(null)).withPairedMessage((String)Optional.ofNullable(request).map(HttpRequest::getCorrespondingRbelMessage).map(RbelElement::getUuid).orElse(null)).withTransmissionTime(routingException.getTimestamp()).withPreviousMessage(previousMessageReference.getAndSet(message.getUuid()));
        return this.rbelConverter.parseMessage(message, metaData);
    }

    private RbelSocketAddress convertUri(String protocolAndHost) {
        if (protocolAndHost == null) {
            return null;
        }
        try {
            new URI(protocolAndHost);
            return RbelSocketAddress.generateFromUrl((String)protocolAndHost).orElse(null);
        }
        catch (URISyntaxException e) {
            throw new TigerProxyParsingException("Unable to parse hostname from '" + protocolAndHost + "'", (Exception)e);
        }
    }

    public RbelElement responseToRbelMessage(HttpResponse response, HttpRequest request) {
        byte[] httpMessage = this.responseToRawMessage(response);
        RbelElement result = RbelElement.builder().rawContent(httpMessage).build();
        result.addFacet((RbelFacet)new MockServerResponseFacet(request, response));
        return result;
    }

    public RbelElement requestToRbelMessage(HttpRequest request) {
        byte[] httpMessage = this.requestToRawMessage(request);
        RbelElement result = RbelElement.builder().rawContent(httpMessage).build();
        result.addFacet((RbelFacet)new MockServerRequestFacet(request));
        return result;
    }

    private byte[] requestToRawMessage(HttpRequest request) {
        byte[] httpRequestHeader = (request.getMethod() + " " + this.getRequestUrl(request) + " HTTP/1.1\r\n" + this.formatHeaderList(request.getHeaderList()) + "\r\n\r\n").getBytes();
        return Arrays.concatenate((byte[])httpRequestHeader, (byte[])request.getBody());
    }

    private byte[] responseToRawMessage(HttpResponse response) {
        byte[] httpResponseHeader = ("HTTP/1.1 " + response.getStatusCode() + " " + (response.getReasonPhrase() != null ? response.getReasonPhrase() : "") + "\r\n" + this.formatHeaderList(response.getHeaderList()) + "\r\n\r\n").getBytes(StandardCharsets.US_ASCII);
        return Arrays.concatenate((byte[])httpResponseHeader, (byte[])response.getBody());
    }

    private String formatHeaderList(List<Header> headerList) {
        return headerList.stream().map(h -> h.getValues().stream().map(value -> h.getName() + ": " + value).collect(Collectors.joining("\r\n"))).collect(Collectors.joining("\r\n"));
    }

    private String getRequestUrl(HttpRequest request) {
        StringJoiner pathToQueryJoiner = new StringJoiner("?");
        if (StringUtils.isEmpty((CharSequence)request.getPath())) {
            pathToQueryJoiner.add("/");
        } else {
            pathToQueryJoiner.add(request.getPath());
        }
        if (request.getQueryStringParameters() != null && request.getQueryStringParameters().getEntries() != null) {
            pathToQueryJoiner.add(request.getQueryStringParameters().getRawParameterString());
        }
        return pathToQueryJoiner.toString();
    }

    public BiConsumer<TigerProxyRoutingException, ChannelHandlerContext> exceptionCallback() {
        return (exception, channelHandlerContext) -> {
            try {
                this.convertErrorResponse(null, null, exception, new AtomicReference<Object>(null));
            }
            catch (Exception e) {
                log.error("Error while converting error response", (Throwable)e);
            }
        };
    }

    @ConstructorProperties(value={"rbelConverter"})
    @Generated
    public MockServerToRbelConverter(RbelConverter rbelConverter) {
        this.rbelConverter = rbelConverter;
    }
}

