/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy;

import de.gematik.rbellogger.RbelConverterPlugin;
import de.gematik.rbellogger.RbelLogger;
import de.gematik.rbellogger.configuration.RbelConfiguration;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelMessageMetadata;
import de.gematik.rbellogger.file.RbelFileWriter;
import de.gematik.rbellogger.initializers.RbelKeyFolderInitializer;
import de.gematik.rbellogger.key.RbelKey;
import de.gematik.rbellogger.util.IRbelMessageListener;
import de.gematik.test.tiger.common.data.config.tigerproxy.TigerFileSaveInfo;
import de.gematik.test.tiger.common.data.config.tigerproxy.TigerProxyConfiguration;
import de.gematik.test.tiger.common.pki.KeyMgr;
import de.gematik.test.tiger.proxy.ITigerProxy;
import de.gematik.test.tiger.proxy.TigerProxyRemoteTransmissionConversionPlugin;
import de.gematik.test.tiger.proxy.data.TigerProxyRoute;
import de.gematik.test.tiger.proxy.exceptions.TigerProxyStartupException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.Key;
import java.security.KeyPair;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import kong.unirest.core.GetRequest;
import kong.unirest.core.Unirest;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTigerProxy
implements ITigerProxy,
AutoCloseable {
    private static final String FIX_VAU_KEY = "-----BEGIN PRIVATE KEY-----\nMIGIAgEAMBQGByqGSM49AgEGCSskAwMCCAEBBwRtMGsCAQEEIAeOzpSQT8a/mQDM\n7Uxa9NzU++vFhbIFS2Nsw/djM73uoUQDQgAEIfr+3Iuh71R3mVooqXlPhjVd8wXx\n9Yr8iPh+kcZkNTongD49z2cL0wXzuSP5Fb/hGTidhpw1ZYKMib1CIjH59A==\n-----END PRIVATE KEY-----\n";
    private final List<IRbelMessageListener> rbelMessageListeners = new ArrayList();
    private final TigerProxyConfiguration tigerProxyConfiguration;
    private RbelLogger rbelLogger;
    private RbelFileWriter rbelFileWriter;
    private Optional<String> name;
    protected final Logger log;
    private boolean isShuttingDown = false;
    private ExecutorService executor = Executors.newCachedThreadPool(r -> {
        Thread t = Executors.defaultThreadFactory().newThread(r);
        t.setName("TigerProxy" + this.getName().map(n -> "-" + n).orElse("") + "-" + t.getId());
        return t;
    });
    private CompletableFuture<Void> fileParsingFuture;

    protected AbstractTigerProxy(TigerProxyConfiguration configuration) {
        this(configuration, null);
    }

    protected AbstractTigerProxy(TigerProxyConfiguration configuration, @Nullable RbelLogger rbelLogger) {
        String loggerName = StringUtils.isNotBlank((CharSequence)configuration.getName()) ? "(" + configuration.getName() + ")" : "";
        this.log = LoggerFactory.getLogger((String)(this.getClass().getName() + loggerName));
        this.name = Optional.ofNullable(configuration.getName());
        if (configuration.getTls() == null) {
            throw new TigerProxyStartupException("no TLS-configuration found!");
        }
        this.rbelLogger = rbelLogger == null ? this.buildRbelLoggerConfiguration(configuration).constructRbelLogger() : rbelLogger;
        this.rbelLogger.getRbelConverter().setName(this.proxyName());
        this.addTransmissionPluginToRbelIfNotPresentAlready();
        if (!configuration.isActivateRbelParsing()) {
            this.rbelLogger.getRbelConverter().deactivateRbelParsing();
        }
        this.addFixVauKey();
        this.initializeFileWriter();
        this.tigerProxyConfiguration = configuration;
        this.addNoteCriterions();
        if (configuration.getFileSaveInfo() != null && StringUtils.isNotEmpty((CharSequence)configuration.getFileSaveInfo().getSourceFile())) {
            this.readTrafficFromSourceFile(configuration.getFileSaveInfo().getSourceFile());
        } else {
            this.fileParsingFuture = CompletableFuture.completedFuture(null);
        }
    }

    private void addTransmissionPluginToRbelIfNotPresentAlready() {
        boolean noPluginAddedYet = this.rbelLogger.getRbelConverter().getConverterPlugins().stream().filter(TigerProxyRemoteTransmissionConversionPlugin.class::isInstance).map(TigerProxyRemoteTransmissionConversionPlugin.class::cast).filter(arg_0 -> this.isTigerProxyMatching(arg_0)).findAny().isEmpty();
        if (noPluginAddedYet) {
            this.rbelLogger.getRbelConverter().addConverter((RbelConverterPlugin)new TigerProxyRemoteTransmissionConversionPlugin(this));
        }
    }

    protected boolean isTigerProxyMatching(TigerProxyRemoteTransmissionConversionPlugin plugin) {
        return plugin.getTigerProxy() == this;
    }

    private void addNoteCriterions() {
        if (this.tigerProxyConfiguration.getNotes() == null) {
            return;
        }
        this.tigerProxyConfiguration.getNotes().forEach(note -> this.rbelLogger.getValueShader().addJexlNoteCriterion(note.getJexlCriterion(), note.getMessage()));
    }

    private void initializeFileWriter() {
        this.rbelFileWriter = new RbelFileWriter(this.rbelLogger.getRbelConverter());
    }

    private void readTrafficFromSourceFile(String sourceFile) {
        this.fileParsingFuture = CompletableFuture.runAsync(() -> this.readTrafficFromTgrFile(sourceFile)).exceptionally(e -> {
            this.log.error("Error while reading traffic from file '{}': {}", (Object)sourceFile, (Object)e.getMessage());
            throw new TigerProxyStartupException("Error while reading traffic from file '" + sourceFile + "'", e);
        });
    }

    public synchronized List<RbelElement> readTrafficFromTgrFile(String sourceFile) {
        this.log.info("Trying to read traffic from file '{}'...", (Object)sourceFile);
        try {
            String rbelFileContent = Files.readString(Path.of(sourceFile, new String[0]), StandardCharsets.UTF_8);
            List readElements = this.readTrafficFromString(rbelFileContent);
            this.log.info("Successfully read and parsed traffic from file '{}'!", (Object)sourceFile);
            return readElements;
        }
        catch (IOException | RuntimeException e) {
            throw new TigerProxyStartupException("Error while parsing traffic file '" + sourceFile + "'", (Throwable)e);
        }
    }

    public synchronized List<RbelElement> readTrafficFromString(String tgrFileContent) {
        return this.rbelFileWriter.convertFromRbelFile(tgrFileContent, Optional.ofNullable(this.getTigerProxyConfiguration().getFileSaveInfo()).map(TigerFileSaveInfo::getReadFilter).filter(StringUtils::isNotBlank));
    }

    private void addFixVauKey() {
        KeyPair keyPair = KeyMgr.readEcdsaKeypairFromPkcs8Pem((byte[])FIX_VAU_KEY.getBytes(StandardCharsets.UTF_8));
        RbelKey rbelPublicVauKey = RbelKey.builder().keyName("fixVauKey_public").key((Key)keyPair.getPublic()).precedence(0).build();
        RbelKey rbelPrivateVauKey = RbelKey.builder().keyName("fixVauKey_public").key((Key)keyPair.getPrivate()).precedence(0).matchingPublicKey(rbelPublicVauKey).build();
        this.rbelLogger.getRbelKeyManager().addKey(rbelPublicVauKey);
        this.rbelLogger.getRbelKeyManager().addKey(rbelPrivateVauKey);
    }

    private RbelConfiguration buildRbelLoggerConfiguration(TigerProxyConfiguration configuration) {
        RbelConfiguration rbelConfiguration = new RbelConfiguration();
        if (configuration.getKeyFolders() != null) {
            configuration.getKeyFolders().forEach(folder -> rbelConfiguration.addInitializer((Consumer)new RbelKeyFolderInitializer(folder)));
        }
        if (configuration.getActivateRbelParsingFor() != null) {
            configuration.getActivateRbelParsingFor().forEach(arg_0 -> ((RbelConfiguration)rbelConfiguration).activateConversionFor(arg_0));
        }
        this.initializeFileSaver(configuration);
        rbelConfiguration.setRbelBufferSizeInMb(configuration.getRbelBufferSizeInMb());
        rbelConfiguration.setSkipParsingWhenMessageLargerThanKb(configuration.getSkipParsingWhenMessageLargerThanKb());
        rbelConfiguration.setManageBuffer(true);
        return rbelConfiguration;
    }

    private void initializeFileSaver(TigerProxyConfiguration configuration) {
        if (configuration.getFileSaveInfo() != null && configuration.getFileSaveInfo().isWriteToFile()) {
            if (configuration.getFileSaveInfo().isClearFileOnBoot() && new File(configuration.getFileSaveInfo().getFilename()).exists()) {
                try {
                    FileUtils.delete((File)new File(configuration.getFileSaveInfo().getFilename()));
                }
                catch (IOException e) {
                    throw new TigerProxyStartupException("Error while deleting file on startup '" + configuration.getFileSaveInfo().getFilename() + "'");
                }
            }
            this.addRbelMessageListener(msg -> {
                String msgString = this.rbelFileWriter.convertToRbelFileString(msg);
                try {
                    FileUtils.writeStringToFile((File)new File(configuration.getFileSaveInfo().getFilename()), (String)msgString, (Charset)StandardCharsets.UTF_8, (boolean)true);
                }
                catch (IOException e) {
                    this.log.warn("Error while saving to file '" + configuration.getFileSaveInfo().getFilename() + "':", (Throwable)e);
                }
            });
        }
    }

    public List<RbelElement> getRbelMessagesList() {
        return this.rbelLogger.getMessageList();
    }

    public void addKey(String keyid, Key key) {
        this.rbelLogger.getRbelKeyManager().addKey(keyid, key, 110);
    }

    public void triggerListener(RbelElement element, RbelMessageMetadata metadata) {
        this.executor.submit(() -> this.rbelMessageListeners.forEach(listener -> listener.triggerNewReceivedMessage(element)));
    }

    public void addRbelMessageListener(IRbelMessageListener listener) {
        this.rbelMessageListeners.add(listener);
    }

    public void clearAllRoutes() {
        this.getRoutes().stream().filter(route -> !route.isInternalRoute()).map(TigerProxyRoute::getId).forEach(arg_0 -> ((AbstractTigerProxy)this).removeRoute(arg_0));
    }

    public void removeRbelMessageListener(IRbelMessageListener listener) {
        this.rbelMessageListeners.remove(listener);
    }

    protected void waitForRemoteTigerProxyToBeOnline(String url) {
        LocalDateTime pollingStart = LocalDateTime.now();
        while (!this.isShuttingDown && !this.isGivenTigerProxyHealthy(url)) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                this.log.debug("InterruptedException while waiting for remote-proxy '{}' to be healthy", (Object)url);
                Thread.currentThread().interrupt();
            }
            if (!pollingStart.plus(this.getTigerProxyConfiguration().getConnectionTimeoutInSeconds(), ChronoUnit.SECONDS).isBefore(LocalDateTime.now())) continue;
            throw new TigerProxyStartupException("Timeout while waiting for remote-proxy '" + url + "' to be healthy");
        }
        if (this.isShuttingDown) {
            this.log.warn("Aborting waitForRemoteTigerProxyToBeOnline at '{}'", (Object)url);
        }
    }

    private boolean isGivenTigerProxyHealthy(String url) {
        try {
            this.log.debug("Waiting for tiger-proxy at '{}' to be online...", (Object)url);
            Object statusUrl = url;
            if (this.getTigerProxyConfiguration().isRequireHealthyTrafficEndpoints()) {
                statusUrl = (String)statusUrl + "/actuator/health";
            }
            int status = ((GetRequest)Unirest.get((String)statusUrl).requestTimeout(this.getTigerProxyConfiguration().getConnectionTimeoutInSeconds() * 1000)).asEmpty().getStatus();
            this.log.trace("Tiger-proxy at '{}' is online! (status is {})", (Object)url, (Object)status);
            if (this.getTigerProxyConfiguration().isRequireHealthyTrafficEndpoints()) {
                return status == 200;
            }
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public String proxyName() {
        return this.name.orElse("");
    }

    public void clearAllMessages() {
        this.getRbelLogger().getRbelConverter().clearAllMessages();
    }

    public Deque<RbelElement> getRbelMessages() {
        return this.getRbelLogger().getMessageHistory();
    }

    public void ensureFileIsParsed() {
        try {
            this.fileParsingFuture.get();
        }
        catch (CancellationException | ExecutionException e) {
            throw new TigerProxyStartupException("Error while parsing tgr file", (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new TigerProxyStartupException("Error while parsing tgr file", (Throwable)e);
        }
    }

    public void addRemovedMessageUuidsHandler(Consumer<List<String>> handleRemovedMessageUuids) {
        this.rbelLogger.getRbelConverter().getKnownMessageUuids().addRemovedMessageUuidsHandler(handleRemovedMessageUuids);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractTigerProxy)) {
            return false;
        }
        AbstractTigerProxy other = (AbstractTigerProxy)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isShuttingDown() != other.isShuttingDown()) {
            return false;
        }
        List this$rbelMessageListeners = this.rbelMessageListeners;
        List other$rbelMessageListeners = other.rbelMessageListeners;
        if (this$rbelMessageListeners == null ? other$rbelMessageListeners != null : !((Object)this$rbelMessageListeners).equals(other$rbelMessageListeners)) {
            return false;
        }
        TigerProxyConfiguration this$tigerProxyConfiguration = this.getTigerProxyConfiguration();
        TigerProxyConfiguration other$tigerProxyConfiguration = other.getTigerProxyConfiguration();
        if (this$tigerProxyConfiguration == null ? other$tigerProxyConfiguration != null : !this$tigerProxyConfiguration.equals(other$tigerProxyConfiguration)) {
            return false;
        }
        RbelLogger this$rbelLogger = this.getRbelLogger();
        RbelLogger other$rbelLogger = other.getRbelLogger();
        if (this$rbelLogger == null ? other$rbelLogger != null : !this$rbelLogger.equals(other$rbelLogger)) {
            return false;
        }
        RbelFileWriter this$rbelFileWriter = this.getRbelFileWriter();
        RbelFileWriter other$rbelFileWriter = other.getRbelFileWriter();
        if (this$rbelFileWriter == null ? other$rbelFileWriter != null : !this$rbelFileWriter.equals(other$rbelFileWriter)) {
            return false;
        }
        Optional this$name = this.getName();
        Optional other$name = other.getName();
        if (this$name == null ? other$name != null : !((Object)this$name).equals(other$name)) {
            return false;
        }
        Logger this$log = this.getLog();
        Logger other$log = other.getLog();
        if (this$log == null ? other$log != null : !this$log.equals(other$log)) {
            return false;
        }
        ExecutorService this$executor = this.getExecutor();
        ExecutorService other$executor = other.getExecutor();
        if (this$executor == null ? other$executor != null : !this$executor.equals(other$executor)) {
            return false;
        }
        CompletableFuture this$fileParsingFuture = this.fileParsingFuture;
        CompletableFuture other$fileParsingFuture = other.fileParsingFuture;
        return !(this$fileParsingFuture == null ? other$fileParsingFuture != null : !this$fileParsingFuture.equals(other$fileParsingFuture));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractTigerProxy;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isShuttingDown() ? 79 : 97);
        List $rbelMessageListeners = this.rbelMessageListeners;
        result = result * 59 + ($rbelMessageListeners == null ? 43 : ((Object)$rbelMessageListeners).hashCode());
        TigerProxyConfiguration $tigerProxyConfiguration = this.getTigerProxyConfiguration();
        result = result * 59 + ($tigerProxyConfiguration == null ? 43 : $tigerProxyConfiguration.hashCode());
        RbelLogger $rbelLogger = this.getRbelLogger();
        result = result * 59 + ($rbelLogger == null ? 43 : $rbelLogger.hashCode());
        RbelFileWriter $rbelFileWriter = this.getRbelFileWriter();
        result = result * 59 + ($rbelFileWriter == null ? 43 : $rbelFileWriter.hashCode());
        Optional $name = this.getName();
        result = result * 59 + ($name == null ? 43 : ((Object)$name).hashCode());
        Logger $log = this.getLog();
        result = result * 59 + ($log == null ? 43 : $log.hashCode());
        ExecutorService $executor = this.getExecutor();
        result = result * 59 + ($executor == null ? 43 : $executor.hashCode());
        CompletableFuture $fileParsingFuture = this.fileParsingFuture;
        result = result * 59 + ($fileParsingFuture == null ? 43 : $fileParsingFuture.hashCode());
        return result;
    }

    @Generated
    public TigerProxyConfiguration getTigerProxyConfiguration() {
        return this.tigerProxyConfiguration;
    }

    @Generated
    public RbelLogger getRbelLogger() {
        return this.rbelLogger;
    }

    @Generated
    public RbelFileWriter getRbelFileWriter() {
        return this.rbelFileWriter;
    }

    @Generated
    public Optional<String> getName() {
        return this.name;
    }

    @Generated
    public Logger getLog() {
        return this.log;
    }

    @Generated
    public boolean isShuttingDown() {
        return this.isShuttingDown;
    }

    @Generated
    public ExecutorService getExecutor() {
        return this.executor;
    }

    @Generated
    private void setFileParsingFuture(CompletableFuture<Void> fileParsingFuture) {
        this.fileParsingFuture = fileParsingFuture;
    }
}

