/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.socket.tls;

import de.gematik.test.tiger.common.pki.TigerPkiIdentity;
import de.gematik.test.tiger.mockserver.configuration.MockServerConfiguration;
import de.gematik.test.tiger.mockserver.model.HttpProtocol;
import de.gematik.test.tiger.mockserver.socket.tls.KeyAlgorithmPreference;
import de.gematik.test.tiger.mockserver.socket.tls.KeyAndCertificateFactory;
import de.gematik.test.tiger.proxy.exceptions.TigerProxySslException;
import io.netty.handler.codec.http2.Http2SecurityUtil;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.security.PrivateKey;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javax.net.ssl.SSLException;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class NettySslContextFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NettySslContextFactory.class);
    private final MockServerConfiguration configuration;
    private final KeyAndCertificateFactory keyAndCertificateFactory;
    private final Map<Pair<HttpProtocol, String>, SslContext> clientSslContexts = new ConcurrentHashMap();
    private Pair<SslContext, TigerPkiIdentity> serverSslContextAndIdentity = null;
    private final boolean forServer;

    public NettySslContextFactory(MockServerConfiguration configuration, boolean forServer) {
        this.configuration = configuration;
        this.forServer = forServer;
        this.keyAndCertificateFactory = this.createKeyAndCertificateFactory();
        System.setProperty("https.protocols", configuration.tlsProtocols());
        configuration.nettySslContextFactoryCustomizer().accept(this);
    }

    public KeyAndCertificateFactory createKeyAndCertificateFactory() {
        if (this.forServer) {
            if (this.configuration.serverKeyAndCertificateFactory() == null) {
                throw new TigerProxySslException("No serverKeyAndCertificateFactory found!");
            }
            return this.configuration.serverKeyAndCertificateFactory();
        }
        if (this.configuration.clientKeyAndCertificateFactory() == null) {
            throw new TigerProxySslException("No clientKeyAndCertificateFactory found!");
        }
        return this.configuration.clientKeyAndCertificateFactory();
    }

    public synchronized SslContext createClientSslContext(Optional<HttpProtocol> protocol) {
        return this.createClientSslContext(protocol, null);
    }

    public synchronized SslContext createClientSslContext(Optional<HttpProtocol> protocol, String hostName) {
        return this.createClientSslContext(protocol.orElse(HttpProtocol.HTTP_1_1), hostName);
    }

    public synchronized SslContext createClientSslContext(HttpProtocol protocol, String hostName) {
        SslContext clientSslContext = (SslContext)this.clientSslContexts.get(Pair.of((Object)protocol, (Object)hostName));
        if (clientSslContext != null) {
            return clientSslContext;
        }
        return this.buildFreshClientSslContext(protocol, hostName);
    }

    private SslContext buildFreshClientSslContext(HttpProtocol protocol, String hostName) {
        try {
            TigerPkiIdentity clientIdentity = this.keyAndCertificateFactory.resolveIdentityForHostname(hostName, KeyAlgorithmPreference.MIXED);
            SslContextBuilder sslContextBuilder = SslContextBuilder.forClient().protocols(this.configuration.tlsProtocols().split(",")).keyManager(clientIdentity.getPrivateKey(), (Iterable)clientIdentity.buildChainWithCertificate());
            if (protocol == HttpProtocol.HTTP_2) {
                NettySslContextFactory.configureALPN((SslContextBuilder)sslContextBuilder);
            }
            sslContextBuilder.trustManager(InsecureTrustManagerFactory.INSTANCE);
            SslContext clientSslContext = this.buildClientSslContext((SslContextBuilder)this.configuration.sslClientContextBuilderCustomizer().apply(sslContextBuilder));
            this.clientSslContexts.put(Pair.of((Object)protocol, (Object)hostName), clientSslContext);
            return clientSslContext;
        }
        catch (Exception e) {
            throw new RuntimeException("Exception creating SSL context for client", e);
        }
    }

    private SslContext buildClientSslContext(SslContextBuilder builder) throws SSLException {
        if (this.configuration.clientSslContextBuilderFunction() == null) {
            return builder.build();
        }
        return (SslContext)this.configuration.clientSslContextBuilderFunction().apply(builder);
    }

    public synchronized Pair<SslContext, TigerPkiIdentity> createServerSslContext(String hostname, KeyAlgorithmPreference clientAlgorithmPreference) {
        KeyAlgorithmPreference algorithmPreference = KeyAlgorithmPreference.determineEffectivePreference((KeyAlgorithmPreference)clientAlgorithmPreference, (KeyAlgorithmPreference)this.configuration.keyAlgorithmPreference());
        if (this.serverSslContextAndIdentity != null && !this.configuration.rebuildServerTlsContext() && this.keyPreferenceMatches(algorithmPreference)) {
            log.info("Using existing server SSL context for {} with key-algorithm {}", (Object)hostname, (Object)((TigerPkiIdentity)this.serverSslContextAndIdentity.getValue()).getPrivateKey().getAlgorithm());
            return this.serverSslContextAndIdentity;
        }
        log.info("Creating new server SSL context for {}", (Object)hostname);
        try {
            TigerPkiIdentity serverIdentity = this.keyAndCertificateFactory.resolveIdentityForHostname(hostname, algorithmPreference);
            log.atInfo().addArgument(() -> serverIdentity.getPrivateKey().getAlgorithm()).addArgument(() -> serverIdentity.getCertificate().getSubjectX500Principal()).addArgument(() -> serverIdentity.getCertificate().getIssuerX500Principal()).log("Using {} Server Certificate '{}', issued by '{}'");
            SslContextBuilder sslContextBuilder = SslContextBuilder.forServer((PrivateKey)serverIdentity.getPrivateKey(), (Iterable)serverIdentity.buildChainWithCertificate()).protocols(this.configuration.tlsProtocols().split(",")).clientAuth(ClientAuth.OPTIONAL);
            NettySslContextFactory.configureALPN((SslContextBuilder)sslContextBuilder);
            sslContextBuilder.trustManager(InsecureTrustManagerFactory.INSTANCE);
            SslContext serverContext = ((SslContextBuilder)this.configuration.sslServerContextBuilderCustomizer().apply(sslContextBuilder)).build();
            this.serverSslContextAndIdentity = Pair.of((Object)serverContext, (Object)serverIdentity);
            this.configuration.rebuildServerTlsContext(false);
            return this.serverSslContextAndIdentity;
        }
        catch (RuntimeException | SSLException e) {
            log.error("Exception creating SSL context for server", (Throwable)e);
            throw new TigerProxySslException("exception creating SSL context for server", e);
        }
    }

    private boolean keyPreferenceMatches(KeyAlgorithmPreference algorithmPreference) {
        if (algorithmPreference == KeyAlgorithmPreference.MIXED || algorithmPreference == KeyAlgorithmPreference.UNKNOWN) {
            return true;
        }
        TigerPkiIdentity serverIdentity = (TigerPkiIdentity)this.serverSslContextAndIdentity.getValue();
        if (serverIdentity == null) {
            return false;
        }
        return algorithmPreference.matches(serverIdentity);
    }

    private static void configureALPN(SslContextBuilder sslContextBuilder) {
        Consumer<SslContextBuilder> configureALPN = contextBuilder -> contextBuilder.ciphers((Iterable)Http2SecurityUtil.CIPHERS, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE).applicationProtocolConfig(new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"http/1.1"}));
        if (SslProvider.isAlpnSupported((SslProvider)SslContext.defaultServerProvider())) {
            configureALPN.accept(sslContextBuilder.sslProvider(SslContext.defaultServerProvider()));
        } else if (SslProvider.isAlpnSupported((SslProvider)SslProvider.JDK)) {
            configureALPN.accept(sslContextBuilder.sslProvider(SslProvider.JDK));
        } else if (SslProvider.isAlpnSupported((SslProvider)SslProvider.OPENSSL)) {
            configureALPN.accept(sslContextBuilder.sslProvider(SslProvider.OPENSSL));
        }
    }
}

