/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.socket.tls;

import de.gematik.test.tiger.common.pki.TigerPkiIdentity;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Hashtable;
import lombok.Generated;
import org.bouncycastle.tls.ClientHello;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsExtensionsUtils;
import org.bouncycastle.tls.TlsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public enum KeyAlgorithmPreference {
    UNKNOWN,
    MIXED,
    RSA,
    ECC;

    @Generated
    private static final Logger log;
    private static final KeyAlgorithmPreference[][] KEY_ALGORITHM_PREFERENCES;

    public static KeyAlgorithmPreference determineKeyAlgorithmPreference(ByteBuf clientHelloByteBuf) {
        try {
            byte[] bb = new byte[clientHelloByteBuf.readableBytes()];
            clientHelloByteBuf.getBytes(0, bb);
            KeyAlgorithmPreference keyAlgorithmPreference = KeyAlgorithmPreference.determineKeyAlgorithmPreference((byte[])bb);
            return keyAlgorithmPreference;
        }
        catch (RuntimeException e) {
            log.error("Error determining key algorithm preference: " + e.getMessage(), (Throwable)e);
            KeyAlgorithmPreference keyAlgorithmPreference = UNKNOWN;
            return keyAlgorithmPreference;
        }
        finally {
            clientHelloByteBuf.resetReaderIndex();
        }
    }

    private static KeyAlgorithmPreference determineKeyAlgorithmPreference(byte[] clientHelloBytes) {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(clientHelloBytes);
            ClientHello clientHello = ClientHello.parse((ByteArrayInputStream)bis, null);
            KeyAlgorithmPreference fromSigAlgs = KeyAlgorithmPreference.getKeyAlgorithmFromSignatureAlgorithms((Hashtable)clientHello.getExtensions());
            KeyAlgorithmPreference fromCipherSuites = KeyAlgorithmPreference.getKeyAlgorithmFromCipherSuites((int[])clientHello.getCipherSuites());
            return KeyAlgorithmPreference.determineEffectivePreference((KeyAlgorithmPreference)fromSigAlgs, (KeyAlgorithmPreference)fromCipherSuites);
        }
        catch (IOException e) {
            log.warn("Error parsing ClientHello: " + e.getMessage(), (Throwable)e);
            return UNKNOWN;
        }
    }

    private static KeyAlgorithmPreference getKeyAlgorithmFromSignatureAlgorithms(Hashtable<Integer, byte[]> extensions) throws IOException {
        byte[] signatureAlgorithmsExtension;
        if (extensions != null && (signatureAlgorithmsExtension = extensions.get(13)) != null) {
            HashSet sigAlgs = new HashSet(TlsExtensionsUtils.getSignatureAlgorithmsExtension(extensions));
            boolean supportsRSA = false;
            boolean supportsECC = false;
            for (SignatureAndHashAlgorithm sigAlg : sigAlgs) {
                if (sigAlg.getSignature() == 1 || sigAlg.getSignature() == 9 || sigAlg.getSignature() == 10 || sigAlg.getSignature() == 11 || sigAlg.getSignature() == 4 || sigAlg.getSignature() == 5 || sigAlg.getSignature() == 6) {
                    supportsRSA = true;
                    continue;
                }
                if (sigAlg.getSignature() != 3 && sigAlg.getSignature() != 26 && sigAlg.getSignature() != 27 && sigAlg.getSignature() != 28) continue;
                supportsECC = true;
            }
            return KeyAlgorithmPreference.calculatePreference((boolean)supportsRSA, (boolean)supportsECC);
        }
        return UNKNOWN;
    }

    private static KeyAlgorithmPreference getKeyAlgorithmFromCipherSuites(int[] cipherSuites) {
        boolean supportsRSA = false;
        boolean supportsECC = false;
        block4: for (int cipherSuite : cipherSuites) {
            int keyExchangeAlgorithm = TlsUtils.getKeyExchangeAlgorithm((int)cipherSuite);
            switch (keyExchangeAlgorithm) {
                case 1: 
                case 2: 
                case 5: 
                case 6: 
                case 9: 
                case 10: {
                    supportsRSA = true;
                    continue block4;
                }
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    supportsECC = true;
                    continue block4;
                }
            }
        }
        return KeyAlgorithmPreference.calculatePreference((boolean)supportsRSA, (boolean)supportsECC);
    }

    private static KeyAlgorithmPreference calculatePreference(boolean supportsRSA, boolean supportsECC) {
        if (supportsRSA && supportsECC) {
            return MIXED;
        }
        if (supportsRSA) {
            return RSA;
        }
        if (supportsECC) {
            return ECC;
        }
        return UNKNOWN;
    }

    public static KeyAlgorithmPreference determineEffectivePreference(KeyAlgorithmPreference clientAlgorithmPreference, KeyAlgorithmPreference serverAlgorithmPreference) {
        return KEY_ALGORITHM_PREFERENCES[KeyAlgorithmPreference.getOrdinal((KeyAlgorithmPreference)clientAlgorithmPreference)][KeyAlgorithmPreference.getOrdinal((KeyAlgorithmPreference)serverAlgorithmPreference)];
    }

    private static int getOrdinal(KeyAlgorithmPreference clientAlgorithmPreference) {
        if (clientAlgorithmPreference == null) {
            return UNKNOWN.ordinal();
        }
        return clientAlgorithmPreference.ordinal();
    }

    public boolean matches(TigerPkiIdentity id) {
        String keyAlgorithm = id.findKeyAlgorithm().orElse(null);
        if ("RSA".equalsIgnoreCase(keyAlgorithm)) {
            return this != ECC;
        }
        if ("EC".equalsIgnoreCase(keyAlgorithm) || "ECDSA".equalsIgnoreCase(keyAlgorithm)) {
            return this != RSA;
        }
        return false;
    }

    static {
        log = LoggerFactory.getLogger(KeyAlgorithmPreference.class);
        KEY_ALGORITHM_PREFERENCES = new KeyAlgorithmPreference[][]{{UNKNOWN, MIXED, RSA, ECC}, {MIXED, MIXED, RSA, ECC}, {RSA, RSA, RSA, ECC}, {ECC, ECC, RSA, ECC}};
    }
}

