/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.netty.proxy.relay;

import de.gematik.test.tiger.mockserver.exception.ExceptionHandling;
import de.gematik.test.tiger.mockserver.netty.MockServer;
import de.gematik.test.tiger.mockserver.netty.unification.PortUnificationHandler;
import de.gematik.test.tiger.mockserver.socket.tls.SniHandler;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpstreamProxyRelayHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UpstreamProxyRelayHandler.class);
    private final Channel upstreamChannel;
    private final Channel downstreamChannel;
    private final MockServer server;

    public UpstreamProxyRelayHandler(MockServer server, Channel upstreamChannel, Channel downstreamChannel) {
        super(false);
        this.server = server;
        this.upstreamChannel = upstreamChannel;
        this.downstreamChannel = downstreamChannel;
    }

    public void channelActive(ChannelHandlerContext ctx) {
        ctx.read();
        ctx.write((Object)Unpooled.EMPTY_BUFFER);
    }

    public void channelRead0(ChannelHandlerContext ctx, FullHttpRequest request) {
        if (PortUnificationHandler.isSslEnabledDownstream((Channel)this.upstreamChannel) && this.downstreamChannel.pipeline().get(SslHandler.class) == null) {
            log.info("Adding SSL Handler in UpstreamProxyRelayHandler.channelRead0");
            this.downstreamChannel.pipeline().addFirst(new ChannelHandler[]{this.server.getClientSslContextFactory().createClientSslContext(SniHandler.getAlpnProtocol((ChannelHandlerContext)ctx)).newHandler(ctx.alloc())});
        }
        this.downstreamChannel.writeAndFlush((Object)request).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
            if (future.isSuccess()) {
                ctx.channel().read();
            } else {
                if (this.isNotSocketClosedException(future.cause())) {
                    log.error("exception while returning response for request \"{} {}\"", new Object[]{request.method(), request.uri(), future.cause()});
                }
                future.channel().close();
            }
        }));
    }

    private boolean isNotSocketClosedException(Throwable cause) {
        return !(cause instanceof ClosedChannelException) && !(cause instanceof ClosedSelectorException);
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        ExceptionHandling.closeOnFlush((Channel)this.downstreamChannel);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (ExceptionHandling.connectionClosedException((Throwable)cause)) {
            log.error("exception caught by upstream relay handler -> closing pipeline {}", (Object)ctx.channel(), (Object)cause);
        }
        ExceptionHandling.closeOnFlush((Channel)ctx.channel());
    }
}

